<?php
//Created by sharon - not using this anywhere

namespace App\Models\Auth;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Batch.
 */
class StudentExamAnswer extends Model
{

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'student_exam_answer';


    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['student_id', 'exam_id', 'qa_id', 'answer', 'correct', 'attempt'];

    public static function insertOrUpdate($data, $studentId = 0)
    {
        if (($studentId > 0) && (!empty($data))) {
            $examObj = StudentExamAnswer::where('exam_id', '=', $data['exam_id'])->where('student_id', '=', $studentId)->first();
            if (empty($examObj)) {
                $examObj = new StudentExamAnswer();
                $examObj->exam_id = $data['exam_id'];
                $examObj->student_id = $studentId;
            }
            $examObj->qa_id = $data['qa_id'];
            $examObj->answer = $data['answer'];
            $examObj->correct = $data['correct'];
            $examObj->attempt = $data['attempt'];
            $examObj->save();
        }
    }

}
