<?php

namespace App\Models\Auth\Traits\Method;

/**
 * Trait UserMethod.
 */
trait UserMethod
{
    /**
     * @return mixed
     */
    public function canChangeEmail()
    {
        return config('access.users.change_email');
    }

    /**
     * @return bool
     */
    public function canChangePassword()
    {
        return ! app('session')->has(config('access.socialite_session_name'));
    }

    /**
     * @param bool $size
     *
     * @return bool|\Illuminate\Contracts\Routing\UrlGenerator|mixed|string
     * @throws \Illuminate\Container\EntryNotFoundException
     */
    public function getPicture($size = false)
    {
        switch ($this->avatar_type) {
            case 'gravatar':
                if (! $size) {
                    $size = config('gravatar.default.size');
                }

                return url('assets/images/user.png');

            case 'storage':
                return url('storage/'.$this->avatar_location);
        }

        $social_avatar = $this->providers()->where('provider', $this->avatar_type)->first();
        if ($social_avatar && strlen($social_avatar->avatar)) {
            return $social_avatar->avatar;
        }

        return false;
    }

    /**
     * @param $provider
     *
     * @return bool
     */
    public function hasProvider($provider)
    {
        foreach ($this->providers as $p) {
            if ($p->provider == $provider) {
                return true;
            }
        }

        return false;
    }

    /**
     * @return mixed
     */
    public function isAdmin()
    {
        return $this->hasRole(config('access.users.admin_role'));
    }

    public function isAgent()
    {
        return $this->hasRole('agent');
    }

    public function isManager()
    {
        return $this->hasRole('manager');
    }

    public function isTrainer()
    {
        return $this->hasRole('trainer');
    }

    public function isStaff()
    {
        if($this->hasRole(config('access.users.admin_role')) || (!$this->hasRole('agent') && !$this->hasRole('trainer')  && !$this->hasRole('user'))) {
            return true;
        }
        return false;
    }

    /**
     * @return bool
     */
    public function isActive()
    {
        return $this->active;
    }

    /**
     * @return bool
     */
    public function isConfirmed()
    {
        return $this->confirmed;
    }

    /**
     * @return bool
     */
    public function isPending()
    {
        return config('access.users.requires_approval') && ! $this->confirmed;
    }
    
    
    public function sms($message, $sms_template_id) {
        if($this->dialcode == '233'){
            $numbers = [ $this->mobile ];
        }else{
            $numbers = [ $this->dialcode.$this->mobile ];
        }
        
        return send_sms($numbers, $message, $sms_template_id);
    }

    public function whatsapp($message, $hook,$customMessage = null) {
        $numbers = [ $this->whatsapp_dialcode.$this->whatsapp ];
        $userId = [$this->id];
        return send_whatsapp_message($numbers,$hook, $userId,$customMessage);
    }     
}
