<?php

namespace App\Models\Auth\Traits;

use App\Notifications\Frontend\Auth\UserNeedsPasswordReset;

/**
 * Class SendUserPasswordReset.
 */
trait SendUserPasswordReset
{
    /**
     * Send the password reset notification.
     *
     * @param string $token
     *
     * @return void
     */
    public function sendPasswordResetNotification($token)
    {
        try{
            //$this->notify(new UserNeedsPasswordReset($token));
            $email_message = __('strings.emails.auth.password_cause_of_email');
            $email_message .= "<p><a href ='".route('frontend.auth.password.reset.form', $token)."'>".__('buttons.emails.auth.reset_password')."</a></p>";
            $email_message .=__('strings.emails.auth.password_if_not_requested');
            user_notify($this,app_name().': '.__('strings.emails.auth.password_reset_subject'), $email_message);
        }catch (\Exception $e) {
            $message = $e->getMessage();
            \Log::debug("Mail Error: (Password reset noti.) ".$message);   
        }
    }
}
