<?php

namespace App\Models\Auth;

use Spatie\Permission\Traits\HasRoles;
use Illuminate\Notifications\Notifiable;
use App\Models\Auth\Traits\Scope\UserScope;
use App\Models\Auth\Traits\Method\UserMethod;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\Auth\Traits\SendUserPasswordReset;
use App\Models\Auth\Traits\Attribute\UserAttribute;
use Illuminate\Foundation\Auth\User as Authenticatable;
use App\Models\Auth\Traits\Relationship\UserRelationship;
use Illuminate\Database\Eloquent\Factories\HasFactory;

/**
 * Class User.
 */
class UserDetails extends Authenticatable
{
    use HasRoles,
        Notifiable,
        UserAttribute,
        UserMethod,
        UserRelationship,
        UserScope,
        HasFactory;

    protected $primaryKey = 'userid';

    protected $guarded = [];    

    
}
