<?php

namespace App\Models\Auth;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

/**
 * Class Course.
 */
class Webinar extends Model
{

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'webinar';


    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $guarded = [];

    protected static function booted()
    {
        static::creating(function ($webinar) {
            if (empty($webinar->public_slug)) {
                $webinar->public_slug = Str::uuid();
            }
        });
    }
}

