<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StaffWorkExp extends Model
{
    use HasFactory;

    protected $table = 'staff_work_exp'; // Table name
    public $timestamps = false;
    protected $fillable = [
        'staff_id',
        'company_name',
        'job_title',
        'job_descp',
        'from_date',
        'to_date',
        'relevant',
    ];

    // Relationship: Each work experience belongs to a staff member
    public function staff()
    {
        return $this->belongsTo(StaffDetails::class, 'staff_id', 'staff_id');
    }
}
