<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class UserDocuEsign extends Model
{
    protected $table = 'user_docu_esign';

    protected $fillable = [
        'user_id',
        'document_id',
        'user_name',
        'user_email',
        'send_request_id',
        'file_path',
        'title',
        'status',
        'signed_date',
        'response_data',
    ];

    protected $casts = [
        'response_data' => 'array',
    ];

    // Relationship to User (optional)
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
