<?php

namespace App\Notifications\Backend;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Support\HtmlString;

/**
 * Class UserAlert.
 */
class UserAlert extends Notification
{
    use Queueable;

    /**
     * @var
     */
    protected $subject;
    protected $message;
    protected $short_message;
    protected $attachments;
    /**
     * UserAlert constructor.
     *
     * 
     */
    public function __construct($subject, $message, $short_message="", $attachments = NULL)
    {
        $this->subject = $subject;
        $this->message = $message;
        $this->attachments = $attachments;
        $this->short_message = $short_message;
        \Log::debug("Creating UserAlert Mail. SUBJECT:".$subject);
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param mixed $notifiable
     *
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param mixed $notifiable
     *
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        //dd($this->attachments);
        // return (new MailMessage())
        //     ->subject($this->subject)
        //     ->replyTo(env('REPLY_TO_ADDRESS'))
        //     //->line($this->message);
        //     ->line(new HtmlString($this->message));



        // $att_string = $att_arr = "";
        // if (isset($this->attachments)) {
        //     $att_string = array();
        //      foreach ($this->attachments as $file) {
        //          $filename = $file->getClientOriginalName();
        //          $filename = microtime()."_".$filename;
        //          $filename = str_replace(" ", "-", $filename);
        //          $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
        //          if (strlen($filename) > 20) {
        //              $filename = substr($filename, 0, 20);
        //          }
        //          $file->storeAs('email_attachments/', $filename.".".$file->getClientOriginalExtension(), 'public');
        //          $att_string[] = $filename.".".$file->getClientOriginalExtension();
        //      }
        //      $att_arr = $att_string;
        //      $att_string = implode(",",$att_string);
        //  }
        
        if(config('mail.mailers.smtp.reply_to') != ''){
            $mailmessage = (new MailMessage)
            ->subject($this->subject)
            ->replyTo(config('mail.mailers.smtp.reply_to'))
            ->line(new HtmlString($this->message));
            if($this->attachments){
                foreach ($this->attachments as $file){
                    $mailmessage->attach(storage_path()."/app/public/email_attachments/".$file);
                }
            }
        }else{
            $mailmessage = (new MailMessage)
            ->subject($this->subject)
            ->line(new HtmlString($this->message));
            if($this->attachments){
                foreach ($this->attachments as $file){
                    $mailmessage->attach(storage_path()."/app/public/email_attachments/".$file);
                }
            }
        }
        return $mailmessage;
    }
}
