<?php
namespace App\Services;
class ExotelAPIService {

    public function make_exotel_call($agent_number,$client_number)
    {
        \Log::info("IN EXOTEL CALL:");
        \Log::info("Agent No.: ".$agent_number." Lead No.: ".$client_number);
        if(!get_site_config('exotel_api_key')){
            \Log::info("EXOTEL API KEY MISSING");
            return json_encode(['err'=>1,'msg'=>'Exotel API KEY missing!']);
        }
        if(!get_site_config('exotel_api_secret')){
            \Log::info("EXOTEL API KEY MISSING");
            return json_encode(['err'=>1,'msg'=>'Exotel API SECRET missing!']);
        }
        if(!get_site_config('exotel_sid')){
            \Log::info("EXOTEL ACCOUNT SID MISSING");
            return json_encode(['err'=>1,'msg'=>'Exotel Account SID missing!']);
        }
        if(!get_site_config('exotel_agent_number')){
            \Log::info("EXOTEL AGENT No. MISSING");
            return json_encode(['err'=>1,'msg'=>'Exotel Agent No. missing!']);
        }
        $post_data = array(
            'From' => '0'.$agent_number, 
            'To' => '0'.$client_number, 
            'CallerId' => get_site_config('exotel_agent_number'), 
            'CallType' => "trans"
        );
            $api_key = get_site_config('exotel_api_key');
            $api_token = get_site_config('exotel_api_secret');
            $exotel_sid = get_site_config('exotel_sid');
            $url = "https://".$api_key.":".$api_token."@api.exotel.com/v1/Accounts/".$exotel_sid."/Calls/connect.json"; 
            $ch = curl_init(); curl_setopt($ch, CURLOPT_VERBOSE, 1); 
            curl_setopt($ch, CURLOPT_URL, $url); 
            curl_setopt($ch, CURLOPT_POST, 1); 
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_FAILONERROR, 0); 
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
            \Log::info("URL: ".$url);
            $http_result = curl_exec($ch); 
            
            $response = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            \Log::info("EXOTEL Response :  " . $response);
            if($response == 200){
                return $http_result;
            }
            print "Response = ".print_r($http_result); 
    }

}