<?php

namespace App\Services;

use Illuminate\Http\Request;
use App\Models\UserActivity;
use App\Models\MailTemplates;
use App\Models\SMSTemplates;
use App\Notifications\Frontend\AdminAlert;
use App\Models\Auth\User;
use App\Models\Auth\UserDetails;
use Log;
use Illuminate\Support\Facades\DB;
use App\Notifications\Backend\UserAlert;

class LeadsService {

    public function create($data) {
        Log::debug("LEADSSERVICE: Create");
        $country_interested = "";
        $study_degree = ""; 

        if (!empty($data->date_of_birth)) {
            $dob = substr($data->date_of_birth, 6, 4) . "-" . substr($data->date_of_birth, 3, 2) . "-" . substr($data->date_of_birth, 0, 2);
        } else {
            $dob = NULL;
        }

        $dialcode = "";
        if(empty($data->dialcode)) {
            $dialcode = config('app.USER_DEFAULT_DIALCODE');
        }else{
            $dialcode = $data->dialcode;
        }

        $gender = "";
        if(empty($data->gender)) {
            $gender = 'male';
        }else{
            $gender = $data->gender;
        }

        $country = "";
        if(!empty($data->country)) {
            if($data->country == 'United States of America') {
                $data->country = 'USA';
            }elseif($data->country == 'United States America') {
                $data->country = 'USA';
            }elseif($data->country == 'United States') {
                $data->country = 'USA';
            }elseif($data->country == 'UAE') {
                $data->country = 'United Arab Emirates';
            }elseif($data->country == 'UK') {
                $data->country = 'United Kingdom';
            }
            $country = get_country_id_by_name($data->country);
        }

        $study_degree = NULL;
        if($data->study_level){
            $study_degree = get_study_level_degree_level($data->study_level);
        }

        $next_followup = "";
        // if(empty($data->next_followup)){
            $next_followup = date("Y-m-d H:i");
        // }else{
            // $next_followup = date("Y-m-d H:i", strtotime($data->next_followup));
        // }
        if (!empty($data->first_name)) {
            $generatedRefCode = generate_refcode($data->first_name);
        }else{
            $generatedRefCode = NULL;
        }

        $leaddetails = new User([
            'first_name' => $data->first_name,
            'last_name' => $data->last_name,
            'email' => $data->email,
            'dialcode' => $dialcode,
            'mobile' => $data->mobile,
            'whatsapp' => $data->whatsapp,
            'gender' => $gender,
            'birthday' => $dob,
            'country' => $country,
            'city' => $data->city,
            'country_interested' => $data->country_interested,
            'overseas_study_level' => $study_degree,
            'overseas_study_level_selection' => $data->study_level,
            'overseas_course_intersted' => $data->course_interested,
            'student_type' => 'study_abroad',
            'lead_status' => get_default_lead_status(),
            'confirmed' => 1,
            'next_followup' => $next_followup,
            'is_lead'   => 1,
            'lead_source' => $data->lead_source,
            'created_mode' => "api",
            'refcode' => $generatedRefCode,
        ]);
        $leaddetails->save();

        $success_msg = 'Lead added successfully';
        
        $userdetails = new UserDetails([
            'userid'    => $leaddetails->id,
            // 'user_data_js' => $attributes_json,
            'lead_campaign_name' => $data->lead_campaign_name,
            'lead_ad_name' => $data->lead_ad_name,
            'lead_form_name' => $data->lead_form_name,
            'lead_lead_id' => $data->lead_id,
            'lead_notes' => $data->note
        ]);
        $userdetails->save();

        //Notify admin
        \Log::debug("Notify Admin: (ADMIN MAIL - Lead Generated)");
        $msg_details = "New Lead Added.<br /><br />Name: " . $data->first_name . ' ' . $data->last_name . "<br />email: " . $data->email . "<br />Mobile: " . $data->dialcode . ' ' . $data->mobile . "<br />Gender: " . $data->gender . "<br />Lead Type: Study Abroad <br />Lead Source: $data->lead_source <br />Lead Campaign Name: $data->lead_campaign_name <br />Lead Ad Name: $data->lead_ad_name <br />Lead Form Name: $data->lead_form_name <br />Lead Id: $data->lead_lead_id <br />";
        
        $notify_emails = get_site_config('event_notification_email');
        if($notify_emails) {
            send_event_notification_email(explode(",", $notify_emails), "New Lead Added", $msg_details);
        } 

        $followup = new UserActivity;
        $followup->user_id = $leaddetails->id;
        $followup->type = 'others';
        // $followup->staff = \Auth::user()->id;
        $followup->detail = "LEAD CREATED";
        $followup->save();

        //Email to lead
        if (get_site_config('lead_welcome_email_lead_create')) {
            \Log::debug("Lead: sending welcome mail to lead");
            $mail_tpl = MailTemplates::find("LEAD_WELCOME");
            
            if ($mail_tpl && $mail_tpl->status) {
                $email_message = $mail_tpl->message;
                $full_name = $data->first_name . ' ' . $data->last_name;
                $email_message = str_ireplace("#sitename#", app_name(), $email_message);
                $email_message = str_ireplace("#siteurl#", url(''), $email_message);
                $email_message = str_ireplace("#first_name#", $data->first_name, $email_message);
                $email_message = str_ireplace("#full_name#", $full_name, $email_message);
                $email_message = str_ireplace("#email#", $data->email, $email_message);
                $email_message = str_ireplace("#mobile#", $dialcode . ' ' . $data->mobile, $email_message);
                // $email_message = str_ireplace("#password#", $data->password, $email_message);
                try {
                    //$leaddetails->notify(new UserAlert($mail_tpl->subject, $email_message));
                    user_notify($leaddetails,$mail_tpl->subject, $email_message);
                    \Log::debug("Lead: mail sent to user- " . $email_message);
                    // UserActivity::create(['user_id' => $leaddetails->id, 'type' => 'others', 'staff' => \Auth::user()->id, 'detail' => "Email Sent: Subject:" . $mail_tpl->subject . "<br>Message:" . $email_message]);
                    UserActivity::create(['user_id' => $leaddetails->id, 'type' => 'others', 'detail' => "Email Sent: Subject:" . $mail_tpl->subject . "<br>Message:" . $email_message]);
                } catch (\Exception $e) {
                    $message = $e->getMessage();
                    \Log::debug("Mail Error: (NEW LEAD) " . $message);
                }
            }

            $notify_sms = SMSTemplates::find("LEAD_WELCOME");
            if ($notify_sms && $notify_sms->status) {
                $full_name = $data->first_name . ' ' . $data->last_name;
                $notify_sms->message = str_replace("#sitename#", app_name(), $notify_sms->message);
                $notify_sms->message = str_replace("#siteurl#", url('/'), $notify_sms->message);
                $notify_sms->message = str_replace("#first_name#", $data->first_name, $notify_sms->message);
                $notify_sms->message = str_replace("#full_name#", $full_name, $notify_sms->message);
                // $notify_sms->message = str_replace("#password#", $request->get('password'), $notify_sms->message);
                \Log::debug("SMS Sending: (CONVERT LEAD)" . $notify_sms->message);
                $numbers = [ $leaddetails->dialcode.$leaddetails->mobile ];
                send_sms($numbers, $notify_sms->message, $notify_sms->template_id);
            }
        }

        return json_decode(json_encode($leaddetails), true);
    }

    public function update($data){
        Log::debug("LEADSSERVICE: Update");
        $leadupdate = User::where('email', $data->email)->first();
        if(!$leadupdate){
            $leadupdate = array();
            return $leadupdate;
        }

        if (!empty($data->first_name)) {
            $leadupdate->first_name = $data->first_name;
        }
        if (!empty($data->last_name)) {
            $leadupdate->last_name = $data->last_name;
        }
        
        if (!empty($data->country_interested)) {
            $leadupdate->country_interested = $data->country_interested;
        } 

        if (!empty($data->date_of_birth)) {
            $leadupdate->birthday = substr($data->date_of_birth, 6, 4) . "-" . substr($data->date_of_birth, 3, 2) . "-" . substr($data->date_of_birth, 0, 2);
        } 

        if(!empty($data->study_level)){
            $leadupdate->overseas_study_level = get_study_level_degree_level($data->study_level);
            $leadupdate->overseas_study_level_selection = $data->study_level;
        }

        if(!empty($data->dialcode)) {
            $leadupdate->dialcode = $data->dialcode;
        }

        if(!empty($data->mobile)) {
            $leadupdate->mobile = $data->mobile;
        }

        if(!empty($data->whatsapp)) {
            $leadupdate->whatsapp = $data->whatsapp;
        }

        if(!empty($data->gender)) {
            $leadupdate->gender = $data->gender;
        }

        $country = "";
        if(!empty($data->country)) {
            if($data->country == 'United States of America') {
                $data->country = 'USA';
            }elseif($data->country == 'United States America') {
                $data->country = 'USA';
            }elseif($data->country == 'United States') {
                $data->country = 'USA';
            }elseif($data->country == 'UAE') {
                $data->country = 'United Arab Emirates';
            }elseif($data->country == 'UK') {
                $data->country = 'United Kingdom';
            }
            $country = get_country_id_by_name($data->country);
        }else{
            $country = $leadupdate->country;
        }

        if(!empty($data->city)) {
            $leadupdate->city = $data->city;
        }

        if(!empty($data->course_interested)) {
            $leadupdate->overseas_course_intersted = $data->course_interested;
        }

        // $next_followup = "";
        // if(!empty($data->next_followup)){
        //     $next_followup = date("Y-m-d H:i", strtotime($data->next_followup));
        // }else{
            // $next_followup = $leadupdate->next_followup;
        // }

        $leadupdate->first_name = $data->first_name;
        //$leadupdate->last_name = $last_name;
        // $leadupdate->email = $data->email;
        // $leadupdate->dialcode = $dialcode;
        // $leadupdate->mobile = $mobile;
        // $leadupdate->whatsapp = $whatsapp;
        // $leadupdate->gender = $gender;
        // $leadupdate->birthday = $dob;
        // $leadupdate->country = $country;
        // $leadupdate->city = $city;
        // $leadupdate->country_interested = $leadupdate->country_interested;
        // $leadupdate->overseas_study_level = $study_degree;
        // $leadupdate->overseas_study_level_selection = $overseas_study_level_selection;
        // $leadupdate->overseas_course_intersted = $course_interested;
        $leadupdate->save();

        $user_details = UserDetails::where('userid', $leadupdate->id)->first();
        if(!empty($data->note)){
            $user_details->lead_notes = $data->lead_notes;
        }
        if(!empty($data->lead_campaign_name)){
            $user_details->lead_campaign_name = $data->lead_campaign_name;
        }
        if(!empty($data->lead_ad_name)){
            $user_details->lead_ad_name = $data->lead_ad_name;
        }
        if(!empty($data->lead_form_name)){
            $user_details->lead_form_name = $data->lead_form_name;
        }
        if(!empty($data->lead_lead_id)){
            $user_details->lead_lead_id = $data->lead_lead_id;
        }
       
        $user_details->save();

        $followup = new UserActivity;
        $followup->user_id = $leadupdate->id;
        $followup->type = 'others';
        // $followup->staff = \Auth::user()->id;
        $followup->detail = "LEAD UPDATED";
        $followup->save();

        return json_decode(json_encode($leadupdate), true);
    }
    
    public function fetchRecentLead(){
        Log::debug("LEADSSERVICE: Fetching....");
        $leads = User::select()->where('is_lead',1)->orderBy('created_at', 'desc')->limit(10)->get();
        return json_decode(json_encode($leads), true);
    }

}