<?php

namespace App\Services;

use GuzzleHttp\Client;
use Illuminate\Support\Facades\Log;

class OpenAIService
{
    protected $client;

    public function __construct()
    {
        $this->client = new Client([
            'base_uri' => 'https://api.openai.com/v1/', // Ensure the trailing slash is present
        ]);
    }

    public function rephraseMessage($message, $tone)
    {
        $apiKey = env('OPENAI_API_KEY');
        $toneDescription = "";
        if ($tone === "Professional") {
            $toneDescription = "Make the tone Professional and uplifting.";
        } elseif ($tone === "Neutral") {
            $toneDescription = "Keep the tone neutral and balanced.";
        } else {
            $toneDescription = "Please rephrase the message without specifying a tone.";
        }
        try {
            $response = $this->client->post('chat/completions', [
                'headers' => [
                    'Authorization' => 'Bearer ' . $apiKey,
                    'Content-Type' => 'application/json',
                ],
                'json' => [
                    'model' => 'gpt-3.5-turbo', // Or use 'gpt-4' if you're using GPT-4
                    'messages' => [
                        [
                            'role' => 'user',
                            'content' => "Rephrase the following message with a $toneDescription\n\n$message",
                        ]
                    ],
                    'temperature' => 0.7,
                    'max_tokens' => (int) env('OPENAI_API_MAX_TOKENS',300),
                ],
            ]);

            $responseBody = json_decode($response->getBody(), true);
            return $responseBody['choices'][0]['message']['content'] ?? 'Could not rephrase the message.';
        } catch (\Exception $e) {
            \Log::error("OpenAI API Error: " . $e->getMessage());
            return 'An error occurred while trying to rephrase the message.';
        }
    }
}
