<?php

namespace App\Services;
use Zadarma_API\Api;
class ZadarmaAPIService {

   public function make_zadarma_call($agent_number,$client_number)
    {
        \Log::info("IN ZADARMA CALL:");
        \Log::info("Calling from: ".$agent_number." Clients No.: ".$client_number);
        
        if(!get_site_config('zadarma_api_key')){
            \Log::info("ZADARMA API KEY MISSING");
            return json_encode(['err'=>1,'msg'=>'Zadarma API KEY missing!']);
        }
        if(!get_site_config('zadarma_api_secret')){
            \Log::info("ZADARMA API KEY MISSING");
            return json_encode(['err'=>1,'msg'=>'Zadarma API SECRET missing!']);
        }
        if($agent_number == ""){
            \Log::info("ZADARMA AGENT No. MISSING");
            return json_encode(['err'=>1,'msg'=>'Zadarma Agent No. missing!']);
        }
        // TODO: enter your values
        $sourceNumber = ''; // in international format
        $destinationNumber = $client_number; //'918109958566';
        $sip = ''; // sip number
        $pbx = $agent_number; //'+12264994004'; // internal number
        $callId = '';
        $destinationEmail = '';
        $api = new Api(get_site_config('zadarma_api_key'), get_site_config('zadarma_api_secret'), false);
        //$api = new \Zadarma_API\Api(get_site_config('zadarma_api_key'), get_site_config('zadarma_api_secret'), false);

            $call = $api->requestCallback($pbx, $destinationNumber);
            $response = [];
            
                $response['Call'] = [
                    'Status' => 'In Progress',
                    'To' => $call->to
                ];
            return $response;
    }
}