<?php

use App\Mail\MailSend;
use App\Models\Configs;
use App\Models\Auth\City;
use App\Models\Auth\User;
use App\Models\Auth\Posts;
use App\Models\Auth\Tags;
use App\Models\Auth\Course;
use App\Models\Auth\Ticket;
use App\Models\Auth\Invoice;
use App\Models\Auth\BusinessConfigs;
use App\Models\Auth\NotificationConfigs;
use App\Models\Auth\Services;
use App\Models\Auth\Country;
use App\Recipients\AdminRecipient;
use App\Notifications\Frontend\AdminAlert;
use App\Notifications\Backend\UserAlert;
use App\Models\Auth\ServiceApplications;
use App\Models\Auth\UserNotification;
use App\Models\Auth\Webinar;
use App\Models\StaffDetails;
use App\Models\Auth\StaffLeaves;
use App\Models\Auth\UserDetails;
use App\Helpers\General\Timezone;
use App\Models\Auth\AgentDetails;
use Illuminate\Support\Facades\DB;
use App\Helpers\General\HtmlHelper;
use Illuminate\Support\Facades\Mail;
use Spatie\Activitylog\Models\Activity;
use App\Models\Auth\UniversityApplication;
use Dacastro4\LaravelGmail\Services\Message\Mail as Gmail;

if (!function_exists('send_sms')) {

    function send_sms($numbers, $message, $sms_template_id)
    {
        \Log::debug("IN SEND_SMS TO:".implode(",", $numbers)." TPL:".$sms_template_id." MSG:".$message);
        if (count($numbers) && !empty($message)) {

            if (app()->environment('production') && get_site_config('sms_enabled')) {

                if (get_site_config('sms_provider') == 'Twilio') {

                    $TWILIO_ACCOUNT_SID = get_site_config('sms_senderid');
                    $TWILIO_AUTH_TOKEN = get_site_config('sms_auth_token');
                    $TWILIO_PHONE = get_site_config('sms_from_phone');
                    $TWILIO_PHONE = get_site_config('sms_from_phone');
                    $url = "https://api.twilio.com/2010-04-01/Accounts/$TWILIO_ACCOUNT_SID/Messages.json";

                    $from = $TWILIO_PHONE;

                    foreach ($numbers as $to) {
                        $to = trim($to);
                        if ($to) {
                            $to = "+".$to;
                            \Log::debug("++++Twilio: SEND SMS TO: " . $to);

                            $data = array(
                                'From' => $from,
                                'To' => $to,
                                'Body' => $message,
                            );
                            $post = http_build_query($data);
                            $ch = curl_init($url);
                            curl_setopt($ch, CURLOPT_POST, true);
                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                            curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
                            curl_setopt($ch, CURLOPT_USERPWD, "$TWILIO_ACCOUNT_SID:$TWILIO_AUTH_TOKEN");
                            curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
                            $resp = curl_exec($ch);
                            curl_close($ch);
                            \Log::debug("SMS Response :  " . $resp);
                            $json_response = json_decode($resp, true);
                            if($json_response){
                                $code = $json_response['code'];
                                if($code == "20003"){
                                    return false;
                                }
                            }
                        }
                    }

                    return true;

                } elseif (get_site_config('sms_provider') == 'Textlocal') {

                    $to = "";
                    foreach ($numbers as $num) {
                        $to .= "," . $num;
                    }
                    $to = trim($to, ",");
                    \Log::debug("++++Textlocal: SEND SMS TO: " . $to);
                    if ($to) {

                        $SENDER = get_site_config('sms_senderid');
                        $API_KEY = get_site_config('sms_auth_token');
                        $url = env('SMS_TEXTLOCAL_URL', "https://api.textlocal.in/send/");

                        $data = array(
                            'apikey' => $API_KEY,
                            'numbers' => $to,
                            'sender' => $SENDER,
                            'message' => $message,
                        );
                        $post = http_build_query($data);
                        $ch = curl_init($url);
                        curl_setopt($ch, CURLOPT_POST, true);
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
                        $resp = curl_exec($ch);
                        curl_close($ch);
                        \Log::debug("SMS Response :  " . $resp);
                        $json_response = json_decode($resp, true);
                        if($json_response){
                            $message = $json_response['errors']['0']['message'];
                            if($message == "Invalid login details"){
                                return false;
                            }
                        }
                        return true;
                    }

                } elseif (get_site_config('sms_provider') == 'Msg91') {

                    foreach ($numbers as $to) {
                        \Log::debug("++++Msg91: SEND SMS TO: " . $to);
                        if ($to) {

                            $SENDER = get_site_config('sms_senderid');
                            $AUTH_KEY = get_site_config('sms_auth_token');
                            $FLOW_ID = get_site_config('sms_flow_id');

                            $curl = curl_init();

                            // curl_setopt_array($curl, [
                            //     CURLOPT_URL => "https://api.msg91.com/api/v5/flow/",
                            //     CURLOPT_RETURNTRANSFER => true,
                            //     CURLOPT_ENCODING => "",
                            //     CURLOPT_MAXREDIRS => 10,
                            //     CURLOPT_TIMEOUT => 30,
                            //     CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                            //     CURLOPT_CUSTOMREQUEST => "POST",
                            //     CURLOPT_POSTFIELDS => "{\n  \"flow_id\": \"$FLOW_ID\",\n  \"sender\": \"$SENDER\",\n  \"mobiles\": \"$to\"\n}",
                            //     CURLOPT_HTTPHEADER => [
                            //         "authkey: $AUTH_KEY",
                            //         "content-type: application/json"
                            //     ],
                            // ]);

                            curl_setopt_array($curl, [
                                CURLOPT_URL => "https://control.msg91.com/api/v5/flow",
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_ENCODING => "",
                                CURLOPT_MAXREDIRS => 10,
                                CURLOPT_TIMEOUT => 30,
                                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                CURLOPT_CUSTOMREQUEST => "POST",
                                CURLOPT_POSTFIELDS => json_encode([
                                    "template_id" => $sms_template_id,
                                    "short_url" => "0",
                                    "short_url_expiry" => "",
                                    "realTimeResponse" => "1",
                                    "recipients" => [
                                        [
                                            "mobiles" => $to,
                                            "VAR1" => "Gourav",
                                            "VAR2" => "06-09-2025 12:00pm"
                                        ]
                                    ]
                                ]),
                                CURLOPT_HTTPHEADER => [
                                    "accept: application/json",
                                    "authkey: $AUTH_KEY",
                                    "content-type: application/json"
                                ],
                            ]);

                            $response = curl_exec($curl);
                            $err = curl_error($curl);

                            curl_close($curl);

                            if ($err) {
                                echo "cURL Error #:" . $err;
                            } else {
                                echo $response;
                            }


                            $response = curl_exec($curl);
                            $err = curl_error($curl);
                            curl_close($curl);
                            if ($err) {
                                \Log::error("cURL Error #:" . $err);
                            } else {
                                $json_response = json_decode($response, true);
                                if($json_response){
                                    $message = $json_response['type'];
                                    if($message == "error"){
                                        return false;
                                    }
                                }
                                \Log::debug("SMS Response :  " . $response);
                            }
                        }
                    }
                    return true;

                } elseif (get_site_config('sms_provider') == 'Gupshup') {
                    $to = "";
                    foreach ($numbers as $num) {
                        $to .= "," . $num;
                    }
                    $to = trim($to, ",");
                    \Log::debug("++++Gupshup: SEND SMS TO: " . $to);

                    if ($to) {
                        $userid = get_site_config('sms_senderid');
                        $password = get_site_config('sms_auth_token');
                        $message = urlencode($message);

                        $url = "https://enterprise.smsgupshup.com/GatewayAPI/rest?method=SendMessage&send_to=$to&msg=$message&msg_type=TEXT&userid=$userid&auth_scheme=plain&password=$password&v=1.1&format=text";
                        $ch = curl_init($url);
                        //curl_setopt($ch, CURLOPT_URL, $url);
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                        $response = curl_exec($ch);
                        curl_close($ch);
                        \Log::debug("SMS Response :  " . $response);
                        
                        // $json_response = json_decode($response, true);
                        
                        //     if($json_response){
                        //         dd($json_response);
                        //             $message = $json_response['type'];
                        //             if($message == "error"){
                        //                 return false;
                        //             }
                        //     }
                        return true;
                    }

                } elseif (get_site_config('sms_provider') == 'Voodoo') {
                    $from = get_site_config('sms_senderid');                    
                    $api_key = get_site_config('sms_auth_token');
                    $to = "";
                    foreach ($numbers as $num) {
                        $to .= "," . $num;
                    }
                    $to = trim($to, ",");
                    \Log::debug("++++Voodoo: SEND SMS TO: " . $to);

                    if ($to) {
                        $msg = json_encode(
                            [
                                'to' => $to,
                                'from' => $from,
                                'msg' => $message,
                            ]
                        );
                        $ch = curl_init('https://api.voodoosms.com/sendsms');
                        curl_setopt($ch, CURLOPT_POST, true);
                        curl_setopt($ch, CURLOPT_HTTPHEADER, [
                            'Authorization: ' . $api_key
                        ]);
                        curl_setopt($ch, CURLOPT_POSTFIELDS, $msg);
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                        
                        $response = curl_exec($ch);
                        \Log::debug("SMS Response :  " . $response);
                        
                        curl_close($ch);
                        $json_response = json_decode($response, true);
                        if($json_response){
                            $error = $json_response['error'];
                            if($error){
                                return false;
                            }
                        }
                        return true;
                    }            

                } elseif (get_site_config('sms_provider') == 'Fast2sms') {

                    $to = "";
                    foreach ($numbers as $num) {
                        $to .= "," . $num;
                    }
                    $to = trim($to, ",");
                    \Log::debug("++++Fast2sms: SEND SMS TO: " . $to);

                    if ($to) {
                        $senderid = get_site_config('sms_senderid');
                        $api_key = get_site_config('sms_auth_token');
                        $message = urlencode($message);

                        $url = "https://www.fast2sms.com/dev/bulkV2?authorization=$api_key&sender_id=$senderid&message=$message&route=v3&numbers=$to";
                        $ch = curl_init();
                        curl_setopt($ch, CURLOPT_URL, $url);
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                        $response = curl_exec($ch);
                        curl_close($ch);
                        \Log::debug("SMS Response :  " . $response);
                        $json_response = json_decode($response, true);
                        if($json_response){
                            $error = $json_response['return'];
                            if($error == false){
                                return false;
                            }
                        }
                        return true;
                    }
                } else {

                    $api_url = get_site_config('sms_api_url');
                    $message = urlencode($message);

                    if (env('SMS_OTHER_SEND_TO_MULTIPLE')) {
                        $to = "";
                        foreach ($numbers as $num) {
                            $to .= "," . $num;
                        }
                        $to = trim($to, ",");
                        \Log::debug("++++Other: SEND SMS TO: " . $to);

                        if ($to) {
                            // $method = "GET";
                            // $opts = array(
                            //     'http' => array(
                            //         'method' => "$method",
                            //         'content' => "",
                            //         'header' => "Accept-language: en\r\n" .
                            //         "Cookie: foo=bar\r\n"
                            //     )
                            // );
                            // $context = stream_context_create($opts);
                            $url = str_replace('{numbers}', $to, $api_url);
                            $url = str_replace('{message}', $message, $url);
                            \Log::info("URL: " . $url);
                            $ch = curl_init();
                            curl_setopt($ch, CURLOPT_URL, $url);
                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                            $response = curl_exec($ch);
                            curl_close($ch);
                            \Log::info("SMS Response :  " . $response);
                            return true;
                        }
                    } else {
                        foreach ($numbers as $to) {
                            \Log::info("++++Other: SEND SMS TO: " . $to . " MSG: " . $message);
                            $url = str_replace('{numbers}', $to, $api_url);
                            $url = str_replace('{message}', $message, $url);
                            \Log::info("URL: " . $url);
                            $ch = curl_init();
                            curl_setopt($ch, CURLOPT_URL, $url);
                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                            $response = curl_exec($ch);
                            curl_close($ch);
                            \Log::info("SMS Response :  " . $response);
                        }
                        return true;
                    }
                }
            } else {
                \Log::debug("Local ENV. or SMS disabled - Not Sending SMS");
                return false;
            }
        } else {
            \Log::debug("Empty Numbers or Message");
            return false;
        }
        return false;
    }
}


if (!function_exists('send_whatsapp_message')) {

    function send_whatsapp_message($numbers, $hook = '', $userId = '', $customMessage = []) {
        // dd($customMessage);
        // dd($hook);
        \Log::debug("Send Whatsapp Message()");

        $template = get_whatsapp_template($hook); 
        if (!$template || !$template->status) {
            \Log::debug("WhatsApp template not found or inactive for hook: {$hook}");
            return false;
        }

        $userinfo = User::where('id', $userId)->first();
        if(!$userinfo){
            \Log::error("User Not Found! User Id:" . $userId);
            return false;
        }



        $commonParams    = []; 
        $whatsappCloudParams  = []; 
        $aisensyParams   = []; 

        preg_match_all('/{{(\S+)}}/', $template->message, $matches);

        foreach ($matches[1] as $vars) {
            $value = null;
            $parameter_name = null;

            switch ($vars) {
                case "first_name":
                    $value = $userinfo ? $userinfo->first_name : '';
                    $parameter_name = 'first_name';
                    break;

                case "full_name":
                    $value = $userinfo ? trim($userinfo->first_name . ' ' . $userinfo->last_name) : '';
                    $parameter_name = 'full_name';
                    break;

                case "sitename":
                    $value = app_name();
                    $parameter_name = 'sitename';
                    break;

                case "siteurl":
                    $value = url('/');
                    $parameter_name = 'siteurl';
                    break;

                default:
                    if (isset($customMessage[$vars])) {
                        $parameter_name = $vars;
                        $value = $customMessage[$vars];
                    }
                    break;
            }

            if (!is_null($value)) {
                $commonParams[] = [
                    "type"           => "text",
                    "parameter_name" => $parameter_name,
                    "text"           => $value
                ];

                $whatsappCloudParams[] = [
                    "type" => "text",
                    "parameter_name" => $parameter_name,
                    "text" => $value
                ];

                $aisensyParams[] = [
                    "text" => $value
                ];

            }
        }

        // $whtsp_msg = json_encode($msg);
        

        \Log::debug("IN SEND_WHATSAPP TO:".implode(",", $numbers)." HOOK:".$hook." MSG:". var_export($commonParams));

        if (!app()->environment('production') || !get_site_config('whatsapp_enabled')) {
            \Log::debug("Local ENV. or WhatsApp disabled - Not Sending Whatsapp");
            return false;
        }

        // Clean numbers
        $to = "";
        foreach ($numbers as $num) {
            if(strlen($num) > 7) {
                $to .= "," . $num;
            }
        }
        $to = trim($to, ",");

        if (!strlen($to)) return false;

        $recipients = array_filter($numbers, fn($num) => strlen($num) > 7);

        // === WATI ===
        foreach ($recipients as $mobile) {
            if (get_site_config('whatsapp_provider') == 'wati') {
                $token = "Bearer " . get_site_config('wati_token');
                $api = get_site_config('wati_api_endpoint').'/api/v1/sendTemplateMessage?whatsappNumber={mobile}';
                $url = str_replace('{mobile}', $to, $api);

                $payload = [
                    "parameters"     => $commonParams,
                    "template_name"  => $hook,
                    "broadcast_name" => "system"
                ];

                $curl = curl_init();
                curl_setopt_array($curl, [
                    CURLOPT_URL => $url,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_CUSTOMREQUEST => "POST",
                    CURLOPT_POSTFIELDS => json_encode($payload),
                    CURLOPT_HTTPHEADER => [
                        "Authorization: $token",
                        "content-type: application/json"
                    ],
                ]);
                $response = curl_exec($curl);
                $err = curl_error($curl);
                curl_close($curl);

                if ($err) {
                    \Log::debug("WHATSAPP[WATI] Error: ".$err);
                    return false;
                } else {
                    \Log::debug("WHATSAPP[WATI] Response: ".$response);
                    return true;
                }
            }

            // === AiSensy ===
            elseif (get_site_config('whatsapp_provider') == 'aisensy') {
                
                $apiKey = get_site_config('aisensy_api_key');  
                $payload = [
                    "apiKey"        => $apiKey,
                    "campaignName"  => $hook,
                    "userName"      => $mobile,
                    "destination"   => $mobile,
                    "templateParams"=> array_map(fn($p) => $p['text'], $aisensyParams)
                ];

                $ch = curl_init("https://backend.aisensy.com/campaign/t1/api");
                curl_setopt_array($ch, [
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_CUSTOMREQUEST  => "POST",
                    CURLOPT_POSTFIELDS     => json_encode($payload),
                    CURLOPT_HTTPHEADER     => ["Content-Type: application/json"],
                ]);

                $response = curl_exec($ch);
                $error    = curl_error($ch);
                curl_close($ch);

                if ($error) {
                    \Log::error("AiSensy cURL Error: ".$error);
                    return false;
                } else {
                    \Log::info("AiSensy Response: ".$response);
                    return true;
                }
            }

            // === META Cloud API ===
            elseif (get_site_config('whatsapp_provider') == 'whatsapp_cloud_api') {
                \Log::debug("------Using Whatsapp Cloud API()-----");
                $token = get_site_config('whatsapp_cloud_access_token');
                $phone_number_id = get_site_config('whatsapp_phone_number_id'); 
                $url = "https://graph.facebook.com/v23.0/{$phone_number_id}/messages";

                $parametersValue = $whatsappCloudParams; 

                $headerComponents = [];
                if (!empty($template->media_type) && !empty($template->media_file)) {
                    $mediaUrl = asset('storage/'.$template->media_file);
                    Log::debug('---------Media  URL is-------'. $mediaUrl);

                    switch ($template->media_type) {
                        case 'image':
                            $headerComponents[] = [
                                "type" => "image",
                                "image" => ["link" => $mediaUrl]
                            ];
                            break;
                        case 'video':
                            $headerComponents[] = [
                                "type" => "video",
                                "video" => ["link" => $mediaUrl]
                            ];
                            break;
                        case 'document':
                            $headerComponents[] = [
                                "type" => "document",
                                "document" => ["link" => $mediaUrl]
                            ];
                            break;
                    }
                }

                $components = [];
                if (!empty($headerComponents)) {
                    $components[] = [
                        "type" => "header",
                        "parameters" => $headerComponents
                    ];
                }

                $components[] = [
                    "type" => "body",
                    "parameters" => $parametersValue
                ];

                $payload = [
                    "messaging_product" => "whatsapp",
                    "recipient_type" => "individual",
                    "to" => $to,
                    "type" => "template",
                    "template" => [
                        "name" => $hook,
                        "language" => ["code" => "en"],
                        "components" => $components
                    ]
                ];

                \Log::debug("Whatsapp Meta Payload Log: " . var_export($payload,true));

                $curl = curl_init();
                curl_setopt_array($curl, [
                    CURLOPT_URL => $url,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 30,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => "POST",
                    CURLOPT_POSTFIELDS => json_encode($payload),
                    CURLOPT_HTTPHEADER => [
                        "Authorization: Bearer ".$token,
                        "Content-Type: application/json"
                    ],
                ]);
                $response = curl_exec($curl);
                $err = curl_error($curl);
                curl_close($curl);

                if ($err) {
                    \Log::debug("WHATSAPP[META] Error: " . $err);
                    return false;
                } else {
                    \Log::debug("WHATSAPP[META] Response: " . $response);
                    return true;
                }
            }
        }

        return false;
    }
}

if (!function_exists('get_course_suggest_levels')) {

    function get_course_suggest_levels()
    {
        return ["Pre-bachelors", "Undergraduate", "Postgraduate", "PhD", "Others"];
    }
}


if (!function_exists('get_course_title_by_id')) {

    function get_course_title_by_id($course_id)
    {
        $rtr = DB::table('university_courses')->where('id',$course_id)->first();
        if($rtr){
            return $rtr->course_name;
        }
        else{
            return "-";
        }
    }
}

// if (!function_exists('get_course_suggest_levels')) {

//     function get_course_suggest_levels()
//     {
//         return ["Master", "Bachelor", "Others"];
//     }
// }

if (!function_exists('get_course_suggest_intake')) {

    function get_course_suggest_intake()
    {
        return ["Summer", "Winter", "July", "November"];
    }
}

if (!function_exists('get_course_suggest_years')) {

    function get_course_suggest_years()
    {
        $ret = array();
        for ($i = date("Y", strtotime("this year")); $i <= date("Y", strtotime("+2 years")); $i++) {
            $ret[] = $i;
        }
        return $ret;
    }
}

if (!function_exists('get_intakes')) {

    function get_intakes($country,$user)
    {
        $data = DB::table('course_preference')->select(DB::raw("CONCAT(intake,' ',intake_year) as intakes"))->where("country", $country)->where("userid", $user)->get();
       
        return $data;
    }
}
if (!function_exists('two_decimal')) {

    function two_decimal($num)
    {
        return sprintf("%0.2f",$num);
    }
}

if (!function_exists('get_default_lead_status')) {

    function get_default_lead_status()
    {
        $status = DB::table('lead_status')->where("default", 1)->first(['status']);
        if ($status) {
            return $status->status;
        } else {
            return '';
        }
    }
}

if (!function_exists('get_default_student_status')) {

    function get_default_student_status()
    {
        $status = DB::table('overseas_status')->where("assign_on_create", 1)->first(['overseas_status_name']);
        if ($status) {
            return $status->overseas_status_name;
        } else {
            return '';
        }
    }
}

if (!function_exists('get_admission_complete_status')) {

    function get_admission_complete_status()
    {
        $status = DB::table('overseas_status')->where("is_completed_success", 1)->first(['overseas_status_name']);
        if ($status) {
            return $status->overseas_status_name;
        } else {
            return '';
        }
    }
}

if (!function_exists('get_student_rejected_status')) {

    function get_student_rejected_status()
    {
        $status = DB::table('overseas_status')->where("is_dropout", 1)->first(['overseas_status_name']);
        if ($status) {
            return $status->overseas_status_name;
        } else {
            return '';
        }
    }
}

if (!function_exists('get_student_app_processing_status')) {

    function get_student_app_processing_status()
    {
        $status = DB::table('overseas_status')->where("assign_on_appl_create", 1)->first(['overseas_status_name']);
        if ($status) {
            return $status->overseas_status_name;
        } else {
            return '';
        }
    }
}

if (!function_exists('get_student_doc_upload_status')) {

    function get_student_doc_upload_status()
    {
        $status = DB::table('overseas_status')->where("assign_on_doc_upload", 1)->first(['overseas_status_name']);
        if ($status) {
            return $status->overseas_status_name;
        } else {
            return '';
        }
    }
}

if (!function_exists('get_student_course_pref_status()')) {

    function get_student_course_pref_status()
    {
        $status = DB::table('overseas_status')->where("assign_on_course_pref", 1)->first(['overseas_status_name']);
        if ($status) {
            return $status->overseas_status_name;
        } else {
            return '';
        }
    }
}

if (!function_exists('get_converted_lead_status')) {

    function get_converted_lead_status()
    {
        $status = DB::table('lead_status')->where("converted_status", 1)->first(['status']);
        if ($status) {
            return $status->status;
        } else {
            return '';
        }
    }
}

if (!function_exists('get_counselling_lead_status')) {

    function get_counselling_lead_status()
    {
        $status = DB::table('lead_status')->where("counselling_status", 1)->first(['status']);
        if ($status) {
            return $status->status;
        } else {
            return '';
        }
    }
}

if (!function_exists('get_disqualified_lead_status')) {

    function get_disqualified_lead_status()
    {
        $status = DB::table('lead_status')->where("disqualified_status", 1)->first(['status']);
        if ($status) {
            return $status->status;
        } else {
            return '';
        }
    }
}

if (!function_exists('get_disqualified_student_status')) {

    function get_disqualified_student_status()
    {
        $status = DB::table('overseas_status')->where("is_dropout", 1)->first(['overseas_status_name']);
        if ($status) {
            return $status->overseas_status_name;
        } else {
            return '';
        }
    }
}

if (!function_exists('get_case_close_success_application_status')) {

    function get_case_close_success_application_status()
    {
        $status = DB::table('application_stages')->where("case_close_success", 1)->first(['status_name']);
        if ($status) {
            return $status->status_name;
        } else {
            return '';
        }
    }
}

if (!function_exists('get_case_close_rejected_application_status')) {

    function get_case_close_rejected_application_status()
    {
        $status = DB::table('application_stages')->where("case_close_rejected", 1)->first(['status_name']);
        if ($status) {
            return $status->status_name;
        } else {
            return '';
        }
    }
}

if (!function_exists('get_disqualified_lead_status_id')) {

    function get_disqualified_lead_status_id()
    {
        $status = DB::table('lead_status')->where("disqualified_status", 1)->first();
        if ($status) {
            return $status->id;
        } else {
            return '';
        }
    }
}

if (!function_exists('get_lead_status_color')) {

    function get_lead_status_color($status)
    {
        $status = DB::table('lead_status')->where("status", $status)->first(['colorcode']);
        if ($status) {
            return $status->colorcode;
        } else {
            return "#2A3042";
        }
    }
}

if (!function_exists('get_overseas_status_color')) {

    function get_overseas_status_color($status)
    {
        $status = DB::table('overseas_status')->where("overseas_status_name", $status)->first(['color']);
        if ($status) {
            return $status->color;
        } else {
            return "#2A3042";
        }
    }
}

if (!function_exists('lead_status_list')) {

    function lead_status_list()
    {
        $status = DB::table('lead_status')->orderBy("display_order", 'ASC')->get();
        return $status;
    }
}

if (!function_exists('get_only_lead_status_list')) {

    function get_only_lead_status_list()
    {
        $leadStatus = DB::table('lead_status')->orderBy("display_order", 'ASC')->get(['status']);
        return $leadStatus;
    }
}

if (!function_exists('counselling_lead_status_list')) {

    function counselling_lead_status_list()
    {
        $status = DB::table('lead_status')->where('converted_status','1')->orwhere('counselling_status',1)->orwhere('disqualified_status',1)->orderBy("display_order", 'ASC')->get();
        return $status;
    }
}


if (!function_exists('get_lead_sop_list')) {

    function get_lead_sop_list($course_pref_id)
    {
        $list = DB::table('user_docs_other')->where("course_pref_id", $course_pref_id)->orderBy('id', 'desc')->first();
        return $list;
    }
}

if (!function_exists('get_essay_list')) {

    function get_essay_list($course_pref_id)
    {
        $list = DB::table('user_docs_other')->where("course_pref_id", $course_pref_id)->where('doc_type','essay')->orderBy('id', 'desc')->get();
        return $list;
    }
}

if (!function_exists('get_lor_count')) {

    function get_lor_count($user_id)
    {
        $count = DB::table('user_docs_other')->where("doc_type", 'letter_of_recommendation')->where("userid", $user_id)->count();
        return $count;
    }
}

if (!function_exists('get_pass_count')) {

    function get_pass_count($user_id)
    {
        $count = DB::table('user_docs_other')->where("doc_type", 'passport')->where("userid", $user_id)->count();
        return $count;
    }
}

if (!function_exists('get_exp_count')) {

    function get_exp_count($user_id)
    {
        $count = DB::table('user_docs_other')->where("doc_type", 'experience')->where("userid", $user_id)->count();
        return $count;
    }
}

if (!function_exists('get_other_count')) {

    function get_other_count($user_id)
    {
        $count = DB::table('user_docs_other')->where("doc_type", 'other')->where("userid", $user_id)->count();
        return $count;
    }
}

if (!function_exists('get_docs_count')) {

    function get_docs_count($user_id,$type)
    {
        $count = DB::table('user_docs_other')->where("doc_type", $type)->where("userid", $user_id)->count();
        return $count;
    }
}

if (!function_exists('generate_ticket_id')) {

    function generate_ticket_id()
    {
        $ticket_id = rand(100000, 999999);
        while (1) {
            $rows = DB::table('tickets')->where("ticket_id", $ticket_id)->count();
            if ($rows) {
                $ticket_id = rand(100000, 999999);
                continue;
            } else {
                break;
            }
        }
        return $ticket_id;
    }
}

if (!function_exists('create_new_ticket')) {

    function create_new_ticket($userid, $subject, $message)
    {
        $ticket_id = generate_ticket_id();
        $now = date("Y-m-d H:i:s");
        DB::table('tickets')->insert(["ticket_id" => $ticket_id, "userid" => $userid, "created_at" => $now, "subject" => $subject, "updated_at" => $now]);
        DB::table('ticket_reply')->insertGetId(["ticket_id" => $ticket_id, "reply_timestamp" => $now, "reply_by" => "user", "message" => $message]);

        //Notify Staff
        $email_message = "Ticket #$ticket_id is created.<br /><br /><hr>$message<hr><br /><br />View Ticket Details: <br /><a href=\"" . url("admin/ticket/" . $ticket_id) . "\">" . url("admin/ticket/" . $ticket_id) . "</a>";
        $notify_ids = get_site_config('support_ticket_notification_email');
        $tos = explode(",", $notify_ids);
        foreach ($tos as $to) {
            try{
            //Mail::to($to)->send(new MailSend("[Ticket ID: $ticket_id] $subject", $email_message));
            user_notify($to,"[Ticket ID: $ticket_id] $subject", $email_message);
            }catch (\Exception $e) {
                    $message = $e->getMessage();
                    \Log::debug("Mail Error: (New Ticket) ".$message);   
            }
        }
        //
        return $ticket_id;
    }
}


if (!function_exists('generate_application_id')) {

    function generate_application_id()
    {
        $unique_id = rand(100000, 999999);
        while (1) {
            $rows = DB::table('university_application')->where("appl_id", $unique_id)->count();
            if ($rows) {
                $unique_id = rand(100000, 999999);
                continue;
            } else {
                break;
            }
        }
        return $unique_id;
    }
}


if(!function_exists('send_event_notification_email')) {
    function send_event_notification_email($email_ids, $subject, $message) {
        foreach ($email_ids as $to) {
            try{
                // Mail::to($to)->send(new MailSend($subject, $message));
                user_notify($to,$subject, $message);
            }catch (\Exception $e) {
                $err_message = $e->getMessage();
                \Log::debug("Mail Error: (send_event_notification_email) ".$err_message);   
            }
        }        
    }
}

if (!function_exists('get_university_name')) {

    function get_university_name($id)
    {
        $rtr = DB::table('universities')->where('id',$id)->first();
        if($rtr){
            return $rtr->university_name;
        }
        else{
            return "-";
        }

    }
}

if (!function_exists('get_university_data')) {

    function get_university_data($id)
    {
        $rtr = DB::table('universities')->where('id',$id)->first();
        if($rtr) return $rtr;
        else return "";
    }
}

if (!function_exists('get_university_course_data')) {

    function get_university_course_data($id)
    {
        $rtr = DB::table('university_courses')->where('id',$id)->first();
        if($rtr){
            return $rtr;
        }
        return "";

    }
}

if (!function_exists('get_university_course_category')) {

    function get_university_course_category($id)
    {       
        $rtr = DB::table('university_course_categories')->where('id',$id)->first();
        if($rtr){
            $name = $rtr->title;
            if($rtr->parent_id > 0){
                $rtr2 = DB::table('university_course_categories')->where('id',$rtr->parent_id)->first();
                if($rtr2){
                    $name = $rtr2->title." > ".$name;
                }
            }
            return $name;
        }else{
            return "";
        }
    }
}

if (!function_exists('get_university_course_category_name')) {

    function get_university_course_category_name($id)
    {       
        $rtr = DB::table('university_course_categories')->where('id', $id)->first();
        if($rtr){
            if($rtr->parent_id != 0){
                return $rtr->title;
            } else{
                return "--";
            }
        } else{
            return "";
        }
    }
}

if (!function_exists('get_university_course_sub_category_name')) {

    function get_university_course_sub_category_name($id)
    {       
        $rtr = DB::table('university_course_categories')->where('id',$id)->first();
        if($rtr){
            // $name = $rtr->title;
            return $rtr;
        }
    }
}

if (!function_exists('get_university_course_parent_category_name')) {

    function get_university_course_parent_category_name($id)
    {       
        $rtr = DB::table('university_course_categories')->where('id',$id)->first();
        if($rtr){
            if($rtr->parent_id > 0){
                $rtr2 = DB::table('university_course_categories')->where('id',$rtr->parent_id)->first();
                return $rtr2->title;
            } else{
                return $rtr->title;
            }
        }
        return "--";
    }
}

if (!function_exists('check_application')) {

    function check_application($id, $type)
    {
        // if($type == 'visa') {
        //     $rtr = DB::table('university_application')->where('visa_pref_id',$id)->first();
        // } elseif($type == 'abroad_job') {
        //     $rtr = DB::table('university_application')->where('abroad_job_pref_id',$id)->first();
        // } else {
            $rtr = DB::table('university_application')->where('course_pref_id',$id)->first();
        // }
        return $rtr;
    }
}

// if (!function_exists('check_noti_enable')) {
//     function check_noti_enable($event,$type)
//     {
//         $notiStat = NotificationConfigs::where('event', $event)->first([$type]);
//         if($notiStat) {
//             return $notiStat->$type;
//         } else {
//             \Log::error("ERROR: NotificationConfigs:".$event." NOT FOUND!");
//             return "";
//         }
//     }
// }

// Old name was send_notification
if (!function_exists('send_mail_notification')) {
    function send_mail_notification($stu_id,$appl_id,$event,$subject,$message, $is_visa=false, $authId = null)
    {
        \Log::debug("send_mail_notification($stu_id,$appl_id,$event,$subject,$message, $is_visa, $authId)");
        $notiStat = NotificationConfigs::where('event', $event)->first();
        if($authId){
            $currentUser = $authId;
        } else{
            $currentUser = \Auth::user()->id;
        }
        \Log::debug("Email Event Triggered by :" . get_user_full_name_by_id($currentUser));
        if($notiStat) {
            if($notiStat->email_appl_assignee){
                if($is_visa){
                    if($notiStat->email_appl_assignee){
                        $user = ServiceApplications::where('id',$appl_id)->first(['user_id','assigned_to']);
                        if($user->assigned_to != 0 && $user->assigned_to != $currentUser){
                            $staffData = get_user_by_id($user->assigned_to);

                            $managerEmail = "";
                            if($staffData->reporting_to != 1 && $notiStat->email_staff_manager){
                                $managerEmail = get_user_email_by_id($staffData->reporting_to);  
                            }
                            if($user->assigned_to != $currentUser && $staffData->reporting_to != $currentUser){
                                // Mail::to($staffData->email)
                                // ->cc($managerEmail)
                                // ->send(new MailSend($subject, $message));
                                if($managerEmail!= ""){
                                    user_notify($staffData->email,$subject, $message,$managerEmail);
                                }else{
                                    user_notify($staffData->email,$subject, $message);
                                }
                                \Log::debug("Mail Sent to Visa Appl Assignee: ".$staffData->email." and Manager: ".$managerEmail."- ($subject) " . $message);
                            } elseif($user->assigned_to == $currentUser && $notiStat->email_staff_manager){
                                // Mail::to($managerEmail)
                                // ->send(new MailSend("NOTIFICATION: ".$subject, $message));
                                user_notify($managerEmail,$subject, $message);
                                \Log::debug("Mail Sent to Visa Appl Assignee Manager: ".$managerEmail."- ($subject) " . $message);
                            } else{
                                // Mail::to($staffData->email)
                                // ->send(new MailSend($subject, $message));
                                user_notify($staffData->email,$subject, $message);
                                \Log::debug("Mail Sent to Visa Appl Assignee Staff: ".$staffData->email."- ($subject) " . $message);
                            }
                        } else {
                            \Log::debug("Mail not sent to Visa Appl Assignee: Visa Application is not assigned to any Staff");
                        }
                    }
                } else{
                    $user = UniversityApplication::where('id',$appl_id)->first(['userid','assign_to']);
                    if($user->assign_to != 0 && $user->assigned_to != $currentUser){
                        $staffData = get_user_by_id($user->assign_to);

                        $managerEmail = "";
                        if($staffData->reporting_to != 1 && $notiStat->email_staff_manager){
                            $managerEmail = get_user_email_by_id($staffData->reporting_to);  
                        }
                        if($user->assigned_to != $currentUser && $staffData->reporting_to != $currentUser){
                            // Mail::to($staffData->email)
                            // ->cc($managerEmail)
                            // ->send(new MailSend($subject, $message));
                            if($managerEmail!= ""){
                                user_notify($staffData->email,$subject, $message,$managerEmail);
                            }else{
                                user_notify($staffData->email,$subject, $message);
                            }
                            \Log::debug("Mail Sent to Appl Assignee: ".$staffData->email." and Manager: ".$managerEmail."- ($subject) " . $message);
                        } elseif($user->assigned_to == $currentUser && $notiStat->email_staff_manager){
                            // Mail::to($managerEmail)
                            // ->send(new MailSend("NOTIFICATION: ".$subject, $message));
                            user_notify($managerEmail,$subject, $message);
                            \Log::debug("Mail Sent to Appl Assignee Manager: ".$managerEmail."- ($subject) " . $message);
                        } else{
                            // Mail::to($staffData->email)
                            // ->send(new MailSend($subject, $message));
                            user_notify($staffData->email,$subject, $message);
                            \Log::debug("Mail Sent to Appl Assignee Staff: ".$staffData->email."- ($subject) " . $message);
                        }
                    } else {
                        \Log::debug("Mail not sent to Appl Assignee: Application is not assigned to any Staff");
                    }
                }
            }
            if($notiStat->email_staff){
                \Log::debug("notiStat->email_staff");
                if($event == "SUPPORT_TICKET_CREATION" || $event == "SUPPORT_TICKET_ASSIGNED_TO_STAFF" || $event == "SUPPORT_TICKET_REPLY_RECEIVED" || $event == "SUPPORT_TICKET_STATUS_CHANGE"){
                    $staffData = get_user_by_id($stu_id); //Now $stu_id is Assigned to ID
                    try {
                        $managerEmail = "";
                        if($staffData->reporting_to != 1 && $notiStat->email_staff_manager){
                            $managerEmail = get_user_email_by_id($staffData->reporting_to);  
                        }
                        if($user->assigned_to != $currentUser && $staffData->reporting_to != $currentUser){
                            // Mail::to($staffData->email)
                            // ->cc($managerEmail)
                            // ->send(new MailSend($subject, $message));
                            if($managerEmail!= ""){
                                user_notify($staffData->email,$subject, $message,$managerEmail);
                            }else{
                                user_notify($staffData->email,$subject, $message);
                            }
                            \Log::debug("Mail Sent to Staff: ".$staffData->email." and Manager: ".$managerEmail."- ($subject) " . $message);
                        } elseif($user->assigned_to == $currentUser && $notiStat->email_staff_manager){
                            // Mail::to($managerEmail)
                            // ->send(new MailSend("NOTIFICATION: ".$subject, $message));
                            user_notify($managerEmail,$subject, $message);
                            \Log::debug("Mail Sent to Manager: ".$managerEmail."- ($subject) " . $message);
                        } else{
                            // Mail::to($staffData->email)
                            // ->send(new MailSend($subject, $message));
                            user_notify($staffData->email,$subject, $message);
                            \Log::debug("Mail Sent to Staff: ".$staffData->email."- ($subject) " . $message);
                        }
                    } catch (\Exception $e) {
                        $err_message = $e->getMessage();
                        if($staffData){
                            \Log::debug("Mail Error: Staff: ".$staffData->email." and Manager: ".$managerEmail."- ($subject) " . $message.". Error: ".$err_message);
                        }
                    }
                } else{
                    // $user = User::where('id', $stu_id)->first();
                    $user = DB::table('users')->where('id', $stu_id)->first();
                    \Log::debug("Student info: assigned_to:".$user->assigned_to);
                    if($user->assigned_to != 0){
                        $staffData = get_user_by_id($user->assigned_to);
                        try {
                            $managerEmail = "";
                            if($staffData->reporting_to != 1 && $notiStat->email_staff_manager){
                                $managerEmail = get_user_email_by_id($staffData->reporting_to);  
                                \Log::debug("Manager:".$managerEmail);
                            }
                            if($user->assigned_to != $currentUser && $staffData->reporting_to != $currentUser){
                                \Log::debug("Send Mail to Staff: ".$staffData->email." and Manager: ".$managerEmail."- ($subject) " . $message);                                
                                // Mail::to($staffData->email)
                                // ->cc($managerEmail)
                                // ->send(new MailSend($subject, $message));
                                if($managerEmail!= ""){
                                    user_notify($staffData->email,$subject, $message,$managerEmail);
                                }else{
                                    user_notify($staffData->email,$subject, $message);
                                }
                                \Log::debug("Mail Sent to Staff: ".$staffData->email." and Manager: ".$managerEmail."- ($subject) " . $message);
                            } elseif($user->assigned_to == $currentUser && $notiStat->email_staff_manager){
                                // Mail::to($managerEmail)
                                // ->send(new MailSend("NOTIFICATION: ".$subject, $message));
                                user_notify($managerEmail,$subject, $message);
                                \Log::debug("Mail Sent to Manager: ".$managerEmail."- ($subject) " . $message);
                            } else{
                                // Mail::to($staffData->email)
                                // ->send(new MailSend($subject, $message));
                                user_notify($staffData->email,$subject, $message);
                                \Log::debug("Mail Sent to Staff: ".$staffData->email."- ($subject) " . $message);
                            }
                        } catch (\Exception $e) {
                            $err_message = $e->getMessage();
                            \Log::debug("Mail Error: Staff: ".$staffData->email." and Manager: ".$managerEmail."- ($subject) " . $message.". Error: ".$err_message);
                        }
                    } else {
                        \Log::debug("Mail not sent to Staff and Manager(email_staff): Student is not assigned to any Staff");
                    }
                }
                
            }

            if(!$notiStat->email_staff && $notiStat->email_staff_manager){
                \Log::debug("notiStat-> only_mgr");
                if($event == "SUPPORT_TICKET_CREATION" || $event == "SUPPORT_TICKET_ASSIGNED_TO_STAFF" || $event == "SUPPORT_TICKET_REPLY_RECEIVED" || $event == "SUPPORT_TICKET_STATUS_CHANGE"){
                    $staffData = get_user_by_id($stu_id); //Now $stu_id is Assigned to ID
                    if($staffData->reporting_to != 1 && $staffData->reporting_to != $currentUser){
                        try {
                            $managerEmail = "";
                            $managerEmail = get_user_email_by_id($staffData->reporting_to);  
                            // Mail::to($managerEmail)
                            // ->send(new MailSend("NOTIFICATION: ".$subject, $message));
                            user_notify($managerEmail,$subject, $message);
                            \Log::debug("Mail Sent to Manager: ".$managerEmail."- ($subject) " . $message);
                        } catch (\Exception $e) {
                            $err_message = $e->getMessage();
                            \Log::debug("Mail Error: Manager: ".$managerEmail."- ($subject) " . $message.". Error: ".$err_message);
                        }
                    }
                }else{
                    // $user = User::find($stu_id);
                    $user = DB::table('users')->where('id', $stu_id)->first();

                    //If this is a lead or student create, notify the the creators manager                    
                    $continue = true;
                    if($event == "LEAD_STUDENT_CREATED") {
                        $continue = false;
                        if(!\Auth::user()->isAgent() && auth()->user()->reporting_to && auth()->user()->reporting_to !=1) {
                            $managerEmail = get_user_email_by_id(auth()->user()->reporting_to);
                            \Log::debug("Lead_student created event, notifing mgr:".$managerEmail);      
                            // Mail::to($managerEmail)
                            // ->send(new MailSend("NOTIFICATION: ".$subject, $message));
                            user_notify($managerEmail,$subject, $message);
                            \Log::debug("Mail Sent to Creator Manager: ".$managerEmail."- ($subject) " . $message);
                        }
                    }

                    if($continue) {
                        $staffData = get_user_by_id($user->assigned_to);
                        if($user->assigned_to != 0 && $staffData->reporting_to != 1 && $staffData->reporting_to != $currentUser){
                            try {
                                $managerEmail = get_user_email_by_id($staffData->reporting_to);  
                                // Mail::to($managerEmail)
                                // ->send(new MailSend("NOTIFICATION: ".$subject, $message));
                                user_notify($managerEmail,$subject, $message);
                                \Log::debug("Mail Sent to Manager: ".$managerEmail."- ($subject) " . $message);
                            } catch (\Exception $e) {
                                $err_message = $e->getMessage();
                                \Log::debug("Mail Error: Manager: ".$managerEmail."- ($subject) " . $message.". Error: ".$err_message);
                            }
                            
                        } else {
                            \Log::debug("Mail not sent to Staff and Manager(only email_staff_manager): Student is not assigned to any Staff");
                        }
                    }
                }
                
            }
            if($notiStat->email_superadmin){
                if($currentUser != 1){
                    $recipient = new AdminRecipient();
                    try {
                        //$recipient->notify(new AdminAlert("NOTIFICATION: ".$subject, $message));
                        user_notify($recipient, "NOTIFICATION: ".$subject, $message);
                        \Log::debug("Mail Sent to Admin- ($subject) " . $message);
                    } catch (\Exception $e) {
                        $err_message = $e->getMessage();
                        \Log::debug("Mail Error: Admin- ($subject) " . $message.". Error: ".$err_message);
                    }
                }
            }

            if($notiStat->email_agent){
                // $user = User::find($stu_id);
                $user = DB::table('users')->where('id', $stu_id)->first();
                if($user->agent_id != 0 && $user->agent_id != $currentUser){
                    $staffData = get_user_by_id($user->agent_id);
                    try {
                        // Mail::to($staffData->email)->send(new MailSend($subject, $message));
                        user_notify($staffData->email,$subject, $message);
                        \Log::debug("Mail Sent to Visa Appl Assignee: ".$staffData->email."- ($subject) " . $message);
                    } catch (\Exception $e) {
                        $err_message = $e->getMessage();
                        \Log::debug("Mail Error: Visa Appl Assignee: ".$staffData->email."- ($subject) " . $message.". Error: ".$err_message);
                    }
                } else {
                    \Log::debug("Mail not sent to Agent: Student is not assigned to any Agent");
                }
            }
        } else {
            \Log::error("ERROR: NotificationConfigs:".$event." NOT FOUND!");
        }
    }
}

if (!function_exists('send_in_app_notification')) {
    function send_in_app_notification($stu_id, $appl_id, $event, $subject, $message, $type, $is_visa = false, $authId = null) {
        // Subject is not used
        \Log::debug("Send In App Notification: Studentid:$stu_id, Applid:$appl_id, $event, $message, $type, Isvisa:$is_visa Authid:$authId");
        if($authId){
            $currentUser = $authId;
        } else{
            $currentUser = \Auth::user()->id;
        }
        //\Log::debug("App Notification Triggered by :" . get_user_full_name_by_id($currentUser));
        
        $notiStat = NotificationConfigs::where('event', $event)->first();
        if($notiStat) {
            if($notiStat->app_appl_assignee){
                if($is_visa){
                    if($notiStat->app_appl_assignee){
                        $user = ServiceApplications::where('appl_id',$appl_id)->first();
                        // $user = User::find($stu_id);

                        $staffData = get_user_by_id($user->assigned_to); //Now $stu_id is Assigned to ID

                        if($user->assigned_to != 0 && $user->assigned_to != $currentUser){
                            $noti = new UserNotification;                   
                            $noti->user_id = $user->assigned_to;
                            $noti->application_id = $user->id;
                            $noti->application_type = $type;
                            $noti->message = $message;
                            $noti->from_user = $currentUser;
                            $noti->save();

                            \Log::debug("App Notification to Visa & Application Assigned to Staff");
                        }

                        // Sending App Notification to App Assigned staff manager
                        if($staffData && $staffData->reporting_to != 1 && $notiStat->app_staff_manager && $staffData->reporting_to != $currentUser){
                            $noti = new UserNotification;
                            $noti->user_id = $staffData->reporting_to;
                            $noti->application_id = $user->id;
                            $noti->application_type = $type;
                            $noti->message = $message;
                            $noti->from_user = $currentUser;
                            $noti->save();

                            \Log::debug("App Notification Assigned to Staff Manager");
                        }
                    }
                } else{
                    if($notiStat->app_appl_assignee){
                        if($type == "university"){
                            $collegeAppl = UniversityApplication::where('appl_id',$appl_id)->first();
                            $assigned_to = $collegeAppl->assign_to;
                        }

                        $staffData = get_user_by_id($collegeAppl->assign_to); //Now $stu_id is Assigned to ID

                        if($assigned_to != 0 && $assigned_to != $currentUser){
                            $noti = new UserNotification;                   
                            $noti->user_id = $assigned_to;
                            $noti->application_id = $collegeAppl->id;
                            $noti->application_type = $type;
                            $noti->message = $message;
                            $noti->from_user = $currentUser;
                            $noti->save();

                            \Log::debug("App Notification to Application Assigned to Staff");
                        }

                        // Sending App Notification to App Assigned staff manager
                        if($staffData && $staffData->reporting_to != 1 && $notiStat->app_staff_manager && $staffData->reporting_to != $currentUser){
                            $noti = new UserNotification;
                            $noti->user_id = $staffData->reporting_to;
                            $noti->application_id = $collegeAppl->id;
                            $noti->application_type = $type;
                            $noti->message = $message;
                            $noti->from_user = $currentUser;
                            $noti->save();

                            \Log::debug("App Notification Assigned to Staff Manager");
                        }
                    }
                }
            }
            if($notiStat->app_staff){
                if($event == "SUPPORT_TICKET_CREATION" || $event == "SUPPORT_TICKET_ASSIGNED_TO_STAFF" || $event == "SUPPORT_TICKET_REPLY_RECEIVED" || $event == "SUPPORT_TICKET_STATUS_CHANGE"){
                    Log::debug("App Staff if");
                    $staffData = get_user_by_id($stu_id); //Now $stu_id is Assigned to ID
                    $ticket = Ticket::where('ticket_id',$appl_id)->first();
                    if($ticket->assigned_to != 0){                        
                        if($ticket->assigned_to != $currentUser){
                            $noti = new UserNotification;
                            $noti->user_id = $ticket->assigned_to;
                            $noti->application_id = $ticket->ticket_id;
                            $noti->application_type = $type;
                            $noti->message = $message;
                            $noti->from_user = $currentUser;
                            $noti->save();

                            \Log::debug("App Notification Assigned to Staff");
                        }

                        if($staffData && $staffData->reporting_to != 1 && $notiStat->app_staff_manager && $staffData->reporting_to != $currentUser){
                            $noti = new UserNotification;
                            $noti->user_id = $staffData->reporting_to;
                            $noti->application_id = $ticket->id;
                            $noti->application_type = $type;
                            $noti->message = $message;
                            $noti->from_user = $currentUser;
                            $noti->save();

                            \Log::debug("App Notification Assigned to Staff Manager");
                        }
                    }
                } else{
                    // $user = User::find($stu_id);
                    $user = DB::table('users')->where('id', $stu_id)->first();
                    $staffData = get_user_by_id($user->assigned_to); //Now $stu_id is Assigned to ID
                    
                    if($user->assigned_to != 0){
                            
                        if($type == "university"){
                            $collegeAppl = UniversityApplication::where('appl_id',$appl_id)->first();
                        } elseif($type == "whatsapp_incoming" || $type == "lead" || $type == "student" || $type == "agent"){
                            // $collegeAppl = User::find($stu_id);
                            Log::debug("Application Type is " . $type);
                            $collegeAppl = DB::table('users')->where('id', $stu_id)->first();
                        } elseif($type == "visa"){
                            $collegeAppl = ServiceApplications::where('appl_id',$appl_id)->first();
                        } elseif($type == "webinar"){
                            $collegeAppl = Webinar::where('id', $appl_id)->first();
                        } elseif($type == "invoice"){
                            $collegeAppl = Invoice::where('id', $appl_id)->first();
                        } elseif($type == "staff_leaves"){
                            $collegeAppl = StaffLeaves::where('id', $appl_id)->first();
                        } else{
                            $collegeAppl = DB::table('users')->where('id', $stu_id)->first();
                        }
                        
                        if($user->assigned_to != $currentUser){
                            $noti = new UserNotification;
                            $noti->user_id = $user->assigned_to;
                            $noti->application_id = $collegeAppl ? $collegeAppl->id : "";
                            $noti->application_type = $type;
                            $noti->message = $message;
                            $noti->from_user = $currentUser;
                            $noti->save();

                            \Log::debug("App Notification Assigned to Staff");
                        }

                        if($staffData && $staffData->reporting_to != 1 && $notiStat->app_staff_manager && $staffData->reporting_to != $currentUser){
                            $noti = new UserNotification;
                            $noti->user_id = $staffData->reporting_to;
                            $noti->application_id = $collegeAppl->id;
                            $noti->application_type = $type;
                            $noti->message = $message;
                            $noti->from_user = $currentUser;
                            $noti->save();

                            \Log::debug("App Notification Assigned to Staff Manager");
                        }
                    }
                }
            }
            
            if(!$notiStat->app_staff && $notiStat->app_staff_manager){
                if($event == "SUPPORT_TICKET_CREATION" || $event == "SUPPORT_TICKET_ASSIGNED_TO_STAFF" || $event == "SUPPORT_TICKET_REPLY_RECEIVED" || $event == "SUPPORT_TICKET_STATUS_CHANGE"){
                    $staffData = get_user_by_id($stu_id); //Now $stu_id is Assigned to ID
                    $ticket = Ticket::where('ticket_id',$appl_id)->first();
                    if($staffData && $staffData->reporting_to != 1 && $staffData->reporting_to != $currentUser){
                        $noti = new UserNotification;
                        $noti->user_id = $staffData->reporting_to;
                        $noti->application_id = $ticket->ticket_id;
                        $noti->application_type = $type;
                        $noti->message = $message;
                        $noti->from_user = $currentUser;
                        $noti->save();
                    }
                } else{
                    // $user = User::find($stu_id);
                    $user = DB::table('users')->where('id', $stu_id)->first();
                    $staffData = get_user_by_id($user->assigned_to); //Now $stu_id is Assigned to ID
                    if($type == "university"){
                        $collegeAppl = UniversityApplication::where('appl_id',$appl_id)->first();
                    } elseif($type == "lead" || $type == "student" || $type == "agent"){
                        // $collegeAppl = User::where('id',$appl_id)->first();
                        $collegeAppl = DB::table('users')->where('id',$appl_id)->first();
                    } elseif($type == "visa"){
                        $collegeAppl = ServiceApplications::where('appl_id',$appl_id)->first();
                    } elseif($type == "webinar"){
                        $collegeAppl = Webinar::where('id', $appl_id)->first();
                    } elseif($type == "invoice"){
                        $collegeAppl = Invoice::where('id', $appl_id)->first();
                    } elseif($type == "staff_leaves"){
                        $collegeAppl = StaffLeaves::where('id', $appl_id)->first();
                    } else{
                        $collegeAppl = DB::table('users')->where('id', $appl_id)->first();
                    }

                    //If this is a lead or student create, notify the the creators manager                    
                    if($event == "LEAD_STUDENT_CREATED") {
                        if(!\Auth::user()->isAgent() && auth()->user()->reporting_to && auth()->user()->reporting_to !=1) {
                            $noti = new UserNotification;
                            $noti->user_id = auth()->user()->reporting_to;
                            $noti->application_id = $collegeAppl->id;
                            $noti->application_type = $type;
                            $noti->message = $message;
                            $noti->from_user = $currentUser; // 
                            $noti->save();
    
                            \Log::debug("App Notification sent to Creator Manager.");
                        }
                    } else {
                        
                        if($staffData && $staffData->reporting_to != 1 && $staffData->reporting_to != $currentUser){
                            $noti = new UserNotification;
                            $noti->user_id = $staffData->reporting_to;;
                            $noti->application_id = $collegeAppl->id;
                            $noti->application_type = $type;
                            $noti->message = $message;
                            $noti->from_user = $currentUser; // 
                            $noti->save();

                            \Log::debug("App Notification sent to Manager.");
                        }
                    }
                }
                
            }
            
            if($notiStat->app_superadmin){
                if($type == "university"){
                    $collegeAppl = UniversityApplication::where('appl_id',$appl_id)->first();
                } elseif($type == "lead" || $type == "student" || $type == "agent"){
                    // $collegeAppl = User::where('id',$appl_id)->first();
                    $collegeAppl = DB::table('users')->where('id',$appl_id)->first();
                } elseif($type == "visa"){
                    $collegeAppl = ServiceApplications::where('appl_id',$appl_id)->first();
                } elseif($type == "ticket"){
                    $collegeAppl = Ticket::where('ticket_id',$appl_id)->first();
                    $collegeAppl->id = $collegeAppl->ticket_id;
                } elseif($type == "webinar"){
                    $collegeAppl = Webinar::where('id', $appl_id)->first();
                } elseif($type == "invoice"){
                    $collegeAppl = Invoice::where('id', $appl_id)->first();
                } elseif($type == "staff_leaves"){
                    $collegeAppl = StaffLeaves::where('id', $appl_id)->first();
                } else{
                    $collegeAppl = DB::table('users')->where('id',$appl_id)->first();
                }
                
                if($currentUser != 1){
                    $noti = new UserNotification;
                    $noti->user_id = 1;
                    $noti->application_id = $collegeAppl->id;
                    $noti->application_type = $type;
                    $noti->message = $message;
                    $noti->from_user = $currentUser;
                    $noti->save();

                    \Log::debug("App Notification sent to Admin");
                }
            }

            if($notiStat->app_agent){
                // $user = User::find($stu_id);
                $user = DB::table('users')->where('id', $stu_id)->first();
                // $agentData = get_user_by_id($user->agent_id);

                if($type == "university"){
                    $collegeAppl = UniversityApplication::where('appl_id',$appl_id)->first();
                } elseif($type == "lead" || $type == "student"){
                    // $collegeAppl = User::where('id',$appl_id)->first();
                    $collegeAppl = DB::table('users')->where('id',$appl_id)->first();
                } elseif($type == "visa"){
                    $collegeAppl = ServiceApplications::where('appl_id',$appl_id)->first();
                } elseif($type == "ticket"){
                    $collegeAppl = Ticket::where('ticket_id',$appl_id)->first();
                    $collegeAppl->id = $collegeAppl->ticket_id;
                } elseif($type == "webinar"){
                    $collegeAppl = Webinar::where('id', $appl_id)->first();
                } elseif($type == "invoice"){
                    $collegeAppl = Invoice::where('id', $appl_id)->first();
                } elseif($type == "staff_leaves"){
                    $collegeAppl = StaffLeaves::where('id', $appl_id)->first();
                } else{
                    $collegeAppl = DB::table('users')->where('id', $stu_id)->first();
                }
                
                if($user->agent_id != 0 && $user->agent_id != $currentUser){
                    $noti = new UserNotification;
                    $noti->user_id = $user->agent_id;
                    $noti->application_id = $collegeAppl->id;
                    $noti->application_type = $type;
                    $noti->message = $message;
                    $noti->from_user = $currentUser;
                    $noti->save();

                    \Log::debug("App Notification sent to Agent");
                }
            }
        } else {
            \Log::error("ERROR: NotificationConfigs:".$event." NOT FOUND!");
        }
    }
}


if(!function_exists('get_study_levels')) {
    function get_study_levels() {
        
        /*$study_levels = [
            'UG Diploma/ Certificate/ Associate Degree' => 'UG Diploma/ Certificate/ Associate Degree',
            'UG' => 'Undergraduate',
            'PG Diploma/Certificate' => 'PG Diploma/Certificate',
            'PG' => 'Postgraduate',
            'UG+PG (Accelerated) Degree' => 'UG+PG (Accelerated) Degree',
            'PhD' => 'PhD',
            'Foundation' => 'Foundation',
            'Short Term Programs' => 'Short Term Programs',
            'Pathway Programs' => 'Pathway Programs',
            'Twinning Programmes (UG)' => 'Twinning Programmes (UG)',
            'Twinning Programmes (PG)' => 'Twinning Programmes (PG)',
            'English Language Program' => 'English Language Program',
            'Online Programmes/ Distance Learning' => 'Online Programmes/ Distance Learning',
            //    'Pre-Bachelors' => 'Pre-Bachelors /Foundation Course',
            //    'Bachelors' => 'Bachelors Degree',
            //    'Pre-Masters' => 'Pre-Masters / Extension Masters',
            //    'Masters' => 'Masters Degree',
            //    'Ph.D' => 'Ph.D',
            //    'Others' => 'Others',
            ];*/

        $study_levels = array();
        $rows = DB::table('study_levels')->orderBy('display_order')->get();
        foreach($rows as $row) {
            $study_levels[$row->study_level] = $row->study_level;
        }    
    
        return $study_levels;
    }
}


if(!function_exists('get_study_level_degree_level')) {
    function get_study_level_degree_level($study_level) {
        return DB::table('study_levels')->where('study_level', $study_level)->first(['degree'])->degree;
        // return DB::table('study_levels')->where('study_level', $study_level)->first(['degree']);
    }
}

if (!function_exists('get_university_course_data')) {

    function get_university_course_data($id)
    {
        $rtr = DB::table('university_courses')->where('id',$id)->first();
        return $rtr;

    }
}
if(!function_exists('get_my_study_level')) {
    function get_my_study_level($logged_in_user) {
        $my_study_level = "";
        if ($logged_in_user->overseas_study_level == 'Pre-bachelors') {
            $my_study_level = "pre-bachelors";
        } elseif ($logged_in_user->overseas_study_level == 'Bachelors') {
            $my_study_level = "bachelors";
        } elseif ($logged_in_user->overseas_study_level == 'Pre-masters') {
            $my_study_level = "pre-masters";
        } elseif ($logged_in_user->overseas_study_level == 'Masters') {
            $my_study_level = "masters";
        } elseif ($logged_in_user->overseas_study_level == 'Ph.D') {
            $my_study_level = "phd";
        } else {
            $my_study_level = "others";
        }
        return $my_study_level;
    }
}

if(!function_exists('get_student_doc_configs')) {
    function get_student_doc_configs() {
        $docs_conf = get_site_config('student_doc_configs');
        $docs_conf = json_decode($docs_conf, true);
        return $docs_conf;
    }
}

if(!function_exists('get_lead_types')) {
    function get_lead_types() {
        if(config('app.product_code') == 'OVERSEAS') {
            $statuses = [
                'Study Abroad',
            ];
        } elseif(config('app.product_code') == 'TRAINING') {
            $statuses = [
                'Coaching',
            ];
        } elseif(config('app.product_code') == 'EDUCTRL_CRM') {
            $statuses = [
                'Study Abroad',
                'Coaching',
                'Study Abroad & Coaching',
            ];
        }

        return $statuses;
    }
}

if (!function_exists('show_lead_type')) {
    function show_lead_type($type)
    {
        switch ($type) {
            case 'Study Abroad':
                $ret = '<span class="badge badge-primary">' . $type . '</span>';
                break;
            case 'Coaching':
                $ret = '<span class="badge badge-default">' . $type . '</span>';
                break;
            case 'Study Abroad & Coaching':
                $ret = '<span class="badge badge-primary">Study Abroad</span> <span class="badge badge-default">Coaching</span>';
                break;
            default:
                $ret = '<span class="badge badge-default">' . $type . '</span>';
                break;
        }
        return $ret;
    }
}

	// if(!function_exists('get_app_apply_through')) {
	//     function get_app_apply_through() {
	//         $sources = get_site_config('application_apply_through');
	//         return array_map('trim', explode(',', $sources));
	//     }
	// }

    if(!function_exists('get_student_referral_payout_modes')) {
	    function get_student_referral_payout_modes() {
	        $sources = get_site_config('student_referral_payout_modes');
	        return array_map('trim', explode(',', $sources));
	    }
	}
if(!function_exists('get_lead_sources')) {
    function get_lead_sources() {
        $sources = get_site_config('lead_sources');
        return array_map('trim', explode(',', $sources));
    }
}

if(!function_exists('get_lead_disqualified_reason')) {
    function get_lead_disqualified_reason() {
        $sources = get_site_config('lead_disqualified_reason');
        return array_map('trim', explode(',', $sources));
    }
}

if(!function_exists('get_student_qualification_levels')) {
    function get_student_qualification_levels() {
        $levels = get_site_config('student_qualification_levels');
        return array_map('trim', explode(',', $levels));
    }
}

if(!function_exists('get_student_disqualified_reason')) {
    function get_student_disqualified_reason() {
        $sources = get_site_config('student_disqualified_reason');
        return array_map('trim', explode(',', $sources));
    }
}

if(!function_exists('get_communication_modes')) {
    function get_communication_modes() {
        $get_communication_modes = get_site_config('communication_mode');
        return array_map('trim', explode(',', $get_communication_modes));
    }
}

if(!function_exists('get_student_types')) {
    function get_student_types() {
        if(config('app.product_code') == 'OVERSEAS') {
            $types = [
                'study_abroad' => 'Study Abroad',
            ];
        } elseif(config('app.product_code') == 'TRAINING') {
            $types = [
                'course' => 'Coaching',
            ];
        } elseif(config('app.product_code') == 'EDUCTRL_CRM') {
            $types = [
                'study_abroad' => 'Study Abroad',
                'course' => 'Coaching',
                'study_abroad_course' => 'Study Abroad & Coaching',
            ];
        }

        return $types;
    }
}


if(!function_exists('get_app_stages')) {
    function get_app_stages() {
        $app_stages = array();
        $rows = DB::table('application_stages')->orderBy('stage_order')->get();
        foreach($rows as $row) {
            $app_stages[$row->status_name] = $row->status_name;
        }    
        return $app_stages;
    }
}

if(!function_exists('get_app_stage_data')) {
    function get_app_stage_data() {
        return "ok working";
        //return DB::table('study_levels')->where('study_level', $study_level)->first(['degree'])->degree;
    }
}


if (!function_exists('get_application_statuses')) {
    function get_application_statuses($country = null)
    {
        $app_stages = array();
        if($country){
            $rows = DB::table('application_stages')
            ->Where('country_applicable', 'like', "%$country%")
            ->orWhere('country_applicable',NULL)->orderBy('stage_order')->get();
        }else{
            $rows = DB::table('application_stages')->orderBy('stage_order')->get();
        }
        foreach($rows as $row) {
            $app_stages[] = $row;
        }    
        
        return $app_stages;
        // return [
        //     'Pending',
        //     'Documents Ready',
        //     'Admission Criteria Met',
        //     'Application Fee Paid',
        //     'Application Submitted',
        //     'Offer Letter Received',
        //     'Funds Under Assessment',
        //     'COE Received',
        //     'Payment Received',
        //     'CAS Requested',
        //     'CAS Received',
        //     'I-20 Initiated',
        //     'I-20 Received',
        //     'AIP Received',
        //     'Visa in Process',
        //     'Visa Received',
        //     'Case Closed - Admission Complete',
        //     'Case Closed - Rejected By Institution',
        //     'Case Closed - Visa Rejected',
        //     'Case Closed - Other reasons'
        // ];
    }
}

if (!function_exists('get_visa_application_statuses')) {
    function get_visa_application_statuses()
    {
        return [
            'Payment Pending',
            'Documents Pending',
            'Documents Ready',
            'Visa in Process',
            'Case Closed - Completed',
            'Case Closed - Rejected',
        ];
    }
}

if (!function_exists('get_abroad_job_application_statuses')) {
    function get_abroad_job_application_statuses()
    {
        return [
            // 'Payment Pending',
            // 'Documents Pending',
            // 'Documents Ready',
            'In Process',
            'Case Closed - Completed',
            'Case Closed - Rejected',
        ];
    }
}



// if (!function_exists('get_agent_application_statuses')) {
//     function get_agent_application_statuses()
//     {
//         return [
//             'Offer Letter Received',
//             'Funds Under Assessment',
//             'COE Received',
//             'Payment Received',
//             'CAS Requested',
//             'CAS Received',
//             'I-20 Initiated',
//             'I-20 Received',
//             'AIP Received',
//             'Visa in Process',
//             'Visa Received',
//             'Case Closed - Admission Complete',
//         ];
//     }
// }

if (!function_exists('get_application_status')) {
    function get_application_status($data)
    {

        if ($data->case_closed) {
            switch ($data->case_closed_reason) {
                case 'admission_complete':
                    $status = 'Case Closed - Admission Complete';
                    break;
                case 'rejected_by_institution':
                    $status = 'Case Closed - Rejected By Institution';
                    break;
                case 'visa_rejected':
                    $status = 'Case Closed - Visa Rejected';
                    break;
                case 'other';
                    $status = 'Case Closed - Other reasons';
                    break;
            }
        } elseif ($data->visa_received == 'yes') {
            $status = 'Visa Received';
        } elseif ($data->visa_in_process == 'yes') {
            $status = 'Visa in Process';
        } elseif ($data->aip_received == 'yes') {
            $status = 'AIP Received';
        } elseif ($data->i20_received == 'yes') {
            $status = 'I-20 Received';
        } elseif ($data->i20_initiated == 'yes') {
            $status = 'I-20 Initiated';
        } elseif ($data->cas_received == 'yes') {
            $status = 'CAS Received';
        } elseif ($data->cas_requested == 'yes') {
            $status = 'CAS Requested';
        } elseif ($data->payment_received == 'yes') {
            $status = 'Payment Received';
        } elseif ($data->coe_received == 'yes') {
            $status = 'COE Received';
        } elseif ($data->funds_under_assessment == 'yes') {
            $status = 'Funds Under Assessment';
        } elseif ($data->offer_letter_received == 'yes') {
            $status = 'Offer Letter Received';
        } elseif ($data->application_submitted == 'yes') {
            $status = 'Application Submitted';
        } elseif ($data->application_fee_paid == 'yes') {
            $status = 'Application Fee Paid';
        } elseif ($data->admission_criteria_met == 'yes') {
            $status = 'Admission Criteria Met';
        } elseif ($data->doc_ready == 'yes') {
            $status = 'Documents Ready';
        } else {
            $status = 'Pending';
        }
        return $status;
    }
}


if (!function_exists('show_application_status')) {
    function show_application_status($status)
    {
        switch ($status) {
            case 'Case Closed - Admission Complete':
                $status = '<span class="tagStatus" style="background-color:' . get_application_status_color($status) . '!important;">' . $status . '</span>';
                break;
            case 'Case Closed - Rejected By Institution':
            case 'Case Closed - Visa Rejected':
            case 'Case Closed - Other reasons':
                $status = '<span class="tagStatus" style="background-color:' . get_application_status_color($status) . '!important;">' . $status . '</span>';
                break;
            case 'Pending':
                $status = '<span class="tagStatus" style="background-color:' . get_application_status_color($status) . '!important;">' . $status . '</span>';
                break;
            default:
                $status = '<span class="tagStatus" style="background-color:' . get_application_status_color($status) . '!important;">' . $status . '</span>';
                break;
        }
        return $status;
    }
}

if (!function_exists('show_visa_application_status')) {
    function show_visa_application_status($status)
    {
        switch ($status) {
            case 'Case Closed - Completed':
                $status = '<span class="tag" style="background-color:' . get_application_status_color($status) . '!important; color:#fff">' . $status . '</span>';
                break;
            case 'Case Closed - Rejected':
                $status = '<span class="tag" style="background-color:' . get_application_status_color($status) . '!important; color:#fff">' . $status . '</span>';
                break;
            case 'Payment Pending':
                $status = '<span class="tag" style="background-color:' . get_application_status_color($status) . '!important; color:#fff">' . $status . '</span>';
                break;
            default:
                $status = '<span class="tag" style="background-color:' . get_application_status_color($status) . '!important; color:#fff">' . $status . '</span>';
                break;
        }
        return $status;
    }
}

if (!function_exists('show_abroad_job_application_status')) {
    function show_abroad_job_application_status($status)
    {
        switch ($status) {
            case 'Case Closed - Completed':
                $status = '<span class="tag" style="background-color:' . get_application_status_color($status) . '!important; color:#fff">' . $status . '</span>';
                break;
            case 'Case Closed - Rejected':
                $status = '<span class="tag" style="background-color:' . get_application_status_color($status) . '!important; color:#fff">' . $status . '</span>';
                break;
            case 'Payment Pending':
                $status = '<span class="tag" style="background-color:' . get_application_status_color($status) . '!important; color:#fff">' . $status . '</span>';
                break;
            default:
                $status = '<span class="tag" style="background-color:' . get_application_status_color($status) . '!important; color:#fff">' . $status . '</span>';
                break;
        }
        return $status;
    }
}


if (!function_exists('get_settings_tabs')) {
    function get_settings_tabs($current_page)
    {
        $ret = '';
        if ($current_page == 'settings') {
            $ret = "<li class=\"nav-item\">
            <button class=\"nav-link nabBarHeading\" data-bs-toggle=\"tab\" data-bs-target=\"#general\">General </button>
        </li>
        <li class=\"nav-item\">
        <a href=\"" . route('admin.settings.business-configs') . "\">
            <button class=\" nabBarHeading nav-link " . ($current_page == 'business-configs' ? 'active' : '') . "\" style='text-align: left;'>Business Configs</button>
        </a>
        </li>
        <li class=\"nav-item\">
        <a href=\"" . route('admin.settings.branch') . "\">
            <button class=\" nabBarHeading nav-link " . ($current_page == 'branch' ? 'active' : '') . "\" style='text-align: left;'>Branches</button>
        </a>
        </li>
        <li class=\"nav-item\">
            <button class=\"nav-link nabBarHeading \" data-bs-toggle=\"tab\" data-bs-target=\"#home-page\">Home Page</button>
        </li>
        ";
        } else {
        $ret = "<a href=\"" . route('admin.settings') . "#general\">
            <li class=\"nav-item\">
            <button class=\"nav-link nabBarHeading \" data-bs-toggle=\"tab\" data-bs-target=\"#general\">General </button>
            </a>
        </li>
        <li class=\"nav-item\">
        <a href=\"" . route('admin.settings.business-configs') . "\">
            <button class=\" nabBarHeading nav-link " . ($current_page == 'business-configs' ? 'active' : '') . "\" style='text-align: left;'>Business Configs</button>
        </a>
        </li>
        <li class=\"nav-item\">
        <a href=\"" . route('admin.settings.branch') . "\">
            <button class=\" nabBarHeading nav-link " . ($current_page == 'branch' ? 'active' : '') . "\" style='text-align: left;'>Branch</button>
        </a>
        </li>
        <li class=\"nav-item\">
            <a href=\"" . route('admin.settings') . "#home-page\">
            <button class=\"nav-link nabBarHeading \" data-bs-toggle=\"tab\" data-bs-target=\"#home-page\">Home Page</button>
            </a>
        </li>
        ";
        }

        $ret .= "
        <li class=\"nav-item\">
        <a href=\"" . route('admin.banners') . "\">
            <button class=\"nabBarHeading nav-link " . ($current_page == 'banners' ? 'active' : '') . "\">Banners </button>
        </a>
        </li>
         <li class=\"nav-item\">
            <a href=\"" . route('admin.content-blocks') . "\">
                <button class=\" nabBarHeading nav-link " . ($current_page == 'content-blocks' ? 'active' : '') . "\">Content Blocks </button>
            </a>
        </li>
        ";
         if ($current_page == 'settings') {

         $ret .= "<li class=\"nav-item\">
            <a href=\"" . route('admin.settings') . "#modules\">
            <button class=\"nav-link nabBarHeading \" data-bs-toggle=\"tab\" data-bs-target=\"#modules\">Modules </button>
            </a>
        </li>";
         }
         else{
            $ret .= "<li class=\"nav-item\">
            <a href=\"" . route('admin.settings') . "#modules\">
            <button class=\"nav-link nabBarHeading \" data-bs-toggle=\"tab\" data-bs-target=\"#modules\">Modules </button>
            </a>
        </li>";

         }

    if (config('app.product_code') == 'OVERSEAS' || config('app.product_code') == 'EDUCTRL_CRM') { 
        $ret .= "
        <li class=\"nav-item\">
            <a href=\"" . route('admin.settings.study-levels') . "\">
                <button class=\"nabBarHeading nav-link " . ($current_page == 'study-levels' ? 'active' : '') . "\">Study Levels</button>
            </a>
        </li>
        <li class=\"nav-item\">
            <a href=\"" . route('admin.country-settings') . "\">
                <button class=\" nabBarHeading nav-link " . ($current_page == 'country-settings' ? 'active' : '') . "\">Country </button>
            </a>
        </li>
        <li class=\"nav-item\">
            <a href=\"" . route('admin.uni-apply-agents') . "\">
                <button class=\" nabBarHeading nav-link " . ($current_page == 'uni-apply-agents' ? 'active' : '') . "\">Uni Apply Agents </button>
            </a>
        </li>";
    }
        
        $ret .= "<li class=\"nav-item\">
            <a href=\"" . route('admin.leads-settings') . "\">
                <button class=\" nabBarHeading nav-link " . ($current_page == 'leads-settings' ? 'active' : '') . "\">Leads </button>
            </a>
        </li>";


        if (config('app.product_code') == 'OVERSEAS' || config('app.product_code') == 'EDUCTRL_CRM') {
            
            $ret .= "
            <li class=\"nav-item\">
            <a href=\"" . route('admin.settings.student-status') . "\">
                <button class=\" nabBarHeading nav-link " . ($current_page == 'student-status' ? 'active' : '') . "\" style='text-align: left;'>Student Status</button>
            </a>
        </li>
            <li class=\"nav-item\">
            <a href=\"" . route('admin.settings.application-stages') . "\">
                <button class=\" nabBarHeading nav-link " . ($current_page == 'application-stages' ? 'active' : '') . "\" style='text-align: left;'>Application Status</button>
            </a>
        </li>
        <li class=\"nav-item\">
            <a href=\"" . route('admin.settings.student') . "\">
                <button class=\" nabBarHeading nav-link " . ($current_page == 'student' ? 'active' : '') . "\">Student Docs</button>
            </a>
        </li>
          <li class=\"nav-item\">
            <a href=\"" . route('admin.additional-docs') . "\">
                <button class=\" nabBarHeading nav-link " . ($current_page == 'additional-docs' ? 'active' : '') . "\">Additional Docs </button>
            </a>
            </li>
            <li class=\"nav-item\">
        <a href=\"" . route('admin.settings.custom-attributes') . "\">
            <button class=\" nabBarHeading nav-link " . ($current_page == 'custom-attributes' ? 'active' : '') . "\" style='text-align: left;'>Custom Attributes</button>
        </a>
        </li>
        ";
        
        if(env('ADDITIONAL_SERVICES_ENABLE')){
            $ret .= "<li class=\"nav-item\">
                <a href=\"" . route('admin.settings.services.list') . "\">
                    <button class=\" nabBarHeading nav-link " . ($current_page == 'services-list' ? 'active' : '') . "\" style='text-align: left;'>Services List</button>
                </a>
            </li>";
        }
        
        if (config('app.product_code') == 'OVERSEAS' || config('app.product_code') == 'EDUCTRL_CRM') {

         $ret .= "
        <li class=\"nav-item\">
            <a href=\"" . route('admin.settings.tax-index') . "\">
                <button class=\" nabBarHeading nav-link " . ($current_page == 'tax-index' ? 'active' : '') . "\">Tax </button>
            </a>
        </li>";
        }

        

        $ret .= "
        <li class=\"nav-item\">
        <a href=\"" . route('admin.settings.custom-labels') . "\">
            <button class=\" nabBarHeading nav-link " . ($current_page == 'custom-labels' ? 'active' : '') . "\" style='text-align: left;'>Custom Labels</button>
        </a>
        </li>";
        
        }

        $ret .= "
        <li class=\"nav-item\">
            <a href=\"" . route('admin.settings.notifications') . "\">
                <button class=\" nabBarHeading nav-link " . ($current_page == 'notifications' ? 'active' : '') . "\">Notifications</button>
            </a>
        </li>
        <li class=\"nav-item\">
            <a href=\"" . route('admin.web-to-lead') . "\">
                <button class=\" nabBarHeading nav-link " . ($current_page == 'web-to-lead' ? 'active' : '') . "\">Web to Lead</button>
            </a>
        </li>
        <li class=\"nav-item\">
            <a href=\"" . route('admin.meta-lead') . "\">
                <button class=\" nabBarHeading nav-link " . ($current_page == 'meta-lead' ? 'active' : '') . "\">Meta Leads</button>
            </a>
        </li>";

        if(env('FORM_BUILDER_ENABLE')){
            $ret .= "<li class=\"nav-item\">
                <a href=\"" . route('admin.form-builder') . "\">
                    <button class=\" nabBarHeading nav-link " . ($current_page == 'form-builder' ? 'active' : '') . "\">Form Builder</button>
                </a>
            </li>";
        }

        $ret .= "<li class=\"nav-item\">
        <a href=\"" . route('admin.email-smtp') . "\">
            <button class=\" nabBarHeading nav-link " . ($current_page == 'email-smtp' ? 'active' : '') . "\">Email SMTP</button>
        </a>
        </li>";
        
        $ret .= "<li class=\"nav-item\">
            <a href=\"" . route('admin.settings.outbound-call') . "\">
                <button class=\" nabBarHeading nav-link " . ($current_page == 'outbound-call' ? 'active' : '') . "\">Outbound Call</button>
            </a>
        </li>";
        $ret .= "<li class=\"nav-item\">
            <a href=\"" . route('admin.settings.whatsapp') . "\">
                <button class=\" nabBarHeading nav-link " . ($current_page == 'whatsapp' ? 'active' : '') . "\">Whatsapp</button>
            </a>
        </li>";
        $ret .= "<li class=\"nav-item\">
            <a href=\"" . route('admin.settings.sms') . "\">
                <button class=\" nabBarHeading nav-link " . ($current_page == 'sms' ? 'active' : '') . "\">SMS</button>
            </a>
        </li>";

        $ret .= "<li class=\"nav-item\">
            <a href=\"" . route('admin.integrations') . "\">
                <button class=\" nabBarHeading nav-link " . ($current_page == 'integrations' ? 'active' : '') . "\">Integrations</button>
            </a>
        </li>";
        if(env('EMAIL_SYNC_ENABLE')){
            $ret .= "<li class=\"nav-item\">
            <a href=\"" . route('admin.email-sync') . "\">
                <button class=\" nabBarHeading nav-link " . ($current_page == 'email-sync' ? 'active' : '') . "\">Email Sync</button>
            </a>
            </li>";
        };

        $ret .= "<li class=\"nav-item\">
            <a href=\"" . route('admin.landing-pages') . "\">
                <button class=\" nabBarHeading nav-link " . ($current_page == 'landing-pages' ? 'active' : '') . "\">Landing Pages</button>
            </a>
        </li>";


        $ret .= "<li class=\"nav-item\">
        <a href=\"" . route('admin.settings.holidays') . "\">
            <button class=\" nabBarHeading nav-link " . ($current_page == 'holidays' ? 'active' : '') . "\">Holidays</button>
        </a>
        </li>";


        if ($current_page == 'settings') {
            $ret .= "<li class=\"nav-item\">
                <button class=\" nabBarHeading nav-link\" data-bs-toggle=\"tab\" data-bs-target=\"#advanced\">Advanced </button>
            </li>";
        } else {
            $ret .= "<li class=\"nav-item\">
            <a href=\"" . route('admin.settings') . "#advanced\">
                <button class=\" nabBarHeading nav-link\">Advanced </button>
            </a>
            </li>";
        }

        if ($current_page == 'master-setup') {
            $ret .= "<li class=\"nav-item\">
                <button class=\" nabBarHeading nav-link active\" data-bs-toggle=\"tab\" data-bs-target=\"#master-setup\">Master Setup </button>
            </li>";
        } else {
            $ret .= "<li class=\"nav-item\">
            <a href=\"" . route('admin.master-setup')."\">
                <button class=\" nabBarHeading nav-link\">Master Setup </button>
            </a>
            </li>";
        }

        

        

        return $ret;
    }
}

if (!function_exists('get_automation_tabs')) {
    function get_automation_tabs($current_page)
    {
        $ret = '';

        $ret .= "<li class=\"nav-item\">
        <a href=\"" . route('admin.automation') . "\">
            <button class=\"nav-link " . ($current_page == 'workflows' ? 'active' : '') . "\">Workflows </button>
        </a>
        </li>

        <li class=\"nav-item\">
            <a href=\"" . route('admin.automation.campaigns') . "\">
                <button class=\"nav-link " . ($current_page == 'automation.campaigns' ? 'active' : '') . "\">Campaigns </button>
            </a>
        </li>";
        return $ret;
    }
}

if(!function_exists('get_doc_section_name')) {
    function get_doc_section_name($section_id) {
        $section = DB::table('additional_docs_sections')->where('id', $section_id)->first();
        if($section){
            return $section->section;
        }
        return "--";
    }
} 

if (!function_exists('get_course_tabs')) {
    function get_course_tabs($current_page)
    {
        $ret = '';

        $ret .= "<li class=\"nav-item\">
        <a href=\"" . route('admin.coursemanagement') . "\">
            <button class=\"course_management_tab nav-link " . ($current_page == 'coursemanagement' ? 'active' : '') . "\">Courses </button>
        </a>
        </li>

        <li class=\"nav-item\">
            <a href=\"" . route('admin.coursemanagement.categories') . "\">
                <button class=\"course_management_tab nav-link " . ($current_page == 'coursemanagement.categories' ? 'active' : '') . "\">Categories </button>
            </a>
        </li>
        <li class=\"nav-item\">
            <a href=\"" . route('admin.coursemanagement.universities') . "\">
                <button class=\"course_management_tab nav-link " . ($current_page == 'coursemanagement.universities' ? 'active' : '') . "\">Universities </button>
            </a>
        </li>";
        return $ret;
    }
}

// if(!function_exists('get_overseas_status_list')) {
//     function get_overseas_status_list() {
//         return [
//             //'Lead' => 'Lead',
//             'Pending' => 'Profile Incomplete',
//             'Profile' => 'Profile Completed',
//             'Course Preferences' => 'Course Preferences Added',
//             'Documents' => 'Documents Uploaded',
//             'Application Processing' => 'Application Processing',
//             'Application Rejected/Cancelled' => 'Application Rejected/Cancelled',
//             'Admission Complete' => 'Admission Complete'
//         ];
//     }
// }

if (!function_exists('get_overseas_status_list')) {

    function get_overseas_status_list()
    {
        $status = DB::table('overseas_status')->orderBy("display_order", 'ASC')->get(['overseas_status_name as status']);
        return $status;
    }
}

if(!function_exists('get_coaching_status_list')) {
    function get_coaching_status_list() {
        return [
            'Not Enrolled' => 'Not Enrolled',
            'Enrolled to Course' => 'Enrolled to Course',
            'Course Completed' => 'Course Completed',
        ];
    }
}

//not in use----------------------------------------------------
if(!function_exists('get_candidate_status_list')) {
    function get_candidate_status_list() {
        return [
            'Pending' => 'Profile Incomplete',
            'Profile' => 'Profile Completed',
            'Country Preferences' => 'Country Preferences Added',
            'Documents' => 'Documents Uploaded',
            'Application Processing' => 'Application Processing',
            'Application Rejected/Cancelled' => 'Application Rejected/Cancelled',
            'Complete' => 'Complete'
        ];
    }
}
//not in use----------------------------------------------------


if(!function_exists('get_country_name')) {
    function get_country_name($id) {
        if(is_numeric($id)) {
            $country = DB::table('countries')->where('id', '=', $id)->first(['title_en']);
            if($country){
                return $country->title_en;
            }
            else{
                return "";
            }
        } else {
            return $id;
        }
    }
}
if(!function_exists('get_country_id_by_name')) {
    function get_country_id_by_name($name) {
        if($name) {
            $country = DB::table('countries')->where('title_en', '=', $name)->first(['id']);
            if($country){
                return $country->id;
            }
            else{
                return config('app.USER_DEFAULT_COUNTRY');
            }
        } else {
            return $name;
        }
    }
}

if(!function_exists('get_additional_docs')){
    function get_additional_docs($userid,$doc_type){
        $rows = DB::table('user_docs_other')->where('userid', $userid)->where('doc_type', $doc_type)->get();
        $doc = array();
        if ($rows) {
            foreach ($rows as $row) {
                $doc[] = $row;
            }
        }
        return $doc;
    }
}


if(!function_exists('get_city_name')) {
    function get_city_name($id) {
        if(is_numeric($id)) {
            $city = DB::table('cities')->where('id', '=', $id)->first(['name']);
            if($city){
                return $city->name;
            }
            else{
                return;
            }
        } else {
            return $id;
        }
    }
}

if(!function_exists('get_date_formated')) {
    function get_date_formated($date) {
        if($date!=''){
            $converted = date(env('DATE_FORMAT'), strtotime($date));
            return $converted;
        }
        else{
            return "--";
        }
    }
}

if(!function_exists('get_date_time_formated')) {
    function get_date_time_formated($date_time) {
        if($date_time){
        $converted = date(env('DATE_TIME_FORMAT'), strtotime($date_time));
        return $converted;
        }
        else{
            return "--";
        }
    }
}

if(!function_exists('get_state_name')) {
    function get_state_name($id) {
        $state = DB::table('states')->where('id', '=', $id)->first(['name']);
         if($state){
            return $state->name;
        }
        else{
            return "--";
        }
    }
}


if(!function_exists('get_visa_user_status_list')) {
    function get_visa_user_status_list() {
        return [
            'Pending' => 'Payment Pending',
            'Application Processing' => 'Application Processing',
            'Application Rejected/Cancelled' => 'Rejected/Cancelled',
            'Complete' => 'Visa Complete'
        ];
    }
}

if (!function_exists('update_student_overseas_status')) {
    function update_student_overseas_status($id)
    {
        //Admission Complete: When any one application is successfully completed, this is status is set
        //Application Rejected/Cancelled: When all applications are rejected, cancelled this status is set
        //Application Processing: When any one application is in any of the processing steps, this status is set
        //Documents
        //Course Preferences
        //Profile
        $overseas_status = '';
        $student = DB::table('users')->where('id', $id)->first();
        if ($student) {
            $appls = DB::table('university_application')->where('userid', $id)->get();
            if ($appls->count()) {
                $rejected = 0;
                foreach ($appls as $appl) {
                        // if ($appl->status == 'Case Closed - Admission Complete') {
                        if ($appl->status == get_case_close_success_application_status()) {
                        $overseas_status = get_admission_complete_status();
                        break;
                    } elseif (
                        // $appl->status == 'Case Closed - Rejected By Institution'
                        // || $appl->status == 'Case Closed - Visa Rejected'
                        // || $appl->status == 'Case Closed - Other reasons'
                        $appl->status == get_case_close_rejected_application_status()
                    ) {
                        $rejected++;
                    }
                    
                }

                if (!$overseas_status) {
                    if ($rejected == $appls->count()) {
                        $overseas_status = get_student_rejected_status();
                    } else {
                        $overseas_status = get_student_app_processing_status();
                    }
                }
            } else {
                //No applications
                if ($student->profile_complete == 'documents') {
                    $overseas_status = get_student_doc_upload_status();
                } elseif ($student->profile_complete == 'course') {
                    $overseas_status = get_student_course_pref_status();
                } 
                // elseif ($student->profile_complete == 'personal') {
                //     $overseas_status = 'Profile';
                // }
            }
            DB::table('users')->where('id', $id)->update(['overseas_status' => $overseas_status]);
        }
    }
}


if (!function_exists('update_visa_user_status')) {
    function update_visa_user_status($id)
    {
        //Complete: Visa done
        //Application Rejected/Cancelled: When all applications are rejected, cancelled this status is set
        //Application Processing: When any one application is in any of the processing steps, this status is set        
        //Payment Pending
        $overseas_status = '';
        $user = DB::table('users')->where('id', $id)->first();
        if ($user) {
            $appls = DB::table('university_application')->where('userid', $id)->get();
            if ($appls->count()) {
                $rejected = 0;
                $payment_pending = 0;
                foreach ($appls as $appl) {
                        if ($appl->visa_status == 'Case Closed - Completed') {
                            $overseas_status = 'Complete';
                            break;
                        }
                        if (
                            $appl->visa_status == 'Case Closed - Rejected') {
                            $rejected++;
                        } elseif (
                            $appl->visa_status == 'Payment Pending') {
                            $payment_pending++;
                        }
                }

                if (!$overseas_status) {
                    if ($rejected == $appls->count()) {
                        $overseas_status = 'Application Rejected/Cancelled';
                    } elseif ($payment_pending == $appls->count()) {
                        $overseas_status = 'Pending';
                    } else {
                        $overseas_status = 'Application Processing';
                    }
                }
            } else {
                //No applications
            }
            DB::table('users')->where('id', $id)->update(['overseas_status' => $overseas_status]);
        }
    }
}

if (!function_exists('update_student_coaching_status')) {
    function update_student_coaching_status($id, $status)
    {
        if($status == 'Course Completed') {
            $batch_in_progress = DB::table('batch_students')
            ->join('batch', 'batch.id', '=', 'batch_students.batch')
            ->where('batch_students.student', '=', $id)
            ->where('batch.status', '!=', 'ended')
            ->count();
            if($batch_in_progress > 1) {
                //some other batch is in progress
            } else {
                DB::table('users')->where('id', $id)->update(['coaching_status' => $status]);    
            }
        } else {
            DB::table('users')->where('id', $id)->update(['coaching_status' => $status]);
        }
    }
}

if(!function_exists('get_visa_service_type_name')) {
    function get_visa_service_type_name($id) {
        return DB::table('visa_service_types')->where('id', $id)->first(['title'])->title;
    }
}

if(!function_exists('get_visa_letter_type_name')) {
    function get_visa_letter_type_name($id) {
        return DB::table('visa_letter_types')->where('id', $id)->first(['title'])->title;
    }
}

if(!function_exists('get_agent_branch')) {
    function get_agent_branch($agent_id) {
        return DB::table('users')->where('id',$agent_id)->pluck('branch')->toArray();
    }
}

if(!function_exists('get_agent_students_count')) {
    function get_agent_students_count($agent_id,$daterange = null) {

        $date_from = "";
        $date_to = "";        
        if(!empty($daterange)) {
            $dts_str = $daterange;
            $dts = explode(" to ", $dts_str);
            $date_from = date("Y-m-d 00:00:00", strtotime($dts[0]));
            $date_to = date("Y-m-d 23:59:59", strtotime($dts[1]));
        }
        return DB::table('users')->where('agent_id',$agent_id)
        ->when(!empty($date_from), function ($query) use ($date_from) {
            return  $query->Where('users.created_at', '>=', "$date_from");
        })
        ->when(!empty($date_to), function ($query) use ($date_to) {
            return  $query->Where('users.created_at', '<=', "$date_to");
        })
        ->count();
    }
}

if(!function_exists('get_agent_applications_count')) {
    function get_agent_applications_count($agent_id,$daterange = null) {

        $date_from = "";
        $date_to = "";        
        if(!empty($daterange)) {
            $dts_str = $daterange;
            $dts = explode(" to ", $dts_str);
            $date_from = date("Y-m-d 00:00:00", strtotime($dts[0]));
            $date_to = date("Y-m-d 23:59:59", strtotime($dts[1]));
        }
        return DB::table('university_application')
        ->join('users', 'users.id', '=', 'university_application.userid')
        ->where('users.agent_id',$agent_id)
        ->when(!empty($date_from), function ($query) use ($date_from) {
            return  $query->Where('university_application.created_at', '>=', "$date_from");
        })
        ->when(!empty($date_to), function ($query) use ($date_to) {
            return  $query->Where('university_application.created_at', '<=', "$date_to");
        })
        ->count();
    }
}

if(!function_exists('get_agents_list')) {
    function get_agents_list() {
            return User::with('roles')
            ->whereHas('roles', function ($q) {
              $q->whereIn('name', ['agent']);
            })->get(['id','first_name','last_name']);
        }
    }

if(!function_exists('get_managerial_list')) {
    function get_managerial_list() {
        return User::with('roles')
        ->whereHas('roles', function ($q) {
        $q->whereIn('managerial', ['1']);
        })->get(['id','first_name','last_name']);
    }
}

if(!function_exists('get_staff_branches')) {
    function get_staff_branches($staff_id) {
        $user = User::find($staff_id);
        if($user->isAdmin()) {
            return DB::table('branch')->get(['branch_name','id']);
        } else {        
            return DB::table('staff_branch')
            ->join('branch', 'branch.id', '=', 'staff_branch.branch_id')
            ->where('staff_branch.staff_id', $staff_id)
            ->get(['branch.branch_name', 'branch.id']);
        }
    }
}

if(!function_exists('get_staff_branch')) {
    function get_staff_branch($staff_id) {
        $user = User::find($staff_id);
        if($user->isAdmin()) {
            return DB::table('branch')->pluck('branch_name','id')->toArray();
        } else {        
            return DB::table('staff_branch')
            ->join('branch', 'branch.id', '=', 'staff_branch.branch_id')
            ->where('staff_branch.staff_id', $staff_id)
            ->pluck('branch.branch_name', 'branch.id')
            ->toArray();
        }
    }
}

if(!function_exists('get_staff_branch_ids')) {
    function get_staff_branch_ids($staff_id) {
        $branch = get_staff_branch($staff_id);
        return array_keys($branch);
    }
}

if(!function_exists('get_staff_branch_names')) {
    function get_staff_branch_names($staff_id) {
        $branch = get_staff_branch($staff_id);
        return implode(", ", array_values($branch));
    }
}

if(!function_exists('branch_name')) {
    function branch_name($id) {
        $ret = DB::table('branch')->where("id", $id)->first();
        if($ret)
            return $ret->branch_name;
        else
            return "-";
    }
}

if(!function_exists('get_pending_masters_setup')) {
    function get_pending_masters_setup() {
        $count = 8;
        $setup_abroad = DB::table("configs_site")->where('key','setup_abroad')->get();
        $setup_abroad_course_finder = DB::table("configs_site")->where('key','setup_abroad_course_finder')->get();
        $setup_general = DB::table("configs_site")->where('key','setup_general')->get();
        $setup_leads = DB::table("configs_site")->where('key','setup_leads')->get();
        $setup_modules = DB::table("configs_site")->where('key','setup_modules')->get();
        $setup_staff_roles = DB::table("configs_site")->where('key','setup_staff_roles')->get();
        $setup_students = DB::table("configs_site")->where('key','setup_students')->get();
        $setup_students_leads_data = DB::table("configs_site")->where('key','setup_students_leads_data')->get();

        // dd($setup_abroad[0]->value);
        if($setup_abroad[0]->value){
            $count--;
        }
        if($setup_abroad_course_finder[0]->value){
            $count--;
        }
        if($setup_general[0]->value){
            $count--;
        }
        if($setup_leads[0]->value){
            $count--;
        }
        if($setup_modules[0]->value){
            $count--;
        }
        if($setup_staff_roles[0]->value){
            $count--;
        }
        if($setup_students[0]->value){
            $count--;
        }
        if($setup_students_leads_data[0]->value){
            $count--;
        }
        return $count;
    }
}

if(!function_exists('get_leads_created')) {
    function get_leads_created($branch_id,$daterange = null) {
        $date_from = "";
        $date_to = "";        
        if(!empty($daterange)) {
            $dts_str = $daterange;
            $dts = explode(" to ", $dts_str);
            $date_from = date("Y-m-d 00:00:00", strtotime($dts[0]));
            $date_to = date("Y-m-d 23:59:59", strtotime($dts[1]));
        }
        $leads_created = DB::table("users")
            ->where('branch', $branch_id)
            ->when(!empty($date_from), function ($query) use ($date_from) {
                return  $query->Where('created_at', '>=', "$date_from");
            })
            ->when(!empty($date_to), function ($query) use ($date_to) {
                return  $query->Where('created_at', '<=', "$date_to");
            })
            ->where(function ($query) {
                return $query->where('is_lead', 1)
                ->orWhere(function ($query) {
                    return $query->where('is_lead', 0)->whereNotNull('lead_converted_date');
                });
            })
            ->count();
        return $leads_created;
    }
}

if(!function_exists('get_leads_converted')) {
    function get_leads_converted($branch_id,$daterange = null) {
        $date_from = "";
        $date_to = "";        
        if(!empty($daterange)) {
            $dts_str = $daterange;
            $dts = explode(" to ", $dts_str);
            $date_from = date("Y-m-d 00:00:00", strtotime($dts[0]));
            $date_to = date("Y-m-d 23:59:59", strtotime($dts[1]));
        }
        $leads_converted = DB::table("users")
            ->where('branch', $branch_id)
            ->when(!empty($date_from), function ($query) use ($date_from) {
                return  $query->Where('lead_converted_date', '>=', "$date_from");
            })
            ->when(!empty($date_to), function ($query) use ($date_to) {
                return  $query->Where('lead_converted_date', '<=', "$date_to");
            })
            ->where('is_lead', 0)
            ->count();
        return $leads_converted;
    }
}

if(!function_exists('get_leads_followups_count')) {
    function get_leads_followups_count($branch_id,$daterange = null) {
        $date_from = "";
        $date_to = "";        
        if(!empty($daterange)) {
            $dts_str = $daterange;
            $dts = explode(" to ", $dts_str);
            $date_from = date("Y-m-d 00:00:00", strtotime($dts[0]));
            $date_to = date("Y-m-d 23:59:59", strtotime($dts[1]));
        }

        $followups_count = DB::table("user_activity")
            ->join('users', 'users.id', '=', 'user_activity.user_id')
            ->where('users.branch', $branch_id)
            ->when(!empty($date_from), function ($query) use ($date_from) {
                return  $query->Where('users.created_at', '>=', "$date_from");
            })
            ->when(!empty($date_to), function ($query) use ($date_to) {
                return  $query->Where('users.created_at', '<=', "$date_to");
            })
            ->count();
        return $followups_count;
    }
}

// if(!function_exists('get_leads_followups')) {
//     function get_leads_followups($user_id) {
//         $followups = DB::table("user_activity")
//             ->where('user_id', $user_id)
//             ->where('type', 'followup')
//             ->count();
//         return $followups;
//     }
// }

// //get max followup count
if(!function_exists('get_max_followups_count')) {
    function get_max_followups_count() {
        $followups = DB::table("user_activity")
            // ->join('users', 'users.id', '=', 'user_activity.user_id')
            // ->when(!empty($date_from), function ($query) use ($date_from) {
            //     return  $query->Where('users.created_at', '>=', "$date_from");
            // })
            // ->when(!empty($date_to), function ($query) use ($date_to) {
            //     return  $query->Where('users.created_at', '<=', "$date_to");
            // })
            ->selectRaw('COUNT(*) AS cnt')
            ->groupBy('user_id')
            ->orderBy('cnt','DESC')
            ->limit(1)
            ->where('type', 'followup')
            ->first();
        return $followups->cnt;
    }
}
//get max followup count

if(!function_exists('get_leads_by_status_count')) {
    function get_leads_by_status_count($branch_id,$status,$daterange = null) {
        foreach(lead_status_list() as $lead_status) {
            $lead_status_stats = DB::table("users")
            ->when(!empty($branch_id), function ($query) use ($branch_id) {
                return $query->where('branch', $branch_id);
            })
            ->where('lead_status', $status)
            ->count();
        }
        return $lead_status_stats;
    }
}

if(!function_exists('get_leads_status_by_id')) {
    function get_leads_status_by_id($lead_id) {
        $lead_status = DB::table('lead_status')->where('id', $lead_id)->first();
        if($lead_status){
            return $lead_status->status;
        } else{
            return "--";
        }
    }
}

if(!function_exists('get_profile_status')) {
    function get_profile_status($branch_id,$status,$daterange = null) {
        $date_from = "";
        $date_to = "";        
        if(!empty($daterange)) {
            $dts_str = $daterange;
            $dts = explode(" to ", $dts_str);
            $date_from = date("Y-m-d 00:00:00", strtotime($dts[0]));
            $date_to = date("Y-m-d 23:59:59", strtotime($dts[1]));
        }
        
            $profiles = DB::table("users")
            ->when(!empty($branch_id), function ($query) use ($branch_id) {
                return $query->where('branch', $branch_id);
            })
            ->when(!empty($date_from), function ($query) use ($date_from) {
                return  $query->Where('created_at', '>=', "$date_from");
            })
            ->when(!empty($date_to), function ($query) use ($date_to) {
                return  $query->Where('created_at', '<=', "$date_to");
            })
            ->where('overseas_status', $status)
            ->where('is_lead', 0)
            ->count();           
        
        return $profiles;
    }
}

//Applications reports
if(!function_exists('get_appls_created')) {
    function get_appls_created($branch_id,$daterange = null) {
        $date_from = "";
        $date_to = "";        
        if(!empty($daterange)) {
            $dts_str = $daterange;
            $dts = explode(" to ", $dts_str);
            $date_from = date("Y-m-d 00:00:00", strtotime($dts[0]));
            $date_to = date("Y-m-d 23:59:59", strtotime($dts[1]));
        }
        $appls_created = DB::table('university_application')
            ->join('users', 'users.id', '=', 'university_application.userid')
            ->where('branch', $branch_id)
            ->when(!empty($date_from), function ($query) use ($date_from) {
                return  $query->Where('university_application.created_at', '>=', "$date_from");
            })
            ->when(!empty($date_to), function ($query) use ($date_to) {
                return  $query->Where('university_application.created_at', '<=', "$date_to");
            })
            ->count();
        return $appls_created;
    }
}

if(!function_exists('get_completed_admissions')) {
    function get_completed_admissions($branch_id,$daterange = null) {
        $date_from = "";
        $date_to = "";        
        if(!empty($daterange)) {
            $dts_str = $daterange;
            $dts = explode(" to ", $dts_str);
            $date_from = date("Y-m-d 00:00:00", strtotime($dts[0]));
            $date_to = date("Y-m-d 23:59:59", strtotime($dts[1]));
        }
        $appls_completed = DB::table('university_application')
            ->join('users', 'users.id', '=', 'university_application.userid')
            ->where('branch', $branch_id)
            ->when(!empty($date_from), function ($query) use ($date_from) {
                return  $query->Where('university_application.created_at', '>=', "$date_from");
            })
            ->when(!empty($date_to), function ($query) use ($date_to) {
                return  $query->Where('university_application.created_at', '<=', "$date_to");
            })
            ->where('status', 'Case Closed - Admission Complete')
            ->count();
        return $appls_completed;
    }
}

if(!function_exists('get_appls_percentage')) {
    function get_appls_percentage($branch_id,$daterange = null) {
        $date_from = "";
        $date_to = "";        
        if(!empty($daterange)) {
            $dts_str = $daterange;
            $dts = explode(" to ", $dts_str);
            $date_from = date("Y-m-d 00:00:00", strtotime($dts[0]));
            $date_to = date("Y-m-d 23:59:59", strtotime($dts[1]));
        }

        $appl_per = DB::table('university_application')
            ->join('users', 'users.id', '=', 'university_application.userid')
            ->where('users.branch', $branch_id)
            ->when(!empty($date_from), function ($query) use ($date_from) {
                return  $query->Where('university_application.created_at', '>=', "$date_from");
            })
            ->when(!empty($date_to), function ($query) use ($date_to) {
                return  $query->Where('university_application.created_at', '<=', "$date_to");
            })
            ->select(DB::Raw('count(university_application.id) * 100 / (select count(*) from university_application) as university_application_percent'))
            ->whereNotIn('status', ['Pending', 'Documents Ready', 'Admission Criteria Met', 'Application Fee Paid','Application Submitted','Case Closed - Rejected By Institution','Case Closed - Visa Rejected','Case Closed - Other reasons'])
            ->get();
        return intval($appl_per[0]->university_application_percent)."%";
    }
}
    
if(!function_exists('get_appls_by_status_count')) {
    function get_appls_by_status_count($branch_id,$status,$daterange = null) {
    
        foreach(get_application_statuses() as $appls_status) {
            $appls_status_stats = DB::table('university_application')
            ->join('users', 'users.id', '=', 'university_application.userid')
            ->when(!empty($branch_id), function ($query) use ($branch_id) {
                return $query->where('branch', $branch_id);
            })
            ->where('university_application.status', $status)
            ->count();
        }
        return $appls_status_stats;
    }
}

if(!function_exists('is_staff_user')) {
    function is_staff_user($userid) {
        $user = User::find($userid);
        if($user->hasRole(config('access.users.admin_role')) || (!$user->hasRole('agent') && !$user->hasRole('trainer')  && !$user->hasRole('user') && !$user->is_lead)) {
            return true;
        }
        return false;
    }
}

if(!function_exists('get_visa_preference')) {
    function get_visa_preference($visa_pref_id) {
        $visa_pref = DB::table("visa_preference")->where('id', $visa_pref_id)->first();
        return $visa_pref;
    }
}

if(!function_exists('get_abroad_job_preference')) {
    function get_abroad_job_preference($abroad_job_pref_id) {
        $res = DB::table("abroad_job_preference")->where('id', $abroad_job_pref_id)->first();
        return $res;
    }
}

if(!function_exists('get_application_count')) {
    function get_application_count($user) {
        $appl_count = DB::table('university_application')->where('userid', $user)->count();
        return $appl_count;
    }
}  

if (!function_exists('get_application_status_color')) {

    function get_application_status_color($status)
    {
        $status_name = DB::table('application_stages')->where("status_name", $status)->first(['color']);
        if ($status_name) {
            return $status_name->color;
        } else {
            return "#F92982";
        }
    }
}
           

if(!function_exists('get_attr_data')) {
    function get_attr_data($id) {
        return DB::table('custom_attributes')->where('attr_name', $id)->first();
    }
} 
        
if(!function_exists('get_attr_label')) {
    function get_attr_label($id,$for) {
        if($for == 'lead'){
            $label = DB::table('custom_attributes')->where('attr_name', $id)->where('for_lead', 1)->first();
        }
        if($for == 'student'){
            $label = DB::table('custom_attributes')->where('attr_name', $id)->where('for_student', 1)->first();
        }
        
        if($label){
            return $label->label;
        }else{
            return "";
        }
    }
}  

if(!function_exists('get_services_data')) {
    function get_services_data() {
        return DB::table('services')->get();
    }
} 

if(!function_exists('get_study_visa')) {
    function get_study_visa() {
        $study_visa_id = DB::table('services')->where('service_name','Study Visa')->first();
        return $study_visa_id->id;
    }
} 

if(!function_exists('get_services')) {
    function get_services($service_id) {
        $service = DB::table('services')->where('id', $service_id)->first();
        if($service){
            return $service->service_name;
        }
        return "--";
    }
} 

if(!function_exists('get_services_appl_id')) {
    function get_services_appl_id($service_id) {
        $service = DB::table('service_applications')->where('id', $service_id)->first();
        if($service){
            return $service->appl_id;
        }
        return "--";
    }
} 

if(!function_exists('get_user_full_name_by_application_id')) {
    function get_user_full_name_by_application_id($id) {
        $application = UniversityApplication::find($id);
        $student = "";
        if($application){
            $student = User::find($application->userid);
        }
        if($student){
            return get_user_full_name_by_id($student->id);
        }
        return "--";
    }
} 

if(!function_exists('get_user_id_by_application_id')) {
    function get_user_id_by_application_id($id) {
        $application = UniversityApplication::find($id);
        $student = "";
        if($application){
            $student = User::find($application->userid);
        }
        if($student){
            return $student->id;
        }
        return "--";
    }
} 

if(!function_exists('get_services_status_data')) {
    function get_services_status_data() {
        return [
            "New File" => "New File",
            "Processing" => "Processing",
            "Decision - Completed" => "Decision - Completed",
            "Decision - Rejected" => "Decision - Rejected",
        ];
    }
} 

if (!function_exists('get_application_id')) {

    function get_application_id($id)
    {
        $rtr = DB::table('university_application')->where('id',$id)->first(['appl_id']);
        if($rtr){
            return $rtr->appl_id;
        }
        return "";

    }
}

if(!function_exists('get_subordinate_ids')) {
    function get_subordinate_ids(array $related_reporting_ids, $parent_profile_id) {
        $profile_id = DB::table('users')->where('reporting_to', '=', $parent_profile_id)->get();
        if($profile_id){
            foreach($profile_id as $profile){
                $related_reporting_ids[] = $profile->id;
                // This below line is required ? We need to store parent or admin id as well?
                // if($profile->id != "1"){
                //     $related_reporting_ids[] = $profile->id;
                // }
                if($profile->id != "1"){ 
                    get_subordinate_ids($related_reporting_ids, $profile->id);
                }
            }
        }
    }
} 

if(!function_exists('get_all_branch_ids')) {
    function get_all_branch_ids() {
        $branch = DB::table('branch')->pluck('id');
        return $branch;
    }
}

if(!function_exists('asBytes')) {
    function asBytes($value) {
        if ( is_numeric( $value ) ) {
            return $value;
        } else {
            $value_length = strlen($value);
            $qty = substr( $value, 0, $value_length - 1 );
            $unit = strtolower( substr( $value, $value_length - 1 ) );
            switch ( $unit ) {
                case 'k':
                    $qty *= 1024;
                    break;
                case 'm':
                    $qty *= 1048576;
                    break;
                case 'g':
                    $qty *= 1073741824;
                    break;
            }
            return $qty;
        }
    }
}
if(!function_exists('get_php_max_upload_size_kb')) {
    function get_php_max_upload_size_kb() {
        $post_max_size = ini_get('post_max_size');
        $upload_max_filesize = ini_get('upload_max_filesize');
        $post_max_size = asBytes($post_max_size);
        $upload_max_filesize = asBytes($upload_max_filesize);
        $max_allowed = ($post_max_size < $upload_max_filesize) ? $post_max_size : $upload_max_filesize;
        if($max_allowed){
            $max_allowed = asBytes($max_allowed);
            return ($max_allowed / 1024) - 1024;
        }
        return 50000;
    }
}

if(!function_exists('get_currency_code_from_symbol')) {
    function get_currency_code_from_symbol($currency_and_tution_fee) {
        try{
            $currency_and_tution_fee = iconv(mb_detect_encoding($currency_and_tution_fee, mb_detect_order(), true), "UTF-8", $currency_and_tution_fee);
        } catch(\Exception $e){
            Log::debug("ERROR: ".$e->getMessage());
        }
        
        if(str_contains($currency_and_tution_fee, "€") || str_contains($currency_and_tution_fee, 'EUR') || str_contains($currency_and_tution_fee, 'Euro')){
            $tution_fee_currency = "EUR";
        } elseif(str_contains($currency_and_tution_fee, '₹') || str_contains($currency_and_tution_fee, 'INR')){
            $tution_fee_currency = "INR";
        } elseif(str_contains($currency_and_tution_fee, '¥') || str_contains($currency_and_tution_fee, 'JPY')){
            $tution_fee_currency = "JPY";                        
        } elseif(str_contains($currency_and_tution_fee, 'GBP') || str_contains($currency_and_tution_fee, '£')){
            $tution_fee_currency = "GBP";
        } elseif(str_contains($currency_and_tution_fee, 'CAD') || str_contains($currency_and_tution_fee, 'Can$')){
            $tution_fee_currency = "CAD";
        } elseif(str_contains($currency_and_tution_fee, 'AUD') || str_contains($currency_and_tution_fee, 'AU$') || str_contains($currency_and_tution_fee, 'A$')){
            $tution_fee_currency = "AUD";
        } elseif(str_contains($currency_and_tution_fee, 'SEK') || str_contains($currency_and_tution_fee, 'kr')){
            $tution_fee_currency = "SEK";
        } elseif(str_contains($currency_and_tution_fee, 'SGD') || str_contains($currency_and_tution_fee, 'S$') || str_contains($currency_and_tution_fee, 'SG$')){
            $tution_fee_currency = "SGD";
        } elseif(str_contains($currency_and_tution_fee, 'AED') || str_contains($currency_and_tution_fee, 'Dhs')){
            $tution_fee_currency = "AED";
        } elseif(str_contains($currency_and_tution_fee, 'ALL')){
            $tution_fee_currency = "ALL";                        
        } elseif(str_contains($currency_and_tution_fee, 'AFN')){
            $tution_fee_currency = "AFN";
        } elseif(str_contains($currency_and_tution_fee, 'ARS')){
            $tution_fee_currency = "ARS";
        } elseif(str_contains($currency_and_tution_fee, 'AWG')){
            $tution_fee_currency = "AWG";
        } elseif(str_contains($currency_and_tution_fee, 'AZN')){
            $tution_fee_currency = "AZN";
        } elseif(str_contains($currency_and_tution_fee, 'BSD')){
            $tution_fee_currency = "BSD";
        } elseif(str_contains($currency_and_tution_fee, 'BBD')){
            $tution_fee_currency = "BBD";
        } elseif(str_contains($currency_and_tution_fee, 'BYN')){
            $tution_fee_currency = "BYN";
        } elseif(str_contains($currency_and_tution_fee, 'BZD')){
            $tution_fee_currency = "BZD";
        } elseif(str_contains($currency_and_tution_fee, 'BMD')){
            $tution_fee_currency = "BMD";
        } elseif(str_contains($currency_and_tution_fee, 'BOB')){
            $tution_fee_currency = "BOB";
        } elseif(str_contains($currency_and_tution_fee, 'BAM')){
            $tution_fee_currency = "BAM";
        } elseif(str_contains($currency_and_tution_fee, 'BWP')){
            $tution_fee_currency = "BWP";
        } elseif(str_contains($currency_and_tution_fee, 'BGN')){
            $tution_fee_currency = "BGN";
        } elseif(str_contains($currency_and_tution_fee, 'BRL')){
            $tution_fee_currency = "BRL";
        } elseif(str_contains($currency_and_tution_fee, 'BND')){
            $tution_fee_currency = "BND";
        } elseif(str_contains($currency_and_tution_fee, 'KHR')){
            $tution_fee_currency = "KHR";
        } elseif(str_contains($currency_and_tution_fee, 'KYD')){
            $tution_fee_currency = "KYD";
        } elseif(str_contains($currency_and_tution_fee, 'CLP')){
            $tution_fee_currency = "CLP";
        } elseif(str_contains($currency_and_tution_fee, 'CNY')){
            $tution_fee_currency = "CNY";
        } elseif(str_contains($currency_and_tution_fee, 'COP')){
            $tution_fee_currency = "COP";
        } elseif(str_contains($currency_and_tution_fee, 'CRC')){
            $tution_fee_currency = "CRC";
        } elseif(str_contains($currency_and_tution_fee, 'HRK')){
            $tution_fee_currency = "HRK";
        } elseif(str_contains($currency_and_tution_fee, 'CUP')){
            $tution_fee_currency = "CUP";
        } elseif(str_contains($currency_and_tution_fee, 'CZK')){
            $tution_fee_currency = "CZK";
        } elseif(str_contains($currency_and_tution_fee, 'DKK')){
            $tution_fee_currency = "DKK";
        } elseif(str_contains($currency_and_tution_fee, 'DOP')){
            $tution_fee_currency = "DOP";
        } elseif(str_contains($currency_and_tution_fee, 'XCD')){
            $tution_fee_currency = "XCD";
        } elseif(str_contains($currency_and_tution_fee, 'EGP')){
            $tution_fee_currency = "EGP";
        } elseif(str_contains($currency_and_tution_fee, 'SVC')){
            $tution_fee_currency = "SVC";
        } elseif(str_contains($currency_and_tution_fee, 'FKP')){
            $tution_fee_currency = "FKP";
        } elseif(str_contains($currency_and_tution_fee, 'FJD')){
            $tution_fee_currency = "FJD";
        } elseif(str_contains($currency_and_tution_fee, 'GHS')){
            $tution_fee_currency = "GHS";
        } elseif(str_contains($currency_and_tution_fee, 'GIP')){
            $tution_fee_currency = "GIP";
        } elseif(str_contains($currency_and_tution_fee, 'GTQ')){
            $tution_fee_currency = "GTQ";
        } elseif(str_contains($currency_and_tution_fee, 'GGP')){
            $tution_fee_currency = "GGP";
        } elseif(str_contains($currency_and_tution_fee, 'GYD')){
            $tution_fee_currency = "GYD";
        } elseif(str_contains($currency_and_tution_fee, 'HNL')){
            $tution_fee_currency = "HNL";
        } elseif(str_contains($currency_and_tution_fee, 'HKD')){
            $tution_fee_currency = "HKD";
        } elseif(str_contains($currency_and_tution_fee, 'HUF')){
            $tution_fee_currency = "HUF";
        } elseif(str_contains($currency_and_tution_fee, 'ISK')){
            $tution_fee_currency = "ISK";
        } elseif(str_contains($currency_and_tution_fee, 'IDR')){
            $tution_fee_currency = "IDR";
        } elseif(str_contains($currency_and_tution_fee, 'IRR')){
            $tution_fee_currency = "IRR";
        } elseif(str_contains($currency_and_tution_fee, 'IMP')){
            $tution_fee_currency = "IMP";
        } elseif(str_contains($currency_and_tution_fee, 'ILS')){
            $tution_fee_currency = "ILS";
        } elseif(str_contains($currency_and_tution_fee, 'JMD')){
            $tution_fee_currency = "JMD";
        } elseif(str_contains($currency_and_tution_fee, 'JEP')){
            $tution_fee_currency = "JEP";
        } elseif(str_contains($currency_and_tution_fee, 'KZT')){
            $tution_fee_currency = "KZT";
        } elseif(str_contains($currency_and_tution_fee, 'KPW')){
            $tution_fee_currency = "KPW";
        } elseif(str_contains($currency_and_tution_fee, 'KRW')){
            $tution_fee_currency = "KRW";
        } elseif(str_contains($currency_and_tution_fee, 'KGS')){
            $tution_fee_currency = "KGS";
        } elseif(str_contains($currency_and_tution_fee, 'LAK')){
            $tution_fee_currency = "LAK";
        } elseif(str_contains($currency_and_tution_fee, 'LBP')){
            $tution_fee_currency = "LBP";
        } elseif(str_contains($currency_and_tution_fee, 'LRD')){
            $tution_fee_currency = "LRD";
        } elseif(str_contains($currency_and_tution_fee, 'MKD')){
            $tution_fee_currency = "MKD";
        } elseif(str_contains($currency_and_tution_fee, 'MYR')){
            $tution_fee_currency = "MYR";
        } elseif(str_contains($currency_and_tution_fee, 'MUR')){
            $tution_fee_currency = "MUR";
        } elseif(str_contains($currency_and_tution_fee, 'MXN')){
            $tution_fee_currency = "MXN";
        } elseif(str_contains($currency_and_tution_fee, 'MNT')){
            $tution_fee_currency = "MNT";
        } elseif(str_contains($currency_and_tution_fee, 'MZN')){
            $tution_fee_currency = "MZN";
        } elseif(str_contains($currency_and_tution_fee, 'NAD')){
            $tution_fee_currency = "NAD";
        } elseif(str_contains($currency_and_tution_fee, 'NPR')){
            $tution_fee_currency = "NPR";
        } elseif(str_contains($currency_and_tution_fee, 'ANG')){
            $tution_fee_currency = "ANG";
        } elseif(str_contains($currency_and_tution_fee, 'NZD')){
            $tution_fee_currency = "NZD";
        } elseif(str_contains($currency_and_tution_fee, 'NIO')){
            $tution_fee_currency = "NIO";
        } elseif(str_contains($currency_and_tution_fee, 'NGN')){
            $tution_fee_currency = "NGN";
        } elseif(str_contains($currency_and_tution_fee, 'NOK')){
            $tution_fee_currency = "NOK";
        } elseif(str_contains($currency_and_tution_fee, 'OMR')){
            $tution_fee_currency = "OMR";
        } elseif(str_contains($currency_and_tution_fee, 'PKR')){
            $tution_fee_currency = "PKR";
        } elseif(str_contains($currency_and_tution_fee, 'PAB')){
            $tution_fee_currency = "PAB";
        } elseif(str_contains($currency_and_tution_fee, 'PYG')){
            $tution_fee_currency = "PYG";
        } elseif(str_contains($currency_and_tution_fee, 'PEN')){
            $tution_fee_currency = "PEN";
        } elseif(str_contains($currency_and_tution_fee, 'PHP')){
            $tution_fee_currency = "PHP";
        } elseif(str_contains($currency_and_tution_fee, 'PLN')){
            $tution_fee_currency = "PLN";
        } elseif(str_contains($currency_and_tution_fee, 'QAR')){
            $tution_fee_currency = "QAR";
        } elseif(str_contains($currency_and_tution_fee, 'RON')){
            $tution_fee_currency = "RON";
        } elseif(str_contains($currency_and_tution_fee, 'RUB')){
            $tution_fee_currency = "RUB";
        } elseif(str_contains($currency_and_tution_fee, 'SHP')){
            $tution_fee_currency = "SHP";
        } elseif(str_contains($currency_and_tution_fee, 'SAR')){
            $tution_fee_currency = "SAR";
        } elseif(str_contains($currency_and_tution_fee, 'RSD')){
            $tution_fee_currency = "RSD";
        } elseif(str_contains($currency_and_tution_fee, 'SCR')){
            $tution_fee_currency = "SCR";
        } elseif(str_contains($currency_and_tution_fee, 'SBD')){
            $tution_fee_currency = "SBD";
        } elseif(str_contains($currency_and_tution_fee, 'SOS')){
            $tution_fee_currency = "SOS";
        } elseif(str_contains($currency_and_tution_fee, 'KRW')){
            $tution_fee_currency = "KRW";
        } elseif(str_contains($currency_and_tution_fee, 'ZAR')){
            $tution_fee_currency = "ZAR";
        } elseif(str_contains($currency_and_tution_fee, 'LKR')){
            $tution_fee_currency = "LKR";
        } elseif(str_contains($currency_and_tution_fee, 'CHF')){
            $tution_fee_currency = "CHF";
        } elseif(str_contains($currency_and_tution_fee, 'SRD')){
            $tution_fee_currency = "SRD";
        } elseif(str_contains($currency_and_tution_fee, 'SYP')){
            $tution_fee_currency = "SYP";
        } elseif(str_contains($currency_and_tution_fee, 'TWD')){
            $tution_fee_currency = "TWD";
        } elseif(str_contains($currency_and_tution_fee, 'THB')){
            $tution_fee_currency = "THB";
        } elseif(str_contains($currency_and_tution_fee, 'TTD')){
            $tution_fee_currency = "TTD";
        } elseif(str_contains($currency_and_tution_fee, 'TRY')){
            $tution_fee_currency = "TRY";
        } elseif(str_contains($currency_and_tution_fee, 'TVD')){
            $tution_fee_currency = "TVD";
        } elseif(str_contains($currency_and_tution_fee, 'UAH')){
            $tution_fee_currency = "UAH";
        } elseif(str_contains($currency_and_tution_fee, 'UYU')){
            $tution_fee_currency = "UYU";
        } elseif(str_contains($currency_and_tution_fee, 'UZS')){
            $tution_fee_currency = "UZS";
        } elseif(str_contains($currency_and_tution_fee, 'VEF')){
            $tution_fee_currency = "VEF";
        } elseif(str_contains($currency_and_tution_fee, 'VND')){
            $tution_fee_currency = "VND";
        } elseif(str_contains($currency_and_tution_fee, 'YER')){
            $tution_fee_currency = "YER";
        } elseif(str_contains($currency_and_tution_fee, 'ZWD')){
            $tution_fee_currency = "ZWD";
        } elseif (str_contains($currency_and_tution_fee, '$') || str_contains($currency_and_tution_fee, 'USD')){
            $tution_fee_currency = "USD";
        } else{
            $tution_fee_currency = "";
        }

        return $tution_fee_currency;
    }
}

if(!function_exists('get_utf8_string')) {
    function get_utf8_string($string) {
    // Log::debug("Import course : ".$string);
        if(mb_detect_encoding($string)){
            $result = mb_convert_encoding($string, 'UTF-8', mb_detect_encoding($string));
        } else{
            $result = mb_convert_encoding($string, 'UTF-8', 'ISO-8859-1');
        }
        if(!$result) {
            $result = $string;
        }
        return $result;
    }
}

if(!function_exists('get_currency_symbol')) {
    function get_currency_symbol($code) {
        // $symbol = DB::table('currency')->where('currency_code', $code)->first();
        // if($symbol){
        //     return $symbol->currency_symbol;
        // }else{
        //     return "";
        // }
        $cur = Country::where('currency', $code)->first();
            if($cur && $cur->code){
                $code = 'en_'.$cur->code;
                $CS = new NumberFormatter($code, NumberFormatter::CURRENCY);
                $CS = $CS->getSymbol(NumberFormatter::CURRENCY_SYMBOL);
                return $CS;
            }
            return "?";
    }
}


function _label($label) {

    //fetch & return the 'custom_text' value for the passed 'label' from the 'custom_labels' table
    
    $label = DB::table('custom_labels')->where('label', $label)->first(['default_text','custom_text']);
    if($label){
        if($label->custom_text){
            return $label->custom_text;
        }
        return $label->default_text;
    }
    else{
        return "";
    }
    
}

if (!function_exists('get_course_by_id')) {

    function get_course_by_id($course_id)
    {
        $course = Course::Where('id', $course_id)->first();
        if($course){
            return $course->title;
        }
        return "-";
    }
}

if (!function_exists('get_service_application_status_color')) {

    function get_service_application_status_color($status,$id)
    {
        $status = DB::table('service_stages')->where("status_name", $status)->where("service_id", $id)->first(['color']);
        if ($status) {
            return $status->color;
        } else {
            return "#F92982";
        }
    }
}

if (!function_exists('email_delay')) {
    function email_delay()
    {
        $delay_seconds_per_email = (60 * 60) / get_site_config('bulk_smtp_limit_hourly');
        $pending_emails = DB::table('jobs')->count();
        $delay_total_sec = round($pending_emails * $delay_seconds_per_email);
        return $delay_total_sec;
    }
}

if (!function_exists('get_student_count_for_webinar')) {
    function get_student_count_for_webinar($id)
    {
        $webinar_count = DB::table('student_webinar')->where('webinar_id', $id)->count();
        if($webinar_count){
            return $webinar_count;
        } else{
            return "--";
        }
    }
}

if (!function_exists('user_notify')) {
    function user_notify($user, $subject, $message, $cc = NULL, $attachments = NULL)
    {
        if(env('SAAS_MAIL_SERVER') && Activity::where('event', 'email')->where('created_at', 'like', date("Y-m-").'%')->count() >= env('MONTHLY_EMAIL_LIMIT')) {
            \Log::error("ERROR!!!!! MONTHLY_EMAIL_LIMIT Reached!");
            return;
        }

        if (is_object($user)) {
            $user_email = $user->email;
        }else{
            $user_email = $user;
        }

        if(get_site_config('smtp_type')== 'google'){
            $mail = new Gmail(null, false, 1);
            $mail->to($user_email, $name = null );
            $mail->cc($cc, $name = null );
            $mail->from(get_site_config('google_email_id'), get_site_config('google_email_from_name'));
            $mail->subject($subject);
            $mail->message($message);
            if($attachments){
                foreach ($attachments as $file){
                    $mail->attach(storage_path()."/app/public/email_attachments/".$file);
                }
            }
            $mail->view('email.default',['content'=>$message]);
            $msgs = $mail->send();
            \Log::debug("user_notify - Sending Mail from Gmail API. TO:".$user_email." SUBJECT:".$subject); 
            activity()->event('email')->log('Email sent To: '.$user_email. ' Subject: '.$subject);
            return "Sent!";
        }
        if(get_site_config('smtp_type')== 'smtp_server'){
            // SMTP from Settings
            if (is_object($user)) {
                $user->notify(new UserAlert($subject, $message,$cc, $attachments));
            }else{
                Mail::to($user_email)
                ->cc($cc)
                ->send(new MailSend($subject, $message));
            }
            
            \Log::debug("user_notify - Sending Mail from SMTP_server. TO:".$user_email." SUBJECT:".$subject); 
            activity()->event('email')->log('Email sent To: '.$user_email. ' Subject: '.$subject);

        }
    }
}

if (!function_exists('notify_student')) {
    function notify_student($user,$subject,$message,$attachments = NULL){

        if(get_site_config('smtp_type')== 'google'){

            if(env('SAAS_MAIL_SERVER') && Activity::where('event', 'email')->where('created_at', 'like', date("Y-m-").'%')->count() >= env('MONTHLY_EMAIL_LIMIT')) {
                \Log::error("ERROR!!!!! MONTHLY_EMAIL_LIMIT Reached!");
                return;
            }            

            $mail = new Gmail(null, false, 1);
            $mail->to($user->email, $name = null );
            $mail->from(get_site_config('google_email_id'), get_site_config('google_email_from_name'));
            $mail->subject($subject);
            $mail->message($message);
            if($attachments){
                foreach ($attachments as $file){
                    $mail->attach(storage_path()."/app/public/email_attachments/".$file);
                }
            }
            $mail->view( 'email.default',['content'=>$message]);
            $msgs = $mail->send();
            activity()->event('email')->log('Email sent To: '.$user->email. ' Subject: '.$subject);
            return "Sent!";
        }

        //check if staff has custom SMTP
        // $smtpdata = DB::table('staff_details')->where('staff_id',auth()->user()->id)->first();
        $smtpdata = DB::table('staff_details')->where('staff_id',auth()->user()->id)->where('email_integration',1)->first();
        //check if student branch has custom SMTP
        $branch = DB::table('branch')->where("id", $user->branch)->first();
        if(isset($smtpdata) && $smtpdata->id && get_site_config('smtp_type')== 'smtp_server'){
            $staff = DB::table('users')->where('id',$smtpdata->staff_id)->first();
            \Config::set('mail.mailers.smtp.transport','smtp');
            \Config::set('mail.mailers.smtp.host',$smtpdata->smtp_host);
            \Config::set('mail.mailers.smtp.port',$smtpdata->smtp_port);
            \Config::set('mail.mailers.smtp.encryption',$smtpdata->smtp_encryption);
            \Config::set('mail.mailers.smtp.username',$smtpdata->smtp_username);
            \Config::set('mail.mailers.smtp.password',$smtpdata->smtp_password);
            \Config::set('mail.mailers.smtp.from.address',$smtpdata->smtp_username);
            \Config::set('mail.mailers.smtp.from.name',$staff->first_name.' '.$staff->last_name);
            \Config::set('mail.mailers.smtp.reply_to',$staff->email);
            \Log::debug("notify_student - Sending Mail from Staff SMTP. Staff ID: ".auth()->user()->id." TO:".$user->email." SUBJECT:".$subject); 
            //$user->notify(new UserAlert($subject, $message,"", $attachments));
            user_notify($user, $subject, $message,"",$attachments);
        } elseif($branch->custom_smtp){
            $smtpHost = $branch->smtp_host;
            $smtpPort = $branch->smtp_port;
            $smtpEnc = $branch->smtp_connection;
            $smtpUser = $branch->smtp_email;
            $smtpPass = $branch->smtp_password;
            $smtpReplyTo = $branch->smtp_reply_to;
            //$mail_from = ($branch->smtp_from_name) ? $branch->smtp_from_name : get_site_config('app_name');
            $mail_from = $branch->smtp_from_name;
            if (isset($smtpHost) && isset($smtpUser) && isset($smtpPass) && isset($smtpPort) && isset($smtpEnc)){
                \Config::set('mail.mailers.smtp.transport','smtp');
                \Config::set('mail.mailers.smtp.host',$smtpHost);
                \Config::set('mail.mailers.smtp.port',$smtpPort);
                \Config::set('mail.mailers.smtp.encryption',$smtpEnc);
                \Config::set('mail.mailers.smtp.username',$smtpUser);
                \Config::set('mail.mailers.smtp.password',$smtpPass);
                \Config::set('mail.mailers.smtp.from.address',$smtpUser);
                \Config::set('mail.mailers.smtp.from.name',$mail_from);
                \Config::set('mail.mailers.smtp.reply_to',$smtpReplyTo);
            }
            \Log::debug("notify_student - Sending Mail from Branch SMTP: Branch ID: ".$user->branch." TO:".$user->email." SUBJECT:".$subject); 
            //$user->notify(new UserAlert($subject, $message,"", $attachments));
            user_notify($user, $subject, $message,"",$attachments);
        } else{
            //Sending email with Default DB smtp details
            // $smtpHost = get_site_config('smtp_host');
            // $smtpPort = get_site_config('smtp_port');
            // $smtpEnc = get_site_config('smtp_connection');
            // $smtpUser = get_site_config('smtp_email');
            // $smtpPass = get_site_config('smtp_password');
            // $smtpReplyTo = get_site_config('smtp_reply_to');
            // $mail_from = get_site_config('app_name');
            // if (isset($smtpHost) && isset($smtpUser) && isset($smtpPass) && isset($smtpPort) && isset($smtpEnc)){
            //     \Config::set('mail.mailers.smtp.transport','smtp');
            //     \Config::set('mail.mailers.smtp.host',$smtpHost);
            //     \Config::set('mail.mailers.smtp.port',$smtpPort);
            //     \Config::set('mail.mailers.smtp.encryption',$smtpEnc);
            //     \Config::set('mail.mailers.smtp.username',$smtpUser);
            //     \Config::set('mail.mailers.smtp.password',$smtpPass);
            //     \Config::set('mail.mailers.smtp.from.address',$smtpUser);
            //     \Config::set('mail.mailers.smtp.from.name',$mail_from);
            //     \Config::set('mail.mailers.smtp.reply_to',$smtpReplyTo);
            // }
            \Log::debug("notify_student - Sending Mail from GLOBAL SMTP. TO:".$user->email." SUBJECT:".$subject);
            //$user->notify(new UserAlert($subject, $message,"", $attachments));
            user_notify($user, $subject, $message,"",$attachments);
            
        }
    }
}

if (!function_exists('get_lead_source_detail')) {
    function get_lead_source_detail($id)
    {
        $user_details = DB::table('user_details')->where('userid', $id)->first();
        if($user_details){
            if(strlen($user_details->lead_source_detail) > 30){
                return substr($user_details->lead_source_detail, 0, 30)."...";
            } else{
                return $user_details->lead_source_detail;
            }
        } else{
            return "--";
        }
    }
}

if(!function_exists('print_memory_usage')) {
    function print_memory_usage(){
        $mem_usage = memory_get_usage();
        $mem_peak = memory_get_peak_usage();
        \Log::debug('The script is now using: ' . round($mem_usage / 1024 /1024) . 'MB of memory.');
        \Log::debug('Peak usage: ' . round($mem_peak / 1024 /1024) . 'MB of memory.');
    }
}

if(!function_exists('get_webinar_name')) {
    function get_webinar_name($id){
        $webinar = DB::table('webinar')->where('id', $id)->first();
        if($webinar){
            return $webinar->topic;
        } else{
            return "--";
        }
    }
}

if(!function_exists('get_ticket_name')) {
    function get_ticket_name($id){
        $tickets = DB::table('tickets')->where('ticket_id', $id)->first();
        if($tickets){
            return $tickets->subject;
        } else{
            return "--";
        }
    }
}

if(!function_exists('get_invoice_num')) {
    function get_invoice_num($id){
        $invoice = DB::table('invoice')->where('id', $id)->first();
        if($invoice){
            return $invoice->invoice_num;
        } else{
            return "--";
        }
    }
}

if(!function_exists('get_staff_leaves')) {
    function get_staff_leaves($id){
        $staff_leaves = DB::table('staff_leaves')->where('id', $id)->first();
        if($staff_leaves){
            return $staff_leaves->reason;
        } else{
            return "--";
        }
    }
}

if(!function_exists('is_staff_agent')) {
    function is_staff_agent($userid) {
        $user = User::find($userid);
        if($user->hasRole('agent')) {
            return true;
        }
        return false;
    }
}

if (!function_exists('get_agent_business_logo')) {
    function get_agent_business_logo($agent_id)
    {
        $agent_details = AgentDetails::where('agent_id', $agent_id)->first();
        if($agent_details){
            if($agent_details->logo_approved && $agent_details->agent_panel_logo){
                return $agent_details->agent_panel_logo;
            }
        } else{
            return "";
        }
    }
}

if (!function_exists('check_email_sync_accounts')) {
    function check_email_sync_accounts()
    {
        $accounts = DB::table('mail_sync_accounts')->count();
        if($accounts){
            return true;
        } else{
            return false;
        }
    }
}


if (!function_exists('lead_status_list_as_array')) {
    function lead_status_list_as_array()
    {
        $status = DB::table('lead_status')->orderBy("display_order", 'ASC')->get();
        $lead_status = array();
        if($status){
            foreach(lead_status_list() as $status_data){
                $lead_status[] = $status_data->status;
            }
            return $lead_status; 
        }

        return [];
    }
}

if(!function_exists('get_country_code_by_name')) {
    function get_country_code_by_name($name) {
        if($name) {
            $country = DB::table('countries')->where('title_en', '=', $name)->first(['code']);
            if($country){
                return strtolower($country->code);
            }
            else{
                return "IN";
            }
        } else {
            return $name;
        }
    }
}

if(!function_exists('get_country_code_by_dialcode')) {
    function get_country_code_by_dialcode($dialcode) {
        $country = DB::table('countries')->where('tel', '=', $dialcode)->first();
        if($country){
            return $country->code;
        }
        return env('USER_DEFAULT_COUNTRY_CODE');
    }
}

if(!function_exists('generate_refcode')) {
    function generate_refcode($firstname) {
        \Log::debug("generate_refcode($firstname)");
        $firstname = strtoupper($firstname);
        $code = preg_replace('/[^A-Z]+/', '', $firstname);
        if(strlen($code) > 4) {
            $code = substr($code, 0,4);    
        }
        $rand = rand(10,99);
        $refcode = $code . $rand;
        while(DB::table('users')->where('refcode', $refcode)->exists()) {
            \Log::debug("generate_refcode() CheckifExists:".$refcode);
            $refcode = $code . ($rand++);
        }
        \Log::debug("generate_refcode() Return:".$refcode);
        return $refcode;
    }
}

// if(!function_exists('get_users_list')) {
//     function get_users_list($exclude_user = NULL) {
//             $users = User::with('roles')
//             ->active()
//             ->where('is_lead',0)
//             ->whereHas('roles', function ($q) {
//                 $q->whereIn('name', ['user']);
//             })
//             ->when(!empty($exclude_user), function ($query) use ($exclude_user) {
//                 return $query->where('id',"!=",$exclude_user);
//             })
//             ->select('id', DB::raw("concat(COALESCE(`first_name`,''), ' ', COALESCE(`last_name`,''), ' (', id, ') ') as text"))
//             ->get();
//             return $users;      
//         }
// }

if (!function_exists('get_user_payment_mode')) {
    function get_user_payment_mode($id)
    {
        $user_details = DB::table('user_details')->where('userid', $id)->first();
        if($user_details && $user_details->payment_pref_mode){
            return $user_details->payment_pref_mode;
        } else{
            return "--";
        }
    }
}

if (!function_exists('get_user_payment_details')) {
    function get_user_payment_details($id)
    {
        $user_details = DB::table('user_details')->where('userid', $id)->first();
        if($user_details && $user_details->payment_pref_detail){
            return $user_details->payment_pref_detail;
        } else{
            return "--";
        }
    }
}

if (!function_exists('get_referrals_count')) {
    function get_referrals_count($referer_id,$reff_month=NULL)
    {
        // $month = explode("-", $reff_month);
        // $year = $month[0];
        // $month = $month[1];
        
        $referrals = DB::table('referral_commission')
        ->where('user_id', $referer_id)
        ->when(!empty($reff_month), function ($query) use ($reff_month) {
            $month = explode("-", $reff_month);
            $year = $month[0];
            $month = $month[1];
            $query->whereYear('referral_commission.created_at', '=', $year)
            ->whereMonth('referral_commission.created_at', '=', $month);
            return  $query;
        })
        ->where('paid',0)->count();
        return $referrals;
        
    }
}

if (!function_exists('check_referral')) {
    function check_referral($referer_id,$user_id)
    {
        $referrals = DB::table('referral_commission')
        ->where('user_id', $referer_id)
        ->where('student_id', $user_id)
        //->where('paid',0)
        ->count();
        return $referrals; 
    }
}

if (!function_exists('get_university_id_by_name')) {
    function get_university_id_by_name($name)
    {
        $rtr = DB::table('universities')->where('university_name',$name)->first();
        if($rtr){
            return $rtr->id;
        }
        else{
            return false;
        }
    }
}

if (!function_exists('get_course_details_by_pref_id')) {
    function get_course_details_by_pref_id($course_pref_id)
    {
        $prefData = DB::table('course_preference')->where("id", $course_pref_id)->where("course_id","!=","")->first(['course_id']);
        if($prefData){
            $courseData = DB::table('university_courses')->where("id", $prefData->course_id)->first(['total_tuition_fee','currency']);
        }
        if($courseData){
            return $courseData;
        }
        return false;
    }
}

if (!function_exists('get_user_sid_by_id')) {
    function get_user_sid_by_id($user_id)
    {
        $row = DB::table('users')->where("id", $user_id)->first();
        if ($row) {
            return $row->sid;
        }
        return "";
    }
}


if (!function_exists('get_total_uni_invoice_payment')) {

    function get_total_uni_invoice_payment($invoice_id)
    {
        $amount = DB::table('uni_invoice_payment')->where("invoice_id", $invoice_id)->sum('amount');
        return $amount;
    }
}

if(!function_exists('get_uni_apply_agent_name_by_id')) {
    function get_uni_apply_agent_name_by_id($id) {
        $agent = DB::table('uni_apply_agents')->where('id', $id)->first();
        if($agent){
            return $agent->name;
        }
        return "--";
    }
} 

if (!function_exists('currency_convert')) {
    function currency_convert($amount, $from, $to)
    {
        if ($from == $to) {
            return round($amount, 2);
        }
        $rate_from = Country::where('currency', $from)->value('rate');
        if($rate_from && $amount){
            $amount_base = $amount / $rate_from;
        } else{
            $amount_base = $amount;
        }
        $rate_to = Country::where('currency', $to)->value('rate');
        $amount_to = $amount_base * $rate_to;
        return round($amount_to, 2);
    }
}

if(!function_exists('get_currency_by_user_country')) {
    function get_currency_by_user_country($user_id) {
        $user = DB::table('users')->where('id', $user_id)->first();
        if($user){
            $currency = DB::table('countries')->where('id', $user->country)->first(['currency']);
            if($currency){
                return $currency->currency;
            }else{
                return NULL;
            }
        }
        
    }
}

if (!function_exists('get_student_signature')) {
    function get_student_signature($user_id)
    {
        $user_detail = UserDetails::where('userid', $user_id)->first();
        if($user_detail->student_signature)
            return $user_detail->student_signature;
        else
            return "";
    }
}

if(!function_exists('get_amount_in_words')) {
    function get_amount_in_words(float $amount)
    {
        $digit = new NumberFormatter("en", NumberFormatter::SPELLOUT);
        return ucwords($digit->format($amount));

        $amount_after_decimal = round($amount - ($num = floor($amount)), 2) * 100;
        // Check if there is any number after decimal
        $amt_hundred = null;
        $count_length = strlen($num);
        $x = 0;
        $string = array();
        $change_words = array(0 => '', 1 => 'One', 2 => 'Two',
            2 => 'Three', 4 => 'Four', 5 => 'Five', 6 => 'Six',
            7 => 'Seven', 8 => 'Eight', 9 => 'Nine',
            10 => 'Ten', 11 => 'Eleven', 12 => 'Twelve',
            13 => 'Thirteen', 14 => 'Fourteen', 15 => 'Fifteen',
            16 => 'Sixteen', 17 => 'Seventeen', 18 => 'Eighteen',
            19 => 'Nineteen', 20 => 'Twenty', 30 => 'Thirty',
            40 => 'Forty', 50 => 'Fifty', 60 => 'Sixty',
            70 => 'Seventy', 80 => 'Eighty', 90 => 'Ninety');
            $here_digits = array('', 'Hundred','Thousand','Lakh', 'Crore');
            while( $x < $count_length ) {
            $get_divider = ($x == 2) ? 10 : 100;
            $amount = floor($num % $get_divider);
            $num = floor($num / $get_divider);
            $x += $get_divider == 10 ? 1 : 2;
            if ($amount) {
            $add_plural = (($counter = count($string)) && $amount > 9) ? 's' : null;
            $amt_hundred = ($counter == 1 && $string[0]) ? ' and ' : null;
            $string [] = ($amount < 21) ? $change_words[$amount].' '. $here_digits[$counter]. $add_plural.' 
            '.$amt_hundred:$change_words[floor($amount / 10) * 10].' '.$change_words[$amount % 10]. ' 
            '.$here_digits[$counter].$add_plural.' '.$amt_hundred;
                }
        else $string[] = null;
        }
        $implode_to_Rupees = implode('', array_reverse($string));
        $get_paise = ($amount_after_decimal > 0) ? "And " . ($change_words[$amount_after_decimal / 10] . " 
        " . $change_words[$amount_after_decimal % 10]) : '';
        return ($implode_to_Rupees ? $implode_to_Rupees : '') . $get_paise;
    }
}

if(!function_exists('get_all_tags')) {
    function get_all_tags() {
        $tags = Tags::get();
            return $tags;
        }
}

if(!function_exists('get_canned_templates')) {
    function get_canned_templates() {
        return DB::table('canned_responses')->where('status', 1)->orderByDesc('created_at')->pluck('hook');
    }
}

if (!function_exists('get_business_details')) {
    function get_business_details($business_id)
    {
        $business_details = BusinessConfigs::where('id', $business_id)->first();
        if($business_details){
            return $business_details;
        } else{
            return NULL;
        }
    }
}

if (!function_exists('get_business_list')) {
    function get_business_list()
    {
        $business = BusinessConfigs::orderBy('name', 'ASC')->get();
        if($business){
                return $business;
        } else{
            return "";
        }
    }
}

if(!function_exists('get_app_apply_through')) {
    function get_app_apply_through() {
        $uni_apply_agents = DB::table('uni_apply_agents')->get();
        if($uni_apply_agents) return $uni_apply_agents;
        else (object)[];
    }
}

if(!function_exists('get_all_services')) {
    function get_all_services($service_id, $html = true) {
        $services = DB::table('services')->whereIn('id', $service_id)->get();
        $all_services = "";
        if($services){
            foreach($services as $service){
                if($html){
                    $all_services .= "<span class='tagSuccess mb-1'>" . $service->service_name . "</span>";
                } else{
                    $all_services .= $service->service_name . ", ";
                }
            }

            return $all_services;
        }
        return "--";
    }
}

if(!function_exists('menu_items')) {
    function menu_items() 
    {
        $menu_details = array();
        
        if(config('app.product_code') == 'TRAINING') {
            $main_menus = Posts::Select('id', 'title', 'menu_title', 'slug')
            ->where('status', '=', 1)
            ->where('show_in_main_menu', '=', 1)
            ->where(function ($query) {
                $query->Where('module_type', '<>', "home")
                    ->Where('module_type', '<>', "country")
                    ->orWhere('module_type', NULL);
            })
            ->orderBy('order')
            ->get();
        } else if(config('app.product_code') == 'OVERSEAS') {
            $main_menus = Posts::Select('id', 'title', 'menu_title', 'slug')
            ->where('status', '=', 1)
            ->where('show_in_main_menu', '=', 1)
            ->where(function ($query) {
                $query->Where('module_type', '<>', "home")
                    ->Where('module_type', '<>', "coaching")
                    ->Where('module_type', '<>', "courses")
                    ->orWhere('module_type', NULL);
            })
            ->orderBy('order')
            ->get();

        } else {
            $main_menus = Posts::Select('id', 'title', 'menu_title', 'slug')
            ->where('status', '=', 1)
            ->where('show_in_main_menu', '=', 1)
            ->where(function ($query) {
                $query->Where('module_type', '<>', "home")
                    ->orWhere('module_type', NULL);
            })
            ->orderBy('order')
            ->get();
        }

        foreach ($main_menus as $main_menu) {
            $menu_title = $main_menu['menu_title'] != '' ? $main_menu['menu_title'] : $main_menu['title'];
            $menu_details[$menu_title] =  route('frontend.view-article', [$main_menu['slug']]);
        }
        return $menu_details;
    }
}

if(!function_exists('get_country_by_state_id')) {
    function get_country_by_state_id($state_id) {
        $country = DB::table('states')->where('id', $state_id)->first();

        if($country){
            return $country->country_id;
        } else{
            return "";
        }
    }
}


if(!function_exists('get_filename_formated')) {
    function get_filename_formated($data) {
        if($data!=''){
            $filename = basename($data);
            $extension = pathinfo($filename, PATHINFO_EXTENSION);
            $nameWithoutExt = pathinfo($filename, PATHINFO_FILENAME);
            $shortenedName = (strlen($nameWithoutExt) > 30) ? substr($nameWithoutExt, 0, 20) . '' : $nameWithoutExt;
            $finalFilename = $shortenedName . '.' . $extension;
            return   $finalFilename;
        }
        else{
            return "--";
        }
    }
}
if (!function_exists('get_agent_commission_percentage')) {
    function get_agent_commission_percentage($agent_id)
    {
        $agent_details = AgentDetails::where('agent_id', $agent_id)->first(['commission_percent']);
        if($agent_details){
            return $agent_details->commission_percent;
        } else{
            return 0;
        }
    }
}

if(!function_exists('get_employee_designation')) {
    function get_employee_designation() {
        $sources = get_site_config('employee_designation');
        return array_map('trim', explode('|', $sources));
    }
}

if(!function_exists('get_employee_department')) {
    function get_employee_department() {
        $sources = get_site_config('employee_department');
        return array_map('trim', explode('|', $sources));
    }
}

if(!function_exists('get_employee_type')) {
    
    function get_employee_type() {
        $sources = get_site_config('employee_type');
        
        return array_map('trim', explode('|', $sources));
    }
}
if(!function_exists('get_employee_status')) {
  
    function get_employee_status() {
        $sources = get_site_config('employee_status');
        return array_map('trim', explode('|', $sources));
    }
}
if(!function_exists('get_onboarding_status')) {
  
    function get_onboarding_status() {
        $sources = get_site_config('onboarding_status');
        return array_map('trim', explode('|', $sources));
    }
}

