<?php

return [

    //demo-specific
    'demo_users' => [1, 1724, 1725, 1726, 1727, 1728,1729,1730,1731,1732,1733,1734,1735,1736,1737,1738,1739,1740,1741,1742,1743,1744,1745,1746,1785],
    'restricted_roles' => [1, 3, 8, 9, 13, 14],

    /*
    |--------------------------------------------------------------------------
    | Application Name
    |--------------------------------------------------------------------------
    |
    | This value is the name of your application. This value is used when the
    | framework needs to place the application's name in a notification or
    | any other location as required by the application or its packages.
    |
    */

    'name' => env('APP_NAME', 'EduCtrl'),

    /*
    |--------------------------------------------------------------------------
    | Application Environment
    |--------------------------------------------------------------------------
    |
    | This value determines the "environment" your application is currently
    | running in. This may determine how you prefer to configure various
    | services the application utilizes. Set this in your ".env" file.
    |
    */

    'env' => env('APP_ENV', 'production'),

    /*
    |--------------------------------------------------------------------------
    | Application Debug Mode
    |--------------------------------------------------------------------------
    |
    | When your application is in debug mode, detailed error messages with
    | stack traces will be shown on every error that occurs within your
    | application. If disabled, a simple generic error page is shown.
    |
    */

    'debug' => (bool) env('APP_DEBUG', true),

    /*
    |--------------------------------------------------------------------------
    | Application URL
    |--------------------------------------------------------------------------
    |
    | This URL is used by the console to properly generate URLs when using
    | the Artisan command line tool. You should set this to the root of
    | your application so that it is used when running Artisan tasks.
    |
    */

    'url' => env('APP_URL', 'http://localhost'),

    'asset_url' => env('ASSET_URL', null),

    /*
    |--------------------------------------------------------------------------
    | Application Timezone
    |--------------------------------------------------------------------------
    |
    | Here you may specify the default timezone for your application, which
    | will be used by the PHP date and date-time functions. We have gone
    | ahead and set this to a sensible default for you out of the box.
    |
    */

    'timezone' => env('APP_TIMEZONE'), //'UTC',

    /*
    |--------------------------------------------------------------------------
    | Application Locale Configuration
    |--------------------------------------------------------------------------
    |
    | The application locale determines the default locale that will be used
    | by the translation service provider. You are free to set this value
    | to any of the locales which will be supported by the application.
    |
    */

    'locale' => 'en',

    /*
    |--------------------------------------------------------------------------
    | Application Fallback Locale
    |--------------------------------------------------------------------------
    |
    | The fallback locale determines the locale to use when the current one
    | is not available. You may change the value to correspond to any of
    | the language folders that are provided through your application.
    |
    */

    'fallback_locale' => 'en',

    /*
    |--------------------------------------------------------------------------
    | Faker Locale
    |--------------------------------------------------------------------------
    |
    | This locale will be used by the Faker PHP library when generating fake
    | data for your database seeds. For example, this will be used to get
    | localized telephone numbers, street address information and more.
    |
    */

    'faker_locale' => 'en_US',

    /*
    |--------------------------------------------------------------------------
    | Encryption Key
    |--------------------------------------------------------------------------
    |
    | This key is used by the Illuminate encrypter service and should be set
    | to a random, 32 character string, otherwise these encrypted strings
    | will not be safe. Please do this before deploying an application!
    |
    */

    'key' => env('APP_KEY'),

    'cipher' => 'AES-256-CBC',

    //Cofigurations
    'api_key' => env('API_KEY', ''),

    'product_code' => env('PRODUCT_CODE'),
    'staff_limit' => env('STAFF_LIMIT', 4),
    // 'agent_enabled' => env('AGENT_ENABLED', false),
    
    'USER_DEFAULT_DIALCODE' => env('USER_DEFAULT_DIALCODE', 91),
    'USER_DEFAULT_COUNTRY' => env('USER_DEFAULT_COUNTRY', 101),

    'USER_MOBILE_MIN_LENGTH' => env('USER_MOBILE_MIN_LENGTH', 10),
    'USER_MOBILE_MAX_LENGTH' => env('USER_MOBILE_MAX_LENGTH', 10),

    'currency' => env('APP_CURRENCY', 'USD'),
    'currency_symbol' => env('APP_CURRENCY_SYMBOL', '$'),

    'doc_single_max_size' => env('DOC_SINGLE_MAX_SIZE', 2),
    'doc_allsem_max_size' => env('DOC_ALLSEM_MAX_SIZE', 8),
    'max_sop_files' => env('MAX_SOP_FILES', 5),
    'max_lor_files' => env('MAX_LOR_FILES', 3),
    'max_pass_files' => env('MAX_PASS_FILES', 3),
    'max_experience_files' => env('MAX_EXPERIENCE_FILES', 6),
    'max_other_files' => env('MAX_OTHER_FILES', 6),

    'staff_doc_max_size' => env('STAFF_DOC_MAX_SIZE', 5),

    'notification_refresh_interval' => env('NOTIFICATION_REFRESH_INTERVAL', 30),
    
    'lead_attributes' => [
        'first_name' => 'First name*',
        'last_name' => 'Last name',
        'campaign_id' => 'Campaign ID',
        'email' => 'Email ID*',        
        'dialcode' => 'Dialcode',
        'mobile' => 'Mobile No.',        
        'gender' => 'Gender',
        'birthday' => 'Date of birth',
        'country_interested' => 'Country Interested to Study In',
        'overseas_study_level' => 'Interested Study Level',
        // 'course' => 'Course Interested',
        'passout_year' => 'Passout Year',        
        'student_type' => 'Lead Type',
        'lead_source' => 'Lead Source',
        'lead_source_detail' => 'Lead Source Details',
        'alternate_contact' => 'Alternate Phone',
        'address' => 'Address',
        'country' => 'Residence Country',
        'state' => 'State',
        'city' => 'City',
        'highest_level_education' => 'Qualification',
        'last_followup' => 'Last followup date',
        'next_followup' => 'Next Followup date',        
        'lead_status' => 'Status',
        'created_at' => 'Created Date',
        'lead_notes' => 'Notes',
        //'current_course' => '',        
        // 'accommodation' => '',
        // 'study_permit' => '',
        // 'branch' => '',
        // 'cgpa' => '',
        // 'ielts' => '',
        // 'toefl' => '',
        // 'pte' => '',
    ],

    'course_attributes' => [
        // 'id' => 'ID',
        'course_name' => 'Course Name*',
        'university' => 'University*',
        'country' => 'Country*',        
        'study_level' => 'Study Level*',

        'application_deadline' => 'Application Deadline',
        'application_fee' => 'Application Fee',
        'applicationmode' => 'Application Mode',
        'backlog_range' => 'Backlog Range',
        'campus' => 'Campus',
        'country_students_not_accepted' => 'Country students not accepted',
        'course_content' => 'Course Content/Learning',
        'course_details' => 'Course Details',
        'detscore' => 'DET Score',
        'duration' => 'Duration',
        'entry_requirements' => 'Entry Requirements',
        'esl_elp_detail' => 'Esl Elp Ddetail',
        'gmat_score' => 'GMAT Score',
        'gre_score' => 'GRE Score',
        'ielts_no_band_less_than' => 'IELTS No Band Less Than',
        'ielts_score' => 'IELTS Score',        
        'intakes' => 'Intake(s)',
        'non_tuition_fee' => 'Non Tuition Fee',
        'occupation_outcome' => 'Occupation Outcome',
        'practical_work' => 'Practical Work',
        'pte_no_band_less_than' => 'PTE No Band Less Than',
        'pte_score' => 'PTE Score',
        'qualify_extended_visa' => 'Qualify extended Visa',
        'regional_location' => 'Regional Location',
        'remarks' => 'Remarks',
        'scholarship_available' => 'Scholarship Available',
        'scholarship_detail' => 'Scholarship Detail',
        'toefl_no_band_less_than' => 'TOEFL No Band Less Than',
        'toefl_score' => 'TOEFL Score',
        'website_url' => 'Website Url',
        'yearly_tuition_fee' => 'Yearly Tuition Fees',


        // 'course_details' => 'Course Details',
        // 'course_content' => 'Course Content/Learning',
        // 'campus' => 'Campus',
        // 'duration' => 'Duration',
        // 'intakes' => 'Intake(s)',
        // 'occupation_outcome' => 'Occupation Outcome',
        // 'practical_work' => 'Practical Work',
        // 'qualify_extended_visa' => 'Qualify extended Visa',
        // 'regional_location' => 'Regional Location',
        // 'country_students_not_accepted' => 'Country students not accepted',
        // 'yearly_tuition_fee' => 'Yearly Tuition Fees',
        // 'non_tuition_fee' => 'Non Tuition Fee',
        // 'website_url' => 'Website Url',
        // 'entry_requirements' => 'Entry Requirements',
        // 'ielts_score' => 'IELTS Score',        
        // 'ielts_no_band_less_than' => 'IELTS No Band Less Than',
        // 'toefl_score' => 'TOEFL Score',
        // 'toefl_no_band_less_than' => 'TOEFL No Band Less Than',
        // 'pte_score' => 'PTE Score',
        // 'pte_no_band_less_than' => 'PTE No Band Less Than',
        // 'gre_score' => 'GRE Score',
        // 'gmat_score' => 'GMAT Score',
        // 'application_deadline' => 'Application Deadline',
        // 'application_fee' => 'Application Fee',
        // 'scholarship_available' => 'Scholarship Available',
        // 'scholarship_detail' => 'Scholarship Detail',
        // 'backlog_range' => 'Backlog Range',
        // 'remarks' => 'Remarks',
        // 'esl_elp_detail' => 'Esl Elp Ddetail',
        // 'applicationmode' => 'Application Mode',
        // 'detscore' => 'DET Score',

        // -----------------------------------------------------
        // 'category' => 'Category',        
        // 'year' => 'Year(s)',
        // 'tuition_fee_onshore' => 'Tuition Fee Onshore',
        // 'tuition_fee_offshore' => 'Tuition Fee Offshore',
        // 'tuition_fee' => 'Tuition Fee',        
    ],

    'university_course_attributes' => [
        'course_name' => 'Course Name*',      
        'study_level' => 'Study Level*',
        'application_deadline' => 'Application Deadline',
        'application_fee' => 'Application Fee',
        'applicationmode' => 'Application Mode',
        'backlog_range' => 'Backlog Range',
        'campus' => 'Campus',
        'country_students_not_accepted' => 'Country students not accepted',
        'course_content' => 'Course Content/Learning',
        'course_details' => 'Course Details',
        'detscore' => 'DET Score',
        'duration' => 'Duration',
        'entry_requirements' => 'Entry Requirements',
        'esl_elp_detail' => 'Esl Elp Ddetail',
        'gmat_score' => 'GMAT Score',
        'gre_score' => 'GRE Score',
        'ielts_no_band_less_than' => 'IELTS No Band Less Than',
        'ielts_score' => 'IELTS Score',        
        'intakes' => 'Intake(s)',
        'non_tuition_fee' => 'Non Tuition Fee',
        'occupation_outcome' => 'Occupation Outcome',
        'practical_work' => 'Practical Work',
        'pte_no_band_less_than' => 'PTE No Band Less Than',
        'pte_score' => 'PTE Score',
        'qualify_extended_visa' => 'Qualify extended Visa',
        'regional_location' => 'Regional Location',
        'remarks' => 'Remarks',
        'scholarship_available' => 'Scholarship Available',
        'scholarship_detail' => 'Scholarship Detail',
        'toefl_no_band_less_than' => 'TOEFL No Band Less Than',
        'toefl_score' => 'TOEFL Score',
        'website_url' => 'Website Url',
        'yearly_tuition_fee' => 'Yearly Tuition Fees',    
    ],

    /*
    |--------------------------------------------------------------------------
    | Autoloaded Service Providers
    |--------------------------------------------------------------------------
    |
    | The service providers listed here will be automatically loaded on the
    | request to your application. Feel free to add your own services to
    | this array to grant expanded functionality to your applications.
    |
    */

    'providers' => [

        /*
         * Laravel Framework Service Providers...
         */
        Illuminate\Auth\AuthServiceProvider::class,
        Illuminate\Broadcasting\BroadcastServiceProvider::class,
        Illuminate\Bus\BusServiceProvider::class,
        Illuminate\Cache\CacheServiceProvider::class,
        Illuminate\Foundation\Providers\ConsoleSupportServiceProvider::class,
        Illuminate\Cookie\CookieServiceProvider::class,
        Illuminate\Database\DatabaseServiceProvider::class,
        Illuminate\Encryption\EncryptionServiceProvider::class,
        Illuminate\Filesystem\FilesystemServiceProvider::class,
        Illuminate\Foundation\Providers\FoundationServiceProvider::class,
        Illuminate\Hashing\HashServiceProvider::class,
        Illuminate\Mail\MailServiceProvider::class,
        Illuminate\Notifications\NotificationServiceProvider::class,
        Illuminate\Pagination\PaginationServiceProvider::class,
        Illuminate\Pipeline\PipelineServiceProvider::class,
        Illuminate\Queue\QueueServiceProvider::class,
        Illuminate\Redis\RedisServiceProvider::class,
        Illuminate\Auth\Passwords\PasswordResetServiceProvider::class,
        Illuminate\Session\SessionServiceProvider::class,
        Illuminate\Translation\TranslationServiceProvider::class,
        Illuminate\Validation\ValidationServiceProvider::class,
        Illuminate\View\ViewServiceProvider::class,
        Dacastro4\LaravelGmail\LaravelGmailServiceProvider::class,

        SimpleSoftwareIO\QrCode\QrCodeServiceProvider::class,

        /*
         * Package Service Providers...
         */

        /*
         * Application Service Providers...
         */
        App\Providers\AppServiceProvider::class,
        App\Providers\AuthServiceProvider::class,
        App\Providers\BladeServiceProvider::class,
        // App\Providers\BroadcastServiceProvider::class,
        App\Providers\ComposerServiceProvider::class,
        App\Providers\EventServiceProvider::class,
        App\Providers\HelperServiceProvider::class,
        App\Providers\LocaleServiceProvider::class,
        App\Providers\ObserverServiceProvider::class,
        App\Providers\RouteServiceProvider::class,
        App\Providers\BreadcrumbServiceProvider::class,

        \SocialiteProviders\Manager\ServiceProvider::class,

        Intervention\Image\ImageServiceProvider::class,

    ],

    /*
    |--------------------------------------------------------------------------
    | Class Aliases
    |--------------------------------------------------------------------------
    |
    | This array of class aliases will be registered when this application
    | is started. However, feel free to register as many as you wish as
    | the aliases are "lazy" loaded so they don't hinder performance.
    |
    */

    'aliases' => [

        'App' => Illuminate\Support\Facades\App::class,
        'Arr' => Illuminate\Support\Arr::class,
        'Artisan' => Illuminate\Support\Facades\Artisan::class,
        'Auth' => Illuminate\Support\Facades\Auth::class,
        'Blade' => Illuminate\Support\Facades\Blade::class,
        'Broadcast' => Illuminate\Support\Facades\Broadcast::class,
        'Bus' => Illuminate\Support\Facades\Bus::class,
        'Cache' => Illuminate\Support\Facades\Cache::class,
        'Config' => Illuminate\Support\Facades\Config::class,
        'Cookie' => Illuminate\Support\Facades\Cookie::class,
        'Crypt' => Illuminate\Support\Facades\Crypt::class,
        'Date' => Illuminate\Support\Facades\Date::class,
        'DB' => Illuminate\Support\Facades\DB::class,
        'Eloquent' => Illuminate\Database\Eloquent\Model::class,
        'Event' => Illuminate\Support\Facades\Event::class,
        'File' => Illuminate\Support\Facades\File::class,
        'Gate' => Illuminate\Support\Facades\Gate::class,
        'Hash' => Illuminate\Support\Facades\Hash::class,
        'Http' => Illuminate\Support\Facades\Http::class,
        'Lang' => Illuminate\Support\Facades\Lang::class,
        'Log' => Illuminate\Support\Facades\Log::class,
        'Mail' => Illuminate\Support\Facades\Mail::class,
        'Notification' => Illuminate\Support\Facades\Notification::class,
        'Password' => Illuminate\Support\Facades\Password::class,
        'Queue' => Illuminate\Support\Facades\Queue::class,
        'RateLimiter' => Illuminate\Support\Facades\RateLimiter::class,
        'Redirect' => Illuminate\Support\Facades\Redirect::class,
        // 'Redis' => Illuminate\Support\Facades\Redis::class,
        'Request' => Illuminate\Support\Facades\Request::class,
        'Response' => Illuminate\Support\Facades\Response::class,
        'Route' => Illuminate\Support\Facades\Route::class,
        'Schema' => Illuminate\Support\Facades\Schema::class,
        'Session' => Illuminate\Support\Facades\Session::class,
        'Storage' => Illuminate\Support\Facades\Storage::class,
        'Str' => Illuminate\Support\Str::class,
        'URL' => Illuminate\Support\Facades\URL::class,
        'Validator' => Illuminate\Support\Facades\Validator::class,
        'View' => Illuminate\Support\Facades\View::class,

        'QrCode' => SimpleSoftwareIO\QrCode\Facades\QrCode::class,

        'LaravelGmail' => Dacastro4\LaravelGmail\Facade\LaravelGmail::class,

        'Image' => Intervention\Image\Facades\Image::class,

    ],

];