<?php
/**
 * PayPal Setting & API Credentials
 * Created by Raza Mehdi <srmk@outlook.com>.
 */

return [
    'mode'    => env('PAYPAL_MODE', 'sandbox'),

    'sandbox' => [
        'client_id'         => env('PAYPAL_SANDBOX_CLIENT_ID', ''),
        'client_secret'     => env('PAYPAL_SANDBOX_CLIENT_SECRET', ''),
        'app_id'            => env('PAYPAL_SANDBOX_APP_ID', ''),
        'api_url'           => 'https://api-m.sandbox.paypal.com/v1/',
        'webhook_id'        => env('PAYPAL_SANDBOX_WEBHOOK_ID', ''),
    ],

    'live' => [
        'client_id'         => env('PAYPAL_LIVE_CLIENT_ID', ''),
        'client_secret'     => env('PAYPAL_LIVE_CLIENT_SECRET', ''),
        'app_id'            => env('PAYPAL_LIVE_APP_ID', ''),
        'api_url'           => 'https://api-m.paypal.com/v1/',
        'webhook_id'        => env('PAYPAL_LIVE_WEBHOOK_ID', ''),
    ],

    'payment_action' => env('PAYPAL_PAYMENT_ACTION', 'Sale'),
    'currency'       => env('PAYPAL_CURRENCY', 'USD'),
    'notify_url'     => env('PAYPAL_NOTIFY_URL', ''),
    'locale'         => env('PAYPAL_LOCALE', 'en_US'),
    'validate_ssl'   => env('PAYPAL_VALIDATE_SSL', true),
];


// return [

//     'PAYPAL_API_URL' => 'https://api-m.sandbox.paypal.com/v1/',
//     'PAYPAL_CLIENT_ID' => 'AQQ8Bd6XHWa8Y2kTDQHjdycMr9f6iBnOrYX1G4xhnVZPqWS8vctmQZ4Jv_U0nACeslc6gD3gj3dFHlv5',
//     'PAYPAL_CLIENT_SECRET' => 'EETjxqreDhRmaG6DYwkNJzc6XOzSFOBzS2W7cK18_k3pflyyNPMsZ6iIZDYjrtrYzsObYs-WBPoveHBd',
//     'PAYPAL_WEBHOOK_ID' => '2K12750560489425L',
//     'PAYPAL_PRODUCT_SKU' => 'GAIN2UMEMBERSHIP',
//     'PAYPAL_BIZLISTING_SKU' => 'GAIN2UBIZLISTING',

//     'mode'    => 'sandbox', // Can only be 'sandbox' Or 'live'. If empty or invalid, 'live' will be used.
//     'sandbox' => [
//         'username'    => env('PAYPAL_SANDBOX_API_USERNAME'),
//         'password'    => env('PAYPAL_SANDBOX_API_PASSWORD'),
//         'secret'      => env('PAYPAL_SANDBOX_API_SECRET'),
//         'certificate' => env('PAYPAL_SANDBOX_API_CERTIFICATE'),
//         'app_id'      => '', // Used for testing Adaptive Payments API in sandbox mode
//     ],
//     'live' => [
//         'username'    => env('PAYPAL_LIVE_API_USERNAME', ''),
//         'password'    => env('PAYPAL_LIVE_API_PASSWORD', ''),
//         'secret'      => env('PAYPAL_LIVE_API_SECRET', ''),
//         'certificate' => env('PAYPAL_LIVE_API_CERTIFICATE', ''),
//         'app_id'      => '', // Used for Adaptive Payments API
//     ],

//     'payment_action' => 'Sale', // Can only be 'Sale', 'Authorization' or 'Order'
//     'currency'       => 'EUR',
//     'notify_url'     => 'https://demo247.xyz/dev/gain2u/api/ipn/notify/', // Change this accordingly for your application.
//     'locale'         => '', // force gateway language  i.e. it_IT, es_ES, en_US ... (for express checkout only)
//     'validate_ssl'   => false,
// ];
