-- 22 Feb

ALTER TABLE `users`
CHANGE `country` `country` varchar(100) COLLATE 'utf8mb4_unicode_ci' NOT NULL AFTER `state`;

-- 13 March 2023
-- INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('setup_abroad_course_finder', '0', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('setup_general', '0', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('setup_leads', '0', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('setup_modules', '0', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('setup_staff_roles', '0', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('setup_students', '0', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('setup_students_leads_data', '0', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('web_lead_assign_to_branch', '1', now(), now());

-- UPDATE `mail_templates` SET
-- `variables` = 'sitename,siteurl,email,mobile,first_name,full_name,password' 
-- WHERE `hook` = 'STUDENT_WELCOME';

-- UPDATE `sms_templates` SET
-- `variables` = 'sitename,siteurl,first_name,full_name,password'
-- WHERE `hook` = 'STUDENT_WELCOME';

-- 06-04-2023
INSERT INTO `mail_templates` (`hook`, `subject`, `variables`, `message`, `system_tpl`, `status`, `created_at`, `updated_at`) VALUES
('STUDENT_CREATE',	'Welcome!',	'sitename,siteurl,email,mobile,first_name,full_name,password',	'Dear&nbsp;<span>#full_name#<br></span><br>Welcome to #sitename#!<br><br>Your login details<br>URL: #siteurl#<br>Email: #email#<br>Password: #password#',	1,	1,	'2022-01-01 00:00:00',	'2023-04-05 16:22:54');

INSERT INTO `sms_templates` (`hook`, `message`, `variables`, `template_id`, `system_tpl`, `status`, `created_at`, `updated_at`) VALUES
('STUDENT_CREATE',	'Dear #first_name#, Welcome to #sitename#! #siteurl# Email: #email# Password: #password#',	'sitename,siteurl,first_name,full_name,password',	'',	1,	1,	'2022-01-01 00:00:00',	NULL);

-- 2023-18-04
update university_courses set study_level = 'Postgraduate' where study_level = 'Master';
update university_courses set study_level = 'Undergraduate' where study_level = 'Bachelor';


-- 2023-04-26

TRUNCATE TABLE currency_rates;
INSERT INTO currency_rates (`code`, symbol, `rate`) VALUES
('USD',	'$',	1.00),
('EUR',	'€',	0.90),
('GBP',	'£',	0.80),
('INR',	'₹',	82.00);

UPDATE `mail_templates` SET
`variables` = 'sitename,siteurl,email,mobile,first_name,full_name,password' 
WHERE `hook` = 'LEAD_WELCOME';

-- 28-04-2023
INSERT INTO `sms_templates` (`hook`, `message`, `variables`, `template_id`, `system_tpl`, `status`, `created_at`, `updated_at`) VALUES
('STUDENT_PASSWORD',	'Dear #first_name#, Welcome to #sitename#! #siteurl# Email: #email# Password: #password#',	'sitename,siteurl,first_name,full_name,password',	'',	1,	1,	'2022-01-01 00:00:00',	NULL);

INSERT INTO `sms_templates` (`hook`, `message`, `variables`, `template_id`, `system_tpl`, `status`, `created_at`, `updated_at`) VALUES
('LEAD_WELCOME',	'Dear #first_name#, Welcome to #sitename#! #siteurl# Email: #email# Password: #password#',	'sitename,siteurl,first_name,full_name,password',	'',	1,	1,	'2022-01-01 00:00:00',	NULL);


INSERT INTO `mail_templates` (`hook`, `subject`, `variables`, `message`, `system_tpl`, `status`, `created_at`, `updated_at`) VALUES
('STUDENT_PASSWORD',	'Welcome!',	'sitename,siteurl,email,mobile,first_name,full_name,password',	'Dear&nbsp;<span>#full_name#<br></span><br>Welcome to #sitename#!<br><br>Your login details<br>URL: #siteurl#<br>Email: #email#<br>Password: #password#',	1,	1,	'2023-04-28 00:00:00',	NULL);


-- 28-04-2023
ALTER TABLE `permissions`
ADD `details` varchar(500) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `guard_name`,
ADD `status` tinyint(1) NOT NULL DEFAULT '1' AFTER `details`;

UPDATE `permissions` SET
`details` = 'This permission gives access to the Admin panel. All staff roles & agent role will need this permission.'
WHERE `name` = 'view backend';

UPDATE `permissions` SET
`details` = 'View support requests created by students, reply to tickets.'
WHERE `name` = 'support tickets';

UPDATE `permissions` SET
`details` = 'Create/manage students, student profile details, course preferences, documents, applications.'
WHERE `name` = 'students';

UPDATE `permissions` SET
`details` = 'View Student University applications, manage details, status.'
WHERE `name` = 'university applications';

UPDATE `permissions` SET
`details` = 'Manage/upload study overseas country information documents.'
WHERE `name` = 'country info';

UPDATE `permissions` SET
`details` = 'View Staff members list, details.'
WHERE `name` = 'view staff';

UPDATE `permissions` SET
`details` = 'View Leads, add follow-ups, change lead status.'
WHERE `name` = 'leads';

UPDATE `permissions` SET
`details` = 'Send bulk email, sms, whatsapp message to leads, students, staff/agents.'
WHERE `name` = 'broadcast';

UPDATE `permissions` SET
`details` = 'Create/edit Portal home page & other page content, manage articles, main menu.'
WHERE `name` = 'cms-articles';

UPDATE `permissions` SET
`details` = 'Manage University Course Data, Course suggestions data, Country Information data.'
WHERE `name` = 'overseas education configs';

UPDATE `permissions` SET
`details` = 'Upload documents that can be shared to students.'
WHERE `name` = 'file uploads';

UPDATE `permissions` SET
`details` = 'Manage Email, SMS Templates.'
WHERE `name` = 'mail templates';

UPDATE `permissions` SET
`details` = 'Manage your business branch details.'
WHERE `name` = 'branch mgmt';

UPDATE `permissions` SET
`details` = 'Manage staff roles. Create/Edit roles & assign permissions to roles.'
WHERE `name` = 'roles mgmt';

UPDATE `permissions` SET
`details` = 'Create/edit staff users.'
WHERE `name` = 'edit-staff';

UPDATE `permissions` SET
`details` = 'Staff with this permission has Delete permission for Leads, Students, Applications.'
WHERE `name` = 'delete-lead-student-application-batch';

UPDATE `permissions` SET
`details` = 'Staff with this permission can perform various settings available in Settings page.'
WHERE `name` = 'settings';

UPDATE `permissions` SET
`details` = 'Create invoices, record payments, manage invoices.'
WHERE `name` = 'invoice';

UPDATE `permissions` SET
`details` = 'Staff with this permission can assign a lead to another staff.'
WHERE `name` = 'lead-assignment';

UPDATE `permissions` SET
`details` = 'Staff with this permission can assign a support ticket to another staff.'
WHERE `name` = 'ticket-assignment';

UPDATE `permissions` SET
`details` = 'Staff with this permission can import Leads, Student, Course data.'
WHERE `name` = 'import';

UPDATE `permissions` SET
`details` = 'View Analytics/reports data.'
WHERE `name` = 'analytics';

UPDATE `permissions` SET
`details` = 'Create/manage Agents(Partners).'
WHERE `name` = 'agent management';

UPDATE `permissions` SET `details` = 'Manage Agent(Partner) commissions.' WHERE `name` = 'agent-commission';

UPDATE `permissions` SET
`details` = 'Staff with this permission can only view leads, students, applications assigned to him/her only.'
WHERE `name` = 'view assigned data only';

UPDATE `permissions` SET
`details` = 'Create/manage Training batches, add students to batch.'
WHERE `name` = 'training batches';

UPDATE `permissions` SET
`details` = 'View/manage Training class attendance, reviews.'
WHERE `name` = 'training classes';

UPDATE `permissions` SET
`details` = 'View Training batch exams, student scores.'
WHERE `name` = 'training exams';

UPDATE `permissions` SET
`details` = 'Create/manage Webinars.'
WHERE `name` = 'cms-events';

UPDATE `permissions` SET
`details` = 'Manage Training Courses, Online Courses, Course Q & A.'
WHERE `name` = 'trainings configs';

UPDATE `permissions` SET
`details` = 'Create/manage Trainers.'
WHERE `name` = 'trainer management';

UPDATE `permissions` SET
`details` = 'Staff with this permission can assign a student to other staff member.'
WHERE `name` = 'student-assignment';


UPDATE `permissions` SET `status` = '0' WHERE `name` = 'export';
UPDATE `permissions` SET `status` = '0' WHERE `name` = 'counselling';

DELETE FROM `permissions` WHERE `name` = 'reports';

-- Consultancy specific
UPDATE `permissions` SET `name` = 'delete-lead-student-application' WHERE `name` = 'delete-lead-student-application-batch';
UPDATE `permissions` SET `status` = '0' WHERE `name` = 'training batches';
UPDATE `permissions` SET `status` = '0' WHERE `name` = 'training classes';
UPDATE `permissions` SET `status` = '0' WHERE `name` = 'training exams';
UPDATE `permissions` SET `status` = '0' WHERE `name` = 'trainings configs';
UPDATE `permissions` SET `status` = '0' WHERE `name` = 'trainer management';
-- 

-- 09-05-2023

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`) 
VALUES ('student_doc_configs', '{"bachelors":{"class10":{"certificate":{"enable":"1","mandatory":"1"},"marks_sheet":{"enable":"1","mandatory":"0"}},"class12":{"certificate":{"enable":"1","mandatory":"1"},"marks_sheet":{"enable":"1","mandatory":"0"}},"diploma":{"certificate":{"enable":"0","mandatory":"0"},"marks_sheet":{"enable":"0","mandatory":"0"}},"degree":{"certificate":{"enable":"0","mandatory":"0"},"marks_sheet":{"enable":"0","mandatory":"0"},"provisional":{"enable":"0","mandatory":"0"},"all_sem":{"enable":"0","mandatory":"0"}},"pg_degree":{"certificate":{"enable":"0","mandatory":"0"},"marks_sheet":{"enable":"0","mandatory":"0"},"provisional":{"enable":"0","mandatory":"0"},"all_sem":{"enable":"0","mandatory":"0"}},"passport":{"enable":"1","mandatory":"1"},"lor":{"enable":"1","mandatory":"1"},"sop":{"enable":"1","mandatory":"1"},"cv":{"enable":"1","mandatory":"1"},"other_cert":{"enable":"1","mandatory":"0"},"experience":{"enable":"0","mandatory":"0"},"essay":{"enable":"0"}},"masters":{"class10":{"certificate":{"enable":"1","mandatory":"1"},"marks_sheet":{"enable":"1","mandatory":"0"}},"class12":{"certificate":{"enable":"1","mandatory":"1"},"marks_sheet":{"enable":"1","mandatory":"0"}},"diploma":{"certificate":{"enable":"0","mandatory":"0"},"marks_sheet":{"enable":"0","mandatory":"0"}},"degree":{"certificate":{"enable":"1","mandatory":"1"},"marks_sheet":{"enable":"1","mandatory":"1"},"provisional":{"enable":"1","mandatory":"0"},"all_sem":{"enable":"1","mandatory":"0"}},"pg_degree":{"certificate":{"enable":"0","mandatory":"0"},"marks_sheet":{"enable":"0","mandatory":"0"},"provisional":{"enable":"0","mandatory":"0"},"all_sem":{"enable":"0","mandatory":"0"}},"passport":{"enable":"1","mandatory":"1"},"lor":{"enable":"1","mandatory":"1"},"sop":{"enable":"1","mandatory":"1"},"cv":{"enable":"1","mandatory":"1"},"other_cert":{"enable":"1","mandatory":"0"},"experience":{"enable":"0","mandatory":"0"},"essay":{"enable":"1"}},"phd":{"class10":{"certificate":{"enable":"1","mandatory":"0"},"marks_sheet":{"enable":"1","mandatory":"0"}},"class12":{"certificate":{"enable":"1","mandatory":"0"},"marks_sheet":{"enable":"1","mandatory":"0"}},"diploma":{"certificate":{"enable":"0","mandatory":"0"},"marks_sheet":{"enable":"0","mandatory":"0"}},"degree":{"certificate":{"enable":"1","mandatory":"0"},"marks_sheet":{"enable":"1","mandatory":"0"},"provisional":{"enable":"0","mandatory":"0"},"all_sem":{"enable":"0","mandatory":"0"}},"pg_degree":{"certificate":{"enable":"1","mandatory":"1"},"marks_sheet":{"enable":"1","mandatory":"1"},"provisional":{"enable":"0","mandatory":"0"},"all_sem":{"enable":"0","mandatory":"0"}},"passport":{"enable":"1","mandatory":"1"},"lor":{"enable":"1","mandatory":"1"},"sop":{"enable":"1","mandatory":"1"},"cv":{"enable":"1","mandatory":"1"},"other_cert":{"enable":"1","mandatory":"0"},"experience":{"enable":"1","mandatory":"0"},"essay":{"enable":"0"}},"others":{"class10":{"certificate":{"enable":"1","mandatory":"0"},"marks_sheet":{"enable":"1","mandatory":"0"}},"class12":{"certificate":{"enable":"1","mandatory":"0"},"marks_sheet":{"enable":"1","mandatory":"0"}},"diploma":{"certificate":{"enable":"1","mandatory":"0"},"marks_sheet":{"enable":"1","mandatory":"0"}},"degree":{"certificate":{"enable":"1","mandatory":"0"},"marks_sheet":{"enable":"1","mandatory":"0"},"provisional":{"enable":"1","mandatory":"0"},"all_sem":{"enable":"1","mandatory":"0"}},"pg_degree":{"certificate":{"enable":"1","mandatory":"0"},"marks_sheet":{"enable":"1","mandatory":"0"},"provisional":{"enable":"1","mandatory":"0"},"all_sem":{"enable":"1","mandatory":"0"}},"passport":{"enable":"1","mandatory":"1"},"lor":{"enable":"1","mandatory":"1"},"sop":{"enable":"1","mandatory":"1"},"cv":{"enable":"1","mandatory":"1"},"other_cert":{"enable":"1","mandatory":"0"},"experience":{"enable":"1","mandatory":"0"},"essay":{"enable":"0"}}}', '2023-02-12 21:39:39', NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('course_preference_dropdown', '1', now(), NULL);

ALTER TABLE `course_preference`
CHANGE `userid` `userid` int(11) unsigned NOT NULL AFTER `id`,
CHANGE `country` `country` varchar(45) COLLATE 'utf8_unicode_ci' NULL AFTER `userid`;

ALTER TABLE `course_preference`
ADD `country_id` int(11) NOT NULL DEFAULT '0',
ADD `course_id` int(11) NOT NULL DEFAULT '0' AFTER `country_id`,
ADD `course_other` varchar(191) COLLATE 'utf8_unicode_ci' NULL AFTER `course_id`,
ADD `university_id` int NOT NULL DEFAULT '0' AFTER `course_other`,
ADD `created_at` timestamp NULL AFTER `university_id`,
ADD `updated_at` timestamp NULL AFTER `created_at`;


CREATE TABLE `course_shortlisted` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(10) unsigned NOT NULL,
  `course_id` int(11) NOT NULL,
  `staff_suggested` tinyint(1) NOT NULL DEFAULT 0,
  `staff_id` int(11) NOT NULL DEFAULT 0,
  `student_approved` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  KEY `course_id` (`course_id`),
  CONSTRAINT `course_shortlisted_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `course_shortlisted_ibfk_2` FOREIGN KEY (`course_id`) REFERENCES `university_courses` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 09-05-2023
ALTER TABLE `user_docs_other`
CHANGE `doc_type` `doc_type` varchar(150) COLLATE 'utf8_unicode_ci' NULL AFTER `userid`;

ALTER TABLE `users`
CHANGE `overseas_study_level` `overseas_study_level` varchar(150) COLLATE 'utf8_unicode_ci' NULL AFTER `coaching_course_interested`;

ALTER TABLE `users`
ADD `overseas_study_level_selection` varchar(150) COLLATE 'utf8_unicode_ci' NULL AFTER `overseas_study_level`;

-- 18-05-2023
ALTER TABLE `countries`
ADD `overseas_status` tinyint(1) NOT NULL DEFAULT '0' AFTER `currency_name`;

update countries set overseas_status=1 where title_en in (select country from country_study where status=1);

update countries set title_en='USA' where title_en='United States';

ALTER TABLE `university_application`
DROP FOREIGN KEY `university_application_country_fk`;

ALTER TABLE `course_preference`
DROP FOREIGN KEY `course_preference_country_fk`;

-- 19-05-2023
INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('invoice_terms_text', '', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('invoice_footer_text', '', now(), NULL);


ALTER TABLE `invoice`
ADD `terms_conditions` text COLLATE 'utf8mb4_unicode_ci' NULL AFTER `terms`;

ALTER TABLE `invoice`
ADD `tax1_name` varchar(100) NULL AFTER `item3_amount`,
ADD `tax1_amount` decimal(13,2) NULL DEFAULT '0.00' AFTER `tax1_name`,
ADD `tax2_name` varchar(100) NULL AFTER `tax1_amount`,
ADD `tax2_amount` decimal(13,2) NULL DEFAULT '0.00' AFTER `tax2_name`;

-- 21-05-2023

ALTER TABLE `cache`
ADD `id` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY FIRST;

ALTER TABLE `password_resets`
ADD `id` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY FIRST;

ALTER TABLE `sessions`
ADD `session_id` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY FIRST;

ALTER TABLE `staff_branch`
DROP INDEX `unique_idx`;

ALTER TABLE `staff_branch`
ADD PRIMARY KEY `staff_branch_id` (`staff_id`,`branch_id`);

-- 23-05-2023
ALTER TABLE `course_preference`
ADD `university_other` varchar(191) COLLATE 'utf8_unicode_ci' NULL AFTER `course_other`;

-- 24-05-2023

DELETE FROM `countries` WHERE ((`id` = '154'));
UPDATE `countries` SET `title_en` = 'Netherlands' WHERE `id` = '155';

-- 27-05-2023

UPDATE `sms_templates` SET
`message` = 'Dear #first_name#, Leads to follow-up:',
`variables` = 'sitename,siteurl,first_name,full_name'
WHERE `hook` = 'STAFF_LEAD_FOLLOWUP';

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('event_notification_email', '', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('support_ticket_notification_email', '', now(), NULL);



-- 29/05 Analytics enhancements related changes
ALTER TABLE `users`
ADD `lead_converted_date` timestamp NULL AFTER `counselling_date`;

ALTER TABLE `user_activity`
CHANGE `type` `type` enum('followup','counselling','system_event','others') COLLATE 'utf8_unicode_ci' NOT NULL DEFAULT 'system_event' COMMENT 'user_event,system_event,admin_event' AFTER `user_id`;

ALTER TABLE `user_activity`
ADD `lead_followup` tinyint(1) NOT NULL DEFAULT '0' AFTER `detail`;

-- end

-- 20-6-2023 Dynamic study levels

CREATE TABLE `study_levels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `study_level` varchar(100) NOT NULL,
  `degree` enum('Pre-bachelors','Bachelors','Masters','Ph.D','Others') NOT NULL,
  `display_order` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`study_level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `study_levels` (`id`, `study_level`, `degree`, `display_order`, `created_at`, `updated_at`) VALUES
(1,	'UG Diploma/ Certificate/ Associate Degree',	'Pre-bachelors',	1,	'2023-06-20 07:00:33',	'2023-06-20 07:00:33'),
(2,	'Undergraduate',	'Bachelors',	2,	'2023-06-20 07:00:51',	'2023-06-20 07:00:51'),
(3,	'PG Diploma/Certificate',	'Masters',	3,	'2023-06-20 07:01:13',	'2023-06-20 07:01:13'),
(4,	'Postgraduate',	'Masters',	4,	'2023-06-20 07:01:35',	'2023-06-20 07:01:35'),
(5,	'UG+PG (Accelerated) Degree',	'Bachelors',	5,	'2023-06-20 07:02:22',	'2023-06-20 07:02:22'),
(6,	'PhD',	'Ph.D',	6,	'2023-06-20 07:03:15',	'2023-06-20 07:03:15'),
(7,	'Foundation',	'Others',	7,	'2023-06-20 07:03:45',	'2023-06-20 07:03:45'),
(8,	'Short Term Programs',	'Others',	8,	'2023-06-20 07:04:12',	'2023-06-20 07:04:12'),
(9,	'Pathway Programs',	'Others',	9,	'2023-06-20 07:04:36',	'2023-06-20 07:04:36'),
(10,	'Twinning Programmes (UG)',	'Bachelors',	10,	'2023-06-20 07:04:58',	'2023-06-20 07:04:58'),
(11,	'Twinning Programmes (PG)',	'Masters',	11,	'2023-06-20 07:06:38',	'2023-06-20 07:06:38'),
(12,	'English Language Program',	'Others',	12,	'2023-06-20 07:06:47',	'2023-06-20 07:06:47'),
(13,	'Online Programmes/ Distance Learning',	'Others',	13,	'2023-06-20 07:06:56',	'2023-06-20 07:06:56');

update users set overseas_study_level_selection='Undergraduate' where overseas_study_level_selection='UG';
update users set overseas_study_level_selection='Postgraduate' where overseas_study_level_selection='PG';

-- end
-- 19-06-2023

ALTER TABLE `user_activity`
ADD `communication_mode` varchar(100) NULL AFTER `staff`;

-- 21-06-2023

ALTER TABLE `user_details`
ADD `qualification_score` varchar(50) NULL AFTER `passout_year`;

-- 24-06-2023

CREATE TABLE `additional_docs_configs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `doc_type` varchar(100) NOT NULL,
  `file_count` int(11) NOT NULL,
  `file_types` varchar(100) NOT NULL,
  `country_specific` tinyint(1) NOT NULL DEFAULT 0,
  `countries` text DEFAULT NULL,
  `display_order` int(11) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `doc_type` (`doc_type`),
  UNIQUE KEY `title` (`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- 26-06-2023

ALTER TABLE `additional_docs_configs`
ADD `doc_notes` varchar(300) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `file_types`;


-- 27-06-2023

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('website_sticky_logo', 'logo/logo-white.png', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('website_sticky_logo_ht', '40', now(), NULL);


DROP TABLE IF EXISTS `application_activity`;
CREATE TABLE `application_activity` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `application_id` int(11) NOT NULL,
  `type` enum('status_update','others') NOT NULL DEFAULT 'others' COMMENT 'user_event,system_event,admin_event',
  `title` varchar(191) DEFAULT NULL,
  `detail` text DEFAULT NULL,
  `staff` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 27-06-2023

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('lead_disqualified_reason', 'Not Interested,Invalid Data,Not Reachable,Applied With Someone Else,Financial Problem,Not Able To Decide,Others', now(), NULL);

ALTER TABLE `user_details`
ADD `lead_disqualified_reason` text COLLATE 'utf8mb4_unicode_ci' NULL AFTER `campaign_id`;

-- 28-06-2023

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('communication_mode', 'Email,Inbound Call,Outbound Call,Video-Call,Walk-In,Others', now(), NULL);

ALTER TABLE `user_activity`
CHANGE `communication_mode` `communication_mode` text COLLATE 'utf8mb4_unicode_ci' NULL AFTER `staff`;

-- 29-06-2023

INSERT INTO `permissions` (`name`, `guard_name`, `details`, `status`, `created_at`, `updated_at`)
VALUES ('course finder', 'web', NULL, '1', now(), NULL);

-- 03-07-2023

CREATE TABLE `application_stages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `status_name` varchar(30) NOT NULL COMMENT 'name shown to the users',
  `file_upload` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'show file upload option in this stage',
  `file_upload_max` int(11) NOT NULL DEFAULT 1 COMMENT 'no. of files',
  `file_upload_required` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'is file upload mandatory',
  `notes_required` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'is notes mandatory',
  `can_go_back` tinyint(4) NOT NULL DEFAULT 0 COMMENT 'can go to previous stage from this stage? superadmin can always change',
  `case_close_success` int(11) NOT NULL DEFAULT -1 COMMENT 'case closed stage with successful completion',
  `case_close_rejected` int(11) NOT NULL DEFAULT -1 COMMENT 'rejected status',
  `stage_order` int(11) NOT NULL COMMENT 'order, display order',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `status_name` (`status_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- 04-07-2023
ALTER TABLE `application_activity`
ADD `attachment` text COLLATE 'utf8_unicode_ci' NULL AFTER `detail`;

-- 06-07-2023
ALTER TABLE `users`
CHANGE `first_name` `first_name` varchar(50) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `title`,
CHANGE `middle_name` `middle_name` varchar(50) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `first_name`,
CHANGE `last_name` `last_name` varchar(50) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `middle_name`;


INSERT INTO `application_stages` (`id`, `status_name`, `file_upload`, `file_upload_max`, `file_upload_required`, `notes_required`, `can_go_back`, `case_close_success`, `case_close_rejected`, `stage_order`, `created_at`, `updated_at`) VALUES
(1,	'Pending',	0,	1,	0,	0,	0,	-1,	-1,	1,	'2023-07-06 05:08:05',	NULL),
(2,	'Documents Ready',	0,	1,	0,	0,	0,	-1,	-1,	2,	'2023-07-06 05:23:34',	'2023-07-06 05:23:34'),
(3,	'Admission Criteria Met',	0,	1,	0,	0,	0,	-1,	-1,	3,	'2023-07-06 05:09:01',	NULL),
(4,	'Application Fee Paid',	0,	1,	0,	0,	0,	-1,	-1,	4,	'2023-07-06 05:09:25',	NULL),
(5,	'Application Submitted',	0,	1,	0,	0,	0,	-1,	-1,	5,	'2023-07-06 05:09:45',	NULL),
(6,	'Offer Letter Received',	1,	1,	0,	0,	0,	-1,	-1,	6,	'2023-07-06 05:10:53',	NULL),
(7,	'Funds Under Assessment',	0,	1,	0,	0,	0,	-1,	-1,	7,	'2023-07-06 05:11:31',	NULL),
(8,	'COE Received',	0,	1,	0,	0,	0,	-1,	-1,	8,	'2023-07-06 05:12:40',	NULL),
(9,	'Payment Received',	0,	1,	0,	0,	0,	-1,	-1,	9,	'2023-07-06 05:13:02',	NULL),
(10,	'CAS Requested',	0,	1,	0,	0,	0,	-1,	-1,	10,	'2023-07-06 05:13:32',	NULL),
(11,	'CAS Received',	0,	1,	0,	0,	0,	-1,	-1,	11,	'2023-07-06 05:13:56',	'2023-07-06 05:13:56'),
(12,	'I-20 Initiated',	0,	1,	0,	0,	0,	-1,	-1,	12,	'2023-07-06 05:14:18',	NULL),
(13,	'I-20 Received',	0,	1,	0,	0,	0,	-1,	-1,	13,	'2023-07-06 05:14:43',	'2023-07-06 05:14:43'),
(14,	'AIP Received',	0,	1,	0,	0,	0,	-1,	-1,	14,	'2023-07-06 05:15:08',	'2023-07-06 05:15:08'),
(15,	'Visa in Process',	0,	1,	0,	0,	0,	-1,	-1,	15,	'2023-07-06 05:15:24',	NULL),
(16,	'Visa Received',	1,	1,	0,	0,	0,	-1,	-1,	16,	'2023-07-06 05:16:04',	'2023-07-06 05:16:04'),
(17,	'Admission Complete',	0,	1,	0,	0,	0,	1,	0,	17,	'2023-07-06 05:17:51',	'2023-07-06 05:17:51'),
(18,	'Rejected',	0,	1,	0,	1,	1,	0,	1,	18,	'2023-07-06 05:18:48',	NULL);


-- 10-07-2023

ALTER TABLE `user_activity`
ADD `application_status` varchar(100) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `communication_mode`;

-- 10-07-2023
DELETE FROM `states`
WHERE `country_id` = '101' AND ((`id` = '18') OR (`id` = '27') OR (`id` = '28') OR (`id` = '30') OR (`id` = '40'));

-- 11-07-2023

ALTER TABLE `application_stages`
ADD `color` varchar(50) NULL DEFAULT '#0D6EFD' AFTER `stage_order`;


CREATE TABLE `custom_attributes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `attr_name` varchar(100) NOT NULL,
  `label` varchar(50) NOT NULL,
  `type` enum('input','select','checkbox','radio','textarea') NOT NULL,
  `placeholder` varchar(100) DEFAULT NULL,
  `selection_values` varchar(500) DEFAULT NULL,
  `select_multiple` tinyint(1) NOT NULL DEFAULT 0,
  `input_datatype` enum('text','number','decimal','date','year','email','mobile','phone','url') DEFAULT NULL,
  `input_min` int(11) DEFAULT NULL,
  `input_max` int(11) DEFAULT NULL,
  `laravel_rules` varchar(100) DEFAULT NULL,
  `for_lead` tinyint(1) NOT NULL,
  `for_student` tinyint(1) NOT NULL,
  `for_lead_mandatory` tinyint(1) NOT NULL,
  `for_student_mandatory` tinyint(1) NOT NULL,
  `display_order` int(11) NOT NULL DEFAULT 99,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


ALTER TABLE `user_details` ADD `user_data_js` longtext COLLATE 'utf8mb4_unicode_ci' NULL AFTER `userid`;


-- 12-07-2023

ALTER TABLE `course_shortlisted`
CHANGE `created_at` `created_at` timestamp NULL AFTER `student_approved`;

ALTER TABLE `study_levels`
CHANGE `created_at` `created_at` timestamp NULL AFTER `display_order`;

ALTER TABLE `additional_docs_configs`
CHANGE `created_at` `created_at` timestamp NULL AFTER `status`;

ALTER TABLE `application_activity`
CHANGE `created_at` `created_at` timestamp NULL AFTER `staff`;

ALTER TABLE `application_stages`
CHANGE `created_at` `created_at` timestamp NULL AFTER `color`;

UPDATE `states` SET `name` = 'New Delhi' WHERE `id` = '10';

-- 17-07-2023

ALTER TABLE `university_application`
ADD `assign_to` int(11) NULL AFTER `notes`;

-- 19-07-2023
ALTER TABLE `university_courses`
ADD `course_details` text COLLATE 'utf8mb4_unicode_ci' NULL AFTER `course_name`,
ADD `course_content` text COLLATE 'utf8mb4_unicode_ci' NULL AFTER `course_details`,
ADD `occupation_outcome` varchar(100) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `year`,
ADD `practical_work` enum('Yes','No','Maybe') COLLATE 'utf8mb4_unicode_ci' NULL AFTER `occupation_outcome`,
ADD `qualify_extended_visa` enum('Yes','No','Maybe') COLLATE 'utf8mb4_unicode_ci' NULL AFTER `practical_work`,
ADD `regional_location` enum('Yes','No','Maybe') COLLATE 'utf8mb4_unicode_ci' NULL AFTER `qualify_extended_visa`,
ADD `country_students_not_accepted` varchar(191) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `regional_location`,
CHANGE `tuition_fee` `tuition_fee_onshore` int NULL AFTER `application_fee`,
ADD `tuition_fee_offshore` int NULL AFTER `tuition_fee_onshore`,
ADD `non_tuition_fee` int NULL AFTER `tuition_fee_offshore`;

ALTER TABLE `universities`
ADD `institution_type` enum('Level 1','Level 2','Level 3','Not applicable') COLLATE 'utf8mb4_unicode_ci' NULL AFTER `country`,
ADD `concurrent_course_allowed` enum('Yes','No','Maybe') COLLATE 'utf8mb4_unicode_ci' NULL AFTER `institution_type`,
ADD `college_details` text COLLATE 'utf8mb4_unicode_ci' NULL AFTER `concurrent_course_allowed`,
ADD `address` text COLLATE 'utf8mb4_unicode_ci' NULL AFTER `college_details`,
ADD `website` varchar(100) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `address`,
ADD `cricos_link` varchar(150) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `website`,
ADD `documents_link` varchar(150) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `cricos_link`,
ADD `current_fee_list_link` varchar(150) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `documents_link`,
ADD `initial_deposit_options` varchar(150) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `current_fee_list_link`,
ADD `admission_process` varchar(150) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `initial_deposit_options`,
ADD `contact_person_name` varchar(100) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `admission_process`,
ADD `contact_person_phone` varchar(12) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `contact_person_name`,
ADD `contact_person_email` varchar(100) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `contact_person_phone`;
-- 21-07-2023
ALTER TABLE `users`
ADD `whatsapp_dialcode` varchar(4) COLLATE 'utf8_unicode_ci' NULL AFTER `mobile`;

-- 25-07-2023
ALTER TABLE `user_details`
ADD `email_signature` text COLLATE 'utf8mb4_unicode_ci' NULL AFTER `lead_disqualified_reason`;

-- 26-07-2023
INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('lead_followup_mandatory', '0', now(), NULL);

ALTER TABLE `user_activity`
ADD `lead_status_changed_to` varchar(100) NULL AFTER `lead_followup`;

ALTER TABLE `users`
ADD `lead_converted_by` int NULL DEFAULT '0' AFTER `lead_converted_date`;

-- 27-07-2023

ALTER TABLE `roles`
ADD `managerial` int(1) NULL DEFAULT '0' AFTER `name`;

UPDATE `roles` SET `managerial` = '1' WHERE `id` = '14';

UPDATE `roles` SET `managerial` = '1' WHERE `id` = '1';

ALTER TABLE `users`
ADD `reporting_to` int(11) NULL DEFAULT '1' AFTER `assigned_to`;

-- 31-07-2023

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('outbound_call_enabled', '0', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('zadarma_api_key', '', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('zadarma_api_secret', '', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('zadarma_agent_number', '', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('exotel_api_key', '', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('exotel_api_secret', '', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('exotel_agent_number', '', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('exotel_sid', '', now(), NULL);

-- 04-08-2023

INSERT INTO `permissions` (`name`, `guard_name`, `details`, `status`, `created_at`, `updated_at`)
VALUES ('export lead, student data', 'web', 'Export data from leads and students list pages', '1', now(), NULL);

ALTER TABLE `user_details`
CHANGE `emergency_name` `emergency_name` varchar(50) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `permanent_post_code`;

-- 01-08-2023
INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('lead_stage_deadline_missed_notification', '0', now(), NULL);

-- 03-08-2023
INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('outbound_call_provider', '', now(), NULL);

UPDATE `mail_templates` SET `message`='<p><img src="#siteurl#/assets/images/background/birthdayImage.jpg"></p><p><span style="color:hsl(30, 75%, 60%);"><strong>Many More Happy Returns Of The Day To Our Dearest #first_name#. May All Your Wishes Come True And Stay Blessed Forever! Happy Birthday!</strong></span></p>' where hook='BIRTHDAY_WISHES';


-- 10-08-2023
INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('home_page_student_signup', '1', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('home_page_agent_signup', '1', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('home_page_staff_login', '1', now(), NULL);

ALTER TABLE `broadcast_stats`
ADD `subject` varchar(400) COLLATE 'utf8_unicode_ci' NULL AFTER `msg_type`,
ADD `sent_to` text COLLATE 'utf8_unicode_ci' NULL AFTER `message`,
ADD `staff_id` int(11) NULL AFTER `sent_to`;

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('whatsapp_enabled', '1', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('whatsapp_provider', '', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('wati_token', '', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('aisensy_api_key', '', now(), NULL);

-- 10-08-2023

ALTER TABLE `lead_status` ADD `deadline` int(11) DEFAULT NULL AFTER `display_order`;

-- 11-08-2023

ALTER TABLE mail_templates
ADD details varchar(150) COLLATE 'utf8mb4_unicode_ci' NULL AFTER status;

UPDATE mail_templates SET
hook = 'COURSE_SUGGESTION'
WHERE hook = 'NEW_COURSE_SUGGESTION';

UPDATE mail_templates SET
details = 'This is sent to an Agent when approved by staff'
WHERE hook = 'AGENT_WELCOME';
UPDATE mail_templates SET
details = 'This is sent to Student on Birthday'
WHERE hook = 'BIRTHDAY_WISHES';
UPDATE mail_templates SET
details = 'This is sent to Student when staff sends a course suggestion'
WHERE hook = 'COURSE_SUGGESTION';
UPDATE mail_templates SET
details = 'This is sent to a Lead when the lead is manually added by staff or generated from web to lead forms'
WHERE hook = 'LEAD_WELCOME';
UPDATE mail_templates SET
details = 'This is sent to Student when staff creates a student'
WHERE hook = 'STUDENT_CREATE';
UPDATE mail_templates SET
details = 'This is sent to Student on signup or on email confirmation'
WHERE hook = 'STUDENT_WELCOME';
UPDATE mail_templates SET
details = 'This is sent to Student when a staff replies to ticket raised by student'
WHERE hook = 'TICKET_REPLY';
UPDATE mail_templates SET
details = 'This is sent to Student when his/her college application status is updated by staff'
WHERE hook = 'UNIVERSITY_APPLICATION_UPDATE';
UPDATE mail_templates SET
details = 'This email with auto-generated password is sent to student when a lead is converted to student'
WHERE hook = 'STUDENT_PASSWORD';

ALTER TABLE sms_templates
ADD details varchar(150) COLLATE 'utf8mb4_unicode_ci' NULL AFTER status;

UPDATE sms_templates SET
hook = 'COUNSELLING_MEET_SCHEDULED'
WHERE hook = 'COUNSELLOR_LEAD_ASSIGNED';

UPDATE sms_templates SET
details = 'This is sent to an Agent when approved by staff'
WHERE hook = 'AGENT_WELCOME';
UPDATE sms_templates SET
details = 'This is sent to Student on Birthday'
WHERE hook = 'BIRTHDAY_WISHES';
UPDATE sms_templates SET
details = 'This is sent to staff when a counselling meeting is scheduled for the staff'
WHERE hook = 'COUNSELLING_MEET_SCHEDULED';
UPDATE sms_templates SET
details = 'This is sent to Student when staff sends a course suggestion'
WHERE hook = 'COURSE_SUGGESTION';
UPDATE sms_templates SET
details = 'This is sent to Student when staff creates a student'
WHERE hook = 'STUDENT_CREATE';
UPDATE sms_templates SET
details = 'This is sent to Student on signup or on email confirmation'
WHERE hook = 'STUDENT_WELCOME';
UPDATE sms_templates SET
details = 'This is sent to Student when a staff replies to ticket raised by student'
WHERE hook = 'TICKET_REPLY';
UPDATE sms_templates SET
details = 'This is sent to Student when his/her college application status is updated by staff'
WHERE hook = 'UNIVERSITY_APPLICATION_UPDATE';
UPDATE sms_templates SET
details = 'This is sent to a Lead when the lead is manually added by staff or generated from web to lead forms'
WHERE hook = 'LEAD_WELCOME';
UPDATE sms_templates SET
details = 'This is sent to a Staff when a lead is assigned to him/her'
WHERE hook = 'STAFF_LEAD_ASSIGNED';
UPDATE sms_templates SET
details = 'This is sent to a Staff with details of upcoming lead follow-ups'
WHERE hook = 'STAFF_LEAD_FOLLOWUP';
UPDATE sms_templates SET
details = 'This message with auto-generated password is sent to student when a lead is converted to student'
WHERE hook = 'STUDENT_PASSWORD';
UPDATE sms_templates SET
details = 'This message is sent to student for an upcoming webinar for which he has registered for'
WHERE hook = 'WEBINAR_REMINDER';

ALTER TABLE `user_documents`
ADD `toefl` varchar(255) COLLATE 'utf8_unicode_ci' NULL AFTER `gmat`;

UPDATE `permissions` SET
`details` = 'Search for university courses and suggest to students'
WHERE `name` = 'course finder';

-- 12-08-2023

CREATE TABLE `services` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service_name` varchar(50) NOT NULL,
  `country_field` tinyint(1) NOT NULL,
  `display_order` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `service_name` (`service_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `services` (`id`, `service_name`, `country_field`, `display_order`, `created_at`, `updated_at`) VALUES
(1,	'Study Visa',	1,	1,	now(), NULL);

CREATE TABLE `service_applications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appl_id` int(11) DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `service_id` int(11) NOT NULL DEFAULT 0 COMMENT '0 - Study Visa',
  `country` int(11) DEFAULT 0,
  `college_appl_id` int(11) NOT NULL DEFAULT 0 COMMENT 'For Study Visa only',
  `notes` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `status` varchar(50) NOT NULL DEFAULT 'New File' COMMENT 'New File, Processing, Decision - Completed, Decision - Rejected',
  `assigned_to` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `service_application_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `application_id` int(11) NOT NULL,
  `reply_timestamp` datetime DEFAULT NULL,
  `message` text NOT NULL,
  `user_id` int(11) NOT NULL,
  `staff_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `staff_id` int(11) NOT NULL DEFAULT 0,
  `attachment_1` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `attachment_2` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `attachment_3` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `attachment_4` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


CREATE TABLE `visa_services_activity` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appl_id` int(11) NOT NULL,
  `detail` text DEFAULT NULL,
  `staff` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

ALTER TABLE `users`
ADD `services` text COLLATE 'utf8mb4_unicode_ci' NULL AFTER `lead_converted_by`;

-- 16-08-2023

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('frontend_theme', 'blue', now(), NULL);


ALTER TABLE `application_messages`
ADD `notified_staff` text NULL AFTER `attachment_4`;

DROP TABLE `user_notification`;
CREATE TABLE `user_notification` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `read` tinyint(1) NOT NULL DEFAULT 0,
  `from_user` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

ALTER TABLE `user_notification`
ADD `application_id` int(11) NOT NULL DEFAULT '0' AFTER `user_id`;

ALTER TABLE `user_notification`
ADD `application_type` enum('visa','university') NULL AFTER `application_id`;

ALTER TABLE `service_application_messages`
ADD `notified_staff` text NULL AFTER `attachment_4`;

ALTER TABLE `users`
ADD `archived` tinyint(1) NULL DEFAULT '0' AFTER `updated_at`;

-- 17-08-2023

ALTER TABLE `users`
CHANGE `mobile` `mobile` varchar(15) COLLATE 'utf8_unicode_ci' NULL AFTER `dialcode`,
CHANGE `whatsapp` `whatsapp` varchar(15) COLLATE 'utf8_unicode_ci' NULL AFTER `whatsapp_dialcode`;

-- 17-08-2023




-- 18-08-2023

UPDATE `mail_templates` SET
`details` = 'This is sent to a Lead when the Lead is manually added by staff'
WHERE `hook` = 'LEAD_WELCOME';

UPDATE `sms_templates` SET
`details` = 'This is sent to a Lead when the Lead is manually added by staff'
WHERE `hook` = 'LEAD_WELCOME';

INSERT INTO `mail_templates` (`hook`, `subject`, `variables`, `message`, `system_tpl`, `status`, `details`, `created_at`, `updated_at`)
VALUES ('LEAD_WELCOME_WEB2LEAD', 'Welcome!', 'sitename,siteurl,email,mobile,first_name,full_name,password', 'Dear&nbsp;<span>#full_name#<br></span><br>Welcome to #sitename#, Thank you for your interest in our services.', '0', '0', 'This is sent to a lead when lead is generated through web to lead form', NULL, NULL);

INSERT INTO `sms_templates` (`hook`, `message`, `variables`, `template_id`, `system_tpl`, `status`, `details`, `created_at`, `updated_at`)
VALUES ('LEAD_WELCOME_WEB2LEAD', 'Dear #first_name#, Welcome to #sitename#! #siteurl# Email: #email# Password: #password#', 'sitename,siteurl,first_name,full_name,password', '', '0', '0', 'This is sent to a lead when lead is generated through web to lead form', NULL, NULL);

DROP TABLE IF EXISTS `whatsapp_templates`;
CREATE TABLE `whatsapp_templates` (
  `hook` varchar(50) NOT NULL,
  `message` varchar(900) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `variables` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `system_tpl` tinyint(1) NOT NULL DEFAULT 0,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `details` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`hook`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `whatsapp_templates` (`hook`, `message`, `variables`, `system_tpl`, `status`, `details`, `created_at`, `updated_at`) VALUES
('agent_welcome',	'Dear #first_name#, Welcome to #sitename#!, Thank you for registering as an agent of #sitename#.',	'sitename,siteurl,first_name,full_name',	1,	1,	'This is sent to an Agent when approved by staff',	'2022-01-01 00:00:00',	NULL),
('birthday_wishes',	'Many More Happy Returns Of The Day To Our Dearest #full_name#! May All Your Wishes Come True And Stay Blessed Forever! Happy Birthday!',	'sitename,siteurl,first_name,full_name',	1,	1,	'This is sent to Student on Birthday',	'2021-12-31 18:30:00',	NULL),
('counselling_meet_scheduled',	'Dear #first_name#, A New counselling meeting is assigned to you.',	'sitename,siteurl,first_name,full_name',	1,	1,	'This is sent to staff when a counselling meeting is scheduled for the staff',	'2022-01-01 00:00:00',	'2023-08-07 09:53:13'),
('course_suggestion',	'Dear #first_name#, You have got new Course Suggestions. Login to check the details.',	'sitename,siteurl,first_name,full_name',	1,	1,	'This is sent to Student when staff sends a course suggestion',	'2021-12-31 18:30:00',	NULL),
('lead_welcome',	'Dear #first_name#, Welcome to #sitename#! #siteurl# Email: #email# Password: #password#',	'sitename,siteurl,first_name,full_name,password',	1,	1,	'This is sent to a Lead when the Lead is manually added by staff',	'2021-12-31 18:30:00',	NULL),
('lead_welcome_web2lead',	'Dear #first_name#, Welcome to #sitename#! #siteurl# Email: #email# Password: #password#',	'sitename,siteurl,first_name,full_name,password',	0,	0,	'This is sent to a lead when lead is generated through web to lead form',	NULL,	NULL),
('notification',	'Notification from #sitename#: #message#',	'sitename,message',	1,	1,	'',	'2021-12-31 18:30:00',	NULL),
('staff_lead_assigned',	'Dear #first_name#, A new lead is assigned to you.',	'sitename,siteurl,first_name,full_name',	1,	1,	'This is sent to a Staff when a lead is assigned to him/her',	'2021-12-31 18:30:00',	'2023-08-07 09:53:04'),
('staff_lead_followup',	'Dear #first_name#, Leads to follow-up:',	'sitename,siteurl,first_name,full_name',	1,	1,	'This is sent to a Staff with details of upcoming lead follow-ups',	'2021-12-31 18:30:00',	'2023-08-07 09:53:09'),
('student_create',	'Dear #first_name#, Welcome to #sitename#! #siteurl# Email: #email# Password: #password#',	'sitename,siteurl,first_name,full_name,password',	1,	1,	'This is sent to Student when staff creates a student',	'2021-12-31 18:30:00',	NULL),
('student_password',	'Dear #first_name#, Welcome to #sitename#! #siteurl# Email: #email# Password: #password#',	'sitename,siteurl,first_name,full_name,password',	1,	1,	'This message with auto-generated password is sent to student when a lead is converted to student',	'2021-12-31 18:30:00',	NULL),
('student_welcome',	'Dear #first_name#, Welcome to #sitename#!',	'sitename,siteurl,first_name,full_name',	1,	1,	'This is sent to Student on signup or on email confirmation',	'2021-12-31 18:30:00',	NULL),
('ticket_reply',	'Dear #first_name#, Ticket #id# has a new reply posted by support staff.',	'sitename,siteurl,first_name,full_name,id',	1,	1,	'This is sent to Student when a staff replies to ticket raised by student',	'2021-12-31 18:30:00',	'2023-08-07 09:53:16'),
('university_application_update',	'Dear #first_name#, Application #application#, Status Update: #details#.',	'sitename,siteurl,first_name,full_name,application,details',	1,	1,	'This is sent to Student when his/her college application status is updated by staff',	'2021-12-31 18:30:00',	NULL),
('webinar_reminder',	'Dear #first_name#, This is a reminder for the upcoming webinar - #webinar#, at #time#.',	'sitename,siteurl,first_name,full_name,webinar,time',	1,	1,	'This message is sent to student for an upcoming webinar for which he has registered for',	'2021-12-31 18:30:00',	NULL);

-- 24-08-2023

ALTER TABLE `users`
ADD `student_created_at` timestamp NULL AFTER `lead_converted_by`;

update users set student_created_at=lead_converted_date where is_lead=0 and lead_converted_date is not null;
update users set student_created_at=created_at where is_lead=0 and student_created_at is null;

-- 04-09-2023

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('lead_create_admin_mandatory', 'email', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('lead_create_web2lead_api_import_mandatory', 'email', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('student_create_admin_mandatory', 'email_and_mobile', now(), NULL);

ALTER TABLE `users`
DROP CONSTRAINT `users_email_unique`;
ALTER TABLE `users`
CHANGE `email` `email` varchar(100) COLLATE 'utf8_unicode_ci' NULL AFTER `coaching_status`;

-- 08-09-2023

ALTER TABLE `service_applications`
AUTO_INCREMENT=22000;

-- Automation

DROP TABLE IF EXISTS `automation_campaign`;
CREATE TABLE `automation_campaign` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(191) NOT NULL,
  `communication_mode` enum('email','whatsapp','sms') NOT NULL,
  `target` enum('leads','students','all_leads_and_students','staff','agents','all') NOT NULL,
  `lead_status` text DEFAULT NULL,
  `student_status` text DEFAULT NULL,
  `lead_filters` text DEFAULT NULL,
  `student_filters` text DEFAULT NULL,
  `filter_condition` varchar(10) DEFAULT NULL,
  `message_template` varchar(191) DEFAULT NULL,
  `message_subject` varchar(191) DEFAULT NULL,
  `message_content` text NOT NULL,
  `run_at` datetime NOT NULL,
  `status` enum('queued','paused','running','sent') NOT NULL DEFAULT 'queued',
  `sent_count` int(11) NOT NULL DEFAULT 0 COMMENT 'no of audience',
  `sent_to` longtext DEFAULT NULL,
  `send_start` datetime DEFAULT NULL,
  `send_end` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `automation_workflow`;
CREATE TABLE `automation_workflow` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(191) NOT NULL,
  `workflow_type` enum('lead_nurture_sequence','message_sequence','specific_event') NOT NULL,
  `communication_mode` enum('email','whatsapp','sms') NOT NULL,
  `run_at` time NOT NULL,
  `target` enum('leads','students','all_leads_and_students','staff','agents','all') NOT NULL,
  `lead_status` text DEFAULT NULL COMMENT 'comma seperated',
  `student_status` text DEFAULT NULL COMMENT 'comma seperated',
  `lead_filters` text DEFAULT NULL COMMENT 'json',
  `student_filters` text DEFAULT NULL COMMENT 'json',
  `filter_condition` varchar(10) DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `message_details` text DEFAULT NULL COMMENT 'json',
  `repeats` varchar(50) DEFAULT NULL,
  `status` tinyint(1) DEFAULT 1,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `auto_workflow_activity`;
CREATE TABLE `auto_workflow_activity` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `workflow_id` int(11) NOT NULL,
  `matched_count` int(11) NOT NULL,
  `matched_audience` longtext DEFAULT NULL COMMENT 'comma seperated user ids',
  `sequence_index` int(11) NOT NULL DEFAULT 1,
  `message_template` varchar(50) DEFAULT NULL COMMENT 'Hook',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

ALTER TABLE `user_activity`
CHANGE `type` `type` enum('followup','counselling','system_event','others','email_sent','email_received','outbound_call','inbound_call','whatsapp_sent','whatsapp_received','sms_sent') COLLATE 'utf8_unicode_ci' NOT NULL DEFAULT 'system_event' COMMENT 'user_event,system_event,admin_event' AFTER `user_id`;


ALTER TABLE `user_activity`
ADD `workflow_campaign_id` int NOT NULL DEFAULT '0' COMMENT 'automation workflow ID or Campaign ID' AFTER `application_status`;

DROP TABLE IF EXISTS `overseas_status`;
CREATE TABLE `overseas_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `overseas_status_name` varchar(100) NOT NULL,
  `color` varchar(50) NOT NULL,
  `assign_on_create` tinyint(1) NOT NULL DEFAULT 0,
  `assign_on_course_pref` tinyint(1) NOT NULL DEFAULT 0,
  `assign_on_doc_upload` tinyint(1) NOT NULL DEFAULT 0,
  `assign_on_appl_create` tinyint(1) NOT NULL DEFAULT 0,
  `is_completed_success` tinyint(1) NOT NULL DEFAULT 0,
  `is_dropout` tinyint(1) NOT NULL DEFAULT 0,
  `display_order` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `overseas_status_name` (`overseas_status_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


INSERT INTO `overseas_status` (`id`, `overseas_status_name`, `color`, `assign_on_create`, `assign_on_course_pref`, `assign_on_doc_upload`, `assign_on_appl_create`, `is_completed_success`, `is_dropout`, `display_order`, `created_at`, `updated_at`) VALUES
(1,	'Pending',	'#f98d00',	1,	0,	0,	0,	0,	0,	1,	'2023-08-22 13:04:57',	NULL),
(2,	'Course Preference Added',	'#5c59d6',	0,	1,	0,	0,	0,	0,	2,	'2023-08-22 13:06:51',	NULL),
(3,	'Documents Uploaded',	'#9453fc',	0,	0,	1,	0,	0,	0,	3,	'2023-08-22 13:07:48',	NULL),
(4,	'Application Processing',	'#478446',	0,	0,	0,	1,	0,	0,	4,	'2023-08-22 13:09:14',	NULL),
(5,	'Admission Complete',	'#949696',	0,	0,	0,	0,	1,	0,	5,	'2023-08-22 13:12:13',	NULL),
(6,	'Rejected/Dropout',	'#c95c58',	0,	0,	0,	0,	0,	1,	6,	'2023-08-22 13:13:32',	NULL);

ALTER TABLE `user_details`
ADD `student_disqualified_reason` text COLLATE 'utf8mb4_unicode_ci' NULL AFTER `lead_disqualified_reason`;


INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('student_disqualified_reason', 'Not Interested,Invalid Data,Not Reachable,Applied With Someone Else,Financial Problem,Not Able To Decide,Others', now(), NULL);

-- 09-09-2023

UPDATE users SET overseas_status='Pending' WHERE overseas_status='Lead';
UPDATE users SET overseas_status='Course Preference Added' WHERE overseas_status='Course Preferences';
UPDATE users SET overseas_status='Pending' WHERE overseas_status='Profile';
UPDATE users SET overseas_status='Documents Uploaded' WHERE overseas_status='Documents';
UPDATE users SET overseas_status='Rejected/Dropout' WHERE overseas_status='Application Rejected/Cancelled';

ALTER TABLE `invoice`
ADD `item4` varchar(191) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `item3_amount`,
ADD `item4_amount` decimal(13,2) NULL DEFAULT '0.00' AFTER `item4`,
ADD `item5` varchar(191) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `item4_amount`,
ADD `item5_amount` decimal(13,2) NULL DEFAULT '0.00' AFTER `item5`,
ADD `item6` varchar(191) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `item5_amount`,
ADD `item6_amount` decimal(13,2) NULL DEFAULT '0.00' AFTER `item6`,
ADD `item7` varchar(191) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `item6_amount`,
ADD `item7_amount` decimal(13,2) NULL DEFAULT '0.00' AFTER `item7`;


-- 11-09-2023
INSERT INTO `permissions` (`name`, `guard_name`, `details`, `status`, `created_at`, `updated_at`)
VALUES ('automations', 'web', 'Create/manage automated email/whatsapp/sms workflow sequences, scheduled campaigns', '1', now(), NULL);

-- 12-09-2023
ALTER TABLE `user_activity`
CHANGE `type` `type` enum('followup','counselling','system_event','others','email_sent','email_received','outbound_call','inbound_call','whatsapp_sent','whatsapp_received','sms_sent','lead_assignment','lead_status_change','student_assignment','student_status_change') COLLATE 'utf8_unicode_ci' NOT NULL DEFAULT 'system_event' AFTER `user_id`,
ADD `lead_assigned_to` int(11) NOT NULL DEFAULT '0' AFTER `lead_status_changed_to`,
ADD `student_status_changed_to` varchar(100) COLLATE 'utf8_unicode_ci' NULL AFTER `lead_assigned_to`,
ADD `student_assigned_to` int(11) NOT NULL DEFAULT '0' AFTER `student_status_changed_to`;

-- 14-09-2023
ALTER TABLE `user_activity`
ADD `attachment` text NULL AFTER `workflow_campaign_id`;

-- 14-09-2023

ALTER TABLE `course_preference`
ADD `created_by` int(11) NULL AFTER `university_id`;

-- 20-09-2023

ALTER TABLE `university_courses`
ADD INDEX `course_name` (`course_name`),
ADD INDEX `category` (`category`),
ADD INDEX `university` (`university`),
ADD INDEX `study_level` (`study_level`),
ADD INDEX `intakes` (`intakes`),
ADD INDEX `campus` (`campus`),
ADD INDEX `duration` (`duration`),
ADD INDEX `ielts_score` (`ielts_score`),
ADD INDEX `ielts_no_band_less_than` (`ielts_no_band_less_than`),
ADD INDEX `toefl_score` (`toefl_score`),
ADD INDEX `toefl_no_band_less_than` (`toefl_no_band_less_than`),
ADD INDEX `pte_score` (`pte_score`),
ADD INDEX `pte_no_band_less_than` (`pte_no_band_less_than`),
ADD INDEX `gre_score` (`gre_score`),
ADD INDEX `gmat_score` (`gmat_score`);

ALTER TABLE `universities`
ADD INDEX `university_name` (`university_name`),
ADD INDEX `country` (`country`);

ALTER TABLE `university_course_categories`
ADD INDEX `parent_id` (`parent_id`);

-- 21-09-2023
ALTER TABLE `university_courses`
ADD `currency` varchar(11) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `application_fee`,
CHANGE `updated_at` `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE CURRENT_TIMESTAMP AFTER `created_at`;

ALTER TABLE `university_courses`
ADD `yearly_tuition_fee` varchar(191) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `currency`,
CHANGE `updated_at` `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE CURRENT_TIMESTAMP AFTER `created_at`;

-- 22-09-2023

DROP TABLE IF EXISTS `currency`;
CREATE TABLE `currency` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `currency_code` varchar(3) NOT NULL,
  `currency_name` varchar(50) NOT NULL,
  `currency_symbol` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;


INSERT INTO `currency` (`id`, `currency_code`, `currency_name`, `currency_symbol`) VALUES
(1,	'AFA',	'Afghan Afghani',	'؋'),
(2,	'ALL',	'Albanian Lek',	'Lek'),
(3,	'DZD',	'Algerian Dinar',	'دج'),
(4,	'AOA',	'Angolan Kwanza',	'Kz'),
(5,	'ARS',	'Argentine Peso',	'$'),
(6,	'AMD',	'Armenian Dram',	'֏'),
(7,	'AWG',	'Aruban Florin',	'ƒ'),
(8,	'AUD',	'Australian Dollar',	'$'),
(9,	'AZN',	'Azerbaijani Manat',	'm'),
(10,	'BSD',	'Bahamian Dollar',	'B$'),
(11,	'BHD',	'Bahraini Dinar',	'.د.ب'),
(12,	'BDT',	'Bangladeshi Taka',	'৳'),
(13,	'BBD',	'Barbadian Dollar',	'Bds$'),
(14,	'BYR',	'Belarusian Ruble',	'Br'),
(15,	'BEF',	'Belgian Franc',	'fr'),
(16,	'BZD',	'Belize Dollar',	'$'),
(17,	'BMD',	'Bermudan Dollar',	'$'),
(18,	'BTN',	'Bhutanese Ngultrum',	'Nu.'),
(19,	'BTC',	'Bitcoin',	'฿'),
(20,	'BOB',	'Bolivian Boliviano',	'Bs.'),
(21,	'BAM',	'Bosnia-Herzegovina Convertible Mark',	'KM'),
(22,	'BWP',	'Botswanan Pula',	'P'),
(23,	'BRL',	'Brazilian Real',	'R$'),
(24,	'GBP',	'British Pound Sterling',	'£'),
(25,	'BND',	'Brunei Dollar',	'B$'),
(26,	'BGN',	'Bulgarian Lev',	'Лв.'),
(27,	'BIF',	'Burundian Franc',	'FBu'),
(28,	'KHR',	'Cambodian Riel',	'KHR'),
(29,	'CAD',	'Canadian Dollar',	'$'),
(30,	'CVE',	'Cape Verdean Escudo',	'$'),
(31,	'KYD',	'Cayman Islands Dollar',	'$'),
(32,	'XOF',	'CFA Franc BCEAO',	'CFA'),
(33,	'XAF',	'CFA Franc BEAC',	'FCFA'),
(34,	'XPF',	'CFP Franc',	'₣'),
(35,	'CLP',	'Chilean Peso',	'$'),
(36,	'CLF',	'Chilean Unit of Account',	'CLF'),
(37,	'CNY',	'Chinese Yuan',	'¥'),
(38,	'COP',	'Colombian Peso',	'$'),
(39,	'KMF',	'Comorian Franc',	'CF'),
(40,	'CDF',	'Congolese Franc',	'FC'),
(41,	'CRC',	'Costa Rican Colón',	'₡'),
(42,	'HRK',	'Croatian Kuna',	'kn'),
(43,	'CUC',	'Cuban Convertible Peso',	'$, CUC'),
(44,	'CZK',	'Czech Republic Koruna',	'Kč'),
(45,	'DKK',	'Danish Krone',	'Kr.'),
(46,	'DJF',	'Djiboutian Franc',	'Fdj'),
(47,	'DOP',	'Dominican Peso',	'$'),
(48,	'XCD',	'East Caribbean Dollar',	'$'),
(49,	'EGP',	'Egyptian Pound',	'ج.م'),
(50,	'ERN',	'Eritrean Nakfa',	'Nfk'),
(51,	'EEK',	'Estonian Kroon',	'kr'),
(52,	'ETB',	'Ethiopian Birr',	'Nkf'),
(53,	'EUR',	'Euro',	'€'),
(54,	'FKP',	'Falkland Islands Pound',	'£'),
(55,	'FJD',	'Fijian Dollar',	'FJ$'),
(56,	'GMD',	'Gambian Dalasi',	'D'),
(57,	'GEL',	'Georgian Lari',	'ლ'),
(58,	'DEM',	'German Mark',	'DM'),
(59,	'GHS',	'Ghanaian Cedi',	'GH₵'),
(60,	'GIP',	'Gibraltar Pound',	'£'),
(61,	'GRD',	'Greek Drachma',	'₯, Δρχ, Δρ'),
(62,	'GTQ',	'Guatemalan Quetzal',	'Q'),
(63,	'GNF',	'Guinean Franc',	'FG'),
(64,	'GYD',	'Guyanaese Dollar',	'$'),
(65,	'HTG',	'Haitian Gourde',	'G'),
(66,	'HNL',	'Honduran Lempira',	'L'),
(67,	'HKD',	'Hong Kong Dollar',	'$'),
(68,	'HUF',	'Hungarian Forint',	'Ft'),
(69,	'ISK',	'Icelandic Króna',	'kr'),
(70,	'INR',	'Indian Rupee',	'₹'),
(71,	'IDR',	'Indonesian Rupiah',	'Rp'),
(72,	'IRR',	'Iranian Rial',	'﷼'),
(73,	'IQD',	'Iraqi Dinar',	'د.ع'),
(74,	'ILS',	'Israeli New Sheqel',	'₪'),
(75,	'ITL',	'Italian Lira',	'L,£'),
(76,	'JMD',	'Jamaican Dollar',	'J$'),
(77,	'JPY',	'Japanese Yen',	'¥'),
(78,	'JOD',	'Jordanian Dinar',	'ا.د'),
(79,	'KZT',	'Kazakhstani Tenge',	'лв'),
(80,	'KES',	'Kenyan Shilling',	'KSh'),
(81,	'KWD',	'Kuwaiti Dinar',	'ك.د'),
(82,	'KGS',	'Kyrgystani Som',	'лв'),
(83,	'LAK',	'Laotian Kip',	'₭'),
(84,	'LVL',	'Latvian Lats',	'Ls'),
(85,	'LBP',	'Lebanese Pound',	'£'),
(86,	'LSL',	'Lesotho Loti',	'L'),
(87,	'LRD',	'Liberian Dollar',	'$'),
(88,	'LYD',	'Libyan Dinar',	'د.ل'),
(89,	'LTC',	'Litecoin',	'Ł'),
(90,	'LTL',	'Lithuanian Litas',	'Lt'),
(91,	'MOP',	'Macanese Pataca',	'$'),
(92,	'MKD',	'Macedonian Denar',	'ден'),
(93,	'MGA',	'Malagasy Ariary',	'Ar'),
(94,	'MWK',	'Malawian Kwacha',	'MK'),
(95,	'MYR',	'Malaysian Ringgit',	'RM'),
(96,	'MVR',	'Maldivian Rufiyaa',	'Rf'),
(97,	'MRO',	'Mauritanian Ouguiya',	'MRU'),
(98,	'MUR',	'Mauritian Rupee',	'₨'),
(99,	'MXN',	'Mexican Peso',	'$'),
(100,	'MDL',	'Moldovan Leu',	'L'),
(101,	'MNT',	'Mongolian Tugrik',	'₮'),
(102,	'MAD',	'Moroccan Dirham',	'MAD'),
(103,	'MZM',	'Mozambican Metical',	'MT'),
(104,	'MMK',	'Myanmar Kyat',	'K'),
(105,	'NAD',	'Namibian Dollar',	'$'),
(106,	'NPR',	'Nepalese Rupee',	'₨'),
(107,	'ANG',	'Netherlands Antillean Guilder',	'ƒ'),
(108,	'TWD',	'New Taiwan Dollar',	'$'),
(109,	'NZD',	'New Zealand Dollar',	'$'),
(110,	'NIO',	'Nicaraguan Córdoba',	'C$'),
(111,	'NGN',	'Nigerian Naira',	'₦'),
(112,	'KPW',	'North Korean Won',	'₩'),
(113,	'NOK',	'Norwegian Krone',	'kr'),
(114,	'OMR',	'Omani Rial',	'.ع.ر'),
(115,	'PKR',	'Pakistani Rupee',	'₨'),
(116,	'PAB',	'Panamanian Balboa',	'B/.'),
(117,	'PGK',	'Papua New Guinean Kina',	'K'),
(118,	'PYG',	'Paraguayan Guarani',	'₲'),
(119,	'PEN',	'Peruvian Nuevo Sol',	'S/.'),
(120,	'PHP',	'Philippine Peso',	'₱'),
(121,	'PLN',	'Polish Zloty',	'zł'),
(122,	'QAR',	'Qatari Rial',	'ق.ر'),
(123,	'RON',	'Romanian Leu',	'lei'),
(124,	'RUB',	'Russian Ruble',	'₽'),
(125,	'RWF',	'Rwandan Franc',	'FRw'),
(126,	'SVC',	'Salvadoran Colón',	'₡'),
(127,	'WST',	'Samoan Tala',	'SAT'),
(128,	'STD',	'São Tomé and Príncipe Dobra',	'Db'),
(129,	'SAR',	'Saudi Riyal',	'﷼'),
(130,	'RSD',	'Serbian Dinar',	'din'),
(131,	'SCR',	'Seychellois Rupee',	'SRe'),
(132,	'SLL',	'Sierra Leonean Leone',	'Le'),
(133,	'SGD',	'Singapore Dollar',	'$'),
(134,	'SKK',	'Slovak Koruna',	'Sk'),
(135,	'SBD',	'Solomon Islands Dollar',	'Si$'),
(136,	'SOS',	'Somali Shilling',	'Sh.so.'),
(137,	'ZAR',	'South African Rand',	'R'),
(138,	'KRW',	'South Korean Won',	'₩'),
(139,	'SSP',	'South Sudanese Pound',	'£'),
(140,	'XDR',	'Special Drawing Rights',	'SDR'),
(141,	'LKR',	'Sri Lankan Rupee',	'Rs'),
(142,	'SHP',	'St. Helena Pound',	'£'),
(143,	'SDG',	'Sudanese Pound',	'.س.ج'),
(144,	'SRD',	'Surinamese Dollar',	'$'),
(145,	'SZL',	'Swazi Lilangeni',	'E'),
(146,	'SEK',	'Swedish Krona',	'kr'),
(147,	'CHF',	'Swiss Franc',	'CHf'),
(148,	'SYP',	'Syrian Pound',	'LS'),
(149,	'TJS',	'Tajikistani Somoni',	'SM'),
(150,	'TZS',	'Tanzanian Shilling',	'TSh'),
(151,	'THB',	'Thai Baht',	'฿'),
(152,	'TOP',	'Tongan Pa\'anga',	'$'),
(153,	'TTD',	'Trinidad & Tobago Dollar',	'$'),
(154,	'TND',	'Tunisian Dinar',	'ت.د'),
(155,	'TRY',	'Turkish Lira',	'₺'),
(156,	'TMT',	'Turkmenistani Manat',	'T'),
(157,	'UGX',	'Ugandan Shilling',	'USh'),
(158,	'UAH',	'Ukrainian Hryvnia',	'₴'),
(159,	'AED',	'United Arab Emirates Dirham',	'إ.د'),
(160,	'UYU',	'Uruguayan Peso',	'$'),
(161,	'USD',	'US Dollar',	'$'),
(162,	'UZS',	'Uzbekistan Som',	'лв'),
(163,	'VUV',	'Vanuatu Vatu',	'VT'),
(164,	'VEF',	'Venezuelan BolÃvar',	'Bs'),
(165,	'VND',	'Vietnamese Dong',	'₫'),
(166,	'YER',	'Yemeni Rial',	'﷼'),
(167,	'ZMK',	'Zambian Kwacha',	'ZK'),
(168,	'ZWL',	'Zimbabwean dollar',	'$');

-- 25-09-2023

DROP TABLE IF EXISTS `notification_configs`;
CREATE TABLE `notification_configs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event` varchar(100) NOT NULL,
  `email_appl_assignee` tinyint(1) NOT NULL,
  `email_staff` tinyint(1) NOT NULL,
  `email_staff_manager` tinyint(1) NOT NULL,
  `email_superadmin` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `notification_configs` (`id`, `event`, `email_appl_assignee`, `email_staff`, `email_staff_manager`, `email_superadmin`, `created_at`, `updated_at`) VALUES
(1,	'LEAD_STATUS_CHANGE',	0,	1,	1,	0,	NULL,	NULL),
(2,	'LEAD_PROFILE_UPDATED_BY_STAFF',	0,	1,	1,	0,	NULL,	NULL),
(3,	'STUDENT_PROFILE_UPDATED',	0,	1,	1,	0,	NULL,	NULL),
(4,	'COURSE_PREFERENCE_ADDED_BY_STUDENT',	0,	1,	1,	0,	NULL,	NULL),
(5,	'COURSE_PREFERENCE_ADDED_BY_STAFF',	0,	1,	1,	0,	NULL,	NULL),
(6,	'COURSE_BOOKMARKED_BY_STUDENT',	0,	1,	1,	0,	NULL,	NULL),
(7,	'DOCUMENT_UPLOAD_BY_STUDENT',	0,	1,	1,	0,	NULL,	NULL),
(8,	'COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT',	0,	1,	1,	0,	NULL,	NULL),
(9,	'UNIVERSITY_APPLICATION_STATUS_CHANGE',	1,	1,	1,	0,	NULL,	NULL),
(10,	'UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT',	1,	1,	1,	0,	NULL,	NULL),
(11,	'VISA_OTHER_APPLICATION_STATUS_CHANGE',	1,	1,	1,	0,	NULL,	NULL),
(12,	'VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT',	1,	1,	1,	0,	NULL,	NULL),
(13,	'SUPPORT_TICKET_ASSIGNED_TO_STAFF',	0,	1,	0,	0,	NULL,	NULL),
(14,	'SUPPORT_TICKET_REPLY_RECEIVED',	0,	1,	0,	0,	NULL,	NULL),
(15,	'SUPPORT_TICKET_STATUS_CHANGE',	0,	1,	1,	0,	NULL,	NULL);


-- 03-10-2023
INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('lead_followup_reminder_notification', '1', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('lead_followup_missed_notification', '1', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('unassigned_lead_notification_lead_age', '2', now(), NULL);

-- 07-10-2023

ALTER TABLE `agent_commission`
ADD `agent_commission_notes` varchar(500) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `notes`,
CHANGE `created_at` `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE CURRENT_TIMESTAMP AFTER `paid_by`;


DROP TABLE IF EXISTS `application_doc_request`;
CREATE TABLE `application_doc_request` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` enum('university','visa') NOT NULL,
  `application_id` int(11) NOT NULL,
  `title` varchar(300) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `files` text DEFAULT NULL,
  `uploaded_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `college_fees`;
CREATE TABLE `college_fees` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `application_id` int(11) NOT NULL,
  `date_paid` date NOT NULL,
  `college_fee_amount` int(11) NOT NULL,
  `notes` varchar(400) NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` int(11) DEFAULT NULL,
  `updated_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `commission`;
CREATE TABLE `commission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `application_id` int(11) NOT NULL,
  `date_received` date NOT NULL,
  `my_commission_amount` int(11) NOT NULL,
  `notes` varchar(400) NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 29-09-2023

UPDATE `permissions` SET `name` = 'commission' WHERE `name` = 'agent-commission';

ALTER TABLE `university_application`
ADD `fees_currency` varchar(3) NULL AFTER `application_close_date`,
ADD `tuition_fees` decimal(13, 2) NULL AFTER `fees_currency`,
ADD `my_commission` decimal(13,2) NULL AFTER `tuition_fees`,
ADD `agent_commission` decimal(13,2) NULL AFTER `my_commission`;

-- 06-10-2023
ALTER TABLE `university_application`
ADD `task` varchar(500) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `notes`,
ADD `deadline` date NULL AFTER `task`;

-- 07-10-2023
ALTER TABLE `application_stages`
ADD `country_applicable` text COLLATE 'utf8mb4_unicode_ci' NULL AFTER `color`;

-- 09-10-2023

INSERT INTO `permissions` (`name`, `guard_name`, `details`, `status`, `created_at`, `updated_at`)
VALUES ('application apply through', 'web', 'Set the University applied through agency configuration', '1', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('application_apply_through', 'Direct,Apply Board', now(), NULL);

ALTER TABLE `university_application`
ADD `applied_with` varchar(150) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `application_close_date`;

ALTER TABLE `user_notification`
CHANGE `application_type` `application_type` enum('visa','university','lead','student') COLLATE 'utf8_unicode_ci' NULL AFTER `application_id`;

ALTER TABLE `study_levels`
CHANGE `degree` `degree` enum('Pre-bachelors','Bachelors','Pre-masters','Masters','Ph.D','Others') COLLATE 'utf8mb4_unicode_ci' NOT NULL AFTER `study_level`;

UPDATE `configs_site` SET value = 
'{"pre-bachelors":{"class10":{"certificate":{"enable":"1","mandatory":"1"},"marks_sheet":{"enable":"1","mandatory":"1"}},"class12":{"certificate":{"enable":"1","mandatory":"1"},"marks_sheet":{"enable":"1","mandatory":"1"}},"diploma":{"certificate":{"enable":"0","mandatory":"0"},"marks_sheet":{"enable":"0","mandatory":"0"}},"degree":{"certificate":{"enable":"0","mandatory":"0"},"marks_sheet":{"enable":"0","mandatory":"0"},"provisional":{"enable":"0","mandatory":"0"},"all_sem":{"enable":"0","mandatory":"0"}},"pg_degree":{"certificate":{"enable":"0","mandatory":"0"},"marks_sheet":{"enable":"0","mandatory":"0"},"provisional":{"enable":"0","mandatory":"0"},"all_sem":{"enable":"0","mandatory":"0"}},"passport":{"enable":"1","mandatory":"1"},"lor":{"enable":"1","mandatory":"1"},"sop":{"enable":"1","mandatory":"1"},"cv":{"enable":"1","mandatory":"1"},"other_cert":{"enable":"1","mandatory":"0"},"experience":{"enable":"1","mandatory":"0"},"essay":{"enable":"1"}},"bachelors":{"class10":{"certificate":{"enable":"1","mandatory":"1"},"marks_sheet":{"enable":"1","mandatory":"1"}},"class12":{"certificate":{"enable":"1","mandatory":"1"},"marks_sheet":{"enable":"1","mandatory":"1"}},"diploma":{"certificate":{"enable":"0","mandatory":"0"},"marks_sheet":{"enable":"0","mandatory":"0"}},"degree":{"certificate":{"enable":"0","mandatory":"0"},"marks_sheet":{"enable":"0","mandatory":"0"},"provisional":{"enable":"0","mandatory":"0"},"all_sem":{"enable":"0","mandatory":"0"}},"pg_degree":{"certificate":{"enable":"0","mandatory":"0"},"marks_sheet":{"enable":"0","mandatory":"0"},"provisional":{"enable":"0","mandatory":"0"},"all_sem":{"enable":"0","mandatory":"0"}},"passport":{"enable":"1","mandatory":"1"},"lor":{"enable":"1","mandatory":"1"},"sop":{"enable":"1","mandatory":"1"},"cv":{"enable":"1","mandatory":"1"},"other_cert":{"enable":"1","mandatory":"0"},"experience":{"enable":"1","mandatory":"0"},"essay":{"enable":"1"}},"pre-masters":{"class10":{"certificate":{"enable":"1","mandatory":"1"},"marks_sheet":{"enable":"1","mandatory":"1"}},"class12":{"certificate":{"enable":"1","mandatory":"1"},"marks_sheet":{"enable":"1","mandatory":"1"}},"diploma":{"certificate":{"enable":"0","mandatory":"0"},"marks_sheet":{"enable":"0","mandatory":"0"}},"degree":{"certificate":{"enable":"1","mandatory":"1"},"marks_sheet":{"enable":"1","mandatory":"1"},"provisional":{"enable":"1","mandatory":"0"},"all_sem":{"enable":"1","mandatory":"0"}},"pg_degree":{"certificate":{"enable":"0","mandatory":"0"},"marks_sheet":{"enable":"0","mandatory":"0"},"provisional":{"enable":"0","mandatory":"0"},"all_sem":{"enable":"0","mandatory":"0"}},"passport":{"enable":"1","mandatory":"1"},"lor":{"enable":"1","mandatory":"1"},"sop":{"enable":"1","mandatory":"1"},"cv":{"enable":"1","mandatory":"1"},"other_cert":{"enable":"1","mandatory":"0"},"experience":{"enable":"1","mandatory":"0"},"essay":{"enable":"1"}},"masters":{"class10":{"certificate":{"enable":"1","mandatory":"1"},"marks_sheet":{"enable":"1","mandatory":"1"}},"class12":{"certificate":{"enable":"1","mandatory":"1"},"marks_sheet":{"enable":"1","mandatory":"1"}},"diploma":{"certificate":{"enable":"0","mandatory":"0"},"marks_sheet":{"enable":"0","mandatory":"0"}},"degree":{"certificate":{"enable":"1","mandatory":"1"},"marks_sheet":{"enable":"1","mandatory":"1"},"provisional":{"enable":"1","mandatory":"0"},"all_sem":{"enable":"1","mandatory":"0"}},"pg_degree":{"certificate":{"enable":"0","mandatory":"0"},"marks_sheet":{"enable":"0","mandatory":"0"},"provisional":{"enable":"0","mandatory":"0"},"all_sem":{"enable":"0","mandatory":"0"}},"passport":{"enable":"1","mandatory":"1"},"lor":{"enable":"1","mandatory":"1"},"sop":{"enable":"1","mandatory":"1"},"cv":{"enable":"1","mandatory":"1"},"other_cert":{"enable":"1","mandatory":"0"},"experience":{"enable":"1","mandatory":"0"},"essay":{"enable":"1"}},"phd":{"class10":{"certificate":{"enable":"1","mandatory":"1"},"marks_sheet":{"enable":"1","mandatory":"1"}},"class12":{"certificate":{"enable":"1","mandatory":"1"},"marks_sheet":{"enable":"1","mandatory":"1"}},"diploma":{"certificate":{"enable":"0","mandatory":"0"},"marks_sheet":{"enable":"0","mandatory":"0"}},"degree":{"certificate":{"enable":"1","mandatory":"1"},"marks_sheet":{"enable":"1","mandatory":"1"},"provisional":{"enable":"1","mandatory":"0"},"all_sem":{"enable":"1","mandatory":"0"}},"pg_degree":{"certificate":{"enable":"1","mandatory":"1"},"marks_sheet":{"enable":"1","mandatory":"1"},"provisional":{"enable":"1","mandatory":"0"},"all_sem":{"enable":"1","mandatory":"0"}},"passport":{"enable":"1","mandatory":"1"},"lor":{"enable":"1","mandatory":"1"},"sop":{"enable":"1","mandatory":"1"},"cv":{"enable":"1","mandatory":"1"},"other_cert":{"enable":"1","mandatory":"0"},"experience":{"enable":"1","mandatory":"0"},"essay":{"enable":"1"}},"others":{"class10":{"certificate":{"enable":"1","mandatory":"1"},"marks_sheet":{"enable":"1","mandatory":"1"}},"class12":{"certificate":{"enable":"1","mandatory":"1"},"marks_sheet":{"enable":"1","mandatory":"1"}},"diploma":{"certificate":{"enable":"0","mandatory":"0"},"marks_sheet":{"enable":"0","mandatory":"0"}},"degree":{"certificate":{"enable":"1","mandatory":"0"},"marks_sheet":{"enable":"1","mandatory":"0"},"provisional":{"enable":"1","mandatory":"0"},"all_sem":{"enable":"1","mandatory":"0"}},"pg_degree":{"certificate":{"enable":"1","mandatory":"0"},"marks_sheet":{"enable":"1","mandatory":"0"},"provisional":{"enable":"1","mandatory":"0"},"all_sem":{"enable":"1","mandatory":"0"}},"passport":{"enable":"1","mandatory":"1"},"lor":{"enable":"1","mandatory":"1"},"sop":{"enable":"1","mandatory":"1"},"cv":{"enable":"1","mandatory":"1"},"other_cert":{"enable":"1","mandatory":"0"},"experience":{"enable":"1","mandatory":"0"},"essay":{"enable":"1"}}}' WHERE `key` = 'student_doc_configs';

UPDATE `study_levels` SET `degree` = 'Pre-masters' WHERE `study_level` = 'PG Diploma/Certificate';

-- 10-10-2023
ALTER TABLE `user_activity`
CHANGE `type` `type` enum('system_event','user_event','admin_event','followup','counselling','others','email_sent','email_received','outbound_call','inbound_call','whatsapp_sent','whatsapp_received','sms_sent','lead_assignment','lead_status_change','student_assignment','student_status_change') COLLATE 'utf8_unicode_ci' NOT NULL DEFAULT 'system_event' AFTER `user_id`;

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('google_lead_webhook_key', '', now(), NULL);

-- 11-10-2023
ALTER TABLE permissions
ADD UNIQUE (name);

-- 13-10-2023

DELETE FROM `states`
WHERE `country_id` = '153' AND ((`id` = '2567') OR (`id` = '2568') OR (`id` = '2570') OR (`id` = '2574') OR (`id` = '2575') OR (`id` = '2576') OR (`id` = '2577') OR (`id` = '2578') OR (`id` = '2579'));

INSERT INTO `states` (`name`, `country_id`)
SELECT 'Sudurpashchim', '153'
FROM `states`
WHERE `country_id` = '153' AND ((`id` = '2573'));

INSERT INTO `states` (`name`, `country_id`)
SELECT 'Madhesh', '153'
FROM `states`
WHERE `country_id` = '153' AND ((`id` = '4293'));


-- 12-10-2023
DROP TABLE IF EXISTS `custom_labels`;
CREATE TABLE `custom_labels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `label` varchar(50) NOT NULL,
  `default_text` varchar(191) NOT NULL,
  `custom_text` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `custom_labels` (`id`, `label`, `default_text`, `custom_text`, `created_at`, `updated_at`) VALUES
(1,	'class_10_certificate',	'Class 10th/SSC Certificate',	'Class 10th/SSC Certificate',	NULL,	NULL),
(2,	'class_10_marks_sheet',	'Class 10th/SSC Marks Sheet',	'Class 10th/SSC Marks Sheet',	NULL,	NULL),
(3,	'class_12_certificate',	'Class 12th/+2/HSC Certificate',	'Class 12th/+2/HSC Certificate',	NULL,	NULL),
(4,	'class_12_marks_sheet',	'Class 12th/+2/HSC Marks Sheet',	'Class 12th/+2/HSC Marks Sheet',	NULL,	NULL),
(5,	'diploma_certificate',	'Diploma Certificate',	'Diploma Certificate',	NULL,	NULL),
(6,	'diploma_marks_sheet',	'Diploma Marks Sheet',	'Diploma Marks Sheet',	NULL,	NULL),
(7,	'bachelors_certificate',	'Bachelors Certificate',	'Bachelors Certificate',	NULL,	NULL),
(8,	'bachelors_marks_sheet',	'Bachelors Marks Sheet',	'Bachelors Marks Sheet',	NULL,	NULL),
(9,	'bachelors_provisional_certificate',	'Bachelors Provisional Certificate',	'Bachelors Provisional Certificate',	NULL,	NULL),
(10,	'bachelors_marks_sheets_all_semesters',	'Bachelors Marks Sheets(All Semesters)',	'Bachelors Marks Sheets(All Semesters)',	NULL,	NULL),
(11,	'masters_certificate',	'Masters Certificate',	'Masters Certificate',	NULL,	NULL),
(12,	'masters_marks_sheet',	'Masters Marks Sheet',	'Masters Marks Sheet',	NULL,	NULL),
(13,	'masters_provisional_certificate',	'Masters Provisional Certificate',	'Masters Provisional Certificate',	NULL,	NULL),
(14,	'masters_marks_sheets_all_semesters',	'Masters Marks Sheets(All Semesters)',	'Masters Marks Sheets(All Semesters)',	NULL,	NULL),
(15,	'backend_students_menu','Students','Students',	NULL,	NULL),
(16,	'backend_support_tickets_menu','Support Tickets','Support Tickets',	NULL,	NULL),

(17,	'backend_students','Students','Students', NULL,	NULL),
(18,	'backend_student','Student','Student',	NULL,	NULL),
(19,	'backend_support_tickets','Support Tickets','Support Tickets',	NULL,	NULL),
(20,	'backend_support_ticket','Support Ticket','Support Ticket',	NULL,	NULL);

-- 08-11-2023

CREATE TABLE `reminders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `activity` varchar(150) NOT NULL,
  `deadline` date NOT NULL,
  `entity` enum('university_application','service_application','user','agent') NOT NULL,
  `entity_id` int(11) NOT NULL,
  `done` tinyint(1) NOT NULL DEFAULT 0,
  `done_date` datetime DEFAULT NULL,
  `done_by` int(11) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `permissions` (`name`, `guard_name`, `details`, `status`, `created_at`, `updated_at`)
VALUES ('delete-visa-service-application', 'web', 'Delete a Visa/Other services application', '1', now(), NULL);


ALTER TABLE `services`
ADD `visa_service` tinyint(1) NOT NULL AFTER `service_name`;

CREATE TABLE `service_stages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `status_name` varchar(30) NOT NULL COMMENT 'name shown to the users',
  `service_id` int NOT NULL,
  `default_stage` int(11) NULL DEFAULT '0',
  `case_close_stage` int(11) NULL DEFAULT '0' COMMENT 'case closed stage',
  `stage_order` int(11) NOT NULL COMMENT 'order, display order',
  `color` varchar(50) NULL DEFAULT '#0D6EFD',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


INSERT INTO `service_stages` (`id`, `status_name`, `service_id`, `default_stage`, `case_close_stage`,`color`,`stage_order`, `created_at`, `updated_at`) VALUES
(1, 'New',  1,  1, 0, '#0AD7FE', 1, now(), NULL),
(2, 'Processing', 1,  0, 0, '#FCB802', 2, now(), NULL),
(3, 'Completed',  1,  0, 1, '#08B333', 3, now(), NULL);

ALTER TABLE `service_applications`
CHANGE `status` `status` varchar(100) COLLATE 'utf8_unicode_ci' NOT NULL AFTER `description`;


-- 10-11-2023

DROP TABLE IF EXISTS `staff_attendance`;
CREATE TABLE `staff_attendance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `date` date DEFAULT NULL,
  `clock_in` datetime DEFAULT NULL,
  `clock_out` datetime DEFAULT NULL,
  `ip` varchar(50) DEFAULT NULL,
  `lat` varchar(50) DEFAULT NULL,
  `long` varchar(50) DEFAULT NULL,
  `location` varchar(100) DEFAULT NULL,
  `details` text DEFAULT NULL,
  `auto_clock_out` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `permissions` (`name`, `guard_name`, `details`) VALUES
('staff attendance','web', 'View Staff Attendance'),
('staff leaves','web', 'View Staff Leaves'),
('Approve Leaves','web', 'Approve/disapprove staff leaves');

DROP TABLE IF EXISTS `staff_leaves`;
CREATE TABLE `staff_leaves` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `leave_date` date NOT NULL,
  `days` decimal(13,1) NOT NULL,
  `when` enum('full_day','first_half','second_half') NOT NULL,
  `reason` varchar(200) NOT NULL,
  `type` enum('EL','SL') NOT NULL DEFAULT 'EL',
  `approved` tinyint(1) NOT NULL DEFAULT 0,
  `request_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `holidays`;
CREATE TABLE `holidays` (
  `date` date NOT NULL,
  `event` varchar(100) NOT NULL,
  PRIMARY KEY (`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


ALTER TABLE `additional_docs_configs`
ADD `section_id` int NULL AFTER `status`;

DROP TABLE IF EXISTS `additional_docs_sections`;
CREATE TABLE `additional_docs_sections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `section` varchar(100) NOT NULL,
  `display_order` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `additional_docs_sections` (`id`, `section`, `display_order`, `created_at`, `updated_at`) VALUES
(1, 'Academic Certificates',  1,  '2023-11-07 12:40:09',  NULL),
(2, 'Tests/English Certificates', 2,  '2023-11-07 12:40:22',  NULL),
(3, 'Passport, CV, LOR, SOP, Experience, Other Certificates', 3,  '2023-11-07 12:40:34',  NULL);

-- 16-11-2023

ALTER TABLE `user_activity`
CHANGE `type` `type` enum('system_event','user_event','admin_event','followup','counselling','others','email_sent','email_received','outbound_call','inbound_call','whatsapp_sent','whatsapp_received','sms_sent','lead_assignment','lead_status_change','student_assignment','student_status_change','message_sent_to_student','message_received_from_student') COLLATE 'utf8_unicode_ci' NOT NULL DEFAULT 'system_event' AFTER `user_id`,
CHANGE `created_at` `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE CURRENT_TIMESTAMP AFTER `attachment`;

-- 17-11-2023
UPDATE `additional_docs_sections` SET
`id` = '1',
`section` = 'Academic Certificates',
`display_order` = '1',
`created_at` = '2023-11-07 12:40:09',
`updated_at` = NULL
WHERE `id` = '1';

-- 21-11-2023

ALTER TABLE `invoice`
ADD `item8` varchar(191) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `item7_amount`,
ADD `item8_amount` decimal(13,2) NULL DEFAULT '0.00' AFTER `item8`,
ADD `item9` varchar(191) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `item8_amount`,
ADD `item9_amount` decimal(13,2) NULL DEFAULT '0.00' AFTER `item9`,
ADD `item10` varchar(191) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `item9_amount`,
ADD `item10_amount` decimal(13,2) NULL DEFAULT '0.00' AFTER `item10`,
ADD `item11` varchar(191) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `item10_amount`,
ADD `item11_amount` decimal(13,2) NULL DEFAULT '0.00' AFTER `item11`,
ADD `item12` varchar(191) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `item11_amount`,
ADD `item12_amount` decimal(13,2) NULL DEFAULT '0.00' AFTER `item12`,
ADD `item13` varchar(191) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `item12_amount`,
ADD `item13_amount` decimal(13,2) NULL DEFAULT '0.00' AFTER `item13`,
ADD `item14` varchar(191) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `item13_amount`,
ADD `item14_amount` decimal(13,2) NULL DEFAULT '0.00' AFTER `item14`,
ADD `item15` varchar(191) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `item14_amount`,
ADD `item15_amount` decimal(13,2) NULL DEFAULT '0.00' AFTER `item15`,
ADD `item16` varchar(191) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `item15_amount`,
ADD `item16_amount` decimal(13,2) NULL DEFAULT '0.00' AFTER `item16`,
ADD `item17` varchar(191) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `item16_amount`,
ADD `item17_amount` decimal(13,2) NULL DEFAULT '0.00' AFTER `item17`,
ADD `item18` varchar(191) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `item17_amount`,
ADD `item18_amount` decimal(13,2) NULL DEFAULT '0.00' AFTER `item18`,
ADD `item19` varchar(191) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `item18_amount`,
ADD `item19_amount` decimal(13,2) NULL DEFAULT '0.00' AFTER `item19`,
ADD `item20` varchar(191) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `item19_amount`,
ADD `item20_amount` decimal(13,2) NULL DEFAULT '0.00' AFTER `item20`,
ADD `item21` varchar(191) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `item20_amount`,
ADD `item21_amount` decimal(13,2) NULL DEFAULT '0.00' AFTER `item21`;

-- 23-11-2023
ALTER TABLE `whatsapp_templates`
CHANGE `message` `message` varchar(1024) COLLATE 'utf8mb4_unicode_ci' NOT NULL AFTER `hook`;

UPDATE `whatsapp_templates` SET
`variables` = 'sitename,siteurl,first_name,full_name,email,password'
WHERE `hook` = 'student_create';

CREATE TABLE `wati_webhook_calls` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `request_id` varchar(40) NOT NULL,
  `details` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `request_id` (`request_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 30-11-2023

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('smtp_reply_to', '', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('bulk_smtp_email', '', now(), NULL);
INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('bulk_smtp_password', '', now(), NULL);
INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('bulk_smtp_host', '', now(), NULL);
INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('bulk_smtp_port', '', now(), NULL);
INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('bulk_smtp_connection', '', now(), NULL);
INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('bulk_smtp_limit_hourly', '500', now(), NULL);

-- 01-12-2023
INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('wati_api_endpoint', '', now(), NULL);

-- 04-12-2023

INSERT INTO mail_templates (hook, subject, variables, message, system_tpl, status, details, created_at, updated_at) 
VALUES ('AGENT_CREATE',	'Welcome!',	'sitename,siteurl,email,mobile,first_name,full_name,password',	'Dear <span>#full_name#<br></span><br>Welcome to #sitename#!<br><br>We are thrilled to extend a warm welcome to you as our esteemed sub-agent at #sitename#. Your decision to join forces with us is a testament to your commitment to providing excellent service in the field of education and study abroad consultancy.<br /><br />At #sitename#, we take pride in our mission to empower students to achieve their academic and career goals by facilitating seamless study abroad experiences. With your expertise and dedication, we are confident that together, we can make a significant impact on the lives of aspiring students.<br /><br />As a sub-agent, you play a crucial role in our network, acting as a bridge between prospective students and the plethora of opportunities available worldwide. Your insights, local knowledge, and personalized approach will undoubtedly contribute to the success of our collaborative efforts.<br /><br />Once again, Thank you for choosing to be a part of our team. Here is your portal login details:<br />URL: #siteurl#/agent-login<br>Email: #email#<br>Password: #password#',	1,	1,	'This is sent to Agent(Partner) when staff creates a agent(partner)',	'2021-12-31 13:00:00',	'2023-04-05 05:22:54');

INSERT INTO sms_templates (hook, message, variables, template_id, system_tpl, status, details, created_at, updated_at) VALUES
('AGENT_CREATE',	'Dear #first_name#, Welcome to #sitename#! We are thrilled to extend a warm welcome to you as our esteemed sub-agent. Your portal login details:#siteurl#/agent-login Email:#email# Password:#password#',	'sitename,siteurl,first_name,full_name,password',	'',	1,	1,	'This is sent to Agent(partner) when staff creates a agent(partner)',	'2021-12-31 13:00:00',	NULL);

-- 11-12-2023

UPDATE `countries` SET `title_en` = 'South Korea' WHERE `id` = '116';

UPDATE `country_study` SET `country` = 'South Korea' WHERE `country` = 'Korea South';

-- 27-11-2023
ALTER TABLE `branch`
ADD `city` varchar(50) COLLATE 'utf8mb4_unicode_ci' NULL,
ADD `country` int NULL AFTER `city`,
ADD `phone` varchar(50) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `country`,
ADD `email` varchar(100) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `phone`,
ADD `custom_smtp` tinyint(1) NOT NULL DEFAULT '0' AFTER `email`,
ADD `smtp_email` varchar(100) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `custom_smtp`,
ADD `smtp_password` varchar(100) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `smtp_email`,
ADD `smtp_host` varchar(100) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `smtp_password`,
ADD `smtp_port` int NULL AFTER `smtp_host`,
ADD `smtp_connection` varchar(10) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `smtp_port`,
ADD `smtp_from_name` varchar(100) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `smtp_connection`,
ADD `smtp_reply_to` varchar(100) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `smtp_from_name`,
ADD `created_at` timestamp NULL AFTER `smtp_reply_to`,
ADD `updated_at` timestamp NULL AFTER `created_at`;


-- 01-12-2023

CREATE TABLE `staff_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `staff_id` bigint(20) unsigned NOT NULL,
  `email_integration` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `smtp_host` varchar(100) DEFAULT NULL,
  `smtp_port` int(11) DEFAULT NULL,
  `smtp_encryption` varchar(255) NOT NULL,
  `smtp_username` varchar(255) NOT NULL,
  `smtp_password` varchar(255) NOT NULL,
  `imap_host` varchar(100) DEFAULT NULL,
  `imap_port` int(11) DEFAULT NULL,
  `imap_encryption` varchar(255) DEFAULT 'ssl',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 04-12-2023
CREATE TABLE `mail_sync_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `imap_email` varchar(100) DEFAULT NULL,
  `imap_password` varchar(100) DEFAULT NULL,
  `imap_host` varchar(100) DEFAULT NULL,
  `imap_port` int(11) DEFAULT NULL,
  `imap_connection` varchar(10) DEFAULT NULL,
  `create_lead` tinyint(1) DEFAULT 0,
  `filter_subject_type` enum('equals','contains') DEFAULT NULL,
  `filter_subject_value` varchar(100) DEFAULT NULL,
  `status` tinyint(1) DEFAULT 1,
  `last_sync_notes` text NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

ALTER TABLE `mail_sync_accounts`
ADD `last_sync_datetime` timestamp NULL AFTER `last_sync_notes`;

ALTER TABLE `mail_sync_accounts`
CHANGE `filter_subject_type` `filter_subject_type` enum('all','equals','contains') COLLATE 'utf8mb4_unicode_ci' NULL AFTER `create_lead`;

-- 15-12-2023

UPDATE `sms_templates` SET
`variables` = 'sitename,siteurl,first_name,full_name,email,password'
WHERE `hook` = 'STUDENT_CREATE';

INSERT INTO `mail_templates` (`hook`, `subject`, `variables`, `message`, `system_tpl`, `status`, `details`, `created_at`, `updated_at`)
VALUES ('COURSE_PREFERENCE_ADDED_BY_STAFF', 'New Course Preference Added', 'sitename,siteurl,first_name,full_name', 'Dear #first_name#,<br>A new course has been added to your course preferences.&nbsp;<br>Please Visit&nbsp;#siteurl#', '1', '1', 'This is sent to Student when staff adds a course to student course preferences', '2022-01-01 00:00:00', '2020-02-01 05:45:30');

INSERT INTO `sms_templates` (`hook`, `message`, `variables`, `template_id`, `system_tpl`, `status`, `details`, `created_at`, `updated_at`)
VALUES ('COURSE_PREFERENCE_ADDED_BY_STAFF', 'Dear #first_name#, A new course has been added to your Course Preferences. Login to check the details.', 'sitename,siteurl,first_name,full_name', '', '1', '1', 'This is sent to Student when staff adds a course to student course preferences', '2022-01-01 00:00:00', NULL);

ALTER TABLE `imap_messages`
ADD INDEX `message_id` (`message_id`);


-- 26-12-2023
ALTER TABLE `custom_attributes`
ADD `web_to_lead` tinyint(1) NULL DEFAULT '0' COMMENT 'decides whether it is used in web to lead form' AFTER `for_student_mandatory`;

ALTER TABLE `custom_attributes`
CHANGE `label` `label` varchar(500) COLLATE 'utf8mb4_unicode_ci' NOT NULL AFTER `attr_name`;

-- 01-01-2024
INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('web_lead_form_name', '', now(), NULL);
INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('web_lead_whatsapp_enabled', '', now(), NULL);
INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('web_lead_intake_enabled', '', now(), NULL);
INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('web_lead_qualification_enabled', '', now(), NULL);
INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('web_lead_passout_year_enabled', '', now(), NULL);
INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('web_lead_score_enabled', '', now(), NULL);

-- 04-01-2024

ALTER TABLE `university_courses`
ADD `concentration` text NULL AFTER `status`;

-- 17-01-2024

ALTER TABLE `user_activity`
ADD `callyzer_call_id` varchar(100) COLLATE 'utf8_unicode_ci' NULL AFTER `attachment`;

-- 22-01-2024

INSERT INTO `permissions` (`name`, `guard_name`, `details`, `status`, `created_at`, `updated_at`)
VALUES ('edit-invoice', 'web', 'Edit Invoice', '1', now(), NULL);

-- 24-01-2024

ALTER TABLE `user_details`
CHANGE `emergency_email` `emergency_email` varchar(50) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `emergency_phone`,
CHANGE `emergency_relation` `emergency_relation` varchar(50) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `emergency_email`;

-- 25-01-2024

ALTER TABLE `sms_templates`
CHANGE `template_id` `template_id` varchar(50) COLLATE 'utf8_unicode_ci' NULL AFTER `variables`;

-- 10-02-2024

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
SELECT 'sample_professional_lor', '', '2023-02-12 21:39:39', '2023-10-27 13:51:11'
FROM `configs_site`
WHERE ((`key` = 'sample_sop' AND `key` = 'sample_sop' COLLATE utf8mb4_bin));

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
SELECT 'sample_academic_lor', '', '2023-02-12 21:39:39', '2023-10-27 13:51:11'
FROM `configs_site`
WHERE ((`key` = 'sample_professional_lor' AND `key` = 'sample_professional_lor' COLLATE utf8mb4_bin));

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
SELECT 'sample_mou', '', '2023-02-12 21:39:39', '2023-10-27 13:51:11'
FROM `configs_site`
WHERE ((`key` = 'sample_academic_lor' AND `key` = 'sample_academic_lor' COLLATE utf8mb4_bin));

-- 11-03-2024
 
CREATE TABLE `agent_resource_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category` varchar(500) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `agent_file_upload` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `country` varchar(100) DEFAULT NULL,
  `filename` varchar(255) NOT NULL,
  `category` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 20-03-2024
ALTER TABLE `country_info_folder`
ADD `image` varchar(150) COLLATE 'utf8_unicode_ci' NULL AFTER `name`;

-- 21-03-2024

ALTER TABLE `user_notification`
CHANGE `application_type` `application_type` enum('visa','university','lead','student','ticket','agent') COLLATE 'utf8_unicode_ci' NULL AFTER `application_id`;

ALTER TABLE `commission`
CHANGE `my_commission_amount` `my_commission_amount` decimal(13,2) NOT NULL AFTER `date_received`;

ALTER TABLE `college_fees`
CHANGE `college_fee_amount` `college_fee_amount` decimal(13,2) NOT NULL AFTER `date_paid`;

-- 25-03-2024

ALTER TABLE `user_notification`
CHANGE `application_type` `application_type` enum('visa','university','lead','student','ticket','agent','webinar','invoice','staff_leaves') COLLATE 'utf8_unicode_ci' NULL AFTER `application_id`;


-- 18-04-2024

INSERT INTO `permissions` (`name`, `guard_name`, `details`, `status`, `created_at`, `updated_at`)
SELECT 'application-assignment', 'web', 'Staff with this permission can assign a Application to another staff.', '1', now(), NULL
FROM `permissions`
WHERE ((`id` = '1'));

-- 25-04-2024

DROP TABLE IF EXISTS `notification_configs`;
CREATE TABLE `notification_configs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `event` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_appl_assignee` tinyint(1) NOT NULL,
  `email_staff` tinyint(1) NOT NULL,
  `email_staff_manager` tinyint(1) NOT NULL,
  `email_superadmin` tinyint(1) NOT NULL,
  `email_agent` tinyint(1) NOT NULL,
  `app_appl_assignee` tinyint(1) NOT NULL DEFAULT '0',
  `app_staff` tinyint(1) NOT NULL DEFAULT '0',
  `app_staff_manager` tinyint(1) NOT NULL DEFAULT '0',
  `app_superadmin` tinyint(1) NOT NULL DEFAULT '0',
  `app_agent` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `notification_configs` (`id`, `event`, `email_appl_assignee`, `email_staff`, `email_staff_manager`, `email_superadmin`, `email_agent`, `app_appl_assignee`, `app_staff`, `app_staff_manager`, `app_superadmin`, `app_agent`, `created_at`, `updated_at`) VALUES
(1,	'LEAD_STATUS_CHANGE',	0,	0,	0,	0,	0,	0,	1,	1,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(2,	'LEAD_PROFILE_UPDATED_BY_STAFF',	0,	1,	1,	1,	0,	0,	0,	0,	0,	0,	NULL,	'2024-03-21 05:23:50'),
(3,	'STUDENT_PROFILE_UPDATED',	0,	0,	0,	0,	0,	0,	1,	1,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(4,	'COURSE_PREFERENCE_ADDED_BY_STUDENT',	0,	0,	0,	0,	0,	0,	1,	1,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(5,	'COURSE_PREFERENCE_ADDED_BY_STAFF',	0,	0,	0,	0,	0,	0,	1,	1,	1,	1,	NULL,	'2024-04-25 12:42:14'),
(6,	'COURSE_BOOKMARKED_BY_STUDENT',	0,	0,	0,	0,	0,	0,	1,	1,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(7,	'DOCUMENT_UPLOAD_BY_STUDENT',	0,	0,	0,	0,	0,	0,	1,	1,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(8,	'COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT',	0,	0,	0,	0,	0,	0,	1,	1,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(9,	'UNIVERSITY_APPLICATION_STATUS_CHANGE',	0,	0,	0,	0,	0,	1,	1,	1,	1,	1,	NULL,	'2024-04-25 12:42:14'),
(10,	'UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT',	0,	0,	0,	0,	0,	1,	1,	1,	1,	1,	NULL,	'2024-04-25 12:42:14'),
(11,	'VISA_OTHER_APPLICATION_STATUS_CHANGE',	0,	0,	0,	0,	0,	1,	1,	1,	1,	1,	NULL,	'2024-04-25 12:42:14'),
(12,	'VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT',	0,	0,	0,	0,	0,	1,	1,	1,	1,	1,	NULL,	'2024-04-25 12:42:14'),
(13,	'SUPPORT_TICKET_ASSIGNED_TO_STAFF',	0,	0,	0,	0,	0,	0,	1,	1,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(14,	'SUPPORT_TICKET_REPLY_RECEIVED',	0,	0,	0,	0,	0,	0,	1,	1,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(15,	'SUPPORT_TICKET_STATUS_CHANGE',	0,	0,	0,	0,	0,	0,	1,	1,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(16,	'COURSE_SUGGESTED_BY_STAFF',	0,	0,	0,	0,	0,	0,	1,	1,	1,	1,	NULL,	'2024-04-25 12:42:14'),
(17,	'LEAD_STUDENT_CREATED',	0,	0,	1,	1,	0,	0,	0,	1,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(18,	'AGENT_SIGNUP',	0,	0,	1,	1,	0,	0,	0,	1,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(19,	'LEAD_STUDENT_ASSIGMENT_STAFF',	0,	0,	0,	0,	0,	0,	1,	1,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(20,	'LEAD_STUDENT_LINK_AGENT',	0,	0,	0,	0,	1,	0,	1,	1,	1,	1,	NULL,	'2024-04-25 12:42:14'),
(21,	'UNIVERSITY_APPLICATION_CREATED',	0,	0,	0,	0,	0,	0,	1,	1,	1,	1,	NULL,	'2024-04-25 12:42:14'),
(22,	'VISA_AND_SERVICES_APPLICATION_CREATED',	0,	0,	0,	0,	0,	0,	1,	1,	1,	1,	NULL,	'2024-04-25 12:42:14'),
(23,	'STUDENT_SUBMIT_APPLICATION',	0,	0,	0,	0,	0,	0,	1,	1,	1,	1,	NULL,	'2024-04-25 12:42:14'),
(24,	'AGENT_COMMISSION_ONLY',	0,	0,	0,	1,	0,	0,	0,	0,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(25,	'SUPPORT_TICKET_CREATION',	0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(26,	'STUDENT_ENROLL_WEBINAR',	0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(27,	'INVOICE_CREATE_AND_INVOICE_PAYMENT',	0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(28,	'STAFF_LEAVES_APPLY',	0,	0,	0,	1,	0,	0,	0,	0,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(29,	'STUDENT_SIGNUP',	0,	0,	1,	1,	0,	0,	0,	1,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(30,	'STUDENT_STATUS_CHANGE',	0,	0,	0,	0,	0,	0,	1,	1,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(31,	'LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE',	0,	0,	0,	0,	0,	0,	1,	1,	1,	1,	NULL,	'2024-04-25 12:42:14'),
(34,	'INVOICE_DELETE',	0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(35,	'STUDENT_STATUS_CHANGE',	0,	0,	0,	0,	0,	0,	1,	1,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(36,	'APPLICATION_ASSIGNED_STAFF',	0,	0,	0,	0,	0,	1,	1,	1,	1,	1,	NULL,	'2024-04-25 12:42:14'),
(37,	'APPLICATION_ASSIGNED_STAFF',	0,	0,	0,	0,	0,	1,	1,	1,	1,	1,	NULL,	'2024-04-25 12:42:14'),
(38,	'VISA_OTHER_APPLICATION_ASSIGNED_STAFF',	0,	0,	0,	0,	0,	1,	1,	1,	1,	1,	NULL,	'2024-04-25 12:42:14');


-- 30-04-2024

DROP TABLE IF EXISTS `agent_details`;
CREATE TABLE `agent_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `agent_id` int(11) NOT NULL,
  `logo_approved` tinyint(1) NOT NULL DEFAULT 0,
  `point_of_contact` int(11) NULL,
  `business_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `agent_category` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `agent_website_url` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `agent_id_proof` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `buis_incorpo_certi_proof` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `agent_panel_logo` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `agent_comments` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facebook` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `instagram` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `others` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- 02-05-2024
CREATE TABLE `user_notes` (
  `id` int NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `user_id` int NOT NULL,
  `staff_id` int NOT NULL,
  `notes` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL
);

-- 13-05-2024
ALTER TABLE `webinar`
CHANGE `description` `description` text COLLATE 'utf8mb4_unicode_ci' NULL AFTER `link`;

-- 16-05-2024
INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('smtp_type', 'smtp_server', now(), NULL);


INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('bulk_smtp_type', 'smtp_server', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('google_email_id', '', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('google_email_from_name', '', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('google_project_id', '', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('google_client_id', '', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('google_client_secret', '', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('google_email_reply_to', '', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('google_redirect_uri', '', now(), NULL);

-- 24-05-2024
UPDATE `mail_templates` SET
`hook` = 'STUDENT_CREATE_WELCOME' 
WHERE `hook` = 'STUDENT_CREATE';

-- 03-06-2024
INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('smtp_from_email', '', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('bulk_smtp_from_email', '', now(), NULL);

DROP TABLE IF EXISTS `activity_log`;
CREATE TABLE `activity_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(255) DEFAULT NULL,
  `description` text NOT NULL,
  `subject_id` bigint(20) unsigned DEFAULT NULL,
  `subject_type` varchar(255) DEFAULT NULL,
  `event` varchar(255) DEFAULT NULL,
  `causer_id` bigint(20) unsigned DEFAULT NULL,
  `causer_type` varchar(255) DEFAULT NULL,
  `properties` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`properties`)),
  `batch_uuid` char(36) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activity_log_log_name_index` (`log_name`),
  KEY `subject` (`subject_id`,`subject_type`),
  KEY `causer` (`causer_id`,`causer_type`),
  KEY `event_index` (`event`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 04-06-2024

DROP TABLE IF EXISTS `announcements_site`;
CREATE TABLE `announcements_site` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `area` enum('public','student','agent','admin') NOT NULL,
  `title` varchar(200) NOT NULL,
  `message` text NOT NULL,
  `created_by` int(11) NOT NULL,
  `published_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 18-06-2024

ALTER TABLE `user_activity`
CHANGE `title` `title` varchar(191) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `type`,
CHANGE `detail` `detail` text COLLATE 'utf8mb4_unicode_ci' NULL AFTER `title`;

ALTER TABLE `custom_attributes`
CHANGE `selection_values` `selection_values` text COLLATE 'utf8mb4_unicode_ci' NULL AFTER `placeholder`;

-- 19-07-2024
ALTER TABLE `users`
ADD `is_staff` tinyint(1) NOT NULL DEFAULT '0' AFTER `is_lead`,
ADD `is_agent` tinyint(1) NOT NULL DEFAULT '0' AFTER `is_staff`;

ALTER TABLE `users`
ADD `created_mode` enum('front_end','staff','agent','import','api','web2lead') NULL AFTER `archived`;

-- 20-07-2024
UPDATE users SET is_agent=1 WHERE id IN (SELECT model_id FROM model_has_roles WHERE role_id=9);
UPDATE users SET is_staff=1 WHERE id IN (SELECT model_id FROM model_has_roles WHERE role_id !=3 AND role_id != 9);

-- 23-07-2024

ALTER TABLE `user_notification`
CHANGE `created_at` `created_at` timestamp NULL AFTER `from_user`;

-- 27-07-2024

ALTER TABLE `user_details`
ADD `lead_campaign_name` varchar(400) COLLATE 'utf8mb4_unicode_ci' NULL COMMENT 'This comes from API Campaign name' AFTER `email_signature`,
ADD `lead_ad_name` varchar(400) COLLATE 'utf8mb4_unicode_ci' NULL COMMENT 'This comes from API Ad name' AFTER `lead_campaign_name`,
ADD `lead_form_name` varchar(400) COLLATE 'utf8mb4_unicode_ci' NULL COMMENT 'This comes from API Form name' AFTER `lead_ad_name`,
ADD `lead_lead_id` varchar(400) COLLATE 'utf8mb4_unicode_ci' NULL COMMENT 'This comes from API Lead Id' AFTER `lead_form_name`;

UPDATE user_details SET lead_campaign_name = campaign_id;
ALTER TABLE `user_details` DROP `campaign_id`;

-- 07-08-2024

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('student_qualification_levels', 'Class 8,Class 9,Class 10,Class 11,Class 12,Diploma,Bachelors,Masters,PhD', now(), NULL);

-- 09-08-2024

UPDATE `permissions` SET
`id` = '4',
`name` = 'university applications',
`guard_name` = 'web',
`details` = 'View/Create Student University applications, manage details, status.',
`status` = '1',
`created_at` = '2019-07-23 00:00:00',
`updated_at` = '2019-07-23 00:00:00'
WHERE `id` = '4';

-- 29-08-2024

ALTER TABLE `content_blocks`
CHANGE `section` `section` varchar(100) COLLATE 'utf8mb4_unicode_ci' NOT NULL AFTER `id`,
CHANGE `content` `content` text COLLATE 'utf8mb4_unicode_ci' NOT NULL AFTER `section`;

TRUNCATE TABLE content_blocks;
INSERT INTO content_blocks (`id`, section, content, created_at, `updated_at`) VALUES
(1,	'homepage_student_intro_heading',	'<h2>Take your first step towards Study Abroad</h2>',	'2024-08-29 07:13:55',	'2024-08-29 07:13:55'),
(2,	'homepage_student_intro_content',	'<p>Embark on an exciting journey toward studying abroad! Discover new cultures, expand your horizons, and create unforgettable memories. Let\’s make your dream a reality. 🌏🎓✈️</p>',	'2024-08-29 07:15:57',	'2024-08-29 07:15:57'),
(3,	'homepage_student_intro_banner',	'<p><img src=\"assets/images/page/student_intro1.jpg\"></p>',	'2024-08-29 07:32:09',	'2024-08-29 07:32:09');


CREATE TABLE `employment_detail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) NOT NULL,
  `employment_histroy_type` enum('Paid','Unpaid') NOT NULL,
  `employment_history_currently_working` varchar(50) NOT NULL,
  `employment_history_organisation_name` varchar(50) NOT NULL,
  `employment_history_industry_type` varchar(50) NOT NULL,
  `employment_history_employer_phone` varchar(50) NOT NULL,
  `employment_history_address` varchar(150) NOT NULL,
  `employment_history_city` varchar(50) NOT NULL,
  `employment_history_state` int(11) NOT NULL,
  `employment_history_country` int(11) NOT NULL,
  `employment_history_postcode` varchar(10) NOT NULL,
  `employment_history_contact_person_name` varchar(50) NOT NULL,
  `employment_history_contact_person_family_name` varchar(50) NOT NULL,
  `employment_history_contact_person_business_phone` varchar(50) NOT NULL,
  `employment_history_contact_person_mobile_number` varchar(50) NOT NULL,
  `employment_history_working_position_occupation` varchar(50) NOT NULL,
  `employment_history_start_date` date NOT NULL,
  `employment_history_working_ended` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


CREATE TABLE `travel_history` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned NOT NULL DEFAULT 0,
  `country_visited` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name_used_on_country` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visa_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visa_issue_at` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_up_to` date DEFAULT NULL,
  `reason_of_visit` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


CREATE TABLE `visa_application_history` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) unsigned NOT NULL DEFAULT 0,
  `country_applied_for_visa` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name_used_for_visa_apply` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visa_apply_visa_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visa_apply_application_date` date DEFAULT NULL,
  `visa_apply_application_number` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visa_apply_outcome` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


CREATE TABLE `user_family` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(10) NOT NULL,
  `first_name` varchar(100) NOT NULL,
  `last_name` varchar(100) NOT NULL,
  `relationship` enum('wife','husband','father','mother','step father','step mother','parental grand father','parental grand mother','maternal grand father','maternal grand mother','son','daughter','step son','step daughter','brother','sister','step brother','step sister') NOT NULL,
  `gender` varchar(10) NOT NULL,
  `email` varchar(191) NOT NULL,
  `dial_code` int(5) NOT NULL,
  `mobile` varchar(20) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `birth_date` date NOT NULL,
  `birth_country` int(10) NOT NULL,
  `residence_country` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


ALTER TABLE `user_academics`
ADD course_name varchar(100) COLLATE utf8mb4_unicode_ci NULL AFTER education_level,
ADD institute varchar(100) COLLATE utf8mb4_unicode_ci NULL AFTER course_name,
ADD institute_country varchar(100) COLLATE utf8mb4_unicode_ci NULL AFTER institute,
ADD campus_city varchar(100) COLLATE utf8mb4_unicode_ci NULL AFTER institute_country,
ADD postal_code varchar(20) COLLATE utf8mb4_unicode_ci NULL AFTER campus_city,
ADD start_year int(4) NULL AFTER postal_code,
ADD course_status varchar(50) COLLATE utf8mb4_unicode_ci NULL AFTER pass_year;

ALTER TABLE `users`
CHANGE `gender` `gender` enum('male','female','other') COLLATE 'utf8mb4_unicode_ci' NOT NULL DEFAULT 'male' AFTER `alternate_contact`;

ALTER TABLE `user_details`
ADD `date_of_marriage` date NULL AFTER `marital_status`;

ALTER TABLE `user_details` ADD `emergency_address` VARCHAR(100) NULL DEFAULT NULL AFTER `emergency_relation`,
ADD `emergency_country` VARCHAR(100) NULL DEFAULT NULL AFTER `emergency_address`,
ADD `emergency_state` VARCHAR(100) NULL DEFAULT NULL AFTER `emergency_country`,
ADD `emergency_city` VARCHAR(100) NULL DEFAULT NULL AFTER `emergency_state`,
ADD `emergency_postalcode` VARCHAR(50) NULL DEFAULT NULL AFTER `emergency_city`;


-- 04-09-2024

ALTER TABLE `user_family` CHANGE `email` `email` VARCHAR(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
CHANGE `dial_code` `dial_code` INT(11) NULL, 
CHANGE `mobile` `mobile` VARCHAR(20) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL, 
CHANGE `birth_date` `birth_date` DATE NULL, 
CHANGE `birth_country` `birth_country` INT(11) NULL, 
CHANGE `residence_country` `residence_country` INT(11) NULL;

ALTER TABLE `employment_detail` CHANGE `employment_history_employer_phone` `employment_history_employer_phone` VARCHAR(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
CHANGE `employment_history_postcode` `employment_history_postcode` VARCHAR(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
CHANGE `employment_history_contact_person_business_phone` `employment_history_contact_person_business_phone` VARCHAR(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
CHANGE `employment_history_contact_person_mobile_number` `employment_history_contact_person_mobile_number` VARCHAR(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
CHANGE `employment_history_working_ended` `employment_history_working_ended` DATE NULL;

ALTER TABLE `employment_detail` CHANGE `employment_history_contact_person_family_name` `employment_history_contact_person_family_name` VARCHAR(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL;

-- 17-10-2024

ALTER TABLE `ticket_reply`
ADD `all_attachment` text COLLATE 'utf8_unicode_ci' NULL;

-- 14-10-2024

ALTER TABLE `users`
ADD `ref_by` int(10) unsigned NULL DEFAULT '0' AFTER `agent_id`,
ADD `ref_status` tinyint unsigned NULL DEFAULT '0' AFTER `ref_by`,
ADD `refcode` varchar(15) NULL AFTER `ref_status`;


-- 15-10-2024

INSERT INTO `permissions` (`name`, `guard_name`, `details`, `status`, `created_at`, `updated_at`)
VALUES ('student referral', 'web', 'Staff with this permission can manage referrals feature', '1', NULL, NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('module_student_referral', '0', now(), NULL);

CREATE TABLE `referral_commission` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `credit` decimal(13,2) NOT NULL DEFAULT '0.00',
  `debit` decimal(13,2) NOT NULL DEFAULT '0.00',
  `student_id` int NOT NULL DEFAULT '0',
  `notes` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid` tinyint(1) NOT NULL DEFAULT '0',
  `paid_at` datetime DEFAULT NULL,
  `payment_notes` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NOT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 16-10-2024

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('student_referral_payout_modes', 'Bank Transfer,UPI', now(), NULL);

ALTER TABLE `user_details`
ADD `payment_pref_mode` varchar(100) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `lead_lead_id`,
ADD `payment_pref_detail` text COLLATE 'utf8mb4_unicode_ci' NULL AFTER `payment_pref_mode`;

-- 17-10-2024

ALTER TABLE `referral_commission`
ADD `payout_month` varchar(7) NULL AFTER `paid`;


-- 18-10-2024

INSERT INTO `mail_templates` (`hook`, `subject`, `variables`, `message`, `system_tpl`, `status`, `details`, `created_at`, `updated_at`)
VALUES ('STUDENT_REFERRAL_PAYOUT', 'Referral Payout', 'sitename,siteurl,email,mobile,first_name,full_name,month_year', '<p>Dear #first_name#,<br>Your referral commission for the month of #month_year# is processed. You will be paid soon.</p>', '1', '1', 'This is sent to referers when commission payout is generated by staff', now(), NULL);


-- 21-10-2024

ALTER TABLE `users`
ADD `ref_by` int(10) unsigned NULL DEFAULT '0' AFTER `agent_id`,
ADD `ref_status` tinyint unsigned NULL DEFAULT '0' AFTER `ref_by`,
ADD `refcode` varchar(15) NULL AFTER `ref_status`;

INSERT INTO `permissions` (`name`, `guard_name`, `details`, `status`, `created_at`, `updated_at`)
VALUES ('student referral', 'web', 'Staff with this permission can manage referrals feature', '1', NULL, NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('module_student_referral', '0', now(), NULL);

CREATE TABLE `referral_commission` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `credit` decimal(13,2) NOT NULL DEFAULT '0.00',
  `debit` decimal(13,2) NOT NULL DEFAULT '0.00',
  `student_id` int NOT NULL DEFAULT '0',
  `notes` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid` tinyint(1) NOT NULL DEFAULT '0',
  `paid_at` datetime DEFAULT NULL,
  `payment_notes` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NOT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('student_referral_payout_modes', 'Bank Transfer,UPI', now(), NULL);

ALTER TABLE `user_details`
ADD `payment_pref_mode` varchar(100) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `lead_lead_id`,
ADD `payment_pref_detail` text COLLATE 'utf8mb4_unicode_ci' NULL AFTER `payment_pref_mode`;

ALTER TABLE `referral_commission`
ADD `payout_month` varchar(7) NULL AFTER `paid`;

INSERT INTO `mail_templates` (`hook`, `subject`, `variables`, `message`, `system_tpl`, `status`, `details`, `created_at`, `updated_at`)
VALUES ('STUDENT_REFERRAL_PAYOUT', 'Referral Payout', 'sitename,siteurl,email,mobile,first_name,full_name,month_year', '<p>Dear #first_name#,<br>Your referral commission for the month of #month_year# is processed. You will be paid soon.</p>', '1', '1', 'This is sent to referers when commission payout is generated by staff', now(), NULL);

INSERT INTO `mail_templates` (`hook`, `subject`, `variables`, `message`, `system_tpl`, `status`, `details`, `created_at`, `updated_at`)
VALUES ('MONTHLY_REFERRALS_REPORT', 'Monthly Referrals Report', 'sitename,siteurl,email,mobile,first_name,full_name,month_year,referral_table,referral_count', '<p>Dear #full_name#,</p><p>This is your monthly referrals report. You can view your referral statistics at any time by logging in to the portal &amp; visit My Account &gt; Referrals.</p><p>Total Students Referred: #referral_count#</p><p>Your Referrals for the Month of #month_year# :</p><p>&nbsp;</p><p>#referral_table#</p><p>Remember, you can refer students using your unique affiliate link: #affiliate_url#</p><p>Thank You,</p><p>#sitename# Team</p>', '1', '1', 'This is sent to referers on 1st day of every month', now(), NULL);

ALTER TABLE `users`
ADD `lead_form_type` varchar(100) NULL AFTER `lead_source`;

DROP TABLE IF EXISTS `forms`;
CREATE TABLE `forms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `form_heading` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `redirect_url` varchar(255) NOT NULL,
  `branch` int(11) NOT NULL,
  `assign_to` int(11) DEFAULT NULL,
  `content` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `form_items`;
CREATE TABLE `form_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `label` varchar(255) DEFAULT NULL,
  `placeholder` varchar(255) DEFAULT NULL,
  `hint` varchar(255) DEFAULT NULL,
  `mandatory` int(1) DEFAULT 0,
  `unique` int(1) DEFAULT 0,
  `input_name` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `target` varchar(255) DEFAULT NULL,
  `form_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 23-10-2024

ALTER TABLE `staff_details`
ADD `photo` varchar(255) NULL AFTER `staff_id`,
ADD `gender` enum('male','female') NULL AFTER `photo`,
ADD `marital_status` enum('single','married') NULL AFTER `gender`,
ADD `dob` date NULL AFTER `marital_status`,
ADD `father_name` varchar(191) NULL AFTER `dob`,
ADD `mother_name` varchar(191) NULL AFTER `father_name`,
ADD `blood_group` varchar(191) NULL AFTER `mother_name`,
ADD `aadhar_no` varchar(191) NULL AFTER `blood_group`,
ADD `pan_no` varchar(191) NULL AFTER `aadhar_no`,
ADD `address` varchar(191) NULL AFTER `pan_no`,
ADD `country` int unsigned NULL AFTER `address`,
ADD `state` int unsigned NULL AFTER `country`,
ADD `city` varchar(191) NULL AFTER `state`,
ADD `postal_code` varchar(15) NULL AFTER `city`,
ADD `emp_id` varchar(15) NULL AFTER `postal_code`,
ADD `designation` varchar(191) NULL AFTER `emp_id`,
ADD `department` varchar(191) NULL AFTER `designation`,
ADD `ctc` int unsigned NULL AFTER `department`,
ADD `emp_start_date` date NULL AFTER `ctc`,
ADD `reporting_to` varchar(191) NULL AFTER `emp_start_date`,
ADD `bank_account_no` varchar(191) NULL AFTER `reporting_to`,
ADD `bank_payee` varchar(191) NULL AFTER `bank_account_no`,
ADD `bank_ifsc` varchar(191) NULL AFTER `bank_payee`,
ADD `bank_branch` varchar(191) NULL AFTER `bank_ifsc`,
ADD `bank_bank_name` varchar(191) NULL AFTER `bank_branch`,
ADD `doc_offer_letter` varchar(191) NULL AFTER `bank_bank_name`,
ADD `doc_resume` varchar(191) NULL AFTER `doc_offer_letter`,
ADD `doc_contract_agreement` varchar(191) NULL AFTER `doc_resume`,
ADD `doc_pan_card` varchar(191) NULL AFTER `doc_contract_agreement`,
ADD `doc_aadhar_card` varchar(191) NULL AFTER `doc_pan_card`;


INSERT INTO `permissions` (`name`, `guard_name`, `details`, `status`, `created_at`, `updated_at`)
VALUES ('university invoice', 'web', 'Create university invoices, record payments, manage university invoices.', '1', now(), NULL);


DROP TABLE IF EXISTS `uni_invoice_payment`;
CREATE TABLE `uni_invoice_payment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` int(11) NOT NULL,
  `payment_date` date NOT NULL,
  `amount` decimal(13,2) NOT NULL,
  `pay_mode` enum('bank_transfer','cheque') NOT NULL,
  `trans_id` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

ALTER TABLE `users`
ADD `sid` varchar(20) NULL COMMENT 'ID given by the University' AFTER `uuid`;

ALTER TABLE `universities`
ADD `tax_type` enum('inclusive','exclusive') NULL AFTER `commission_count`,
ADD `tax_percent` decimal(13,1) NULL AFTER `tax_type`;

ALTER TABLE `university_application`
ADD `my_commission_percent` decimal(13,2) NULL AFTER `my_commission`,
ADD `agent_commission_percent` decimal(13,2) NULL AFTER `agent_commission`;

DROP TABLE IF EXISTS `uni_invoice`;
CREATE TABLE `uni_invoice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_num` int(11) NOT NULL,
  `university_id` int(11) NOT NULL,
  `ad_hoc` tinyint(1) NOT NULL DEFAULT 0,
  `item1` varchar(191) DEFAULT NULL,
  `item1_amount` decimal(13,2) NOT NULL DEFAULT 0.00,
  `payment_stage` varchar(191) NOT NULL COMMENT '1,2,3,4 comma seperated',
  `due_date` date NOT NULL,
  `currency` varchar(3) NOT NULL,
  `sub_total` decimal(13,2) NOT NULL,
  `tax` decimal(13,2) NOT NULL,
  `tax_rate` decimal(13,2) NOT NULL,
  `tax_type` enum('inclusive','exclusive') DEFAULT NULL,
  `total` decimal(13,2) NOT NULL,
  `commission_rate` decimal(13,5) NULL,
  `status` enum('due','paid') NOT NULL DEFAULT 'due',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `invoice_num` (`invoice_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `uni_invoice_detail`;
CREATE TABLE `uni_invoice_detail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `commission` decimal(13,2) NOT NULL,
  `uni_application_id` int(11) NOT NULL,
  `tax` decimal(13,2) NOT NULL,
  `total` decimal(13,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

ALTER TABLE `uni_invoice_detail`
ADD `commission_rate` decimal(13,5) NOT NULL COMMENT 'For uni apply agent invoice' AFTER `student_id`;

ALTER TABLE `uni_invoice`
ADD `uni_apply_agent_id` int NULL AFTER `university_id`;

DROP TABLE IF EXISTS `uni_apply_agents`;
CREATE TABLE `uni_apply_agents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `address` text DEFAULT NULL,
  `phone` varchar(12) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `tax_id` varchar(50) DEFAULT NULL,
  `tax_type` enum('inclusive','exclusive') DEFAULT NULL,
  `tax_percent` decimal(13,1) DEFAULT NULL,
  `commission_count` int(11) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

ALTER TABLE `university_courses`
ADD `total_tuition_fee` varchar(191) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `yearly_tuition_fee`;

ALTER TABLE `agent_commission`
ADD `currency` varchar(3) NULL AFTER `appl_id`;

ALTER TABLE `agent_commission`
ADD `amount_base` decimal(13,2) NOT NULL DEFAULT '0.00' AFTER `amount`,
ADD `deduction_base` decimal(13,2) NOT NULL DEFAULT '0.00' AFTER `deduction`,
ADD `net_pay_base` decimal(13,2) NOT NULL DEFAULT '0.00' AFTER `net_pay`,
ADD `net_pay_agent` decimal(13,2) NOT NULL DEFAULT '0.00' COMMENT 'Actual amount paid in his local currency' AFTER `net_pay_base`;

ALTER TABLE agent_commission AUTO_INCREMENT=102364;

-- 25-10-2024

DROP TABLE IF EXISTS `countries`;
CREATE TABLE `countries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(191) DEFAULT NULL,
  `title_en` varchar(191) DEFAULT NULL,
  `tel` int(11) DEFAULT NULL,
  `currency` varchar(3) NOT NULL DEFAULT 'USD',
  `rate` decimal(13,5) DEFAULT NULL,
  `currency_name` varchar(50) NOT NULL DEFAULT 'US Dollar',
  `overseas_status` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `title_fr` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `countries` (`id`, `code`, `title_en`, `tel`, `currency`, `rate`, `currency_name`, `overseas_status`, `created_at`, `updated_at`, `title_fr`) VALUES
(1,	'AF',	'Afghanistan',	93,	'AFN',	0.80052,	'Afghani',	0,	NULL,	NULL,	''),
(2,	'AL',	'Albania',	355,	'ALL',	1.09527,	'Lek',	0,	NULL,	NULL,	''),
(3,	'DZ',	'Algeria',	213,	'DZD',	1.60098,	'Algerian Dinar',	0,	NULL,	NULL,	''),
(4,	'AS',	'American Samoa',	1684,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(5,	'AD',	'Andorra',	376,	'EUR',	0.01110,	'Euro',	0,	NULL,	NULL,	''),
(6,	'AO',	'Angola',	244,	'AOA',	10.92782,	'Kwanza',	0,	NULL,	NULL,	''),
(7,	'AI',	'Anguilla',	1264,	'XCD',	0.03238,	'East Caribbean Dollar',	0,	NULL,	NULL,	''),
(9,	'AG',	'Antigua and Barbuda',	1268,	'XCD',	0.03238,	'East Caribbean Dollar',	0,	NULL,	NULL,	''),
(10,	'AR',	'Argentina',	54,	'ARS',	11.79986,	'Argentine Peso',	0,	NULL,	NULL,	''),
(11,	'AM',	'Armenia',	374,	'AMD',	4.63222,	'Armenian Dram',	0,	NULL,	NULL,	''),
(12,	'AW',	'Aruba',	297,	'AWG',	0.02160,	'Aruban Florin',	0,	NULL,	NULL,	''),
(13,	'AU',	'Australia',	61,	'AUD',	0.01800,	'Australian Dollar',	1,	NULL,	NULL,	''),
(14,	'AT',	'Austria',	43,	'EUR',	0.01110,	'Euro',	1,	NULL,	NULL,	''),
(15,	'AZ',	'Azerbaijan',	994,	'AZN',	0.02040,	'Azerbaijanian Manat',	0,	NULL,	NULL,	''),
(16,	'BS',	'Bahamas',	1242,	'BSD',	0.01197,	'Bahamian Dollar',	0,	NULL,	NULL,	''),
(17,	'BH',	'Bahrain',	973,	'BHD',	0.00452,	'Bahraini Dinar',	0,	NULL,	NULL,	''),
(18,	'BD',	'Bangladesh',	880,	'BDT',	1.43031,	'Taka',	0,	NULL,	NULL,	''),
(19,	'BB',	'Barbados',	1246,	'BBD',	0.02417,	'Barbados Dollar',	0,	NULL,	NULL,	''),
(20,	'BY',	'Belarus',	375,	'BYR',	234.85225,	'Belarussian Ruble',	0,	NULL,	NULL,	''),
(21,	'BE',	'Belgium',	32,	'EUR',	0.01110,	'Euro',	0,	NULL,	NULL,	''),
(22,	'BZ',	'Belize',	501,	'BZD',	0.02413,	'Belize Dollar',	0,	NULL,	NULL,	''),
(23,	'BJ',	'Benin',	229,	'XOF',	7.28505,	'CFA Franc BCEAO',	0,	NULL,	NULL,	''),
(24,	'BM',	'Bermuda',	1441,	'BMD',	0.01198,	'Bermudian Dollar',	0,	NULL,	NULL,	''),
(25,	'BT',	'Bhutan',	975,	'BTN',	1.00732,	'Bhutanese Ngultrum',	0,	NULL,	NULL,	''),
(26,	'BO',	'Bolivia',	591,	'BOB',	0.08270,	'Boliviano',	0,	NULL,	NULL,	''),
(27,	'BA',	'Bosnia and Herzegovina',	387,	'BAM',	0.02172,	'Convertible Mark',	0,	NULL,	NULL,	''),
(28,	'BW',	'Botswana',	267,	'BWP',	0.15970,	'Pula',	0,	NULL,	NULL,	''),
(30,	'BR',	'Brazil',	55,	'BRL',	0.06818,	'Brazilian Real',	0,	NULL,	NULL,	''),
(31,	'IO',	'British Indian Ocean Territory',	246,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(32,	'BN',	'Brunei Darussalam',	673,	'BND',	0.01581,	'Brunei Dollar',	0,	NULL,	NULL,	''),
(33,	'BG',	'Bulgaria',	359,	'BGN',	0.02173,	'Bulgarian Lev',	1,	NULL,	NULL,	''),
(34,	'BF',	'Burkina Faso',	226,	'XOF',	7.28505,	'CFA Franc BCEAO',	0,	NULL,	NULL,	''),
(35,	'BI',	'Burundi',	257,	'BIF',	34.75748,	'Burundi Franc',	0,	NULL,	NULL,	''),
(36,	'KH',	'Cambodia',	855,	'KHR',	48.68891,	'Riel',	0,	NULL,	NULL,	''),
(37,	'CM',	'Cameroon',	237,	'XAF',	7.28509,	'CFA Franc BEAC',	0,	NULL,	NULL,	''),
(38,	'CA',	'Canada',	1,	'CAD',	0.01656,	'Canadian Dollar',	1,	NULL,	NULL,	''),
(39,	'CV',	'Cape Verde',	238,	'CVE',	1.22458,	'Cabo Verde Escudo',	0,	NULL,	NULL,	''),
(40,	'KY',	'Cayman Islands',	1345,	'KYD',	0.00997,	'Cayman Islands Dollar',	0,	NULL,	NULL,	''),
(41,	'CF',	'Central African Republic',	236,	'XAF',	7.28509,	'CFA Franc BEAC',	0,	NULL,	NULL,	''),
(42,	'TD',	'Chad',	235,	'XAF',	7.28509,	'CFA Franc BEAC',	0,	NULL,	NULL,	''),
(43,	'CL',	'Chile',	56,	'CLP',	11.32718,	'Chilean Peso',	0,	NULL,	NULL,	''),
(44,	'CN',	'China',	86,	'CNY',	0.08522,	'Yuan Renminbi',	1,	NULL,	NULL,	''),
(45,	'CX',	'Christmas Island',	61,	'AUD',	0.01800,	'Australian Dollar',	0,	NULL,	NULL,	''),
(46,	'CC',	'Cocos (Keeling) Islands',	672,	'AUD',	0.01800,	'Australian Dollar',	0,	NULL,	NULL,	''),
(47,	'CO',	'Colombia',	57,	'COP',	51.62556,	'Colombian Peso',	0,	NULL,	NULL,	''),
(48,	'KM',	'Comoros',	269,	'KMF',	5.46211,	'Comoro Franc',	0,	NULL,	NULL,	''),
(49,	'CG',	'Congo',	242,	'XAF',	7.28509,	'CFA Franc BEAC',	0,	NULL,	NULL,	''),
(50,	'CD',	'Congo, the Democratic Republic of the',	242,	'',	NULL,	'',	0,	NULL,	NULL,	''),
(51,	'CK',	'Cook Islands',	682,	'NZD',	0.01990,	'New Zealand Dollar',	0,	NULL,	NULL,	''),
(52,	'CR',	'Costa Rica',	506,	'CRC',	6.17163,	'Costa Rican Colon',	0,	NULL,	NULL,	''),
(53,	'CI',	'C?te d\'Ivoire',	225,	'XOF',	7.28505,	'CFA Franc BCEAO',	0,	NULL,	NULL,	''),
(54,	'HR',	'Croatia',	385,	'HRK',	0.08255,	'Croatian Kuna',	1,	NULL,	NULL,	''),
(55,	'CU',	'Cuba',	53,	'CUP',	0.31753,	'Cuban Peso',	0,	NULL,	NULL,	''),
(56,	'CY',	'Cyprus',	357,	'EUR',	0.01110,	'Euro',	1,	NULL,	NULL,	''),
(57,	'CZ',	'Czech Republic',	420,	'CZK',	0.27989,	'Czech Koruna',	1,	NULL,	NULL,	''),
(58,	'DK',	'Denmark',	45,	'DKK',	0.08279,	'Danish Krone',	1,	NULL,	NULL,	''),
(59,	'DJ',	'Djibouti',	253,	'DJF',	2.13146,	'Djibouti Franc',	0,	NULL,	NULL,	''),
(60,	'DM',	'Dominica',	1767,	'XCD',	0.03238,	'East Caribbean Dollar',	0,	NULL,	NULL,	''),
(61,	'DO',	'Dominican Republic',	1809,	'DOP',	0.72089,	'Dominican Peso',	0,	NULL,	NULL,	''),
(62,	'TP',	'East Timor',	670,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(63,	'EC',	'Ecuador',	593,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(64,	'EG',	'Egypt',	20,	'EGP',	0.58438,	'Egyptian Pound',	0,	NULL,	NULL,	''),
(65,	'SV',	'El Salvador',	503,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(66,	'GQ',	'Equatorial Guinea',	240,	'XAF',	7.28509,	'CFA Franc BEAC',	0,	NULL,	NULL,	''),
(67,	'ER',	'Eritrea',	291,	'ERN',	0.17973,	'Nakfa',	0,	NULL,	NULL,	''),
(68,	'EE',	'Estonia',	372,	'EUR',	0.01110,	'Euro',	0,	NULL,	NULL,	''),
(69,	'ET',	'Ethiopia',	251,	'ETB',	1.42660,	'Ethiopian Birr',	0,	NULL,	NULL,	''),
(70,	'XA',	'External Territories of Australia',	61,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(71,	'FK',	'Falkland Islands (Malvinas)',	500,	'FKP',	0.00917,	'Falkland Islands Pound',	0,	NULL,	NULL,	''),
(72,	'FO',	'Faroe Islands',	298,	'DKK',	0.08279,	'Danish Krone',	0,	NULL,	NULL,	''),
(73,	'FJ',	'Fiji',	679,	'FJD',	0.02683,	'Fiji Dollar',	0,	NULL,	NULL,	''),
(74,	'FI',	'Finland',	358,	'EUR',	0.01110,	'Euro',	1,	NULL,	NULL,	''),
(75,	'FR',	'France',	33,	'EUR',	0.01110,	'Euro',	1,	NULL,	NULL,	''),
(76,	'GF',	'French Guiana',	594,	'EUR',	0.01110,	'Euro',	0,	NULL,	NULL,	''),
(77,	'PF',	'French Polynesia',	689,	'XPF',	1.32429,	'CFP Franc',	0,	NULL,	NULL,	''),
(78,	'TF',	'French Southern Territories',	0,	'EUR',	0.01110,	'Euro',	0,	NULL,	NULL,	''),
(79,	'GA',	'Gabon',	241,	'XAF',	7.28509,	'CFA Franc BEAC',	0,	NULL,	NULL,	''),
(80,	'GM',	'Gambia',	220,	'GMD',	0.83876,	'Dalasi',	0,	NULL,	NULL,	''),
(81,	'GE',	'Georgia',	995,	'GEL',	0.03283,	'Lari',	1,	NULL,	NULL,	''),
(82,	'DE',	'Germany',	49,	'EUR',	0.01110,	'Euro',	1,	NULL,	NULL,	''),
(83,	'GH',	'Ghana',	233,	'GHS',	0.19289,	'Ghana Cedi',	0,	NULL,	NULL,	''),
(84,	'GI',	'Gibraltar',	350,	'GIP',	0.00917,	'Gibraltar Pound',	0,	NULL,	NULL,	''),
(85,	'GR',	'Greece',	30,	'EUR',	0.01110,	'Euro',	1,	NULL,	NULL,	''),
(86,	'GL',	'Greenland',	299,	'DKK',	0.08279,	'Danish Krone',	0,	NULL,	NULL,	''),
(87,	'GD',	'Grenada',	1473,	'XCD',	0.03238,	'East Caribbean Dollar',	0,	NULL,	NULL,	''),
(88,	'GP',	'Guadeloupe',	590,	'EUR',	0.01110,	'Euro',	0,	NULL,	NULL,	''),
(89,	'GU',	'Guam',	1671,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(90,	'GT',	'Guatemala',	502,	'GTQ',	0.09256,	'Quetzal',	0,	NULL,	NULL,	''),
(91,	'GG',	'Guernsey',	44,	'GBP',	0.00924,	'Pound Sterling',	0,	NULL,	NULL,	''),
(92,	'GN',	'Guinea',	224,	'GNF',	103.25195,	'Guinea Franc',	0,	NULL,	NULL,	''),
(93,	'GW',	'Guinea-Bissau',	245,	'XOF',	7.28505,	'CFA Franc BCEAO',	0,	NULL,	NULL,	''),
(94,	'GY',	'Guyana',	592,	'GYD',	2.50225,	'Guyana Dollar',	0,	NULL,	NULL,	''),
(95,	'HT',	'Haiti',	509,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(97,	'HN',	'Honduras',	504,	'HNL',	0.30168,	'Lempira',	0,	NULL,	NULL,	''),
(98,	'HK',	'Hong Kong',	852,	'HKD',	0.09310,	'Hong Kong Dollar',	0,	NULL,	NULL,	''),
(99,	'HU',	'Hungary',	36,	'HUF',	4.46950,	'Forint',	1,	NULL,	NULL,	''),
(100,	'IS',	'Iceland',	354,	'ISK',	1.65463,	'Iceland Krona',	0,	NULL,	NULL,	''),
(101,	'IN',	'India',	91,	'INR',	1.00744,	'Indian Rupee',	1,	NULL,	NULL,	''),
(102,	'ID',	'Indonesia',	62,	'IDR',	186.76685,	'Rupiah',	0,	NULL,	NULL,	''),
(103,	'IR',	'Iran',	98,	'IRR',	504.36319,	'Iranian Rial',	0,	NULL,	NULL,	''),
(104,	'IQ',	'Iraq',	964,	'IQD',	15.68041,	'Iraqi Dinar',	0,	NULL,	NULL,	''),
(105,	'IE',	'Ireland',	353,	'EUR',	0.01110,	'Euro',	1,	NULL,	NULL,	''),
(106,	'IL',	'Israel',	972,	'ILS',	0.04540,	'New Israeli Sheqel',	0,	NULL,	NULL,	''),
(107,	'IT',	'Italy',	39,	'EUR',	0.01110,	'Euro',	1,	NULL,	NULL,	''),
(108,	'JM',	'Jamaica',	1876,	'JMD',	1.89969,	'Jamaican Dollar',	0,	NULL,	NULL,	''),
(109,	'JP',	'Japan',	81,	'JPY',	1.82376,	'Yen',	0,	NULL,	NULL,	''),
(110,	'JE',	'Jersey',	44,	'GBP',	0.00924,	'Pound Sterling',	0,	NULL,	NULL,	''),
(111,	'JO',	'Jordan',	962,	'JOD',	0.00850,	'Jordanian Dinar',	0,	NULL,	NULL,	''),
(112,	'KZ',	'Kazakhstan',	7,	'KZT',	5.81482,	'Tenge',	0,	NULL,	NULL,	''),
(113,	'KE',	'Kenya',	254,	'KES',	1.54404,	'Kenyan Shilling',	0,	NULL,	NULL,	''),
(114,	'KI',	'Kiribati',	686,	'AUD',	0.01800,	'Australian Dollar',	0,	NULL,	NULL,	''),
(115,	'KP',	'Korea, North',	850,	'KPW',	10.78403,	'North Korean Won',	0,	NULL,	NULL,	''),
(116,	'KR',	'Korea, South',	82,	'KRW',	16.51604,	'Won',	0,	NULL,	NULL,	''),
(117,	'KW',	'Kuwait',	965,	'KWD',	0.00367,	'Kuwaiti Dinar',	0,	NULL,	NULL,	''),
(118,	'KG',	'Kyrgyzstan',	996,	'KGS',	1.02440,	'Som',	0,	NULL,	NULL,	''),
(119,	'LA',	'Laos',	856,	'LAK',	262.97884,	'Kip',	0,	NULL,	NULL,	''),
(120,	'LV',	'Latvia',	371,	'EUR',	0.01110,	'Euro',	1,	NULL,	NULL,	''),
(121,	'LB',	'Lebanon',	961,	'LBP',	1071.86729,	'Lebanese Pound',	0,	NULL,	NULL,	''),
(122,	'LS',	'Lesotho',	266,	'ZAR',	0.21221,	'Rand',	0,	NULL,	NULL,	''),
(123,	'LR',	'Liberia',	231,	'LRD',	2.30412,	'Liberian Dollar',	0,	NULL,	NULL,	''),
(124,	'LY',	'Libya',	218,	'LYD',	0.05766,	'Libyan Dinar',	0,	NULL,	NULL,	''),
(125,	'LI',	'Liechtenstein',	423,	'CHF',	0.01038,	'Swiss Franc',	0,	NULL,	NULL,	''),
(126,	'LT',	'Lithuania',	370,	'EUR',	0.01110,	'Euro',	1,	NULL,	NULL,	''),
(127,	'LU',	'Luxembourg',	352,	'EUR',	0.01110,	'Euro',	0,	NULL,	NULL,	''),
(128,	'MO',	'Macao',	853,	'MOP',	0.09580,	'Pataca',	0,	NULL,	NULL,	''),
(129,	'MK',	'Macedonia, the Former Yugoslav Republic of',	389,	'MKD',	0.68276,	'Denar',	0,	NULL,	NULL,	''),
(130,	'MG',	'Madagascar',	261,	'MGA',	55.47470,	'Malagasy Ariary',	0,	NULL,	NULL,	''),
(131,	'MW',	'Malawi',	265,	'MWK',	20.75498,	'Kwacha',	0,	NULL,	NULL,	''),
(132,	'MY',	'Malaysia',	60,	'MYR',	0.05215,	'Malaysian Ringgit',	1,	NULL,	NULL,	''),
(133,	'MV',	'Maldives',	960,	'MVR',	0.18392,	'Rufiyaa',	0,	NULL,	NULL,	''),
(134,	'ML',	'Mali',	223,	'XOF',	7.28505,	'CFA Franc BCEAO',	0,	NULL,	NULL,	''),
(135,	'MT',	'Malta',	356,	'EUR',	0.01110,	'Euro',	1,	NULL,	NULL,	''),
(136,	'XM',	'Man (Isle of)',	44,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(137,	'MH',	'Marshall Islands',	692,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(138,	'MQ',	'Martinique',	596,	'EUR',	0.01110,	'Euro',	0,	NULL,	NULL,	''),
(139,	'MR',	'Mauritania',	222,	'MRO',	NULL,	'Ouguiya',	0,	NULL,	NULL,	''),
(140,	'MU',	'Mauritius',	230,	'MUR',	0.55346,	'Mauritius Rupee',	1,	NULL,	NULL,	''),
(141,	'YT',	'Mayotte',	269,	'EUR',	0.01110,	'Euro',	0,	NULL,	NULL,	''),
(142,	'MX',	'Mexico',	52,	'MXN',	0.23731,	'Mexican Peso',	0,	NULL,	NULL,	''),
(143,	'FM',	'Micronesia, Federated States of',	691,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(144,	'MD',	'Moldova, Republic of',	373,	'MDL',	0.21479,	'Moldovan Leu',	0,	NULL,	NULL,	''),
(145,	'MC',	'Monaco',	377,	'EUR',	0.01110,	'Euro',	0,	NULL,	NULL,	''),
(146,	'MN',	'Mongolia',	976,	'MNT',	40.71571,	'Tugrik',	0,	NULL,	NULL,	''),
(147,	'MS',	'Montserrat',	1664,	'XCD',	0.03238,	'East Caribbean Dollar',	0,	NULL,	NULL,	''),
(148,	'MA',	'Morocco',	212,	'MAD',	0.11858,	'Moroccan Dirham',	0,	NULL,	NULL,	''),
(149,	'MZ',	'Mozambique',	258,	'MZN',	0.76555,	'Mozambique Metical',	0,	NULL,	NULL,	''),
(150,	'MM',	'Myanmar',	95,	'MMK',	38.91790,	'Kyat',	0,	NULL,	NULL,	''),
(151,	'NA',	'Namibia',	264,	'ZAR',	0.21221,	'Rand',	0,	NULL,	NULL,	''),
(152,	'NR',	'Nauru',	674,	'AUD',	0.01800,	'Australian Dollar',	0,	NULL,	NULL,	''),
(153,	'NP',	'Nepal',	977,	'NPR',	1.61174,	'Nepalese Rupee',	0,	NULL,	NULL,	''),
(155,	'NL',	'Netherlands',	31,	'USD',	0.01198,	'US Dollar',	1,	NULL,	NULL,	''),
(156,	'NC',	'New Caledonia',	687,	'XPF',	1.32429,	'CFP Franc',	0,	NULL,	NULL,	''),
(157,	'NZ',	'New Zealand',	64,	'NZD',	0.01990,	'New Zealand Dollar',	1,	NULL,	NULL,	''),
(158,	'NI',	'Nicaragua',	505,	'NIO',	0.44046,	'Cordoba Oro',	0,	NULL,	NULL,	''),
(159,	'NE',	'Niger',	227,	'XOF',	7.28505,	'CFA Franc BCEAO',	0,	NULL,	NULL,	''),
(160,	'NG',	'Nigeria',	234,	'NGN',	19.67930,	'Naira',	0,	NULL,	NULL,	''),
(161,	'NU',	'Niue',	683,	'NZD',	0.01990,	'New Zealand Dollar',	0,	NULL,	NULL,	''),
(162,	'NF',	'Norfolk Island',	672,	'AUD',	0.01800,	'Australian Dollar',	0,	NULL,	NULL,	''),
(163,	'MP',	'Northern Mariana Islands',	1670,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(164,	'NO',	'Norway',	47,	'NOK',	0.13119,	'Norwegian Krone',	0,	NULL,	NULL,	''),
(165,	'OM',	'Oman',	968,	'OMR',	0.00461,	'Rial Omani',	0,	NULL,	NULL,	''),
(166,	'PK',	'Pakistan',	92,	'PKR',	3.32453,	'Pakistan Rupee',	0,	NULL,	NULL,	''),
(167,	'PW',	'Palau',	680,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(168,	'PS',	'Palestinian Territory Occupied',	970,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(169,	'PA',	'Panama',	507,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(170,	'PG',	'Papua New Guinea',	675,	'PGK',	0.04786,	'Kina',	0,	NULL,	NULL,	''),
(171,	'PY',	'Paraguay',	595,	'PYG',	94.96736,	'Guarani',	0,	NULL,	NULL,	''),
(172,	'PE',	'Peru',	51,	'PEN',	0.04490,	'Nuevo Sol',	0,	NULL,	NULL,	''),
(173,	'PH',	'Philippines',	63,	'PHP',	0.69451,	'Philippine Peso',	0,	NULL,	NULL,	''),
(175,	'PL',	'Poland',	48,	'PLN',	0.04819,	'Zloty',	0,	NULL,	NULL,	''),
(176,	'PT',	'Portugal',	351,	'EUR',	0.01110,	'Euro',	1,	NULL,	NULL,	''),
(177,	'PR',	'Puerto Rico',	1787,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(178,	'QA',	'Qatar',	974,	'QAR',	0.04365,	'Qatari Rial',	0,	NULL,	NULL,	''),
(179,	'RE',	'Reunion',	262,	'EUR',	0.01110,	'Euro',	0,	NULL,	NULL,	''),
(180,	'RO',	'Romania',	40,	'RON',	0.05519,	'New Romanian Leu',	0,	NULL,	NULL,	''),
(181,	'RU',	'Russia',	70,	'RUB',	1.15958,	'Russian Ruble',	1,	NULL,	NULL,	''),
(182,	'RW',	'Rwanda',	250,	'RWF',	16.18928,	'Rwanda Franc',	0,	NULL,	NULL,	''),
(183,	'SH',	'Saint Helena',	290,	'SHP',	0.00917,	'Saint Helena Pound',	0,	NULL,	NULL,	''),
(184,	'KN',	'Saint Kitts and Nevis',	1869,	'XCD',	0.03238,	'East Caribbean Dollar',	0,	NULL,	NULL,	''),
(185,	'LC',	'Saint Lucia',	1758,	'XCD',	0.03238,	'East Caribbean Dollar',	0,	NULL,	NULL,	''),
(186,	'PM',	'Saint Pierre and Miquelon',	508,	'EUR',	0.01110,	'Euro',	0,	NULL,	NULL,	''),
(187,	'VC',	'Saint Vincent and the Grenadines',	1784,	'XCD',	0.03238,	'East Caribbean Dollar',	0,	NULL,	NULL,	''),
(188,	'WS',	'Samoa',	684,	'WST',	0.03356,	'Tala',	0,	NULL,	NULL,	''),
(189,	'SM',	'San Marino',	378,	'EUR',	0.01110,	'Euro',	0,	NULL,	NULL,	''),
(190,	'ST',	'Sao Tome and Principe',	239,	'STD',	248.00854,	'Dobra',	0,	NULL,	NULL,	''),
(191,	'SA',	'Saudi Arabia',	966,	'SAR',	0.04500,	'Saudi Riyal',	0,	NULL,	NULL,	''),
(192,	'SN',	'Senegal',	221,	'XOF',	7.28505,	'CFA Franc BCEAO',	0,	NULL,	NULL,	''),
(193,	'RS',	'Serbia',	381,	'RSD',	1.29883,	'Serbian Dinar',	0,	NULL,	NULL,	''),
(194,	'SC',	'Seychelles',	248,	'SCR',	0.16319,	'Seychelles Rupee',	0,	NULL,	NULL,	''),
(195,	'SL',	'Sierra Leone',	232,	'SLL',	251.26191,	'Leone',	0,	NULL,	NULL,	''),
(196,	'SG',	'Singapore',	65,	'SGD',	0.01582,	'Singapore Dollar',	1,	NULL,	NULL,	''),
(197,	'SK',	'Slovakia',	421,	'EUR',	0.01110,	'Euro',	0,	NULL,	NULL,	''),
(198,	'SI',	'Slovenia',	386,	'EUR',	0.01110,	'Euro',	0,	NULL,	NULL,	''),
(199,	'XG',	'Smaller Territories of the UK',	44,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(200,	'SB',	'Solomon Islands',	677,	'SBD',	0.09928,	'Solomon Islands Dollar',	0,	NULL,	NULL,	''),
(201,	'SO',	'Somalia',	252,	'SOS',	6.84021,	'Somali Shilling',	0,	NULL,	NULL,	''),
(202,	'ZA',	'South Africa',	27,	'ZAR',	0.21221,	'Rand',	1,	NULL,	NULL,	''),
(204,	'SS',	'South Sudan',	211,	'SSP',	NULL,	'South Sudanese Pound',	0,	NULL,	NULL,	''),
(205,	'ES',	'Spain',	34,	'EUR',	0.01110,	'Euro',	1,	NULL,	NULL,	''),
(206,	'LK',	'Sri Lanka',	94,	'LKR',	3.51305,	'Sri Lanka Rupee',	0,	NULL,	NULL,	''),
(207,	'SD',	'Sudan',	249,	'SDG',	7.20758,	'Sudanese Pound',	0,	NULL,	NULL,	''),
(208,	'SR',	'Suriname',	597,	'SRD',	0.40274,	'Surinam Dollar',	0,	NULL,	NULL,	''),
(209,	'SJ',	'Svalbard and Jan Mayen',	47,	'NOK',	0.13119,	'Norwegian Krone',	0,	NULL,	NULL,	''),
(210,	'SZ',	'Swaziland',	268,	'SZL',	0.21068,	'Lilangeni',	0,	NULL,	NULL,	''),
(211,	'SE',	'Sweden',	46,	'SEK',	0.12671,	'Swedish Krona',	1,	NULL,	NULL,	''),
(212,	'CH',	'Switzerland',	41,	'CHF',	0.01038,	'Swiss Franc',	1,	NULL,	NULL,	''),
(213,	'SY',	'Syrian Arab Republic',	963,	'SYP',	30.10578,	'Syrian Pound',	0,	NULL,	NULL,	''),
(214,	'TW',	'Taiwan, Province of China',	886,	'TWD',	0.38425,	'New Taiwan Dollar',	0,	NULL,	NULL,	''),
(215,	'TJ',	'Tajikistan',	992,	'TJS',	0.12747,	'Somoni',	0,	NULL,	NULL,	''),
(216,	'TZ',	'Tanzania, United Republic of',	255,	'TZS',	32.69378,	'Tanzanian Shilling',	0,	NULL,	NULL,	''),
(217,	'TH',	'Thailand',	66,	'THB',	0.40406,	'Baht',	0,	NULL,	NULL,	''),
(218,	'TG',	'Togo',	228,	'XOF',	7.28505,	'CFA Franc BCEAO',	0,	NULL,	NULL,	''),
(219,	'TK',	'Tokelau',	690,	'NZD',	0.01990,	'New Zealand Dollar',	0,	NULL,	NULL,	''),
(220,	'TO',	'Tonga',	676,	'TOP',	0.02806,	'Pa?anga',	0,	NULL,	NULL,	''),
(221,	'TT',	'Trinidad and Tobago',	1868,	'TTD',	0.08132,	'Trinidad and Tobago Dollar',	0,	NULL,	NULL,	''),
(222,	'TN',	'Tunisia',	216,	'TND',	0.03733,	'Tunisian Dinar',	0,	NULL,	NULL,	''),
(223,	'TR',	'Turkey',	90,	'TRY',	0.41056,	'Turkish Lira',	0,	NULL,	NULL,	''),
(224,	'TM',	'Turkmenistan',	7370,	'TMT',	0.04206,	'Turkmenistan New Manat',	0,	NULL,	NULL,	''),
(225,	'TC',	'Turks and Caicos Islands',	1649,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(226,	'TV',	'Tuvalu',	688,	'AUD',	0.01800,	'Australian Dollar',	0,	NULL,	NULL,	''),
(227,	'UG',	'Uganda',	256,	'UGX',	43.86786,	'Uganda Shilling',	0,	NULL,	NULL,	''),
(228,	'UA',	'Ukraine',	380,	'UAH',	0.49377,	'Hryvnia',	0,	NULL,	NULL,	''),
(229,	'AE',	'United Arab Emirates',	971,	'AED',	0.04401,	'UAE Dirham',	1,	NULL,	NULL,	''),
(230,	'GB',	'United Kingdom',	44,	'GBP',	0.00924,	'Pound Sterling',	1,	NULL,	NULL,	''),
(231,	'US',	'United States',	1,	'USD',	0.01198,	'US Dollar',	1,	NULL,	NULL,	''),
(233,	'UY',	'Uruguay',	598,	'UYU',	0.49620,	'Peso Uruguayo',	0,	NULL,	NULL,	''),
(234,	'UZ',	'Uzbekistan',	998,	'UZS',	153.41679,	'Uzbekistan Sum',	0,	NULL,	NULL,	''),
(235,	'VU',	'Vanuatu',	678,	'VUV',	1.42256,	'Vatu',	0,	NULL,	NULL,	''),
(237,	'VE',	'Venezuela',	58,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(238,	'VN',	'Vietnam',	84,	'VND',	304.52907,	'Dong',	0,	NULL,	NULL,	''),
(239,	'VG',	'Virgin Islands, British',	1284,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(240,	'VI',	'Virgin Islands, U.S.',	1340,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(241,	'WF',	'Wallis and Futuna',	681,	'XPF',	1.32429,	'CFP Franc',	0,	NULL,	NULL,	''),
(242,	'EH',	'Western Sahara',	212,	'MAD',	0.11858,	'Moroccan Dirham',	0,	NULL,	NULL,	''),
(243,	'YE',	'Yemen',	967,	'YER',	3.00038,	'Yemeni Rial',	0,	NULL,	NULL,	''),
(244,	'YU',	'Yugoslavia',	38,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(245,	'ZM',	'Zambia',	260,	'ZMW',	0.31749,	'Zambian Kwacha',	0,	NULL,	NULL,	''),
(246,	'ZW',	'Zimbabwe',	263,	'ZWL',	3.85828,	'Zimbabwe Dollar',	0,	NULL,	NULL,	''),
(247,	'code',	'title_en',	0,	'cur',	NULL,	'currency_name',	0,	NULL,	NULL,	'title_fr');

INSERT INTO `mail_templates` (`hook`, `subject`, `variables`, `message`, `system_tpl`, `status`, `details`, `created_at`, `updated_at`)
VALUES ('AGENT_COMMISSION_PAYOUT', 'Commission Payout', 'sitename,siteurl,email,mobile,first_name,full_name,currency,payout_amount', '<p>Dear #full_name#,</p><p>A commission payout of #currency# #payout_amount# has been processed. You will soon receive the payment.</p><p>Thank You,</p><p>#sitename# Team</p>', '1', '1', 'This is sent to agents when process agent payout is done', now(), NULL);

-- 26-10-2024
DROP TABLE IF EXISTS `tax_rates`;
CREATE TABLE `tax_rates` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb3_unicode_ci NOT NULL,
  `display_name` varchar(50) COLLATE utf8mb3_unicode_ci NOT NULL,
  `country` int NOT NULL DEFAULT '0',
  `state` int NOT NULL DEFAULT '0',
  `tax_rate` decimal(13,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('enabled_taxes', '0', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('tax_inclusive', '0', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('tax_exclusive', '0', now(), NULL);

INSERT INTO `custom_labels` (`label`, `default_text`, `custom_text`, `created_at`, `updated_at`) VALUES
('tax_id',	'Tax ID',	'GSTN',	NULL,	NULL);


ALTER TABLE invoice RENAME TO invoice_old;

CREATE TABLE `invoice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_num` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `batch_id` int(11) NOT NULL DEFAULT 0,
  `currency` varchar(3) DEFAULT NULL,
  `tax1_name` varchar(191) DEFAULT NULL,
  `tax1_rate` int(11) DEFAULT NULL,
  `tax1_value` decimal(16,2) DEFAULT NULL,
  `tax1_value_base` decimal(16,2) DEFAULT NULL,
  `tax2_name` varchar(191) DEFAULT NULL,
  `tax2_rate` int(11) DEFAULT NULL,
  `tax2_value` decimal(16,2) DEFAULT NULL,
  `tax2_value_base` decimal(16,2) DEFAULT NULL,
  `total_tax` decimal(16,2) DEFAULT NULL,
  `total_tax_base` decimal(16,2) DEFAULT NULL,
  `tax_type` enum('inclusive','exclusive') DEFAULT NULL,
  `sub_total` decimal(16,2) NOT NULL,
  `sub_total_base` decimal(16,2) NOT NULL,
  `discount` decimal(16,2) NOT NULL,
  `discount_base` decimal(16,2) NOT NULL,
  `grand_total` decimal(16,2) NOT NULL,
  `grand_total_base` decimal(16,2) NOT NULL,
  `due_date` date NOT NULL,
  `status` enum('due','paid') NOT NULL DEFAULT 'due',
  `terms` text DEFAULT NULL,
  `terms_conditions` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `invoice_num` (`invoice_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `invoice_items`;
CREATE TABLE `invoice_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` int NOT NULL,
  `currency` varchar(191) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `item` varchar(191) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `item_amount` decimal(16,2) DEFAULT NULL,
  `item_amount_base` decimal(16,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- 27-10-2024

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
SELECT 'lead_create_next_followup_mandate', '1', now(), now()
FROM `configs_site`
WHERE ((`key` = 'home_page_student_signup' AND `key` = 'home_page_student_signup' COLLATE utf8mb4_bin));

-- 29-10-2024

ALTER TABLE `users`
ADD `tags` text COLLATE 'utf8mb4_unicode_ci' NULL AFTER `services`;


DROP TABLE IF EXISTS `user_tags`;

DROP TABLE IF EXISTS `tags`;
CREATE TABLE `tags` (
  `id` int unsigned NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `tag_name` varchar(100) NOT NULL,
  `created_at` timestamp NULL,
  `updated_at` timestamp NULL
);
ALTER TABLE `tags`
ADD UNIQUE `tag_name` (`tag_name`);

-- 30-10-2024

INSERT INTO `permissions` (`name`, `guard_name`, `details`, `status`, `created_at`, `updated_at`)
VALUES ('canned responses', 'web', 'This permission will allow staff member to create/edit and delete canned responses', '1', NULL, NULL);

DELETE FROM `permissions` WHERE `name` = 'broadcast';

INSERT INTO `permissions` (`name`, `guard_name`, `details`, `status`, `created_at`, `updated_at`)
VALUES ('broadcast to leads and students', 'web', 'Send bulk email, sms, whatsapp message to leads & students', '1', NULL, NULL);

INSERT INTO `permissions` (`name`, `guard_name`, `details`, `status`, `created_at`, `updated_at`)
VALUES ('broadcast to staff', 'web', 'Send bulk email, sms, whatsapp message to staff', '1', NULL, NULL);

INSERT INTO `permissions` (`name`, `guard_name`, `details`, `status`, `created_at`, `updated_at`)
VALUES ('broadcast to agents', 'web', 'Send bulk email, sms, whatsapp message to agents', '1', NULL, NULL);

DROP TABLE IF EXISTS `canned_responses`;
CREATE TABLE `canned_responses` (
  `hook` varchar(50) NOT NULL,
  `variables` text NOT NULL,
  `message` text NOT NULL,
  `system_tpl` tinyint(1) NOT NULL DEFAULT 0,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `details` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`hook`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 06-11-2024

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('lang_en', '1', '2024-03-21 11:49:42', '2024-06-13 22:02:24');

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('lang_fr', '0', '2024-03-21 11:49:42', '2024-06-13 22:02:24');

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('lang_it', '0', '2024-03-21 11:49:42', '2024-06-13 22:02:24');

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('lang_es', '0', '2024-03-21 11:49:42', '2024-06-13 22:02:24');

-- 18-11-2024

CREATE INDEX course_name 
ON university_courses (course_name);

CREATE INDEX study_level 
ON university_courses (study_level);

CREATE INDEX university_name
ON universities (university_name);

CREATE INDEX country
ON universities (country);

-- 22-11-2024
-- changed again as some sql was giving error
ALTER TABLE `user_academics`
ADD `id` int NOT NULL AUTO_INCREMENT UNIQUE FIRST;

ALTER TABLE `user_academics`
ADD PRIMARY KEY `id` (`id`),
DROP INDEX `PRIMARY`,
DROP INDEX `id`;


ALTER TABLE `user_courses`
ADD `id` int NOT NULL AUTO_INCREMENT UNIQUE FIRST;

ALTER TABLE `user_courses`
ADD PRIMARY KEY `id` (`id`),
DROP INDEX `PRIMARY`,
DROP INDEX `id`;


ALTER TABLE `user_internship`
ADD `id` int NOT NULL AUTO_INCREMENT UNIQUE FIRST;

ALTER TABLE `user_internship`
ADD PRIMARY KEY `id` (`id`),
DROP INDEX `PRIMARY`,
DROP INDEX `id`;

-- 04-12-2024

CREATE TABLE `business_configs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `logo` text DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `phone` varchar(15) DEFAULT NULL,
  `address` varchar(200) DEFAULT NULL,
  `tax_id` varchar(50) DEFAULT NULL,
  `bank_details` varchar(200) DEFAULT NULL,
  `footer_text` varchar(200) DEFAULT NULL,
  `terms_text` varchar(200) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `business_configs` (`name`, `logo`, `email`, `phone`, `address`, `tax_id`, `bank_details`, `footer_text`, `terms_text`, `created_at`, `updated_at`)
VALUES ('Demo', NULL, 'info@demo.com', '1234567890', '#1, 1st Cross, Bangalore', '123456', '', 'Thank you for your business with us', '', now(), NULL);

ALTER TABLE `invoice`
ADD `business_id` int(11) NOT NULL AFTER `student_id`;

ALTER TABLE `uni_invoice`
ADD `business_id` int(11) NOT NULL AFTER `invoice_num`;

ALTER TABLE `uni_invoice`
ADD `terms_conditions` text COLLATE 'utf8mb4_unicode_ci' NULL AFTER `status`;

-- 13-12-2024

UPDATE `invoice` SET `business_id`=1;

-- 31-12-2024

ALTER TABLE `university_application`
CHANGE `applied_with` `applied_with` int NULL AFTER `application_close_date`;

-- 27-01-2024

ALTER TABLE `services`
ADD `amount` varchar(250) NOT NULL AFTER `country_field`;

ALTER TABLE `service_applications`
ADD `amount` varchar(250) NOT NULL AFTER `college_appl_id`;

-- 10-02-2025

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('recaptcha_site_key', '', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('recaptcha_secret_key', '', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('student_signup_captcha', '', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('agent_signup_captcha', '', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('web_to_lead_captcha', '', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('form_builder_captcha', '', now(), NULL);

-- 14-02-2025

ALTER TABLE `permissions`
ADD `group` varchar(100) NULL AFTER `status`;

ALTER TABLE `permissions`
ADD `display_order` int NULL AFTER `group`;

DELETE FROM `role_has_permissions` 
WHERE ((`permission_id` = '5') OR (`permission_id` = '10') OR (`permission_id` = '11') OR (`permission_id` = '16') OR (`permission_id` = '30') OR (`permission_id` = '33') OR (`permission_id` = '36'));

DELETE FROM `permissions`
WHERE ((`id` = '5') OR (`id` = '10') OR (`id` = '11') OR (`id` = '16') OR (`id` = '30') OR (`id` = '33') OR (`id` = '36'));

UPDATE `permissions` SET `details` = 'Staff with this permission can perform various settings available in Settings page like: Branch management, Businesses, Modules, Lead/Student/Application Status values, Email/SMS/Whatsapp configs, Taxes etc.',`display_order` = '40' WHERE `name` = 'settings';
UPDATE `permissions` SET `group` = 'Support Tickets',`display_order` = '23' WHERE `name` = 'support tickets';

UPDATE `permissions` SET `details`='View students, student profile details, course preferences, documents, applications.', `group` = 'Student Management', `display_order` = '4' WHERE `name` = 'students';
UPDATE `permissions` SET `name` = 'view students' WHERE `name` = 'students';

UPDATE `permissions` SET `details`='View Student University applications', `group` = 'Application Management', `display_order` = '7' WHERE `name` = 'university applications';
UPDATE `permissions` SET `name` = 'view university applications' WHERE `name` = 'university applications';

UPDATE `permissions` SET `group` = 'Advanced', `display_order` = '37' WHERE `name` = 'country info';
UPDATE `permissions` SET `group` = 'Staff Management', `display_order` = '12' WHERE `name` = 'view staff';

UPDATE `permissions` SET `details`='View Leads', `group` = 'Lead Management', `display_order` = '1' WHERE `name` = 'leads';
UPDATE `permissions` SET `name` = 'view leads' WHERE `name` = 'leads';

UPDATE `permissions` SET `group` = 'CMS Management', `display_order` = '25' WHERE `name` = 'cms-articles';
UPDATE `permissions` SET `group` = 'CMS Management', `display_order` = '26' WHERE `name` = 'cms-events';
UPDATE `permissions` SET `group` = 'Advanced', `display_order` = '38' WHERE `name` = 'overseas education configs';
UPDATE `permissions` SET `group` = 'Upload Management', `display_order` = '27' WHERE `name` = 'file uploads';
UPDATE `permissions` SET `group` = 'Message Template Management', `display_order` = '28' WHERE `name` = 'mail templates';
UPDATE `permissions` SET `group` = 'Advanced', `display_order` = '35' WHERE `name` = 'branch mgmt';
UPDATE `permissions` SET `group` = 'Advanced', `display_order` = '34' WHERE `name` = 'roles mgmt';
UPDATE `permissions` SET `group` = 'Staff Management', `display_order` = '13' WHERE `name` = 'edit-staff';
UPDATE `permissions` SET `group` = 'Advanced', `display_order` = '36' WHERE `name` = 'delete-lead-student-application';
UPDATE `permissions` SET `group` = 'Invoice Management', `display_order` = '20' WHERE `name` = 'invoice';
UPDATE `permissions` SET `group` = 'Lead Management', `display_order` = '3' WHERE `name` = 'lead-assignment';
UPDATE `permissions` SET `group` = 'Support Tickets', `display_order` = '24' WHERE `name` = 'ticket-assignment';
UPDATE `permissions` SET `group` = 'Advanced', `display_order` = '33' WHERE `name` = 'import';
UPDATE `permissions` SET `group` = 'Report Management', `display_order` = '30' WHERE `name` = 'analytics';
UPDATE `permissions` SET `group` = 'Advanced', `display_order` = '31' WHERE `name` = 'automations';
UPDATE `permissions` SET `group` = 'Agent Management', `display_order` = '18' WHERE `name` = 'agent management';
UPDATE `permissions` SET `group` = 'Student Management', `display_order` = '6' WHERE `name` = 'student-assignment';
UPDATE `permissions` SET `group` = 'Agent Management', `display_order` = '18' WHERE `name` = 'commission';
UPDATE `permissions` SET `group` = 'Course Management', `display_order` = '19' WHERE `name` = 'course finder';
UPDATE `permissions` SET `group` = 'Advanced', `display_order` = '39' WHERE `name` = 'export lead, student data';
UPDATE `permissions` SET `group` = 'Application Management', `display_order` = '10' WHERE `name` = 'application apply through';
UPDATE `permissions` SET `group` = 'Application Management', `display_order` = '11' WHERE `name` = 'delete-visa-service-application';
UPDATE `permissions` SET `group` = 'Staff Management', `display_order` = '14' WHERE `name` = 'staff attendance';
UPDATE `permissions` SET `group` = 'Staff Management', `display_order` = '15' WHERE `name` = 'staff leaves';
UPDATE `permissions` SET `group` = 'Staff Management', `display_order` = '16' WHERE `name` = 'Approve Leaves';
UPDATE `permissions` SET `group` = 'Application Management', `display_order` = '9' WHERE `name` = 'application-assignment';
UPDATE `permissions` SET `group` = 'Invoice Management', `display_order` = '21' WHERE `name` = 'edit-invoice';
UPDATE `permissions` SET `group` = 'Referral Management', `display_order` = '29' WHERE `name` = 'student referral';
UPDATE `permissions` SET `group` = 'Invoice Management', `display_order` = '22' WHERE `name` = 'university invoice';
UPDATE `permissions` SET `group` = 'Message Template Management', `display_order` = '29' WHERE `name` = 'canned responses';
UPDATE `permissions` SET `group` = 'Advanced', `display_order` = '41' WHERE `name` = 'broadcast to leads and students';
UPDATE `permissions` SET `group` = 'Advanced', `display_order` = '42' WHERE `name` = 'broadcast to staff';
UPDATE `permissions` SET `group` = 'Advanced', `display_order` = '43' WHERE `name` = 'broadcast to agents';

INSERT INTO `permissions` (`name`, `guard_name`, `details`, `status`, `group`, `display_order`, `created_at`, `updated_at`)
VALUES ('lead create-update', 'web', 'Ability to create leads, edit leads and change lead status, add followups.', '1', 'Lead Management', '2', now(), NULL);

INSERT INTO `permissions` (`name`, `guard_name`, `details`, `status`, `group`, `display_order`, `created_at`, `updated_at`)
VALUES ('manage students', 'web', 'Create/manage students, student profile details, course preferences, documents, applications.', '1', 'Student Management', '5', now(), NULL);

INSERT INTO `permissions` (`name`, `guard_name`, `details`, `status`, `group`, `display_order`, `created_at`, `updated_at`)
VALUES ('manage university applications', 'web', 'Create Student University applications, manage details, status.', '1', 'Application Management', '8', now(), NULL);

INSERT INTO role_has_permissions (permission_id, role_id)
VALUES ((SELECT id FROM permissions WHERE name = 'lead create-update'), 14);

INSERT INTO role_has_permissions (permission_id, role_id)
VALUES ((SELECT id FROM permissions WHERE name = 'manage students'), 14);

INSERT INTO role_has_permissions (permission_id, role_id)
VALUES ((SELECT id FROM permissions WHERE name = 'manage university applications'), 14);

-- 28-03-2025

ALTER TABLE `user_details`
CHANGE `marital_status` `marital_status` varchar(50) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `criminal_offence`;

DELETE FROM `countries`
WHERE `title_en` = 'Yugoslavia' AND ((`id` = '244'));

-- 13-06-2025

ALTER TABLE `universities`
CHANGE `institution_type` `institution_type` enum('private_university','government_university') COLLATE 'utf8mb4_unicode_ci' NULL AFTER `country`;

-- 14-06-2025

ALTER TABLE `states`
ADD `status` int(2) NOT NULL;

ALTER TABLE `states`
CHANGE `status` `status` int(2) NOT NULL DEFAULT '1' AFTER `country_id`;

ALTER TABLE `cities`
ADD `status` int(2) NOT NULL DEFAULT '1';

-- 19-07-2025

ALTER TABLE `users`
ADD `google_refresh_token` text COLLATE 'utf8mb4_unicode_ci' NULL,
ADD `google_token_expires_in` int NULL AFTER `google_refresh_token`,
ADD `google_token_created_at` timestamp NULL AFTER `google_token_expires_in`;

ALTER TABLE `users`
ADD `google_token` text COLLATE 'utf8mb4_unicode_ci' NULL;

-- 20-07-2025

ALTER TABLE `user_details`
ADD `lead_campaign_name` text COLLATE 'utf8mb4_unicode_ci' NULL AFTER `campaign_id`;

DROP TABLE IF EXISTS `google_sheets`;
CREATE TABLE `google_sheets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `sheet_id` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 18-08-2025

ALTER TABLE `services`
CHANGE `amount` `amount` varchar(250) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `country_field`;

-- 22-08-2025 --
INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`) VALUES ('whatsapp_phone_number_id ', '', current_timestamp(), NULL), ('whatsapp_cloud_access_token', '', current_timestamp(), NULL);
-- 08-09-2025


CREATE TABLE `user_docu_esign` (
  `id` int(10) UNSIGNED NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL,
  `document_id` varchar(255) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `user_name` varchar(255) NOT NULL,
  `user_email` varchar(255) NOT NULL,
  `send_request_id` varchar(255) DEFAULT NULL,
  `status` varchar(50) DEFAULT 'Pending',
  `file_path` text DEFAULT NULL,
  `signed_date` datetime DEFAULT NULL,
  `response_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`response_data`)),
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES 
('docusign_api_token', '', NOW(), NULL),
('docusign_api_url', '', NOW(), NULL);

INSERT INTO `custom_labels` (`id`, `label`, `default_text`, `custom_text`, `created_at`, `updated_at`) VALUES (NULL, 'pan_card_number', 'PAN/TAX ID Number', 'PAN/TAX ID Number', NULL, NULL);
-- 17-09-2025

ALTER TABLE `university_courses`
ADD `sub_agent_commission_detail` text COLLATE 'utf8mb4_unicode_ci' NULL AFTER `status`,
CHANGE `updated_at` `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE CURRENT_TIMESTAMP AFTER `created_at`;

-- 22-09-2025

ALTER TABLE `universities`
ADD `commission_percent` decimal(13,1) NULL DEFAULT '0.0' AFTER `contact_person_email`;

ALTER TABLE `universities`
ADD `commission_count` int NULL DEFAULT '1' AFTER `commission_percent`;

