-- Adminer 4.8.1 MySQL 10.4.27-MariaDB dump

SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';

SET NAMES utf8mb4;

DROP TABLE IF EXISTS `activity_log`;
CREATE TABLE `activity_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(255) DEFAULT NULL,
  `description` text NOT NULL,
  `subject_id` bigint(20) unsigned DEFAULT NULL,
  `subject_type` varchar(255) DEFAULT NULL,
  `event` varchar(255) DEFAULT NULL,
  `causer_id` bigint(20) unsigned DEFAULT NULL,
  `causer_type` varchar(255) DEFAULT NULL,
  `properties` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`properties`)),
  `batch_uuid` char(36) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activity_log_log_name_index` (`log_name`),
  KEY `subject` (`subject_id`,`subject_type`),
  KEY `causer` (`causer_id`,`causer_type`),
  KEY `event_index` (`event`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `additional_docs_configs`;
CREATE TABLE `additional_docs_configs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `doc_type` varchar(100) NOT NULL,
  `file_count` int(11) NOT NULL,
  `file_types` varchar(100) NOT NULL,
  `doc_notes` varchar(300) DEFAULT NULL,
  `country_specific` tinyint(1) NOT NULL DEFAULT 0,
  `countries` text DEFAULT NULL,
  `display_order` int(11) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `section_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `doc_type` (`doc_type`),
  UNIQUE KEY `title` (`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `additional_docs_sections`;
CREATE TABLE `additional_docs_sections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `section` varchar(100) NOT NULL,
  `display_order` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `additional_docs_sections` (`id`, `section`, `display_order`, `created_at`, `updated_at`) VALUES
(1,	'Academic Certificates',	1,	'2023-11-07 12:40:09',	NULL),
(2,	'Tests/English Certificates',	2,	'2023-11-07 12:40:22',	NULL),
(3,	'Passport, CV, LOR, SOP, Experience, Other Certificates',	3,	'2023-11-07 12:40:34',	NULL);

DROP TABLE IF EXISTS `agent_commission`;
CREATE TABLE `agent_commission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `agent_id` int(11) NOT NULL,
  `appl_id` int(11) NOT NULL,
  `currency` varchar(3) DEFAULT NULL,
  `amount` decimal(13,2) NOT NULL,
  `amount_base` decimal(13,2) NOT NULL DEFAULT 0.00,
  `deduction` decimal(13,2) NOT NULL DEFAULT 0.00,
  `deduction_base` decimal(13,2) NOT NULL DEFAULT 0.00,
  `net_pay` decimal(13,2) NOT NULL DEFAULT 0.00,
  `net_pay_base` decimal(13,2) NOT NULL DEFAULT 0.00,
  `net_pay_agent` decimal(13,2) NOT NULL DEFAULT 0.00 COMMENT 'Actual amount paid in his local currency',
  `notes` varchar(500) DEFAULT NULL,
  `agent_commission_notes` varchar(500) DEFAULT NULL,
  `paid` varchar(10) NOT NULL DEFAULT '0',
  `paid_date` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `paid_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `agent_details`;
CREATE TABLE `agent_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `agent_id` int(11) NOT NULL,
  `logo_approved` tinyint(1) NOT NULL DEFAULT 0,
  `point_of_contact` int(11) DEFAULT NULL,
  `business_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `agent_category` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `agent_website_url` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `agent_id_proof` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `buis_incorpo_certi_proof` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `agent_panel_logo` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `agent_comments` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facebook` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `instagram` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `others` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `agent_file_upload`;
CREATE TABLE `agent_file_upload` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `country` varchar(100) DEFAULT NULL,
  `filename` varchar(255) NOT NULL,
  `category` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `agent_resource_category`;
CREATE TABLE `agent_resource_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category` varchar(500) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `announcements`;
CREATE TABLE `announcements` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `area` enum('frontend','backend') DEFAULT NULL,
  `type` enum('info','danger','warning','success') NOT NULL DEFAULT 'info',
  `message` text NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `starts_at` timestamp NULL DEFAULT NULL,
  `ends_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `announcements_site`;
CREATE TABLE `announcements_site` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `area` enum('public','student','agent','admin') NOT NULL,
  `title` varchar(200) NOT NULL,
  `message` text NOT NULL,
  `created_by` int(11) NOT NULL,
  `published_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `application_activity`;
CREATE TABLE `application_activity` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `application_id` int(11) NOT NULL,
  `type` enum('status_update','others') NOT NULL DEFAULT 'others' COMMENT 'user_event,system_event,admin_event',
  `title` varchar(191) DEFAULT NULL,
  `detail` text DEFAULT NULL,
  `attachment` text DEFAULT NULL,
  `staff` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `application_doc_request`;
CREATE TABLE `application_doc_request` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` enum('university','visa') NOT NULL,
  `application_id` int(11) NOT NULL,
  `title` varchar(300) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `files` text DEFAULT NULL,
  `uploaded_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `application_messages`;
CREATE TABLE `application_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `application_id` int(11) NOT NULL,
  `reply_timestamp` datetime DEFAULT NULL,
  `message` text NOT NULL,
  `user_id` int(11) NOT NULL,
  `staff_name` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `staff_id` int(11) NOT NULL DEFAULT 0,
  `attachment_1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attachment_2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attachment_3` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attachment_4` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notified_staff` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `application_stages`;
CREATE TABLE `application_stages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `status_name` varchar(30) NOT NULL COMMENT 'name shown to the users',
  `file_upload` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'show file upload option in this stage',
  `file_upload_max` int(11) NOT NULL DEFAULT 1 COMMENT 'no. of files',
  `file_upload_required` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'is file upload mandatory',
  `notes_required` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'is notes mandatory',
  `can_go_back` tinyint(4) NOT NULL DEFAULT 0 COMMENT 'can go to previous stage from this stage? superadmin can always change',
  `case_close_success` int(11) NOT NULL DEFAULT -1 COMMENT 'case closed stage with successful completion',
  `case_close_rejected` int(11) NOT NULL DEFAULT -1 COMMENT 'rejected status',
  `stage_order` int(11) NOT NULL COMMENT 'order, display order',
  `color` varchar(50) DEFAULT '#0D6EFD',
  `country_applicable` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `status_name` (`status_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `application_stages` (`id`, `status_name`, `file_upload`, `file_upload_max`, `file_upload_required`, `notes_required`, `can_go_back`, `case_close_success`, `case_close_rejected`, `stage_order`, `color`, `country_applicable`, `created_at`, `updated_at`) VALUES
(1,	'Pending',	0,	1,	0,	0,	0,	-1,	-1,	1,	'#0D6EFD',	NULL,	'2023-07-06 05:08:05',	NULL),
(2,	'Documents Ready',	0,	1,	0,	0,	0,	-1,	-1,	2,	'#0D6EFD',	NULL,	'2023-07-06 05:23:34',	'2023-07-06 05:23:34'),
(3,	'Admission Criteria Met',	0,	1,	0,	0,	0,	-1,	-1,	3,	'#0D6EFD',	NULL,	'2023-07-06 05:09:01',	NULL),
(4,	'Application Fee Paid',	0,	1,	0,	0,	0,	-1,	-1,	4,	'#0D6EFD',	NULL,	'2023-07-06 05:09:25',	NULL),
(5,	'Application Submitted',	0,	1,	0,	0,	0,	-1,	-1,	5,	'#0D6EFD',	NULL,	'2023-07-06 05:09:45',	NULL),
(6,	'Offer Letter Received',	1,	1,	0,	0,	0,	-1,	-1,	6,	'#0D6EFD',	NULL,	'2023-07-06 05:10:53',	NULL),
(7,	'Funds Under Assessment',	0,	1,	0,	0,	0,	-1,	-1,	7,	'#0D6EFD',	NULL,	'2023-07-06 05:11:31',	NULL),
(8,	'COE Received',	0,	1,	0,	0,	0,	-1,	-1,	8,	'#0D6EFD',	NULL,	'2023-07-06 05:12:40',	NULL),
(9,	'Payment Received',	0,	1,	0,	0,	0,	-1,	-1,	9,	'#0D6EFD',	NULL,	'2023-07-06 05:13:02',	NULL),
(10,	'CAS Requested',	0,	1,	0,	0,	0,	-1,	-1,	10,	'#0D6EFD',	NULL,	'2023-07-06 05:13:32',	NULL),
(11,	'CAS Received',	0,	1,	0,	0,	0,	-1,	-1,	11,	'#0D6EFD',	NULL,	'2023-07-06 05:13:56',	'2023-07-06 05:13:56'),
(12,	'I-20 Initiated',	0,	1,	0,	0,	0,	-1,	-1,	12,	'#0D6EFD',	NULL,	'2023-07-06 05:14:18',	NULL),
(13,	'I-20 Received',	0,	1,	0,	0,	0,	-1,	-1,	13,	'#0D6EFD',	NULL,	'2023-07-06 05:14:43',	'2023-07-06 05:14:43'),
(14,	'AIP Received',	0,	1,	0,	0,	0,	-1,	-1,	14,	'#0D6EFD',	NULL,	'2023-07-06 05:15:08',	'2023-07-06 05:15:08'),
(15,	'Visa in Process',	0,	1,	0,	0,	0,	-1,	-1,	15,	'#0D6EFD',	NULL,	'2023-07-06 05:15:24',	NULL),
(16,	'Visa Received',	1,	1,	0,	0,	0,	-1,	-1,	16,	'#0D6EFD',	NULL,	'2023-07-06 05:16:04',	'2023-07-06 05:16:04'),
(17,	'Admission Complete',	0,	1,	0,	0,	0,	1,	0,	17,	'#0D6EFD',	NULL,	'2023-07-06 05:17:51',	'2023-07-06 05:17:51'),
(18,	'Rejected',	0,	1,	0,	1,	1,	0,	1,	18,	'#0D6EFD',	NULL,	'2023-07-06 05:18:48',	NULL);

DROP TABLE IF EXISTS `assignments`;
CREATE TABLE `assignments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `batch_id` int(11) DEFAULT NULL,
  `title` varchar(150) DEFAULT NULL,
  `details` text DEFAULT NULL,
  `attachment` varchar(150) DEFAULT NULL,
  `due_date` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `batch_id` (`batch_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `attendance`;
CREATE TABLE `attendance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(10) unsigned NOT NULL,
  `batch_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `verified` tinyint(1) NOT NULL DEFAULT 0,
  `rating` enum('1','2','3','4','5') NOT NULL COMMENT '1 to 5',
  `review` varchar(500) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `attendance_unique` (`student_id`,`batch_id`,`date`),
  KEY `batch_id` (`batch_id`),
  CONSTRAINT `attendance_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `users` (`id`),
  CONSTRAINT `attendance_ibfk_2` FOREIGN KEY (`batch_id`) REFERENCES `batch` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `automation_campaign`;
CREATE TABLE `automation_campaign` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(191) NOT NULL,
  `communication_mode` enum('email','whatsapp','sms') NOT NULL,
  `target` enum('leads','students','all_leads_and_students','staff','agents','all') NOT NULL,
  `lead_status` text DEFAULT NULL,
  `student_status` text DEFAULT NULL,
  `lead_filters` text DEFAULT NULL,
  `student_filters` text DEFAULT NULL,
  `filter_condition` varchar(10) DEFAULT NULL,
  `message_template` varchar(191) DEFAULT NULL,
  `message_subject` varchar(191) DEFAULT NULL,
  `message_content` text NOT NULL,
  `run_at` datetime NOT NULL,
  `status` enum('queued','paused','running','sent') NOT NULL DEFAULT 'queued',
  `sent_count` int(11) NOT NULL DEFAULT 0 COMMENT 'no of audience',
  `sent_to` longtext DEFAULT NULL,
  `send_start` datetime DEFAULT NULL,
  `send_end` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `automation_workflow`;
CREATE TABLE `automation_workflow` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(191) NOT NULL,
  `workflow_type` enum('lead_nurture_sequence','message_sequence','specific_event') NOT NULL,
  `communication_mode` enum('email','whatsapp','sms') NOT NULL,
  `run_at` time NOT NULL,
  `target` enum('leads','students','all_leads_and_students','staff','agents','all') NOT NULL,
  `lead_status` text DEFAULT NULL COMMENT 'comma seperated',
  `student_status` text DEFAULT NULL COMMENT 'comma seperated',
  `lead_filters` text DEFAULT NULL COMMENT 'json',
  `student_filters` text DEFAULT NULL COMMENT 'json',
  `filter_condition` varchar(10) DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `message_details` text DEFAULT NULL COMMENT 'json',
  `repeats` varchar(50) DEFAULT NULL,
  `status` tinyint(1) DEFAULT 1,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `auto_workflow_activity`;
CREATE TABLE `auto_workflow_activity` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `workflow_id` int(11) NOT NULL,
  `matched_count` int(11) NOT NULL,
  `matched_audience` longtext DEFAULT NULL COMMENT 'comma seperated user ids',
  `sequence_index` int(11) NOT NULL DEFAULT 1,
  `message_template` varchar(50) DEFAULT NULL COMMENT 'Hook',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `banners`;
CREATE TABLE `banners` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `banner_text` varchar(500) DEFAULT NULL,
  `button_text` varchar(200) DEFAULT NULL,
  `banner_link` varchar(500) DEFAULT NULL,
  `banner_file` varchar(500) NOT NULL,
  `display_order` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `banners` (`id`, `banner_text`, `button_text`, `banner_link`, `banner_file`, `display_order`, `created_at`, `updated_at`) VALUES
(1,	'Opening a New World of Opportunities for You',	'Know More',	'login',	'banners/banners-1_70086.jpg',	1,	'2024-08-29 01:53:22',	'2024-08-29 01:53:22'),
(2,	'There is nothing more Important than Good Education',	'Know More',	'login',	'banners/banners-2_63786.jpg',	2,	'2024-08-29 01:53:36',	'2024-08-29 01:53:36'),
(3,	'Unlocking World-Class Education: Your Journey Starts with Us!',	NULL,	NULL,	'banners/banners-3_34858.jpg',	3,	'2024-08-29 01:53:46',	'2024-08-29 01:53:46'),
(4,	'Explore, Learn, Succeed: Where Your International Education Begins!',	NULL,	NULL,	'banners/banners-4_54359.jpg',	4,	'2024-08-29 01:53:56',	'2024-08-29 01:53:56'),
(5,	'Knowledge Knows No Borders: Let Us Guide Your Global Education Adventure!',	NULL,	NULL,	'banners/banners-5_57231.jpg',	5,	'2024-08-29 01:54:07',	'2024-08-29 01:54:07');

DROP TABLE IF EXISTS `batch`;
CREATE TABLE `batch` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(30) NOT NULL,
  `branch` int(11) NOT NULL,
  `course` int(11) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date DEFAULT NULL,
  `trainer` int(11) DEFAULT NULL,
  `days` enum('weekdays','weekends','custom') NOT NULL,
  `start_hour` varchar(2) DEFAULT NULL,
  `start_min` varchar(2) DEFAULT NULL,
  `end_hour` varchar(2) DEFAULT NULL,
  `end_min` varchar(2) DEFAULT NULL,
  `totalduration` int(11) NOT NULL DEFAULT 0,
  `meeting_room` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `assignment_marks` int(11) DEFAULT 0,
  `attendance_marks` int(11) DEFAULT 0,
  `online_course_marks` int(11) DEFAULT 0,
  `online_courses` varchar(100) DEFAULT NULL,
  `oral_mid_term_exam_marks` int(11) DEFAULT 0,
  `mid_term_marks` int(11) DEFAULT 0,
  `oral_end_term_marks` int(11) DEFAULT 0,
  `end_term_marks` int(11) DEFAULT 0,
  `status` enum('yet_to_start','inprogress','ended') NOT NULL DEFAULT 'yet_to_start',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `branch` (`branch`),
  KEY `course` (`course`),
  CONSTRAINT `batch_ibfk_1` FOREIGN KEY (`branch`) REFERENCES `branch` (`id`),
  CONSTRAINT `batch_ibfk_2` FOREIGN KEY (`course`) REFERENCES `courses` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `batch_students`;
CREATE TABLE `batch_students` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `batch` int(11) NOT NULL,
  `student` int(10) unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `batch_student_unique` (`batch`,`student`),
  KEY `batch` (`batch`),
  KEY `student` (`student`),
  CONSTRAINT `batch_students_ibfk_1` FOREIGN KEY (`batch`) REFERENCES `batch` (`id`),
  CONSTRAINT `batch_students_ibfk_2` FOREIGN KEY (`student`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `branch`;
CREATE TABLE `branch` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `branch_name` varchar(80) NOT NULL,
  `branch_address` varchar(200) DEFAULT NULL,
  `city` varchar(50) DEFAULT NULL,
  `country` int(11) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `custom_smtp` tinyint(1) NOT NULL DEFAULT 0,
  `smtp_email` varchar(100) DEFAULT NULL,
  `smtp_password` varchar(100) DEFAULT NULL,
  `smtp_host` varchar(100) DEFAULT NULL,
  `smtp_port` int(11) DEFAULT NULL,
  `smtp_connection` varchar(10) DEFAULT NULL,
  `smtp_from_name` varchar(100) DEFAULT NULL,
  `smtp_reply_to` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `branch` (`id`, `branch_name`, `branch_address`, `city`, `country`, `phone`, `email`, `custom_smtp`, `smtp_email`, `smtp_password`, `smtp_host`, `smtp_port`, `smtp_connection`, `smtp_from_name`, `smtp_reply_to`, `created_at`, `updated_at`) VALUES
(1,	'Main Branch',	NULL,	NULL,	NULL,	NULL,	NULL,	0,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL);

DROP TABLE IF EXISTS `broadcast_stats`;
CREATE TABLE `broadcast_stats` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL,
  `msg_type` varchar(100) NOT NULL,
  `subject` varchar(400) DEFAULT NULL,
  `message` varchar(400) NOT NULL,
  `sent_to` text DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `sent_count` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `cache`;
CREATE TABLE `cache` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(191) NOT NULL,
  `value` text NOT NULL,
  `expiration` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cache_key_unique` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `canned_responses`;
CREATE TABLE `canned_responses` (
  `hook` varchar(50) NOT NULL,
  `variables` text NOT NULL,
  `message` text NOT NULL,
  `system_tpl` tinyint(1) NOT NULL DEFAULT 0,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `details` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`hook`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `categories`;
CREATE TABLE `categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `slug` varchar(191) NOT NULL,
  `photo` varchar(255) NOT NULL,
  `parent` int(11) NOT NULL DEFAULT 0,
  `details` text DEFAULT NULL,
  `order` int(11) NOT NULL DEFAULT 9999,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `meta_title` varchar(255) DEFAULT NULL,
  `meta_desc` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `category`;
CREATE TABLE `category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category` varchar(500) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `certificate_request`;
CREATE TABLE `certificate_request` (
  `userid` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `status` enum('requested','provided') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'requested',
  PRIMARY KEY (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `chat`;
CREATE TABLE `chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sender` int(11) NOT NULL,
  `receiver` int(11) NOT NULL,
  `batch` int(11) NOT NULL,
  `message` varchar(1000) NOT NULL,
  `send_sms` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `chat_group`;
CREATE TABLE `chat_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trainer` int(11) NOT NULL,
  `batch` int(11) NOT NULL,
  `message` varchar(1000) NOT NULL,
  `send_sms` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `cities`;
CREATE TABLE `cities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `state_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `cms_course_suggestion`;
CREATE TABLE `cms_course_suggestion` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `country` varchar(45) NOT NULL,
  `level` enum('Master','Bachelor','Others') NOT NULL,
  `year` int(11) NOT NULL,
  `intake` varchar(191) NOT NULL,
  `file` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `college_fees`;
CREATE TABLE `college_fees` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `application_id` int(11) NOT NULL,
  `date_paid` date NOT NULL,
  `college_fee_amount` decimal(13,2) NOT NULL,
  `notes` varchar(400) NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` int(11) DEFAULT NULL,
  `updated_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `commission`;
CREATE TABLE `commission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `application_id` int(11) NOT NULL,
  `date_received` date NOT NULL,
  `my_commission_amount` decimal(13,2) NOT NULL,
  `notes` varchar(400) NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `configs_site`;
CREATE TABLE `configs_site` (
  `key` varchar(50) NOT NULL,
  `value` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Site Configs';

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`) VALUES
('academic_details_in_profile',	'1',	'2023-02-12 16:09:39',	NULL),
('aisensy_api_key',	'',	'2024-11-27 06:40:25',	NULL),
('analytics_backend',	'',	'2023-02-12 16:09:39',	NULL),
('analytics_frontend',	'',	'2023-02-12 16:09:39',	NULL),
('app_name',	'Portal',	'2023-02-12 16:09:39',	NULL),
('application_apply_through',	'Direct,Apply Board',	'2024-11-27 06:40:25',	NULL),
('backend_logo',	'logo/backend-logo.png',	'2023-02-12 16:09:39',	NULL),
('backend_logo_ht',	'30',	'2023-02-12 16:09:39',	NULL),
('bulk_smtp_connection',	'',	'2024-11-27 06:40:26',	NULL),
('bulk_smtp_email',	'',	'2024-11-27 06:40:26',	NULL),
('bulk_smtp_from_email',	'',	'2024-11-27 06:40:26',	NULL),
('bulk_smtp_host',	'',	'2024-11-27 06:40:26',	NULL),
('bulk_smtp_limit_hourly',	'500',	'2024-11-27 06:40:26',	NULL),
('bulk_smtp_password',	'',	'2024-11-27 06:40:26',	NULL),
('bulk_smtp_port',	'',	'2024-11-27 06:40:26',	NULL),
('bulk_smtp_type',	'smtp_server',	'2024-11-27 06:40:26',	NULL),
('certificate_business_name',	'',	'2023-02-12 16:09:39',	NULL),
('certificate_logo',	'',	'2023-02-12 16:09:39',	NULL),
('certificate_logo_ht',	'',	'2023-02-12 16:09:39',	NULL),
('certificate_sign',	'',	'2023-02-12 16:09:39',	NULL),
('certificate_sign_ht',	'',	'2023-02-12 16:09:39',	NULL),
('communication_mode',	'Email,Inbound Call,Outbound Call,Video-Call,Walk-In,Others',	'2024-11-27 06:40:25',	NULL),
('contact_email',	'support@demo.com',	'2023-02-12 16:09:39',	NULL),
('contact_phone',	'+1-234567890',	'2023-02-12 16:09:39',	NULL),
('course_preference_dropdown',	'1',	'2023-05-21 14:24:54',	NULL),
('create_lead_on_student_signup',	'1',	'2023-02-12 16:09:39',	NULL),
('email_logo',	'logo/email-logo.png',	'2023-02-12 16:09:39',	NULL),
('email_logo_ht',	'60',	'2023-02-12 16:09:39',	NULL),
('enabled_taxes',	'0',	'2024-11-27 06:40:26',	NULL),
('event_notification_email',	'',	'2024-11-27 06:40:25',	NULL),
('exotel_agent_number',	'',	'2024-11-27 06:40:25',	NULL),
('exotel_api_key',	'',	'2024-11-27 06:40:25',	NULL),
('exotel_api_secret',	'',	'2024-11-27 06:40:25',	NULL),
('exotel_sid',	'',	'2024-11-27 06:40:25',	NULL),
('favicon',	'',	'2023-02-12 16:09:39',	NULL),
('frontend_theme',	'blue',	'2024-11-27 06:40:25',	NULL),
('google_client_id',	'',	'2024-11-27 06:40:26',	NULL),
('google_client_secret',	'',	'2024-11-27 06:40:26',	NULL),
('google_email_from_name',	'',	'2024-11-27 06:40:26',	NULL),
('google_email_id',	'',	'2024-11-27 06:40:26',	NULL),
('google_email_reply_to',	'',	'2024-11-27 06:40:26',	NULL),
('google_lead_webhook_key',	'',	'2024-11-27 06:40:25',	NULL),
('google_project_id',	'',	'2024-11-27 06:40:26',	NULL),
('google_redirect_uri',	'',	'2024-11-27 06:40:26',	NULL),
('home_page_agent_signup',	'1',	'2024-11-27 06:40:25',	NULL),
('home_page_coaching_courses_enabled',	'0',	'2023-02-12 16:09:39',	NULL),
('home_page_countryinfo_enabled',	'0',	'2023-02-12 16:09:39',	NULL),
('home_page_online_courses_enabled',	'0',	'2023-02-12 16:09:39',	NULL),
('home_page_slider_enabled',	'1',	'2023-02-12 16:09:39',	NULL),
('home_page_staff_login',	'1',	'2024-11-27 06:40:25',	NULL),
('home_page_student_signup',	'1',	'2024-11-27 06:40:25',	NULL),
('invoice_business_address',	'',	'2023-02-12 16:09:39',	NULL),
('invoice_business_email',	'',	'2023-02-12 16:09:39',	NULL),
('invoice_business_name',	'',	'2023-02-12 16:09:39',	NULL),
('invoice_business_phone',	'',	'2023-02-12 16:09:39',	NULL),
('invoice_business_taxid',	'',	'2023-02-12 16:09:39',	NULL),
('invoice_footer_text',	'',	'2023-05-21 14:24:55',	NULL),
('invoice_terms_text',	'',	'2023-05-21 14:24:55',	NULL),
('js_backend',	'',	'2023-02-12 16:09:39',	NULL),
('js_frontend',	'',	'2023-02-12 16:09:39',	NULL),
('lang_en',	'1',	'2024-03-21 11:49:42',	'2024-06-13 22:02:24'),
('lang_es',	'0',	'2024-03-21 11:49:42',	'2024-06-13 22:02:24'),
('lang_fr',	'0',	'2024-03-21 11:49:42',	'2024-06-13 22:02:24'),
('lang_it',	'0',	'2024-03-21 11:49:42',	'2024-06-13 22:02:24'),
('lead_create_admin_mandatory',	'email',	'2024-11-27 06:40:25',	NULL),
('lead_create_next_followup_mandate',	'1',	'2024-11-27 06:40:26',	'2024-11-27 06:40:26'),
('lead_create_web2lead_api_import_mandatory',	'email',	'2024-11-27 06:40:25',	NULL),
('lead_disqualified_reason',	'Not Interested,Invalid Data,Not Reachable,Applied With Someone Else,Financial Problem,Not Able To Decide,Others',	'2024-11-27 06:40:25',	NULL),
('lead_followup_mandatory',	'0',	'2024-11-27 06:40:25',	NULL),
('lead_followup_missed_notification',	'1',	'2024-11-27 06:40:25',	NULL),
('lead_followup_reminder_notification',	'1',	'2024-11-27 06:40:25',	NULL),
('lead_sources',	'Email,Ads,Telecall,Walkin,Reference,Website,WhatsApp,WebForm2Lead,Email Marketing,Agent,Others',	'2023-02-12 16:09:39',	NULL),
('lead_stage_deadline_missed_notification',	'0',	'2024-11-27 06:40:25',	NULL),
('lead_welcome_email_lead_create',	'0',	'2023-02-12 16:09:39',	NULL),
('lead_welcome_email_web2lead',	'0',	'2023-02-12 16:09:39',	NULL),
('module_coaching_classes',	'1',	'2023-02-12 16:09:39',	NULL),
('module_country_info',	'1',	'2023-02-12 16:09:39',	NULL),
('module_course_purchase',	'1',	'2023-02-12 16:09:39',	NULL),
('module_course_suggestion',	'1',	'2023-02-12 16:09:39',	NULL),
('module_democlasses',	'1',	'2023-02-12 16:09:39',	NULL),
('module_helpdesk',	'1',	'2023-02-12 16:09:39',	NULL),
('module_membermenu_allcoaching',	'1',	'2023-02-12 16:09:39',	NULL),
('module_membermenu_allonlinecourses',	'1',	'2023-02-12 16:09:39',	NULL),
('module_mycertificate',	'0',	'2023-02-12 16:09:39',	NULL),
('module_online_courses',	'1',	'2023-02-12 16:09:39',	NULL),
('module_resources',	'1',	'2023-02-12 16:09:39',	NULL),
('module_shop',	'0',	'2023-02-12 16:09:39',	NULL),
('module_sop',	'0',	'2023-02-12 16:09:39',	NULL),
('module_student_referral',	'0',	'2024-11-27 06:40:26',	NULL),
('module_webinar',	'1',	'2023-02-12 16:09:39',	NULL),
('outbound_call_enabled',	'0',	'2024-11-27 06:40:25',	NULL),
('outbound_call_provider',	'',	'2024-11-27 06:40:25',	NULL),
('payment_bank',	'1',	'2023-02-12 16:09:39',	NULL),
('payment_bank_details',	'',	'2023-02-12 16:09:39',	NULL),
('payment_paypal',	'1',	'2023-02-12 16:09:39',	NULL),
('payment_razorpay',	'1',	'2023-02-12 16:09:39',	NULL),
('payment_stripe',	'1',	'2023-02-12 16:09:39',	NULL),
('sample_academic_lor',	'',	'2023-02-12 21:39:39',	'2023-10-27 13:51:11'),
('sample_cv',	'',	'2023-02-12 16:09:39',	NULL),
('sample_mou',	'',	'2023-02-12 21:39:39',	'2023-10-27 13:51:11'),
('sample_professional_lor',	'',	'2023-02-12 21:39:39',	'2023-10-27 13:51:11'),
('sample_sop',	'',	'2023-02-12 16:09:39',	NULL),
('setup_abroad',	'0',	'2023-05-21 14:24:54',	NULL),
('setup_abroad_course_finder',	'0',	'2023-05-21 14:24:54',	NULL),
('setup_general',	'0',	'2023-05-21 14:24:54',	NULL),
('setup_leads',	'0',	'2023-05-21 14:24:54',	NULL),
('setup_modules',	'0',	'2023-05-21 14:24:54',	NULL),
('setup_staff_roles',	'0',	'2023-05-21 14:24:54',	NULL),
('setup_students',	'0',	'2023-05-21 14:24:54',	NULL),
('setup_students_leads_data',	'0',	'2023-05-21 14:24:54',	NULL),
('sms_api_url',	'',	'2023-02-12 16:09:39',	NULL),
('sms_auth_token',	'',	'2023-02-12 16:09:39',	NULL),
('sms_enabled',	'0',	'2023-02-12 16:09:39',	NULL),
('sms_flow_id',	'',	'2023-02-12 16:09:39',	NULL),
('sms_from_phone',	'',	'2023-02-12 16:09:39',	NULL),
('sms_provider',	'',	'2023-02-12 16:09:39',	NULL),
('sms_senderid',	'',	'2023-02-12 16:09:39',	NULL),
('smtp_connection',	'',	'2023-02-12 16:09:39',	NULL),
('smtp_email',	'',	'2023-02-12 16:09:39',	NULL),
('smtp_from_email',	'',	'2024-11-27 06:40:26',	NULL),
('smtp_host',	'',	'2023-02-12 16:09:39',	NULL),
('smtp_password',	'',	'2023-02-12 16:09:39',	NULL),
('smtp_port',	'',	'2023-02-12 16:09:39',	NULL),
('smtp_reply_to',	'',	'2024-11-27 06:40:26',	NULL),
('smtp_type',	'smtp_server',	'2024-11-27 06:40:26',	NULL),
('student_allow_add_new_university_application',	'0',	'2023-02-12 16:09:39',	NULL),
('student_application_terms_page',	'0',	'2023-02-12 16:09:39',	NULL),
('student_bachelors',	'1',	'2023-02-12 16:09:39',	NULL),
('student_bachelors_mandatory',	'1',	'2023-02-12 16:09:39',	NULL),
('student_bachelors_provisional',	'1',	'2023-02-12 16:09:39',	NULL),
('student_bachelors_provisional_mandatory',	'1',	'2023-02-12 16:09:39',	NULL),
('student_cmm',	'1',	'2023-02-12 16:09:39',	NULL),
('student_cmm_mandatory',	'1',	'2023-02-12 16:09:39',	NULL),
('student_create_admin_mandatory',	'email_and_mobile',	'2024-11-27 06:40:25',	NULL),
('student_cv',	'1',	'2023-02-12 16:09:39',	NULL),
('student_cv_mandatory',	'1',	'2023-02-12 16:09:39',	NULL),
('student_cv_mandatory_in_profile',	'1',	'2023-02-12 16:09:39',	NULL),
('student_degree_completion',	'1',	'2023-02-12 16:09:39',	NULL),
('student_degree_completion_mandatory',	'1',	'2023-02-12 16:09:39',	NULL),
('student_diploma',	'0',	'2023-02-12 16:09:39',	NULL),
('student_diploma_mandatory',	'0',	'2023-02-12 16:09:39',	NULL),
('student_disqualified_reason',	'Not Interested,Invalid Data,Not Reachable,Applied With Someone Else,Financial Problem,Not Able To Decide,Others',	'2024-11-27 06:40:25',	NULL),
('student_doc_configs',	'{\"pre-bachelors\":{\"class10\":{\"certificate\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"marks_sheet\":{\"enable\":\"1\",\"mandatory\":\"1\"}},\"class12\":{\"certificate\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"marks_sheet\":{\"enable\":\"1\",\"mandatory\":\"1\"}},\"diploma\":{\"certificate\":{\"enable\":\"0\",\"mandatory\":\"0\"},\"marks_sheet\":{\"enable\":\"0\",\"mandatory\":\"0\"}},\"degree\":{\"certificate\":{\"enable\":\"0\",\"mandatory\":\"0\"},\"marks_sheet\":{\"enable\":\"0\",\"mandatory\":\"0\"},\"provisional\":{\"enable\":\"0\",\"mandatory\":\"0\"},\"all_sem\":{\"enable\":\"0\",\"mandatory\":\"0\"}},\"pg_degree\":{\"certificate\":{\"enable\":\"0\",\"mandatory\":\"0\"},\"marks_sheet\":{\"enable\":\"0\",\"mandatory\":\"0\"},\"provisional\":{\"enable\":\"0\",\"mandatory\":\"0\"},\"all_sem\":{\"enable\":\"0\",\"mandatory\":\"0\"}},\"passport\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"lor\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"sop\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"cv\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"other_cert\":{\"enable\":\"1\",\"mandatory\":\"0\"},\"experience\":{\"enable\":\"1\",\"mandatory\":\"0\"},\"essay\":{\"enable\":\"1\"}},\"bachelors\":{\"class10\":{\"certificate\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"marks_sheet\":{\"enable\":\"1\",\"mandatory\":\"1\"}},\"class12\":{\"certificate\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"marks_sheet\":{\"enable\":\"1\",\"mandatory\":\"1\"}},\"diploma\":{\"certificate\":{\"enable\":\"0\",\"mandatory\":\"0\"},\"marks_sheet\":{\"enable\":\"0\",\"mandatory\":\"0\"}},\"degree\":{\"certificate\":{\"enable\":\"0\",\"mandatory\":\"0\"},\"marks_sheet\":{\"enable\":\"0\",\"mandatory\":\"0\"},\"provisional\":{\"enable\":\"0\",\"mandatory\":\"0\"},\"all_sem\":{\"enable\":\"0\",\"mandatory\":\"0\"}},\"pg_degree\":{\"certificate\":{\"enable\":\"0\",\"mandatory\":\"0\"},\"marks_sheet\":{\"enable\":\"0\",\"mandatory\":\"0\"},\"provisional\":{\"enable\":\"0\",\"mandatory\":\"0\"},\"all_sem\":{\"enable\":\"0\",\"mandatory\":\"0\"}},\"passport\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"lor\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"sop\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"cv\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"other_cert\":{\"enable\":\"1\",\"mandatory\":\"0\"},\"experience\":{\"enable\":\"1\",\"mandatory\":\"0\"},\"essay\":{\"enable\":\"1\"}},\"pre-masters\":{\"class10\":{\"certificate\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"marks_sheet\":{\"enable\":\"1\",\"mandatory\":\"1\"}},\"class12\":{\"certificate\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"marks_sheet\":{\"enable\":\"1\",\"mandatory\":\"1\"}},\"diploma\":{\"certificate\":{\"enable\":\"0\",\"mandatory\":\"0\"},\"marks_sheet\":{\"enable\":\"0\",\"mandatory\":\"0\"}},\"degree\":{\"certificate\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"marks_sheet\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"provisional\":{\"enable\":\"1\",\"mandatory\":\"0\"},\"all_sem\":{\"enable\":\"1\",\"mandatory\":\"0\"}},\"pg_degree\":{\"certificate\":{\"enable\":\"0\",\"mandatory\":\"0\"},\"marks_sheet\":{\"enable\":\"0\",\"mandatory\":\"0\"},\"provisional\":{\"enable\":\"0\",\"mandatory\":\"0\"},\"all_sem\":{\"enable\":\"0\",\"mandatory\":\"0\"}},\"passport\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"lor\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"sop\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"cv\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"other_cert\":{\"enable\":\"1\",\"mandatory\":\"0\"},\"experience\":{\"enable\":\"1\",\"mandatory\":\"0\"},\"essay\":{\"enable\":\"1\"}},\"masters\":{\"class10\":{\"certificate\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"marks_sheet\":{\"enable\":\"1\",\"mandatory\":\"1\"}},\"class12\":{\"certificate\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"marks_sheet\":{\"enable\":\"1\",\"mandatory\":\"1\"}},\"diploma\":{\"certificate\":{\"enable\":\"0\",\"mandatory\":\"0\"},\"marks_sheet\":{\"enable\":\"0\",\"mandatory\":\"0\"}},\"degree\":{\"certificate\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"marks_sheet\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"provisional\":{\"enable\":\"1\",\"mandatory\":\"0\"},\"all_sem\":{\"enable\":\"1\",\"mandatory\":\"0\"}},\"pg_degree\":{\"certificate\":{\"enable\":\"0\",\"mandatory\":\"0\"},\"marks_sheet\":{\"enable\":\"0\",\"mandatory\":\"0\"},\"provisional\":{\"enable\":\"0\",\"mandatory\":\"0\"},\"all_sem\":{\"enable\":\"0\",\"mandatory\":\"0\"}},\"passport\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"lor\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"sop\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"cv\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"other_cert\":{\"enable\":\"1\",\"mandatory\":\"0\"},\"experience\":{\"enable\":\"1\",\"mandatory\":\"0\"},\"essay\":{\"enable\":\"1\"}},\"phd\":{\"class10\":{\"certificate\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"marks_sheet\":{\"enable\":\"1\",\"mandatory\":\"1\"}},\"class12\":{\"certificate\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"marks_sheet\":{\"enable\":\"1\",\"mandatory\":\"1\"}},\"diploma\":{\"certificate\":{\"enable\":\"0\",\"mandatory\":\"0\"},\"marks_sheet\":{\"enable\":\"0\",\"mandatory\":\"0\"}},\"degree\":{\"certificate\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"marks_sheet\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"provisional\":{\"enable\":\"1\",\"mandatory\":\"0\"},\"all_sem\":{\"enable\":\"1\",\"mandatory\":\"0\"}},\"pg_degree\":{\"certificate\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"marks_sheet\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"provisional\":{\"enable\":\"1\",\"mandatory\":\"0\"},\"all_sem\":{\"enable\":\"1\",\"mandatory\":\"0\"}},\"passport\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"lor\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"sop\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"cv\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"other_cert\":{\"enable\":\"1\",\"mandatory\":\"0\"},\"experience\":{\"enable\":\"1\",\"mandatory\":\"0\"},\"essay\":{\"enable\":\"1\"}},\"others\":{\"class10\":{\"certificate\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"marks_sheet\":{\"enable\":\"1\",\"mandatory\":\"1\"}},\"class12\":{\"certificate\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"marks_sheet\":{\"enable\":\"1\",\"mandatory\":\"1\"}},\"diploma\":{\"certificate\":{\"enable\":\"0\",\"mandatory\":\"0\"},\"marks_sheet\":{\"enable\":\"0\",\"mandatory\":\"0\"}},\"degree\":{\"certificate\":{\"enable\":\"1\",\"mandatory\":\"0\"},\"marks_sheet\":{\"enable\":\"1\",\"mandatory\":\"0\"},\"provisional\":{\"enable\":\"1\",\"mandatory\":\"0\"},\"all_sem\":{\"enable\":\"1\",\"mandatory\":\"0\"}},\"pg_degree\":{\"certificate\":{\"enable\":\"1\",\"mandatory\":\"0\"},\"marks_sheet\":{\"enable\":\"1\",\"mandatory\":\"0\"},\"provisional\":{\"enable\":\"1\",\"mandatory\":\"0\"},\"all_sem\":{\"enable\":\"1\",\"mandatory\":\"0\"}},\"passport\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"lor\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"sop\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"cv\":{\"enable\":\"1\",\"mandatory\":\"1\"},\"other_cert\":{\"enable\":\"1\",\"mandatory\":\"0\"},\"experience\":{\"enable\":\"1\",\"mandatory\":\"0\"},\"essay\":{\"enable\":\"1\"}}}',	'2023-02-12 16:09:39',	'2024-11-27 06:40:25'),
('student_lor',	'1',	'2023-02-12 16:09:39',	NULL),
('student_lor_mandatory',	'1',	'2023-02-12 16:09:39',	NULL),
('student_masters_all_semesters',	'1',	'2023-02-12 16:09:39',	NULL),
('student_masters_all_semesters_mandatory',	'0',	'2023-02-12 16:09:39',	NULL),
('student_masters_completion',	'1',	'2023-02-12 16:09:39',	NULL),
('student_masters_completion_mandatory',	'1',	'2023-02-12 16:09:39',	NULL),
('student_masters_provisional',	'1',	'2023-02-12 16:09:39',	NULL),
('student_masters_provisional_mandatory',	'1',	'2023-02-12 16:09:39',	NULL),
('student_other_certificate',	'1',	'2023-02-12 16:09:39',	NULL),
('student_other_certificate_mandatory',	'0',	'2023-02-12 16:09:39',	NULL),
('student_passport',	'1',	'2023-02-12 16:09:39',	NULL),
('student_passport_mandatory',	'1',	'2023-02-12 16:09:39',	NULL),
('student_qualification_levels',	'Class 8,Class 9,Class 10,Class 11,Class 12,Diploma,Bachelors,Masters,PhD',	'2024-11-27 06:40:26',	NULL),
('student_referral_payout_modes',	'Bank Transfer,UPI',	'2024-11-27 06:40:26',	NULL),
('student_signup_default_branch',	'1',	'2022-11-17 05:59:41',	'2022-11-17 07:17:12'),
('student_signup_terms_page',	'0',	'2023-02-12 16:09:39',	NULL),
('student_sop',	'1',	'2023-02-12 16:09:39',	NULL),
('student_sop_mandatory',	'1',	'2023-02-12 16:09:39',	NULL),
('student_tenth_certificate',	'1',	'2023-02-12 16:09:39',	NULL),
('student_tenth_certificate_mandatory',	'1',	'2023-02-12 16:09:39',	NULL),
('student_twelth_certificate',	'1',	'2023-02-12 16:09:39',	NULL),
('student_twelth_certificate_mandatory',	'1',	'2023-02-12 16:09:39',	NULL),
('support_ticket_notification_email',	'',	'2024-11-27 06:40:25',	NULL),
('tax_exclusive',	'0',	'2024-11-27 06:40:26',	NULL),
('tax_inclusive',	'0',	'2024-11-27 06:40:26',	NULL),
('unassigned_lead_notification_lead_age',	'2',	'2024-11-27 06:40:25',	NULL),
('university_course_finder',	'0',	'2023-02-12 16:09:39',	NULL),
('wati_api_endpoint',	'',	'2024-11-27 06:40:26',	NULL),
('wati_token',	'',	'2024-11-27 06:40:25',	NULL),
('web_lead_accommodation_enabled',	'0',	'2023-02-12 16:09:39',	NULL),
('web_lead_alternate_contact_enabled',	'0',	'2023-02-12 16:09:39',	NULL),
('web_lead_assign_to',	'',	'2023-02-12 16:09:39',	NULL),
('web_lead_assign_to_branch',	'1',	'2023-05-21 14:24:54',	'2023-05-21 14:24:54'),
('web_lead_city_enabled',	'',	'2023-02-12 16:09:39',	NULL),
('web_lead_country_of_citizenship_enabled',	'0',	'2023-02-12 16:09:39',	NULL),
('web_lead_country_pref_enabled',	'0',	'2023-02-12 16:09:39',	NULL),
('web_lead_course_interested_enabled',	'1',	'2023-02-12 16:09:39',	NULL),
('web_lead_current_course_enabled',	'0',	'2023-02-12 16:09:39',	NULL),
('web_lead_dob_enabled',	'0',	'2023-02-12 16:09:39',	NULL),
('web_lead_email_enabled',	'1',	'2023-02-12 16:09:39',	NULL),
('web_lead_enabled',	'0',	'2023-02-12 16:09:39',	NULL),
('web_lead_first_name_enabled',	'1',	'2023-02-12 16:09:39',	NULL),
('web_lead_form_name',	'',	'2024-11-27 06:40:26',	NULL),
('web_lead_gender_enabled',	'0',	'2023-02-12 16:09:39',	NULL),
('web_lead_intake_enabled',	'',	'2024-11-27 06:40:26',	NULL),
('web_lead_last_name_enabled',	'',	'2023-02-12 16:09:39',	NULL),
('web_lead_mobile_enabled',	'',	'2023-02-12 16:09:39',	NULL),
('web_lead_passout_year_enabled',	'',	'2024-11-27 06:40:26',	NULL),
('web_lead_qualification_enabled',	'',	'2024-11-27 06:40:26',	NULL),
('web_lead_redirect_url',	'',	'2023-02-12 16:09:39',	NULL),
('web_lead_score_enabled',	'',	'2024-11-27 06:40:26',	NULL),
('web_lead_study_level_enabled',	'0',	'2023-02-12 16:09:39',	NULL),
('web_lead_study_permit_enabled',	'0',	'2023-02-12 16:09:39',	NULL),
('web_lead_whatsapp_enabled',	'',	'2024-11-27 06:40:26',	NULL),
('website_logo',	'logo/logo.png',	'2023-02-12 16:09:39',	NULL),
('website_logo_ht',	'48',	'2023-02-12 16:09:39',	NULL),
('website_sticky_logo',	'logo/logo-white.png',	'2024-11-27 06:40:25',	NULL),
('website_sticky_logo_ht',	'40',	'2024-11-27 06:40:25',	NULL),
('whatsapp_enabled',	'1',	'2024-11-27 06:40:25',	NULL),
('whatsapp_provider',	'',	'2024-11-27 06:40:25',	NULL),
('zadarma_agent_number',	'',	'2024-11-27 06:40:25',	NULL),
('zadarma_api_key',	'',	'2024-11-27 06:40:25',	NULL),
('zadarma_api_secret',	'',	'2024-11-27 06:40:25',	NULL);

DROP TABLE IF EXISTS `content_blocks`;
CREATE TABLE `content_blocks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `section` varchar(100) NOT NULL,
  `content` text NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `section` (`section`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `content_blocks` (`id`, `section`, `content`, `created_at`, `updated_at`) VALUES
(1,	'homepage_student_intro_heading',	'<h2>Take your first step towards Study Abroad</h2>',	'2024-08-29 07:13:55',	'2024-08-29 07:13:55'),
(2,	'homepage_student_intro_content',	'<p>Embark on an exciting journey toward studying abroad! Discover new cultures, expand your horizons, and create unforgettable memories. Let’s make your dream a reality. 🌏🎓✈️</p>',	'2024-08-29 07:15:57',	'2024-08-29 07:15:57'),
(3,	'homepage_student_intro_banner',	'<p><img src=\"assets/images/page/student_intro1.jpg\"></p>',	'2024-08-29 07:32:09',	'2024-08-29 07:32:09');

DROP TABLE IF EXISTS `countries`;
CREATE TABLE `countries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(191) DEFAULT NULL,
  `title_en` varchar(191) DEFAULT NULL,
  `tel` int(11) DEFAULT NULL,
  `currency` varchar(3) NOT NULL DEFAULT 'USD',
  `rate` decimal(13,5) DEFAULT NULL,
  `currency_name` varchar(50) NOT NULL DEFAULT 'US Dollar',
  `overseas_status` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `title_fr` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `countries` (`id`, `code`, `title_en`, `tel`, `currency`, `rate`, `currency_name`, `overseas_status`, `created_at`, `updated_at`, `title_fr`) VALUES
(1,	'AF',	'Afghanistan',	93,	'AFN',	0.80052,	'Afghani',	0,	NULL,	NULL,	''),
(2,	'AL',	'Albania',	355,	'ALL',	1.09527,	'Lek',	0,	NULL,	NULL,	''),
(3,	'DZ',	'Algeria',	213,	'DZD',	1.60098,	'Algerian Dinar',	0,	NULL,	NULL,	''),
(4,	'AS',	'American Samoa',	1684,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(5,	'AD',	'Andorra',	376,	'EUR',	0.01110,	'Euro',	0,	NULL,	NULL,	''),
(6,	'AO',	'Angola',	244,	'AOA',	10.92782,	'Kwanza',	0,	NULL,	NULL,	''),
(7,	'AI',	'Anguilla',	1264,	'XCD',	0.03238,	'East Caribbean Dollar',	0,	NULL,	NULL,	''),
(9,	'AG',	'Antigua and Barbuda',	1268,	'XCD',	0.03238,	'East Caribbean Dollar',	0,	NULL,	NULL,	''),
(10,	'AR',	'Argentina',	54,	'ARS',	11.79986,	'Argentine Peso',	0,	NULL,	NULL,	''),
(11,	'AM',	'Armenia',	374,	'AMD',	4.63222,	'Armenian Dram',	0,	NULL,	NULL,	''),
(12,	'AW',	'Aruba',	297,	'AWG',	0.02160,	'Aruban Florin',	0,	NULL,	NULL,	''),
(13,	'AU',	'Australia',	61,	'AUD',	0.01800,	'Australian Dollar',	1,	NULL,	NULL,	''),
(14,	'AT',	'Austria',	43,	'EUR',	0.01110,	'Euro',	1,	NULL,	NULL,	''),
(15,	'AZ',	'Azerbaijan',	994,	'AZN',	0.02040,	'Azerbaijanian Manat',	0,	NULL,	NULL,	''),
(16,	'BS',	'Bahamas',	1242,	'BSD',	0.01197,	'Bahamian Dollar',	0,	NULL,	NULL,	''),
(17,	'BH',	'Bahrain',	973,	'BHD',	0.00452,	'Bahraini Dinar',	0,	NULL,	NULL,	''),
(18,	'BD',	'Bangladesh',	880,	'BDT',	1.43031,	'Taka',	0,	NULL,	NULL,	''),
(19,	'BB',	'Barbados',	1246,	'BBD',	0.02417,	'Barbados Dollar',	0,	NULL,	NULL,	''),
(20,	'BY',	'Belarus',	375,	'BYR',	234.85225,	'Belarussian Ruble',	0,	NULL,	NULL,	''),
(21,	'BE',	'Belgium',	32,	'EUR',	0.01110,	'Euro',	0,	NULL,	NULL,	''),
(22,	'BZ',	'Belize',	501,	'BZD',	0.02413,	'Belize Dollar',	0,	NULL,	NULL,	''),
(23,	'BJ',	'Benin',	229,	'XOF',	7.28505,	'CFA Franc BCEAO',	0,	NULL,	NULL,	''),
(24,	'BM',	'Bermuda',	1441,	'BMD',	0.01198,	'Bermudian Dollar',	0,	NULL,	NULL,	''),
(25,	'BT',	'Bhutan',	975,	'BTN',	1.00732,	'Bhutanese Ngultrum',	0,	NULL,	NULL,	''),
(26,	'BO',	'Bolivia',	591,	'BOB',	0.08270,	'Boliviano',	0,	NULL,	NULL,	''),
(27,	'BA',	'Bosnia and Herzegovina',	387,	'BAM',	0.02172,	'Convertible Mark',	0,	NULL,	NULL,	''),
(28,	'BW',	'Botswana',	267,	'BWP',	0.15970,	'Pula',	0,	NULL,	NULL,	''),
(30,	'BR',	'Brazil',	55,	'BRL',	0.06818,	'Brazilian Real',	0,	NULL,	NULL,	''),
(31,	'IO',	'British Indian Ocean Territory',	246,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(32,	'BN',	'Brunei Darussalam',	673,	'BND',	0.01581,	'Brunei Dollar',	0,	NULL,	NULL,	''),
(33,	'BG',	'Bulgaria',	359,	'BGN',	0.02173,	'Bulgarian Lev',	1,	NULL,	NULL,	''),
(34,	'BF',	'Burkina Faso',	226,	'XOF',	7.28505,	'CFA Franc BCEAO',	0,	NULL,	NULL,	''),
(35,	'BI',	'Burundi',	257,	'BIF',	34.75748,	'Burundi Franc',	0,	NULL,	NULL,	''),
(36,	'KH',	'Cambodia',	855,	'KHR',	48.68891,	'Riel',	0,	NULL,	NULL,	''),
(37,	'CM',	'Cameroon',	237,	'XAF',	7.28509,	'CFA Franc BEAC',	0,	NULL,	NULL,	''),
(38,	'CA',	'Canada',	1,	'CAD',	0.01656,	'Canadian Dollar',	1,	NULL,	NULL,	''),
(39,	'CV',	'Cape Verde',	238,	'CVE',	1.22458,	'Cabo Verde Escudo',	0,	NULL,	NULL,	''),
(40,	'KY',	'Cayman Islands',	1345,	'KYD',	0.00997,	'Cayman Islands Dollar',	0,	NULL,	NULL,	''),
(41,	'CF',	'Central African Republic',	236,	'XAF',	7.28509,	'CFA Franc BEAC',	0,	NULL,	NULL,	''),
(42,	'TD',	'Chad',	235,	'XAF',	7.28509,	'CFA Franc BEAC',	0,	NULL,	NULL,	''),
(43,	'CL',	'Chile',	56,	'CLP',	11.32718,	'Chilean Peso',	0,	NULL,	NULL,	''),
(44,	'CN',	'China',	86,	'CNY',	0.08522,	'Yuan Renminbi',	1,	NULL,	NULL,	''),
(46,	'CC',	'Cocos (Keeling) Islands',	672,	'AUD',	0.01800,	'Australian Dollar',	0,	NULL,	NULL,	''),
(47,	'CO',	'Colombia',	57,	'COP',	51.62556,	'Colombian Peso',	0,	NULL,	NULL,	''),
(48,	'KM',	'Comoros',	269,	'KMF',	5.46211,	'Comoro Franc',	0,	NULL,	NULL,	''),
(49,	'CG',	'Congo',	242,	'XAF',	7.28509,	'CFA Franc BEAC',	0,	NULL,	NULL,	''),
(51,	'CK',	'Cook Islands',	682,	'NZD',	0.01990,	'New Zealand Dollar',	0,	NULL,	NULL,	''),
(52,	'CR',	'Costa Rica',	506,	'CRC',	6.17163,	'Costa Rican Colon',	0,	NULL,	NULL,	''),
(53,	'CI',	'C?te d\'Ivoire',	225,	'XOF',	7.28505,	'CFA Franc BCEAO',	0,	NULL,	NULL,	''),
(54,	'HR',	'Croatia',	385,	'HRK',	0.08255,	'Croatian Kuna',	1,	NULL,	NULL,	''),
(55,	'CU',	'Cuba',	53,	'CUP',	0.31753,	'Cuban Peso',	0,	NULL,	NULL,	''),
(56,	'CY',	'Cyprus',	357,	'EUR',	0.01110,	'Euro',	1,	NULL,	NULL,	''),
(57,	'CZ',	'Czech Republic',	420,	'CZK',	0.27989,	'Czech Koruna',	1,	NULL,	NULL,	''),
(58,	'DK',	'Denmark',	45,	'DKK',	0.08279,	'Danish Krone',	1,	NULL,	NULL,	''),
(59,	'DJ',	'Djibouti',	253,	'DJF',	2.13146,	'Djibouti Franc',	0,	NULL,	NULL,	''),
(60,	'DM',	'Dominica',	1767,	'XCD',	0.03238,	'East Caribbean Dollar',	0,	NULL,	NULL,	''),
(61,	'DO',	'Dominican Republic',	1809,	'DOP',	0.72089,	'Dominican Peso',	0,	NULL,	NULL,	''),
(62,	'TP',	'East Timor',	670,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(63,	'EC',	'Ecuador',	593,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(64,	'EG',	'Egypt',	20,	'EGP',	0.58438,	'Egyptian Pound',	0,	NULL,	NULL,	''),
(65,	'SV',	'El Salvador',	503,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(66,	'GQ',	'Equatorial Guinea',	240,	'XAF',	7.28509,	'CFA Franc BEAC',	0,	NULL,	NULL,	''),
(67,	'ER',	'Eritrea',	291,	'ERN',	0.17973,	'Nakfa',	0,	NULL,	NULL,	''),
(68,	'EE',	'Estonia',	372,	'EUR',	0.01110,	'Euro',	0,	NULL,	NULL,	''),
(69,	'ET',	'Ethiopia',	251,	'ETB',	1.42660,	'Ethiopian Birr',	0,	NULL,	NULL,	''),
(71,	'FK',	'Falkland Islands (Malvinas)',	500,	'FKP',	0.00917,	'Falkland Islands Pound',	0,	NULL,	NULL,	''),
(72,	'FO',	'Faroe Islands',	298,	'DKK',	0.08279,	'Danish Krone',	0,	NULL,	NULL,	''),
(73,	'FJ',	'Fiji',	679,	'FJD',	0.02683,	'Fiji Dollar',	0,	NULL,	NULL,	''),
(74,	'FI',	'Finland',	358,	'EUR',	0.01110,	'Euro',	1,	NULL,	NULL,	''),
(75,	'FR',	'France',	33,	'EUR',	0.01110,	'Euro',	1,	NULL,	NULL,	''),
(76,	'GF',	'French Guiana',	594,	'EUR',	0.01110,	'Euro',	0,	NULL,	NULL,	''),
(77,	'PF',	'French Polynesia',	689,	'XPF',	1.32429,	'CFP Franc',	0,	NULL,	NULL,	''),
(79,	'GA',	'Gabon',	241,	'XAF',	7.28509,	'CFA Franc BEAC',	0,	NULL,	NULL,	''),
(80,	'GM',	'Gambia',	220,	'GMD',	0.83876,	'Dalasi',	0,	NULL,	NULL,	''),
(81,	'GE',	'Georgia',	995,	'GEL',	0.03283,	'Lari',	1,	NULL,	NULL,	''),
(82,	'DE',	'Germany',	49,	'EUR',	0.01110,	'Euro',	1,	NULL,	NULL,	''),
(83,	'GH',	'Ghana',	233,	'GHS',	0.19289,	'Ghana Cedi',	0,	NULL,	NULL,	''),
(84,	'GI',	'Gibraltar',	350,	'GIP',	0.00917,	'Gibraltar Pound',	0,	NULL,	NULL,	''),
(85,	'GR',	'Greece',	30,	'EUR',	0.01110,	'Euro',	1,	NULL,	NULL,	''),
(86,	'GL',	'Greenland',	299,	'DKK',	0.08279,	'Danish Krone',	0,	NULL,	NULL,	''),
(87,	'GD',	'Grenada',	1473,	'XCD',	0.03238,	'East Caribbean Dollar',	0,	NULL,	NULL,	''),
(88,	'GP',	'Guadeloupe',	590,	'EUR',	0.01110,	'Euro',	0,	NULL,	NULL,	''),
(89,	'GU',	'Guam',	1671,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(90,	'GT',	'Guatemala',	502,	'GTQ',	0.09256,	'Quetzal',	0,	NULL,	NULL,	''),
(92,	'GN',	'Guinea',	224,	'GNF',	103.25195,	'Guinea Franc',	0,	NULL,	NULL,	''),
(93,	'GW',	'Guinea-Bissau',	245,	'XOF',	7.28505,	'CFA Franc BCEAO',	0,	NULL,	NULL,	''),
(94,	'GY',	'Guyana',	592,	'GYD',	2.50225,	'Guyana Dollar',	0,	NULL,	NULL,	''),
(95,	'HT',	'Haiti',	509,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(97,	'HN',	'Honduras',	504,	'HNL',	0.30168,	'Lempira',	0,	NULL,	NULL,	''),
(98,	'HK',	'Hong Kong',	852,	'HKD',	0.09310,	'Hong Kong Dollar',	0,	NULL,	NULL,	''),
(99,	'HU',	'Hungary',	36,	'HUF',	4.46950,	'Forint',	1,	NULL,	NULL,	''),
(100,	'IS',	'Iceland',	354,	'ISK',	1.65463,	'Iceland Krona',	0,	NULL,	NULL,	''),
(101,	'IN',	'India',	91,	'INR',	1.00744,	'Indian Rupee',	1,	NULL,	NULL,	''),
(102,	'ID',	'Indonesia',	62,	'IDR',	186.76685,	'Rupiah',	0,	NULL,	NULL,	''),
(103,	'IR',	'Iran',	98,	'IRR',	504.36319,	'Iranian Rial',	0,	NULL,	NULL,	''),
(104,	'IQ',	'Iraq',	964,	'IQD',	15.68041,	'Iraqi Dinar',	0,	NULL,	NULL,	''),
(105,	'IE',	'Ireland',	353,	'EUR',	0.01110,	'Euro',	1,	NULL,	NULL,	''),
(106,	'IL',	'Israel',	972,	'ILS',	0.04540,	'New Israeli Sheqel',	0,	NULL,	NULL,	''),
(107,	'IT',	'Italy',	39,	'EUR',	0.01110,	'Euro',	1,	NULL,	NULL,	''),
(108,	'JM',	'Jamaica',	1876,	'JMD',	1.89969,	'Jamaican Dollar',	0,	NULL,	NULL,	''),
(109,	'JP',	'Japan',	81,	'JPY',	1.82376,	'Yen',	0,	NULL,	NULL,	''),
(111,	'JO',	'Jordan',	962,	'JOD',	0.00850,	'Jordanian Dinar',	0,	NULL,	NULL,	''),
(112,	'KZ',	'Kazakhstan',	7,	'KZT',	5.81482,	'Tenge',	0,	NULL,	NULL,	''),
(113,	'KE',	'Kenya',	254,	'KES',	1.54404,	'Kenyan Shilling',	0,	NULL,	NULL,	''),
(114,	'KI',	'Kiribati',	686,	'AUD',	0.01800,	'Australian Dollar',	0,	NULL,	NULL,	''),
(115,	'KP',	'Korea, North',	850,	'KPW',	10.78403,	'North Korean Won',	0,	NULL,	NULL,	''),
(116,	'KR',	'Korea, South',	82,	'KRW',	16.51604,	'Won',	0,	NULL,	NULL,	''),
(117,	'KW',	'Kuwait',	965,	'KWD',	0.00367,	'Kuwaiti Dinar',	0,	NULL,	NULL,	''),
(118,	'KG',	'Kyrgyzstan',	996,	'KGS',	1.02440,	'Som',	0,	NULL,	NULL,	''),
(119,	'LA',	'Laos',	856,	'LAK',	262.97884,	'Kip',	0,	NULL,	NULL,	''),
(120,	'LV',	'Latvia',	371,	'EUR',	0.01110,	'Euro',	1,	NULL,	NULL,	''),
(121,	'LB',	'Lebanon',	961,	'LBP',	1071.86729,	'Lebanese Pound',	0,	NULL,	NULL,	''),
(122,	'LS',	'Lesotho',	266,	'ZAR',	0.21221,	'Rand',	0,	NULL,	NULL,	''),
(123,	'LR',	'Liberia',	231,	'LRD',	2.30412,	'Liberian Dollar',	0,	NULL,	NULL,	''),
(124,	'LY',	'Libya',	218,	'LYD',	0.05766,	'Libyan Dinar',	0,	NULL,	NULL,	''),
(125,	'LI',	'Liechtenstein',	423,	'CHF',	0.01038,	'Swiss Franc',	0,	NULL,	NULL,	''),
(126,	'LT',	'Lithuania',	370,	'EUR',	0.01110,	'Euro',	1,	NULL,	NULL,	''),
(127,	'LU',	'Luxembourg',	352,	'EUR',	0.01110,	'Euro',	0,	NULL,	NULL,	''),
(128,	'MO',	'Macao',	853,	'MOP',	0.09580,	'Pataca',	0,	NULL,	NULL,	''),
(129,	'MK',	'Macedonia, the Former Yugoslav Republic of',	389,	'MKD',	0.68276,	'Denar',	0,	NULL,	NULL,	''),
(130,	'MG',	'Madagascar',	261,	'MGA',	55.47470,	'Malagasy Ariary',	0,	NULL,	NULL,	''),
(131,	'MW',	'Malawi',	265,	'MWK',	20.75498,	'Kwacha',	0,	NULL,	NULL,	''),
(132,	'MY',	'Malaysia',	60,	'MYR',	0.05215,	'Malaysian Ringgit',	1,	NULL,	NULL,	''),
(133,	'MV',	'Maldives',	960,	'MVR',	0.18392,	'Rufiyaa',	0,	NULL,	NULL,	''),
(134,	'ML',	'Mali',	223,	'XOF',	7.28505,	'CFA Franc BCEAO',	0,	NULL,	NULL,	''),
(135,	'MT',	'Malta',	356,	'EUR',	0.01110,	'Euro',	1,	NULL,	NULL,	''),
(137,	'MH',	'Marshall Islands',	692,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(138,	'MQ',	'Martinique',	596,	'EUR',	0.01110,	'Euro',	0,	NULL,	NULL,	''),
(139,	'MR',	'Mauritania',	222,	'MRO',	NULL,	'Ouguiya',	0,	NULL,	NULL,	''),
(140,	'MU',	'Mauritius',	230,	'MUR',	0.55346,	'Mauritius Rupee',	1,	NULL,	NULL,	''),
(141,	'YT',	'Mayotte',	269,	'EUR',	0.01110,	'Euro',	0,	NULL,	NULL,	''),
(142,	'MX',	'Mexico',	52,	'MXN',	0.23731,	'Mexican Peso',	0,	NULL,	NULL,	''),
(143,	'FM',	'Micronesia, Federated States of',	691,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(144,	'MD',	'Moldova, Republic of',	373,	'MDL',	0.21479,	'Moldovan Leu',	0,	NULL,	NULL,	''),
(145,	'MC',	'Monaco',	377,	'EUR',	0.01110,	'Euro',	0,	NULL,	NULL,	''),
(146,	'MN',	'Mongolia',	976,	'MNT',	40.71571,	'Tugrik',	0,	NULL,	NULL,	''),
(147,	'MS',	'Montserrat',	1664,	'XCD',	0.03238,	'East Caribbean Dollar',	0,	NULL,	NULL,	''),
(148,	'MA',	'Morocco',	212,	'MAD',	0.11858,	'Moroccan Dirham',	0,	NULL,	NULL,	''),
(149,	'MZ',	'Mozambique',	258,	'MZN',	0.76555,	'Mozambique Metical',	0,	NULL,	NULL,	''),
(150,	'MM',	'Myanmar',	95,	'MMK',	38.91790,	'Kyat',	0,	NULL,	NULL,	''),
(151,	'NA',	'Namibia',	264,	'ZAR',	0.21221,	'Rand',	0,	NULL,	NULL,	''),
(152,	'NR',	'Nauru',	674,	'AUD',	0.01800,	'Australian Dollar',	0,	NULL,	NULL,	''),
(153,	'NP',	'Nepal',	977,	'NPR',	1.61174,	'Nepalese Rupee',	0,	NULL,	NULL,	''),
(155,	'NL',	'Netherlands',	31,	'USD',	0.01198,	'US Dollar',	1,	NULL,	NULL,	''),
(156,	'NC',	'New Caledonia',	687,	'XPF',	1.32429,	'CFP Franc',	0,	NULL,	NULL,	''),
(157,	'NZ',	'New Zealand',	64,	'NZD',	0.01990,	'New Zealand Dollar',	1,	NULL,	NULL,	''),
(158,	'NI',	'Nicaragua',	505,	'NIO',	0.44046,	'Cordoba Oro',	0,	NULL,	NULL,	''),
(159,	'NE',	'Niger',	227,	'XOF',	7.28505,	'CFA Franc BCEAO',	0,	NULL,	NULL,	''),
(160,	'NG',	'Nigeria',	234,	'NGN',	19.67930,	'Naira',	0,	NULL,	NULL,	''),
(161,	'NU',	'Niue',	683,	'NZD',	0.01990,	'New Zealand Dollar',	0,	NULL,	NULL,	''),
(162,	'NF',	'Norfolk Island',	672,	'AUD',	0.01800,	'Australian Dollar',	0,	NULL,	NULL,	''),
(163,	'MP',	'Northern Mariana Islands',	1670,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(164,	'NO',	'Norway',	47,	'NOK',	0.13119,	'Norwegian Krone',	0,	NULL,	NULL,	''),
(165,	'OM',	'Oman',	968,	'OMR',	0.00461,	'Rial Omani',	0,	NULL,	NULL,	''),
(166,	'PK',	'Pakistan',	92,	'PKR',	3.32453,	'Pakistan Rupee',	0,	NULL,	NULL,	''),
(167,	'PW',	'Palau',	680,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(168,	'PS',	'Palestinian Territory Occupied',	970,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(169,	'PA',	'Panama',	507,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(170,	'PG',	'Papua New Guinea',	675,	'PGK',	0.04786,	'Kina',	0,	NULL,	NULL,	''),
(171,	'PY',	'Paraguay',	595,	'PYG',	94.96736,	'Guarani',	0,	NULL,	NULL,	''),
(172,	'PE',	'Peru',	51,	'PEN',	0.04490,	'Nuevo Sol',	0,	NULL,	NULL,	''),
(173,	'PH',	'Philippines',	63,	'PHP',	0.69451,	'Philippine Peso',	0,	NULL,	NULL,	''),
(175,	'PL',	'Poland',	48,	'PLN',	0.04819,	'Zloty',	0,	NULL,	NULL,	''),
(176,	'PT',	'Portugal',	351,	'EUR',	0.01110,	'Euro',	1,	NULL,	NULL,	''),
(177,	'PR',	'Puerto Rico',	1787,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(178,	'QA',	'Qatar',	974,	'QAR',	0.04365,	'Qatari Rial',	0,	NULL,	NULL,	''),
(179,	'RE',	'Reunion',	262,	'EUR',	0.01110,	'Euro',	0,	NULL,	NULL,	''),
(180,	'RO',	'Romania',	40,	'RON',	0.05519,	'New Romanian Leu',	0,	NULL,	NULL,	''),
(181,	'RU',	'Russia',	70,	'RUB',	1.15958,	'Russian Ruble',	1,	NULL,	NULL,	''),
(182,	'RW',	'Rwanda',	250,	'RWF',	16.18928,	'Rwanda Franc',	0,	NULL,	NULL,	''),
(183,	'SH',	'Saint Helena',	290,	'SHP',	0.00917,	'Saint Helena Pound',	0,	NULL,	NULL,	''),
(184,	'KN',	'Saint Kitts and Nevis',	1869,	'XCD',	0.03238,	'East Caribbean Dollar',	0,	NULL,	NULL,	''),
(185,	'LC',	'Saint Lucia',	1758,	'XCD',	0.03238,	'East Caribbean Dollar',	0,	NULL,	NULL,	''),
(186,	'PM',	'Saint Pierre and Miquelon',	508,	'EUR',	0.01110,	'Euro',	0,	NULL,	NULL,	''),
(187,	'VC',	'Saint Vincent and the Grenadines',	1784,	'XCD',	0.03238,	'East Caribbean Dollar',	0,	NULL,	NULL,	''),
(188,	'WS',	'Samoa',	684,	'WST',	0.03356,	'Tala',	0,	NULL,	NULL,	''),
(189,	'SM',	'San Marino',	378,	'EUR',	0.01110,	'Euro',	0,	NULL,	NULL,	''),
(190,	'ST',	'Sao Tome and Principe',	239,	'STD',	248.00854,	'Dobra',	0,	NULL,	NULL,	''),
(191,	'SA',	'Saudi Arabia',	966,	'SAR',	0.04500,	'Saudi Riyal',	0,	NULL,	NULL,	''),
(192,	'SN',	'Senegal',	221,	'XOF',	7.28505,	'CFA Franc BCEAO',	0,	NULL,	NULL,	''),
(193,	'RS',	'Serbia',	381,	'RSD',	1.29883,	'Serbian Dinar',	0,	NULL,	NULL,	''),
(194,	'SC',	'Seychelles',	248,	'SCR',	0.16319,	'Seychelles Rupee',	0,	NULL,	NULL,	''),
(195,	'SL',	'Sierra Leone',	232,	'SLL',	251.26191,	'Leone',	0,	NULL,	NULL,	''),
(196,	'SG',	'Singapore',	65,	'SGD',	0.01582,	'Singapore Dollar',	1,	NULL,	NULL,	''),
(197,	'SK',	'Slovakia',	421,	'EUR',	0.01110,	'Euro',	0,	NULL,	NULL,	''),
(198,	'SI',	'Slovenia',	386,	'EUR',	0.01110,	'Euro',	0,	NULL,	NULL,	''),
(200,	'SB',	'Solomon Islands',	677,	'SBD',	0.09928,	'Solomon Islands Dollar',	0,	NULL,	NULL,	''),
(201,	'SO',	'Somalia',	252,	'SOS',	6.84021,	'Somali Shilling',	0,	NULL,	NULL,	''),
(202,	'ZA',	'South Africa',	27,	'ZAR',	0.21221,	'Rand',	1,	NULL,	NULL,	''),
(204,	'SS',	'South Sudan',	211,	'SSP',	NULL,	'South Sudanese Pound',	0,	NULL,	NULL,	''),
(205,	'ES',	'Spain',	34,	'EUR',	0.01110,	'Euro',	1,	NULL,	NULL,	''),
(206,	'LK',	'Sri Lanka',	94,	'LKR',	3.51305,	'Sri Lanka Rupee',	0,	NULL,	NULL,	''),
(207,	'SD',	'Sudan',	249,	'SDG',	7.20758,	'Sudanese Pound',	0,	NULL,	NULL,	''),
(208,	'SR',	'Suriname',	597,	'SRD',	0.40274,	'Surinam Dollar',	0,	NULL,	NULL,	''),
(209,	'SJ',	'Svalbard and Jan Mayen',	47,	'NOK',	0.13119,	'Norwegian Krone',	0,	NULL,	NULL,	''),
(210,	'SZ',	'Swaziland',	268,	'SZL',	0.21068,	'Lilangeni',	0,	NULL,	NULL,	''),
(211,	'SE',	'Sweden',	46,	'SEK',	0.12671,	'Swedish Krona',	1,	NULL,	NULL,	''),
(212,	'CH',	'Switzerland',	41,	'CHF',	0.01038,	'Swiss Franc',	1,	NULL,	NULL,	''),
(213,	'SY',	'Syrian Arab Republic',	963,	'SYP',	30.10578,	'Syrian Pound',	0,	NULL,	NULL,	''),
(214,	'TW',	'Taiwan, Province of China',	886,	'TWD',	0.38425,	'New Taiwan Dollar',	0,	NULL,	NULL,	''),
(215,	'TJ',	'Tajikistan',	992,	'TJS',	0.12747,	'Somoni',	0,	NULL,	NULL,	''),
(216,	'TZ',	'Tanzania, United Republic of',	255,	'TZS',	32.69378,	'Tanzanian Shilling',	0,	NULL,	NULL,	''),
(217,	'TH',	'Thailand',	66,	'THB',	0.40406,	'Baht',	0,	NULL,	NULL,	''),
(218,	'TG',	'Togo',	228,	'XOF',	7.28505,	'CFA Franc BCEAO',	0,	NULL,	NULL,	''),
(219,	'TK',	'Tokelau',	690,	'NZD',	0.01990,	'New Zealand Dollar',	0,	NULL,	NULL,	''),
(220,	'TO',	'Tonga',	676,	'TOP',	0.02806,	'Pa?anga',	0,	NULL,	NULL,	''),
(221,	'TT',	'Trinidad and Tobago',	1868,	'TTD',	0.08132,	'Trinidad and Tobago Dollar',	0,	NULL,	NULL,	''),
(222,	'TN',	'Tunisia',	216,	'TND',	0.03733,	'Tunisian Dinar',	0,	NULL,	NULL,	''),
(223,	'TR',	'Turkey',	90,	'TRY',	0.41056,	'Turkish Lira',	0,	NULL,	NULL,	''),
(224,	'TM',	'Turkmenistan',	7370,	'TMT',	0.04206,	'Turkmenistan New Manat',	0,	NULL,	NULL,	''),
(225,	'TC',	'Turks and Caicos Islands',	1649,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(226,	'TV',	'Tuvalu',	688,	'AUD',	0.01800,	'Australian Dollar',	0,	NULL,	NULL,	''),
(227,	'UG',	'Uganda',	256,	'UGX',	43.86786,	'Uganda Shilling',	0,	NULL,	NULL,	''),
(228,	'UA',	'Ukraine',	380,	'UAH',	0.49377,	'Hryvnia',	0,	NULL,	NULL,	''),
(229,	'AE',	'United Arab Emirates',	971,	'AED',	0.04401,	'UAE Dirham',	1,	NULL,	NULL,	''),
(230,	'GB',	'United Kingdom',	44,	'GBP',	0.00924,	'Pound Sterling',	1,	NULL,	NULL,	''),
(231,	'US',	'USA',	1,	'USD',	0.01198,	'US Dollar',	1,	NULL,	NULL,	''),
(233,	'UY',	'Uruguay',	598,	'UYU',	0.49620,	'Peso Uruguayo',	0,	NULL,	NULL,	''),
(234,	'UZ',	'Uzbekistan',	998,	'UZS',	153.41679,	'Uzbekistan Sum',	0,	NULL,	NULL,	''),
(235,	'VU',	'Vanuatu',	678,	'VUV',	1.42256,	'Vatu',	0,	NULL,	NULL,	''),
(237,	'VE',	'Venezuela',	58,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(238,	'VN',	'Vietnam',	84,	'VND',	304.52907,	'Dong',	0,	NULL,	NULL,	''),
(239,	'VG',	'Virgin Islands, British',	1284,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(240,	'VI',	'Virgin Islands, U.S.',	1340,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(241,	'WF',	'Wallis and Futuna',	681,	'XPF',	1.32429,	'CFP Franc',	0,	NULL,	NULL,	''),
(243,	'YE',	'Yemen',	967,	'YER',	3.00038,	'Yemeni Rial',	0,	NULL,	NULL,	''),
(244,	'YU',	'Yugoslavia',	38,	'USD',	0.01198,	'US Dollar',	0,	NULL,	NULL,	''),
(245,	'ZM',	'Zambia',	260,	'ZMW',	0.31749,	'Zambian Kwacha',	0,	NULL,	NULL,	''),
(246,	'ZW',	'Zimbabwe',	263,	'ZWL',	3.85828,	'Zimbabwe Dollar',	0,	NULL,	NULL,	'');


DROP TABLE IF EXISTS `country_info_doc`;
CREATE TABLE `country_info_doc` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `file` varchar(150) NOT NULL,
  `folder` int(11) NOT NULL,
  `description` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `country_info_folder`;
CREATE TABLE `country_info_folder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `image` varchar(150) DEFAULT NULL,
  `parent` int(11) NOT NULL DEFAULT 0,
  `sharing` enum('public','member','private') NOT NULL DEFAULT 'private',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `country_study`;
CREATE TABLE `country_study` (
  `country` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`country`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `country_study` (`country`, `status`) VALUES
('Afghanistan',	0),
('Albania',	0),
('Algeria',	0),
('American Samoa',	0),
('Andorra',	0),
('Angola',	0),
('Anguilla',	0),
('Antigua And Barbuda',	0),
('Argentina',	0),
('Armenia',	0),
('Aruba',	0),
('Australia',	1),
('Austria',	1),
('Azerbaijan',	0),
('Bahamas The',	0),
('Bahrain',	0),
('Bangladesh',	0),
('Barbados',	0),
('Belarus',	0),
('Belgium',	0),
('Belize',	0),
('Benin',	0),
('Bermuda',	0),
('Bhutan',	0),
('Bolivia',	0),
('Bosnia and Herzegovina',	0),
('Botswana',	0),
('Brazil',	0),
('British Indian Ocean Territory',	0),
('Brunei',	0),
('Bulgaria',	1),
('Burkina Faso',	0),
('Burundi',	0),
('Cambodia',	0),
('Cameroon',	0),
('Canada',	1),
('Cape Verde',	0),
('Cayman Islands',	0),
('Central African Republic',	0),
('Chad',	0),
('Chile',	0),
('China',	1),
('Christmas Island',	0),
('Cocos (Keeling) Islands',	0),
('Colombia',	0),
('Comoros',	0),
('Cook Islands',	0),
('Costa Rica',	0),
('Cote D\'Ivoire (Ivory Coast)',	0),
('Croatia (Hrvatska)',	0),
('Cuba',	0),
('Cyprus',	1),
('Czech Republic',	1),
('Democratic Republic Of The Congo',	0),
('Denmark',	1),
('Djibouti',	0),
('Dominica',	0),
('Dominican Republic',	0),
('Dubai',	1),
('East Timor',	0),
('Ecuador',	0),
('Egypt',	0),
('El Salvador',	0),
('Equatorial Guinea',	0),
('Eritrea',	0),
('Estonia',	0),
('Ethiopia',	0),
('External Territories of Australia',	0),
('Falkland Islands',	0),
('Faroe Islands',	0),
('Fiji Islands',	0),
('Finland',	1),
('France',	1),
('French Guiana',	0),
('French Polynesia',	0),
('Gabon',	0),
('Gambia The',	0),
('Georgia',	0),
('Germany',	1),
('Ghana',	0),
('Gibraltar',	0),
('Greece',	0),
('Greenland',	0),
('Grenada',	0),
('Guadeloupe',	0),
('Guam',	0),
('Guatemala',	0),
('Guernsey and Alderney',	0),
('Guinea',	0),
('Guinea-Bissau',	0),
('Guyana',	0),
('Haiti',	0),
('Honduras',	0),
('Hong Kong S.A.R.',	0),
('HongKong',	1),
('Hungary',	1),
('Iceland',	0),
('India',	0),
('Indonesia',	0),
('Iran',	0),
('Iraq',	0),
('Ireland',	1),
('Israel',	0),
('Italy',	1),
('Jamaica',	0),
('Japan',	0),
('Jersey',	0),
('Jordan',	0),
('Kazakhstan',	0),
('Kenya',	0),
('Kiribati',	0),
('Kuwait',	0),
('Kyrgyzstan',	0),
('Laos',	0),
('Latvia',	0),
('Lebanon',	0),
('Lesotho',	0),
('Liberia',	0),
('Libya',	0),
('Liechtenstein',	0),
('Lithuania',	1),
('Luxembourg',	0),
('Macau S.A.R.',	0),
('Macedonia',	0),
('Madagascar',	0),
('Malawi',	0),
('Malaysia',	1),
('Maldives',	0),
('Mali',	0),
('Malta',	0),
('Man (Isle of)',	0),
('Marshall Islands',	0),
('Martinique',	0),
('Mauritania',	0),
('Mauritius',	1),
('Mayotte',	0),
('Mexico',	0),
('Micronesia',	0),
('Moldova',	0),
('Monaco',	0),
('Mongolia',	0),
('Montserrat',	0),
('Morocco',	0),
('Mozambique',	0),
('Myanmar',	0),
('Namibia',	0),
('Nauru',	0),
('Nepal',	0),
('Netherlands',	1),
('Netherlands Antilles',	0),
('Netherlands The',	0),
('New Caledonia',	0),
('New Zealand',	1),
('Nicaragua',	0),
('Niger',	0),
('Nigeria',	0),
('Niue',	0),
('Norfolk Island',	0),
('North Korea',	0),
('Northern Mariana Islands',	0),
('Norway',	0),
('Oman',	0),
('Pakistan',	0),
('Palau',	0),
('Palestinian Territory Occupied',	0),
('Panama',	0),
('Papua new Guinea',	0),
('Paraguay',	0),
('Peru',	0),
('Philippines',	0),
('Poland',	0),
('Portugal',	0),
('Puerto Rico',	0),
('Qatar',	0),
('Republic Of The Congo',	0),
('Reunion',	0),
('Romania',	0),
('Russia',	0),
('Rwanda',	0),
('Saint Helena',	0),
('Saint Kitts And Nevis',	0),
('Saint Lucia',	0),
('Saint Pierre and Miquelon',	0),
('Saint Vincent And The Grenadines',	0),
('Samoa',	0),
('San Marino',	0),
('Sao Tome and Principe',	0),
('Saudi Arabia',	0),
('Senegal',	0),
('Serbia',	0),
('Seychelles',	0),
('Sierra Leone',	0),
('Singapore',	1),
('Slovakia',	0),
('Slovenia',	0),
('Smaller Territories of the UK',	0),
('Solomon Islands',	0),
('Somalia',	0),
('South Africa',	1),
('South Korea',	0),
('South Sudan',	0),
('Spain',	1),
('Sri Lanka',	0),
('Sudan',	0),
('Suriname',	0),
('Svalbard And Jan Mayen Islands',	0),
('Swaziland',	0),
('Sweden',	1),
('Switzerland',	1),
('Syria',	0),
('Taiwan',	0),
('Tajikistan',	0),
('Tanzania',	0),
('Thailand',	0),
('Togo',	0),
('Tokelau',	0),
('Tonga',	0),
('Trinidad And Tobago',	0),
('Tunisia',	0),
('Turkey',	0),
('Turkmenistan',	0),
('Turks And Caicos Islands',	0),
('Tuvalu',	0),
('Uganda',	0),
('Ukraine',	0),
('United Arab Emirates',	0),
('United Kingdom',	1),
('Uruguay',	0),
('USA',	1),
('Uzbekistan',	0),
('Vanuatu',	0),
('Venezuela',	0),
('Vietnam',	0),
('Virgin Islands (British)',	0),
('Virgin Islands (US)',	0),
('Wallis And Futuna Islands',	0),
('Western Sahara',	0),
('Yemen',	0),
('Yugoslavia',	0),
('Zambia',	0),
('Zimbabwe',	0);

DROP TABLE IF EXISTS `courses`;
CREATE TABLE `courses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `description` varchar(500) DEFAULT NULL,
  `fees` decimal(13,2) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `category` int(11) NOT NULL DEFAULT 0,
  `level` int(11) NOT NULL DEFAULT 1,
  `has_offer` tinyint(1) NOT NULL DEFAULT 0,
  `offer_desc` varchar(500) DEFAULT NULL,
  `offer_price` decimal(13,2) NOT NULL DEFAULT 0.00,
  `display_order` int(11) NOT NULL DEFAULT 99,
  `updated_at` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `course_category`;
CREATE TABLE `course_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category` varchar(100) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `category` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `course_preference`;
CREATE TABLE `course_preference` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) unsigned NOT NULL,
  `country` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `course` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `university` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `intake_year` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `intake` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '1- Jan 2-Feb 3-Mar etc comma seperated',
  `country_id` int(11) NOT NULL DEFAULT 0,
  `course_id` int(11) NOT NULL DEFAULT 0,
  `course_other` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `university_other` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `university_id` int(11) NOT NULL DEFAULT 0,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `course_preference_userid_fk` (`userid`),
  CONSTRAINT `course_preference_userid_fk` FOREIGN KEY (`userid`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `course_recommendation`;
CREATE TABLE `course_recommendation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `upload_date` datetime NOT NULL,
  `userid` int(11) NOT NULL,
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `satisfied` enum('yes','no','none') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'none',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `course_shortlisted`;
CREATE TABLE `course_shortlisted` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(10) unsigned NOT NULL,
  `course_id` int(11) NOT NULL,
  `staff_suggested` tinyint(1) NOT NULL DEFAULT 0,
  `staff_id` int(11) NOT NULL DEFAULT 0,
  `student_approved` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  KEY `course_id` (`course_id`),
  CONSTRAINT `course_shortlisted_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `course_shortlisted_ibfk_2` FOREIGN KEY (`course_id`) REFERENCES `university_courses` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `currency`;
CREATE TABLE `currency` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `currency_code` varchar(3) NOT NULL,
  `currency_name` varchar(50) NOT NULL,
  `currency_symbol` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `currency` (`id`, `currency_code`, `currency_name`, `currency_symbol`) VALUES
(1,	'AFA',	'Afghan Afghani',	'؋'),
(2,	'ALL',	'Albanian Lek',	'Lek'),
(3,	'DZD',	'Algerian Dinar',	'دج'),
(4,	'AOA',	'Angolan Kwanza',	'Kz'),
(5,	'ARS',	'Argentine Peso',	'$'),
(6,	'AMD',	'Armenian Dram',	'֏'),
(7,	'AWG',	'Aruban Florin',	'ƒ'),
(8,	'AUD',	'Australian Dollar',	'$'),
(9,	'AZN',	'Azerbaijani Manat',	'm'),
(10,	'BSD',	'Bahamian Dollar',	'B$'),
(11,	'BHD',	'Bahraini Dinar',	'.د.ب'),
(12,	'BDT',	'Bangladeshi Taka',	'৳'),
(13,	'BBD',	'Barbadian Dollar',	'Bds$'),
(14,	'BYR',	'Belarusian Ruble',	'Br'),
(15,	'BEF',	'Belgian Franc',	'fr'),
(16,	'BZD',	'Belize Dollar',	'$'),
(17,	'BMD',	'Bermudan Dollar',	'$'),
(18,	'BTN',	'Bhutanese Ngultrum',	'Nu.'),
(19,	'BTC',	'Bitcoin',	'฿'),
(20,	'BOB',	'Bolivian Boliviano',	'Bs.'),
(21,	'BAM',	'Bosnia-Herzegovina Convertible Mark',	'KM'),
(22,	'BWP',	'Botswanan Pula',	'P'),
(23,	'BRL',	'Brazilian Real',	'R$'),
(24,	'GBP',	'British Pound Sterling',	'£'),
(25,	'BND',	'Brunei Dollar',	'B$'),
(26,	'BGN',	'Bulgarian Lev',	'Лв.'),
(27,	'BIF',	'Burundian Franc',	'FBu'),
(28,	'KHR',	'Cambodian Riel',	'KHR'),
(29,	'CAD',	'Canadian Dollar',	'$'),
(30,	'CVE',	'Cape Verdean Escudo',	'$'),
(31,	'KYD',	'Cayman Islands Dollar',	'$'),
(32,	'XOF',	'CFA Franc BCEAO',	'CFA'),
(33,	'XAF',	'CFA Franc BEAC',	'FCFA'),
(34,	'XPF',	'CFP Franc',	'₣'),
(35,	'CLP',	'Chilean Peso',	'$'),
(36,	'CLF',	'Chilean Unit of Account',	'CLF'),
(37,	'CNY',	'Chinese Yuan',	'¥'),
(38,	'COP',	'Colombian Peso',	'$'),
(39,	'KMF',	'Comorian Franc',	'CF'),
(40,	'CDF',	'Congolese Franc',	'FC'),
(41,	'CRC',	'Costa Rican Colón',	'₡'),
(42,	'HRK',	'Croatian Kuna',	'kn'),
(43,	'CUC',	'Cuban Convertible Peso',	'$, CUC'),
(44,	'CZK',	'Czech Republic Koruna',	'Kč'),
(45,	'DKK',	'Danish Krone',	'Kr.'),
(46,	'DJF',	'Djiboutian Franc',	'Fdj'),
(47,	'DOP',	'Dominican Peso',	'$'),
(48,	'XCD',	'East Caribbean Dollar',	'$'),
(49,	'EGP',	'Egyptian Pound',	'ج.م'),
(50,	'ERN',	'Eritrean Nakfa',	'Nfk'),
(51,	'EEK',	'Estonian Kroon',	'kr'),
(52,	'ETB',	'Ethiopian Birr',	'Nkf'),
(53,	'EUR',	'Euro',	'€'),
(54,	'FKP',	'Falkland Islands Pound',	'£'),
(55,	'FJD',	'Fijian Dollar',	'FJ$'),
(56,	'GMD',	'Gambian Dalasi',	'D'),
(57,	'GEL',	'Georgian Lari',	'ლ'),
(58,	'DEM',	'German Mark',	'DM'),
(59,	'GHS',	'Ghanaian Cedi',	'GH₵'),
(60,	'GIP',	'Gibraltar Pound',	'£'),
(61,	'GRD',	'Greek Drachma',	'₯, Δρχ, Δρ'),
(62,	'GTQ',	'Guatemalan Quetzal',	'Q'),
(63,	'GNF',	'Guinean Franc',	'FG'),
(64,	'GYD',	'Guyanaese Dollar',	'$'),
(65,	'HTG',	'Haitian Gourde',	'G'),
(66,	'HNL',	'Honduran Lempira',	'L'),
(67,	'HKD',	'Hong Kong Dollar',	'$'),
(68,	'HUF',	'Hungarian Forint',	'Ft'),
(69,	'ISK',	'Icelandic Króna',	'kr'),
(70,	'INR',	'Indian Rupee',	'₹'),
(71,	'IDR',	'Indonesian Rupiah',	'Rp'),
(72,	'IRR',	'Iranian Rial',	'﷼'),
(73,	'IQD',	'Iraqi Dinar',	'د.ع'),
(74,	'ILS',	'Israeli New Sheqel',	'₪'),
(75,	'ITL',	'Italian Lira',	'L,£'),
(76,	'JMD',	'Jamaican Dollar',	'J$'),
(77,	'JPY',	'Japanese Yen',	'¥'),
(78,	'JOD',	'Jordanian Dinar',	'ا.د'),
(79,	'KZT',	'Kazakhstani Tenge',	'лв'),
(80,	'KES',	'Kenyan Shilling',	'KSh'),
(81,	'KWD',	'Kuwaiti Dinar',	'ك.د'),
(82,	'KGS',	'Kyrgystani Som',	'лв'),
(83,	'LAK',	'Laotian Kip',	'₭'),
(84,	'LVL',	'Latvian Lats',	'Ls'),
(85,	'LBP',	'Lebanese Pound',	'£'),
(86,	'LSL',	'Lesotho Loti',	'L'),
(87,	'LRD',	'Liberian Dollar',	'$'),
(88,	'LYD',	'Libyan Dinar',	'د.ل'),
(89,	'LTC',	'Litecoin',	'Ł'),
(90,	'LTL',	'Lithuanian Litas',	'Lt'),
(91,	'MOP',	'Macanese Pataca',	'$'),
(92,	'MKD',	'Macedonian Denar',	'ден'),
(93,	'MGA',	'Malagasy Ariary',	'Ar'),
(94,	'MWK',	'Malawian Kwacha',	'MK'),
(95,	'MYR',	'Malaysian Ringgit',	'RM'),
(96,	'MVR',	'Maldivian Rufiyaa',	'Rf'),
(97,	'MRO',	'Mauritanian Ouguiya',	'MRU'),
(98,	'MUR',	'Mauritian Rupee',	'₨'),
(99,	'MXN',	'Mexican Peso',	'$'),
(100,	'MDL',	'Moldovan Leu',	'L'),
(101,	'MNT',	'Mongolian Tugrik',	'₮'),
(102,	'MAD',	'Moroccan Dirham',	'MAD'),
(103,	'MZM',	'Mozambican Metical',	'MT'),
(104,	'MMK',	'Myanmar Kyat',	'K'),
(105,	'NAD',	'Namibian Dollar',	'$'),
(106,	'NPR',	'Nepalese Rupee',	'₨'),
(107,	'ANG',	'Netherlands Antillean Guilder',	'ƒ'),
(108,	'TWD',	'New Taiwan Dollar',	'$'),
(109,	'NZD',	'New Zealand Dollar',	'$'),
(110,	'NIO',	'Nicaraguan Córdoba',	'C$'),
(111,	'NGN',	'Nigerian Naira',	'₦'),
(112,	'KPW',	'North Korean Won',	'₩'),
(113,	'NOK',	'Norwegian Krone',	'kr'),
(114,	'OMR',	'Omani Rial',	'.ع.ر'),
(115,	'PKR',	'Pakistani Rupee',	'₨'),
(116,	'PAB',	'Panamanian Balboa',	'B/.'),
(117,	'PGK',	'Papua New Guinean Kina',	'K'),
(118,	'PYG',	'Paraguayan Guarani',	'₲'),
(119,	'PEN',	'Peruvian Nuevo Sol',	'S/.'),
(120,	'PHP',	'Philippine Peso',	'₱'),
(121,	'PLN',	'Polish Zloty',	'zł'),
(122,	'QAR',	'Qatari Rial',	'ق.ر'),
(123,	'RON',	'Romanian Leu',	'lei'),
(124,	'RUB',	'Russian Ruble',	'₽'),
(125,	'RWF',	'Rwandan Franc',	'FRw'),
(126,	'SVC',	'Salvadoran Colón',	'₡'),
(127,	'WST',	'Samoan Tala',	'SAT'),
(128,	'STD',	'São Tomé and Príncipe Dobra',	'Db'),
(129,	'SAR',	'Saudi Riyal',	'﷼'),
(130,	'RSD',	'Serbian Dinar',	'din'),
(131,	'SCR',	'Seychellois Rupee',	'SRe'),
(132,	'SLL',	'Sierra Leonean Leone',	'Le'),
(133,	'SGD',	'Singapore Dollar',	'$'),
(134,	'SKK',	'Slovak Koruna',	'Sk'),
(135,	'SBD',	'Solomon Islands Dollar',	'Si$'),
(136,	'SOS',	'Somali Shilling',	'Sh.so.'),
(137,	'ZAR',	'South African Rand',	'R'),
(138,	'KRW',	'South Korean Won',	'₩'),
(139,	'SSP',	'South Sudanese Pound',	'£'),
(140,	'XDR',	'Special Drawing Rights',	'SDR'),
(141,	'LKR',	'Sri Lankan Rupee',	'Rs'),
(142,	'SHP',	'St. Helena Pound',	'£'),
(143,	'SDG',	'Sudanese Pound',	'.س.ج'),
(144,	'SRD',	'Surinamese Dollar',	'$'),
(145,	'SZL',	'Swazi Lilangeni',	'E'),
(146,	'SEK',	'Swedish Krona',	'kr'),
(147,	'CHF',	'Swiss Franc',	'CHf'),
(148,	'SYP',	'Syrian Pound',	'LS'),
(149,	'TJS',	'Tajikistani Somoni',	'SM'),
(150,	'TZS',	'Tanzanian Shilling',	'TSh'),
(151,	'THB',	'Thai Baht',	'฿'),
(152,	'TOP',	'Tongan Pa\'anga',	'$'),
(153,	'TTD',	'Trinidad & Tobago Dollar',	'$'),
(154,	'TND',	'Tunisian Dinar',	'ت.د'),
(155,	'TRY',	'Turkish Lira',	'₺'),
(156,	'TMT',	'Turkmenistani Manat',	'T'),
(157,	'UGX',	'Ugandan Shilling',	'USh'),
(158,	'UAH',	'Ukrainian Hryvnia',	'₴'),
(159,	'AED',	'United Arab Emirates Dirham',	'إ.د'),
(160,	'UYU',	'Uruguayan Peso',	'$'),
(161,	'USD',	'US Dollar',	'$'),
(162,	'UZS',	'Uzbekistan Som',	'лв'),
(163,	'VUV',	'Vanuatu Vatu',	'VT'),
(164,	'VEF',	'Venezuelan BolÃvar',	'Bs'),
(165,	'VND',	'Vietnamese Dong',	'₫'),
(166,	'YER',	'Yemeni Rial',	'﷼'),
(167,	'ZMK',	'Zambian Kwacha',	'ZK'),
(168,	'ZWL',	'Zimbabwean dollar',	'$');

DROP TABLE IF EXISTS `currency_rates`;
CREATE TABLE `currency_rates` (
  `code` varchar(3) NOT NULL,
  `symbol` varchar(5) NOT NULL,
  `rate` decimal(13,2) NOT NULL,
  PRIMARY KEY (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `currency_rates` (`code`, `symbol`, `rate`) VALUES
('EUR',	'€',	0.90),
('GBP',	'£',	0.80),
('INR',	'₹',	82.00),
('USD',	'$',	1.00);

DROP TABLE IF EXISTS `custom_attributes`;
CREATE TABLE `custom_attributes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `attr_name` varchar(100) NOT NULL,
  `label` varchar(500) NOT NULL,
  `type` enum('input','select','checkbox','radio','textarea') NOT NULL,
  `placeholder` varchar(100) DEFAULT NULL,
  `selection_values` text DEFAULT NULL,
  `select_multiple` tinyint(1) NOT NULL DEFAULT 0,
  `input_datatype` enum('text','number','decimal','date','year','email','mobile','phone','url') DEFAULT NULL,
  `input_min` int(11) DEFAULT NULL,
  `input_max` int(11) DEFAULT NULL,
  `laravel_rules` varchar(100) DEFAULT NULL,
  `for_lead` tinyint(1) NOT NULL,
  `for_student` tinyint(1) NOT NULL,
  `for_lead_mandatory` tinyint(1) NOT NULL,
  `for_student_mandatory` tinyint(1) NOT NULL,
  `web_to_lead` tinyint(1) DEFAULT 0 COMMENT 'decides whether it is used in web to lead form',
  `display_order` int(11) NOT NULL DEFAULT 99,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `custom_labels`;
CREATE TABLE `custom_labels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `label` varchar(50) NOT NULL,
  `default_text` varchar(191) NOT NULL,
  `custom_text` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `custom_labels` (`id`, `label`, `default_text`, `custom_text`, `created_at`, `updated_at`) VALUES
(1,	'class_10_certificate',	'Class 10th/SSC Certificate',	'Class 10th/SSC Certificate',	NULL,	NULL),
(2,	'class_10_marks_sheet',	'Class 10th/SSC Marks Sheet',	'Class 10th/SSC Marks Sheet',	NULL,	NULL),
(3,	'class_12_certificate',	'Class 12th/+2/HSC Certificate',	'Class 12th/+2/HSC Certificate',	NULL,	NULL),
(4,	'class_12_marks_sheet',	'Class 12th/+2/HSC Marks Sheet',	'Class 12th/+2/HSC Marks Sheet',	NULL,	NULL),
(5,	'diploma_certificate',	'Diploma Certificate',	'Diploma Certificate',	NULL,	NULL),
(6,	'diploma_marks_sheet',	'Diploma Marks Sheet',	'Diploma Marks Sheet',	NULL,	NULL),
(7,	'bachelors_certificate',	'Bachelors Certificate',	'Bachelors Certificate',	NULL,	NULL),
(8,	'bachelors_marks_sheet',	'Bachelors Marks Sheet',	'Bachelors Marks Sheet',	NULL,	NULL),
(9,	'bachelors_provisional_certificate',	'Bachelors Provisional Certificate',	'Bachelors Provisional Certificate',	NULL,	NULL),
(10,	'bachelors_marks_sheets_all_semesters',	'Bachelors Marks Sheets(All Semesters)',	'Bachelors Marks Sheets(All Semesters)',	NULL,	NULL),
(11,	'masters_certificate',	'Masters Certificate',	'Masters Certificate',	NULL,	NULL),
(12,	'masters_marks_sheet',	'Masters Marks Sheet',	'Masters Marks Sheet',	NULL,	NULL),
(13,	'masters_provisional_certificate',	'Masters Provisional Certificate',	'Masters Provisional Certificate',	NULL,	NULL),
(14,	'masters_marks_sheets_all_semesters',	'Masters Marks Sheets(All Semesters)',	'Masters Marks Sheets(All Semesters)',	NULL,	NULL),
(15,	'backend_students_menu',	'Students',	'Students',	NULL,	NULL),
(16,	'backend_support_tickets_menu',	'Support Tickets',	'Support Tickets',	NULL,	NULL),
(17,	'backend_students',	'Students',	'Students',	NULL,	NULL),
(18,	'backend_student',	'Student',	'Student',	NULL,	NULL),
(19,	'backend_support_tickets',	'Support Tickets',	'Support Tickets',	NULL,	NULL),
(20,	'backend_support_ticket',	'Support Ticket',	'Support Ticket',	NULL,	NULL),
(21,	'tax_id',	'Tax ID',	'GSTN',	NULL,	NULL);

DROP TABLE IF EXISTS `demo_class_category`;
CREATE TABLE `demo_class_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `parent` int(11) NOT NULL DEFAULT 0,
  `sharing` enum('public','private') NOT NULL DEFAULT 'private',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `demo_class_video`;
CREATE TABLE `demo_class_video` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `file_url` varchar(255) NOT NULL,
  `folder` int(11) NOT NULL,
  `description` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `downloads`;
CREATE TABLE `downloads` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `product_id` int(11) DEFAULT NULL,
  `file` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `employment_detail`;
CREATE TABLE `employment_detail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) NOT NULL,
  `employment_histroy_type` enum('Paid','Unpaid') NOT NULL,
  `employment_history_currently_working` varchar(50) NOT NULL,
  `employment_history_organisation_name` varchar(50) NOT NULL,
  `employment_history_industry_type` varchar(50) NOT NULL,
  `employment_history_employer_phone` varchar(50) DEFAULT NULL,
  `employment_history_address` varchar(150) NOT NULL,
  `employment_history_city` varchar(50) NOT NULL,
  `employment_history_state` int(11) NOT NULL,
  `employment_history_country` int(11) NOT NULL,
  `employment_history_postcode` varchar(10) DEFAULT NULL,
  `employment_history_contact_person_name` varchar(50) NOT NULL,
  `employment_history_contact_person_family_name` varchar(50) DEFAULT NULL,
  `employment_history_contact_person_business_phone` varchar(50) DEFAULT NULL,
  `employment_history_contact_person_mobile_number` varchar(50) DEFAULT NULL,
  `employment_history_working_position_occupation` varchar(50) NOT NULL,
  `employment_history_start_date` date NOT NULL,
  `employment_history_working_ended` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `exam`;
CREATE TABLE `exam` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `batch_id` int(11) DEFAULT NULL,
  `type` enum('mid','end','mock') DEFAULT 'mid',
  `exam_date` datetime DEFAULT NULL,
  `chapters` varchar(50) DEFAULT NULL,
  `objective_question_count` int(11) NOT NULL,
  `objective_question_mark` int(11) NOT NULL,
  `essay_question_count` int(11) NOT NULL,
  `essay_question_mark` int(11) NOT NULL,
  `comprehension_question_count` int(11) NOT NULL,
  `comprehension_question_mark` int(11) NOT NULL,
  `total_questions` int(11) NOT NULL DEFAULT 0 COMMENT 'comprehension question count not included. instead included comprehension count',
  `total_marks` int(11) NOT NULL DEFAULT 0,
  `duration` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `batch_id` (`batch_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `facebook_tokens`;
CREATE TABLE `facebook_tokens` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `access_type` varchar(255) NOT NULL,
  `facebook_id` bigint(20) NOT NULL,
  `access_token` text NOT NULL,
  `refresh_token` text DEFAULT NULL,
  `long_lived_token` text DEFAULT NULL,
  `token_type` text NOT NULL,
  `expires_at` datetime NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `failed_jobs`;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) NOT NULL,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `file_upload`;
CREATE TABLE `file_upload` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `filename` varchar(255) NOT NULL,
  `category` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `forms`;
CREATE TABLE `forms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `form_heading` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `redirect_url` varchar(255) NOT NULL,
  `branch` int(11) NOT NULL,
  `assign_to` int(11) DEFAULT NULL,
  `content` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `form_items`;
CREATE TABLE `form_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `label` varchar(255) DEFAULT NULL,
  `placeholder` varchar(255) DEFAULT NULL,
  `hint` varchar(255) DEFAULT NULL,
  `mandatory` int(1) DEFAULT 0,
  `unique` int(1) DEFAULT 0,
  `input_name` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `target` varchar(255) DEFAULT NULL,
  `form_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `holidays`;
CREATE TABLE `holidays` (
  `date` date NOT NULL,
  `event` varchar(100) NOT NULL,
  PRIMARY KEY (`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `imap_messages`;
CREATE TABLE `imap_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message_id` varchar(100) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `message_id` (`message_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `invoice`;
CREATE TABLE `invoice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_num` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `batch_id` int(11) NOT NULL DEFAULT 0,
  `currency` varchar(3) DEFAULT NULL,
  `tax1_name` varchar(191) DEFAULT NULL,
  `tax1_rate` int(11) DEFAULT NULL,
  `tax1_value` decimal(16,2) DEFAULT NULL,
  `tax1_value_base` decimal(16,2) DEFAULT NULL,
  `tax2_name` varchar(191) DEFAULT NULL,
  `tax2_rate` int(11) DEFAULT NULL,
  `tax2_value` decimal(16,2) DEFAULT NULL,
  `tax2_value_base` decimal(16,2) DEFAULT NULL,
  `total_tax` decimal(16,2) DEFAULT NULL,
  `total_tax_base` decimal(16,2) DEFAULT NULL,
  `tax_type` enum('inclusive','exclusive') DEFAULT NULL,
  `sub_total` decimal(16,2) NOT NULL,
  `sub_total_base` decimal(16,2) NOT NULL,
  `discount` decimal(16,2) NOT NULL,
  `discount_base` decimal(16,2) NOT NULL,
  `grand_total` decimal(16,2) NOT NULL,
  `grand_total_base` decimal(16,2) NOT NULL,
  `due_date` date NOT NULL,
  `status` enum('due','paid') NOT NULL DEFAULT 'due',
  `terms` text DEFAULT NULL,
  `terms_conditions` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `invoice_num` (`invoice_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `invoice_items`;
CREATE TABLE `invoice_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` int(11) NOT NULL,
  `currency` varchar(191) DEFAULT NULL,
  `item` varchar(191) DEFAULT NULL,
  `item_amount` decimal(16,2) DEFAULT NULL,
  `item_amount_base` decimal(16,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `invoice_payment`;
CREATE TABLE `invoice_payment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` int(11) NOT NULL,
  `payment_date` date NOT NULL,
  `amount` decimal(13,2) NOT NULL,
  `pay_mode` enum('bank_transfer','upi','cheque','cash','paypal','stripe','razorpay') NOT NULL,
  `trans_id` varchar(191) DEFAULT NULL,
  `staff_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `jobs`;
CREATE TABLE `jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(191) NOT NULL,
  `payload` longtext NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL,
  `reserved_at` int(10) unsigned DEFAULT NULL,
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `lang_courses`;
CREATE TABLE `lang_courses` (
  `name` varchar(30) NOT NULL,
  `description` varchar(400) DEFAULT NULL,
  `fees` int(11) NOT NULL DEFAULT 0,
  `image` varchar(150) DEFAULT NULL,
  `display_order` int(11) NOT NULL DEFAULT 99,
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `leads`;
CREATE TABLE `leads` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `first_name` varchar(50) NOT NULL,
  `last_name` varchar(50) DEFAULT NULL,
  `gender` varchar(10) DEFAULT NULL,
  `date_of_birth` date DEFAULT NULL,
  `dialcode` varchar(5) DEFAULT NULL,
  `mobile` varchar(20) DEFAULT NULL,
  `alternate_contact` varchar(50) DEFAULT NULL,
  `whatsapp` varchar(12) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `address` varchar(150) DEFAULT NULL,
  `lead_type` varchar(50) DEFAULT NULL,
  `status` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `current_course` varchar(100) DEFAULT NULL,
  `course` int(11) DEFAULT NULL,
  `study_level` varchar(50) DEFAULT NULL,
  `course_interested` varchar(100) DEFAULT NULL,
  `country` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_pref` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `accommodation` int(11) DEFAULT 0,
  `study_permit` int(11) DEFAULT 0,
  `education_loan` int(11) DEFAULT 0,
  `branch` int(11) DEFAULT 0,
  `qualification` varchar(50) DEFAULT NULL,
  `passout_year` varchar(4) DEFAULT NULL,
  `cgpa` decimal(13,2) DEFAULT NULL,
  `ielts` decimal(13,1) DEFAULT NULL,
  `toefl` decimal(13,1) DEFAULT NULL,
  `pte` decimal(13,1) DEFAULT NULL,
  `gre` decimal(13,1) DEFAULT NULL,
  `duolingo` decimal(13,1) DEFAULT NULL,
  `work_experience` varchar(50) DEFAULT NULL,
  `intake_year` varchar(4) DEFAULT NULL,
  `intake_month` varchar(45) DEFAULT NULL,
  `lead_source` varchar(50) DEFAULT NULL,
  `lead_source_detail` varchar(500) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `created_by` int(11) DEFAULT 0,
  `assigned_to` int(11) NOT NULL DEFAULT 0,
  `last_followup` timestamp NULL DEFAULT NULL,
  `next_followup` timestamp NULL DEFAULT NULL,
  `counselling_date` timestamp NULL DEFAULT NULL,
  `campaign_id` varchar(150) DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `lead_activity`;
CREATE TABLE `lead_activity` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lead_id` int(11) NOT NULL,
  `date` datetime NOT NULL,
  `staff` int(11) NOT NULL DEFAULT 0,
  `type` enum('followup','others') NOT NULL DEFAULT 'followup',
  `detail` text NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `lead_status`;
CREATE TABLE `lead_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `status` varchar(100) NOT NULL,
  `default` tinyint(1) NOT NULL DEFAULT 0,
  `converted_status` tinyint(1) NOT NULL DEFAULT 0,
  `disqualified_status` tinyint(1) NOT NULL DEFAULT 0,
  `counselling_status` tinyint(1) NOT NULL DEFAULT 0,
  `colorcode` varchar(50) DEFAULT '#2A3042',
  `display_order` int(11) NOT NULL,
  `deadline` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `lead_status` (`id`, `status`, `default`, `converted_status`, `disqualified_status`, `counselling_status`, `colorcode`, `display_order`, `deadline`, `created_at`, `updated_at`) VALUES
(1,	'Hot',	1,	0,	0,	0,	'#16b4d4',	1,	NULL,	'2022-09-23 15:52:58',	NULL),
(2,	'Prospect',	0,	0,	0,	0,	'#dc3545',	2,	NULL,	'2022-09-23 15:52:58',	NULL),
(3,	'Counseling',	0,	0,	0,	1,	'#a2c4a5',	3,	NULL,	'2022-09-23 15:52:58',	NULL),
(4,	'Converted',	0,	1,	0,	0,	'#28a745',	4,	NULL,	'2022-09-23 15:52:58',	NULL),
(5,	'Disqualified',	0,	0,	1,	0,	'#6c757d',	5,	NULL,	'2022-09-23 15:52:58',	NULL),
(6,	'Long term nurture',	0,	0,	0,	0,	'#ae9c7a',	6,	NULL,	'2022-09-23 15:52:58',	NULL),
(7,	'Warm',	0,	0,	0,	0,	'#ed7228',	7,	NULL,	'2022-09-23 15:52:58',	NULL),
(8,	'Cold',	0,	0,	0,	0,	'#ffc107',	8,	NULL,	'2022-09-23 15:52:58',	NULL);

DROP TABLE IF EXISTS `mail_sync_accounts`;
CREATE TABLE `mail_sync_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `imap_email` varchar(100) DEFAULT NULL,
  `imap_password` varchar(100) DEFAULT NULL,
  `imap_host` varchar(100) DEFAULT NULL,
  `imap_port` int(11) DEFAULT NULL,
  `imap_connection` varchar(10) DEFAULT NULL,
  `create_lead` tinyint(1) DEFAULT 0,
  `filter_subject_type` enum('all','equals','contains') DEFAULT NULL,
  `filter_subject_value` varchar(100) DEFAULT NULL,
  `status` tinyint(1) DEFAULT 1,
  `last_sync_notes` text DEFAULT NULL,
  `last_sync_datetime` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `mail_templates`;
CREATE TABLE `mail_templates` (
  `hook` varchar(50) NOT NULL,
  `subject` varchar(100) NOT NULL,
  `variables` text NOT NULL,
  `message` text NOT NULL,
  `system_tpl` tinyint(1) NOT NULL DEFAULT 0,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `details` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`hook`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `mail_templates` (`hook`, `subject`, `variables`, `message`, `system_tpl`, `status`, `details`, `created_at`, `updated_at`) VALUES
('AGENT_COMMISSION_PAYOUT',	'Commission Payout',	'sitename,siteurl,email,mobile,first_name,full_name,currency,payout_amount',	'<p>Dear #full_name#,</p><p>A commission payout of #currency# #payout_amount# has been processed. You will soon receive the payment.</p><p>Thank You,</p><p>#sitename# Team</p>',	1,	1,	'This is sent to agents when process agent payout is done',	'2024-11-27 06:40:26',	NULL),
('AGENT_CREATE',	'Welcome!',	'sitename,siteurl,email,mobile,first_name,full_name,password',	'Dear <span>#full_name#<br></span><br>Welcome to #sitename#!<br><br>We are thrilled to extend a warm welcome to you as our esteemed sub-agent at #sitename#. Your decision to join forces with us is a testament to your commitment to providing excellent service in the field of education and study abroad consultancy.<br /><br />At #sitename#, we take pride in our mission to empower students to achieve their academic and career goals by facilitating seamless study abroad experiences. With your expertise and dedication, we are confident that together, we can make a significant impact on the lives of aspiring students.<br /><br />As a sub-agent, you play a crucial role in our network, acting as a bridge between prospective students and the plethora of opportunities available worldwide. Your insights, local knowledge, and personalized approach will undoubtedly contribute to the success of our collaborative efforts.<br /><br />Once again, Thank you for choosing to be a part of our team. Here is your portal login details:<br />URL: #siteurl#/agent-login<br>Email: #email#<br>Password: #password#',	1,	1,	'This is sent to Agent(Partner) when staff creates a agent(partner)',	'2021-12-31 13:00:00',	'2023-04-05 05:22:54'),
('AGENT_WELCOME',	'Welcome!',	'sitename,siteurl,email,mobile,first_name,full_name',	'Dear&nbsp;<span>#full_name#<br></span><br>Welcome to #sitename#, Thank you for registering as an agent of #sitename#.',	1,	1,	'This is sent to an Agent when approved by staff',	'2021-12-31 18:30:00',	NULL),
('BIRTHDAY_WISHES',	'Happy Birthday!',	'first_name',	'<p><img src=\"#siteurl#/assets/images/background/birthdayImage.jpg\"></p><p><span style=\"color:hsl(30, 75%, 60%);\"><strong>Many More Happy Returns Of The Day To Our Dearest #first_name#. May All Your Wishes Come True And Stay Blessed Forever! Happy Birthday!</strong></span></p>',	1,	1,	'This is sent to Student on Birthday',	'2021-12-31 13:00:00',	'2020-07-21 20:18:11'),
('COURSE_PREFERENCE_ADDED_BY_STAFF',	'New Course Preference Added',	'sitename,siteurl,first_name,full_name',	'Dear #first_name#,<br>A new course has been added to your course preferences.&nbsp;<br>Please Visit&nbsp;#siteurl#',	1,	1,	'This is sent to Student when staff adds a course to student course preferences',	'2022-01-01 00:00:00',	'2020-02-01 05:45:30'),
('COURSE_SUGGESTION',	'New Course Suggestion',	'sitename,siteurl,first_name,full_name',	'Dear #first_name#,<br>You have got new course suggestion.&nbsp;<br>Please Visit&nbsp;#siteurl#',	1,	1,	'This is sent to Student when staff sends a course suggestion',	'2021-12-31 13:00:00',	'2020-01-31 18:45:30'),
('LEAD_WELCOME',	'Welcome!',	'sitename,siteurl,email,mobile,first_name,full_name,password',	'Dear&nbsp;<span>#full_name#<br></span><br>Welcome to #sitename#, Thank you for your interest in our services.',	1,	0,	'This is sent to a Lead when the Lead is manually added by staff',	'2021-12-31 13:00:00',	'2020-12-05 19:26:25'),
('LEAD_WELCOME_WEB2LEAD',	'Welcome!',	'sitename,siteurl,email,mobile,first_name,full_name,password',	'Dear&nbsp;<span>#full_name#<br></span><br>Welcome to #sitename#, Thank you for your interest in our services.',	0,	0,	'This is sent to a lead when lead is generated through web to lead form',	NULL,	NULL),
('MONTHLY_REFERRALS_REPORT',	'Monthly Referrals Report',	'sitename,siteurl,email,mobile,first_name,full_name,month_year,referral_table,referral_count',	'<p>Dear #full_name#,</p><p>This is your monthly referrals report. You can view your referral statistics at any time by logging in to the portal &amp; visit My Account &gt; Referrals.</p><p>Total Students Referred: #referral_count#</p><p>Your Referrals for the Month of #month_year# :</p><p>&nbsp;</p><p>#referral_table#</p><p>Remember, you can refer students using your unique affiliate link: #affiliate_url#</p><p>Thank You,</p><p>#sitename# Team</p>',	1,	1,	'This is sent to referers on 1st day of every month',	'2024-11-27 06:40:26',	NULL),
('STUDENT_CREATE_WELCOME',	'Welcome!',	'sitename,siteurl,email,mobile,first_name,full_name,password',	'Dear&nbsp;<span>#full_name#<br></span><br>Welcome to #sitename#!<br><br>Your login details<br>URL: #siteurl#<br>Email: #email#<br>Password: #password#',	1,	1,	'This is sent to Student when staff creates a student',	'2021-12-31 13:00:00',	'2023-04-05 05:22:54'),
('STUDENT_PASSWORD',	'Welcome!',	'sitename,siteurl,email,mobile,first_name,full_name,password',	'Dear&nbsp;<span>#full_name#<br></span><br>Welcome to #sitename#!<br><br>Your login details<br>URL: #siteurl#<br>Email: #email#<br>Password: #password#',	1,	1,	'This email with auto-generated password is sent to student when a lead is converted to student',	'2023-04-27 13:00:00',	NULL),
('STUDENT_REFERRAL_PAYOUT',	'Referral Payout',	'sitename,siteurl,email,mobile,first_name,full_name,month_year',	'<p>Dear #first_name#,<br>Your referral commission for the month of #month_year# is processed. You will be paid soon.</p>',	1,	1,	'This is sent to referers when commission payout is generated by staff',	'2024-11-27 06:40:26',	NULL),
('STUDENT_WELCOME',	'Welcome!',	'sitename,siteurl,email,mobile,first_name,full_name',	'Dear&nbsp;<span>#full_name#<br></span><br>Welcome to #sitename#, Thank you for registering on our student portal.',	1,	1,	'This is sent to Student on signup or on email confirmation',	'2021-12-31 13:00:00',	'2020-12-05 19:26:25'),
('TICKET_REPLY',	'Ticket Reply',	'sitename,siteurl,first_name,full_name,ticket_id,reply_message,ticket_url',	'Dear #first_name#,<br>Ticket #ticket_id# has a new reply posted by support staff.<br><br>#reply_message#<br><br>View Ticket Details: <br>#ticket_url#',	1,	1,	'This is sent to Student when a staff replies to ticket raised by student',	'2021-12-31 13:00:00',	'2019-12-10 18:06:01'),
('UNIVERSITY_APPLICATION_UPDATE',	'Application Status Update',	'sitename,siteurl,first_name,full_name,application_name,details',	'Dear #first_name#,<br />Your Application #application_name# Status Updated. Details: #details#',	1,	0,	'This is sent to Student when his/her college application status is updated by staff',	'2021-12-31 13:00:00',	NULL);

DROP TABLE IF EXISTS `meeting_rooms`;
CREATE TABLE `meeting_rooms` (
  `room_name` varchar(50) NOT NULL,
  `zoom_id` varchar(300) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`room_name`),
  UNIQUE KEY `zoom_id` (`zoom_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `migrations`;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
(1,	'2014_10_12_000000_create_users_table',	1),
(2,	'2014_10_12_100000_create_password_resets_table',	1),
(3,	'2017_09_03_144628_create_permission_tables',	1),
(4,	'2017_09_11_174816_create_social_accounts_table',	1),
(5,	'2017_09_26_140332_create_cache_table',	1),
(6,	'2017_09_26_140528_create_sessions_table',	1),
(7,	'2017_09_26_140609_create_jobs_table',	1),
(8,	'2018_04_08_033256_create_password_histories_table',	1),
(9,	'2019_12_14_000001_create_personal_access_tokens_table',	2),
(10,	'2020_05_25_021239_create_announcements_table',	3),
(11,	'2020_07_06_215139_create_activity_log_table',	4),
(12,	'2021_04_05_153840_create_two_factor_authentications_table',	5),
(13,	'2022_11_09_133246_create_failed_jobs_table',	5),
(14,	'2022_12_08_191901_create_webhook_calls_table',	5),
(15,	'2022_12_09_120519_create_laravel_facebook_webhook_tables',	6),
(16,	'2019_08_19_000000_create_failed_jobs_table',	7),
(18,	'2024_06_03_175105_add_event_column_to_activity_log_table',	9),
(19,	'2024_06_03_175106_add_batch_uuid_column_to_activity_log_table',	9);

DROP TABLE IF EXISTS `model_has_permissions`;
CREATE TABLE `model_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_type_model_id_index` (`model_type`,`model_id`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `model_has_roles`;
CREATE TABLE `model_has_roles` (
  `role_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_type_model_id_index` (`model_type`,`model_id`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `model_has_roles` (`role_id`, `model_type`, `model_id`) VALUES
(1,	'App\\Models\\Auth\\User',	1),
(3,	'App\\Models\\Auth\\User',	3);

DROP TABLE IF EXISTS `notification_configs`;
CREATE TABLE `notification_configs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event` varchar(100) NOT NULL,
  `email_appl_assignee` tinyint(1) NOT NULL,
  `email_staff` tinyint(1) NOT NULL,
  `email_staff_manager` tinyint(1) NOT NULL,
  `email_superadmin` tinyint(1) NOT NULL,
  `email_agent` tinyint(1) NOT NULL,
  `app_appl_assignee` tinyint(1) NOT NULL DEFAULT 0,
  `app_staff` tinyint(1) NOT NULL DEFAULT 0,
  `app_staff_manager` tinyint(1) NOT NULL DEFAULT 0,
  `app_superadmin` tinyint(1) NOT NULL DEFAULT 0,
  `app_agent` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `notification_configs` (`id`, `event`, `email_appl_assignee`, `email_staff`, `email_staff_manager`, `email_superadmin`, `email_agent`, `app_appl_assignee`, `app_staff`, `app_staff_manager`, `app_superadmin`, `app_agent`, `created_at`, `updated_at`) VALUES
(1,	'LEAD_STATUS_CHANGE',	0,	0,	0,	0,	0,	0,	1,	1,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(2,	'LEAD_PROFILE_UPDATED_BY_STAFF',	0,	1,	1,	1,	0,	0,	0,	0,	0,	0,	NULL,	'2024-03-21 05:23:50'),
(3,	'STUDENT_PROFILE_UPDATED',	0,	0,	0,	0,	0,	0,	1,	1,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(4,	'COURSE_PREFERENCE_ADDED_BY_STUDENT',	0,	0,	0,	0,	0,	0,	1,	1,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(5,	'COURSE_PREFERENCE_ADDED_BY_STAFF',	0,	0,	0,	0,	0,	0,	1,	1,	1,	1,	NULL,	'2024-04-25 12:42:14'),
(6,	'COURSE_BOOKMARKED_BY_STUDENT',	0,	0,	0,	0,	0,	0,	1,	1,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(7,	'DOCUMENT_UPLOAD_BY_STUDENT',	0,	0,	0,	0,	0,	0,	1,	1,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(8,	'COURSE_SUGGESTED_IS_APPROVED_BY_STUDENT',	0,	0,	0,	0,	0,	0,	1,	1,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(9,	'UNIVERSITY_APPLICATION_STATUS_CHANGE',	0,	0,	0,	0,	0,	1,	1,	1,	1,	1,	NULL,	'2024-04-25 12:42:14'),
(10,	'UNIVERSITY_APPLICATION_MESSAGE_BY_STUDENT',	0,	0,	0,	0,	0,	1,	1,	1,	1,	1,	NULL,	'2024-04-25 12:42:14'),
(11,	'VISA_OTHER_APPLICATION_STATUS_CHANGE',	0,	0,	0,	0,	0,	1,	1,	1,	1,	1,	NULL,	'2024-04-25 12:42:14'),
(12,	'VISA_OTHER_APPLICATION_MESSAGE_BY_STUDENT',	0,	0,	0,	0,	0,	1,	1,	1,	1,	1,	NULL,	'2024-04-25 12:42:14'),
(13,	'SUPPORT_TICKET_ASSIGNED_TO_STAFF',	0,	0,	0,	0,	0,	0,	1,	1,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(14,	'SUPPORT_TICKET_REPLY_RECEIVED',	0,	0,	0,	0,	0,	0,	1,	1,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(15,	'SUPPORT_TICKET_STATUS_CHANGE',	0,	0,	0,	0,	0,	0,	1,	1,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(16,	'COURSE_SUGGESTED_BY_STAFF',	0,	0,	0,	0,	0,	0,	1,	1,	1,	1,	NULL,	'2024-04-25 12:42:14'),
(17,	'LEAD_STUDENT_CREATED',	0,	0,	1,	1,	0,	0,	0,	1,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(18,	'AGENT_SIGNUP',	0,	0,	1,	1,	0,	0,	0,	1,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(19,	'LEAD_STUDENT_ASSIGMENT_STAFF',	0,	0,	0,	0,	0,	0,	1,	1,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(20,	'LEAD_STUDENT_LINK_AGENT',	0,	0,	0,	0,	1,	0,	1,	1,	1,	1,	NULL,	'2024-04-25 12:42:14'),
(21,	'UNIVERSITY_APPLICATION_CREATED',	0,	0,	0,	0,	0,	0,	1,	1,	1,	1,	NULL,	'2024-04-25 12:42:14'),
(22,	'VISA_AND_SERVICES_APPLICATION_CREATED',	0,	0,	0,	0,	0,	0,	1,	1,	1,	1,	NULL,	'2024-04-25 12:42:14'),
(23,	'STUDENT_SUBMIT_APPLICATION',	0,	0,	0,	0,	0,	0,	1,	1,	1,	1,	NULL,	'2024-04-25 12:42:14'),
(24,	'AGENT_COMMISSION_ONLY',	0,	0,	0,	1,	0,	0,	0,	0,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(25,	'SUPPORT_TICKET_CREATION',	0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(26,	'STUDENT_ENROLL_WEBINAR',	0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(27,	'INVOICE_CREATE_AND_INVOICE_PAYMENT',	0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(28,	'STAFF_LEAVES_APPLY',	0,	0,	0,	1,	0,	0,	0,	0,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(29,	'STUDENT_SIGNUP',	0,	0,	1,	1,	0,	0,	0,	1,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(30,	'STUDENT_STATUS_CHANGE',	0,	0,	0,	0,	0,	0,	1,	1,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(31,	'LEAD_STUDENT_APPLICATION_COURSEPREFERENCE_OTHERS_DELETE',	0,	0,	0,	0,	0,	0,	1,	1,	1,	1,	NULL,	'2024-04-25 12:42:14'),
(34,	'INVOICE_DELETE',	0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(35,	'STUDENT_STATUS_CHANGE',	0,	0,	0,	0,	0,	0,	1,	1,	1,	0,	NULL,	'2024-04-25 12:42:14'),
(36,	'APPLICATION_ASSIGNED_STAFF',	0,	0,	0,	0,	0,	1,	1,	1,	1,	1,	NULL,	'2024-04-25 12:42:14'),
(37,	'APPLICATION_ASSIGNED_STAFF',	0,	0,	0,	0,	0,	1,	1,	1,	1,	1,	NULL,	'2024-04-25 12:42:14'),
(38,	'VISA_OTHER_APPLICATION_ASSIGNED_STAFF',	0,	0,	0,	0,	0,	1,	1,	1,	1,	1,	NULL,	'2024-04-25 12:42:14');

DROP TABLE IF EXISTS `online_course`;
CREATE TABLE `online_course` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `short_desc` varchar(500) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `type` enum('public','private') DEFAULT 'public',
  `price` decimal(13,2) NOT NULL DEFAULT 0.00,
  `offer_price` decimal(13,2) NOT NULL DEFAULT 0.00,
  `display_order` smallint(6) DEFAULT NULL,
  `image` varchar(150) DEFAULT NULL,
  `created_by` int(11) DEFAULT 0,
  `status` tinyint(1) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `online_course_chapters`;
CREATE TABLE `online_course_chapters` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `online_course_id` int(11) NOT NULL,
  `title` varchar(150) DEFAULT NULL,
  `file1` varchar(150) DEFAULT NULL,
  `file1_type` enum('video','doc','image','none') DEFAULT 'none',
  `file2` varchar(150) DEFAULT NULL,
  `file2_type` enum('video','doc','image','none') DEFAULT 'none',
  `file3` varchar(150) DEFAULT NULL,
  `file3_type` enum('video','doc','image','none') DEFAULT 'none',
  `summary` varchar(500) DEFAULT NULL,
  `duration` int(11) DEFAULT 0,
  `display_order` smallint(6) DEFAULT 0,
  `status` tinyint(1) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `online_course_id` (`online_course_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `online_course_chapters_quiz`;
CREATE TABLE `online_course_chapters_quiz` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `chapter_id` int(11) NOT NULL,
  `display_order` tinyint(4) DEFAULT NULL,
  `question` varchar(500) DEFAULT NULL,
  `question_file` varchar(100) DEFAULT NULL,
  `option1` varchar(100) DEFAULT NULL,
  `option2` varchar(100) DEFAULT NULL,
  `option3` varchar(100) DEFAULT NULL,
  `option4` varchar(100) DEFAULT NULL,
  `option5` varchar(100) DEFAULT NULL,
  `option6` varchar(100) DEFAULT NULL,
  `option7` varchar(100) DEFAULT NULL,
  `option8` varchar(100) DEFAULT NULL,
  `answers` varchar(100) DEFAULT NULL COMMENT 'possible values 1,2,3,4,5,6,7,8',
  `answer_type` enum('single','multiple') DEFAULT 'single',
  `status` tinyint(1) DEFAULT 1,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `chapter_id` (`chapter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `orders`;
CREATE TABLE `orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `create_date` datetime NOT NULL,
  `order_type` enum('physical','digital','coaching','online_course') NOT NULL DEFAULT 'digital',
  `payment_date` datetime DEFAULT NULL,
  `payment_type` varchar(30) DEFAULT NULL,
  `payment_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'NULL',
  `user_id` int(11) NOT NULL,
  `status` enum('pending','paid') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `total` double(8,2) DEFAULT NULL,
  `currency` varchar(3) NOT NULL,
  `total_base` decimal(16,2) NOT NULL DEFAULT 0.00,
  `shipping_config` int(11) NOT NULL DEFAULT 0,
  `shipping_to` varchar(45) DEFAULT NULL,
  `shipping_address` varchar(100) DEFAULT NULL,
  `shipping_zip` varchar(10) DEFAULT NULL,
  `shipping_country` varchar(45) DEFAULT NULL,
  `shipping_state` varchar(45) DEFAULT NULL,
  `shipping_city` varchar(150) DEFAULT NULL,
  `shipping_phone` varchar(15) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `order_items`;
CREATE TABLE `order_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `seller_id` int(11) DEFAULT NULL,
  `product_id` int(11) NOT NULL DEFAULT 0,
  `coaching_id` int(11) NOT NULL DEFAULT 0,
  `online_course_id` int(11) NOT NULL DEFAULT 0,
  `qty` int(11) NOT NULL DEFAULT 1,
  `price` decimal(16,2) NOT NULL,
  `price_base` decimal(16,2) NOT NULL,
  `shipping_cost` decimal(16,2) NOT NULL,
  `currency` varchar(3) NOT NULL,
  `details` longtext DEFAULT NULL,
  `status` enum('pending','active','cancelled','completed') NOT NULL COMMENT 'pending-payment pending, active-for subscriptions',
  `last_payment_date` datetime DEFAULT NULL COMMENT 'for subscriptions',
  `expires` date DEFAULT NULL COMMENT 'subscription expiry',
  `payment_id` int(11) NOT NULL DEFAULT 0 COMMENT 'for subscriptions',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `order_status`;
CREATE TABLE `order_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderid` int(11) NOT NULL,
  `p_id` int(11) DEFAULT NULL,
  `trans_date` datetime NOT NULL DEFAULT current_timestamp(),
  `type` enum('payment','delivery') NOT NULL,
  `status` varchar(45) NOT NULL,
  `notes` varchar(500) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `overseas_courses`;
CREATE TABLE `overseas_courses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `course_name` varchar(191) NOT NULL,
  `category` int(11) NOT NULL COMMENT 'sub category id',
  `university` int(11) NOT NULL,
  `study_level` varchar(191) NOT NULL,
  `campus` varchar(191) DEFAULT NULL,
  `duration` varchar(191) DEFAULT NULL,
  `intakes` varchar(191) DEFAULT NULL,
  `website_url` varchar(300) DEFAULT NULL,
  `entry_requirements` text DEFAULT NULL,
  `ielts_score` varchar(191) DEFAULT NULL,
  `ielts_no_band_less_than` varchar(191) DEFAULT NULL,
  `toefl_score` varchar(191) DEFAULT NULL,
  `toefl_no_band_less_than` varchar(191) DEFAULT NULL,
  `pte_score` varchar(191) DEFAULT NULL,
  `pte_no_band_less_than` varchar(191) DEFAULT NULL,
  `gre_score` varchar(191) DEFAULT NULL,
  `gmat_score` varchar(191) DEFAULT NULL,
  `application_deadline` varchar(191) DEFAULT NULL,
  `application_fee` varchar(191) DEFAULT NULL,
  `tuition_fee` varchar(191) DEFAULT NULL,
  `scholarship_available` varchar(191) DEFAULT NULL,
  `scholarship_detail` text DEFAULT NULL,
  `backlog_range` varchar(191) DEFAULT NULL,
  `remarks` text DEFAULT NULL,
  `esl_elp_detail` text DEFAULT NULL,
  `applicationmode` varchar(191) DEFAULT NULL,
  `detscore` varchar(191) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `overseas_course_categories`;
CREATE TABLE `overseas_course_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `overseas_course_subcategories`;
CREATE TABLE `overseas_course_subcategories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `category_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `overseas_status`;
CREATE TABLE `overseas_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `overseas_status_name` varchar(100) NOT NULL,
  `color` varchar(50) NOT NULL,
  `assign_on_create` tinyint(1) NOT NULL DEFAULT 0,
  `assign_on_course_pref` tinyint(1) NOT NULL DEFAULT 0,
  `assign_on_doc_upload` tinyint(1) NOT NULL DEFAULT 0,
  `assign_on_appl_create` tinyint(1) NOT NULL DEFAULT 0,
  `is_completed_success` tinyint(1) NOT NULL DEFAULT 0,
  `is_dropout` tinyint(1) NOT NULL DEFAULT 0,
  `display_order` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `overseas_status_name` (`overseas_status_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `overseas_status` (`id`, `overseas_status_name`, `color`, `assign_on_create`, `assign_on_course_pref`, `assign_on_doc_upload`, `assign_on_appl_create`, `is_completed_success`, `is_dropout`, `display_order`, `created_at`, `updated_at`) VALUES
(1,	'Pending',	'#f98d00',	1,	0,	0,	0,	0,	0,	1,	'2023-08-22 13:04:57',	NULL),
(2,	'Course Preference Added',	'#5c59d6',	0,	1,	0,	0,	0,	0,	2,	'2023-08-22 13:06:51',	NULL),
(3,	'Documents Uploaded',	'#9453fc',	0,	0,	1,	0,	0,	0,	3,	'2023-08-22 13:07:48',	NULL),
(4,	'Application Processing',	'#478446',	0,	0,	0,	1,	0,	0,	4,	'2023-08-22 13:09:14',	NULL),
(5,	'Admission Complete',	'#949696',	0,	0,	0,	0,	1,	0,	5,	'2023-08-22 13:12:13',	NULL),
(6,	'Rejected/Dropout',	'#c95c58',	0,	0,	0,	0,	0,	1,	6,	'2023-08-22 13:13:32',	NULL);

DROP TABLE IF EXISTS `password_histories`;
CREATE TABLE `password_histories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `password` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `password_histories_user_id_foreign` (`user_id`),
  CONSTRAINT `password_histories_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `password_resets`;
CREATE TABLE `password_resets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(191) NOT NULL,
  `token` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `payment_gateway_trans`;
CREATE TABLE `payment_gateway_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `gateway` enum('paypal','stripe','razorpay','bank') NOT NULL,
  `amount` int(11) NOT NULL DEFAULT 0,
  `currency` varchar(3) DEFAULT NULL,
  `status` enum('pending','paid','cancel') NOT NULL,
  `gateway_trans_id` varchar(100) DEFAULT NULL,
  `payer_email` varchar(100) DEFAULT NULL,
  `trans_detail` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `permissions`;
CREATE TABLE `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `guard_name` varchar(191) NOT NULL,
  `details` varchar(500) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `permissions` (`id`, `name`, `guard_name`, `details`, `status`, `created_at`, `updated_at`) VALUES
(1,	'view backend',	'web',	'This permission gives access to the Admin panel. All staff roles & agent role will need this permission.',	1,	'2019-02-22 00:14:29',	'2019-02-22 00:14:29'),
(2,	'support tickets',	'web',	'View support requests created by students, reply to tickets.',	1,	'2019-07-22 13:00:00',	'2019-07-22 13:00:00'),
(3,	'students',	'web',	'Create/manage students, student profile details, course preferences, documents, applications.',	1,	'2019-07-22 13:00:00',	'2019-07-22 13:00:00'),
(4,	'university applications',	'web',	'View/Create Student University applications, manage details, status.',	1,	'2019-07-23 00:00:00',	'2019-07-23 00:00:00'),
(5,	'training batches',	'web',	'Create/manage Training batches, add students to batch.',	0,	'2019-07-22 13:00:00',	'2019-07-22 13:00:00'),
(6,	'country info',	'web',	'Manage/upload study overseas country information documents.',	1,	'2019-07-22 13:00:00',	'2019-07-22 13:00:00'),
(7,	'view staff',	'web',	'View Staff members list, details.',	1,	'2019-07-22 13:00:00',	'2019-07-22 13:00:00'),
(9,	'leads',	'web',	'View Leads, add follow-ups, change lead status.',	1,	'2019-07-23 01:30:00',	'2019-07-23 01:30:00'),
(10,	'training classes',	'web',	'View/manage Training class attendance, reviews.',	0,	'2019-07-23 01:30:00',	'2019-07-23 01:30:00'),
(11,	'training exams',	'web',	'View Training batch exams, student scores.',	0,	'2019-07-23 01:30:00',	'2019-07-23 01:30:00'),
(12,	'broadcast',	'web',	'Send bulk email, sms, whatsapp message to leads, students, staff/agents.',	1,	'2019-07-23 01:30:00',	'2019-07-23 01:30:00'),
(13,	'cms-articles',	'web',	'Create/edit Portal home page & other page content, manage articles, main menu.',	1,	'2019-07-23 01:30:00',	'2019-07-23 01:30:00'),
(14,	'cms-events',	'web',	'Create/manage Webinars.',	1,	'2019-07-23 01:30:00',	'2019-07-23 01:30:00'),
(15,	'overseas education configs',	'web',	'Manage University Course Data, Course suggestions data, Country Information data.',	1,	'2019-07-23 01:30:00',	'2019-07-23 01:30:00'),
(16,	'trainings configs',	'web',	'Manage Training Courses, Online Courses, Course Q & A.',	0,	'2019-07-23 01:30:00',	'2019-07-23 01:30:00'),
(17,	'file uploads',	'web',	'Upload documents that can be shared to students.',	1,	'2019-07-23 01:30:00',	'2019-07-23 01:30:00'),
(18,	'mail templates',	'web',	'Manage Email, SMS Templates.',	1,	'2019-07-23 01:30:00',	'2019-07-23 01:30:00'),
(20,	'branch mgmt',	'web',	'Manage your business branch details.',	1,	'2019-07-23 01:30:00',	'2019-07-23 01:30:00'),
(22,	'roles mgmt',	'web',	'Manage staff roles. Create/Edit roles & assign permissions to roles.',	1,	'2019-07-23 01:30:00',	'2019-07-23 01:30:00'),
(23,	'edit-staff',	'web',	'Create/edit staff users.',	1,	'2019-07-23 01:30:00',	'2019-07-23 01:30:00'),
(24,	'delete-lead-student-application',	'web',	'Staff with this permission has Delete permission for Leads, Students, Applications.',	1,	'2019-07-23 01:30:00',	'2019-07-23 01:30:00'),
(25,	'settings',	'web',	'Staff with this permission can perform various settings available in Settings page.',	1,	'2019-07-23 01:30:00',	'2019-07-23 01:30:00'),
(26,	'invoice',	'web',	'Create invoices, record payments, manage invoices.',	1,	'2019-07-23 01:30:00',	'2019-07-23 01:30:00'),
(27,	'lead-assignment',	'web',	'Staff with this permission can assign a lead to another staff.',	1,	'2022-08-02 03:04:21',	NULL),
(28,	'ticket-assignment',	'web',	'Staff with this permission can assign a support ticket to another staff.',	1,	'2022-08-24 08:51:42',	NULL),
(29,	'import',	'web',	'Staff with this permission can import Leads, Student, Course data.',	1,	'2022-08-25 12:08:26',	NULL),
(30,	'export',	'web',	NULL,	0,	'2022-08-25 12:08:26',	NULL),
(31,	'analytics',	'web',	'View Analytics/reports data.',	1,	'2022-09-07 06:17:34',	NULL),
(32,	'agent management',	'web',	'Create/manage Agents(Partners).',	1,	'2022-09-29 01:31:10',	NULL),
(33,	'trainer management',	'web',	'Create/manage Trainers.',	0,	'2022-09-29 01:31:10',	NULL),
(34,	'student-assignment',	'web',	'Staff with this permission can assign a student to other staff member.',	1,	'2022-07-30 15:17:42',	NULL),
(35,	'commission',	'web',	'Manage Agent(Partner) commissions.',	1,	'2022-07-30 15:17:42',	NULL),
(36,	'counselling',	'web',	NULL,	0,	'2023-02-12 10:39:39',	NULL),
(37,	'view assigned data only',	'web',	'Staff with this permission can only view leads, students, applications assigned to him/her only.',	1,	'2023-02-12 10:39:39',	NULL),
(38,	'course finder',	'web',	'Search for university courses and suggest to students',	1,	'2023-08-10 06:49:50',	NULL),
(39,	'export lead, student data',	'web',	'Export data from leads and students list pages',	1,	'2023-07-06 05:04:01',	NULL),
(40,	'delete-visa-service-application',	'web',	'Delete a Visa/Other services application',	1,	'2024-11-27 06:40:26',	NULL),
(41,	'application apply through',	'web',	'Set the University applied through agency configuration',	1,	'2024-11-27 06:40:26',	NULL),
(42,	'automations',	'web',	'Create/manage automated email/whatsapp/sms workflow sequences, scheduled campaigns',	1,	'2024-11-27 06:40:26',	NULL),
(43,	'staff attendance',	'web',	'View Staff Attendance',	1,	NULL,	NULL),
(44,	'staff leaves',	'web',	'View Staff Leaves',	1,	NULL,	NULL),
(45,	'Approve Leaves',	'web',	'Approve/disapprove staff leaves',	1,	NULL,	NULL),
(46,	'edit-invoice',	'web',	'Edit Invoice',	1,	'2024-11-27 06:40:26',	NULL),
(47,	'application-assignment',	'web',	'Staff with this permission can assign a Application to another staff.',	1,	'2024-11-27 06:40:26',	NULL),
(48,	'student referral',	'web',	'Staff with this permission can manage referrals feature',	1,	NULL,	NULL),
(49,	'university invoice',	'web',	'Create university invoices, record payments, manage university invoices.',	1,	'2024-11-27 06:40:26',	NULL);

DROP TABLE IF EXISTS `personal_access_tokens`;
CREATE TABLE `personal_access_tokens` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(255) NOT NULL,
  `tokenable_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `token` varchar(64) NOT NULL,
  `abilities` text DEFAULT NULL,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `posts`;
CREATE TABLE `posts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) NOT NULL,
  `menu_title` varchar(100) DEFAULT NULL,
  `slug` varchar(191) NOT NULL,
  `intro` text DEFAULT NULL,
  `content` text DEFAULT NULL,
  `type` enum('content_page','module_page','blog') NOT NULL,
  `module_type` enum('home','coaching','courses','country','webinar_events','offers','demo_classes') DEFAULT NULL,
  `system_post` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'system posts cannot be deleted',
  `meta_title` varchar(191) DEFAULT NULL,
  `meta_keywords` text DEFAULT NULL,
  `meta_description` text DEFAULT NULL,
  `order` int(11) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `published_at` timestamp NULL DEFAULT NULL,
  `show_in_main_menu` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_by` varchar(150) NOT NULL,
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `posts` (`id`, `title`, `menu_title`, `slug`, `intro`, `content`, `type`, `module_type`, `system_post`, `meta_title`, `meta_keywords`, `meta_description`, `order`, `status`, `published_at`, `show_in_main_menu`, `created_at`, `created_by`, `updated_at`, `deleted_at`) VALUES
(1,	'The Premier Choice for Study Abroad Aspirants',	'Home',	'home',	'<p><img class=\"image_resized image-style-align-right\" style=\"width:77.59%;\" src=\"storage/images/cms/home_28372399pnglGbQKhhgxsYiTXZnsaWD.png\">We are thrilled to be a part of thousands of students who have achieved their dream of studying abroad.</p><p>We are a team of passionate individuals who understand the transformative power of education. We have seen firsthand the impact that international education can have on an individual\'s life, opening up new opportunities, broadening horizons, and shaping future success.</p><p>Our work is driven by empathy and understanding, as we strive to support students through every step of the application process. We know the challenges and uncertainties that come with pursuing education abroad, and we are committed to providing guidance and reassurance along the way.</p>',	NULL,	'module_page',	'home',	0,	NULL,	NULL,	'Welcome!',	1,	1,	'2022-01-16 01:41:00',	1,	'2022-01-15 20:11:48',	'Admin Admin',	'2024-08-30 06:38:51',	NULL),
(2,	'Countries',	'Countries',	'countries',	'<p>Vestibulum tempus, urna id rutrum eleifend, orci odio dignissim erat, eu facilisis massa mauris at lorem. Duis pellentesque eros enim, id condimentum diam dignissim ut. Aliquam vel dolor est. Donec feugiat urna nec elit elementum varius.</p>',	NULL,	'module_page',	'country',	0,	NULL,	NULL,	NULL,	3,	1,	'2022-03-12 01:41:00',	1,	'2022-03-12 01:41:40',	'Admin Admin',	'2022-03-28 11:47:55',	NULL);

DROP TABLE IF EXISTS `products`;
CREATE TABLE `products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `slug` varchar(191) NOT NULL,
  `type` enum('physical','digital') NOT NULL DEFAULT 'digital',
  `currency` varchar(3) NOT NULL,
  `price` decimal(16,2) NOT NULL COMMENT 'For subscription products, this is upfront fee',
  `offer_price` decimal(16,2) NOT NULL,
  `has_downloads` tinyint(1) NOT NULL DEFAULT 0,
  `short_desc` varchar(500) NOT NULL,
  `details` text DEFAULT NULL,
  `weight` varchar(100) DEFAULT NULL,
  `dimension` varchar(100) DEFAULT NULL,
  `color` varchar(100) DEFAULT NULL,
  `brand` varchar(100) DEFAULT NULL,
  `status` enum('pending_approval','disapproved','enabled','disabled') NOT NULL DEFAULT 'pending_approval',
  `stock` int(11) NOT NULL DEFAULT -1,
  `order` int(11) NOT NULL DEFAULT 9999,
  `meta_title` varchar(255) DEFAULT NULL,
  `meta_desc` varchar(255) NOT NULL,
  `seller` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `product_categories`;
CREATE TABLE `product_categories` (
  `product_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`product_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `product_images`;
CREATE TABLE `product_images` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `type` enum('image','video') NOT NULL,
  `filename` varchar(255) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `order` int(11) NOT NULL DEFAULT 99,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `q_a`;
CREATE TABLE `q_a` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `course_id` int(11) DEFAULT NULL COMMENT 'course table id',
  `chapter` int(11) NOT NULL,
  `chapter_notes` varchar(500) DEFAULT NULL,
  `category` enum('reading','writing','listening') DEFAULT 'reading',
  `question_model` enum('obj_essay','comprehension') NOT NULL DEFAULT 'obj_essay',
  `comprehension_id` int(11) DEFAULT NULL,
  `question_type` enum('objective','comprehension','essay') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'objective',
  `question` text DEFAULT NULL,
  `question_file` varchar(150) DEFAULT NULL,
  `question_file_type` enum('doc','image','audio','none') DEFAULT 'none',
  `option1` varchar(200) DEFAULT NULL,
  `option2` varchar(200) DEFAULT NULL,
  `option3` varchar(200) DEFAULT NULL,
  `option4` varchar(200) DEFAULT NULL,
  `option5` varchar(200) DEFAULT NULL,
  `option6` varchar(200) DEFAULT NULL,
  `option7` varchar(200) DEFAULT NULL,
  `option8` varchar(200) DEFAULT NULL,
  `answers` varchar(100) DEFAULT NULL,
  `answer_type` enum('single','multiple') DEFAULT 'single',
  `display_order` smallint(6) DEFAULT NULL,
  `status` tinyint(1) DEFAULT 1,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `course_id` (`course_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `q_a_comprehension_text`;
CREATE TABLE `q_a_comprehension_text` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `course_id` int(11) NOT NULL,
  `chapter` int(11) NOT NULL,
  `chapter_notes` varchar(500) DEFAULT NULL,
  `title` varchar(250) NOT NULL,
  `content` longtext NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `referral_commission`;
CREATE TABLE `referral_commission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `credit` decimal(13,2) NOT NULL DEFAULT 0.00,
  `debit` decimal(13,2) NOT NULL DEFAULT 0.00,
  `student_id` int(11) NOT NULL DEFAULT 0,
  `notes` varchar(500) DEFAULT NULL,
  `paid` tinyint(1) NOT NULL DEFAULT 0,
  `payout_month` varchar(7) DEFAULT NULL,
  `paid_at` datetime DEFAULT NULL,
  `payment_notes` varchar(500) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `reminders`;
CREATE TABLE `reminders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `activity` varchar(150) NOT NULL,
  `deadline` date NOT NULL,
  `entity` enum('university_application','service_application','user','agent') NOT NULL,
  `entity_id` int(11) NOT NULL,
  `done` tinyint(1) NOT NULL DEFAULT 0,
  `done_date` datetime DEFAULT NULL,
  `done_by` int(11) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `roles`;
CREATE TABLE `roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `managerial` int(1) DEFAULT 0,
  `guard_name` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `roles_name_index` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `roles` (`id`, `name`, `managerial`, `guard_name`, `created_at`, `updated_at`) VALUES
(1,	'administrator',	1,	'web',	'2019-02-22 05:44:29',	'2019-02-22 05:44:29'),
(3,	'user',	0,	'web',	'2019-02-22 05:44:29',	'2019-02-22 05:44:29'),
(8,	'trainer',	0,	'web',	'2020-03-23 11:36:27',	'2020-03-23 11:36:27'),
(9,	'agent',	0,	'web',	'2020-03-23 17:06:27',	'2020-03-23 17:06:27'),
(13,	'staff member',	0,	'web',	'2022-03-11 23:08:12',	'2022-03-11 23:08:12'),
(14,	'manager',	1,	'web',	'2022-03-11 23:09:13',	'2022-03-11 23:09:13');

DROP TABLE IF EXISTS `role_has_permissions`;
CREATE TABLE `role_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `role_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
(1,	1),
(1,	9),
(1,	13),
(1,	14),
(2,	13),
(2,	14),
(3,	13),
(3,	14),
(4,	13),
(4,	14),
(5,	13),
(5,	14),
(6,	13),
(6,	14),
(7,	13),
(7,	14),
(9,	13),
(9,	14),
(10,	13),
(10,	14),
(11,	13),
(11,	14),
(12,	13),
(12,	14),
(13,	13),
(13,	14),
(14,	13),
(14,	14),
(15,	14),
(16,	14),
(23,	14),
(24,	14),
(27,	14),
(28,	13),
(28,	14),
(29,	13),
(30,	14);

DROP TABLE IF EXISTS `services`;
CREATE TABLE `services` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service_name` varchar(50) NOT NULL,
  `visa_service` tinyint(1) NOT NULL,
  `country_field` tinyint(1) NOT NULL,
  `display_order` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `service_name` (`service_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `services` (`id`, `service_name`, `visa_service`, `country_field`, `display_order`, `created_at`, `updated_at`) VALUES
(1,	'Study Visa',	0,	1,	1,	'2024-11-27 06:40:25',	NULL);

DROP TABLE IF EXISTS `service_applications`;
CREATE TABLE `service_applications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appl_id` int(11) DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `service_id` int(11) NOT NULL DEFAULT 0 COMMENT '0 - Study Visa',
  `country` int(11) DEFAULT 0,
  `college_appl_id` int(11) NOT NULL DEFAULT 0 COMMENT 'For Study Visa only',
  `notes` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `status` varchar(100) NOT NULL,
  `assigned_to` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `service_application_messages`;
CREATE TABLE `service_application_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `application_id` int(11) NOT NULL,
  `reply_timestamp` datetime DEFAULT NULL,
  `message` text NOT NULL,
  `user_id` int(11) NOT NULL,
  `staff_name` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `staff_id` int(11) NOT NULL DEFAULT 0,
  `attachment_1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attachment_2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attachment_3` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attachment_4` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notified_staff` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `service_stages`;
CREATE TABLE `service_stages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `status_name` varchar(30) NOT NULL COMMENT 'name shown to the users',
  `service_id` int(11) NOT NULL,
  `default_stage` int(11) DEFAULT 0,
  `case_close_stage` int(11) DEFAULT 0 COMMENT 'case closed stage',
  `stage_order` int(11) NOT NULL COMMENT 'order, display order',
  `color` varchar(50) DEFAULT '#0D6EFD',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `service_stages` (`id`, `status_name`, `service_id`, `default_stage`, `case_close_stage`, `stage_order`, `color`, `created_at`, `updated_at`) VALUES
(1,	'New',	1,	1,	0,	1,	'#0AD7FE',	'2024-11-27 06:40:25',	NULL),
(2,	'Processing',	1,	0,	0,	2,	'#FCB802',	'2024-11-27 06:40:25',	NULL),
(3,	'Completed',	1,	0,	1,	3,	'#08B333',	'2024-11-27 06:40:25',	NULL);

DROP TABLE IF EXISTS `sessions`;
CREATE TABLE `sessions` (
  `session_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(191) NOT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `payload` text NOT NULL,
  `last_activity` int(11) NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `sessions_id_unique` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `shipping_configs`;
CREATE TABLE `shipping_configs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `seller_id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `zone_id` int(11) NOT NULL,
  `rate_type` enum('flat_rate','weight_based') NOT NULL,
  `flat_rate_value` decimal(13,2) NOT NULL,
  `currency` varchar(3) DEFAULT NULL,
  `has_free_shipping` tinyint(1) NOT NULL DEFAULT 0,
  `free_from` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `shipping_unique_idx` (`seller_id`,`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `sms_templates`;
CREATE TABLE `sms_templates` (
  `hook` varchar(50) NOT NULL,
  `message` varchar(320) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `variables` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `template_id` varchar(50) DEFAULT NULL,
  `system_tpl` tinyint(1) NOT NULL DEFAULT 0,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `details` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`hook`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `sms_templates` (`hook`, `message`, `variables`, `template_id`, `system_tpl`, `status`, `details`, `created_at`, `updated_at`) VALUES
('AGENT_CREATE',	'Dear #first_name#, Welcome to #sitename#! We are thrilled to extend a warm welcome to you as our esteemed sub-agent. Your portal login details:#siteurl#/agent-login Email:#email# Password:#password#',	'sitename,siteurl,first_name,full_name,password',	'',	1,	1,	'This is sent to Agent(partner) when staff creates a agent(partner)',	'2021-12-31 13:00:00',	NULL),
('AGENT_WELCOME',	'Dear #first_name#, Welcome to #sitename#!, Thank you for registering as an agent of #sitename#.',	'sitename,siteurl,first_name,full_name',	'',	1,	1,	'This is sent to an Agent when approved by staff',	'2021-12-31 18:30:00',	NULL),
('BIRTHDAY_WISHES',	'Many More Happy Returns Of The Day To Our Dearest #full_name#! May All Your Wishes Come True And Stay Blessed Forever! Happy Birthday!',	'sitename,siteurl,first_name,full_name',	'',	1,	1,	'This is sent to Student on Birthday',	'2021-12-31 13:00:00',	NULL),
('COUNSELLING_MEET_SCHEDULED',	'Dear #first_name#, A New counselling meeting is assigned to you.',	'sitename,siteurl,first_name,full_name',	'',	1,	0,	'This is sent to staff when a counselling meeting is scheduled for the staff',	'2021-12-31 18:30:00',	NULL),
('COURSE_PREFERENCE_ADDED_BY_STAFF',	'Dear #first_name#, A new course has been added to your Course Preferences. Login to check the details.',	'sitename,siteurl,first_name,full_name',	'',	1,	1,	'This is sent to Student when staff adds a course to student course preferences',	'2022-01-01 00:00:00',	NULL),
('COURSE_SUGGESTION',	'Dear #first_name#, You have got new Course Suggestions. Login to check the details.',	'sitename,siteurl,first_name,full_name',	'',	1,	1,	'This is sent to Student when staff sends a course suggestion',	'2021-12-31 13:00:00',	NULL),
('LEAD_WELCOME',	'Dear #first_name#, Welcome to #sitename#! #siteurl# Email: #email# Password: #password#',	'sitename,siteurl,first_name,full_name,password',	'',	1,	1,	'This is sent to a Lead when the Lead is manually added by staff',	'2021-12-31 13:00:00',	NULL),
('LEAD_WELCOME_WEB2LEAD',	'Dear #first_name#, Welcome to #sitename#! #siteurl# Email: #email# Password: #password#',	'sitename,siteurl,first_name,full_name,password',	'',	0,	0,	'This is sent to a lead when lead is generated through web to lead form',	NULL,	NULL),
('NOTIFICATION',	'Notification from #sitename#: #message#',	'sitename,message',	'',	1,	1,	'',	'2021-12-31 13:00:00',	NULL),
('STAFF_LEAD_ASSIGNED',	'Dear #first_name#, A new lead is assigned to you.',	'sitename,siteurl,first_name,full_name',	'',	1,	0,	'',	'2021-12-31 13:00:00',	NULL),
('STAFF_LEAD_FOLLOWUP',	'Dear #first_name#, Leads to follow-up:',	'sitename,siteurl,first_name,full_name',	'',	1,	0,	'',	'2021-12-31 13:00:00',	NULL),
('STUDENT_CREATE',	'Dear #first_name#, Welcome to #sitename#! #siteurl# Email: #email# Password: #password#',	'sitename,siteurl,first_name,full_name,email,password',	'',	1,	1,	'This is sent to Student when staff creates a student',	'2021-12-31 13:00:00',	NULL),
('STUDENT_PASSWORD',	'Dear #first_name#, Welcome to #sitename#! #siteurl# Email: #email# Password: #password#',	'sitename,siteurl,first_name,full_name,password',	'',	1,	1,	'This message with auto-generated password is sent to student when a lead is converted to student',	'2021-12-31 13:00:00',	NULL),
('STUDENT_WELCOME',	'Dear #first_name#, Welcome to #sitename#!',	'sitename,siteurl,first_name,full_name',	'',	1,	1,	'This is sent to Student on signup or on email confirmation',	'2021-12-31 13:00:00',	NULL),
('TICKET_REPLY',	'Dear #first_name#, Ticket #id# has a new reply posted by support staff.',	'sitename,siteurl,first_name,full_name,id',	'',	1,	0,	'This is sent to Student when a staff replies to ticket raised by student',	'2021-12-31 13:00:00',	NULL),
('UNIVERSITY_APPLICATION_UPDATE',	'Dear #first_name#, Application #application#, Status Update: #details#.',	'sitename,siteurl,first_name,full_name,application,details',	'',	1,	1,	'This is sent to Student when his/her college application status is updated by staff',	'2021-12-31 13:00:00',	NULL),
('WEBINAR_REMINDER',	'Dear #first_name#, This is a reminder for the upcoming webinar - #webinar#, at #time#.',	'sitename,siteurl,first_name,full_name,webinar,time',	'',	1,	1,	'This message is sent to student for an upcoming webinar for which he has registered for',	'2021-12-31 13:00:00',	NULL);

DROP TABLE IF EXISTS `social_accounts`;
CREATE TABLE `social_accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `provider` varchar(32) NOT NULL,
  `provider_id` varchar(191) NOT NULL,
  `token` text DEFAULT NULL,
  `avatar` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `social_accounts_user_id_foreign` (`user_id`),
  CONSTRAINT `social_accounts_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `sop`;
CREATE TABLE `sop` (
  `userid` int(11) NOT NULL,
  `date` date NOT NULL,
  `status` enum('requested','provided') NOT NULL DEFAULT 'requested',
  PRIMARY KEY (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `staff_attendance`;
CREATE TABLE `staff_attendance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `date` date DEFAULT NULL,
  `clock_in` datetime DEFAULT NULL,
  `clock_out` datetime DEFAULT NULL,
  `ip` varchar(50) DEFAULT NULL,
  `lat` varchar(50) DEFAULT NULL,
  `long` varchar(50) DEFAULT NULL,
  `location` varchar(100) DEFAULT NULL,
  `details` text DEFAULT NULL,
  `auto_clock_out` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `staff_branch`;
CREATE TABLE `staff_branch` (
  `staff_id` int(11) NOT NULL,
  `branch_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`staff_id`,`branch_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `staff_branch` (`staff_id`, `branch_id`, `created_at`, `updated_at`) VALUES
(1,	1,	'2023-02-17 10:15:18',	NULL);

DROP TABLE IF EXISTS `staff_details`;
CREATE TABLE `staff_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `staff_id` bigint(20) unsigned NOT NULL,
  `photo` varchar(255) DEFAULT NULL,
  `gender` enum('male','female') DEFAULT NULL,
  `marital_status` enum('single','married') DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `father_name` varchar(191) DEFAULT NULL,
  `mother_name` varchar(191) DEFAULT NULL,
  `blood_group` varchar(191) DEFAULT NULL,
  `aadhar_no` varchar(191) DEFAULT NULL,
  `pan_no` varchar(191) DEFAULT NULL,
  `address` varchar(191) DEFAULT NULL,
  `country` int(10) unsigned DEFAULT NULL,
  `state` int(10) unsigned DEFAULT NULL,
  `city` varchar(191) DEFAULT NULL,
  `postal_code` varchar(15) DEFAULT NULL,
  `emp_id` varchar(15) DEFAULT NULL,
  `designation` varchar(191) DEFAULT NULL,
  `department` varchar(191) DEFAULT NULL,
  `ctc` int(10) unsigned DEFAULT NULL,
  `emp_start_date` date DEFAULT NULL,
  `reporting_to` varchar(191) DEFAULT NULL,
  `bank_account_no` varchar(191) DEFAULT NULL,
  `bank_payee` varchar(191) DEFAULT NULL,
  `bank_ifsc` varchar(191) DEFAULT NULL,
  `bank_branch` varchar(191) DEFAULT NULL,
  `bank_bank_name` varchar(191) DEFAULT NULL,
  `doc_offer_letter` varchar(191) DEFAULT NULL,
  `doc_resume` varchar(191) DEFAULT NULL,
  `doc_contract_agreement` varchar(191) DEFAULT NULL,
  `doc_pan_card` varchar(191) DEFAULT NULL,
  `doc_aadhar_card` varchar(191) DEFAULT NULL,
  `email_integration` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `smtp_host` varchar(100) DEFAULT NULL,
  `smtp_port` int(11) DEFAULT NULL,
  `smtp_encryption` varchar(255) NOT NULL,
  `smtp_username` varchar(255) NOT NULL,
  `smtp_password` varchar(255) NOT NULL,
  `imap_host` varchar(100) DEFAULT NULL,
  `imap_port` int(11) DEFAULT NULL,
  `imap_encryption` varchar(255) DEFAULT 'ssl',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `staff_leaves`;
CREATE TABLE `staff_leaves` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `leave_date` date NOT NULL,
  `days` decimal(13,1) NOT NULL,
  `when` enum('full_day','first_half','second_half') NOT NULL,
  `reason` varchar(200) NOT NULL,
  `type` enum('EL','SL') NOT NULL DEFAULT 'EL',
  `approved` tinyint(1) NOT NULL DEFAULT 0,
  `request_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `states`;
CREATE TABLE `states` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `country_id` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `states` (`id`, `name`, `country_id`) VALUES
(1,	'Andaman and Nicobar Islands',	101),
(2,	'Andhra Pradesh',	101),
(3,	'Arunachal Pradesh',	101),
(4,	'Assam',	101),
(5,	'Bihar',	101),
(6,	'Chandigarh',	101),
(7,	'Chhattisgarh',	101),
(8,	'Dadra and Nagar Haveli',	101),
(9,	'Daman and Diu',	101),
(10,	'New Delhi',	101),
(11,	'Goa',	101),
(12,	'Gujarat',	101),
(13,	'Haryana',	101),
(14,	'Himachal Pradesh',	101),
(15,	'Jammu and Kashmir',	101),
(16,	'Jharkhand',	101),
(17,	'Karnataka',	101),
(19,	'Kerala',	101),
(20,	'Lakshadweep',	101),
(21,	'Madhya Pradesh',	101),
(22,	'Maharashtra',	101),
(23,	'Manipur',	101),
(24,	'Meghalaya',	101),
(25,	'Mizoram',	101),
(26,	'Nagaland',	101),
(29,	'Odisha',	101),
(31,	'Pondicherry',	101),
(32,	'Punjab',	101),
(33,	'Rajasthan',	101),
(34,	'Sikkim',	101),
(35,	'Tamil Nadu',	101),
(36,	'Telangana',	101),
(37,	'Tripura',	101),
(38,	'Uttar Pradesh',	101),
(39,	'Uttarakhand',	101),
(41,	'West Bengal',	101),
(42,	'Badakhshan',	1),
(43,	'Badgis',	1),
(44,	'Baglan',	1),
(45,	'Balkh',	1),
(46,	'Bamiyan',	1),
(47,	'Farah',	1),
(48,	'Faryab',	1),
(49,	'Gawr',	1),
(50,	'Gazni',	1),
(51,	'Herat',	1),
(52,	'Hilmand',	1),
(53,	'Jawzjan',	1),
(54,	'Kabul',	1),
(55,	'Kapisa',	1),
(56,	'Khawst',	1),
(57,	'Kunar',	1),
(58,	'Lagman',	1),
(59,	'Lawghar',	1),
(60,	'Nangarhar',	1),
(61,	'Nimruz',	1),
(62,	'Nuristan',	1),
(63,	'Paktika',	1),
(64,	'Paktiya',	1),
(65,	'Parwan',	1),
(66,	'Qandahar',	1),
(67,	'Qunduz',	1),
(68,	'Samangan',	1),
(69,	'Sar-e Pul',	1),
(70,	'Takhar',	1),
(71,	'Uruzgan',	1),
(72,	'Wardag',	1),
(73,	'Zabul',	1),
(74,	'Berat',	2),
(75,	'Bulqize',	2),
(76,	'Delvine',	2),
(77,	'Devoll',	2),
(78,	'Dibre',	2),
(79,	'Durres',	2),
(80,	'Elbasan',	2),
(81,	'Fier',	2),
(82,	'Gjirokaster',	2),
(83,	'Gramsh',	2),
(84,	'Has',	2),
(85,	'Kavaje',	2),
(86,	'Kolonje',	2),
(87,	'Korce',	2),
(88,	'Kruje',	2),
(89,	'Kucove',	2),
(90,	'Kukes',	2),
(91,	'Kurbin',	2),
(92,	'Lezhe',	2),
(93,	'Librazhd',	2),
(94,	'Lushnje',	2),
(95,	'Mallakaster',	2),
(96,	'Malsi e Madhe',	2),
(97,	'Mat',	2),
(98,	'Mirdite',	2),
(99,	'Peqin',	2),
(100,	'Permet',	2),
(101,	'Pogradec',	2),
(102,	'Puke',	2),
(103,	'Sarande',	2),
(104,	'Shkoder',	2),
(105,	'Skrapar',	2),
(106,	'Tepelene',	2),
(107,	'Tirane',	2),
(108,	'Tropoje',	2),
(109,	'Vlore',	2),
(110,	'\'Ayn Daflah',	3),
(111,	'\'Ayn Tamushanat',	3),
(112,	'Adrar',	3),
(113,	'Algiers',	3),
(114,	'Annabah',	3),
(115,	'Bashshar',	3),
(116,	'Batnah',	3),
(117,	'Bijayah',	3),
(118,	'Biskrah',	3),
(119,	'Blidah',	3),
(120,	'Buirah',	3),
(121,	'Bumardas',	3),
(122,	'Burj Bu Arririj',	3),
(123,	'Ghalizan',	3),
(124,	'Ghardayah',	3),
(125,	'Ilizi',	3),
(126,	'Jijili',	3),
(127,	'Jilfah',	3),
(128,	'Khanshalah',	3),
(129,	'Masilah',	3),
(130,	'Midyah',	3),
(131,	'Milah',	3),
(132,	'Muaskar',	3),
(133,	'Mustaghanam',	3),
(134,	'Naama',	3),
(135,	'Oran',	3),
(136,	'Ouargla',	3),
(137,	'Qalmah',	3),
(138,	'Qustantinah',	3),
(139,	'Sakikdah',	3),
(140,	'Satif',	3),
(141,	'Sayda\'',	3),
(142,	'Sidi ban-al-\'Abbas',	3),
(143,	'Suq Ahras',	3),
(144,	'Tamanghasat',	3),
(145,	'Tibazah',	3),
(146,	'Tibissah',	3),
(147,	'Tilimsan',	3),
(148,	'Tinduf',	3),
(149,	'Tisamsilt',	3),
(150,	'Tiyarat',	3),
(151,	'Tizi Wazu',	3),
(152,	'Umm-al-Bawaghi',	3),
(153,	'Wahran',	3),
(154,	'Warqla',	3),
(155,	'Wilaya d Alger',	3),
(156,	'Wilaya de Bejaia',	3),
(157,	'Wilaya de Constantine',	3),
(158,	'al-Aghwat',	3),
(159,	'al-Bayadh',	3),
(160,	'al-Jaza\'ir',	3),
(161,	'al-Wad',	3),
(162,	'ash-Shalif',	3),
(163,	'at-Tarif',	3),
(164,	'Eastern',	4),
(165,	'Manu\'a',	4),
(166,	'Swains Island',	4),
(167,	'Western',	4),
(168,	'Andorra la Vella',	5),
(169,	'Canillo',	5),
(170,	'Encamp',	5),
(171,	'La Massana',	5),
(172,	'Les Escaldes',	5),
(173,	'Ordino',	5),
(174,	'Sant Julia de Loria',	5),
(175,	'Bengo',	6),
(176,	'Benguela',	6),
(177,	'Bie',	6),
(178,	'Cabinda',	6),
(179,	'Cunene',	6),
(180,	'Huambo',	6),
(181,	'Huila',	6),
(182,	'Kuando-Kubango',	6),
(183,	'Kwanza Norte',	6),
(184,	'Kwanza Sul',	6),
(185,	'Luanda',	6),
(186,	'Lunda Norte',	6),
(187,	'Lunda Sul',	6),
(188,	'Malanje',	6),
(189,	'Moxico',	6),
(190,	'Namibe',	6),
(191,	'Uige',	6),
(192,	'Zaire',	6),
(193,	'Other Provinces',	7),
(194,	'Sector claimed by Argentina/Ch',	8),
(195,	'Sector claimed by Argentina/UK',	8),
(196,	'Sector claimed by Australia',	8),
(197,	'Sector claimed by France',	8),
(198,	'Sector claimed by New Zealand',	8),
(199,	'Sector claimed by Norway',	8),
(200,	'Unclaimed Sector',	8),
(201,	'Barbuda',	9),
(202,	'Saint George',	9),
(203,	'Saint John',	9),
(204,	'Saint Mary',	9),
(205,	'Saint Paul',	9),
(206,	'Saint Peter',	9),
(207,	'Saint Philip',	9),
(208,	'Buenos Aires',	10),
(209,	'Catamarca',	10),
(210,	'Chaco',	10),
(211,	'Chubut',	10),
(212,	'Cordoba',	10),
(213,	'Corrientes',	10),
(214,	'Distrito Federal',	10),
(215,	'Entre Rios',	10),
(216,	'Formosa',	10),
(217,	'Jujuy',	10),
(218,	'La Pampa',	10),
(219,	'La Rioja',	10),
(220,	'Mendoza',	10),
(221,	'Misiones',	10),
(222,	'Neuquen',	10),
(223,	'Rio Negro',	10),
(224,	'Salta',	10),
(225,	'San Juan',	10),
(226,	'San Luis',	10),
(227,	'Santa Cruz',	10),
(228,	'Santa Fe',	10),
(229,	'Santiago del Estero',	10),
(230,	'Tierra del Fuego',	10),
(231,	'Tucuman',	10),
(232,	'Aragatsotn',	11),
(233,	'Ararat',	11),
(234,	'Armavir',	11),
(235,	'Gegharkunik',	11),
(236,	'Kotaik',	11),
(237,	'Lori',	11),
(238,	'Shirak',	11),
(239,	'Stepanakert',	11),
(240,	'Syunik',	11),
(241,	'Tavush',	11),
(242,	'Vayots Dzor',	11),
(243,	'Yerevan',	11),
(244,	'Aruba',	12),
(245,	'Auckland',	13),
(246,	'Australian Capital Territory',	13),
(247,	'Balgowlah',	13),
(248,	'Balmain',	13),
(249,	'Bankstown',	13),
(250,	'Baulkham Hills',	13),
(251,	'Bonnet Bay',	13),
(252,	'Camberwell',	13),
(253,	'Carole Park',	13),
(254,	'Castle Hill',	13),
(255,	'Caulfield',	13),
(256,	'Chatswood',	13),
(257,	'Cheltenham',	13),
(258,	'Cherrybrook',	13),
(259,	'Clayton',	13),
(260,	'Collingwood',	13),
(261,	'Frenchs Forest',	13),
(262,	'Hawthorn',	13),
(263,	'Jannnali',	13),
(264,	'Knoxfield',	13),
(265,	'Melbourne',	13),
(266,	'New South Wales',	13),
(267,	'Northern Territory',	13),
(268,	'Perth',	13),
(269,	'Queensland',	13),
(270,	'South Australia',	13),
(271,	'Tasmania',	13),
(272,	'Templestowe',	13),
(273,	'Victoria',	13),
(274,	'Werribee south',	13),
(275,	'Western Australia',	13),
(276,	'Wheeler',	13),
(277,	'Bundesland Salzburg',	14),
(278,	'Bundesland Steiermark',	14),
(279,	'Bundesland Tirol',	14),
(280,	'Burgenland',	14),
(281,	'Carinthia',	14),
(282,	'Karnten',	14),
(283,	'Liezen',	14),
(284,	'Lower Austria',	14),
(285,	'Niederosterreich',	14),
(286,	'Oberosterreich',	14),
(287,	'Salzburg',	14),
(288,	'Schleswig-Holstein',	14),
(289,	'Steiermark',	14),
(290,	'Styria',	14),
(291,	'Tirol',	14),
(292,	'Upper Austria',	14),
(293,	'Vorarlberg',	14),
(294,	'Wien',	14),
(295,	'Abseron',	15),
(296,	'Baki Sahari',	15),
(297,	'Ganca',	15),
(298,	'Ganja',	15),
(299,	'Kalbacar',	15),
(300,	'Lankaran',	15),
(301,	'Mil-Qarabax',	15),
(302,	'Mugan-Salyan',	15),
(303,	'Nagorni-Qarabax',	15),
(304,	'Naxcivan',	15),
(305,	'Priaraks',	15),
(306,	'Qazax',	15),
(307,	'Saki',	15),
(308,	'Sirvan',	15),
(309,	'Xacmaz',	15),
(310,	'Abaco',	16),
(311,	'Acklins Island',	16),
(312,	'Andros',	16),
(313,	'Berry Islands',	16),
(314,	'Biminis',	16),
(315,	'Cat Island',	16),
(316,	'Crooked Island',	16),
(317,	'Eleuthera',	16),
(318,	'Exuma and Cays',	16),
(319,	'Grand Bahama',	16),
(320,	'Inagua Islands',	16),
(321,	'Long Island',	16),
(322,	'Mayaguana',	16),
(323,	'New Providence',	16),
(324,	'Ragged Island',	16),
(325,	'Rum Cay',	16),
(326,	'San Salvador',	16),
(327,	'\'Isa',	17),
(328,	'Badiyah',	17),
(329,	'Hidd',	17),
(330,	'Jidd Hafs',	17),
(331,	'Mahama',	17),
(332,	'Manama',	17),
(333,	'Sitrah',	17),
(334,	'al-Manamah',	17),
(335,	'al-Muharraq',	17),
(336,	'ar-Rifa\'a',	17),
(337,	'Bagar Hat',	18),
(338,	'Bandarban',	18),
(339,	'Barguna',	18),
(340,	'Barisal',	18),
(341,	'Bhola',	18),
(342,	'Bogora',	18),
(343,	'Brahman Bariya',	18),
(344,	'Chandpur',	18),
(345,	'Chattagam',	18),
(346,	'Chittagong Division',	18),
(347,	'Chuadanga',	18),
(348,	'Dhaka',	18),
(349,	'Dinajpur',	18),
(350,	'Faridpur',	18),
(351,	'Feni',	18),
(352,	'Gaybanda',	18),
(353,	'Gazipur',	18),
(354,	'Gopalganj',	18),
(355,	'Habiganj',	18),
(356,	'Jaipur Hat',	18),
(357,	'Jamalpur',	18),
(358,	'Jessor',	18),
(359,	'Jhalakati',	18),
(360,	'Jhanaydah',	18),
(361,	'Khagrachhari',	18),
(362,	'Khulna',	18),
(363,	'Kishorganj',	18),
(364,	'Koks Bazar',	18),
(365,	'Komilla',	18),
(366,	'Kurigram',	18),
(367,	'Kushtiya',	18),
(368,	'Lakshmipur',	18),
(369,	'Lalmanir Hat',	18),
(370,	'Madaripur',	18),
(371,	'Magura',	18),
(372,	'Maimansingh',	18),
(373,	'Manikganj',	18),
(374,	'Maulvi Bazar',	18),
(375,	'Meherpur',	18),
(376,	'Munshiganj',	18),
(377,	'Naral',	18),
(378,	'Narayanganj',	18),
(379,	'Narsingdi',	18),
(380,	'Nator',	18),
(381,	'Naugaon',	18),
(382,	'Nawabganj',	18),
(383,	'Netrakona',	18),
(384,	'Nilphamari',	18),
(385,	'Noakhali',	18),
(386,	'Pabna',	18),
(387,	'Panchagarh',	18),
(388,	'Patuakhali',	18),
(389,	'Pirojpur',	18),
(390,	'Rajbari',	18),
(391,	'Rajshahi',	18),
(392,	'Rangamati',	18),
(393,	'Rangpur',	18),
(394,	'Satkhira',	18),
(395,	'Shariatpur',	18),
(396,	'Sherpur',	18),
(397,	'Silhat',	18),
(398,	'Sirajganj',	18),
(399,	'Sunamganj',	18),
(400,	'Tangayal',	18),
(401,	'Thakurgaon',	18),
(402,	'Christ Church',	19),
(403,	'Saint Andrew',	19),
(404,	'Saint George',	19),
(405,	'Saint James',	19),
(406,	'Saint John',	19),
(407,	'Saint Joseph',	19),
(408,	'Saint Lucy',	19),
(409,	'Saint Michael',	19),
(410,	'Saint Peter',	19),
(411,	'Saint Philip',	19),
(412,	'Saint Thomas',	19),
(413,	'Brest',	20),
(414,	'Homjel\'',	20),
(415,	'Hrodna',	20),
(416,	'Mahiljow',	20),
(417,	'Mahilyowskaya Voblasts',	20),
(418,	'Minsk',	20),
(419,	'Minskaja Voblasts\'',	20),
(420,	'Petrik',	20),
(421,	'Vicebsk',	20),
(422,	'Antwerpen',	21),
(423,	'Berchem',	21),
(424,	'Brabant',	21),
(425,	'Brabant Wallon',	21),
(426,	'Brussel',	21),
(427,	'East Flanders',	21),
(428,	'Hainaut',	21),
(429,	'Liege',	21),
(430,	'Limburg',	21),
(431,	'Luxembourg',	21),
(432,	'Namur',	21),
(433,	'Ontario',	21),
(434,	'Oost-Vlaanderen',	21),
(435,	'Provincie Brabant',	21),
(436,	'Vlaams-Brabant',	21),
(437,	'Wallonne',	21),
(438,	'West-Vlaanderen',	21),
(439,	'Belize',	22),
(440,	'Cayo',	22),
(441,	'Corozal',	22),
(442,	'Orange Walk',	22),
(443,	'Stann Creek',	22),
(444,	'Toledo',	22),
(445,	'Alibori',	23),
(446,	'Atacora',	23),
(447,	'Atlantique',	23),
(448,	'Borgou',	23),
(449,	'Collines',	23),
(450,	'Couffo',	23),
(451,	'Donga',	23),
(452,	'Littoral',	23),
(453,	'Mono',	23),
(454,	'Oueme',	23),
(455,	'Plateau',	23),
(456,	'Zou',	23),
(457,	'Hamilton',	24),
(458,	'Saint George',	24),
(459,	'Bumthang',	25),
(460,	'Chhukha',	25),
(461,	'Chirang',	25),
(462,	'Daga',	25),
(463,	'Geylegphug',	25),
(464,	'Ha',	25),
(465,	'Lhuntshi',	25),
(466,	'Mongar',	25),
(467,	'Pemagatsel',	25),
(468,	'Punakha',	25),
(469,	'Rinpung',	25),
(470,	'Samchi',	25),
(471,	'Samdrup Jongkhar',	25),
(472,	'Shemgang',	25),
(473,	'Tashigang',	25),
(474,	'Timphu',	25),
(475,	'Tongsa',	25),
(476,	'Wangdiphodrang',	25),
(477,	'Beni',	26),
(478,	'Chuquisaca',	26),
(479,	'Cochabamba',	26),
(480,	'La Paz',	26),
(481,	'Oruro',	26),
(482,	'Pando',	26),
(483,	'Potosi',	26),
(484,	'Santa Cruz',	26),
(485,	'Tarija',	26),
(486,	'Federacija Bosna i Hercegovina',	27),
(487,	'Republika Srpska',	27),
(488,	'Central Bobonong',	28),
(489,	'Central Boteti',	28),
(490,	'Central Mahalapye',	28),
(491,	'Central Serowe-Palapye',	28),
(492,	'Central Tutume',	28),
(493,	'Chobe',	28),
(494,	'Francistown',	28),
(495,	'Gaborone',	28),
(496,	'Ghanzi',	28),
(497,	'Jwaneng',	28),
(498,	'Kgalagadi North',	28),
(499,	'Kgalagadi South',	28),
(500,	'Kgatleng',	28),
(501,	'Kweneng',	28),
(502,	'Lobatse',	28),
(503,	'Ngamiland',	28),
(504,	'Ngwaketse',	28),
(505,	'North East',	28),
(506,	'Okavango',	28),
(507,	'Orapa',	28),
(508,	'Selibe Phikwe',	28),
(509,	'South East',	28),
(510,	'Sowa',	28),
(511,	'Bouvet Island',	29),
(512,	'Acre',	30),
(513,	'Alagoas',	30),
(514,	'Amapa',	30),
(515,	'Amazonas',	30),
(516,	'Bahia',	30),
(517,	'Ceara',	30),
(518,	'Distrito Federal',	30),
(519,	'Espirito Santo',	30),
(520,	'Estado de Sao Paulo',	30),
(521,	'Goias',	30),
(522,	'Maranhao',	30),
(523,	'Mato Grosso',	30),
(524,	'Mato Grosso do Sul',	30),
(525,	'Minas Gerais',	30),
(526,	'Para',	30),
(527,	'Paraiba',	30),
(528,	'Parana',	30),
(529,	'Pernambuco',	30),
(530,	'Piaui',	30),
(531,	'Rio Grande do Norte',	30),
(532,	'Rio Grande do Sul',	30),
(533,	'Rio de Janeiro',	30),
(534,	'Rondonia',	30),
(535,	'Roraima',	30),
(536,	'Santa Catarina',	30),
(537,	'Sao Paulo',	30),
(538,	'Sergipe',	30),
(539,	'Tocantins',	30),
(540,	'British Indian Ocean Territory',	31),
(541,	'Belait',	32),
(542,	'Brunei-Muara',	32),
(543,	'Temburong',	32),
(544,	'Tutong',	32),
(545,	'Blagoevgrad',	33),
(546,	'Burgas',	33),
(547,	'Dobrich',	33),
(548,	'Gabrovo',	33),
(549,	'Haskovo',	33),
(550,	'Jambol',	33),
(551,	'Kardzhali',	33),
(552,	'Kjustendil',	33),
(553,	'Lovech',	33),
(554,	'Montana',	33),
(555,	'Oblast Sofiya-Grad',	33),
(556,	'Pazardzhik',	33),
(557,	'Pernik',	33),
(558,	'Pleven',	33),
(559,	'Plovdiv',	33),
(560,	'Razgrad',	33),
(561,	'Ruse',	33),
(562,	'Shumen',	33),
(563,	'Silistra',	33),
(564,	'Sliven',	33),
(565,	'Smoljan',	33),
(566,	'Sofija grad',	33),
(567,	'Sofijska oblast',	33),
(568,	'Stara Zagora',	33),
(569,	'Targovishte',	33),
(570,	'Varna',	33),
(571,	'Veliko Tarnovo',	33),
(572,	'Vidin',	33),
(573,	'Vraca',	33),
(574,	'Yablaniza',	33),
(575,	'Bale',	34),
(576,	'Bam',	34),
(577,	'Bazega',	34),
(578,	'Bougouriba',	34),
(579,	'Boulgou',	34),
(580,	'Boulkiemde',	34),
(581,	'Comoe',	34),
(582,	'Ganzourgou',	34),
(583,	'Gnagna',	34),
(584,	'Gourma',	34),
(585,	'Houet',	34),
(586,	'Ioba',	34),
(587,	'Kadiogo',	34),
(588,	'Kenedougou',	34),
(589,	'Komandjari',	34),
(590,	'Kompienga',	34),
(591,	'Kossi',	34),
(592,	'Kouritenga',	34),
(593,	'Kourweogo',	34),
(594,	'Leraba',	34),
(595,	'Mouhoun',	34),
(596,	'Nahouri',	34),
(597,	'Namentenga',	34),
(598,	'Noumbiel',	34),
(599,	'Oubritenga',	34),
(600,	'Oudalan',	34),
(601,	'Passore',	34),
(602,	'Poni',	34),
(603,	'Sanguie',	34),
(604,	'Sanmatenga',	34),
(605,	'Seno',	34),
(606,	'Sissili',	34),
(607,	'Soum',	34),
(608,	'Sourou',	34),
(609,	'Tapoa',	34),
(610,	'Tuy',	34),
(611,	'Yatenga',	34),
(612,	'Zondoma',	34),
(613,	'Zoundweogo',	34),
(614,	'Bubanza',	35),
(615,	'Bujumbura',	35),
(616,	'Bururi',	35),
(617,	'Cankuzo',	35),
(618,	'Cibitoke',	35),
(619,	'Gitega',	35),
(620,	'Karuzi',	35),
(621,	'Kayanza',	35),
(622,	'Kirundo',	35),
(623,	'Makamba',	35),
(624,	'Muramvya',	35),
(625,	'Muyinga',	35),
(626,	'Ngozi',	35),
(627,	'Rutana',	35),
(628,	'Ruyigi',	35),
(629,	'Banteay Mean Chey',	36),
(630,	'Bat Dambang',	36),
(631,	'Kampong Cham',	36),
(632,	'Kampong Chhnang',	36),
(633,	'Kampong Spoeu',	36),
(634,	'Kampong Thum',	36),
(635,	'Kampot',	36),
(636,	'Kandal',	36),
(637,	'Kaoh Kong',	36),
(638,	'Kracheh',	36),
(639,	'Krong Kaeb',	36),
(640,	'Krong Pailin',	36),
(641,	'Krong Preah Sihanouk',	36),
(642,	'Mondol Kiri',	36),
(643,	'Otdar Mean Chey',	36),
(644,	'Phnum Penh',	36),
(645,	'Pousat',	36),
(646,	'Preah Vihear',	36),
(647,	'Prey Veaeng',	36),
(648,	'Rotanak Kiri',	36),
(649,	'Siem Reab',	36),
(650,	'Stueng Traeng',	36),
(651,	'Svay Rieng',	36),
(652,	'Takaev',	36),
(653,	'Adamaoua',	37),
(654,	'Centre',	37),
(655,	'Est',	37),
(656,	'Littoral',	37),
(657,	'Nord',	37),
(658,	'Nord Extreme',	37),
(659,	'Nordouest',	37),
(660,	'Ouest',	37),
(661,	'Sud',	37),
(662,	'Sudouest',	37),
(663,	'Alberta',	38),
(664,	'British Columbia',	38),
(665,	'Manitoba',	38),
(666,	'New Brunswick',	38),
(667,	'Newfoundland and Labrador',	38),
(668,	'Northwest Territories',	38),
(669,	'Nova Scotia',	38),
(670,	'Nunavut',	38),
(671,	'Ontario',	38),
(672,	'Prince Edward Island',	38),
(673,	'Quebec',	38),
(674,	'Saskatchewan',	38),
(675,	'Yukon',	38),
(676,	'Boavista',	39),
(677,	'Brava',	39),
(678,	'Fogo',	39),
(679,	'Maio',	39),
(680,	'Sal',	39),
(681,	'Santo Antao',	39),
(682,	'Sao Nicolau',	39),
(683,	'Sao Tiago',	39),
(684,	'Sao Vicente',	39),
(685,	'Grand Cayman',	40),
(686,	'Bamingui-Bangoran',	41),
(687,	'Bangui',	41),
(688,	'Basse-Kotto',	41),
(689,	'Haut-Mbomou',	41),
(690,	'Haute-Kotto',	41),
(691,	'Kemo',	41),
(692,	'Lobaye',	41),
(693,	'Mambere-Kadei',	41),
(694,	'Mbomou',	41),
(695,	'Nana-Gribizi',	41),
(696,	'Nana-Mambere',	41),
(697,	'Ombella Mpoko',	41),
(698,	'Ouaka',	41),
(699,	'Ouham',	41),
(700,	'Ouham-Pende',	41),
(701,	'Sangha-Mbaere',	41),
(702,	'Vakaga',	41),
(703,	'Batha',	42),
(704,	'Biltine',	42),
(705,	'Bourkou-Ennedi-Tibesti',	42),
(706,	'Chari-Baguirmi',	42),
(707,	'Guera',	42),
(708,	'Kanem',	42),
(709,	'Lac',	42),
(710,	'Logone Occidental',	42),
(711,	'Logone Oriental',	42),
(712,	'Mayo-Kebbi',	42),
(713,	'Moyen-Chari',	42),
(714,	'Ouaddai',	42),
(715,	'Salamat',	42),
(716,	'Tandjile',	42),
(717,	'Aisen',	43),
(718,	'Antofagasta',	43),
(719,	'Araucania',	43),
(720,	'Atacama',	43),
(721,	'Bio Bio',	43),
(722,	'Coquimbo',	43),
(723,	'Libertador General Bernardo O\'',	43),
(724,	'Los Lagos',	43),
(725,	'Magellanes',	43),
(726,	'Maule',	43),
(727,	'Metropolitana',	43),
(728,	'Metropolitana de Santiago',	43),
(729,	'Tarapaca',	43),
(730,	'Valparaiso',	43),
(731,	'Anhui',	44),
(734,	'Aomen',	44),
(735,	'Beijing',	44),
(736,	'Beijing Shi',	44),
(737,	'Chongqing',	44),
(738,	'Fujian',	44),
(740,	'Gansu',	44),
(741,	'Guangdong',	44),
(743,	'Guangxi',	44),
(744,	'Guizhou',	44),
(745,	'Hainan',	44),
(746,	'Hebei',	44),
(747,	'Heilongjiang',	44),
(748,	'Henan',	44),
(749,	'Hubei',	44),
(750,	'Hunan',	44),
(751,	'Jiangsu',	44),
(753,	'Jiangxi',	44),
(754,	'Jilin',	44),
(755,	'Liaoning',	44),
(757,	'Nei Monggol',	44),
(758,	'Ningxia Hui',	44),
(759,	'Qinghai',	44),
(760,	'Shaanxi',	44),
(761,	'Shandong',	44),
(763,	'Shanghai',	44),
(764,	'Shanxi',	44),
(765,	'Sichuan',	44),
(766,	'Tianjin',	44),
(767,	'Xianggang',	44),
(768,	'Xinjiang',	44),
(769,	'Xizang',	44),
(770,	'Yunnan',	44),
(771,	'Zhejiang',	44),
(773,	'Christmas Island',	45),
(774,	'Cocos (Keeling) Islands',	46),
(775,	'Amazonas',	47),
(776,	'Antioquia',	47),
(777,	'Arauca',	47),
(778,	'Atlantico',	47),
(779,	'Bogota',	47),
(780,	'Bolivar',	47),
(781,	'Boyaca',	47),
(782,	'Caldas',	47),
(783,	'Caqueta',	47),
(784,	'Casanare',	47),
(785,	'Cauca',	47),
(786,	'Cesar',	47),
(787,	'Choco',	47),
(788,	'Cordoba',	47),
(789,	'Cundinamarca',	47),
(790,	'Guainia',	47),
(791,	'Guaviare',	47),
(792,	'Huila',	47),
(793,	'La Guajira',	47),
(794,	'Magdalena',	47),
(795,	'Meta',	47),
(796,	'Narino',	47),
(797,	'Norte de Santander',	47),
(798,	'Putumayo',	47),
(799,	'Quindio',	47),
(800,	'Risaralda',	47),
(801,	'San Andres y Providencia',	47),
(802,	'Santander',	47),
(803,	'Sucre',	47),
(804,	'Tolima',	47),
(805,	'Valle del Cauca',	47),
(806,	'Vaupes',	47),
(807,	'Vichada',	47),
(808,	'Mwali',	48),
(809,	'Njazidja',	48),
(810,	'Nzwani',	48),
(811,	'Bouenza',	49),
(812,	'Brazzaville',	49),
(813,	'Cuvette',	49),
(814,	'Kouilou',	49),
(815,	'Lekoumou',	49),
(816,	'Likouala',	49),
(817,	'Niari',	49),
(818,	'Plateaux',	49),
(819,	'Pool',	49),
(820,	'Sangha',	49),
(821,	'Bandundu',	50),
(822,	'Bas-Congo',	50),
(823,	'Equateur',	50),
(824,	'Haut-Congo',	50),
(825,	'Kasai-Occidental',	50),
(826,	'Kasai-Oriental',	50),
(827,	'Katanga',	50),
(828,	'Kinshasa',	50),
(829,	'Maniema',	50),
(830,	'Nord-Kivu',	50),
(831,	'Sud-Kivu',	50),
(832,	'Aitutaki',	51),
(833,	'Atiu',	51),
(834,	'Mangaia',	51),
(835,	'Manihiki',	51),
(836,	'Mauke',	51),
(837,	'Mitiaro',	51),
(838,	'Nassau',	51),
(839,	'Pukapuka',	51),
(840,	'Rakahanga',	51),
(841,	'Rarotonga',	51),
(842,	'Tongareva',	51),
(843,	'Alajuela',	52),
(844,	'Cartago',	52),
(845,	'Guanacaste',	52),
(846,	'Heredia',	52),
(847,	'Limon',	52),
(848,	'Puntarenas',	52),
(849,	'San Jose',	52),
(850,	'Abidjan',	53),
(851,	'Agneby',	53),
(852,	'Bafing',	53),
(853,	'Denguele',	53),
(854,	'Dix-huit Montagnes',	53),
(855,	'Fromager',	53),
(856,	'Haut-Sassandra',	53),
(857,	'Lacs',	53),
(858,	'Lagunes',	53),
(859,	'Marahoue',	53),
(860,	'Moyen-Cavally',	53),
(861,	'Moyen-Comoe',	53),
(862,	'N\'zi-Comoe',	53),
(863,	'Sassandra',	53),
(864,	'Savanes',	53),
(865,	'Sud-Bandama',	53),
(866,	'Sud-Comoe',	53),
(867,	'Vallee du Bandama',	53),
(868,	'Worodougou',	53),
(869,	'Zanzan',	53),
(870,	'Bjelovar-Bilogora',	54),
(871,	'Dubrovnik-Neretva',	54),
(872,	'Grad Zagreb',	54),
(873,	'Istra',	54),
(874,	'Karlovac',	54),
(875,	'Koprivnica-Krizhevci',	54),
(876,	'Krapina-Zagorje',	54),
(877,	'Lika-Senj',	54),
(878,	'Medhimurje',	54),
(879,	'Medimurska Zupanija',	54),
(880,	'Osijek-Baranja',	54),
(881,	'Osjecko-Baranjska Zupanija',	54),
(882,	'Pozhega-Slavonija',	54),
(883,	'Primorje-Gorski Kotar',	54),
(884,	'Shibenik-Knin',	54),
(885,	'Sisak-Moslavina',	54),
(886,	'Slavonski Brod-Posavina',	54),
(887,	'Split-Dalmacija',	54),
(888,	'Varazhdin',	54),
(889,	'Virovitica-Podravina',	54),
(890,	'Vukovar-Srijem',	54),
(891,	'Zadar',	54),
(892,	'Zagreb',	54),
(893,	'Camaguey',	55),
(894,	'Ciego de Avila',	55),
(895,	'Cienfuegos',	55),
(896,	'Ciudad de la Habana',	55),
(897,	'Granma',	55),
(898,	'Guantanamo',	55),
(899,	'Habana',	55),
(900,	'Holguin',	55),
(901,	'Isla de la Juventud',	55),
(902,	'La Habana',	55),
(903,	'Las Tunas',	55),
(904,	'Matanzas',	55),
(905,	'Pinar del Rio',	55),
(906,	'Sancti Spiritus',	55),
(907,	'Santiago de Cuba',	55),
(908,	'Villa Clara',	55),
(909,	'Government controlled area',	56),
(910,	'Limassol',	56),
(911,	'Nicosia District',	56),
(912,	'Paphos',	56),
(913,	'Turkish controlled area',	56),
(914,	'Central Bohemian',	57),
(915,	'Frycovice',	57),
(916,	'Jihocesky Kraj',	57),
(917,	'Jihochesky',	57),
(918,	'Jihomoravsky',	57),
(919,	'Karlovarsky',	57),
(920,	'Klecany',	57),
(921,	'Kralovehradecky',	57),
(922,	'Liberecky',	57),
(923,	'Lipov',	57),
(924,	'Moravskoslezsky',	57),
(925,	'Olomoucky',	57),
(926,	'Olomoucky Kraj',	57),
(927,	'Pardubicky',	57),
(928,	'Plzensky',	57),
(929,	'Praha',	57),
(930,	'Rajhrad',	57),
(931,	'Smirice',	57),
(932,	'South Moravian',	57),
(933,	'Straz nad Nisou',	57),
(934,	'Stredochesky',	57),
(935,	'Unicov',	57),
(936,	'Ustecky',	57),
(937,	'Valletta',	57),
(938,	'Velesin',	57),
(939,	'Vysochina',	57),
(940,	'Zlinsky',	57),
(941,	'Arhus',	58),
(942,	'Bornholm',	58),
(943,	'Frederiksborg',	58),
(944,	'Fyn',	58),
(945,	'Hovedstaden',	58),
(946,	'Kobenhavn',	58),
(947,	'Kobenhavns Amt',	58),
(948,	'Kobenhavns Kommune',	58),
(949,	'Nordjylland',	58),
(950,	'Ribe',	58),
(951,	'Ringkobing',	58),
(952,	'Roervig',	58),
(953,	'Roskilde',	58),
(954,	'Roslev',	58),
(955,	'Sjaelland',	58),
(956,	'Soeborg',	58),
(957,	'Sonderjylland',	58),
(958,	'Storstrom',	58),
(959,	'Syddanmark',	58),
(960,	'Toelloese',	58),
(961,	'Vejle',	58),
(962,	'Vestsjalland',	58),
(963,	'Viborg',	58),
(964,	'\'Ali Sabih',	59),
(965,	'Dikhil',	59),
(966,	'Jibuti',	59),
(967,	'Tajurah',	59),
(968,	'Ubuk',	59),
(969,	'Saint Andrew',	60),
(970,	'Saint David',	60),
(971,	'Saint George',	60),
(972,	'Saint John',	60),
(973,	'Saint Joseph',	60),
(974,	'Saint Luke',	60),
(975,	'Saint Mark',	60),
(976,	'Saint Patrick',	60),
(977,	'Saint Paul',	60),
(978,	'Saint Peter',	60),
(979,	'Azua',	61),
(980,	'Bahoruco',	61),
(981,	'Barahona',	61),
(982,	'Dajabon',	61),
(983,	'Distrito Nacional',	61),
(984,	'Duarte',	61),
(985,	'El Seybo',	61),
(986,	'Elias Pina',	61),
(987,	'Espaillat',	61),
(988,	'Hato Mayor',	61),
(989,	'Independencia',	61),
(990,	'La Altagracia',	61),
(991,	'La Romana',	61),
(992,	'La Vega',	61),
(993,	'Maria Trinidad Sanchez',	61),
(994,	'Monsenor Nouel',	61),
(995,	'Monte Cristi',	61),
(996,	'Monte Plata',	61),
(997,	'Pedernales',	61),
(998,	'Peravia',	61),
(999,	'Puerto Plata',	61),
(1000,	'Salcedo',	61),
(1001,	'Samana',	61),
(1002,	'San Cristobal',	61),
(1003,	'San Juan',	61),
(1004,	'San Pedro de Macoris',	61),
(1005,	'Sanchez Ramirez',	61),
(1006,	'Santiago',	61),
(1007,	'Santiago Rodriguez',	61),
(1008,	'Valverde',	61),
(1009,	'Aileu',	62),
(1010,	'Ainaro',	62),
(1011,	'Ambeno',	62),
(1012,	'Baucau',	62),
(1013,	'Bobonaro',	62),
(1014,	'Cova Lima',	62),
(1015,	'Dili',	62),
(1016,	'Ermera',	62),
(1017,	'Lautem',	62),
(1018,	'Liquica',	62),
(1019,	'Manatuto',	62),
(1020,	'Manufahi',	62),
(1021,	'Viqueque',	62),
(1022,	'Azuay',	63),
(1023,	'Bolivar',	63),
(1024,	'Canar',	63),
(1025,	'Carchi',	63),
(1026,	'Chimborazo',	63),
(1027,	'Cotopaxi',	63),
(1028,	'El Oro',	63),
(1029,	'Esmeraldas',	63),
(1030,	'Galapagos',	63),
(1031,	'Guayas',	63),
(1032,	'Imbabura',	63),
(1033,	'Loja',	63),
(1034,	'Los Rios',	63),
(1035,	'Manabi',	63),
(1036,	'Morona Santiago',	63),
(1037,	'Napo',	63),
(1038,	'Orellana',	63),
(1039,	'Pastaza',	63),
(1040,	'Pichincha',	63),
(1041,	'Sucumbios',	63),
(1042,	'Tungurahua',	63),
(1043,	'Zamora Chinchipe',	63),
(1044,	'Aswan',	64),
(1045,	'Asyut',	64),
(1046,	'Bani Suwayf',	64),
(1047,	'Bur Sa\'id',	64),
(1048,	'Cairo',	64),
(1049,	'Dumyat',	64),
(1050,	'Kafr-ash-Shaykh',	64),
(1051,	'Matruh',	64),
(1052,	'Muhafazat ad Daqahliyah',	64),
(1053,	'Muhafazat al Fayyum',	64),
(1054,	'Muhafazat al Gharbiyah',	64),
(1055,	'Muhafazat al Iskandariyah',	64),
(1056,	'Muhafazat al Qahirah',	64),
(1057,	'Qina',	64),
(1058,	'Sawhaj',	64),
(1059,	'Sina al-Janubiyah',	64),
(1060,	'Sina ash-Shamaliyah',	64),
(1061,	'ad-Daqahliyah',	64),
(1062,	'al-Bahr-al-Ahmar',	64),
(1063,	'al-Buhayrah',	64),
(1064,	'al-Fayyum',	64),
(1065,	'al-Gharbiyah',	64),
(1066,	'al-Iskandariyah',	64),
(1067,	'al-Ismailiyah',	64),
(1068,	'al-Jizah',	64),
(1069,	'al-Minufiyah',	64),
(1070,	'al-Minya',	64),
(1071,	'al-Qahira',	64),
(1072,	'al-Qalyubiyah',	64),
(1073,	'al-Uqsur',	64),
(1074,	'al-Wadi al-Jadid',	64),
(1075,	'as-Suways',	64),
(1076,	'ash-Sharqiyah',	64),
(1077,	'Ahuachapan',	65),
(1078,	'Cabanas',	65),
(1079,	'Chalatenango',	65),
(1080,	'Cuscatlan',	65),
(1081,	'La Libertad',	65),
(1082,	'La Paz',	65),
(1083,	'La Union',	65),
(1084,	'Morazan',	65),
(1085,	'San Miguel',	65),
(1086,	'San Salvador',	65),
(1087,	'San Vicente',	65),
(1088,	'Santa Ana',	65),
(1089,	'Sonsonate',	65),
(1090,	'Usulutan',	65),
(1091,	'Annobon',	66),
(1092,	'Bioko Norte',	66),
(1093,	'Bioko Sur',	66),
(1094,	'Centro Sur',	66),
(1095,	'Kie-Ntem',	66),
(1096,	'Litoral',	66),
(1097,	'Wele-Nzas',	66),
(1098,	'Anseba',	67),
(1099,	'Debub',	67),
(1100,	'Debub-Keih-Bahri',	67),
(1101,	'Gash-Barka',	67),
(1102,	'Maekel',	67),
(1103,	'Semien-Keih-Bahri',	67),
(1104,	'Harju',	68),
(1105,	'Hiiu',	68),
(1106,	'Ida-Viru',	68),
(1107,	'Jarva',	68),
(1108,	'Jogeva',	68),
(1109,	'Laane',	68),
(1110,	'Laane-Viru',	68),
(1111,	'Parnu',	68),
(1112,	'Polva',	68),
(1113,	'Rapla',	68),
(1114,	'Saare',	68),
(1115,	'Tartu',	68),
(1116,	'Valga',	68),
(1117,	'Viljandi',	68),
(1118,	'Voru',	68),
(1119,	'Addis Abeba',	69),
(1120,	'Afar',	69),
(1121,	'Amhara',	69),
(1122,	'Benishangul',	69),
(1123,	'Diredawa',	69),
(1124,	'Gambella',	69),
(1125,	'Harar',	69),
(1126,	'Jigjiga',	69),
(1127,	'Mekele',	69),
(1128,	'Oromia',	69),
(1129,	'Somali',	69),
(1130,	'Southern',	69),
(1131,	'Tigray',	69),
(1132,	'Christmas Island',	70),
(1133,	'Cocos Islands',	70),
(1134,	'Coral Sea Islands',	70),
(1135,	'Falkland Islands',	71),
(1136,	'South Georgia',	71),
(1137,	'Klaksvik',	72),
(1138,	'Nor ara Eysturoy',	72),
(1139,	'Nor oy',	72),
(1140,	'Sandoy',	72),
(1141,	'Streymoy',	72),
(1142,	'Su uroy',	72),
(1143,	'Sy ra Eysturoy',	72),
(1144,	'Torshavn',	72),
(1145,	'Vaga',	72),
(1146,	'Central',	73),
(1147,	'Eastern',	73),
(1148,	'Northern',	73),
(1149,	'South Pacific',	73),
(1150,	'Western',	73),
(1151,	'Ahvenanmaa',	74),
(1152,	'Etela-Karjala',	74),
(1153,	'Etela-Pohjanmaa',	74),
(1154,	'Etela-Savo',	74),
(1155,	'Etela-Suomen Laani',	74),
(1156,	'Ita-Suomen Laani',	74),
(1157,	'Ita-Uusimaa',	74),
(1158,	'Kainuu',	74),
(1159,	'Kanta-Hame',	74),
(1160,	'Keski-Pohjanmaa',	74),
(1161,	'Keski-Suomi',	74),
(1162,	'Kymenlaakso',	74),
(1163,	'Lansi-Suomen Laani',	74),
(1164,	'Lappi',	74),
(1165,	'Northern Savonia',	74),
(1166,	'Ostrobothnia',	74),
(1167,	'Oulun Laani',	74),
(1168,	'Paijat-Hame',	74),
(1169,	'Pirkanmaa',	74),
(1170,	'Pohjanmaa',	74),
(1171,	'Pohjois-Karjala',	74),
(1172,	'Pohjois-Pohjanmaa',	74),
(1173,	'Pohjois-Savo',	74),
(1174,	'Saarijarvi',	74),
(1175,	'Satakunta',	74),
(1176,	'Southern Savonia',	74),
(1177,	'Tavastia Proper',	74),
(1178,	'Uleaborgs Lan',	74),
(1179,	'Uusimaa',	74),
(1180,	'Varsinais-Suomi',	74),
(1181,	'Ain',	75),
(1182,	'Aisne',	75),
(1183,	'Albi Le Sequestre',	75),
(1184,	'Allier',	75),
(1185,	'Alpes-Cote dAzur',	75),
(1186,	'Alpes-Maritimes',	75),
(1187,	'Alpes-de-Haute-Provence',	75),
(1188,	'Alsace',	75),
(1189,	'Aquitaine',	75),
(1190,	'Ardeche',	75),
(1191,	'Ardennes',	75),
(1192,	'Ariege',	75),
(1193,	'Aube',	75),
(1194,	'Aude',	75),
(1195,	'Auvergne',	75),
(1196,	'Aveyron',	75),
(1197,	'Bas-Rhin',	75),
(1198,	'Basse-Normandie',	75),
(1199,	'Bouches-du-Rhone',	75),
(1200,	'Bourgogne',	75),
(1201,	'Bretagne',	75),
(1202,	'Brittany',	75),
(1203,	'Burgundy',	75),
(1204,	'Calvados',	75),
(1205,	'Cantal',	75),
(1206,	'Cedex',	75),
(1207,	'Centre',	75),
(1208,	'Charente',	75),
(1209,	'Charente-Maritime',	75),
(1210,	'Cher',	75),
(1211,	'Correze',	75),
(1212,	'Corse-du-Sud',	75),
(1213,	'Cote-d\'Or',	75),
(1214,	'Cotes-d\'Armor',	75),
(1215,	'Creuse',	75),
(1216,	'Crolles',	75),
(1217,	'Deux-Sevres',	75),
(1218,	'Dordogne',	75),
(1219,	'Doubs',	75),
(1220,	'Drome',	75),
(1221,	'Essonne',	75),
(1222,	'Eure',	75),
(1223,	'Eure-et-Loir',	75),
(1224,	'Feucherolles',	75),
(1225,	'Finistere',	75),
(1226,	'Franche-Comte',	75),
(1227,	'Gard',	75),
(1228,	'Gers',	75),
(1229,	'Gironde',	75),
(1230,	'Haut-Rhin',	75),
(1231,	'Haute-Corse',	75),
(1232,	'Haute-Garonne',	75),
(1233,	'Haute-Loire',	75),
(1234,	'Haute-Marne',	75),
(1235,	'Haute-Saone',	75),
(1236,	'Haute-Savoie',	75),
(1237,	'Haute-Vienne',	75),
(1238,	'Hautes-Alpes',	75),
(1239,	'Hautes-Pyrenees',	75),
(1240,	'Hauts-de-Seine',	75),
(1241,	'Herault',	75),
(1242,	'Ile-de-France',	75),
(1243,	'Ille-et-Vilaine',	75),
(1244,	'Indre',	75),
(1245,	'Indre-et-Loire',	75),
(1246,	'Isere',	75),
(1247,	'Jura',	75),
(1248,	'Klagenfurt',	75),
(1249,	'Landes',	75),
(1250,	'Languedoc-Roussillon',	75),
(1251,	'Larcay',	75),
(1252,	'Le Castellet',	75),
(1253,	'Le Creusot',	75),
(1254,	'Limousin',	75),
(1255,	'Loir-et-Cher',	75),
(1256,	'Loire',	75),
(1257,	'Loire-Atlantique',	75),
(1258,	'Loiret',	75),
(1259,	'Lorraine',	75),
(1260,	'Lot',	75),
(1261,	'Lot-et-Garonne',	75),
(1262,	'Lower Normandy',	75),
(1263,	'Lozere',	75),
(1264,	'Maine-et-Loire',	75),
(1265,	'Manche',	75),
(1266,	'Marne',	75),
(1267,	'Mayenne',	75),
(1268,	'Meurthe-et-Moselle',	75),
(1269,	'Meuse',	75),
(1270,	'Midi-Pyrenees',	75),
(1271,	'Morbihan',	75),
(1272,	'Moselle',	75),
(1273,	'Nievre',	75),
(1274,	'Nord',	75),
(1275,	'Nord-Pas-de-Calais',	75),
(1276,	'Oise',	75),
(1277,	'Orne',	75),
(1278,	'Paris',	75),
(1279,	'Pas-de-Calais',	75),
(1280,	'Pays de la Loire',	75),
(1281,	'Pays-de-la-Loire',	75),
(1282,	'Picardy',	75),
(1283,	'Puy-de-Dome',	75),
(1284,	'Pyrenees-Atlantiques',	75),
(1285,	'Pyrenees-Orientales',	75),
(1286,	'Quelmes',	75),
(1287,	'Rhone',	75),
(1288,	'Rhone-Alpes',	75),
(1289,	'Saint Ouen',	75),
(1290,	'Saint Viatre',	75),
(1291,	'Saone-et-Loire',	75),
(1292,	'Sarthe',	75),
(1293,	'Savoie',	75),
(1294,	'Seine-Maritime',	75),
(1295,	'Seine-Saint-Denis',	75),
(1296,	'Seine-et-Marne',	75),
(1297,	'Somme',	75),
(1298,	'Sophia Antipolis',	75),
(1299,	'Souvans',	75),
(1300,	'Tarn',	75),
(1301,	'Tarn-et-Garonne',	75),
(1302,	'Territoire de Belfort',	75),
(1303,	'Treignac',	75),
(1304,	'Upper Normandy',	75),
(1305,	'Val-d\'Oise',	75),
(1306,	'Val-de-Marne',	75),
(1307,	'Var',	75),
(1308,	'Vaucluse',	75),
(1309,	'Vellise',	75),
(1310,	'Vendee',	75),
(1311,	'Vienne',	75),
(1312,	'Vosges',	75),
(1313,	'Yonne',	75),
(1314,	'Yvelines',	75),
(1315,	'Cayenne',	76),
(1316,	'Saint-Laurent-du-Maroni',	76),
(1317,	'Iles du Vent',	77),
(1318,	'Iles sous le Vent',	77),
(1319,	'Marquesas',	77),
(1320,	'Tuamotu',	77),
(1321,	'Tubuai',	77),
(1322,	'Amsterdam',	78),
(1323,	'Crozet Islands',	78),
(1324,	'Kerguelen',	78),
(1325,	'Estuaire',	79),
(1326,	'Haut-Ogooue',	79),
(1327,	'Moyen-Ogooue',	79),
(1328,	'Ngounie',	79),
(1329,	'Nyanga',	79),
(1330,	'Ogooue-Ivindo',	79),
(1331,	'Ogooue-Lolo',	79),
(1332,	'Ogooue-Maritime',	79),
(1333,	'Woleu-Ntem',	79),
(1334,	'Banjul',	80),
(1335,	'Basse',	80),
(1336,	'Brikama',	80),
(1337,	'Janjanbureh',	80),
(1338,	'Kanifing',	80),
(1339,	'Kerewan',	80),
(1340,	'Kuntaur',	80),
(1341,	'Mansakonko',	80),
(1342,	'Abhasia',	81),
(1343,	'Ajaria',	81),
(1344,	'Guria',	81),
(1345,	'Imereti',	81),
(1346,	'Kaheti',	81),
(1347,	'Kvemo Kartli',	81),
(1348,	'Mcheta-Mtianeti',	81),
(1349,	'Racha',	81),
(1350,	'Samagrelo-Zemo Svaneti',	81),
(1351,	'Samche-Zhavaheti',	81),
(1352,	'Shida Kartli',	81),
(1353,	'Tbilisi',	81),
(1354,	'Auvergne',	82),
(1355,	'Baden-Wurttemberg',	82),
(1356,	'Bavaria',	82),
(1357,	'Bayern',	82),
(1358,	'Beilstein Wurtt',	82),
(1359,	'Berlin',	82),
(1360,	'Brandenburg',	82),
(1361,	'Bremen',	82),
(1362,	'Dreisbach',	82),
(1363,	'Freistaat Bayern',	82),
(1364,	'Hamburg',	82),
(1365,	'Hannover',	82),
(1366,	'Heroldstatt',	82),
(1367,	'Hessen',	82),
(1368,	'Kortenberg',	82),
(1369,	'Laasdorf',	82),
(1370,	'Land Baden-Wurttemberg',	82),
(1371,	'Land Bayern',	82),
(1372,	'Land Brandenburg',	82),
(1373,	'Land Hessen',	82),
(1374,	'Land Mecklenburg-Vorpommern',	82),
(1375,	'Land Nordrhein-Westfalen',	82),
(1376,	'Land Rheinland-Pfalz',	82),
(1377,	'Land Sachsen',	82),
(1378,	'Land Sachsen-Anhalt',	82),
(1379,	'Land Thuringen',	82),
(1380,	'Lower Saxony',	82),
(1381,	'Mecklenburg-Vorpommern',	82),
(1382,	'Mulfingen',	82),
(1383,	'Munich',	82),
(1384,	'Neubeuern',	82),
(1385,	'Niedersachsen',	82),
(1386,	'Noord-Holland',	82),
(1387,	'Nordrhein-Westfalen',	82),
(1388,	'North Rhine-Westphalia',	82),
(1389,	'Osterode',	82),
(1390,	'Rheinland-Pfalz',	82),
(1391,	'Rhineland-Palatinate',	82),
(1392,	'Saarland',	82),
(1393,	'Sachsen',	82),
(1394,	'Sachsen-Anhalt',	82),
(1395,	'Saxony',	82),
(1396,	'Schleswig-Holstein',	82),
(1397,	'Thuringia',	82),
(1398,	'Webling',	82),
(1399,	'Weinstrabe',	82),
(1400,	'schlobborn',	82),
(1401,	'Ashanti',	83),
(1402,	'Brong-Ahafo',	83),
(1403,	'Central',	83),
(1404,	'Eastern',	83),
(1405,	'Greater Accra',	83),
(1406,	'Northern',	83),
(1407,	'Upper East',	83),
(1408,	'Upper West',	83),
(1409,	'Volta',	83),
(1410,	'Western',	83),
(1411,	'Gibraltar',	84),
(1412,	'Acharnes',	85),
(1413,	'Ahaia',	85),
(1414,	'Aitolia kai Akarnania',	85),
(1415,	'Argolis',	85),
(1416,	'Arkadia',	85),
(1417,	'Arta',	85),
(1418,	'Attica',	85),
(1419,	'Attiki',	85),
(1420,	'Ayion Oros',	85),
(1421,	'Crete',	85),
(1422,	'Dodekanisos',	85),
(1423,	'Drama',	85),
(1424,	'Evia',	85),
(1425,	'Evritania',	85),
(1426,	'Evros',	85),
(1427,	'Evvoia',	85),
(1428,	'Florina',	85),
(1429,	'Fokis',	85),
(1430,	'Fthiotis',	85),
(1431,	'Grevena',	85),
(1432,	'Halandri',	85),
(1433,	'Halkidiki',	85),
(1434,	'Hania',	85),
(1435,	'Heraklion',	85),
(1436,	'Hios',	85),
(1437,	'Ilia',	85),
(1438,	'Imathia',	85),
(1439,	'Ioannina',	85),
(1440,	'Iraklion',	85),
(1441,	'Karditsa',	85),
(1442,	'Kastoria',	85),
(1443,	'Kavala',	85),
(1444,	'Kefallinia',	85),
(1445,	'Kerkira',	85),
(1446,	'Kiklades',	85),
(1447,	'Kilkis',	85),
(1448,	'Korinthia',	85),
(1449,	'Kozani',	85),
(1450,	'Lakonia',	85),
(1451,	'Larisa',	85),
(1452,	'Lasithi',	85),
(1453,	'Lesvos',	85),
(1454,	'Levkas',	85),
(1455,	'Magnisia',	85),
(1456,	'Messinia',	85),
(1457,	'Nomos Attikis',	85),
(1458,	'Nomos Zakynthou',	85),
(1459,	'Pella',	85),
(1460,	'Pieria',	85),
(1461,	'Piraios',	85),
(1462,	'Preveza',	85),
(1463,	'Rethimni',	85),
(1464,	'Rodopi',	85),
(1465,	'Samos',	85),
(1466,	'Serrai',	85),
(1467,	'Thesprotia',	85),
(1468,	'Thessaloniki',	85),
(1469,	'Trikala',	85),
(1470,	'Voiotia',	85),
(1471,	'West Greece',	85),
(1472,	'Xanthi',	85),
(1473,	'Zakinthos',	85),
(1474,	'Aasiaat',	86),
(1475,	'Ammassalik',	86),
(1476,	'Illoqqortoormiut',	86),
(1477,	'Ilulissat',	86),
(1478,	'Ivittuut',	86),
(1479,	'Kangaatsiaq',	86),
(1480,	'Maniitsoq',	86),
(1481,	'Nanortalik',	86),
(1482,	'Narsaq',	86),
(1483,	'Nuuk',	86),
(1484,	'Paamiut',	86),
(1485,	'Qaanaaq',	86),
(1486,	'Qaqortoq',	86),
(1487,	'Qasigiannguit',	86),
(1488,	'Qeqertarsuaq',	86),
(1489,	'Sisimiut',	86),
(1490,	'Udenfor kommunal inddeling',	86),
(1491,	'Upernavik',	86),
(1492,	'Uummannaq',	86),
(1493,	'Carriacou-Petite Martinique',	87),
(1494,	'Saint Andrew',	87),
(1495,	'Saint Davids',	87),
(1496,	'Saint George\'s',	87),
(1497,	'Saint John',	87),
(1498,	'Saint Mark',	87),
(1499,	'Saint Patrick',	87),
(1500,	'Basse-Terre',	88),
(1501,	'Grande-Terre',	88),
(1502,	'Iles des Saintes',	88),
(1503,	'La Desirade',	88),
(1504,	'Marie-Galante',	88),
(1505,	'Saint Barthelemy',	88),
(1506,	'Saint Martin',	88),
(1507,	'Agana Heights',	89),
(1508,	'Agat',	89),
(1509,	'Barrigada',	89),
(1510,	'Chalan-Pago-Ordot',	89),
(1511,	'Dededo',	89),
(1512,	'Hagatna',	89),
(1513,	'Inarajan',	89),
(1514,	'Mangilao',	89),
(1515,	'Merizo',	89),
(1516,	'Mongmong-Toto-Maite',	89),
(1517,	'Santa Rita',	89),
(1518,	'Sinajana',	89),
(1519,	'Talofofo',	89),
(1520,	'Tamuning',	89),
(1521,	'Yigo',	89),
(1522,	'Yona',	89),
(1523,	'Alta Verapaz',	90),
(1524,	'Baja Verapaz',	90),
(1525,	'Chimaltenango',	90),
(1526,	'Chiquimula',	90),
(1527,	'El Progreso',	90),
(1528,	'Escuintla',	90),
(1529,	'Guatemala',	90),
(1530,	'Huehuetenango',	90),
(1531,	'Izabal',	90),
(1532,	'Jalapa',	90),
(1533,	'Jutiapa',	90),
(1534,	'Peten',	90),
(1535,	'Quezaltenango',	90),
(1536,	'Quiche',	90),
(1537,	'Retalhuleu',	90),
(1538,	'Sacatepequez',	90),
(1539,	'San Marcos',	90),
(1540,	'Santa Rosa',	90),
(1541,	'Solola',	90),
(1542,	'Suchitepequez',	90),
(1543,	'Totonicapan',	90),
(1544,	'Zacapa',	90),
(1545,	'Alderney',	91),
(1546,	'Castel',	91),
(1547,	'Forest',	91),
(1548,	'Saint Andrew',	91),
(1549,	'Saint Martin',	91),
(1550,	'Saint Peter Port',	91),
(1551,	'Saint Pierre du Bois',	91),
(1552,	'Saint Sampson',	91),
(1553,	'Saint Saviour',	91),
(1554,	'Sark',	91),
(1555,	'Torteval',	91),
(1556,	'Vale',	91),
(1557,	'Beyla',	92),
(1558,	'Boffa',	92),
(1559,	'Boke',	92),
(1560,	'Conakry',	92),
(1561,	'Coyah',	92),
(1562,	'Dabola',	92),
(1563,	'Dalaba',	92),
(1564,	'Dinguiraye',	92),
(1565,	'Faranah',	92),
(1566,	'Forecariah',	92),
(1567,	'Fria',	92),
(1568,	'Gaoual',	92),
(1569,	'Gueckedou',	92),
(1570,	'Kankan',	92),
(1571,	'Kerouane',	92),
(1572,	'Kindia',	92),
(1573,	'Kissidougou',	92),
(1574,	'Koubia',	92),
(1575,	'Koundara',	92),
(1576,	'Kouroussa',	92),
(1577,	'Labe',	92),
(1578,	'Lola',	92),
(1579,	'Macenta',	92),
(1580,	'Mali',	92),
(1581,	'Mamou',	92),
(1582,	'Mandiana',	92),
(1583,	'Nzerekore',	92),
(1584,	'Pita',	92),
(1585,	'Siguiri',	92),
(1586,	'Telimele',	92),
(1587,	'Tougue',	92),
(1588,	'Yomou',	92),
(1589,	'Bafata',	93),
(1590,	'Bissau',	93),
(1591,	'Bolama',	93),
(1592,	'Cacheu',	93),
(1593,	'Gabu',	93),
(1594,	'Oio',	93),
(1595,	'Quinara',	93),
(1596,	'Tombali',	93),
(1597,	'Barima-Waini',	94),
(1598,	'Cuyuni-Mazaruni',	94),
(1599,	'Demerara-Mahaica',	94),
(1600,	'East Berbice-Corentyne',	94),
(1601,	'Essequibo Islands-West Demerar',	94),
(1602,	'Mahaica-Berbice',	94),
(1603,	'Pomeroon-Supenaam',	94),
(1604,	'Potaro-Siparuni',	94),
(1605,	'Upper Demerara-Berbice',	94),
(1606,	'Upper Takutu-Upper Essequibo',	94),
(1607,	'Artibonite',	95),
(1608,	'Centre',	95),
(1609,	'Grand\'Anse',	95),
(1610,	'Nord',	95),
(1611,	'Nord-Est',	95),
(1612,	'Nord-Ouest',	95),
(1613,	'Ouest',	95),
(1614,	'Sud',	95),
(1615,	'Sud-Est',	95),
(1616,	'Heard and McDonald Islands',	96),
(1617,	'Atlantida',	97),
(1618,	'Choluteca',	97),
(1619,	'Colon',	97),
(1620,	'Comayagua',	97),
(1621,	'Copan',	97),
(1622,	'Cortes',	97),
(1623,	'Distrito Central',	97),
(1624,	'El Paraiso',	97),
(1625,	'Francisco Morazan',	97),
(1626,	'Gracias a Dios',	97),
(1627,	'Intibuca',	97),
(1628,	'Islas de la Bahia',	97),
(1629,	'La Paz',	97),
(1630,	'Lempira',	97),
(1631,	'Ocotepeque',	97),
(1632,	'Olancho',	97),
(1633,	'Santa Barbara',	97),
(1634,	'Valle',	97),
(1635,	'Yoro',	97),
(1636,	'Hong Kong',	98),
(1637,	'Bacs-Kiskun',	99),
(1638,	'Baranya',	99),
(1639,	'Bekes',	99),
(1640,	'Borsod-Abauj-Zemplen',	99),
(1641,	'Budapest',	99),
(1642,	'Csongrad',	99),
(1643,	'Fejer',	99),
(1644,	'Gyor-Moson-Sopron',	99),
(1645,	'Hajdu-Bihar',	99),
(1646,	'Heves',	99),
(1647,	'Jasz-Nagykun-Szolnok',	99),
(1648,	'Komarom-Esztergom',	99),
(1649,	'Nograd',	99),
(1650,	'Pest',	99),
(1651,	'Somogy',	99),
(1652,	'Szabolcs-Szatmar-Bereg',	99),
(1653,	'Tolna',	99),
(1654,	'Vas',	99),
(1655,	'Veszprem',	99),
(1656,	'Zala',	99),
(1657,	'Austurland',	100),
(1658,	'Gullbringusysla',	100),
(1659,	'Hofu borgarsva i',	100),
(1660,	'Nor urland eystra',	100),
(1661,	'Nor urland vestra',	100),
(1662,	'Su urland',	100),
(1663,	'Su urnes',	100),
(1664,	'Vestfir ir',	100),
(1665,	'Vesturland',	100),
(1666,	'Aceh',	102),
(1667,	'Bali',	102),
(1668,	'Bangka-Belitung',	102),
(1669,	'Banten',	102),
(1670,	'Bengkulu',	102),
(1671,	'Gandaria',	102),
(1672,	'Gorontalo',	102),
(1673,	'Jakarta',	102),
(1674,	'Jambi',	102),
(1675,	'Jawa Barat',	102),
(1676,	'Jawa Tengah',	102),
(1677,	'Jawa Timur',	102),
(1678,	'Kalimantan Barat',	102),
(1679,	'Kalimantan Selatan',	102),
(1680,	'Kalimantan Tengah',	102),
(1681,	'Kalimantan Timur',	102),
(1682,	'Kendal',	102),
(1683,	'Lampung',	102),
(1684,	'Maluku',	102),
(1685,	'Maluku Utara',	102),
(1686,	'Nusa Tenggara Barat',	102),
(1687,	'Nusa Tenggara Timur',	102),
(1688,	'Papua',	102),
(1689,	'Riau',	102),
(1690,	'Riau Kepulauan',	102),
(1691,	'Solo',	102),
(1692,	'Sulawesi Selatan',	102),
(1693,	'Sulawesi Tengah',	102),
(1694,	'Sulawesi Tenggara',	102),
(1695,	'Sulawesi Utara',	102),
(1696,	'Sumatera Barat',	102),
(1697,	'Sumatera Selatan',	102),
(1698,	'Sumatera Utara',	102),
(1699,	'Yogyakarta',	102),
(1700,	'Ardabil',	103),
(1701,	'Azarbayjan-e Bakhtari',	103),
(1702,	'Azarbayjan-e Khavari',	103),
(1703,	'Bushehr',	103),
(1704,	'Chahar Mahal-e Bakhtiari',	103),
(1705,	'Esfahan',	103),
(1706,	'Fars',	103),
(1707,	'Gilan',	103),
(1708,	'Golestan',	103),
(1709,	'Hamadan',	103),
(1710,	'Hormozgan',	103),
(1711,	'Ilam',	103),
(1712,	'Kerman',	103),
(1713,	'Kermanshah',	103),
(1714,	'Khorasan',	103),
(1715,	'Khuzestan',	103),
(1716,	'Kohgiluyeh-e Boyerahmad',	103),
(1717,	'Kordestan',	103),
(1718,	'Lorestan',	103),
(1719,	'Markazi',	103),
(1720,	'Mazandaran',	103),
(1721,	'Ostan-e Esfahan',	103),
(1722,	'Qazvin',	103),
(1723,	'Qom',	103),
(1724,	'Semnan',	103),
(1725,	'Sistan-e Baluchestan',	103),
(1726,	'Tehran',	103),
(1727,	'Yazd',	103),
(1728,	'Zanjan',	103),
(1729,	'Babil',	104),
(1730,	'Baghdad',	104),
(1731,	'Dahuk',	104),
(1732,	'Dhi Qar',	104),
(1733,	'Diyala',	104),
(1734,	'Erbil',	104),
(1735,	'Irbil',	104),
(1736,	'Karbala',	104),
(1737,	'Kurdistan',	104),
(1738,	'Maysan',	104),
(1739,	'Ninawa',	104),
(1740,	'Salah-ad-Din',	104),
(1741,	'Wasit',	104),
(1742,	'al-Anbar',	104),
(1743,	'al-Basrah',	104),
(1744,	'al-Muthanna',	104),
(1745,	'al-Qadisiyah',	104),
(1746,	'an-Najaf',	104),
(1747,	'as-Sulaymaniyah',	104),
(1748,	'at-Ta\'mim',	104),
(1749,	'Armagh',	105),
(1750,	'Carlow',	105),
(1751,	'Cavan',	105),
(1752,	'Clare',	105),
(1753,	'Cork',	105),
(1754,	'Donegal',	105),
(1755,	'Dublin',	105),
(1756,	'Galway',	105),
(1757,	'Kerry',	105),
(1758,	'Kildare',	105),
(1759,	'Kilkenny',	105),
(1760,	'Laois',	105),
(1761,	'Leinster',	105),
(1762,	'Leitrim',	105),
(1763,	'Limerick',	105),
(1764,	'Loch Garman',	105),
(1765,	'Longford',	105),
(1766,	'Louth',	105),
(1767,	'Mayo',	105),
(1768,	'Meath',	105),
(1769,	'Monaghan',	105),
(1770,	'Offaly',	105),
(1771,	'Roscommon',	105),
(1772,	'Sligo',	105),
(1773,	'Tipperary North Riding',	105),
(1774,	'Tipperary South Riding',	105),
(1775,	'Ulster',	105),
(1776,	'Waterford',	105),
(1777,	'Westmeath',	105),
(1778,	'Wexford',	105),
(1779,	'Wicklow',	105),
(1780,	'Beit Hanania',	106),
(1781,	'Ben Gurion Airport',	106),
(1782,	'Bethlehem',	106),
(1783,	'Caesarea',	106),
(1784,	'Centre',	106),
(1785,	'Gaza',	106),
(1786,	'Hadaron',	106),
(1787,	'Haifa District',	106),
(1788,	'Hamerkaz',	106),
(1789,	'Hazafon',	106),
(1790,	'Hebron',	106),
(1791,	'Jaffa',	106),
(1792,	'Jerusalem',	106),
(1793,	'Khefa',	106),
(1794,	'Kiryat Yam',	106),
(1795,	'Lower Galilee',	106),
(1796,	'Qalqilya',	106),
(1797,	'Talme Elazar',	106),
(1798,	'Tel Aviv',	106),
(1799,	'Tsafon',	106),
(1800,	'Umm El Fahem',	106),
(1801,	'Yerushalayim',	106),
(1903,	'Buxoro Viloyati',	108),
(1904,	'Clarendon',	108),
(1905,	'Hanover',	108),
(1906,	'Kingston',	108),
(1907,	'Manchester',	108),
(1908,	'Portland',	108),
(1909,	'Saint Andrews',	108),
(1910,	'Saint Ann',	108),
(1911,	'Saint Catherine',	108),
(1912,	'Saint Elizabeth',	108),
(1913,	'Saint James',	108),
(1914,	'Saint Mary',	108),
(1915,	'Saint Thomas',	108),
(1916,	'Trelawney',	108),
(1917,	'Westmoreland',	108),
(1918,	'Aichi',	109),
(1919,	'Akita',	109),
(1920,	'Aomori',	109),
(1921,	'Chiba',	109),
(1922,	'Ehime',	109),
(1923,	'Fukui',	109),
(1924,	'Fukuoka',	109),
(1925,	'Fukushima',	109),
(1926,	'Gifu',	109),
(1927,	'Gumma',	109),
(1928,	'Hiroshima',	109),
(1929,	'Hokkaido',	109),
(1930,	'Hyogo',	109),
(1931,	'Ibaraki',	109),
(1932,	'Ishikawa',	109),
(1933,	'Iwate',	109),
(1934,	'Kagawa',	109),
(1935,	'Kagoshima',	109),
(1936,	'Kanagawa',	109),
(1937,	'Kanto',	109),
(1938,	'Kochi',	109),
(1939,	'Kumamoto',	109),
(1940,	'Kyoto',	109),
(1941,	'Mie',	109),
(1942,	'Miyagi',	109),
(1943,	'Miyazaki',	109),
(1944,	'Nagano',	109),
(1945,	'Nagasaki',	109),
(1946,	'Nara',	109),
(1947,	'Niigata',	109),
(1948,	'Oita',	109),
(1949,	'Okayama',	109),
(1950,	'Okinawa',	109),
(1951,	'Osaka',	109),
(1952,	'Saga',	109),
(1953,	'Saitama',	109),
(1954,	'Shiga',	109),
(1955,	'Shimane',	109),
(1956,	'Shizuoka',	109),
(1957,	'Tochigi',	109),
(1958,	'Tokushima',	109),
(1959,	'Tokyo',	109),
(1960,	'Tottori',	109),
(1961,	'Toyama',	109),
(1962,	'Wakayama',	109),
(1963,	'Yamagata',	109),
(1964,	'Yamaguchi',	109),
(1965,	'Yamanashi',	109),
(1966,	'Grouville',	110),
(1967,	'Saint Brelade',	110),
(1968,	'Saint Clement',	110),
(1969,	'Saint Helier',	110),
(1970,	'Saint John',	110),
(1971,	'Saint Lawrence',	110),
(1972,	'Saint Martin',	110),
(1973,	'Saint Mary',	110),
(1974,	'Saint Peter',	110),
(1975,	'Saint Saviour',	110),
(1976,	'Trinity',	110),
(1977,	'\'Ajlun',	111),
(1978,	'Amman',	111),
(1979,	'Irbid',	111),
(1980,	'Jarash',	111),
(1981,	'Ma\'an',	111),
(1982,	'Madaba',	111),
(1983,	'al-\'Aqabah',	111),
(1984,	'al-Balqa\'',	111),
(1985,	'al-Karak',	111),
(1986,	'al-Mafraq',	111),
(1987,	'at-Tafilah',	111),
(1988,	'az-Zarqa\'',	111),
(1989,	'Akmecet',	112),
(1990,	'Akmola',	112),
(1991,	'Aktobe',	112),
(1992,	'Almati',	112),
(1993,	'Atirau',	112),
(1994,	'Batis Kazakstan',	112),
(1995,	'Burlinsky Region',	112),
(1996,	'Karagandi',	112),
(1997,	'Kostanay',	112),
(1998,	'Mankistau',	112),
(1999,	'Ontustik Kazakstan',	112),
(2000,	'Pavlodar',	112),
(2001,	'Sigis Kazakstan',	112),
(2002,	'Soltustik Kazakstan',	112),
(2003,	'Taraz',	112),
(2004,	'Central',	113),
(2005,	'Coast',	113),
(2006,	'Eastern',	113),
(2007,	'Nairobi',	113),
(2008,	'North Eastern',	113),
(2009,	'Nyanza',	113),
(2010,	'Rift Valley',	113),
(2011,	'Western',	113),
(2012,	'Abaiang',	114),
(2013,	'Abemana',	114),
(2014,	'Aranuka',	114),
(2015,	'Arorae',	114),
(2016,	'Banaba',	114),
(2017,	'Beru',	114),
(2018,	'Butaritari',	114),
(2019,	'Kiritimati',	114),
(2020,	'Kuria',	114),
(2021,	'Maiana',	114),
(2022,	'Makin',	114),
(2023,	'Marakei',	114),
(2024,	'Nikunau',	114),
(2025,	'Nonouti',	114),
(2026,	'Onotoa',	114),
(2027,	'Phoenix Islands',	114),
(2028,	'Tabiteuea North',	114),
(2029,	'Tabiteuea South',	114),
(2030,	'Tabuaeran',	114),
(2031,	'Tamana',	114),
(2032,	'Tarawa North',	114),
(2033,	'Tarawa South',	114),
(2034,	'Teraina',	114),
(2035,	'Chagangdo',	115),
(2036,	'Hamgyeongbukto',	115),
(2037,	'Hamgyeongnamdo',	115),
(2038,	'Hwanghaebukto',	115),
(2039,	'Hwanghaenamdo',	115),
(2040,	'Kaeseong',	115),
(2041,	'Kangweon',	115),
(2042,	'Nampo',	115),
(2043,	'Pyeonganbukto',	115),
(2044,	'Pyeongannamdo',	115),
(2045,	'Pyeongyang',	115),
(2046,	'Yanggang',	115),
(2047,	'Busan',	116),
(2048,	'Cheju',	116),
(2049,	'Chollabuk',	116),
(2050,	'Chollanam',	116),
(2051,	'Chungbuk',	116),
(2052,	'Chungcheongbuk',	116),
(2053,	'Chungcheongnam',	116),
(2054,	'Chungnam',	116),
(2055,	'Daegu',	116),
(2056,	'Gangwon-do',	116),
(2057,	'Goyang-si',	116),
(2058,	'Gyeonggi-do',	116),
(2059,	'Gyeongsang ',	116),
(2060,	'Gyeongsangnam-do',	116),
(2061,	'Incheon',	116),
(2062,	'Jeju-Si',	116),
(2063,	'Jeonbuk',	116),
(2064,	'Kangweon',	116),
(2065,	'Kwangju',	116),
(2066,	'Kyeonggi',	116),
(2067,	'Kyeongsangbuk',	116),
(2068,	'Kyeongsangnam',	116),
(2069,	'Kyonggi-do',	116),
(2070,	'Kyungbuk-Do',	116),
(2071,	'Kyunggi-Do',	116),
(2072,	'Kyunggi-do',	116),
(2073,	'Pusan',	116),
(2074,	'Seoul',	116),
(2075,	'Sudogwon',	116),
(2076,	'Taegu',	116),
(2077,	'Taejeon',	116),
(2078,	'Taejon-gwangyoksi',	116),
(2079,	'Ulsan',	116),
(2080,	'Wonju',	116),
(2081,	'gwangyoksi',	116),
(2082,	'Al Asimah',	117),
(2083,	'Hawalli',	117),
(2084,	'Mishref',	117),
(2085,	'Qadesiya',	117),
(2086,	'Safat',	117),
(2087,	'Salmiya',	117),
(2088,	'al-Ahmadi',	117),
(2089,	'al-Farwaniyah',	117),
(2090,	'al-Jahra',	117),
(2091,	'al-Kuwayt',	117),
(2092,	'Batken',	118),
(2093,	'Bishkek',	118),
(2094,	'Chui',	118),
(2095,	'Issyk-Kul',	118),
(2096,	'Jalal-Abad',	118),
(2097,	'Naryn',	118),
(2098,	'Osh',	118),
(2099,	'Talas',	118),
(2100,	'Attopu',	119),
(2101,	'Bokeo',	119),
(2102,	'Bolikhamsay',	119),
(2103,	'Champasak',	119),
(2104,	'Houaphanh',	119),
(2105,	'Khammouane',	119),
(2106,	'Luang Nam Tha',	119),
(2107,	'Luang Prabang',	119),
(2108,	'Oudomxay',	119),
(2109,	'Phongsaly',	119),
(2110,	'Saravan',	119),
(2111,	'Savannakhet',	119),
(2112,	'Sekong',	119),
(2113,	'Viangchan Prefecture',	119),
(2114,	'Viangchan Province',	119),
(2115,	'Xaignabury',	119),
(2116,	'Xiang Khuang',	119),
(2117,	'Aizkraukles',	120),
(2118,	'Aluksnes',	120),
(2119,	'Balvu',	120),
(2120,	'Bauskas',	120),
(2121,	'Cesu',	120),
(2122,	'Daugavpils',	120),
(2123,	'Daugavpils City',	120),
(2124,	'Dobeles',	120),
(2125,	'Gulbenes',	120),
(2126,	'Jekabspils',	120),
(2127,	'Jelgava',	120),
(2128,	'Jelgavas',	120),
(2129,	'Jurmala City',	120),
(2130,	'Kraslavas',	120),
(2131,	'Kuldigas',	120),
(2132,	'Liepaja',	120),
(2133,	'Liepajas',	120),
(2134,	'Limbazhu',	120),
(2135,	'Ludzas',	120),
(2136,	'Madonas',	120),
(2137,	'Ogres',	120),
(2138,	'Preilu',	120),
(2139,	'Rezekne',	120),
(2140,	'Rezeknes',	120),
(2141,	'Riga',	120),
(2142,	'Rigas',	120),
(2143,	'Saldus',	120),
(2144,	'Talsu',	120),
(2145,	'Tukuma',	120),
(2146,	'Valkas',	120),
(2147,	'Valmieras',	120),
(2148,	'Ventspils',	120),
(2149,	'Ventspils City',	120),
(2150,	'Beirut',	121),
(2151,	'Jabal Lubnan',	121),
(2152,	'Mohafazat Liban-Nord',	121),
(2153,	'Mohafazat Mont-Liban',	121),
(2154,	'Sidon',	121),
(2155,	'al-Biqa',	121),
(2156,	'al-Janub',	121),
(2157,	'an-Nabatiyah',	121),
(2158,	'ash-Shamal',	121),
(2159,	'Berea',	122),
(2160,	'Butha-Buthe',	122),
(2161,	'Leribe',	122),
(2162,	'Mafeteng',	122),
(2163,	'Maseru',	122),
(2164,	'Mohale\'s Hoek',	122),
(2165,	'Mokhotlong',	122),
(2166,	'Qacha\'s Nek',	122),
(2167,	'Quthing',	122),
(2168,	'Thaba-Tseka',	122),
(2169,	'Bomi',	123),
(2170,	'Bong',	123),
(2171,	'Grand Bassa',	123),
(2172,	'Grand Cape Mount',	123),
(2173,	'Grand Gedeh',	123),
(2174,	'Loffa',	123),
(2175,	'Margibi',	123),
(2176,	'Maryland and Grand Kru',	123),
(2177,	'Montserrado',	123),
(2178,	'Nimba',	123),
(2179,	'Rivercess',	123),
(2180,	'Sinoe',	123),
(2181,	'Ajdabiya',	124),
(2182,	'Fezzan',	124),
(2183,	'Banghazi',	124),
(2184,	'Darnah',	124),
(2185,	'Ghadamis',	124),
(2186,	'Gharyan',	124),
(2187,	'Misratah',	124),
(2188,	'Murzuq',	124),
(2189,	'Sabha',	124),
(2190,	'Sawfajjin',	124),
(2191,	'Surt',	124),
(2192,	'Tarabulus',	124),
(2193,	'Tarhunah',	124),
(2194,	'Tripolitania',	124),
(2195,	'Tubruq',	124),
(2196,	'Yafran',	124),
(2197,	'Zlitan',	124),
(2198,	'al-\'Aziziyah',	124),
(2199,	'al-Fatih',	124),
(2200,	'al-Jabal al Akhdar',	124),
(2201,	'al-Jufrah',	124),
(2202,	'al-Khums',	124),
(2203,	'al-Kufrah',	124),
(2204,	'an-Nuqat al-Khams',	124),
(2205,	'ash-Shati\'',	124),
(2206,	'az-Zawiyah',	124),
(2207,	'Balzers',	125),
(2208,	'Eschen',	125),
(2209,	'Gamprin',	125),
(2210,	'Mauren',	125),
(2211,	'Planken',	125),
(2212,	'Ruggell',	125),
(2213,	'Schaan',	125),
(2214,	'Schellenberg',	125),
(2215,	'Triesen',	125),
(2216,	'Triesenberg',	125),
(2217,	'Vaduz',	125),
(2218,	'Alytaus',	126),
(2219,	'Anyksciai',	126),
(2220,	'Kauno',	126),
(2221,	'Klaipedos',	126),
(2222,	'Marijampoles',	126),
(2223,	'Panevezhio',	126),
(2224,	'Panevezys',	126),
(2225,	'Shiauliu',	126),
(2226,	'Taurages',	126),
(2227,	'Telshiu',	126),
(2228,	'Telsiai',	126),
(2229,	'Utenos',	126),
(2230,	'Vilniaus',	126),
(2231,	'Capellen',	127),
(2232,	'Clervaux',	127),
(2233,	'Diekirch',	127),
(2234,	'Echternach',	127),
(2235,	'Esch-sur-Alzette',	127),
(2236,	'Grevenmacher',	127),
(2237,	'Luxembourg',	127),
(2238,	'Mersch',	127),
(2239,	'Redange',	127),
(2240,	'Remich',	127),
(2241,	'Vianden',	127),
(2242,	'Wiltz',	127),
(2243,	'Macau',	128),
(2244,	'Berovo',	129),
(2245,	'Bitola',	129),
(2246,	'Brod',	129),
(2247,	'Debar',	129),
(2248,	'Delchevo',	129),
(2249,	'Demir Hisar',	129),
(2250,	'Gevgelija',	129),
(2251,	'Gostivar',	129),
(2252,	'Kavadarci',	129),
(2253,	'Kichevo',	129),
(2254,	'Kochani',	129),
(2255,	'Kratovo',	129),
(2256,	'Kriva Palanka',	129),
(2257,	'Krushevo',	129),
(2258,	'Kumanovo',	129),
(2259,	'Negotino',	129),
(2260,	'Ohrid',	129),
(2261,	'Prilep',	129),
(2262,	'Probishtip',	129),
(2263,	'Radovish',	129),
(2264,	'Resen',	129),
(2265,	'Shtip',	129),
(2266,	'Skopje',	129),
(2267,	'Struga',	129),
(2268,	'Strumica',	129),
(2269,	'Sveti Nikole',	129),
(2270,	'Tetovo',	129),
(2271,	'Valandovo',	129),
(2272,	'Veles',	129),
(2273,	'Vinica',	129),
(2274,	'Antananarivo',	130),
(2275,	'Antsiranana',	130),
(2276,	'Fianarantsoa',	130),
(2277,	'Mahajanga',	130),
(2278,	'Toamasina',	130),
(2279,	'Toliary',	130),
(2280,	'Balaka',	131),
(2281,	'Blantyre City',	131),
(2282,	'Chikwawa',	131),
(2283,	'Chiradzulu',	131),
(2284,	'Chitipa',	131),
(2285,	'Dedza',	131),
(2286,	'Dowa',	131),
(2287,	'Karonga',	131),
(2288,	'Kasungu',	131),
(2289,	'Lilongwe City',	131),
(2290,	'Machinga',	131),
(2291,	'Mangochi',	131),
(2292,	'Mchinji',	131),
(2293,	'Mulanje',	131),
(2294,	'Mwanza',	131),
(2295,	'Mzimba',	131),
(2296,	'Mzuzu City',	131),
(2297,	'Nkhata Bay',	131),
(2298,	'Nkhotakota',	131),
(2299,	'Nsanje',	131),
(2300,	'Ntcheu',	131),
(2301,	'Ntchisi',	131),
(2302,	'Phalombe',	131),
(2303,	'Rumphi',	131),
(2304,	'Salima',	131),
(2305,	'Thyolo',	131),
(2306,	'Zomba Municipality',	131),
(2307,	'Johor',	132),
(2308,	'Kedah',	132),
(2309,	'Kelantan',	132),
(2310,	'Kuala Lumpur',	132),
(2311,	'Labuan',	132),
(2312,	'Melaka',	132),
(2313,	'Negeri Johor',	132),
(2314,	'Negeri Sembilan',	132),
(2315,	'Pahang',	132),
(2316,	'Penang',	132),
(2317,	'Perak',	132),
(2318,	'Perlis',	132),
(2319,	'Pulau Pinang',	132),
(2320,	'Sabah',	132),
(2321,	'Sarawak',	132),
(2322,	'Selangor',	132),
(2323,	'Sembilan',	132),
(2324,	'Terengganu',	132),
(2325,	'Alif Alif',	133),
(2326,	'Alif Dhaal',	133),
(2327,	'Baa',	133),
(2328,	'Dhaal',	133),
(2329,	'Faaf',	133),
(2330,	'Gaaf Alif',	133),
(2331,	'Gaaf Dhaal',	133),
(2332,	'Ghaviyani',	133),
(2333,	'Haa Alif',	133),
(2334,	'Haa Dhaal',	133),
(2335,	'Kaaf',	133),
(2336,	'Laam',	133),
(2337,	'Lhaviyani',	133),
(2338,	'Male',	133),
(2339,	'Miim',	133),
(2340,	'Nuun',	133),
(2341,	'Raa',	133),
(2342,	'Shaviyani',	133),
(2343,	'Siin',	133),
(2344,	'Thaa',	133),
(2345,	'Vaav',	133),
(2346,	'Bamako',	134),
(2347,	'Gao',	134),
(2348,	'Kayes',	134),
(2349,	'Kidal',	134),
(2350,	'Koulikoro',	134),
(2351,	'Mopti',	134),
(2352,	'Segou',	134),
(2353,	'Sikasso',	134),
(2354,	'Tombouctou',	134),
(2355,	'Gozo and Comino',	135),
(2356,	'Inner Harbour',	135),
(2357,	'Northern',	135),
(2358,	'Outer Harbour',	135),
(2359,	'South Eastern',	135),
(2360,	'Valletta',	135),
(2361,	'Western',	135),
(2362,	'Castletown',	136),
(2363,	'Douglas',	136),
(2364,	'Laxey',	136),
(2365,	'Onchan',	136),
(2366,	'Peel',	136),
(2367,	'Port Erin',	136),
(2368,	'Port Saint Mary',	136),
(2369,	'Ramsey',	136),
(2370,	'Ailinlaplap',	137),
(2371,	'Ailuk',	137),
(2372,	'Arno',	137),
(2373,	'Aur',	137),
(2374,	'Bikini',	137),
(2375,	'Ebon',	137),
(2376,	'Enewetak',	137),
(2377,	'Jabat',	137),
(2378,	'Jaluit',	137),
(2379,	'Kili',	137),
(2380,	'Kwajalein',	137),
(2381,	'Lae',	137),
(2382,	'Lib',	137),
(2383,	'Likiep',	137),
(2384,	'Majuro',	137),
(2385,	'Maloelap',	137),
(2386,	'Mejit',	137),
(2387,	'Mili',	137),
(2388,	'Namorik',	137),
(2389,	'Namu',	137),
(2390,	'Rongelap',	137),
(2391,	'Ujae',	137),
(2392,	'Utrik',	137),
(2393,	'Wotho',	137),
(2394,	'Wotje',	137),
(2395,	'Fort-de-France',	138),
(2396,	'La Trinite',	138),
(2397,	'Le Marin',	138),
(2398,	'Saint-Pierre',	138),
(2399,	'Adrar',	139),
(2400,	'Assaba',	139),
(2401,	'Brakna',	139),
(2402,	'Dhakhlat Nawadibu',	139),
(2403,	'Hudh-al-Gharbi',	139),
(2404,	'Hudh-ash-Sharqi',	139),
(2405,	'Inshiri',	139),
(2406,	'Nawakshut',	139),
(2407,	'Qidimagha',	139),
(2408,	'Qurqul',	139),
(2409,	'Taqant',	139),
(2410,	'Tiris Zammur',	139),
(2411,	'Trarza',	139),
(2412,	'Black River',	140),
(2413,	'Eau Coulee',	140),
(2414,	'Flacq',	140),
(2415,	'Floreal',	140),
(2416,	'Grand Port',	140),
(2417,	'Moka',	140),
(2418,	'Pamplempousses',	140),
(2419,	'Plaines Wilhelm',	140),
(2420,	'Port Louis',	140),
(2421,	'Riviere du Rempart',	140),
(2422,	'Rodrigues',	140),
(2423,	'Rose Hill',	140),
(2424,	'Savanne',	140),
(2425,	'Mayotte',	141),
(2426,	'Pamanzi',	141),
(2427,	'Aguascalientes',	142),
(2428,	'Baja California',	142),
(2429,	'Baja California Sur',	142),
(2430,	'Campeche',	142),
(2431,	'Chiapas',	142),
(2432,	'Chihuahua',	142),
(2433,	'Coahuila',	142),
(2434,	'Colima',	142),
(2435,	'Distrito Federal',	142),
(2436,	'Durango',	142),
(2437,	'Estado de Mexico',	142),
(2438,	'Guanajuato',	142),
(2439,	'Guerrero',	142),
(2440,	'Hidalgo',	142),
(2441,	'Jalisco',	142),
(2442,	'Mexico',	142),
(2443,	'Michoacan',	142),
(2444,	'Morelos',	142),
(2445,	'Nayarit',	142),
(2446,	'Nuevo Leon',	142),
(2447,	'Oaxaca',	142),
(2448,	'Puebla',	142),
(2449,	'Queretaro',	142),
(2450,	'Quintana Roo',	142),
(2451,	'San Luis Potosi',	142),
(2452,	'Sinaloa',	142),
(2453,	'Sonora',	142),
(2454,	'Tabasco',	142),
(2455,	'Tamaulipas',	142),
(2456,	'Tlaxcala',	142),
(2457,	'Veracruz',	142),
(2458,	'Yucatan',	142),
(2459,	'Zacatecas',	142),
(2460,	'Chuuk',	143),
(2461,	'Kusaie',	143),
(2462,	'Pohnpei',	143),
(2463,	'Yap',	143),
(2464,	'Balti',	144),
(2465,	'Cahul',	144),
(2466,	'Chisinau',	144),
(2467,	'Chisinau Oras',	144),
(2468,	'Edinet',	144),
(2469,	'Gagauzia',	144),
(2470,	'Lapusna',	144),
(2471,	'Orhei',	144),
(2472,	'Soroca',	144),
(2473,	'Taraclia',	144),
(2474,	'Tighina',	144),
(2475,	'Transnistria',	144),
(2476,	'Ungheni',	144),
(2477,	'Fontvieille',	145),
(2478,	'La Condamine',	145),
(2479,	'Monaco-Ville',	145),
(2480,	'Monte Carlo',	145),
(2481,	'Arhangaj',	146),
(2482,	'Bajan-Olgij',	146),
(2483,	'Bajanhongor',	146),
(2484,	'Bulgan',	146),
(2485,	'Darhan-Uul',	146),
(2486,	'Dornod',	146),
(2487,	'Dornogovi',	146),
(2488,	'Dundgovi',	146),
(2489,	'Govi-Altaj',	146),
(2490,	'Govisumber',	146),
(2491,	'Hentij',	146),
(2492,	'Hovd',	146),
(2493,	'Hovsgol',	146),
(2494,	'Omnogovi',	146),
(2495,	'Orhon',	146),
(2496,	'Ovorhangaj',	146),
(2497,	'Selenge',	146),
(2498,	'Suhbaatar',	146),
(2499,	'Tov',	146),
(2500,	'Ulaanbaatar',	146),
(2501,	'Uvs',	146),
(2502,	'Zavhan',	146),
(2503,	'Montserrat',	147),
(2504,	'Agadir',	148),
(2505,	'Casablanca',	148),
(2506,	'Chaouia-Ouardigha',	148),
(2507,	'Doukkala-Abda',	148),
(2508,	'Fes-Boulemane',	148),
(2509,	'Gharb-Chrarda-Beni Hssen',	148),
(2510,	'Guelmim',	148),
(2511,	'Kenitra',	148),
(2512,	'Marrakech-Tensift-Al Haouz',	148),
(2513,	'Meknes-Tafilalet',	148),
(2514,	'Oriental',	148),
(2515,	'Oujda',	148),
(2516,	'Province de Tanger',	148),
(2517,	'Rabat-Sale-Zammour-Zaer',	148),
(2518,	'Sala Al Jadida',	148),
(2519,	'Settat',	148),
(2520,	'Souss Massa-Draa',	148),
(2521,	'Tadla-Azilal',	148),
(2522,	'Tangier-Tetouan',	148),
(2523,	'Taza-Al Hoceima-Taounate',	148),
(2524,	'Wilaya de Casablanca',	148),
(2525,	'Wilaya de Rabat-Sale',	148),
(2526,	'Cabo Delgado',	149),
(2527,	'Gaza',	149),
(2528,	'Inhambane',	149),
(2529,	'Manica',	149),
(2530,	'Maputo',	149),
(2531,	'Maputo Provincia',	149),
(2532,	'Nampula',	149),
(2533,	'Niassa',	149),
(2534,	'Sofala',	149),
(2535,	'Tete',	149),
(2536,	'Zambezia',	149),
(2537,	'Ayeyarwady',	150),
(2538,	'Bago',	150),
(2539,	'Chin',	150),
(2540,	'Kachin',	150),
(2541,	'Kayah',	150),
(2542,	'Kayin',	150),
(2543,	'Magway',	150),
(2544,	'Mandalay',	150),
(2545,	'Mon',	150),
(2546,	'Nay Pyi Taw',	150),
(2547,	'Rakhine',	150),
(2548,	'Sagaing',	150),
(2549,	'Shan',	150),
(2550,	'Tanintharyi',	150),
(2551,	'Yangon',	150),
(2552,	'Caprivi',	151),
(2553,	'Erongo',	151),
(2554,	'Hardap',	151),
(2555,	'Karas',	151),
(2556,	'Kavango',	151),
(2557,	'Khomas',	151),
(2558,	'Kunene',	151),
(2559,	'Ohangwena',	151),
(2560,	'Omaheke',	151),
(2561,	'Omusati',	151),
(2562,	'Oshana',	151),
(2563,	'Oshikoto',	151),
(2564,	'Otjozondjupa',	151),
(2565,	'Yaren',	152),
(2566,	'Bagmati',	153),
(2569,	'Gandaki',	153),
(2571,	'Karnali',	153),
(2572,	'Koshi',	153),
(2573,	'Lumbini',	153),
(2580,	'Bonaire',	154),
(2581,	'Curacao',	154),
(2582,	'Saba',	154),
(2583,	'Sint Eustatius',	154),
(2584,	'Sint Maarten',	154),
(2585,	'Amsterdam',	155),
(2586,	'Benelux',	155),
(2587,	'Drenthe',	155),
(2588,	'Flevoland',	155),
(2589,	'Friesland',	155),
(2590,	'Gelderland',	155),
(2591,	'Groningen',	155),
(2592,	'Limburg',	155),
(2593,	'Noord-Brabant',	155),
(2594,	'Noord-Holland',	155),
(2595,	'Overijssel',	155),
(2596,	'South Holland',	155),
(2597,	'Utrecht',	155),
(2598,	'Zeeland',	155),
(2599,	'Zuid-Holland',	155),
(2600,	'Iles',	156),
(2601,	'Nord',	156),
(2602,	'Sud',	156),
(2603,	'Area Outside Region',	157),
(2604,	'Auckland',	157),
(2605,	'Bay of Plenty',	157),
(2606,	'Canterbury',	157),
(2607,	'Christchurch',	157),
(2608,	'Gisborne',	157),
(2609,	'Hawke\'s Bay',	157),
(2610,	'Manawatu-Wanganui',	157),
(2611,	'Marlborough',	157),
(2612,	'Nelson',	157),
(2613,	'Northland',	157),
(2614,	'Otago',	157),
(2615,	'Rodney',	157),
(2616,	'Southland',	157),
(2617,	'Taranaki',	157),
(2618,	'Tasman',	157),
(2619,	'Waikato',	157),
(2620,	'Wellington',	157),
(2621,	'West Coast',	157),
(2622,	'Atlantico Norte',	158),
(2623,	'Atlantico Sur',	158),
(2624,	'Boaco',	158),
(2625,	'Carazo',	158),
(2626,	'Chinandega',	158),
(2627,	'Chontales',	158),
(2628,	'Esteli',	158),
(2629,	'Granada',	158),
(2630,	'Jinotega',	158),
(2631,	'Leon',	158),
(2632,	'Madriz',	158),
(2633,	'Managua',	158),
(2634,	'Masaya',	158),
(2635,	'Matagalpa',	158),
(2636,	'Nueva Segovia',	158),
(2637,	'Rio San Juan',	158),
(2638,	'Rivas',	158),
(2639,	'Agadez',	159),
(2640,	'Diffa',	159),
(2641,	'Dosso',	159),
(2642,	'Maradi',	159),
(2643,	'Niamey',	159),
(2644,	'Tahoua',	159),
(2645,	'Tillabery',	159),
(2646,	'Zinder',	159),
(2647,	'Abia',	160),
(2648,	'Abuja Federal Capital Territor',	160),
(2649,	'Adamawa',	160),
(2650,	'Akwa Ibom',	160),
(2651,	'Anambra',	160),
(2652,	'Bauchi',	160),
(2653,	'Bayelsa',	160),
(2654,	'Benue',	160),
(2655,	'Borno',	160),
(2656,	'Cross River',	160),
(2657,	'Delta',	160),
(2658,	'Ebonyi',	160),
(2659,	'Edo',	160),
(2660,	'Ekiti',	160),
(2661,	'Enugu',	160),
(2662,	'Gombe',	160),
(2663,	'Imo',	160),
(2664,	'Jigawa',	160),
(2665,	'Kaduna',	160),
(2666,	'Kano',	160),
(2667,	'Katsina',	160),
(2668,	'Kebbi',	160),
(2669,	'Kogi',	160),
(2670,	'Kwara',	160),
(2671,	'Lagos',	160),
(2672,	'Nassarawa',	160),
(2673,	'Niger',	160),
(2674,	'Ogun',	160),
(2675,	'Ondo',	160),
(2676,	'Osun',	160),
(2677,	'Oyo',	160),
(2678,	'Plateau',	160),
(2679,	'Rivers',	160),
(2680,	'Sokoto',	160),
(2681,	'Taraba',	160),
(2682,	'Yobe',	160),
(2683,	'Zamfara',	160),
(2684,	'Niue',	161),
(2685,	'Norfolk Island',	162),
(2686,	'Northern Islands',	163),
(2687,	'Rota',	163),
(2688,	'Saipan',	163),
(2689,	'Tinian',	163),
(2713,	'Al Buraimi',	165),
(2714,	'Dhufar',	165),
(2715,	'Masqat',	165),
(2716,	'Musandam',	165),
(2717,	'Rusayl',	165),
(2718,	'Wadi Kabir',	165),
(2719,	'ad-Dakhiliyah',	165),
(2720,	'adh-Dhahirah',	165),
(2721,	'al-Batinah',	165),
(2722,	'ash-Sharqiyah',	165),
(2723,	'Baluchistan',	166),
(2724,	'Federal Capital Area',	166),
(2725,	'Federally administered Tribal ',	166),
(2726,	'North-West Frontier',	166),
(2727,	'Northern Areas',	166),
(2728,	'Punjab',	166),
(2729,	'Sind',	166),
(2730,	'Aimeliik',	167),
(2731,	'Airai',	167),
(2732,	'Angaur',	167),
(2733,	'Hatobohei',	167),
(2734,	'Kayangel',	167),
(2735,	'Koror',	167),
(2736,	'Melekeok',	167),
(2737,	'Ngaraard',	167),
(2738,	'Ngardmau',	167),
(2739,	'Ngaremlengui',	167),
(2740,	'Ngatpang',	167),
(2741,	'Ngchesar',	167),
(2742,	'Ngerchelong',	167),
(2743,	'Ngiwal',	167),
(2744,	'Peleliu',	167),
(2745,	'Sonsorol',	167),
(2746,	'Ariha',	168),
(2747,	'Bayt Lahm',	168),
(2748,	'Bethlehem',	168),
(2749,	'Dayr-al-Balah',	168),
(2750,	'Ghazzah',	168),
(2751,	'Ghazzah ash-Shamaliyah',	168),
(2752,	'Janin',	168),
(2753,	'Khan Yunis',	168),
(2754,	'Nabulus',	168),
(2755,	'Qalqilyah',	168),
(2756,	'Rafah',	168),
(2757,	'Ram Allah wal-Birah',	168),
(2758,	'Salfit',	168),
(2759,	'Tubas',	168),
(2760,	'Tulkarm',	168),
(2761,	'al-Khalil',	168),
(2762,	'al-Quds',	168),
(2763,	'Bocas del Toro',	169),
(2764,	'Chiriqui',	169),
(2765,	'Cocle',	169),
(2766,	'Colon',	169),
(2767,	'Darien',	169),
(2768,	'Embera',	169),
(2769,	'Herrera',	169),
(2770,	'Kuna Yala',	169),
(2771,	'Los Santos',	169),
(2772,	'Ngobe Bugle',	169),
(2773,	'Panama',	169),
(2774,	'Veraguas',	169),
(2775,	'East New Britain',	170),
(2776,	'East Sepik',	170),
(2777,	'Eastern Highlands',	170),
(2778,	'Enga',	170),
(2779,	'Fly River',	170),
(2780,	'Gulf',	170),
(2781,	'Madang',	170),
(2782,	'Manus',	170),
(2783,	'Milne Bay',	170),
(2784,	'Morobe',	170),
(2785,	'National Capital District',	170),
(2786,	'New Ireland',	170),
(2787,	'North Solomons',	170),
(2788,	'Oro',	170),
(2789,	'Sandaun',	170),
(2790,	'Simbu',	170),
(2791,	'Southern Highlands',	170),
(2792,	'West New Britain',	170),
(2793,	'Western Highlands',	170),
(2794,	'Alto Paraguay',	171),
(2795,	'Alto Parana',	171),
(2796,	'Amambay',	171),
(2797,	'Asuncion',	171),
(2798,	'Boqueron',	171),
(2799,	'Caaguazu',	171),
(2800,	'Caazapa',	171),
(2801,	'Canendiyu',	171),
(2802,	'Central',	171),
(2803,	'Concepcion',	171),
(2804,	'Cordillera',	171),
(2805,	'Guaira',	171),
(2806,	'Itapua',	171),
(2807,	'Misiones',	171),
(2808,	'Neembucu',	171),
(2809,	'Paraguari',	171),
(2810,	'Presidente Hayes',	171),
(2811,	'San Pedro',	171),
(2812,	'Amazonas',	172),
(2813,	'Ancash',	172),
(2814,	'Apurimac',	172),
(2815,	'Arequipa',	172),
(2816,	'Ayacucho',	172),
(2817,	'Cajamarca',	172),
(2818,	'Cusco',	172),
(2819,	'Huancavelica',	172),
(2820,	'Huanuco',	172),
(2821,	'Ica',	172),
(2822,	'Junin',	172),
(2823,	'La Libertad',	172),
(2824,	'Lambayeque',	172),
(2825,	'Lima y Callao',	172),
(2826,	'Loreto',	172),
(2827,	'Madre de Dios',	172),
(2828,	'Moquegua',	172),
(2829,	'Pasco',	172),
(2830,	'Piura',	172),
(2831,	'Puno',	172),
(2832,	'San Martin',	172),
(2833,	'Tacna',	172),
(2834,	'Tumbes',	172),
(2835,	'Ucayali',	172),
(2836,	'Batangas',	173),
(2837,	'Bicol',	173),
(2838,	'Bulacan',	173),
(2839,	'Cagayan',	173),
(2840,	'Caraga',	173),
(2841,	'Central Luzon',	173),
(2842,	'Central Mindanao',	173),
(2843,	'Central Visayas',	173),
(2844,	'Cordillera',	173),
(2845,	'Davao',	173),
(2846,	'Eastern Visayas',	173),
(2847,	'Greater Metropolitan Area',	173),
(2848,	'Ilocos',	173),
(2849,	'Laguna',	173),
(2850,	'Luzon',	173),
(2851,	'Mactan',	173),
(2852,	'Metropolitan Manila Area',	173),
(2853,	'Muslim Mindanao',	173),
(2854,	'Northern Mindanao',	173),
(2855,	'Southern Mindanao',	173),
(2856,	'Southern Tagalog',	173),
(2857,	'Western Mindanao',	173),
(2858,	'Western Visayas',	173),
(2859,	'Pitcairn Island',	174),
(2860,	'Biale Blota',	175),
(2861,	'Dobroszyce',	175),
(2862,	'Dolnoslaskie',	175),
(2863,	'Dziekanow Lesny',	175),
(2864,	'Hopowo',	175),
(2865,	'Kartuzy',	175),
(2866,	'Koscian',	175),
(2867,	'Krakow',	175),
(2868,	'Kujawsko-Pomorskie',	175),
(2869,	'Lodzkie',	175),
(2870,	'Lubelskie',	175),
(2871,	'Lubuskie',	175),
(2872,	'Malomice',	175),
(2873,	'Malopolskie',	175),
(2874,	'Mazowieckie',	175),
(2875,	'Mirkow',	175),
(2876,	'Opolskie',	175),
(2877,	'Ostrowiec',	175),
(2878,	'Podkarpackie',	175),
(2879,	'Podlaskie',	175),
(2880,	'Polska',	175),
(2881,	'Pomorskie',	175),
(2882,	'Poznan',	175),
(2883,	'Pruszkow',	175),
(2884,	'Rymanowska',	175),
(2885,	'Rzeszow',	175),
(2886,	'Slaskie',	175),
(2887,	'Stare Pole',	175),
(2888,	'Swietokrzyskie',	175),
(2889,	'Warminsko-Mazurskie',	175),
(2890,	'Warsaw',	175),
(2891,	'Wejherowo',	175),
(2892,	'Wielkopolskie',	175),
(2893,	'Wroclaw',	175),
(2894,	'Zachodnio-Pomorskie',	175),
(2895,	'Zukowo',	175),
(2896,	'Abrantes',	176),
(2897,	'Acores',	176),
(2898,	'Alentejo',	176),
(2899,	'Algarve',	176),
(2900,	'Braga',	176),
(2901,	'Centro',	176),
(2902,	'Distrito de Leiria',	176),
(2903,	'Distrito de Viana do Castelo',	176),
(2904,	'Distrito de Vila Real',	176),
(2905,	'Distrito do Porto',	176),
(2906,	'Lisboa e Vale do Tejo',	176),
(2907,	'Madeira',	176),
(2908,	'Norte',	176),
(2909,	'Paivas',	176),
(2910,	'Arecibo',	177),
(2911,	'Bayamon',	177),
(2912,	'Carolina',	177),
(2913,	'Florida',	177),
(2914,	'Guayama',	177),
(2915,	'Humacao',	177),
(2916,	'Mayaguez-Aguadilla',	177),
(2917,	'Ponce',	177),
(2918,	'Salinas',	177),
(2919,	'San Juan',	177),
(2920,	'Doha',	178),
(2921,	'Jarian-al-Batnah',	178),
(2922,	'Umm Salal',	178),
(2923,	'ad-Dawhah',	178),
(2924,	'al-Ghuwayriyah',	178),
(2925,	'al-Jumayliyah',	178),
(2926,	'al-Khawr',	178),
(2927,	'al-Wakrah',	178),
(2928,	'ar-Rayyan',	178),
(2929,	'ash-Shamal',	178),
(2930,	'Saint-Benoit',	179),
(2931,	'Saint-Denis',	179),
(2932,	'Saint-Paul',	179),
(2933,	'Saint-Pierre',	179),
(2934,	'Alba',	180),
(2935,	'Arad',	180),
(2936,	'Arges',	180),
(2937,	'Bacau',	180),
(2938,	'Bihor',	180),
(2939,	'Bistrita-Nasaud',	180),
(2940,	'Botosani',	180),
(2941,	'Braila',	180),
(2942,	'Brasov',	180),
(2943,	'Bucuresti',	180),
(2944,	'Buzau',	180),
(2945,	'Calarasi',	180),
(2946,	'Caras-Severin',	180),
(2947,	'Cluj',	180),
(2948,	'Constanta',	180),
(2949,	'Covasna',	180),
(2950,	'Dambovita',	180),
(2951,	'Dolj',	180),
(2952,	'Galati',	180),
(2953,	'Giurgiu',	180),
(2954,	'Gorj',	180),
(2955,	'Harghita',	180),
(2956,	'Hunedoara',	180),
(2957,	'Ialomita',	180),
(2958,	'Iasi',	180),
(2959,	'Ilfov',	180),
(2960,	'Maramures',	180),
(2961,	'Mehedinti',	180),
(2962,	'Mures',	180),
(2963,	'Neamt',	180),
(2964,	'Olt',	180),
(2965,	'Prahova',	180),
(2966,	'Salaj',	180),
(2967,	'Satu Mare',	180),
(2968,	'Sibiu',	180),
(2969,	'Sondelor',	180),
(2970,	'Suceava',	180),
(2971,	'Teleorman',	180),
(2972,	'Timis',	180),
(2973,	'Tulcea',	180),
(2974,	'Valcea',	180),
(2975,	'Vaslui',	180),
(2976,	'Vrancea',	180),
(2977,	'Adygeja',	181),
(2978,	'Aga',	181),
(2979,	'Alanija',	181),
(2980,	'Altaj',	181),
(2981,	'Amur',	181),
(2982,	'Arhangelsk',	181),
(2983,	'Astrahan',	181),
(2984,	'Bashkortostan',	181),
(2985,	'Belgorod',	181),
(2986,	'Brjansk',	181),
(2987,	'Burjatija',	181),
(2988,	'Chechenija',	181),
(2989,	'Cheljabinsk',	181),
(2990,	'Chita',	181),
(2991,	'Chukotka',	181),
(2992,	'Chuvashija',	181),
(2993,	'Dagestan',	181),
(2994,	'Evenkija',	181),
(2995,	'Gorno-Altaj',	181),
(2996,	'Habarovsk',	181),
(2997,	'Hakasija',	181),
(2998,	'Hanty-Mansija',	181),
(2999,	'Ingusetija',	181),
(3000,	'Irkutsk',	181),
(3001,	'Ivanovo',	181),
(3002,	'Jamalo-Nenets',	181),
(3003,	'Jaroslavl',	181),
(3004,	'Jevrej',	181),
(3005,	'Kabardino-Balkarija',	181),
(3006,	'Kaliningrad',	181),
(3007,	'Kalmykija',	181),
(3008,	'Kaluga',	181),
(3009,	'Kamchatka',	181),
(3010,	'Karachaj-Cherkessija',	181),
(3011,	'Karelija',	181),
(3012,	'Kemerovo',	181),
(3013,	'Khabarovskiy Kray',	181),
(3014,	'Kirov',	181),
(3015,	'Komi',	181),
(3016,	'Komi-Permjakija',	181),
(3017,	'Korjakija',	181),
(3018,	'Kostroma',	181),
(3019,	'Krasnodar',	181),
(3020,	'Krasnojarsk',	181),
(3021,	'Krasnoyarskiy Kray',	181),
(3022,	'Kurgan',	181),
(3023,	'Kursk',	181),
(3024,	'Leningrad',	181),
(3025,	'Lipeck',	181),
(3026,	'Magadan',	181),
(3027,	'Marij El',	181),
(3028,	'Mordovija',	181),
(3029,	'Moscow',	181),
(3030,	'Moskovskaja Oblast',	181),
(3031,	'Moskovskaya Oblast',	181),
(3032,	'Moskva',	181),
(3033,	'Murmansk',	181),
(3034,	'Nenets',	181),
(3035,	'Nizhnij Novgorod',	181),
(3036,	'Novgorod',	181),
(3037,	'Novokusnezk',	181),
(3038,	'Novosibirsk',	181),
(3039,	'Omsk',	181),
(3040,	'Orenburg',	181),
(3041,	'Orjol',	181),
(3042,	'Penza',	181),
(3043,	'Perm',	181),
(3044,	'Primorje',	181),
(3045,	'Pskov',	181),
(3046,	'Pskovskaya Oblast',	181),
(3047,	'Rjazan',	181),
(3048,	'Rostov',	181),
(3049,	'Saha',	181),
(3050,	'Sahalin',	181),
(3051,	'Samara',	181),
(3052,	'Samarskaya',	181),
(3053,	'Sankt-Peterburg',	181),
(3054,	'Saratov',	181),
(3055,	'Smolensk',	181),
(3056,	'Stavropol',	181),
(3057,	'Sverdlovsk',	181),
(3058,	'Tajmyrija',	181),
(3059,	'Tambov',	181),
(3060,	'Tatarstan',	181),
(3061,	'Tjumen',	181),
(3062,	'Tomsk',	181),
(3063,	'Tula',	181),
(3064,	'Tver',	181),
(3065,	'Tyva',	181),
(3066,	'Udmurtija',	181),
(3067,	'Uljanovsk',	181),
(3068,	'Ulyanovskaya Oblast',	181),
(3069,	'Ust-Orda',	181),
(3070,	'Vladimir',	181),
(3071,	'Volgograd',	181),
(3072,	'Vologda',	181),
(3073,	'Voronezh',	181),
(3074,	'Butare',	182),
(3075,	'Byumba',	182),
(3076,	'Cyangugu',	182),
(3077,	'Gikongoro',	182),
(3078,	'Gisenyi',	182),
(3079,	'Gitarama',	182),
(3080,	'Kibungo',	182),
(3081,	'Kibuye',	182),
(3082,	'Kigali-ngali',	182),
(3083,	'Ruhengeri',	182),
(3084,	'Ascension',	183),
(3085,	'Gough Island',	183),
(3086,	'Saint Helena',	183),
(3087,	'Tristan da Cunha',	183),
(3088,	'Christ Church Nichola Town',	184),
(3089,	'Saint Anne Sandy Point',	184),
(3090,	'Saint George Basseterre',	184),
(3091,	'Saint George Gingerland',	184),
(3092,	'Saint James Windward',	184),
(3093,	'Saint John Capesterre',	184),
(3094,	'Saint John Figtree',	184),
(3095,	'Saint Mary Cayon',	184),
(3096,	'Saint Paul Capesterre',	184),
(3097,	'Saint Paul Charlestown',	184),
(3098,	'Saint Peter Basseterre',	184),
(3099,	'Saint Thomas Lowland',	184),
(3100,	'Saint Thomas Middle Island',	184),
(3101,	'Trinity Palmetto Point',	184),
(3102,	'Anse-la-Raye',	185),
(3103,	'Canaries',	185),
(3104,	'Castries',	185),
(3105,	'Choiseul',	185),
(3106,	'Dennery',	185),
(3107,	'Gros Inlet',	185),
(3108,	'Laborie',	185),
(3109,	'Micoud',	185),
(3110,	'Soufriere',	185),
(3111,	'Vieux Fort',	185),
(3112,	'Miquelon-Langlade',	186),
(3113,	'Saint-Pierre',	186),
(3114,	'Charlotte',	187),
(3115,	'Grenadines',	187),
(3116,	'Saint Andrew',	187),
(3117,	'Saint David',	187),
(3118,	'Saint George',	187),
(3119,	'Saint Patrick',	187),
(3120,	'A\'ana',	188),
(3121,	'Aiga-i-le-Tai',	188),
(3122,	'Atua',	188),
(3123,	'Fa\'asaleleaga',	188),
(3124,	'Gaga\'emauga',	188),
(3125,	'Gagaifomauga',	188),
(3126,	'Palauli',	188),
(3127,	'Satupa\'itea',	188),
(3128,	'Tuamasaga',	188),
(3129,	'Va\'a-o-Fonoti',	188),
(3130,	'Vaisigano',	188),
(3131,	'Acquaviva',	189),
(3132,	'Borgo Maggiore',	189),
(3133,	'Chiesanuova',	189),
(3134,	'Domagnano',	189),
(3135,	'Faetano',	189),
(3136,	'Fiorentino',	189),
(3137,	'Montegiardino',	189),
(3138,	'San Marino',	189),
(3139,	'Serravalle',	189),
(3140,	'Agua Grande',	190),
(3141,	'Cantagalo',	190),
(3142,	'Lemba',	190),
(3143,	'Lobata',	190),
(3144,	'Me-Zochi',	190),
(3145,	'Pague',	190),
(3146,	'Al Khobar',	191),
(3147,	'Aseer',	191),
(3148,	'Ash Sharqiyah',	191),
(3149,	'Asir',	191),
(3150,	'Central Province',	191),
(3151,	'Eastern Province',	191),
(3152,	'Ha\'il',	191),
(3153,	'Jawf',	191),
(3154,	'Jizan',	191),
(3155,	'Makkah',	191),
(3156,	'Najran',	191),
(3157,	'Qasim',	191),
(3158,	'Tabuk',	191),
(3159,	'Western Province',	191),
(3160,	'al-Bahah',	191),
(3161,	'al-Hudud-ash-Shamaliyah',	191),
(3162,	'al-Madinah',	191),
(3163,	'ar-Riyad',	191),
(3164,	'Dakar',	192),
(3165,	'Diourbel',	192),
(3166,	'Fatick',	192),
(3167,	'Kaolack',	192),
(3168,	'Kolda',	192),
(3169,	'Louga',	192),
(3170,	'Saint-Louis',	192),
(3171,	'Tambacounda',	192),
(3172,	'Thies',	192),
(3173,	'Ziguinchor',	192),
(3174,	'Central Serbia',	193),
(3175,	'Kosovo and Metohija',	193),
(3176,	'Vojvodina',	193),
(3177,	'Anse Boileau',	194),
(3178,	'Anse Royale',	194),
(3179,	'Cascade',	194),
(3180,	'Takamaka',	194),
(3181,	'Victoria',	194),
(3182,	'Eastern',	195),
(3183,	'Northern',	195),
(3184,	'Southern',	195),
(3185,	'Western',	195),
(3186,	'Singapore',	196),
(3187,	'Banskobystricky',	197),
(3188,	'Bratislavsky',	197),
(3189,	'Kosicky',	197),
(3190,	'Nitriansky',	197),
(3191,	'Presovsky',	197),
(3192,	'Trenciansky',	197),
(3193,	'Trnavsky',	197),
(3194,	'Zilinsky',	197),
(3195,	'Benedikt',	198),
(3196,	'Gorenjska',	198),
(3197,	'Gorishka',	198),
(3198,	'Jugovzhodna Slovenija',	198),
(3199,	'Koroshka',	198),
(3200,	'Notranjsko-krashka',	198),
(3201,	'Obalno-krashka',	198),
(3202,	'Obcina Domzale',	198),
(3203,	'Obcina Vitanje',	198),
(3204,	'Osrednjeslovenska',	198),
(3205,	'Podravska',	198),
(3206,	'Pomurska',	198),
(3207,	'Savinjska',	198),
(3208,	'Slovenian Littoral',	198),
(3209,	'Spodnjeposavska',	198),
(3210,	'Zasavska',	198),
(3211,	'Pitcairn',	199),
(3212,	'Central',	200),
(3213,	'Choiseul',	200),
(3214,	'Guadalcanal',	200),
(3215,	'Isabel',	200),
(3216,	'Makira and Ulawa',	200),
(3217,	'Malaita',	200),
(3218,	'Rennell and Bellona',	200),
(3219,	'Temotu',	200),
(3220,	'Western',	200),
(3221,	'Awdal',	201),
(3222,	'Bakol',	201),
(3223,	'Banadir',	201),
(3224,	'Bari',	201),
(3225,	'Bay',	201),
(3226,	'Galgudug',	201),
(3227,	'Gedo',	201),
(3228,	'Hiran',	201),
(3229,	'Jubbada Hose',	201),
(3230,	'Jubbadha Dexe',	201),
(3231,	'Mudug',	201),
(3232,	'Nugal',	201),
(3233,	'Sanag',	201),
(3234,	'Shabellaha Dhexe',	201),
(3235,	'Shabellaha Hose',	201),
(3236,	'Togdher',	201),
(3237,	'Woqoyi Galbed',	201),
(3238,	'Eastern Cape',	202),
(3239,	'Free State',	202),
(3240,	'Gauteng',	202),
(3241,	'Kempton Park',	202),
(3242,	'Kramerville',	202),
(3243,	'KwaZulu Natal',	202),
(3244,	'Limpopo',	202),
(3245,	'Mpumalanga',	202),
(3246,	'North West',	202),
(3247,	'Northern Cape',	202),
(3248,	'Parow',	202),
(3249,	'Table View',	202),
(3250,	'Umtentweni',	202),
(3251,	'Western Cape',	202),
(3252,	'South Georgia',	203),
(3253,	'Central Equatoria',	204),
(3254,	'A Coruna',	205),
(3255,	'Alacant',	205),
(3256,	'Alava',	205),
(3257,	'Albacete',	205),
(3258,	'Almeria',	205),
(3260,	'Asturias',	205),
(3261,	'Avila',	205),
(3262,	'Badajoz',	205),
(3263,	'Balears',	205),
(3264,	'Barcelona',	205),
(3267,	'Burgos',	205),
(3268,	'Caceres',	205),
(3269,	'Cadiz',	205),
(3270,	'Cantabria',	205),
(3271,	'Castello',	205),
(3273,	'Ceuta',	205),
(3274,	'Ciudad Real',	205),
(3281,	'Cordoba',	205),
(3282,	'Cuenca',	205),
(3284,	'Girona',	205),
(3285,	'Granada',	205),
(3286,	'Guadalajara',	205),
(3287,	'Guipuzcoa',	205),
(3288,	'Huelva',	205),
(3289,	'Huesca',	205),
(3290,	'Jaen',	205),
(3291,	'La Rioja',	205),
(3292,	'Las Palmas',	205),
(3293,	'Leon',	205),
(3295,	'Lleida',	205),
(3296,	'Lugo',	205),
(3297,	'Madrid',	205),
(3298,	'Malaga',	205),
(3299,	'Melilla',	205),
(3300,	'Murcia',	205),
(3301,	'Navarra',	205),
(3302,	'Ourense',	205),
(3303,	'Pais Vasco',	205),
(3304,	'Palencia',	205),
(3305,	'Pontevedra',	205),
(3306,	'Salamanca',	205),
(3308,	'Segovia',	205),
(3309,	'Sevilla',	205),
(3310,	'Soria',	205),
(3311,	'Tarragona',	205),
(3312,	'Santa Cruz de Tenerife',	205),
(3313,	'Teruel',	205),
(3314,	'Toledo',	205),
(3315,	'Valencia',	205),
(3316,	'Valladolid',	205),
(3317,	'Vizcaya',	205),
(3318,	'Zamora',	205),
(3319,	'Zaragoza',	205),
(3320,	'Amparai',	206),
(3321,	'Anuradhapuraya',	206),
(3322,	'Badulla',	206),
(3323,	'Boralesgamuwa',	206),
(3324,	'Colombo',	206),
(3325,	'Galla',	206),
(3326,	'Gampaha',	206),
(3327,	'Hambantota',	206),
(3328,	'Kalatura',	206),
(3329,	'Kegalla',	206),
(3330,	'Kilinochchi',	206),
(3331,	'Kurunegala',	206),
(3332,	'Madakalpuwa',	206),
(3333,	'Maha Nuwara',	206),
(3334,	'Malwana',	206),
(3335,	'Mannarama',	206),
(3336,	'Matale',	206),
(3337,	'Matara',	206),
(3338,	'Monaragala',	206),
(3339,	'Mullaitivu',	206),
(3340,	'North Eastern Province',	206),
(3341,	'North Western Province',	206),
(3342,	'Nuwara Eliya',	206),
(3343,	'Polonnaruwa',	206),
(3344,	'Puttalama',	206),
(3345,	'Ratnapuraya',	206),
(3346,	'Southern Province',	206),
(3347,	'Tirikunamalaya',	206),
(3348,	'Tuscany',	206),
(3349,	'Vavuniyawa',	206),
(3350,	'Western Province',	206),
(3351,	'Yapanaya',	206),
(3352,	'kadawatha',	206),
(3353,	'A\'ali-an-Nil',	207),
(3354,	'Bahr-al-Jabal',	207),
(3355,	'Central Equatoria',	207),
(3356,	'Gharb Bahr-al-Ghazal',	207),
(3357,	'Gharb Darfur',	207),
(3358,	'Gharb Kurdufan',	207),
(3359,	'Gharb-al-Istiwa\'iyah',	207),
(3360,	'Janub Darfur',	207),
(3361,	'Janub Kurdufan',	207),
(3362,	'Junqali',	207),
(3363,	'Kassala',	207),
(3364,	'Nahr-an-Nil',	207),
(3365,	'Shamal Bahr-al-Ghazal',	207),
(3366,	'Shamal Darfur',	207),
(3367,	'Shamal Kurdufan',	207),
(3368,	'Sharq-al-Istiwa\'iyah',	207),
(3369,	'Sinnar',	207),
(3370,	'Warab',	207),
(3371,	'Wilayat al Khartum',	207),
(3372,	'al-Bahr-al-Ahmar',	207),
(3373,	'al-Buhayrat',	207),
(3374,	'al-Jazirah',	207),
(3375,	'al-Khartum',	207),
(3376,	'al-Qadarif',	207),
(3377,	'al-Wahdah',	207),
(3378,	'an-Nil-al-Abyad',	207),
(3379,	'an-Nil-al-Azraq',	207),
(3380,	'ash-Shamaliyah',	207),
(3381,	'Brokopondo',	208),
(3382,	'Commewijne',	208),
(3383,	'Coronie',	208),
(3384,	'Marowijne',	208),
(3385,	'Nickerie',	208),
(3386,	'Para',	208),
(3387,	'Paramaribo',	208),
(3388,	'Saramacca',	208),
(3389,	'Wanica',	208),
(3390,	'Svalbard',	209),
(3391,	'Hhohho',	210),
(3392,	'Lubombo',	210),
(3393,	'Manzini',	210),
(3394,	'Shiselweni',	210),
(3395,	'Alvsborgs Lan',	211),
(3396,	'Angermanland',	211),
(3397,	'Blekinge',	211),
(3398,	'Bohuslan',	211),
(3399,	'Dalarna',	211),
(3400,	'Gavleborg',	211),
(3401,	'Gaza',	211),
(3402,	'Gotland',	211),
(3403,	'Halland',	211),
(3404,	'Jamtland',	211),
(3405,	'Jonkoping',	211),
(3406,	'Kalmar',	211),
(3407,	'Kristianstads',	211),
(3408,	'Kronoberg',	211),
(3409,	'Norrbotten',	211),
(3410,	'Orebro',	211),
(3411,	'Ostergotland',	211),
(3412,	'Saltsjo-Boo',	211),
(3413,	'Skane',	211),
(3414,	'Smaland',	211),
(3415,	'Sodermanland',	211),
(3416,	'Stockholm',	211),
(3417,	'Uppsala',	211),
(3418,	'Varmland',	211),
(3419,	'Vasterbotten',	211),
(3420,	'Vastergotland',	211),
(3421,	'Vasternorrland',	211),
(3422,	'Vastmanland',	211),
(3423,	'Vastra Gotaland',	211),
(3424,	'Aargau',	212),
(3425,	'Appenzell Inner-Rhoden',	212),
(3426,	'Appenzell-Ausser Rhoden',	212),
(3427,	'Basel-Landschaft',	212),
(3428,	'Basel-Stadt',	212),
(3429,	'Bern',	212),
(3430,	'Canton Ticino',	212),
(3431,	'Fribourg',	212),
(3432,	'Geneve',	212),
(3433,	'Glarus',	212),
(3434,	'Graubunden',	212),
(3435,	'Heerbrugg',	212),
(3436,	'Jura',	212),
(3437,	'Kanton Aargau',	212),
(3438,	'Luzern',	212),
(3439,	'Morbio Inferiore',	212),
(3440,	'Muhen',	212),
(3441,	'Neuchatel',	212),
(3442,	'Nidwalden',	212),
(3443,	'Obwalden',	212),
(3444,	'Sankt Gallen',	212),
(3445,	'Schaffhausen',	212),
(3446,	'Schwyz',	212),
(3447,	'Solothurn',	212),
(3448,	'Thurgau',	212),
(3449,	'Ticino',	212),
(3450,	'Uri',	212),
(3451,	'Valais',	212),
(3452,	'Vaud',	212),
(3453,	'Vauffelin',	212),
(3454,	'Zug',	212),
(3455,	'Zurich',	212),
(3456,	'Aleppo',	213),
(3457,	'Dar\'a',	213),
(3458,	'Dayr-az-Zawr',	213),
(3459,	'Dimashq',	213),
(3460,	'Halab',	213),
(3461,	'Hamah',	213),
(3462,	'Hims',	213),
(3463,	'Idlib',	213),
(3464,	'Madinat Dimashq',	213),
(3465,	'Tartus',	213),
(3466,	'al-Hasakah',	213),
(3467,	'al-Ladhiqiyah',	213),
(3468,	'al-Qunaytirah',	213),
(3469,	'ar-Raqqah',	213),
(3470,	'as-Suwayda',	213),
(3471,	'Changhua County',	214),
(3472,	'Chiayi County',	214),
(3473,	'Chiayi City',	214),
(3474,	'Taipei City',	214),
(3475,	'Hsinchu County',	214),
(3476,	'Hsinchu City',	214),
(3477,	'Hualien County',	214),
(3480,	'Kaohsiung City',	214),
(3481,	'Keelung City',	214),
(3482,	'Kinmen County',	214),
(3483,	'Miaoli County',	214),
(3484,	'Nantou County',	214),
(3486,	'Penghu County',	214),
(3487,	'Pingtung County',	214),
(3488,	'Taichung City',	214),
(3492,	'Tainan City',	214),
(3493,	'New Taipei City',	214),
(3495,	'Taitung County',	214),
(3496,	'Taoyuan City',	214),
(3497,	'Yilan County',	214),
(3498,	'YunLin County',	214),
(3500,	'Dushanbe',	215),
(3501,	'Gorno-Badakhshan',	215),
(3502,	'Karotegin',	215),
(3503,	'Khatlon',	215),
(3504,	'Sughd',	215),
(3505,	'Arusha',	216),
(3506,	'Dar es Salaam',	216),
(3507,	'Dodoma',	216),
(3508,	'Iringa',	216),
(3509,	'Kagera',	216),
(3510,	'Kigoma',	216),
(3511,	'Kilimanjaro',	216),
(3512,	'Lindi',	216),
(3513,	'Mara',	216),
(3514,	'Mbeya',	216),
(3515,	'Morogoro',	216),
(3516,	'Mtwara',	216),
(3517,	'Mwanza',	216),
(3518,	'Pwani',	216),
(3519,	'Rukwa',	216),
(3520,	'Ruvuma',	216),
(3521,	'Shinyanga',	216),
(3522,	'Singida',	216),
(3523,	'Tabora',	216),
(3524,	'Tanga',	216),
(3525,	'Zanzibar and Pemba',	216),
(3526,	'Amnat Charoen',	217),
(3527,	'Ang Thong',	217),
(3528,	'Bangkok',	217),
(3529,	'Buri Ram',	217),
(3530,	'Chachoengsao',	217),
(3531,	'Chai Nat',	217),
(3532,	'Chaiyaphum',	217),
(3533,	'Changwat Chaiyaphum',	217),
(3534,	'Chanthaburi',	217),
(3535,	'Chiang Mai',	217),
(3536,	'Chiang Rai',	217),
(3537,	'Chon Buri',	217),
(3538,	'Chumphon',	217),
(3539,	'Kalasin',	217),
(3540,	'Kamphaeng Phet',	217),
(3541,	'Kanchanaburi',	217),
(3542,	'Khon Kaen',	217),
(3543,	'Krabi',	217),
(3544,	'Krung Thep',	217),
(3545,	'Lampang',	217),
(3546,	'Lamphun',	217),
(3547,	'Loei',	217),
(3548,	'Lop Buri',	217),
(3549,	'Mae Hong Son',	217),
(3550,	'Maha Sarakham',	217),
(3551,	'Mukdahan',	217),
(3552,	'Nakhon Nayok',	217),
(3553,	'Nakhon Pathom',	217),
(3554,	'Nakhon Phanom',	217),
(3555,	'Nakhon Ratchasima',	217),
(3556,	'Nakhon Sawan',	217),
(3557,	'Nakhon Si Thammarat',	217),
(3558,	'Nan',	217),
(3559,	'Narathiwat',	217),
(3560,	'Nong Bua Lam Phu',	217),
(3561,	'Nong Khai',	217),
(3562,	'Nonthaburi',	217),
(3563,	'Pathum Thani',	217),
(3564,	'Pattani',	217),
(3565,	'Phangnga',	217),
(3566,	'Phatthalung',	217),
(3567,	'Phayao',	217),
(3568,	'Phetchabun',	217),
(3569,	'Phetchaburi',	217),
(3570,	'Phichit',	217),
(3571,	'Phitsanulok',	217),
(3572,	'Phra Nakhon Si Ayutthaya',	217),
(3573,	'Phrae',	217),
(3574,	'Phuket',	217),
(3575,	'Prachin Buri',	217),
(3576,	'Prachuap Khiri Khan',	217),
(3577,	'Ranong',	217),
(3578,	'Ratchaburi',	217),
(3579,	'Rayong',	217),
(3580,	'Roi Et',	217),
(3581,	'Sa Kaeo',	217),
(3582,	'Sakon Nakhon',	217),
(3583,	'Samut Prakan',	217),
(3584,	'Samut Sakhon',	217),
(3585,	'Samut Songkhran',	217),
(3586,	'Saraburi',	217),
(3587,	'Satun',	217),
(3588,	'Si Sa Ket',	217),
(3589,	'Sing Buri',	217),
(3590,	'Songkhla',	217),
(3591,	'Sukhothai',	217),
(3592,	'Suphan Buri',	217),
(3593,	'Surat Thani',	217),
(3594,	'Surin',	217),
(3595,	'Tak',	217),
(3596,	'Trang',	217),
(3597,	'Trat',	217),
(3598,	'Ubon Ratchathani',	217),
(3599,	'Udon Thani',	217),
(3600,	'Uthai Thani',	217),
(3601,	'Uttaradit',	217),
(3602,	'Yala',	217),
(3603,	'Yasothon',	217),
(3604,	'Centre',	218),
(3605,	'Kara',	218),
(3606,	'Maritime',	218),
(3607,	'Plateaux',	218),
(3608,	'Savanes',	218),
(3609,	'Atafu',	219),
(3610,	'Fakaofo',	219),
(3611,	'Nukunonu',	219),
(3612,	'Eua',	220),
(3613,	'Ha\'apai',	220),
(3614,	'Niuas',	220),
(3615,	'Tongatapu',	220),
(3616,	'Vava\'u',	220),
(3617,	'Arima-Tunapuna-Piarco',	221),
(3618,	'Caroni',	221),
(3619,	'Chaguanas',	221),
(3620,	'Couva-Tabaquite-Talparo',	221),
(3621,	'Diego Martin',	221),
(3622,	'Glencoe',	221),
(3623,	'Penal Debe',	221),
(3624,	'Point Fortin',	221),
(3625,	'Port of Spain',	221),
(3626,	'Princes Town',	221),
(3627,	'Saint George',	221),
(3628,	'San Fernando',	221),
(3629,	'San Juan',	221),
(3630,	'Sangre Grande',	221),
(3631,	'Siparia',	221),
(3632,	'Tobago',	221),
(3633,	'Aryanah',	222),
(3634,	'Bajah',	222),
(3635,	'Bin \'Arus',	222),
(3636,	'Binzart',	222),
(3637,	'Gouvernorat de Ariana',	222),
(3638,	'Gouvernorat de Nabeul',	222),
(3639,	'Gouvernorat de Sousse',	222),
(3640,	'Hammamet Yasmine',	222),
(3641,	'Jundubah',	222),
(3642,	'Madaniyin',	222),
(3643,	'Manubah',	222),
(3644,	'Monastir',	222),
(3645,	'Nabul',	222),
(3646,	'Qabis',	222),
(3647,	'Qafsah',	222),
(3648,	'Qibili',	222),
(3649,	'Safaqis',	222),
(3650,	'Sfax',	222),
(3651,	'Sidi Bu Zayd',	222),
(3652,	'Silyanah',	222),
(3653,	'Susah',	222),
(3654,	'Tatawin',	222),
(3655,	'Tawzar',	222),
(3656,	'Tunis',	222),
(3657,	'Zaghwan',	222),
(3658,	'al-Kaf',	222),
(3659,	'al-Mahdiyah',	222),
(3660,	'al-Munastir',	222),
(3661,	'al-Qasrayn',	222),
(3662,	'al-Qayrawan',	222),
(3663,	'Adana',	223),
(3664,	'Adiyaman',	223),
(3665,	'Afyon',	223),
(3666,	'Agri',	223),
(3667,	'Aksaray',	223),
(3668,	'Amasya',	223),
(3669,	'Ankara',	223),
(3670,	'Antalya',	223),
(3671,	'Ardahan',	223),
(3672,	'Artvin',	223),
(3673,	'Aydin',	223),
(3674,	'Balikesir',	223),
(3675,	'Bartin',	223),
(3676,	'Batman',	223),
(3677,	'Bayburt',	223),
(3678,	'Bilecik',	223),
(3679,	'Bingol',	223),
(3680,	'Bitlis',	223),
(3681,	'Bolu',	223),
(3682,	'Burdur',	223),
(3683,	'Bursa',	223),
(3684,	'Canakkale',	223),
(3685,	'Cankiri',	223),
(3686,	'Corum',	223),
(3687,	'Denizli',	223),
(3688,	'Diyarbakir',	223),
(3689,	'Duzce',	223),
(3690,	'Edirne',	223),
(3691,	'Elazig',	223),
(3692,	'Erzincan',	223),
(3693,	'Erzurum',	223),
(3694,	'Eskisehir',	223),
(3695,	'Gaziantep',	223),
(3696,	'Giresun',	223),
(3697,	'Gumushane',	223),
(3698,	'Hakkari',	223),
(3699,	'Hatay',	223),
(3700,	'Icel',	223),
(3701,	'Igdir',	223),
(3702,	'Isparta',	223),
(3703,	'Istanbul',	223),
(3704,	'Izmir',	223),
(3705,	'Kahramanmaras',	223),
(3706,	'Karabuk',	223),
(3707,	'Karaman',	223),
(3708,	'Kars',	223),
(3709,	'Karsiyaka',	223),
(3710,	'Kastamonu',	223),
(3711,	'Kayseri',	223),
(3712,	'Kilis',	223),
(3713,	'Kirikkale',	223),
(3714,	'Kirklareli',	223),
(3715,	'Kirsehir',	223),
(3716,	'Kocaeli',	223),
(3717,	'Konya',	223),
(3718,	'Kutahya',	223),
(3719,	'Lefkosa',	223),
(3720,	'Malatya',	223),
(3721,	'Manisa',	223),
(3722,	'Mardin',	223),
(3723,	'Mugla',	223),
(3724,	'Mus',	223),
(3725,	'Nevsehir',	223),
(3726,	'Nigde',	223),
(3727,	'Ordu',	223),
(3728,	'Osmaniye',	223),
(3729,	'Rize',	223),
(3730,	'Sakarya',	223),
(3731,	'Samsun',	223),
(3732,	'Sanliurfa',	223),
(3733,	'Siirt',	223),
(3734,	'Sinop',	223),
(3735,	'Sirnak',	223),
(3736,	'Sivas',	223),
(3737,	'Tekirdag',	223),
(3738,	'Tokat',	223),
(3739,	'Trabzon',	223),
(3740,	'Tunceli',	223),
(3741,	'Usak',	223),
(3742,	'Van',	223),
(3743,	'Yalova',	223),
(3744,	'Yozgat',	223),
(3745,	'Zonguldak',	223),
(3746,	'Ahal',	224),
(3747,	'Asgabat',	224),
(3748,	'Balkan',	224),
(3749,	'Dasoguz',	224),
(3750,	'Lebap',	224),
(3751,	'Mari',	224),
(3752,	'Grand Turk',	225),
(3753,	'South Caicos and East Caicos',	225),
(3754,	'Funafuti',	226),
(3755,	'Nanumanga',	226),
(3756,	'Nanumea',	226),
(3757,	'Niutao',	226),
(3758,	'Nui',	226),
(3759,	'Nukufetau',	226),
(3760,	'Nukulaelae',	226),
(3761,	'Vaitupu',	226),
(3762,	'Central',	227),
(3763,	'Eastern',	227),
(3764,	'Northern',	227),
(3765,	'Western',	227),
(3766,	'Cherkas\'ka',	228),
(3767,	'Chernihivs\'ka',	228),
(3768,	'Chernivets\'ka',	228),
(3769,	'Crimea',	228),
(3770,	'Dnipropetrovska',	228),
(3771,	'Donets\'ka',	228),
(3772,	'Ivano-Frankivs\'ka',	228),
(3773,	'Kharkiv',	228),
(3774,	'Kharkov',	228),
(3775,	'Khersonska',	228),
(3776,	'Khmel\'nyts\'ka',	228),
(3777,	'Kirovohrad',	228),
(3778,	'Krym',	228),
(3779,	'Kyyiv',	228),
(3780,	'Kyyivs\'ka',	228),
(3781,	'L\'vivs\'ka',	228),
(3782,	'Luhans\'ka',	228),
(3783,	'Mykolayivs\'ka',	228),
(3784,	'Odes\'ka',	228),
(3785,	'Odessa',	228),
(3786,	'Poltavs\'ka',	228),
(3787,	'Rivnens\'ka',	228),
(3788,	'Sevastopol\'',	228),
(3789,	'Sums\'ka',	228),
(3790,	'Ternopil\'s\'ka',	228),
(3791,	'Volyns\'ka',	228),
(3792,	'Vynnyts\'ka',	228),
(3793,	'Zakarpats\'ka',	228),
(3794,	'Zaporizhia',	228),
(3795,	'Zhytomyrs\'ka',	228),
(3796,	'Abu Zabi',	229),
(3797,	'Ajman',	229),
(3798,	'Dubai',	229),
(3799,	'Ras al-Khaymah',	229),
(3800,	'Sharjah',	229),
(3801,	'Sharjha',	229),
(3802,	'Umm al Qaywayn',	229),
(3803,	'al-Fujayrah',	229),
(3804,	'ash-Shariqah',	229),
(3919,	'Alabama',	231),
(3920,	'Alaska',	231),
(3921,	'Arizona',	231),
(3922,	'Arkansas',	231),
(3923,	'Byram',	231),
(3924,	'California',	231),
(3925,	'Cokato',	231),
(3926,	'Colorado',	231),
(3927,	'Connecticut',	231),
(3928,	'Delaware',	231),
(3929,	'District of Columbia',	231),
(3930,	'Florida',	231),
(3931,	'Georgia',	231),
(3932,	'Hawaii',	231),
(3933,	'Idaho',	231),
(3934,	'Illinois',	231),
(3935,	'Indiana',	231),
(3936,	'Iowa',	231),
(3937,	'Kansas',	231),
(3938,	'Kentucky',	231),
(3939,	'Louisiana',	231),
(3940,	'Lowa',	231),
(3941,	'Maine',	231),
(3942,	'Maryland',	231),
(3943,	'Massachusetts',	231),
(3944,	'Medfield',	231),
(3945,	'Michigan',	231),
(3946,	'Minnesota',	231),
(3947,	'Mississippi',	231),
(3948,	'Missouri',	231),
(3949,	'Montana',	231),
(3950,	'Nebraska',	231),
(3951,	'Nevada',	231),
(3952,	'New Hampshire',	231),
(3953,	'New Jersey',	231),
(3954,	'New Jersy',	231),
(3955,	'New Mexico',	231),
(3956,	'New York',	231),
(3957,	'North Carolina',	231),
(3958,	'North Dakota',	231),
(3959,	'Ohio',	231),
(3960,	'Oklahoma',	231),
(3961,	'Ontario',	231),
(3962,	'Oregon',	231),
(3963,	'Pennsylvania',	231),
(3964,	'Ramey',	231),
(3965,	'Rhode Island',	231),
(3966,	'South Carolina',	231),
(3967,	'South Dakota',	231),
(3968,	'Sublimity',	231),
(3969,	'Tennessee',	231),
(3970,	'Texas',	231),
(3971,	'Trimble',	231),
(3972,	'Utah',	231),
(3973,	'Vermont',	231),
(3974,	'Virginia',	231),
(3975,	'Washington',	231),
(3976,	'West Virginia',	231),
(3977,	'Wisconsin',	231),
(3978,	'Wyoming',	231),
(3979,	'United States Minor Outlying I',	232),
(3980,	'Artigas',	233),
(3981,	'Canelones',	233),
(3982,	'Cerro Largo',	233),
(3983,	'Colonia',	233),
(3984,	'Durazno',	233),
(3985,	'FLorida',	233),
(3986,	'Flores',	233),
(3987,	'Lavalleja',	233),
(3988,	'Maldonado',	233),
(3989,	'Montevideo',	233),
(3990,	'Paysandu',	233),
(3991,	'Rio Negro',	233),
(3992,	'Rivera',	233),
(3993,	'Rocha',	233),
(3994,	'Salto',	233),
(3995,	'San Jose',	233),
(3996,	'Soriano',	233),
(3997,	'Tacuarembo',	233),
(3998,	'Treinta y Tres',	233),
(3999,	'Andijon',	234),
(4000,	'Buhoro',	234),
(4001,	'Buxoro Viloyati',	234),
(4002,	'Cizah',	234),
(4003,	'Fargona',	234),
(4004,	'Horazm',	234),
(4005,	'Kaskadar',	234),
(4006,	'Korakalpogiston',	234),
(4007,	'Namangan',	234),
(4008,	'Navoi',	234),
(4009,	'Samarkand',	234),
(4010,	'Sirdare',	234),
(4011,	'Surhondar',	234),
(4012,	'Toskent',	234),
(4013,	'Malampa',	235),
(4014,	'Penama',	235),
(4015,	'Sanma',	235),
(4016,	'Shefa',	235),
(4017,	'Tafea',	235),
(4018,	'Torba',	235),
(4019,	'Vatican City State (Holy See)',	236),
(4020,	'Amazonas',	237),
(4021,	'Anzoategui',	237),
(4022,	'Apure',	237),
(4023,	'Aragua',	237),
(4024,	'Barinas',	237),
(4025,	'Bolivar',	237),
(4026,	'Carabobo',	237),
(4027,	'Cojedes',	237),
(4028,	'Delta Amacuro',	237),
(4029,	'Distrito Federal',	237),
(4030,	'Falcon',	237),
(4031,	'Guarico',	237),
(4032,	'Lara',	237),
(4033,	'Merida',	237),
(4034,	'Miranda',	237),
(4035,	'Monagas',	237),
(4036,	'Nueva Esparta',	237),
(4037,	'Portuguesa',	237),
(4038,	'Sucre',	237),
(4039,	'Tachira',	237),
(4040,	'Trujillo',	237),
(4041,	'Vargas',	237),
(4042,	'Yaracuy',	237),
(4043,	'Zulia',	237),
(4044,	'Bac Giang',	238),
(4045,	'Binh Dinh',	238),
(4046,	'Binh Duong',	238),
(4047,	'Da Nang',	238),
(4048,	'Dong Bang Song Cuu Long',	238),
(4049,	'Dong Bang Song Hong',	238),
(4050,	'Dong Nai',	238),
(4051,	'Dong Nam Bo',	238),
(4052,	'Duyen Hai Mien Trung',	238),
(4053,	'Hanoi',	238),
(4054,	'Hung Yen',	238),
(4055,	'Khu Bon Cu',	238),
(4056,	'Long An',	238),
(4057,	'Mien Nui Va Trung Du',	238),
(4058,	'Thai Nguyen',	238),
(4059,	'Thanh Pho Ho Chi Minh',	238),
(4060,	'Thu Do Ha Noi',	238),
(4061,	'Tinh Can Tho',	238),
(4062,	'Tinh Da Nang',	238),
(4063,	'Tinh Gia Lai',	238),
(4064,	'Anegada',	239),
(4065,	'Jost van Dyke',	239),
(4066,	'Tortola',	239),
(4067,	'Saint Croix',	240),
(4068,	'Saint John',	240),
(4069,	'Saint Thomas',	240),
(4070,	'Alo',	241),
(4071,	'Singave',	241),
(4072,	'Wallis',	241),
(4073,	'Bu Jaydur',	242),
(4074,	'Wad-adh-Dhahab',	242),
(4075,	'al-\'Ayun',	242),
(4076,	'as-Samarah',	242),
(4077,	'\'Adan',	243),
(4078,	'Abyan',	243),
(4079,	'Dhamar',	243),
(4080,	'Hadramaut',	243),
(4081,	'Hajjah',	243),
(4082,	'Hudaydah',	243),
(4083,	'Ibb',	243),
(4084,	'Lahij',	243),
(4085,	'Ma\'rib',	243),
(4086,	'Madinat San\'a',	243),
(4087,	'Sa\'dah',	243),
(4088,	'Sana',	243),
(4089,	'Shabwah',	243),
(4090,	'Ta\'izz',	243),
(4091,	'al-Bayda',	243),
(4092,	'al-Hudaydah',	243),
(4093,	'al-Jawf',	243),
(4094,	'al-Mahrah',	243),
(4095,	'al-Mahwit',	243),
(4096,	'Central Serbia',	244),
(4097,	'Kosovo and Metohija',	244),
(4098,	'Montenegro',	244),
(4099,	'Republic of Serbia',	244),
(4100,	'Serbia',	244),
(4101,	'Vojvodina',	244),
(4102,	'Central',	245),
(4103,	'Copperbelt',	245),
(4104,	'Eastern',	245),
(4105,	'Luapala',	245),
(4106,	'Lusaka',	245),
(4107,	'North-Western',	245),
(4108,	'Northern',	245),
(4109,	'Southern',	245),
(4110,	'Western',	245),
(4111,	'Bulawayo',	246),
(4112,	'Harare',	246),
(4113,	'Manicaland',	246),
(4114,	'Mashonaland Central',	246),
(4115,	'Mashonaland East',	246),
(4116,	'Mashonaland West',	246),
(4117,	'Masvingo',	246),
(4118,	'Matabeleland North',	246),
(4119,	'Matabeleland South',	246),
(4120,	'Midlands',	246),
(4121,	'Lienchiang County',	214),
(4153,	'Aberdeenshire - Scotland',	230),
(4154,	'Angus - Scotland',	230),
(4155,	'Argyll and Bute - Scotland',	230),
(4156,	'Ayrshire and Arran - Scotland',	230),
(4157,	'Banffshire - Scotland',	230),
(4158,	'Bedfordshire',	230),
(4159,	'Berkshire',	230),
(4160,	'Berwickshire - Scotland',	230),
(4161,	'Bristol',	230),
(4162,	'Buckinghamshire',	230),
(4163,	'Caithness - Scotland',	230),
(4164,	'Cambridgeshire',	230),
(4165,	'Cheshire',	230),
(4166,	'City of Aberdeen - Scotland',	230),
(4167,	'City of Dundee - Scotland',	230),
(4168,	'City of Edinburgh - Scotland',	230),
(4169,	'City of Glasgow - Scotland',	230),
(4170,	'Clackmannan - Scotland',	230),
(4171,	'Clwyd - Wales',	230),
(4172,	'Cornwall',	230),
(4173,	'County Antrim - Northern Ireland',	230),
(4174,	'County Armagh - Northern Ireland',	230),
(4175,	'County Derry / Londonderry - Northern Ireland',	230),
(4176,	'County Down - Northern Ireland',	230),
(4177,	'County Fermanagh - Northern Ireland',	230),
(4178,	'County Tyrone - Northern Ireland',	230),
(4179,	'Cumbria',	230),
(4180,	'Derbyshire',	230),
(4181,	'Devon',	230),
(4182,	'Dorset',	230),
(4183,	'Dumfries - Scotland',	230),
(4184,	'Dunbartonshire - Scotland',	230),
(4185,	'Durham',	230),
(4186,	'Dyfed - Wales',	230),
(4187,	'East Lothian - Scotland',	230),
(4188,	'East Riding of Yorkshire',	230),
(4189,	'East Sussex',	230),
(4190,	'Essex',	230),
(4191,	'Fife - Scotland',	230),
(4192,	'Gloucestershire',	230),
(4193,	'London',	230),
(4194,	'Greater Manchester',	230),
(4195,	'Gwent - Wales',	230),
(4196,	'Gwynedd - Wales',	230),
(4197,	'Hampshire',	230),
(4198,	'Herefordshire',	230),
(4199,	'Hertfordshire',	230),
(4200,	'Inverness - Scotland',	230),
(4201,	'Isle of Man - Isle of Man',	230),
(4202,	'Isle of Wight',	230),
(4203,	'Kent',	230),
(4204,	'Kincardineshire - Scotland',	230),
(4205,	'Lanarkshire - Scotland',	230),
(4206,	'Lancashire',	230),
(4207,	'Leicestershire',	230),
(4208,	'Lincolnshire',	230),
(4209,	'Merseyside',	230),
(4210,	'Mid Glamorgan - Wales',	230),
(4211,	'Midlothian - Scotland',	230),
(4212,	'Moray - Scotland',	230),
(4213,	'Nairn - Scotland',	230),
(4214,	'Norfolk',	230),
(4215,	'North Yorkshire',	230),
(4216,	'Northamptonshire',	230),
(4217,	'Northumberland',	230),
(4218,	'Nottinghamshire',	230),
(4219,	'Orkney - Scotland',	230),
(4220,	'Oxfordshire',	230),
(4221,	'Perth and Kinross - Scotland',	230),
(4222,	'Powys - Wales',	230),
(4223,	'Renfrewshire - Scotland',	230),
(4224,	'Ross and Cromarty - Scotland',	230),
(4225,	'Roxburgh, Ettrick and Lauderdale - Scotland',	230),
(4226,	'Rutland',	230),
(4227,	'Shetland - Scotland',	230),
(4228,	'Shropshire',	230),
(4229,	'Somerset',	230),
(4230,	'South Glamorgan - Wales',	230),
(4231,	'South Yorkshire',	230),
(4232,	'Staffordshire',	230),
(4233,	'Stirling and Falkirk - Scotland',	230),
(4234,	'Suffolk',	230),
(4235,	'Surrey',	230),
(4236,	'Sutherland - Scotland',	230),
(4237,	'The Stewartry of Kirkcudbright - Scotland',	230),
(4238,	'Tweeddale - Scotland',	230),
(4239,	'Tyne and Wear',	230),
(4240,	'Warwickshire',	230),
(4241,	'West Glamorgan - Wales',	230),
(4242,	'West Lothian - Scotland',	230),
(4243,	'West Midlands',	230),
(4244,	'West Sussex',	230),
(4245,	'West Yorkshire',	230),
(4246,	'Western Isles - Scotland',	230),
(4247,	'Wigtown - Scotland',	230),
(4248,	'Wiltshire',	230),
(4249,	'Worcestershire',	230),
(4250,	'Lazio',	107),
(4251,	'Lombardy',	107),
(4252,	'Campania',	107),
(4253,	'Piedmont',	107),
(4254,	'Sicilia',	107),
(4255,	'Liguria',	107),
(4256,	'Emilia-Romagna',	107),
(4257,	'Tuscany',	107),
(4258,	'Puglia',	107),
(4259,	'Veneto',	107),
(4260,	'Friuli-Venezia Giulia',	107),
(4261,	'Calabria',	107),
(4262,	'Umbria',	107),
(4263,	'Sardegna',	107),
(4264,	'Abruzzo',	107),
(4265,	'Trentino-Alto Adige',	107),
(4266,	'Marche',	107),
(4267,	'Basilicata',	107),
(4268,	'Molise',	107),
(4269,	'Valle d’Aosta',	107),
(4270,	'Ferrara',	107),
(4271,	'La Spezia',	107),
(4272,	'Mantova',	107),
(4273,	'Trapani',	107),
(4274,	'Oslo',	164),
(4275,	'Hordaland',	164),
(4276,	'Sør-Trøndelag',	164),
(4277,	'Rogaland',	164),
(4278,	'Buskerud',	164),
(4279,	'Vest-Agder',	164),
(4280,	'Østfold',	164),
(4281,	'Telemark',	164),
(4282,	'Vestfold',	164),
(4283,	'Akershus',	164),
(4284,	'Møre og Romsdal',	164),
(4285,	'Nordland',	164),
(4286,	'Troms',	164),
(4287,	'Hedmark',	164),
(4288,	'Aust-Agder',	164),
(4289,	'Oppland',	164),
(4290,	'Nord-Trøndelag',	164),
(4291,	'Finnmark',	164),
(4292,	'Sogn og Fjordane',	164),
(4293,	'Sudurpashchim',	153),
(4294,	'Madhesh',	153);

DROP TABLE IF EXISTS `student_assignments`;
CREATE TABLE `student_assignments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `batch_id` int(11) DEFAULT NULL,
  `assignment_id` int(11) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `file1` varchar(100) DEFAULT NULL,
  `file2` varchar(100) DEFAULT NULL,
  `file3` varchar(100) DEFAULT NULL,
  `is_reviewed` tinyint(1) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `batch_id` (`batch_id`),
  KEY `assignment_id` (`assignment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `student_course_certificate`;
CREATE TABLE `student_course_certificate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `upload_date` date NOT NULL,
  `course` enum('german','french','spanish','japanese','ielts','accent') NOT NULL,
  `certificate` varchar(150) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `student_exams`;
CREATE TABLE `student_exams` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `exam_id` int(11) NOT NULL,
  `attempt` tinyint(1) NOT NULL DEFAULT 1,
  `exam_started_at` datetime NOT NULL,
  `completed` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `student_exam_answers`;
CREATE TABLE `student_exam_answers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_exam_id` int(11) NOT NULL,
  `qa_id` int(11) NOT NULL DEFAULT 0,
  `comprehension_id` int(11) DEFAULT NULL,
  `question_model` enum('obj_essay','comprehension') NOT NULL,
  `question_type` enum('objective','essay') NOT NULL,
  `order` int(11) NOT NULL DEFAULT 999999,
  `answers` longtext NOT NULL,
  `documents` varchar(250) NOT NULL,
  `correct` tinyint(1) DEFAULT NULL,
  `corrected_by` int(11) NOT NULL DEFAULT 0 COMMENT 'tariner has updated the correct',
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `student_exam_result`;
CREATE TABLE `student_exam_result` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `exam_id` int(11) NOT NULL,
  `score` decimal(13,2) NOT NULL,
  `passed` tinyint(1) NOT NULL DEFAULT 0,
  `attempt` tinyint(4) NOT NULL DEFAULT 0,
  `attempt_date` datetime NOT NULL,
  `total_exam_marks` int(11) NOT NULL,
  `objective_marks` decimal(13,2) NOT NULL DEFAULT 0.00,
  `essay_marks` decimal(13,2) NOT NULL DEFAULT 0.00,
  `comprehension_marks` decimal(13,2) NOT NULL DEFAULT 0.00,
  `listening_marks` decimal(13,2) NOT NULL DEFAULT 0.00,
  `reading_marks` decimal(13,2) NOT NULL DEFAULT 0.00,
  `writing_marks` decimal(13,2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  KEY `batch_id` (`exam_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `student_marks`;
CREATE TABLE `student_marks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `batch_id` int(11) NOT NULL,
  `assignment_score` decimal(13,2) NOT NULL DEFAULT 0.00,
  `attendance_score` decimal(13,2) NOT NULL DEFAULT 0.00,
  `midterm_exam_score` decimal(13,2) NOT NULL DEFAULT 0.00,
  `midterm_oral_score` decimal(13,2) NOT NULL DEFAULT 0.00,
  `endterm_exam_score` decimal(13,2) NOT NULL DEFAULT 0.00,
  `endterm_oral_score` decimal(13,2) NOT NULL DEFAULT 0.00,
  `online_marks` decimal(13,2) NOT NULL DEFAULT 0.00,
  `final_score` decimal(13,2) NOT NULL DEFAULT 0.00,
  `final_percentage` decimal(13,2) NOT NULL DEFAULT 0.00,
  `total_marks` decimal(13,2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  KEY `batch_id` (`batch_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `student_online_course`;
CREATE TABLE `student_online_course` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `online_course_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL DEFAULT 0,
  `chapters_completed` varchar(1000) DEFAULT NULL COMMENT 'comma separated',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  KEY `online_course_id` (`online_course_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `student_quiz_answer`;
CREATE TABLE `student_quiz_answer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) DEFAULT NULL,
  `chapter_id` int(11) DEFAULT NULL,
  `quiz_question_id` int(11) DEFAULT NULL,
  `answer` varchar(200) DEFAULT NULL,
  `correct` tinyint(1) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  KEY `chapter_id` (`chapter_id`),
  KEY `quiz_question_id` (`quiz_question_id`),
  KEY `correct` (`correct`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `student_quiz_result`;
CREATE TABLE `student_quiz_result` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) DEFAULT NULL,
  `chapter_id` int(11) DEFAULT NULL,
  `score` int(11) DEFAULT NULL,
  `passed` tinyint(1) DEFAULT 0,
  `no_of_attempts` tinyint(1) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  KEY `chapter_id` (`chapter_id`),
  KEY `quiz_question_id` (`score`),
  KEY `correct` (`passed`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `student_webinar`;
CREATE TABLE `student_webinar` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(10) unsigned NOT NULL,
  `webinar_id` int(11) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sudent_webinar_unik` (`student_id`,`webinar_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `study_levels`;
CREATE TABLE `study_levels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `study_level` varchar(100) NOT NULL,
  `degree` enum('Pre-bachelors','Bachelors','Pre-masters','Masters','Ph.D','Others') NOT NULL,
  `display_order` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`study_level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `study_levels` (`id`, `study_level`, `degree`, `display_order`, `created_at`, `updated_at`) VALUES
(1,	'UG Diploma/ Certificate/ Associate Degree',	'Pre-bachelors',	1,	'2023-06-20 07:00:33',	'2023-06-20 07:00:33'),
(2,	'Undergraduate',	'Bachelors',	2,	'2023-06-20 07:00:51',	'2023-06-20 07:00:51'),
(3,	'PG Diploma/Certificate',	'Pre-masters',	3,	'2023-06-20 07:01:13',	'2023-06-20 07:01:13'),
(4,	'Postgraduate',	'Masters',	4,	'2023-06-20 07:01:35',	'2023-06-20 07:01:35'),
(5,	'UG+PG (Accelerated) Degree',	'Bachelors',	5,	'2023-06-20 07:02:22',	'2023-06-20 07:02:22'),
(6,	'PhD',	'Ph.D',	6,	'2023-06-20 07:03:15',	'2023-06-20 07:03:15'),
(7,	'Foundation',	'Others',	7,	'2023-06-20 07:03:45',	'2023-06-20 07:03:45'),
(8,	'Short Term Programs',	'Others',	8,	'2023-06-20 07:04:12',	'2023-06-20 07:04:12'),
(9,	'Pathway Programs',	'Others',	9,	'2023-06-20 07:04:36',	'2023-06-20 07:04:36'),
(10,	'Twinning Programmes (UG)',	'Bachelors',	10,	'2023-06-20 07:04:58',	'2023-06-20 07:04:58'),
(11,	'Twinning Programmes (PG)',	'Masters',	11,	'2023-06-20 07:06:38',	'2023-06-20 07:06:38'),
(12,	'English Language Program',	'Others',	12,	'2023-06-20 07:06:47',	'2023-06-20 07:06:47'),
(13,	'Online Programmes/ Distance Learning',	'Others',	13,	'2023-06-20 07:06:56',	'2023-06-20 07:06:56');

DROP TABLE IF EXISTS `tags`;
CREATE TABLE `tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tag_name` varchar(100) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `tag_name` (`tag_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `tax_rates`;
CREATE TABLE `tax_rates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `display_name` varchar(50) NOT NULL,
  `country` int(11) NOT NULL DEFAULT 0,
  `state` int(11) NOT NULL DEFAULT 0,
  `tax_rate` decimal(13,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `tickets`;
CREATE TABLE `tickets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ticket_id` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `userid` int(10) unsigned DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `subject` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('new','customer_reply','staff_reply','inprogress','closed') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'new',
  `assigned_to` int(11) NOT NULL DEFAULT 0,
  `updated_at` datetime DEFAULT NULL,
  `cert_request` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ticket_id_UNIQUE` (`ticket_id`),
  KEY `tickets_userid_fk` (`userid`),
  CONSTRAINT `tickets_userid_fk` FOREIGN KEY (`userid`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `ticket_reply`;
CREATE TABLE `ticket_reply` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ticket_id` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `reply_timestamp` datetime NOT NULL,
  `message` text NOT NULL,
  `reply_by` enum('user','staff') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `staff_name` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `staff_id` int(11) NOT NULL DEFAULT 0,
  `attachment_1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attachment_2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attachment_3` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attachment_4` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `all_attachment` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ticket_reply_ticket_id_fk` (`ticket_id`),
  CONSTRAINT `ticket_reply_ticket_id_fk` FOREIGN KEY (`ticket_id`) REFERENCES `tickets` (`ticket_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `trainer_attendance`;
CREATE TABLE `trainer_attendance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trainer_id` int(10) unsigned NOT NULL,
  `batch_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `topics` varchar(500) NOT NULL,
  `duration` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `trainer_id` (`trainer_id`,`batch_id`,`date`),
  KEY `batch_id_fk` (`batch_id`),
  CONSTRAINT `batch_id_fk` FOREIGN KEY (`batch_id`) REFERENCES `batch` (`id`),
  CONSTRAINT `trainer_id_fk` FOREIGN KEY (`trainer_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `trainer_student_attendance`;
CREATE TABLE `trainer_student_attendance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `batch_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `student_name` varchar(100) NOT NULL,
  `trainer_id` int(11) NOT NULL,
  `verified` tinyint(1) NOT NULL DEFAULT 0,
  `date` date NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `travel_history`;
CREATE TABLE `travel_history` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned NOT NULL DEFAULT 0,
  `country_visited` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name_used_on_country` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visa_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visa_issue_at` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_up_to` date DEFAULT NULL,
  `reason_of_visit` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `two_factor_authentications`;
CREATE TABLE `two_factor_authentications` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `authenticatable_type` varchar(255) NOT NULL,
  `authenticatable_id` bigint(20) unsigned NOT NULL,
  `shared_secret` varchar(255) NOT NULL,
  `enabled_at` timestamp NULL DEFAULT NULL,
  `label` varchar(255) NOT NULL,
  `digits` tinyint(3) unsigned NOT NULL DEFAULT 6,
  `seconds` tinyint(3) unsigned NOT NULL DEFAULT 30,
  `window` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `algorithm` varchar(16) NOT NULL DEFAULT 'sha1',
  `recovery_codes` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`recovery_codes`)),
  `recovery_codes_generated_at` timestamp NULL DEFAULT NULL,
  `safe_devices` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`safe_devices`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `2fa_auth_type_auth_id_index` (`authenticatable_type`,`authenticatable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `universities`;
CREATE TABLE `universities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `university_name` varchar(191) NOT NULL,
  `country` varchar(45) NOT NULL,
  `institution_type` enum('Level 1','Level 2','Level 3','Not applicable') DEFAULT NULL,
  `concurrent_course_allowed` enum('Yes','No','Maybe') DEFAULT NULL,
  `college_details` text DEFAULT NULL,
  `address` text DEFAULT NULL,
  `website` varchar(100) DEFAULT NULL,
  `cricos_link` varchar(150) DEFAULT NULL,
  `documents_link` varchar(150) DEFAULT NULL,
  `current_fee_list_link` varchar(150) DEFAULT NULL,
  `initial_deposit_options` varchar(150) DEFAULT NULL,
  `admission_process` varchar(150) DEFAULT NULL,
  `contact_person_name` varchar(100) DEFAULT NULL,
  `contact_person_phone` varchar(12) DEFAULT NULL,
  `contact_person_email` varchar(100) DEFAULT NULL,
  `commission_percent` decimal(13,1) DEFAULT 0.0,
  `commission_count` int(11) DEFAULT 1,
  `tax_type` enum('inclusive','exclusive') DEFAULT NULL,
  `tax_percent` decimal(13,1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `university_name` (`university_name`),
  KEY `country` (`country`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `university_application`;
CREATE TABLE `university_application` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appl_id` int(11) NOT NULL,
  `type` enum('university','visa','abroad_job') NOT NULL DEFAULT 'university',
  `userid` int(10) unsigned NOT NULL,
  `course_pref_id` int(10) unsigned DEFAULT NULL,
  `university` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `course` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `country` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `year` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `intake` tinyint(4) NOT NULL,
  `status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Pending',
  `application_open_date` date DEFAULT NULL,
  `application_close_date` date DEFAULT NULL,
  `applied_with` varchar(150) DEFAULT NULL,
  `fees_currency` varchar(3) DEFAULT NULL,
  `tuition_fees` decimal(13,2) DEFAULT NULL,
  `my_commission` decimal(13,2) DEFAULT NULL,
  `my_commission_percent` decimal(13,2) DEFAULT NULL,
  `agent_commission` decimal(13,2) DEFAULT NULL,
  `agent_commission_percent` decimal(13,2) DEFAULT NULL,
  `doc_ready` enum('yes','no','none') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'none',
  `doc_ready_ts` datetime DEFAULT NULL COMMENT 'timestamp of this step update',
  `doc_ready_notes` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `admission_criteria_met` enum('yes','no','partial','none') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'none',
  `admission_criteria_met_ts` datetime DEFAULT NULL,
  `admission_criteria_met_notes` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `application_mode` enum('online','offline','portal','none') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'none',
  `application_portal_url` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `application_mode_ts` datetime DEFAULT NULL,
  `application_mode_notes` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `application_fee_paid` enum('yes','no','none') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'none',
  `application_fee_paid_ts` datetime DEFAULT NULL,
  `application_fee_paid_notes` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `application_submitted` enum('yes','none') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'none',
  `application_submitted_ts` datetime DEFAULT NULL,
  `application_submitted_notes` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `offer_letter_received` enum('yes','none') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'none',
  `offer_letter_type` enum('conditional','unconditional') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `conditional_offer_letter_file` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `conditional_offer_letter_received_ts` datetime DEFAULT NULL,
  `conditional_offer_letter_received_notes` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `offer_letter_file` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `offer_letter_received_ts` datetime DEFAULT NULL,
  `offer_letter_received_notes` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `funds_under_assessment` enum('yes','none') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'none',
  `funds_under_assessment_ts` datetime DEFAULT NULL,
  `funds_under_assessment_notes` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `coe_received` enum('yes','none') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'none',
  `coe_received_ts` datetime DEFAULT NULL,
  `coe_received_notes` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_received` enum('yes','none') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'none',
  `payment_received_ts` datetime DEFAULT NULL,
  `payment_received_notes` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cas_requested` enum('yes','none') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'none',
  `cas_requested_ts` datetime DEFAULT NULL,
  `cas_requested_notes` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cas_received` enum('yes','none') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'none',
  `cas_received_ts` datetime DEFAULT NULL,
  `cas_received_notes` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `i20_initiated` enum('yes','none') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'none',
  `i20_initiated_ts` datetime DEFAULT NULL,
  `i20_initiated_notes` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `i20_received` enum('yes','none') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'none',
  `i20_received_ts` datetime DEFAULT NULL,
  `i20_received_notes` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `aip_received` enum('yes','none') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'none',
  `aip_received_ts` datetime DEFAULT NULL,
  `aip_received_notes` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visa_in_process` enum('yes','none') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'none',
  `visa_in_process_ts` datetime DEFAULT NULL,
  `visa_in_process_notes` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visa_received` enum('yes','none') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'none',
  `visa_received_ts` datetime DEFAULT NULL,
  `visa_received_notes` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `case_closed` tinyint(1) DEFAULT 0,
  `case_closed_reason` enum('admission_complete','rejected_by_institution','visa_rejected','other','visa_complete') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `case_closed_ts` datetime DEFAULT NULL,
  `case_closed_notes` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_commission` decimal(13,2) DEFAULT 0.00,
  `agent_percent` decimal(13,2) DEFAULT 0.00,
  `commission_paid` tinyint(1) DEFAULT 0,
  `visa_pref_id` int(11) DEFAULT NULL,
  `visa_status` enum('Payment Pending','Documents Pending','Documents Ready','Visa in Process','Case Closed - Completed','Case Closed - Rejected') DEFAULT 'Payment Pending',
  `visa_payment_done_ts` timestamp NULL DEFAULT NULL,
  `visa_documents_ready_ts` timestamp NULL DEFAULT NULL,
  `visa_inprogress_ts` timestamp NULL DEFAULT NULL,
  `abroad_job_pref_id` int(11) DEFAULT NULL,
  `abroad_job_status` varchar(150) DEFAULT 'In Process',
  `abroad_job_payment_done_ts` timestamp NULL DEFAULT NULL,
  `abroad_job_documents_ready_ts` timestamp NULL DEFAULT NULL,
  `abroad_job_visa_inprogress_ts` timestamp NULL DEFAULT NULL,
  `abroad_job_completed_ts` timestamp NULL DEFAULT NULL,
  `notes` varchar(500) DEFAULT NULL,
  `task` varchar(500) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `assign_to` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `appl_id` (`appl_id`),
  KEY `university_application_userid_fk` (`userid`),
  KEY `university_application_country_fk` (`country`),
  CONSTRAINT `university_application_userid_fk` FOREIGN KEY (`userid`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `university_courses`;
CREATE TABLE `university_courses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `course_name` varchar(191) NOT NULL,
  `course_details` text DEFAULT NULL,
  `course_content` text DEFAULT NULL,
  `category` int(11) NOT NULL COMMENT 'sub category id',
  `university` int(11) NOT NULL,
  `study_level` varchar(191) NOT NULL,
  `campus` varchar(191) DEFAULT NULL,
  `duration` varchar(191) DEFAULT NULL,
  `intakes` varchar(191) DEFAULT NULL,
  `year` varchar(191) DEFAULT NULL,
  `occupation_outcome` varchar(100) DEFAULT NULL,
  `practical_work` enum('Yes','No','Maybe') DEFAULT NULL,
  `qualify_extended_visa` enum('Yes','No','Maybe') DEFAULT NULL,
  `regional_location` enum('Yes','No','Maybe') DEFAULT NULL,
  `country_students_not_accepted` varchar(191) DEFAULT NULL,
  `website_url` varchar(300) DEFAULT NULL,
  `entry_requirements` text DEFAULT NULL,
  `ielts_score` varchar(191) DEFAULT NULL,
  `ielts_no_band_less_than` varchar(191) DEFAULT NULL,
  `toefl_score` varchar(191) DEFAULT NULL,
  `toefl_no_band_less_than` varchar(191) DEFAULT NULL,
  `pte_score` varchar(191) DEFAULT NULL,
  `pte_no_band_less_than` varchar(191) DEFAULT NULL,
  `gre_score` varchar(191) DEFAULT NULL,
  `gmat_score` varchar(191) DEFAULT NULL,
  `application_deadline` varchar(191) DEFAULT NULL,
  `application_fee` varchar(191) DEFAULT NULL,
  `tuition_fee_onshore` int(11) DEFAULT NULL,
  `tuition_fee_offshore` int(11) DEFAULT NULL,
  `non_tuition_fee` int(11) DEFAULT NULL,
  `currency` varchar(11) DEFAULT NULL,
  `yearly_tuition_fee` varchar(191) DEFAULT NULL,
  `total_tuition_fee` varchar(191) DEFAULT NULL,
  `scholarship_available` varchar(191) DEFAULT NULL,
  `scholarship_detail` text DEFAULT NULL,
  `backlog_range` varchar(191) DEFAULT NULL,
  `remarks` text DEFAULT NULL,
  `esl_elp_detail` text DEFAULT NULL,
  `applicationmode` varchar(191) DEFAULT NULL,
  `detscore` varchar(191) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `concentration` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `course_name` (`course_name`),
  KEY `category` (`category`),
  KEY `university` (`university`),
  KEY `study_level` (`study_level`),
  KEY `intakes` (`intakes`),
  KEY `campus` (`campus`),
  KEY `duration` (`duration`),
  KEY `ielts_score` (`ielts_score`),
  KEY `ielts_no_band_less_than` (`ielts_no_band_less_than`),
  KEY `toefl_score` (`toefl_score`),
  KEY `toefl_no_band_less_than` (`toefl_no_band_less_than`),
  KEY `pte_score` (`pte_score`),
  KEY `pte_no_band_less_than` (`pte_no_band_less_than`),
  KEY `gre_score` (`gre_score`),
  KEY `gmat_score` (`gmat_score`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `university_course_categories`;
CREATE TABLE `university_course_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) NOT NULL,
  `description` text DEFAULT NULL,
  `parent_id` int(11) NOT NULL DEFAULT 0,
  `display_order` int(11) NOT NULL DEFAULT 999,
  `seo_url_slug` varchar(255) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `seo_url_slug` (`seo_url_slug`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `uni_apply_agents`;
CREATE TABLE `uni_apply_agents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `address` text DEFAULT NULL,
  `phone` varchar(12) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `tax_id` varchar(50) DEFAULT NULL,
  `tax_type` enum('inclusive','exclusive') DEFAULT NULL,
  `tax_percent` decimal(13,1) DEFAULT NULL,
  `commission_count` int(11) DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `uni_invoice`;
CREATE TABLE `uni_invoice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_num` int(11) NOT NULL,
  `university_id` int(11) NOT NULL,
  `uni_apply_agent_id` int(11) DEFAULT NULL,
  `ad_hoc` tinyint(1) NOT NULL DEFAULT 0,
  `item1` varchar(191) DEFAULT NULL,
  `item1_amount` decimal(13,2) NOT NULL DEFAULT 0.00,
  `payment_stage` varchar(191) NOT NULL COMMENT '1,2,3,4 comma seperated',
  `due_date` date NOT NULL,
  `currency` varchar(3) NOT NULL,
  `sub_total` decimal(13,2) NOT NULL,
  `tax` decimal(13,2) NOT NULL,
  `tax_rate` decimal(13,2) NOT NULL,
  `tax_type` enum('inclusive','exclusive') DEFAULT NULL,
  `total` decimal(13,2) NOT NULL,
  `commission_rate` decimal(13,5) DEFAULT NULL,
  `status` enum('due','paid') NOT NULL DEFAULT 'due',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `invoice_num` (`invoice_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `uni_invoice_detail`;
CREATE TABLE `uni_invoice_detail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `commission_rate` decimal(13,5) NOT NULL COMMENT 'For uni apply agent invoice',
  `commission` decimal(13,2) NOT NULL,
  `uni_application_id` int(11) NOT NULL,
  `tax` decimal(13,2) NOT NULL,
  `total` decimal(13,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `uni_invoice_payment`;
CREATE TABLE `uni_invoice_payment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` int(11) NOT NULL,
  `payment_date` date NOT NULL,
  `amount` decimal(13,2) NOT NULL,
  `pay_mode` enum('bank_transfer','cheque') NOT NULL,
  `trans_id` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `sid` varchar(20) DEFAULT NULL COMMENT 'ID given by the University',
  `title` enum('Mr.','Ms.','Mrs.','Dr.','Prof.') DEFAULT NULL,
  `first_name` varchar(50) DEFAULT NULL,
  `middle_name` varchar(50) DEFAULT NULL,
  `last_name` varchar(50) DEFAULT NULL,
  `is_lead` tinyint(1) NOT NULL DEFAULT 0,
  `is_staff` tinyint(1) NOT NULL DEFAULT 0,
  `is_agent` tinyint(1) NOT NULL DEFAULT 0,
  `lead_status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `student_type` enum('course','study_abroad','study_abroad_course','visa','abroad_job') DEFAULT NULL,
  `country_interested` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `coaching_course_interested` int(11) DEFAULT 0,
  `overseas_study_level` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `overseas_study_level_selection` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `overseas_course_intersted` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `overseas_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'Pending',
  `coaching_status` enum('Not Enrolled','Enrolled to Course','Course Completed') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'Not Enrolled',
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dialcode` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `whatsapp_dialcode` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `whatsapp` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alternate_contact` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gender` enum('male','female','other') NOT NULL DEFAULT 'male',
  `address_1` varchar(200) DEFAULT NULL,
  `address_2` varchar(50) DEFAULT NULL,
  `post_code` varchar(20) DEFAULT NULL,
  `city` varchar(50) DEFAULT NULL,
  `state` varchar(50) DEFAULT NULL,
  `country` varchar(100) NOT NULL,
  `birthday` date DEFAULT NULL,
  `agent_id` int(11) DEFAULT 0,
  `ref_by` int(10) unsigned DEFAULT 0,
  `ref_status` tinyint(3) unsigned DEFAULT 0,
  `refcode` varchar(15) DEFAULT NULL,
  `lead_source` varchar(50) DEFAULT NULL,
  `lead_form_type` varchar(100) DEFAULT NULL,
  `profile_complete` enum('personal','course','documents') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `application_submit_date` date DEFAULT NULL,
  `branch` int(11) DEFAULT 1,
  `avatar_type` varchar(191) NOT NULL DEFAULT 'gravatar',
  `avatar_location` varchar(191) DEFAULT NULL,
  `password` varchar(191) DEFAULT NULL,
  `password_changed_at` timestamp NULL DEFAULT NULL,
  `active` tinyint(3) unsigned NOT NULL DEFAULT 1,
  `confirmation_code` varchar(191) DEFAULT NULL,
  `confirmed` tinyint(1) NOT NULL DEFAULT 0,
  `timezone` varchar(191) DEFAULT NULL,
  `last_login_at` timestamp NULL DEFAULT NULL,
  `last_login_ip` varchar(191) DEFAULT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `assigned_to` int(11) DEFAULT 0,
  `reporting_to` int(11) DEFAULT 1,
  `last_followup` timestamp NULL DEFAULT NULL,
  `next_followup` timestamp NULL DEFAULT NULL,
  `counselling_date` timestamp NULL DEFAULT NULL,
  `lead_converted_date` timestamp NULL DEFAULT NULL,
  `lead_converted_by` int(11) DEFAULT 0,
  `student_created_at` timestamp NULL DEFAULT NULL,
  `services` text DEFAULT NULL,
  `tags` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `created_by` int(11) DEFAULT 0,
  `updated_at` timestamp NULL DEFAULT NULL,
  `archived` tinyint(1) DEFAULT 0,
  `created_mode` enum('front_end','staff','agent','import','api','web2lead') DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `removed` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'permanent delete. cannot restore ',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `users` (`id`, `uuid`, `sid`, `title`, `first_name`, `middle_name`, `last_name`, `is_lead`, `is_staff`, `is_agent`, `lead_status`, `student_type`, `country_interested`, `coaching_course_interested`, `overseas_study_level`, `overseas_study_level_selection`, `overseas_course_intersted`, `overseas_status`, `coaching_status`, `email`, `dialcode`, `mobile`, `whatsapp_dialcode`, `whatsapp`, `alternate_contact`, `gender`, `address_1`, `address_2`, `post_code`, `city`, `state`, `country`, `birthday`, `agent_id`, `ref_by`, `ref_status`, `refcode`, `lead_source`, `lead_form_type`, `profile_complete`, `application_submit_date`, `branch`, `avatar_type`, `avatar_location`, `password`, `password_changed_at`, `active`, `confirmation_code`, `confirmed`, `timezone`, `last_login_at`, `last_login_ip`, `remember_token`, `assigned_to`, `reporting_to`, `last_followup`, `next_followup`, `counselling_date`, `lead_converted_date`, `lead_converted_by`, `student_created_at`, `services`, `tags`, `created_at`, `created_by`, `updated_at`, `archived`, `created_mode`, `deleted_at`, `removed`) VALUES
(1,	'4043eea7-7f46-4905-b7cf-978925ac48a1',	NULL,	NULL,	'Admin',	NULL,	'Admin',	0,	1,	0,	NULL,	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'Pending',	'Not Enrolled',	'admin@test.com',	NULL,	NULL,	NULL,	NULL,	NULL,	'male',	NULL,	NULL,	NULL,	NULL,	NULL,	101,	NULL,	0,	0,	0,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	'gravatar',	NULL,	'$2y$10$y9DoRL4sJi7ynP8P8tsIK.vJRfditUvr0NVIFoY26R.hAOD1fGEd.',	NULL,	1,	'31b08fdd39831d7b0a9603af52814733',	1,	'America/New_York',	'2021-01-16 05:22:35',	'127.0.0.1',	'0VnIE864jrIgQ3i7wq999nozy6Qnd8brdPMHPDsnmaxtoyh1hegF7NM5OmGi',	0,	1,	NULL,	NULL,	NULL,	NULL,	0,	'2019-02-22 00:14:28',	NULL,	NULL,	'2019-02-22 00:14:28',	0,	'2021-01-16 05:22:35',	0,	NULL,	NULL,	0),
(3,	'f0757a91-f33f-4bb3-b80e-82d75f92b38e',	NULL,	'Mr.',	'Student',	NULL,	'One',	0,	0,	0,	NULL,	'study_abroad',	NULL,	0,	NULL,	NULL,	NULL,	'Pending',	'Not Enrolled',	'student@test.com',	NULL,	NULL,	NULL,	NULL,	NULL,	'male',	NULL,	NULL,	NULL,	NULL,	NULL,	101,	NULL,	0,	0,	0,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	'gravatar',	NULL,	'$2y$10$PyMPhjKUdTo9kHQgDOwu7uMnndcVfIhB84TRFwKTEiNnG2Mykn4Oe',	NULL,	1,	'a9c84a1abc034793ef399d908d961b82',	1,	'Asia/Kolkata',	'2021-01-10 13:21:21',	'106.200.232.18',	'lAa8A8KlXnAJVIDyzOOFpvbXkAXbDAEe5yGIqC9v8AcScuhxs3eofdEsd1IR',	0,	1,	NULL,	NULL,	NULL,	NULL,	0,	'2019-02-22 00:14:29',	NULL,	NULL,	'2019-02-22 00:14:29',	0,	'2021-01-10 13:21:21',	0,	NULL,	NULL,	0);

DROP TABLE IF EXISTS `user_academics`;
CREATE TABLE `user_academics` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned NOT NULL,
  `education_level` enum('10','12','Diploma','Bachelors','Masters','Other') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `course_name` varchar(100) DEFAULT NULL,
  `institute` varchar(100) DEFAULT NULL,
  `institute_country` varchar(100) DEFAULT NULL,
  `campus_city` varchar(100) DEFAULT NULL,
  `postal_code` varchar(20) DEFAULT NULL,
  `start_year` int(4) DEFAULT NULL,
  `percent_cgpa` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pass_year` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `course_status` varchar(50) DEFAULT NULL,
  `specialization` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `school_college` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `university` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `backlogs` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `other_name` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `user_activity`;
CREATE TABLE `user_activity` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `type` enum('system_event','user_event','admin_event','followup','counselling','others','email_sent','email_received','outbound_call','inbound_call','whatsapp_sent','whatsapp_received','sms_sent','lead_assignment','lead_status_change','student_assignment','student_status_change','message_sent_to_student','message_received_from_student') NOT NULL DEFAULT 'system_event',
  `title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `detail` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lead_followup` tinyint(1) NOT NULL DEFAULT 0,
  `lead_status_changed_to` varchar(100) DEFAULT NULL,
  `lead_assigned_to` int(11) NOT NULL DEFAULT 0,
  `student_status_changed_to` varchar(100) DEFAULT NULL,
  `student_assigned_to` int(11) NOT NULL DEFAULT 0,
  `staff` int(11) NOT NULL DEFAULT 0,
  `communication_mode` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `application_status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `workflow_campaign_id` int(11) NOT NULL DEFAULT 0 COMMENT 'automation workflow ID or Campaign ID',
  `attachment` text DEFAULT NULL,
  `callyzer_call_id` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `user_certification_eng`;
CREATE TABLE `user_certification_eng` (
  `userid` int(10) unsigned NOT NULL,
  `exam` enum('IELTS','TOEFL','PTE','DET','ACT','SAT') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `overall_score` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `speaking` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reading` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `writing` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `listening` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `math` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `science` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `english` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `essay` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expiry_date` date DEFAULT NULL,
  PRIMARY KEY (`userid`,`exam`),
  CONSTRAINT `user_certification_eng_userid_fk` FOREIGN KEY (`userid`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `user_certification_lang`;
CREATE TABLE `user_certification_lang` (
  `userid` int(10) unsigned NOT NULL,
  `language` enum('German','French','Spanish','Japanese','Other') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `level` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `overall_score` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `speaking` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reading` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `writing` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `listening` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `institute` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `language_other` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`userid`,`language`,`level`),
  CONSTRAINT `user_certification_lang_userid_fk` FOREIGN KEY (`userid`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `user_courses`;
CREATE TABLE `user_courses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned NOT NULL,
  `course` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `duration` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `hours` int(10) unsigned DEFAULT NULL,
  `institute` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `user_democlass_permission`;
CREATE TABLE `user_democlass_permission` (
  `userid` int(11) NOT NULL,
  `folderid` int(11) NOT NULL,
  PRIMARY KEY (`userid`,`folderid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `user_details`;
CREATE TABLE `user_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) NOT NULL,
  `user_data_js` longtext DEFAULT NULL,
  `name_passport` varchar(50) DEFAULT NULL,
  `passport_num` varchar(20) DEFAULT NULL,
  `passport_issue_date` date DEFAULT NULL,
  `passport_expiry_date` date DEFAULT NULL,
  `passport_country` varchar(100) DEFAULT NULL,
  `city_of_birth` varchar(50) DEFAULT NULL,
  `country_of_birth` varchar(100) DEFAULT NULL,
  `nationality` varchar(100) DEFAULT NULL,
  `citizenship` varchar(100) DEFAULT NULL,
  `dual_citizenship` tinyint(1) DEFAULT NULL,
  `dual_citizenship_country` varchar(100) DEFAULT NULL,
  `studying_abroad` tinyint(1) DEFAULT NULL,
  `studying_abroad_country` varchar(100) DEFAULT NULL,
  `immigration` tinyint(1) DEFAULT NULL,
  `immigration_country` varchar(100) DEFAULT NULL,
  `medical_condition` tinyint(1) DEFAULT NULL,
  `visa_refusal` tinyint(1) DEFAULT NULL,
  `visa_refusal_country` varchar(100) DEFAULT NULL,
  `criminal_offence` tinyint(1) DEFAULT NULL,
  `marital_status` varchar(10) DEFAULT NULL,
  `date_of_marriage` date DEFAULT NULL,
  `permanent_address` varchar(200) DEFAULT NULL,
  `permanent_city` varchar(50) DEFAULT NULL,
  `permanent_state` varchar(50) DEFAULT NULL,
  `permanent_country` varchar(100) DEFAULT NULL,
  `permanent_post_code` varchar(20) DEFAULT NULL,
  `emergency_name` varchar(50) DEFAULT NULL,
  `emergency_phone` varchar(12) DEFAULT NULL,
  `emergency_email` varchar(50) DEFAULT NULL,
  `emergency_relation` varchar(50) DEFAULT NULL,
  `emergency_address` varchar(100) DEFAULT NULL,
  `emergency_country` varchar(100) DEFAULT NULL,
  `emergency_state` varchar(100) DEFAULT NULL,
  `emergency_city` varchar(100) DEFAULT NULL,
  `emergency_postalcode` varchar(50) DEFAULT NULL,
  `study_permit` tinyint(1) DEFAULT NULL,
  `accommodation` tinyint(1) DEFAULT NULL,
  `education_loan` tinyint(1) DEFAULT NULL,
  `country_of_education` varchar(100) DEFAULT NULL,
  `highest_level_education` varchar(50) DEFAULT NULL,
  `passout_year` year(4) DEFAULT NULL,
  `qualification_score` varchar(50) DEFAULT NULL,
  `current_course` varchar(100) DEFAULT NULL,
  `cgpa` decimal(13,2) DEFAULT NULL,
  `ielts` decimal(13,2) DEFAULT NULL,
  `toefl` decimal(13,1) DEFAULT NULL,
  `pte` decimal(13,1) DEFAULT NULL,
  `gre` decimal(13,1) DEFAULT NULL,
  `duolingo` decimal(13,1) DEFAULT NULL,
  `work_experience` varchar(50) DEFAULT NULL,
  `intake_year` year(4) DEFAULT NULL,
  `intake_month` varchar(45) DEFAULT NULL,
  `lead_notes` text DEFAULT NULL,
  `lead_source_detail` text DEFAULT NULL,
  `lead_disqualified_reason` text DEFAULT NULL,
  `student_disqualified_reason` text DEFAULT NULL,
  `email_signature` text DEFAULT NULL,
  `lead_campaign_name` varchar(400) DEFAULT NULL COMMENT 'This comes from API Campaign name',
  `lead_ad_name` varchar(400) DEFAULT NULL COMMENT 'This comes from API Ad name',
  `lead_form_name` varchar(400) DEFAULT NULL COMMENT 'This comes from API Form name',
  `lead_lead_id` varchar(400) DEFAULT NULL COMMENT 'This comes from API Lead Id',
  `payment_pref_mode` varchar(100) DEFAULT NULL,
  `payment_pref_detail` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `userid` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `user_details` (`id`, `userid`, `user_data_js`, `name_passport`, `passport_num`, `passport_issue_date`, `passport_expiry_date`, `passport_country`, `city_of_birth`, `country_of_birth`, `nationality`, `citizenship`, `dual_citizenship`, `dual_citizenship_country`, `studying_abroad`, `studying_abroad_country`, `immigration`, `immigration_country`, `medical_condition`, `visa_refusal`, `visa_refusal_country`, `criminal_offence`, `marital_status`, `date_of_marriage`, `permanent_address`, `permanent_city`, `permanent_state`, `permanent_country`, `permanent_post_code`, `emergency_name`, `emergency_phone`, `emergency_email`, `emergency_relation`, `emergency_address`, `emergency_country`, `emergency_state`, `emergency_city`, `emergency_postalcode`, `study_permit`, `accommodation`, `education_loan`, `country_of_education`, `highest_level_education`, `passout_year`, `qualification_score`, `current_course`, `cgpa`, `ielts`, `toefl`, `pte`, `gre`, `duolingo`, `work_experience`, `intake_year`, `intake_month`, `lead_notes`, `lead_source_detail`, `lead_disqualified_reason`, `student_disqualified_reason`, `email_signature`, `lead_campaign_name`, `lead_ad_name`, `lead_form_name`, `lead_lead_id`, `payment_pref_mode`, `payment_pref_detail`, `created_at`, `updated_at`) VALUES
(1,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL),
(2,	3,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL);

DROP TABLE IF EXISTS `user_docs_other`;
CREATE TABLE `user_docs_other` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned NOT NULL,
  `doc_type` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `course_pref_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `user_docs_other_userid_fk` (`userid`),
  CONSTRAINT `user_docs_other_userid_fk` FOREIGN KEY (`userid`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `user_documents`;
CREATE TABLE `user_documents` (
  `userid` int(10) unsigned NOT NULL,
  `class10` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `class10_marks_sheet` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `class12` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `class12_marks_sheet` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `diploma` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `diploma_marks_sheet` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `grad_all_sem` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `grad_degree` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cmm` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `grad_provisional` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `grad_transcripts` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pg_all_sem` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pg_degree` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pg_provisional` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pg_transcripts` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_ielts` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_pte` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gmat` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `toefl` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `duolingo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`userid`),
  CONSTRAINT `user_documents_userid_fk` FOREIGN KEY (`userid`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `user_experience`;
CREATE TABLE `user_experience` (
  `userid` int(10) unsigned NOT NULL,
  `company` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `designation` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  PRIMARY KEY (`userid`,`company`),
  CONSTRAINT `user_experience_userid_fk` FOREIGN KEY (`userid`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `user_family`;
CREATE TABLE `user_family` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(10) NOT NULL,
  `first_name` varchar(100) NOT NULL,
  `last_name` varchar(100) NOT NULL,
  `relationship` enum('wife','husband','father','mother','step father','step mother','parental grand father','parental grand mother','maternal grand father','maternal grand mother','son','daughter','step son','step daughter','brother','sister','step brother','step sister') NOT NULL,
  `gender` varchar(10) NOT NULL,
  `email` varchar(191) DEFAULT NULL,
  `dial_code` int(11) DEFAULT NULL,
  `mobile` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `birth_date` date DEFAULT NULL,
  `birth_country` int(11) DEFAULT NULL,
  `residence_country` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `user_folder_permission`;
CREATE TABLE `user_folder_permission` (
  `userid` int(11) NOT NULL,
  `folderid` int(11) NOT NULL,
  PRIMARY KEY (`userid`,`folderid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `user_gre_gmat`;
CREATE TABLE `user_gre_gmat` (
  `userid` int(10) unsigned NOT NULL,
  `exam` enum('GRE','GMAT') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_score` int(10) unsigned DEFAULT NULL,
  `verbal` int(10) unsigned DEFAULT NULL,
  `quantitative` int(10) unsigned DEFAULT NULL,
  `analytical` int(10) unsigned DEFAULT NULL,
  `integrated` int(10) unsigned DEFAULT NULL,
  `expiry_date` date DEFAULT NULL,
  PRIMARY KEY (`userid`,`exam`),
  CONSTRAINT `user_gre_gmat_userid_fk` FOREIGN KEY (`userid`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `user_internship`;
CREATE TABLE `user_internship` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned NOT NULL,
  `company` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `duration` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `place` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `user_notes`;
CREATE TABLE `user_notes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `notes` text NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `user_notification`;
CREATE TABLE `user_notification` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `application_id` int(11) NOT NULL DEFAULT 0,
  `application_type` enum('visa','university','lead','student','ticket','agent','webinar','invoice','staff_leaves') DEFAULT NULL,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `read` tinyint(1) NOT NULL DEFAULT 0,
  `from_user` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `user_shipping_addresses`;
CREATE TABLE `user_shipping_addresses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `address_type` varchar(45) NOT NULL,
  `address` varchar(200) NOT NULL,
  `zip_code` varchar(20) NOT NULL,
  `country` varchar(45) NOT NULL,
  `state` varchar(45) NOT NULL,
  `city` varchar(45) NOT NULL,
  `phone` varchar(30) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `visa_application_history`;
CREATE TABLE `visa_application_history` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) unsigned NOT NULL DEFAULT 0,
  `country_applied_for_visa` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name_used_for_visa_apply` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visa_apply_visa_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visa_apply_application_date` date DEFAULT NULL,
  `visa_apply_application_number` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visa_apply_outcome` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `visa_services_activity`;
CREATE TABLE `visa_services_activity` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appl_id` int(11) NOT NULL,
  `detail` text DEFAULT NULL,
  `staff` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `wati_webhook_calls`;
CREATE TABLE `wati_webhook_calls` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `request_id` varchar(40) NOT NULL,
  `details` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `request_id` (`request_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `webhook_calls`;
CREATE TABLE `webhook_calls` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `url` varchar(255) NOT NULL,
  `headers` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `exception` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `webhook_calls_chk_1` CHECK (json_valid(`headers`)),
  CONSTRAINT `webhook_calls_chk_2` CHECK (json_valid(`payload`))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `webhook_lead_responses`;
CREATE TABLE `webhook_lead_responses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `page_id` bigint(20) NOT NULL,
  `adgroup_id` bigint(20) NOT NULL,
  `ad_id` bigint(20) NOT NULL,
  `form_id` bigint(20) NOT NULL,
  `leadgen_id` bigint(20) NOT NULL,
  `received_at` datetime NOT NULL,
  `payload` text DEFAULT NULL,
  `processed` tinyint(1) NOT NULL DEFAULT 0,
  `processed_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `webinar`;
CREATE TABLE `webinar` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `topic` varchar(100) NOT NULL,
  `image` varchar(225) DEFAULT NULL,
  `course` int(11) DEFAULT NULL,
  `date` datetime NOT NULL,
  `venue` varchar(250) NOT NULL,
  `link` varchar(500) DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `whatsapp_templates`;
CREATE TABLE `whatsapp_templates` (
  `hook` varchar(50) NOT NULL,
  `message` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `variables` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `system_tpl` tinyint(1) NOT NULL DEFAULT 0,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `details` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`hook`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `whatsapp_templates` (`hook`, `message`, `variables`, `system_tpl`, `status`, `details`, `created_at`, `updated_at`) VALUES
('agent_welcome',	'Dear #first_name#, Welcome to #sitename#!, Thank you for registering as an agent of #sitename#.',	'sitename,siteurl,first_name,full_name',	1,	1,	'This is sent to an Agent when approved by staff',	'2022-01-01 00:00:00',	NULL),
('birthday_wishes',	'Many More Happy Returns Of The Day To Our Dearest #full_name#! May All Your Wishes Come True And Stay Blessed Forever! Happy Birthday!',	'sitename,siteurl,first_name,full_name',	1,	1,	'This is sent to Student on Birthday',	'2021-12-31 18:30:00',	NULL),
('counselling_meet_scheduled',	'Dear #first_name#, A New counselling meeting is assigned to you.',	'sitename,siteurl,first_name,full_name',	1,	1,	'This is sent to staff when a counselling meeting is scheduled for the staff',	'2022-01-01 00:00:00',	'2023-08-07 09:53:13'),
('course_suggestion',	'Dear #first_name#, You have got new Course Suggestions. Login to check the details.',	'sitename,siteurl,first_name,full_name',	1,	1,	'This is sent to Student when staff sends a course suggestion',	'2021-12-31 18:30:00',	NULL),
('lead_welcome',	'Dear #first_name#, Welcome to #sitename#! #siteurl# Email: #email# Password: #password#',	'sitename,siteurl,first_name,full_name,password',	1,	1,	'This is sent to a Lead when the Lead is manually added by staff',	'2021-12-31 18:30:00',	NULL),
('lead_welcome_web2lead',	'Dear #first_name#, Welcome to #sitename#! #siteurl# Email: #email# Password: #password#',	'sitename,siteurl,first_name,full_name,password',	0,	0,	'This is sent to a lead when lead is generated through web to lead form',	NULL,	NULL),
('notification',	'Notification from #sitename#: #message#',	'sitename,message',	1,	1,	'',	'2021-12-31 18:30:00',	NULL),
('staff_lead_assigned',	'Dear #first_name#, A new lead is assigned to you.',	'sitename,siteurl,first_name,full_name',	1,	1,	'This is sent to a Staff when a lead is assigned to him/her',	'2021-12-31 18:30:00',	'2023-08-07 09:53:04'),
('staff_lead_followup',	'Dear #first_name#, Leads to follow-up:',	'sitename,siteurl,first_name,full_name',	1,	1,	'This is sent to a Staff with details of upcoming lead follow-ups',	'2021-12-31 18:30:00',	'2023-08-07 09:53:09'),
('student_create',	'Hello #first_name# 👋\r\nWe\'re thrilled to welcome you to #sitename#, your gateway to a world of educational opportunities! 🌟\r\n\r\nEmbarking on a journey to study overseas is an exciting and life-changing experience, and we\'re here to guide you every step of the way. Whether you\'re dreaming of prestigious universities, cultural immersion, or personal growth, we\'ve got you covered.\r\n\r\nYour Login details:\r\nURL: #siteurl#\r\nEmail: #email#\r\nPassword: #password#\r\n\r\n*🚀 Let\'s turn your study abroad dreams into reality! 🌟*',	'sitename,siteurl,first_name,full_name,email,password',	1,	1,	'This is sent to Student when staff creates a student',	'2021-12-31 18:30:00',	'2023-11-23 21:56:50'),
('student_password',	'Dear #first_name#, Welcome to #sitename#! #siteurl# Email: #email# Password: #password#',	'sitename,siteurl,first_name,full_name,password',	1,	1,	'This message with auto-generated password is sent to student when a lead is converted to student',	'2021-12-31 18:30:00',	NULL),
('student_welcome',	'Hello #first_name# 👋\r\nWe\'re thrilled to welcome you to #sitename#, your gateway to a world of educational opportunities! 🌟\r\n\r\nEmbarking on a journey to study overseas is an exciting and life-changing experience, and we\'re here to guide you every step of the way. Whether you\'re dreaming of prestigious universities, cultural immersion, or personal growth, we\'ve got you covered.\r\n\r\n*🎓 Why Choose #sitename#?*\r\n*✈️ Personalized Support*\r\n*🌐 Global Network*\r\n*📚 Comprehensive Services*\r\n*🤝 Community and Connections*\r\n\r\nFeel free to reach out if you have any questions or if there\'s anything specific you\'d like to know. Your adventure awaits, and we\'re here to make it extraordinary!\r\n\r\n*🚀 Let\'s turn your study abroad dreams into reality! 🌟*',	'sitename,siteurl,first_name,full_name',	1,	1,	'This is sent to Student on signup or on email confirmation',	'2021-12-31 18:30:00',	'2023-11-23 21:22:11'),
('ticket_reply',	'Dear #first_name#, Ticket #id# has a new reply posted by support staff.',	'sitename,siteurl,first_name,full_name,id',	1,	1,	'This is sent to Student when a staff replies to ticket raised by student',	'2021-12-31 18:30:00',	'2023-08-07 09:53:16'),
('university_application_update',	'Dear #first_name#, Application #application#, Status Update: #details#.',	'sitename,siteurl,first_name,full_name,application,details',	1,	1,	'This is sent to Student when his/her college application status is updated by staff',	'2021-12-31 18:30:00',	NULL),
('webinar_reminder',	'Dear #first_name#, This is a reminder for the upcoming webinar - #webinar#, at #time#.',	'sitename,siteurl,first_name,full_name,webinar,time',	1,	1,	'This message is sent to student for an upcoming webinar for which he has registered for',	'2021-12-31 18:30:00',	NULL);

DROP TABLE IF EXISTS `zone_configs`;
CREATE TABLE `zone_configs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `seller_id` int(11) NOT NULL,
  `zone_name` varchar(100) NOT NULL,
  `country_id` int(11) NOT NULL,
  `state_id` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- -------------------------------------------------------------------------
-- Adminer export END
-- -------------------------------------------------------------------------


DELETE FROM `permissions` WHERE `name` = 'broadcast';

INSERT INTO `permissions` (`name`, `guard_name`, `details`, `status`, `created_at`, `updated_at`)
VALUES ('canned responses', 'web', 'This permission will allow staff member to create/edit and delete canned responses', '1', NULL, NULL);

INSERT INTO `permissions` (`name`, `guard_name`, `details`, `status`, `created_at`, `updated_at`)
VALUES ('broadcast to leads and students', 'web', 'Send bulk email, sms, whatsapp message to leads & students', '1', NULL, NULL);

INSERT INTO `permissions` (`name`, `guard_name`, `details`, `status`, `created_at`, `updated_at`)
VALUES ('broadcast to staff', 'web', 'Send bulk email, sms, whatsapp message to staff', '1', NULL, NULL);

INSERT INTO `permissions` (`name`, `guard_name`, `details`, `status`, `created_at`, `updated_at`)
VALUES ('broadcast to agents', 'web', 'Send bulk email, sms, whatsapp message to agents', '1', NULL, NULL);


-- 04-12-2024

CREATE TABLE `business_configs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `logo` text DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `phone` varchar(15) DEFAULT NULL,
  `address` varchar(200) DEFAULT NULL,
  `tax_id` varchar(50) DEFAULT NULL,
  `bank_details` varchar(200) DEFAULT NULL,
  `footer_text` varchar(200) DEFAULT NULL,
  `terms_text` varchar(200) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `business_configs` (`id`, `name`, `logo`, `email`, `phone`, `address`, `tax_id`, `bank_details`, `footer_text`, `terms_text`, `created_at`, `updated_at`)
VALUES (1, 'Demo', NULL, 'info@demo.com', '1234567890', '#1, 1st Cross, Bangalore', '123456', '', 'Thank you for your business with us', '', now(), NULL);

ALTER TABLE `invoice`
ADD `business_id` int(11) NOT NULL AFTER `student_id`;

ALTER TABLE `uni_invoice`
ADD `business_id` int(11) NOT NULL AFTER `invoice_num`;

ALTER TABLE `uni_invoice`
ADD `terms_conditions` text COLLATE 'utf8mb4_unicode_ci' NULL AFTER `status`;

-- 31-12-2024

ALTER TABLE `university_application`
CHANGE `applied_with` `applied_with` int NULL AFTER `application_close_date`;

-- 27-01-2024

ALTER TABLE `services`
ADD `amount` varchar(250) NOT NULL AFTER `country_field`;

ALTER TABLE `service_applications`
ADD `amount` varchar(250) NOT NULL AFTER `college_appl_id`;

-- 10-02-2025

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('recaptcha_site_key', '', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('recaptcha_secret_key', '', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('student_signup_captcha', '', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('agent_signup_captcha', '', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('web_to_lead_captcha', '', now(), NULL);

INSERT INTO `configs_site` (`key`, `value`, `created_at`, `updated_at`)
VALUES ('form_builder_captcha', '', now(), NULL);

-- 14-02-2025

ALTER TABLE `permissions`
ADD `group` varchar(100) NULL AFTER `status`;

ALTER TABLE `permissions`
ADD `display_order` int NULL AFTER `group`;

DELETE FROM `role_has_permissions` 
WHERE ((`permission_id` = '5') OR (`permission_id` = '10') OR (`permission_id` = '11') OR (`permission_id` = '16') OR (`permission_id` = '30') OR (`permission_id` = '33') OR (`permission_id` = '36'));

DELETE FROM `permissions`
WHERE ((`id` = '5') OR (`id` = '10') OR (`id` = '11') OR (`id` = '16') OR (`id` = '30') OR (`id` = '33') OR (`id` = '36'));

UPDATE `permissions` SET `details` = 'Staff with this permission can perform various settings available in Settings page like: Branch management, Businesses, Modules, Lead/Student/Application Status values, Email/SMS/Whatsapp configs, Taxes etc.',`display_order` = '40' WHERE `name` = 'settings';
UPDATE `permissions` SET `group` = 'Support Tickets',`display_order` = '23' WHERE `name` = 'support tickets';

UPDATE `permissions` SET `details`='View students, student profile details, course preferences, documents, applications.', `group` = 'Student Management', `display_order` = '4' WHERE `name` = 'students';
UPDATE `permissions` SET `name` = 'view students' WHERE `name` = 'students';

UPDATE `permissions` SET `details`='View Student University applications', `group` = 'Application Management', `display_order` = '7' WHERE `name` = 'university applications';
UPDATE `permissions` SET `name` = 'view university applications' WHERE `name` = 'university applications';

UPDATE `permissions` SET `group` = 'Advanced', `display_order` = '37' WHERE `name` = 'country info';
UPDATE `permissions` SET `group` = 'Staff Management', `display_order` = '12' WHERE `name` = 'view staff';

UPDATE `permissions` SET `details`='View Leads', `group` = 'Lead Management', `display_order` = '1' WHERE `name` = 'leads';
UPDATE `permissions` SET `name` = 'view leads' WHERE `name` = 'leads';

UPDATE `permissions` SET `group` = 'CMS Management', `display_order` = '25' WHERE `name` = 'cms-articles';
UPDATE `permissions` SET `group` = 'CMS Management', `display_order` = '26' WHERE `name` = 'cms-events';
UPDATE `permissions` SET `group` = 'Advanced', `display_order` = '38' WHERE `name` = 'overseas education configs';
UPDATE `permissions` SET `group` = 'Upload Management', `display_order` = '27' WHERE `name` = 'file uploads';
UPDATE `permissions` SET `group` = 'Message Template Management', `display_order` = '28' WHERE `name` = 'mail templates';
UPDATE `permissions` SET `group` = 'Advanced', `display_order` = '35' WHERE `name` = 'branch mgmt';
UPDATE `permissions` SET `group` = 'Advanced', `display_order` = '34' WHERE `name` = 'roles mgmt';
UPDATE `permissions` SET `group` = 'Staff Management', `display_order` = '13' WHERE `name` = 'edit-staff';
UPDATE `permissions` SET `group` = 'Advanced', `display_order` = '36' WHERE `name` = 'delete-lead-student-application';
UPDATE `permissions` SET `group` = 'Invoice Management', `display_order` = '20' WHERE `name` = 'invoice';
UPDATE `permissions` SET `group` = 'Lead Management', `display_order` = '3' WHERE `name` = 'lead-assignment';
UPDATE `permissions` SET `group` = 'Support Tickets', `display_order` = '24' WHERE `name` = 'ticket-assignment';
UPDATE `permissions` SET `group` = 'Advanced', `display_order` = '33' WHERE `name` = 'import';
UPDATE `permissions` SET `group` = 'Report Management', `display_order` = '30' WHERE `name` = 'analytics';
UPDATE `permissions` SET `group` = 'Advanced', `display_order` = '31' WHERE `name` = 'automations';
UPDATE `permissions` SET `group` = 'Agent Management', `display_order` = '18' WHERE `name` = 'agent management';
UPDATE `permissions` SET `group` = 'Student Management', `display_order` = '6' WHERE `name` = 'student-assignment';
UPDATE `permissions` SET `group` = 'Agent Management', `display_order` = '18' WHERE `name` = 'commission';
UPDATE `permissions` SET `group` = 'Course Management', `display_order` = '19' WHERE `name` = 'course finder';
UPDATE `permissions` SET `group` = 'Advanced', `display_order` = '39' WHERE `name` = 'export lead, student data';
UPDATE `permissions` SET `group` = 'Application Management', `display_order` = '10' WHERE `name` = 'application apply through';
UPDATE `permissions` SET `group` = 'Application Management', `display_order` = '11' WHERE `name` = 'delete-visa-service-application';
UPDATE `permissions` SET `group` = 'Staff Management', `display_order` = '14' WHERE `name` = 'staff attendance';
UPDATE `permissions` SET `group` = 'Staff Management', `display_order` = '15' WHERE `name` = 'staff leaves';
UPDATE `permissions` SET `group` = 'Staff Management', `display_order` = '16' WHERE `name` = 'Approve Leaves';
UPDATE `permissions` SET `group` = 'Application Management', `display_order` = '9' WHERE `name` = 'application-assignment';
UPDATE `permissions` SET `group` = 'Invoice Management', `display_order` = '21' WHERE `name` = 'edit-invoice';
UPDATE `permissions` SET `group` = 'Referral Management', `display_order` = '29' WHERE `name` = 'student referral';
UPDATE `permissions` SET `group` = 'Invoice Management', `display_order` = '22' WHERE `name` = 'university invoice';
UPDATE `permissions` SET `group` = 'Message Template Management', `display_order` = '29' WHERE `name` = 'canned responses';
UPDATE `permissions` SET `group` = 'Advanced', `display_order` = '41' WHERE `name` = 'broadcast to leads and students';
UPDATE `permissions` SET `group` = 'Advanced', `display_order` = '42' WHERE `name` = 'broadcast to staff';
UPDATE `permissions` SET `group` = 'Advanced', `display_order` = '43' WHERE `name` = 'broadcast to agents';

INSERT INTO `permissions` (`name`, `guard_name`, `details`, `status`, `group`, `display_order`, `created_at`, `updated_at`)
VALUES ('lead create-update', 'web', 'Ability to create leads, edit leads and change lead status, add followups.', '1', 'Lead Management', '2', now(), NULL);

INSERT INTO `permissions` (`name`, `guard_name`, `details`, `status`, `group`, `display_order`, `created_at`, `updated_at`)
VALUES ('manage students', 'web', 'Create/manage students, student profile details, course preferences, documents, applications.', '1', 'Student Management', '5', now(), NULL);

INSERT INTO `permissions` (`name`, `guard_name`, `details`, `status`, `group`, `display_order`, `created_at`, `updated_at`)
VALUES ('manage university applications', 'web', 'Create Student University applications, manage details, status.', '1', 'Application Management', '8', now(), NULL);

-- default permissions for staff
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (54, 13);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (27, 13);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (55, 13);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (34, 13);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (56, 13);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (41, 13);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (47, 13);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (38, 13);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (18, 13);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (48, 13);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (50, 13);

-- default permissions for manager
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (54, 14);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (27, 14);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (55, 14);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (34, 14);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (56, 14);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (41, 14);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (47, 14);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (38, 14);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (18, 14);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (48, 14);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (50, 14);

INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (17, 14);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (40, 14);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (43, 14);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (44, 14);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (45, 14);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (32, 14);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (35, 14);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (26, 14);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (46, 14);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (49, 14);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (48, 14);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (31, 14);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (42, 14);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (29, 14);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (39, 14);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (51, 14);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (52, 14);
INSERT IGNORE INTO role_has_permissions (permission_id, role_id) VALUES (53, 14);

-- 28-03-2025

ALTER TABLE `user_details`
CHANGE `marital_status` `marital_status` varchar(50) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `criminal_offence`;

DELETE FROM `countries`
WHERE `title_en` = 'Yugoslavia' AND ((`id` = '244'));

-- 13-06-2025

ALTER TABLE `universities`
CHANGE `institution_type` `institution_type` enum('private_university','government_university') COLLATE 'utf8mb4_unicode_ci' NULL AFTER `country`;

-- 14-06-2025

ALTER TABLE `states`
ADD `status` int(2) NOT NULL;

ALTER TABLE `states`
CHANGE `status` `status` int(2) NOT NULL DEFAULT '1' AFTER `country_id`;

ALTER TABLE `cities`
ADD `status` int(2) NOT NULL DEFAULT '1';

-- 19-07-2025

ALTER TABLE `users`
ADD `google_refresh_token` text COLLATE 'utf8mb4_unicode_ci' NULL,
ADD `google_token_expires_in` int NULL AFTER `google_refresh_token`,
ADD `google_token_created_at` timestamp NULL AFTER `google_token_expires_in`;

ALTER TABLE `users`
ADD `google_token` text COLLATE 'utf8mb4_unicode_ci' NULL;

-- 20-07-2025

CREATE TABLE `google_sheets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `sheet_id` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 18-08-2025

ALTER TABLE `services`
CHANGE `amount` `amount` varchar(250) COLLATE 'utf8mb4_unicode_ci' NULL AFTER `country_field`;
