<?php
namespace Database\Factories;

use App\Models\Auth\User;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;
use Illuminate\Database\Eloquent\Factories\Factory;

class UserFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = User::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            // 'uuid'              => Uuid::generate(4)->string,
            'first_name'        => $this->faker->name(),
            'last_name'         => $this->faker->name(),
            'email'             => $this->faker->unique()->safeEmail(),
            //'email_verified_at' => now(),
            'password'          => 'secret',
            'password_changed_at' => null,
            'remember_token'    => Str::random(10),
            'confirmation_code' => md5(uniqid(mt_rand(), true)),
            'active' => 1,
            'confirmed' => 1,
        ];
    }
}
