<?php

function GetIonCubeLoaderVersion() {
    if (function_exists('ioncube_loader_iversion')) {
       $version = ioncube_loader_iversion();
       $version = sprintf('%d.%d.%d', $version / 10000, ($version / 100) % 100, $version % 100);
       return $version;
    }
    return 'Not Found!';
}

?>
<html>

<body>
    <table>

        <tr>
            <td style="width:250px;">PHP > 8.1.0</td>
            <?php
            if (!version_compare(PHP_VERSION, '8.1.0', '>=')) {
            ?>
                <td><span style='color:red'>Missing! (Has Version: <?=PHP_VERSION?>)</span></td>
            <?php
            } else {
            ?>
                <td>OK (Version: <?=PHP_VERSION?>)</span></td>
            <?php
            }
            ?>
        </tr>
        <tr>
            <td style="width:250px;">MySQL</td>
            <?php

            if (!function_exists('mysqli_connect')) {
            ?>

                <td><span style='color:red'>Missing!</span></td>
        </tr>
    <?php
            } else {
    ?>
        <td>OK</span></td>
    <?php
            }
    ?>
    </tr>
    <tr>
        <td style="width:250px;">cURL</td>

        <?php
        if (!function_exists('curl_init')) {
        ?>
            <td><span style='color:red'>Missing!</span></td>
        <?php
        } else {
        ?>
            <td>OK</span></td>
        <?php
        }
        ?>
    </tr>
    <tr>
        <td style="width:250px;">MBString</td>
        <?php

        if (!extension_loaded('mbstring')) {
        ?>
            <td><span style='color:red'>Missing!</span></td>
        <?php
        } else {
        ?>
            <td>OK</span></td>
        <?php
        }
        ?>
    </tr>
    <tr>
        <td style="width:250px;">GD</td>
        <?php

        if (!extension_loaded('gd') && !function_exists('gd_info')) {
        ?>
            <td><span style='color:red'>Missing!</span></td>
        <?php
        } else {
        ?>
            <td>OK</span></td>
        <?php
        }
        ?>
    </tr>
    <tr>
        <td style="width:250px;">Zip</td>
        <?php
        if (!extension_loaded('zip')) {
        ?>
            <td><span style='color:red'>Missing!</span></td>
        <?php
        } else {
        ?>
            <td>OK</span></td>
        <?php
        }
        ?>
    </tr>
    <tr>
        <td style="width:250px;">MIME Content Type</td>
        <?php

        if (!function_exists('mime_content_type')) {
        ?>
            <td><span style='color:red'>Missing!</span></td>
        <?php
        } else {
        ?>
            <td>OK</span></td>
        <?php
        }
        ?>
    </tr>
    <tr>
        <td style="width:250px;">ionCube Loader</td>
        <?php

        if (!extension_loaded('ionCube Loader')) {
        ?>
            <td><span style='color:red'>Missing!</span></td>
        <?php
        } else {

            $version = GetIonCubeLoaderVersion();
        ?>
            <td>OK (Version: <?=$version?>)</span></td>
        <?php
        }
        ?>
    </tr>

    </table>
</body>
</html>