<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Strings Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used in strings throughout the system.
    | Regardless where it is placed, a string can be listed here so it is easily
    | found in a intuitive way.
    |
    */

    'backend' => [
        'access' => [
            'users' => [
                'delete_user_confirm'  => 'Are you sure you want to delete this user permanently? Anywhere in the application that references this user\'s id will most likely error. Proceed at your own risk. This can not be un-done.',
                'if_confirmed_off'     => '(If confirmed is off)',
                'no_deactivated' => 'There are no deactivated users.',
                'no_deleted' => 'There are no deleted users.',
                'restore_user_confirm' => 'Restore this user to its original state?',
            ],
        ],

        'dashboard' => [
            'title'   => 'Dashboard',
            'welcome' => 'Welcome',
            'guest' => 'Guest',
        ],

        'general' => [
            'all_rights_reserved' => 'All Rights Reserved.',
            'are_you_sure'        => 'Are you sure you want to do this?',
            'delete_user_permanently'        => 'Delete User Permanently?',
            'delete_lead_permanently'        => 'Delete Lead Permanently?',
            'boilerplate_link'    => 'Laravel 5 Boilerplate',
            'continue'            => 'Continue',
            'member_since'        => 'Member since',
            'minutes'             => ' minutes',
            'search_placeholder'  => 'Search...',
            'already'  => 'Already',
            'timeout'             => 'You were automatically logged out for security reasons since you had no activity in ',

            'see_all' => [
                'messages'      => 'See all messages',
                'notifications' => 'View all',
                'tasks'         => 'View all tasks',
            ],

            'status' => [
                'online'  => 'Online',
                'offline' => 'Offline',
            ],

            'you_have' => [
                'messages'      => '{0} You don\'t have messages|{1} You have 1 message|[2,Inf] You have :number messages',
                'notifications' => '{0} You don\'t have notifications|{1} You have 1 notification|[2,Inf] You have :number notifications',
                'tasks'         => '{0} You don\'t have tasks|{1} You have 1 task|[2,Inf] You have :number tasks',
            ],
        ],

        'search' => [
            'empty'      => 'Please enter a search term.',
            'incomplete' => 'You must write your own search logic for this system.',
            'title'      => 'Search Results',
            'results'    => 'Search Results for :query',
        ],

        'welcome' => 'Welcome to the Dashboard',
        'todo' => 'Todo',
    ],

    'emails' => [
        'auth' => [
            'account_confirmed' => 'Your account has been confirmed.',
            'error'                   => 'Whoops!',
            'greeting'                => 'Hello!',
            'regards'                 => 'Regards,',
            'trouble_clicking_button' => 'If you’re having trouble clicking the ":action_text" button, copy and paste the URL below into your web browser:',
            'thank_you_for_using_app' => 'Thank you for using our application!',

            'password_reset_subject'    => 'Reset Password',
            'password_cause_of_email'   => 'You are receiving this email because we received a password reset request for your account.',
            'password_if_not_requested' => 'If you did not request a password reset, no further action is required.',
            'reset_password'            => 'Click here to reset your password',

            'click_to_confirm' => 'Click here to confirm your account:',
        ],

        'contact' => [
            'email_body_title' => 'You have a new contact form request: Below are the details:',
            'subject' => 'A new :app_name contact form submission!',
        ],
    ],

    'frontend' => [
        'test' => 'Test',

        'tests' => [
            'based_on' => [
                'permission' => 'Permission Based - ',
                'role'       => 'Role Based - ',
            ],

            'js_injected_from_controller' => 'Javascript Injected from a Controller',

            'using_blade_extensions' => 'Using Blade Extensions',

            'using_access_helper' => [
                'array_permissions'     => 'Using Access Helper with Array of Permission Names or ID\'s where the user does have to possess all.',
                'array_permissions_not' => 'Using Access Helper with Array of Permission Names or ID\'s where the user does not have to possess all.',
                'array_roles'           => 'Using Access Helper with Array of Role Names or ID\'s where the user does have to possess all.',
                'array_roles_not'       => 'Using Access Helper with Array of Role Names or ID\'s where the user does not have to possess all.',
                'permission_id'         => 'Using Access Helper with Permission ID',
                'permission_name'       => 'Using Access Helper with Permission Name',
                'role_id'               => 'Using Access Helper with Role ID',
                'role_name'             => 'Using Access Helper with Role Name',
            ],

            'view_console_it_works'          => 'View console, you should see \'it works!\' which is coming from FrontendController@index',
            'you_can_see_because'            => 'You can see this because you have the role of \':role\'!',
            'you_can_see_because_permission' => 'You can see this because you have the permission of \':permission\'!',
        ],

        'general' => [
            'joined' => 'Joined',
            'apply_for_study_abroad'        => "Apply for Study Abroad",
            //Study Abroad
            'apply_for_overseas'        => "Apply for Overseas",
            'country_information'        => "Country Information",
            'course_suggestion'        => "Course Suggestion",
            'applications'        => "Applications",
            //course Preference
            'completed_this_step'=> 'Your have completed this step.',
            'update_Profile'=> 'Please update “Interested Study Level” in Profile, to update course preferences.',
            'program_preferences'=> 'Your Program Preferences',
            'add_new_program'=> 'Add New Program',
            'Search_course_select_program'=> 'Search for a Course and Select Program',
            'add_program'=> 'Add Program',
            'intake'=> 'Intake',
            'manually_add_program'=> 'Manually Add a Program',
            'selected_programs'=> 'Selected Programs',
            'complete_your_profile'=> 'You must complete your profile details before adding the course preferences',
            'added_by'=> 'Added By',
            //document upload
            'must_complete_profile'=> 'You must complete your profile & course preferences details before you can upload documents.',
            'file_size'=> 'Each individual file size must not exceed',
            'merged_file_size'=> 'All semester merged file size must not exceed',
            'academic_language_certificates'=> 'Academic, Language Certificates',
            'academic_certificates_and_document'=> 'Academic Certificates & Document',
            'must_pdf_format'=> 'The following documents must be in pdf format.',
            'uploaded_file'=> 'Uploaded File:',
            'replace_file'=> 'Replace File',
            'required'=> 'Required',
            'essay'=> 'Essay',
            'upload_essay'=> 'Upload Essay',
            'must_be'=> 'Must be',
            'uploading'=> 'Uploading...',
            'tests_or_english_certificates'=> 'Tests/English Certificates',
            'upload_applicable_certificates'=> 'Upload all applicable certificates. The documents must be in pdf format.',
            'allowed_file_types'=> 'Allowed file types:',
            'agree_to_the_above_terms'=> 'I agree to the above terms and conditions',
            'submit_application'=> 'Submit Application',
            'you_have_submitted_application'=> 'You have submitted application on',
            'other_certificates'=> 'Passport, CV, LOR, SOP, Experience, Other Certificates',
            'download_sample_cv'=> 'Download Sample CV',
            'maximum'=> 'Maximum',
            'document_must_be_in_word_format'=> 'This document must be in Word format',
            'letter_of_recommendation'=> 'Letter of Recommendation (LOR)',
            'upload_sop'=> 'Upload SOP',
            'experience_letters'=> 'Experience Letters',
            'other_certificates_documents'=> 'Other Certificates/Documents',
            'know_how_to_write_mou'=> 'If you want to know how to write an MOU, download the sample MOU.',
            'download_sample_mou'=> 'Download Sample MOU',
            'agree_to_above_terms_and_conditions'=> 'I agree to the above terms and conditions',
            
            
            'submitted_application_on '=> 'You have submitted application on ',
            // 'must_update_study_level'=> 'You must update Study Level in Course Preferences before you can upload documents.',
            'must_update_study_level'=> 'Please update "Interested Study Level" in Profile before you can upload documents.',
            //Detete File Warning
            'are_you_sure'=> 'Are you sure?',
            'want_to_delete'=> 'Do you want to delete?',
            'delete_it'=> 'Yes, delete it!',
            
            //Resources.views.frontend.index.blade.php

            'coaching_classes'=> 'Coaching Classes',
            'view_all_courses'=> 'View All Courses',
            'online_courses'=> 'Online Courses',
            'view_all_countries'=> 'View All Countries',
            'students'=> 'Students',
            
            'student_login_or_signup'=> 'Student? login/signup',
            'agent_panel'=> 'Agent Panel',
            'login'=> 'Login',
            'signup'=> 'Signup',
            'agents'=> 'Agents',
            'latest'=> 'Latest',
            'document'=>'Document',
            'application'=>'Application',
            'start_discussion'=>'Start a discussion with us.',

            
            //Account Controller

            'shipping_address_added'=> 'Shipping Address added!',
            
            //Overseas Controller
            'x_document_uploaded_successfully'=> ':x Uploaded Successfully.',

            // '10th_document_uploaded_successfully'=> '10th Document Uploaded Successfully.',
            // '12th_document_uploaded_successfully'=> '12th Document Uploaded Successfully.',
            // 'diploma_document_uploaded_successfully'=> 'Diploma Document Uploaded Successfully.',
            // 'bachelors_document_uploaded_successfully'=> 'Bachelors (All Sem) Document Uploaded Successfully.',
            // 'bachelors_provisional_document_uploaded_successfully'=> 'Bachelors Provisional Document Uploaded Successfully.',
            // 'consolidated_marks_memo_document_uploaded_successfully'=> 'Consolidated Marks Memo Document Uploaded Successfully.',
            // 'bachelors_degree_document_uploaded_successfully'=> 'Bachelors Degree Document Uploaded Successfully.',
            // 'masters_provisional_document_uploaded_successfully'=> 'Masters Provisional Document Uploaded Successfully.',
            // 'granduation_transcripts_uploaded_successfully'=> 'Granduation Transcripts Uploaded Successfully.',
            // 'masters_document_uploaded_successfully'=> 'Masters (All Sem) Document Uploaded Successfully.',
            // 'masters_degree_document_uploaded_successfully'=> 'Masters Degree Document Uploaded Successfully.',
            // 'masters_transcripts_uploaded_successfully'=> 'Masters Transcripts Uploaded Successfully.',
            'ielts_document_uploaded_successfully'=> 'IELTS Document Uploaded Successfully.',
            'pte_document_uploaded_successfully'=> 'PTE Document Uploaded Successfully.',
            'gre_document_uploaded_successfully'=> 'GRE Document Uploaded Successfully.',
            'gmat_document_uploaded_successfully'=> 'GMAT Document Uploaded Successfully.',
            'toefl_document_uploaded_successfully'=> 'TOEFL Document Uploaded Successfully.',
            'duolingo_document_uploaded_successfully'=> 'Duolingo Document Uploaded Successfully.',
            'the_file_may_not_be_greater_than'=> 'The file may not be greater than ',
            'the_files_may_not_be_greater_than'=> 'The files may not be greater than ',

            

        ],

        'user' => [
            'change_email_notice' => 'If you change your e-mail you will be logged out until you confirm your new e-mail address.',
            'email_changed_notice' => 'You must confirm your new e-mail address before you can log in again.',
            'profile_updated'  => 'Profile successfully updated.',
            'password_updated' => 'Password successfully updated.',
        ],
        'student' => [
           'para_one' => 'Update your Profile, Education details, Upload Documents',
           'para_two' => 'Learn about academic requirements, Which courses are available, Specific rules in countries, University Information, University Applications process',
           'para_three' => 'Our team of experts will evaluate your profile & suggest you the courses.',
           'para_four' => 'Track University Applications process. Fulfill requirements for University Applications stages.',
           'profile' => 'Your Profile & Educational Details',
           'profile_subheading' => 'Fill the below form & complete your personal & educational qualification details.',
           'message_sent_successfully' => 'Message sent successfully',
        ],

        'welcome_to' => 'Welcome to :place',
    ],
];
