<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Strings Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used in strings throughout the system.
    | Regardless where it is placed, a string can be listed here so it is easily
    | found in a intuitive way.
    |
    */

    'backend' => [
        'access' => [
            'users' => [
                'delete_user_confirm'   => '¿Está seguro de querer eliminar este Usuario de forma permanente? Esto puede producir un error grave en aquellas partes de la aplicación que hagan referencia al mismo. Proceda con cautela. Esta operación no puede deshacerse.',
                'if_confirmed_off'      => '(Si la confirmación está desactivada)',
                'no_deactivated'        => 'No hay usuarios desactivados.',
                'no_deleted'            => 'No hay usuarios eliminados.',
                'restore_user_confirm'  => '¿Restaurar este Usuario a su estado original?',
            ],
        ],

        'dashboard' => [
            'title'   => 'Panel de Administración',
            'welcome' => 'Bienvenido',
            'guest' => 'invitado',
        ],

        'general' => [
            'all_rights_reserved' => 'Todos los derechos reservados.',
            'are_you_sure'        => '¿Está seguro?',
            'boilerplate_link'    => 'Laravel 5 Boilerplate',
            'continue'            => 'Continuar',
            'member_since'        => 'Miembro desde',
            'minutes'             => ' minutos',
            'search_placeholder'  => 'Buscar...',
            'already'=>'ya',

            'timeout'             => 'Usted ha sido automaticamente desconectado por razones de seguridad ya que no tuvo actividad en ',

            'see_all' => [
                'messages'      => 'Ver todos los mensajes',
                'notifications' => 'Ver todo',
                'tasks'         => 'Ver todas las tareas',
            ],

            'status' => [
                'online'  => 'Conectado',
                'offline' => 'Desconectado',
            ],

            'you_have' => [
                'messages'      => '{0} No tiene nuevos mensajes|{1} Tiene un nuevo mensaje|[2,Inf] Tiene :number nuevos mensajes ',
                'notifications' => '{0} No tiene nuevas notificaciones|{1} Tiene una nueva notificación|[2,Inf] Tiene :number nuevas notificaciones',
                'tasks'         => '{0} No tiene nuevas tareas|{1} Tiene 1 nueva tarea|[2,Inf] Tiene :number nuevas tareas',
            ],
        ],

        'search' => [
            'empty'      => 'Por favor, escriba un término de búsqueda.',
            'incomplete' => 'Debe escribir su propia lógica de búsqueda para este sistema.',
            'title'      => 'Resultados de la búsqueda',
            'results'    => 'Resultados de la búsqueda para :query',
        ],

        'welcome' => 'Bienenvidos al Panel de Control',
    ],

    'emails' => [
        'auth' => [
            'account_confirmed'         => 'Su cuenta ha sido confirmada.',
            'error'                     => '¡Ups!',
            'greeting'                  => '¡Hola!',
            'regards'                   => 'Saludos,',
            'trouble_clicking_button'   => 'Si tiene problemas haciendo clic en el botón ":action_text", copie y pegue el enlace en su navegador:',
            'thank_you_for_using_app'   => '¡Gracias por utilizar nuestra aplicación!',

            'password_reset_subject'    => 'Su enlace de reinicio de contraseña',
            'password_cause_of_email'   => 'Ha recibido este correo porque hemos recibido una solicitud de reinicio de contraseña para su cuenta.',
            'password_if_not_requested' => 'Si usted no hizo la solicitud, no haga nada.',
            'reset_password'            => 'Pulse aquí para reiniciar su contraseña',

            'click_to_confirm'          => 'Pulse aquí para verificar su cuenta:',
        ],

        'contact' => [
            'email_body_title' => 'Tiene una nueva solicitud del formulario de contacto. A continuación los detalles:',
            'subject'          => '¡Nueva solicitud del formulario de contacto :app_name!',
        ],
    ],

    'frontend' => [
        'test' => 'Prueba',

        'tests' => [
            'based_on' => [
                'permission' => 'Basado en el Permiso - ',
                'role'       => 'Basado en el Rol - ',
            ],

            'js_injected_from_controller' => 'Javascript inyectado desde el Controlador',

            'using_blade_extensions'      => 'Usando las extensiones de Blade',

            'using_access_helper' => [
                'array_permissions'     => 'Uso de Access Helper con lista de nombres de Permisos o ID\'s donde el usuario tiene que tenerlos todos.',
                'array_permissions_not' => 'Uso de Access Helper con lista de nombres de Permisos o ID\'s donde el usuario no tiene por que tenerlos todos.',
                'array_roles'           => 'Uso de Access Helper con lista de nombres de Roles o ID\'s donde el usuario tiene que tenerlos todos.',
                'array_roles_not'       => 'Uso de Access Helper con lista de nombres de Roles o ID\'s donde el usuario no tiene que tenerlos todos.',
                'permission_id'         => 'Uso de Access Helper mediante ID de Permiso',
                'permission_name'       => 'Uso de Access Helper mediante nombre de Permiso',
                'role_id'               => 'Uso de Access Helper mediante ID de Rol',
                'role_name'             => 'Uso de Access Helper mediante nombre de Rol',
            ],

            'view_console_it_works'          => 'Mire la consola del navegador, deberia ver \'Funciona!!\' que tiene su origen en FrontendController@index',
            'you_can_see_because'            => 'Puede ver esto porque dispone del Rol \':role\'!',
            'you_can_see_because_permission' => 'Puede ver esto porque dispone del Permiso \':permission\'!',
        ],

        'general' => [
            'joined'        => 'Afiliado',
            'apply_for_study_abroad'        => "Solicitar estudios en el extranjero",
            //Study Abroad
            'country_information'        => "Información del país",
            'apply_for_overseas'        => "Solicitar en el extranjero",
            'course_suggestion'        => "Sugerencia de curso",
            'applications'        => "Aplicaciones",
            'completed_this_step'=> 'Ha completado este paso.',
            'update_Profile'=> 'Actualice "Nivel de estudio interesado" en Perfil para actualizar las preferencias del curso.',
            'program_preferences'=> 'Sus preferencias del programa',
            'add_new_program'=> 'Agregar nuevo programa',
            'Search_course_select_program'=> 'Busque un curso y seleccione el programa',
            'add_program'=> 'Agregar programa',
            'intake'=> 'Admisión',
            'manually_add_program'=> 'Agregar manualmente un programa',
            'selected_programs'=> 'Programas seleccionados',
            'complete_your_profile'=> 'Debe completar los detalles de su perfil antes de agregar las preferencias del curso',
            'added_by'=> 'Añadido por',
            //Documents
            'must_complete_profile'=> 'Debe completar los detalles de su perfil y las preferencias del curso antes de poder cargar documentos.',
            'file_size'=> 'El tamaño de cada archivo individual no debe exceder',
            'merged_file_size'=> 'El tamaño de los archivos combinados de todos los semestres no debe exceder',
            'academic_language_certificates'=> 'Académico, Certificados de Idiomas',
            'academic_certificates_and_document'=> 'Certificados y documentos académicos',
            'must_pdf_format'=> 'Los siguientes documentos deben estar en formato pdf.',
            'uploaded_file'=> 'Archivo cargado:',
            'replace_file'=> 'Reemplazar archivo',
            'required'=> 'Requerido',
            'essay'=> 'Ensayo',
            'upload_essay'=> 'Subir ensayo',
            'must_be'=> 'Debe ser',
            'uploading'=> 'Cargar...',
            'tests_or_english_certificates'=> 'Pruebas/Inglés Certificados',
            'upload_applicable_certificates'=> 'Cargue todos los certificados aplicables. Los documentos deben estar en formato pdf.',
            'allowed_file_types'=> 'Tipos de archivo permitidos:',
            'agree_to_the_above_terms'=> 'Acepto los términos y condiciones anteriores',
            'submit_application'=> 'Enviar solicitud',
            'you_have_submitted_application'=> 'Ha presentado su solicitud el',
            'other_certificates'=> 'Pasaporte, CV, LOR, SOP, Experiencia, Otros certificados',
            'download_sample_cv'=> 'Descargar CV de muestra',
            'maximum'=> 'Máxima',
            'document_must_be_in_word_format'=> 'Este documento debe estar en formato Word',
            'letter_of_recommendation'=> 'Carta de Recomendación (LOR)',
            'upload_sop'=> 'Upload SOP',
            'experience_letters'=> 'Cartas de experiencia',
            'other_certificates_documents'=> 'Otros Certificados/Documentos',
            'know_how_to_write_mou'=> 'If you want to know how to write an MOU, download the sample MOU.',
            'download_sample_mou'=> 'Download Sample MOU',
            'agree_to_above_terms_and_conditions'=> 'Acepto los términos y condiciones anteriores',
            'submitted_application_on '=> 'Ha presentado su solicitud el ',
            'must_update_study_level'=> 'Debe actualizar el nivel de estudio en las preferencias del curso antes de poder cargar documentos.',
            //Detete File Warning
            'are_you_sure'=> '¿Estás seguro?',
            'want_to_delete'=> '¿Quieres eliminar?',
            'delete_it'=> '¡Sí, bórralo!',
            
            //Resources.viewa.rontend.index.blade.php

            'coaching_classes'=> 'Clases de Coaching',
            'view_all_courses'=> 'Ver todos los cursos',
            'online_courses'=> 'Cursos en línea',
            'view_all_countries'=> 'Ver todos los países',
            'students'=> 'Estudiantes',
            
            'student_login_or_signup'=> '¿Alumno? Iniciar sesión/Registrarse',
            'agent_panel'=> 'Panel de agente',
            'login'=> 'Iniciar sesión',
            'signup'=> 'Regístrate',
            'agents'=> 'Agentes',
            'latest'=> 'Último',
            'document'=>'Documento',
            'application'=>'Solicitud',
            'start_discussion'=>'Iniciar una discusión .',

            
            
            //Account Controller

            'shipping_address_added'=> '¡Dirección de envío agregada!',
            
            //Overseas Controller
            
            '10th_document_uploaded_successfully'=> '10º Documento cargado correctamente.',
            '12th_document_uploaded_successfully'=> '12º Documento cargado correctamente.',
            'diploma_document_uploaded_successfully'=> 'El documento del diploma se ha cargado correctamente.',
            'bachelors_document_uploaded_successfully'=> 'Licenciaturas (todas las sem) Documento cargado con éxito.',
            'bachelors_provisional_document_uploaded_successfully'=> 'Documento provisional de Bachelors cargado con éxito.',
            'consolidated_marks_memo_document_uploaded_successfully'=> 'Documento de memorándum de marcas consolidadas cargado correctamente.',
            'bachelors_degree_document_uploaded_successfully'=> 'Documento de licenciatura cargado con éxito.',
            'masters_provisional_document_uploaded_successfully'=> 'El documento provisional de Masters se ha cargado correctamente.',
            'granduation_transcripts_uploaded_successfully'=> 'Las transcripciones de la concesión se han cargado correctamente.',
            'masters_document_uploaded_successfully'=> 'El documento Masters (todos los sem) se ha cargado correctamente.',
            'masters_degree_document_uploaded_successfully'=> 'Documento de maestría cargado con éxito.',
            'masters_transcripts_uploaded_successfully'=> 'Transcripciones de maestría cargadas exitosamente.',
            'ielts_document_uploaded_successfully'=> 'IELTS Documento cargado exitosamente.',
            'pte_document_uploaded_successfully'=> 'PTE Documento cargado exitosamente.',
            'gre_document_uploaded_successfully'=> 'GRE Documento cargado exitosamente.',
            'gmat_document_uploaded_successfully'=> 'GMAT Documento cargado exitosamente.',
            'toefl_document_uploaded_successfully'=> 'TOEFL Documento cargado exitosamente.',
            'duolingo_document_uploaded_successfully'=> 'Duolingo Documento cargado exitosamente.',
            'the_file_may_not_be_greater_than'=> 'El archivo no podrá ser mayor que ',
            'the_files_may_not_be_greater_than'=> 'Los archivos no pueden ser mayores que ',
        ],

        'user' => [
            'change_email_notice'  => 'Si cambia su correo electrónico, se cerrará la sesión hasta que confirme su nueva dirección de correo electrónico.',
            'email_changed_notice' => 'Debe confirmar su nueva dirección de correo electrónico antes de poder iniciar sesión de nuevo.',
            'profile_updated'      => 'Perfil actualizado correctamente.',
            'password_updated'     => 'Contraseña actualizada correctamente.',
        ],
        'student' => [
            'para_one' => 'Actualice su perfil, detalles educativos, cargue documentos',
            'para_two' => 'Conozca los requisitos académicos, qué cursos están disponibles, reglas específicas en los países, información universitaria, proceso de solicitudes universitarias',
            'para_three' => 'Nuestro equipo de expertos evaluará tu perfil y te sugerirá los cursos.',
            'para_four' => 'Seguimiento del proceso de solicitudes universitarias. Cumplir con los requisitos para las etapas de Solicitudes Universitarias.',
            'profile' => 'Su perfil y detalles educativos',
            'profile_subheading' => 'Rellene el siguiente formulario y complete sus datos personales y educativos.',
            'message_sent_successfully' => 'Mensaje enviado con éxito',
         ],
 
 

        'welcome_to' => 'Bienvenido a :place',
    ],
];
