<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Exception Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used in Exceptions thrown throughout the system.
    | Regardless where it is placed, a button can be listed here so it is easily
    | found in a intuitive way.
    |
    */

    'backend' => [
        'access' => [
            'roles' => [
                'already_exists'    => 'این نقش در حال حاضر وجود دارد. لطفا نام دیگری را انتخاب کنید.',
                'cant_delete_admin' => 'شما نمی‌توانید نقش مدیر را حذف کنید.',
                'create_error'      => 'مشکلی در ایجاد این نقش وجود داشت. لطفا دوباره تلاش کنید.',
                'delete_error'      => 'مشکلی در حذف این نقش وجود داشت. لطفا دوباره تلاش کنید.',
                'has_users'         => 'شما نمی‌توانید یک نقش را با کاربران مرتبط حذف کنید.',
                'needs_permission'  => 'شما باید حداقل یک مجوز برای این نقش انتخاب کنید.',
                'not_found'         => 'این نقش وجود ندارد.',
                'update_error'      => 'مشکلی در به‌روز رسانی این نقش وجود داشت. لطفا دوباره تلاش کنید.',
            ],

            'users' => [
                'already_confirmed'     => 'این کاربر قبلا تایید شده است.',
                'cant_confirm'          => 'مشکلی در تأیید حساب کاربری وجود داشت.',
                'cant_deactivate_self'  => 'شما نمی‌توانید این کار را برای خود انجام دهید.',
                'cant_delete_admin'     => 'شما نمی‌توانید مدیر کل را حذف کنید.',
                'cant_delete_self'      => 'شما نمی‌توانید خودتان را حذف کنید',
                'cant_delete_own_session' => 'شما نمی‌توانید جلسه خود را حذف کنید.',
                'cant_restore'          => 'این کاربر حذف نشده است بنابراین نمی‌توان آن را بازیابی کرد.',
                'cant_unconfirm_admin'  => 'شما نمی‌توانید مدیر کل را رد یا تأیید کنید',
                'cant_unconfirm_self'   => 'شما نمی‌توانید خودتان را رد یا تأیید کنید.',
                'create_error'          => 'مشکلی در ایجاد این کاربر ایجاد شد. لطفا دوباره تلاش کنید.',
                'delete_error'          => 'مشکلی در حذف این کاربر ایجاد شد. لطفا دوباره تلاش کنید.',
                'delete_first'          => 'این کاربر قبل از اینکه بتواند حذف همیشگی شود ابتدا باید حذف شود.',
                'email_error'           => 'این رایانامه متعلق به کاربر دیگری است.',
                'mark_error'            => 'مشکلی در ویرایش این کاربر ایجاد شد. لطفا دوباره تلاش کنید.',
                'not_confirmed'         => 'این کاربر تائید نشده است.',
                'not_found'             => 'این کاربر وجود ندارد.',
                'restore_error'         => 'مشکلی در بازیابی این کاربر ایجاد شد. لطفا دوباره تلاش کنید.',
                'role_needed_create'    => 'شما باید حداقل یک نقش را انتخاب کنید.',
                'role_needed'           => 'شما باید حداقل یک نقش را انتخاب کنید.',
                'session_wrong_driver'  => 'راه‌انداز جلسه شما باید برای استفاده از این ویژگی به پایگاه داده تنظیم شود.',
                'social_delete_error'   => 'مشکلی در حذف حساب کاربری شبکه اجتماعی کاربر وجود داشت.',
                'update_error'          => 'مشکلی در ویرایش این کاربر ایجاد شد. لطفا دوباره تلاش کنید.',
                'update_password_error' => 'مشکلی در تغییر گذرواژه این کاربر ایجاد شد. لطفا دوباره تلاش کنید.',
            ],
        ],
    ],

    'frontend' => [
        'auth' => [
            'confirmation' => [
                'already_confirmed' => 'حساب کاربری شما قبلا تایید شده است.',
                'confirm'           => 'اکانت خود را تائید کنید!',
                'created_confirm'   => 'حساب شما با موفقیت ایجاد شد. ما برای تأیید حساب کاربری، یک رایانامه فرستادیم',
                'created_pending'   => 'حساب شما با موفقیت ایجاد شد و مورد تایید قرار دارد. در صورت تأیید حساب شما، یک رایانامه ارسال می‌شود.',
                'mismatch'          => 'کد تأیید شما مطابقت ندارد.',
                'not_found'         => 'این کد تأیید وجود ندارد.',
                'pending'           => 'حساب شما در حال تایید است.',
                'resend'            => 'حساب شما تأیید نشده است لطفا روی پیوند تأیید در رایانامه خود کلیک کنید یا برای ارسال مجدد تأیید رایانامه <a href="'.route('frontend.auth.account.confirm.resend', ':user_uuid').'">اینجا</a> را کلیک کنید.',
                'success'           => 'حساب شما با موفقیت تایید شده است!',
                'resent'            => 'یک رایانامه تایید جدید به آدرس در فایل فرستاده شده است.',
            ],

            'deactivated' => 'حساب کاربری شما غیرفعال شده است.',
            'email_taken' => 'این رایانامه قبلا گرفته شده است.',

            'password' => [
                'change_mismatch' => 'این گذرواژه قدیمی شما نیست.',
                'reset_problem' => 'یک مشکل بازنشانی گذرواژه شما وجود داشت. لطفا رایانامه بازنشانی گذرواژه را دوباره ارسال کنید.',
            ],

            'registration_disabled' => 'ثبت نام در حال حاضر بسته است.',
        ],
    ],
];
