<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Strings Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used in strings throughout the system.
    | Regardless where it is placed, a string can be listed here so it is easily
    | found in a intuitive way.
    |
    */

    'backend' => [
        'access' => [
            'users' => [
                'delete_user_confirm'  => 'Êtes-vous sûr de vouloir supprimer cet utilisateur de façon permanente ? Toutes les références à cet utilisateur dans cette application peuvent provoquer des erreurs et cette opération ne peut être annullée.',
                'if_confirmed_off'     => '(pour le mode sans confirmation)',
                'restore_user_confirm' => 'Restaurer cet utilisateur à son statut original ?',
            ],
        ],

        'dashboard' => [
            'title'   => "Tableau de bord de l'administration",
            'welcome' => 'Bienvenue',
            'guest' => 'invité',
        ],

        'general' => [
            'all_rights_reserved' => 'Tous droits réservés.',
            'are_you_sure'        => 'Êtes-vous sûr ?',
            'boilerplate_link'    => 'Laravel 5 Boilerplate',
            'continue'            => 'Continuer',
            'member_since'        => 'Membre depuis',
            'minutes'             => ' minutes.',
            'search_placeholder'  => 'Rechercher...',
            'already'=>'déjà',
            'timeout'             => 'Vous avez été automatiquement déconnecté pour cause d\'inactivité pendant ',

            'see_all' => [
                'messages'      => 'Voir tous les messages',
                'notifications' => 'Voir toutes les notifications',
                'tasks'         => 'Voir les nouvelles tâches',
            ],

            'status' => [
                'online'  => 'En ligne',
                'offline' => 'Hors ligne',
            ],

            'you_have' => [
                'messages'      => "{0} Vous n'avez pas de message|{1} Vous avez 1 message|[2,Inf] Vous avez :number messages",
                'notifications' => "{0} Vous n'avez pas de notification|{1} Vous avez 1 notification|[2,Inf] Vous avez :number notifications",
                'tasks'         => "{0} Vous n'avez pas de tâche affectée|{1} Vous avez 1 tâche affectée|[2,Inf] Vous avez :number tâches affectées",
            ],
        ],

        'search' => [
            'empty'      => 'Veuillez entrer un terme de recherche.',
            'incomplete' => 'Vous devez mettre en place votre propre logique pour ce système.',
            'title'      => 'Résultats de recherche',
            'results'    => 'Résultats de la recherche :query',
        ],

        'welcome' => 'Welcome to the Dashboard',
    ],

    'emails' => [
        'auth' => [
            'account_confirmed' => 'Votre compte a été confirmé.',
            'error'                   => 'Oups !',
            'greeting'                => 'Bonjour !',
            'regards'                 => 'Salutations,',
            'trouble_clicking_button' => "Si vous ne pouvez pas cliquer sur le bouton ':action_text', copiez et collez l'URL ci-dessous dans un navigateur:",
            'thank_you_for_using_app' => "Merci d'utiliser notre application !",

            'password_reset_subject'    => 'Votre lien de réinitialisation',
            'password_cause_of_email'   => 'Vous recevez cet email car nous avons reçu une demande de réinitialisation de mot de passe pour ce compte.',
            'password_if_not_requested' => "Si vous n'avez pas effectué cette demande, aucune autre action n'est requise.",
            'reset_password'            => 'Cliquez ici pour réinitialiser votre mot de passe',

            'click_to_confirm' => 'Cliquez ici pour confirmer votre compte :',
        ],

        'contact' => [
            'email_body_title' => 'Vous avez une nouvelle prise de contact dont voici les détails :',
            'subject' => 'Nouvelle soumission du formulaire de contact sur :app_name !',
        ],
    ],

    'frontend' => [
        'test' => 'Test',

        'tests' => [
            'based_on' => [
                'permission' => 'Helper sur la base de la permissions : ',
                'role'       => 'Helper sur la base du rôle : ',
            ],

            'js_injected_from_controller' => 'Javascript injecté depuis un contrôleur',

            'using_blade_extensions' => 'Utilisation des extensions Blade',

            'using_access_helper' => [
                'array_permissions'     => "L'utilisateur doit disposer de toutes les permissions d'un tableau, identifiées soit par leur ID, soit par leur nom.",
                'array_permissions_not' => "L'utilisateur doit disposer d'au moins une des permissions d'un tableau, identifiées soit par leur ID, soit par leur nom.",
                'array_roles'           => "L'utilisateur doit disposer de tous les rôles d'un tableau, identifiés soit par leur ID, soit par leur nom.",
                'array_roles_not'       => "L'utilisateur doit disposer d'au moins un des rôles d'un tableau, identifiés soit par leur ID, soit par leur nom.",
                'permission_id'         => "L'utilisateur doit disposer d'une permission identifiée par son ID",
                'permission_name'       => "L'utilisateur doit disposer d'une permission identifiée par son nom",
                'role_id'               => "L'utilisateur doit disposer d'un rôle identifié par son ID",
                'role_name'             => "L'utilisateur doit disposer d'un rôle identifié par son nom",
            ],

            'view_console_it_works'          => 'Sur la console du navigateur, vous devriez voir \'it works!\', ce qui est produit depuis le FrontendController@index',
            'you_can_see_because'            => 'Vous voyez ce message car vous disposez du rôle \':role\' !',
            'you_can_see_because_permission' => 'Vous voyez ce message car vous disposez de la permission \':permission\' !',
        ],

        'general' => [
            'joined'        => 'Membre depuis',
            'apply_for_study_abroad'        => "Postuler pour étudier à l’étranger",
            //Study Abroad
            'country_information'        => "Informations sur le pays",
            'apply_for_overseas'        => "Postuler pour l’outre-mer",
            'course_suggestion'        => "Suggestion de cours",
            'applications'        => "Applications",
            'completed_this_step.'=> 'Vous avez terminé cette étape.',
            'update_Profile'=> 'Veuillez mettre à jour « Niveau d’étude intéressé » dans le profil, pour mettre à jour les préférences de cours.',
            'program_preferences'=> 'Vos préférences de programme',
            'add_new_program'=> 'Ajouter un nouveau programme',
            'Search_course_select_program'=> 'Rechercher un cours et sélectionner un programme',
            'add_program'=> 'Ajouter un programme',
            'intake'=> 'Prise',
            'manually_add_program'=> 'Ajouter manuellement un programme',
            'selected_programs'=> 'Programmes sélectionnés',
            'complete_your_profile'=> 'Vous devez compléter les détails de votre profil avant d’ajouter les préférences de cours',
            'added_by'=> 'Ajouté par',
             //document upload
             'must_update_study_level'=> 'Vous devez mettre à jour le niveau d’étude dans les préférences de cours avant de pouvoir télécharger des documents.',
             'must_complete_profile'=> 'Vous devez compléter les détails de votre profil et de vos préférences de cours avant de pouvoir télécharger des documents.',
             'file_size'=> 'La taille de chaque fichier ne doit pas dépasser',
             'merged_file_size'=> 'La taille de tous les fichiers fusionnés semestriels ne doit pas dépasser',
             'academic_language_certificates'=> 'Académique, Certificats de langue',
             'academic_certificates_and_document'=> 'Certificats et documents académiques',
             'must_pdf_format'=> 'Les documents suivants doivent être en format pdf.',
             'replace_file'=> 'Remplacer le fichier',
             'required'=> 'Requis',
             'essay'=> 'Essai',
             'upload_essay'=> 'Télécharger l’essai',
             
             'must_be'=> 'Doit être',
             'uploading'=> 'Téléchargement...',
             'tests_or_english_certificates'=> 'Tests/Anglais Certificats',
             'upload_applicable_certificates'=> 'Téléchargez tous les certificats applicables. Les documents doivent être en format pdf.',
             'allowed_file_types'=> 'Types de fichiers autorisés :',
             'agree_to_the_above_terms'=> 'J’accepte les termes et conditions ci-dessus',
             'submit_application'=> 'Soumettre une demande',
             'you_have_submitted_application'=> 'Vous avez soumis votre candidature le',
             'other_certificates'=> 'Passeport, CV, LOR, SOP, Expérience, Autres certificats',
             'download_sample_cv'=> 'Télécharger un exemple de CV',
             'maximum'=> 'Maximum',
             'document_must_be_in_word_format'=> 'Ce document doit être en format Word',
             'upload_sop'=> 'Upload SOP',
             'experience_letters'=> 'Lettres d’expérience',
             'other_certificates_documents'=> 'Autres certificats/documents',
             'know_how_to_write_mou'=> 'If you want to know how to write an MOU, download the sample MOU.',
             'uploaded_file'=> 'Fichier téléchargé :',
             'download_sample_mou'=> 'Download Sample MOU',
             'agree_to_above_terms_and_conditions'=> 'J’accepte les termes et conditions ci-dessus',
             
             'submitted_application_on '=> 'Vous avez soumis votre candidature le ',
             'letter_of_recommendation'=> 'Lettre de recommandation (LOR)',
            //Detete File Warning
            'are_you_sure'=> 'Es-tu sûr?',
            'want_to_delete'=> 'Voulez-vous supprimer ?',
            'delete_it'=> 'Oui, supprimez-le !',

            //Resources.views.frontend.index.blade.php


            'coaching_classes'=> 'Cours de coaching',
            'view_all_courses'=> 'Voir tous les cours',
            'online_courses'=> 'Cours en ligne',
            'view_all_countries'=> 'Visualizza tutti i paesi',
            'students'=> 'Étudiants',
            'student_login_or_signup'=> 'Étudiant? connectez-vous/S’inscrire',
            'agent_panel'=> 'Panneau d’agent',
            'login'=> 'Connectez-vous',
            'signup'=> 'S’inscrire',
            'agents'=> 'Agents',
            'latest'=> 'Dernier',
            'document'=>'Document',
            'application'=>'Application',
            'start_discussion'=>'Lancez une discussion avec nous.',
            //Account Controller

            'shipping_address_added'=> 'Adresse de livraison ajoutée !',
            
            //Overseas Controller
            
            '10th_document_uploaded_successfully'=> '10ème document téléchargé avec succès.',
            '12th_document_uploaded_successfully'=> '12ème document téléchargé avec succès.',
            'diploma_document_uploaded_successfully'=> 'Document de diplôme téléchargé avec succès.',
            'bachelors_document_uploaded_successfully'=> 'Baccalauréat (tous les sem) Document téléchargé avec succès.',
            'bachelors_provisional_document_uploaded_successfully'=> 'Le document provisoire du baccalauréat a été téléchargé avec succès.',
            'consolidated_marks_memo_document_uploaded_successfully'=> 'Consolidated Marks Memo Document téléchargé avec succès.',
            'bachelors_degree_document_uploaded_successfully'=> 'Document de baccalauréat téléchargé avec succès.',
            'masters_provisional_document_uploaded_successfully'=> 'Le document provisoire Masters a été téléchargé avec succès.',
            'granduation_transcripts_uploaded_successfully'=> 'Transcriptions de Granduation téléchargées avec succès.',
            'masters_document_uploaded_successfully'=> 'Document Masters (All Sem) téléchargé avec succès.',
            'masters_degree_document_uploaded_successfully'=> 'Document de maîtrise téléchargé avec succès.',
            'masters_transcripts_uploaded_successfully'=> 'Relevés de notes de maîtrise téléchargés avec succès.',
            'ielts_document_uploaded_successfully'=> 'IELTS Document téléchargé avec succès.',
            'pte_document_uploaded_successfully'=> 'PTE Document téléchargé avec succès.',
            'gre_document_uploaded_successfully'=> 'GRE Document téléchargé avec succès.',
            'gmat_document_uploaded_successfully'=> 'GMAT Document téléchargé avec succès.',
            'toefl_document_uploaded_successfully'=> 'TOEFL Document téléchargé avec succès.',
            'duolingo_document_uploaded_successfully'=> 'Duolingo Document téléchargé avec succès.',
            'the_file_may_not_be_greater_than'=> 'Le fichier ne peut pas être plus grand que ',
            'the_files_may_not_be_greater_than'=> 'Les fichiers ne peuvent pas être plus grands que ',
        ],

        'user' => [
            'change_email_notice' => "Si vous changez votre adresse email vous serez déconnecté jusqu'à que vous confirmiez votre nouvelle adresse email.",
            'email_changed_notice' => 'Vous devez confirmer votre nouvelle adresse email avant de pouvoir vous connecter de nouveau.',
            'profile_updated'  => 'Profil modifié avec succès.',
            'password_updated' => 'Mot de passe modifié avec succès.',
        ],
        'student' => [
            'para_one' => 'Mettez à jour votre profil, les détails de votre formation, téléchargez des documents',
            'para_two' => "En savoir plus sur les exigences académiques, les cours disponibles, les règles spécifiques dans les pays, les informations sur l'université, le processus de candidature à l'université.",
            'para_three' => "Notre équipe d'experts évaluera votre profil et vous proposera les cours.",
            'para_four' => "Suivez le processus de candidature à l’université. Remplissez les exigences des étapes de candidature à l’université.",
            'profile' => 'Votre profil et les détails de votre formation',
            'profile_subheading' => 'Remplissez le formulaire ci-dessous et complétez les détails de votre qualification personnelle et éducative.',
            'message_sent_successfully' => 'Message envoyé avec succès',
         ],
 
 

        'welcome_to' => 'Bienvenue sur :place',
    ],
];
