<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Strings Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used in strings throughout the system.
    | Regardless where it is placed, a string can be listed here so it is easily
    | found in a intuitive way.
    |
    */

    'backend' => [
        'access' => [
            'users' => [
                'delete_user_confirm'  => "Sei sicuro di voler eliminare definitivamente questo utente? Ovunque ci sia un riferimento a questo utente all'interno dell'applicazione si vedrà un errore. Procedi a tuo rischio e pericolo, non si potrà annullare questa operazione.",
                'if_confirmed_off'     => '(Se non è confermato)',
                'restore_user_confirm' => "Ripristinare l'utente al suo stato originario?",
            ],
        ],

        'dashboard' => [
            'title'   => 'Dashboard Amministrazione',
            'welcome' => 'Benvenuto',
            'guest' => 'ospite',
        ],

        'general' => [
            'all_rights_reserved' => 'Tutti i diritti riservati.',
            'are_you_sure'        => 'Sei sicuro?',
            'boilerplate_link'    => 'Laravel 5 Boilerplate',
            'continue'            => 'Continua',
            'member_since'        => 'Membro dal',
            'minutes'             => ' minutes',
            'search_placeholder'  => 'Cerca...',
            'already'=>'Già',

            'timeout'             => 'You were automatically logged out for security reasons since you had no activity in ',

            'see_all' => [
                'messages'      => 'Visualizza tutti i messaggi',
                'notifications' => 'Visualizza tutte',
                'tasks'         => 'Visualizza tutti i compiti',
            ],

            'status' => [
                'online'  => 'Online',
                'offline' => 'Offline',
            ],

            'you_have' => [
                'messages'      => '{0} Non hai messaggi|{1} Hai un messaggio|[2,Inf] Hai :number messaggi',
                'notifications' => '{0} Non hai notifiche|{1} Hai una notifica|[2,Inf] Hai :number notifiche',
                'tasks'         => '{0} Non hai compiti|{1} Hai un compito|[2,Inf] Hai :number compiti',
            ],
        ],

        'search' => [
            'empty'      => 'Please enter a search term.',
            'incomplete' => 'You must write your own search logic for this system.',
            'title'      => 'Search Results',
            'results'    => 'Search Results for :query',
        ],

        'welcome' => 'Welcome to the Dashboard',
    ],

    'emails' => [
        'auth' => [
            'account_confirmed' => 'Your account has been confirmed.',
            'error'                   => 'Whoops!',
            'greeting'                => 'Hello!',
            'regards'                 => 'Regards,',
            'trouble_clicking_button' => 'If you’re having trouble clicking the ":action_text" button, copy and paste the URL below into your web browser:',
            'thank_you_for_using_app' => 'Thank you for using our application!',

            'password_reset_subject'    => 'Il tuo link per il reset della password',
            'password_cause_of_email'   => 'You are receiving this email because we received a password reset request for your account.',
            'password_if_not_requested' => 'If you did not request a password reset, no further action is required.',
            'reset_password'            => 'Clicca qui per resettare la tua password',

            'click_to_confirm' => 'Clicca qui per confermare il tuo account:',
        ],

        'contact' => [
            'email_body_title' => 'You have a new contact form request: Below are the details:',
            'subject' => 'A new :app_name contact form submission!',
        ],
    ],

    'frontend' => [
        'test' => 'Test',

        'tests' => [
            'based_on' => [
                'permission' => 'Basato su permessi - ',
                'role'       => 'Basato su ruoli - ',
            ],

            'js_injected_from_controller' => 'Javascript iniettato da un controller',

            'using_blade_extensions' => 'Usando estensioni Blade',

            'using_access_helper' => [
                'array_permissions'     => "Si sta usando l'Access Helper con un array di nomi o ID di permessi, l'utente li deve possedere tutti.",
                'array_permissions_not' => "Si sta usando l'Access Helper con un array di nomi o ID di permessi, l'utente non li deve possedere tutti.",
                'array_roles'           => "Si sta usando l'Access Helper con un array di nomi o ID di ruoli, l'utente li deve possedere tutti.",
                'array_roles_not'       => "Si sta usando l'Access Helper con un array di nomi o ID di ruoli, l'utente non li deve possedere tutti.",
                'permission_id'         => "Si sta usando l'Access Helper con un ID di permesso",
                'permission_name'       => "Si sta usando l'Access Helper con un nome di permesso",
                'role_id'               => "Si sta usando l'Access Helper con un ID di ruolo",
                'role_name'             => "Si sta usando l'Access Helper con un nome di ruolo",
            ],

            'view_console_it_works'          => 'Apri la console Javascript del browser, dovresti vedere \'it works!\' generato da FrontendController@index',
            'you_can_see_because'            => 'Puoi vedere questo perché il tuo ruolo è \':role\'!',
            'you_can_see_because_permission' => 'Puoi vedere questo perché hai il permesso \':permission\'!',
        ],

        'general' => [
            'joined'        => 'Joined',
            'apply_for_study_abroad'        => "Candidarsi per studiare all'esteroa",
            //Study Abroad
            'country_information'        => "Informazioni sul paese",
            'apply_for_overseas'        => "Richiedi l'iscrizione all'estero",
            'course_suggestion'        => "Suggerimento per il corso",
            'applications'        => "Applicazioni",
            'completed_this_step'=> 'Hai completato questo passaggio.',
            'update_Profile'=> 'Actualice "Nivel de estudio interesado" en Perfil para actualizar las preferencias del curso. ...',
            'program_preferences'=> 'Preferenze del programma',
            'add_new_program'=> 'Aggiungi nuovo programma',
            'Search_course_select_program'=> 'Cerca un corso e seleziona il programma',
            'add_program'=> 'Aggiungi programma',
            'intake'=> 'Assunzione',
            'manually_add_program'=> 'Aggiunta manuale di un programma',
            'selected_programs'=> 'Programmi selezionati',
            'complete_your_profile'=> 'Devi completare i dettagli del tuo profilo prima di aggiungere le preferenze del corso',
            'added_by'=> 'Aggiunto da',
            //Document
            'must_update_study_level'=> 'È necessario aggiornare il livello di studio nelle Preferenze del corso prima di poter caricare i documenti.',
            'must_complete_profile'=> 'È necessario completare i dettagli del profilo e delle preferenze del corso prima di poter caricare i documenti.',
            'file_size'=> 'Ogni singola dimensione del file non deve superare',
            'merged_file_size'=> 'La dimensione del file unito per tutto il semestre non deve superare',
            'academic_language_certificates'=> 'Accademico, Certificazioni linguistiche',
            'academic_certificates_and_document'=> 'Certificati accademici e documenti',
            'must_pdf_format'=> 'I seguenti documenti devono essere in formato pdf.',
            'uploaded_file'=> 'File caricato:',
            'replace_file'=> 'Sostituisci file',
            'required'=> 'Necessario',
            'essay'=> 'Saggio',
            'upload_essay'=> 'Carica saggio',
            'must_be'=> 'Deve essere',
            'tests_or_english_certificates'=> 'Test/Inglese Certificati',
            'upload_applicable_certificates'=> 'Carica tutti i certificati applicabili. I documenti devono essere in formato pdf.',
            
            'allowed_file_types'=> 'Tipi di file consentiti:',
            'agree_to_the_above_terms'=> 'Accetto i termini e le condizioni di cui sopra',
            'submit_application'=> 'Invia la tua candidatura',
            'you_have_submitted_application'=> 'Hai presentato la tua candidatura il',
            'other_certificates'=> 'Passaporto, CV, LOR, SOP, Esperienza, Altri Certificati',
            'download_sample_cv'=> 'Scarica il CV di esempio',
            'maximum'=> 'Massima',
            'document_must_be_in_word_format'=> 'Questo documento deve essere in formato Word',
            'letter_of_recommendation'=> 'Lettera di raccomandazione (LOR)',
            'upload_sop'=> 'Upload SOP',
            'experience_letters'=> 'Lettere di esperienza',
            'other_certificates_documents'=> 'Altri certificati/documenti',
            'know_how_to_write_mou'=> 'If you want to know how to write an MOU, download the sample MOU.',
            'download_sample_mou'=> 'Download Sample MOU',
            'agree_to_above_terms_and_conditions'=> 'Accetto i termini e le condizioni di cui sopra',
            'submitted_application_on '=> 'You have submitted application on ',
            'uploading'=> 'Caricamento...',
            //Detete File Warning
            'are_you_sure'=> 'Sei sicuro?',
            'want_to_delete'=> 'Vuoi eliminare?',
            'delete_it'=> 'Sì, eliminalo!',
            
            
            //Resources.views.frontend.index.blade.php

            'coaching_classes'=> 'Corsi di coaching',
            'view_all_courses'=> 'Visualizza tutti i corsi',
            'online_courses'=> 'Corsi online',
            'fiview_all_countriesle'=> 'Visualizza tutti i paesi',
            'students'=> 'Sstudente',
            'student_login_or_signup'=> 'Alunno? accesso/registrati',
            'agent_panel'=> "Pannello dell'agente",
            'login'=> 'accesso',
            'signup'=> 'iscrizione',
            'agents'=> 'Agenti',
            'latest'=> 'Ultimo',
            'document'=>'Documento',
            'application'=>'Applicazione',
            'start_discussion'=>'Avvia una discussione con noi.',
          
            
            
            
            //Account Controller

            'shipping_address_added'=> 'Indirizzo di spedizione aggiunto!',
            
            //Overseas Controller
            
            '10th_document_uploaded_successfully'=> '10° documento caricato con successo.',
            '12th_document_uploaded_successfully'=> '12° documento caricato con successo.',
            'diploma_document_uploaded_successfully'=> 'Documento di diploma caricato con successo.',
            'bachelors_document_uploaded_successfully'=> 'Bachelor (tutti i SEM) Documento caricato con successo.',
            'bachelors_provisional_document_uploaded_successfully'=> 'Documento provvisorio di laurea caricato con successo.',
            'consolidated_marks_memo_document_uploaded_successfully'=> 'Il documento Consolidated Marks Memo è stato caricato correttamente.',
            'bachelors_degree_document_uploaded_successfully'=> 'Documento di laurea triennale caricato con successo.',
            'masters_provisional_document_uploaded_successfully'=> 'Il documento provvisorio dei master è stato caricato correttamente.',
            'granduation_transcripts_uploaded_successfully'=> 'Le trascrizioni di Granduation sono state caricate correttamente.',
            'masters_document_uploaded_successfully'=> 'Il documento master (tutti i sem) è stato caricato correttamente.',
            'masters_degree_document_uploaded_successfully'=> 'Documento di laurea magistrale caricato con successo.',
            'masters_transcripts_uploaded_successfully'=> 'Le trascrizioni dei master sono state caricate correttamente.',
            'ielts_document_uploaded_successfully'=> 'IELTS Document Uploaded Successfully.',
            'pte_document_uploaded_successfully'=> 'PTE Documento caricato correttamente.',
            'gre_document_uploaded_successfully'=> 'GRE Documento caricato correttamente.',
            'gmat_document_uploaded_successfully'=> 'GMAT Documento caricato correttamente.',
            'toefl_document_uploaded_successfully'=> 'TOEFL Documento caricato correttamente.',
            'duolingo_document_uploaded_successfully'=> 'Duolingo Documento caricato correttamente.',
            'the_file_may_not_be_greater_than'=> 'Il file non può essere più grande di ',
            'the_files_may_not_be_greater_than'=> 'I file non possono essere più grandi di ',
            
        ],

        'user' => [
            'change_email_notice' => 'If you change your e-mail you will be logged out until you confirm your new e-mail address.',
            'email_changed_notice' => 'You must confirm your new e-mail address before you can log in again.',
            'profile_updated'  => 'Profilo aggiornato con successo.',
            'password_updated' => 'Password aggiornata con successo.',
        ],

        'student' => [
            'para_one' => "Aggiorna il tuo profilo, i dettagli dell'istruzione, carica i documenti",
            'para_two' => "Scopri i requisiti accademici, quali corsi sono disponibili, regole specifiche nei paesi, informazioni sull'università, processo di iscrizione all'università",
            'para_three' => 'Il nostro team di esperti valuterà il tuo profilo e ti suggerirà i corsi.',
            'para_four' => "Tieni traccia del processo di candidatura all'università. Soddisfare i requisiti per le fasi delle domande universitarie.",
            'profile' => 'Il tuo profilo e i tuoi dettagli educativi',
            'profile_subheading' => 'Compila il modulo sottostante e completa i dettagli del tuo titolo di studio personale e formativo.',
            'message_sent_successfully' => 'Messaggio inviato con successo',
         ],
 
 
        'welcome_to' => 'Benvenuto su :place',
    ],
];
