<!DOCTYPE html>
<html>
    <head>
        <title>{{ $uniData->university_name }} Ad-hoc Invoice #{{$invoice->invoice_num}}</title>
        <style type="text/css">
        @font-face {
                    font-family: 'Roboto';
                    font-style: normal;
                    font-weight: 400;
                    src: local('Roboto Light'), local('Roboto-Light'), url(https://themes.googleusercontent.com/static/fonts/roboto/v9/Pru33qjShpZSmG3z6VYwnT8E0i7KZn-EPnyo3HZu7kw.woff) format('woff');
            }
            body {
                font-family: 'Roboto', sans-serif;
                color: #121212;
                font-style: normal;
                font-size: 14px;
            }
            th {
                font-weight: 600;
                font-style: normal;
            }
            table.bordered td, th {
                font-style: normal;
                border: 1px solid #808080;
                margin:0;
            }
        </style>        
    </head>
<body>
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-md-12">
                <div class="card card-body printableArea" style="">
                    <div class="row">
                        <div class="col-sm-5">
                            <h3 class="card-title mb-0">
                                <table style="width: 100%;">
                                    <tr>
                                        <td>
                                            <?php
                                            if(get_business_details($invoice->business_id)->logo){
                                                $logo = get_business_details($invoice->business_id)->logo;
                                            }
                                            else{
                                                $logo = asset('storage/'.get_site_config('website_logo')); 
                                            }
                                            ?>
                                        <img src="{{ asset('storage/'.$logo) }}" style="height:80px">
                                        </td>
                                        <td>
                                            <address style="font-style: normal;padding-left: 5px;">
                                                <p style=""><b>{{get_business_details($invoice->business_id)->name}}</b><br>
                                                    {!!get_business_details($invoice->business_id)->address!!} <br/>
                                                    Ph: {!!get_business_details($invoice->business_id)->phone!!} <br/>
                                                    Email: {!!get_business_details($invoice->business_id)->email!!}<br>
                                                    @lang('labels.general.taxid'): {!!get_business_details($invoice->business_id)->tax_id!!}<br><br/>
                                                    </p>
                                            </address>
                                        </td>
                                        <td>
                                            <h3 style="float:right; font-size: 20px;">INVOICE</h3>
                                        </td>
                                    </tr>
                                </table>
                            </h3>
                        </div>
                    </div>
                    <br>
                    <div class="row mt-4">
                        <div class="col-md-4">
                            <div style="float: left">
                                <address style="width: 60%;">
                                    <p style="font-style: normal;"><b>Bill To</b></p>
                                    <p style="font-style: normal;">
                                        {{$uniData->university_name}} <br />
                                        @php
                                            $address = "";
                                            if($uniData){
                                                if($uniData->address){
                                                    $address .= $uniData->address.", " ;
                                                }
                                                if($uniData->country){
                                                    $address .= get_country_name($uniData->country);
                                                }
                                            }
                                        @endphp
                                        @if($address)
                                            {!! $address !!}<br />
                                        @endif
                                    </p>
                                </address>
                            </div>            
                            <div style="float: right;width:150px;">
                                <address style="font-style: normal;">
                                    <p class="font-bold"><b>Invoice #{{$invoice->invoice_num}}</b></p>
                                    <p class="text-muted m-l-30">
                                        Created: {{date('d/m/Y', strtotime($invoice->created_at))}}<br>
                                        Due: {{date('d/m/Y', strtotime($invoice->due_date))}}
                                   </p>
                                </address>
                            </div>
                        </div>
                       
                            <div style="clear: both;">
                                <table style="margin-top:30px!important; width: 100%;padding: 0px;" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th style="margin: 0px;padding:5px;">Sl.No</th>
                                            <th style="text-align: left;padding: 5px;margin: 0px;">Item</th>
                                            <th style="text-align: center;padding: 5px;margin: 0px;">Amount</th>
                                           
                                        </tr>
                                    </thead>
                                    <tbody>
                                        
                                        <tr>
                                            <td style="text-align: center;border: 1px solid gray;">1</td>
                                            <td style="text-align: left;border: 1px solid gray;">{!!nl2br($invoice->item1)!!}</td>
                                            <td style="text-align: center;border: 1px solid gray;">{{get_currency_symbol($invoice->currency)}} {{$invoice->item1_amount}}</td>
                                        </tr>
                                       
                                    </tbody>
                                </table>
                            </div>
                                <div class="col-md-6" style="font-size: 14px; width:60%;display:inline-block;float:left;">
                                    @if(get_business_details($invoice->business_id)->bank_details)
                                    <p style="font-size: 12px;"><b>Bank Details</b><br>{!! nl2br(e(get_business_details($invoice->business_id)->bank_details)) !!}</p>
                                    @endif
                                    @if($invoice->terms_conditions)
                                        <p style="font-size: 13px; font-weight:400;">{!!$invoice->terms_conditions!!}</p>
                                    @endif
                                </div>
                                <div class="col-md-6" style="width:50%;display:inline-block;float:right;">
                                   <div style="text-align: right;line-height: 1.5; font-size: 14px;">
                                     <p><b>Commission Total:</b> <span style="font-family: DejaVu Sans; sans-serif;">{{get_currency_symbol($invoice->currency)}}</span>{{$invoice->sub_total}}<br>  
                                    
                                    <b>Tax({{$invoice->tax_rate}}%):</b> <span style="font-family: DejaVu Sans; sans-serif;">{{get_currency_symbol($invoice->currency)}}</span>{{$invoice->tax}}<br>
                                     <b>Total:</b> <span style="font-family: DejaVu Sans; sans-serif;">{{get_currency_symbol($invoice->currency)}}</span>{{$invoice->total}}<br>
                                     <b>Payment Made:</b> (-) <span style="font-family: DejaVu Sans; sans-serif;">{{get_currency_symbol($invoice->currency)}}</span>{{($total_payment) ? $total_payment : '0'}}<br>
                                     <b>Balance Due:</b> <span style="font-family: DejaVu Sans; sans-serif;">{{get_currency_symbol($invoice->currency)}}</span>{{($total_payment) ? $invoice->total - $total_payment : $invoice->total}}</p>
                                   </div>
                                    <br><br>
                                </div>
                                <div class="col-md-6" style="">
                                    <div class="clearfix"></div>
                                    @if(count($payments)>0)
                                    <div class="text-left">
                                        <div style="clear: both;">
                                            <p><b>Transactions</b></p>
                                            <div style="clear: both;">
                                                <table style="width: 100%;padding: 0px;" cellspacing="0">
                                                    <thead>
                                                        <tr>
                                                            <th style="padding: 5px;text-align: left;">Date</th>
                                                            <th style="padding: 5px;text-align: left;">Mode</th>
                                                            <th style="padding: 5px;text-align: left;">Transaction ID/ Notes</th>
                                                            <th style="padding: 5px;text-align: left;">Amount</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @foreach($payments as $payment)
                                                        <tr>
                                                            <td style="padding: 5px;border: 1px solid gray;">{{date('d/m/Y', strtotime($payment->payment_date))}}</td>
                                                            <td style="padding: 5px;border: 1px solid gray;">{{strtoupper(str_replace("_", " ", $payment->pay_mode))}}</td>
                                                            <td style="padding: 5px;border: 1px solid gray;">{{$payment->trans_id}}</td>
                                                            <td style="padding: 5px;border: 1px solid gray;"><span style="font-family: DejaVu Sans; sans-serif;">{{get_currency_symbol($invoice->currency)}}</span>{{$payment->amount}}</td>
                                                        </tr>
                                                        @endforeach
                                                    </tbody>
                                                    
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    @else
                                    <div class="text-left">
                                        <div style="clear: both;">
                                        </div>  
                                    </div>
                                @endif
                                @if(get_business_details($invoice->business_id)->footer_text)
                                <p style="position: fixed; bottom:0px;">{!!get_business_details($invoice->business_id)->footer_text!!}</p>
                                @endif
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-4">
        <div class="col"></div>
    </div>
    </div>
</div>
</body>
</html>