@extends('backend.layouts.app')

@section('title', "Announcements-details")

@section('content')

<div class="container mt-5">
        <div class="row">
            <div class="col-md-12 mt-1">
                
                <div class="announcement-list">  
                        <div class="announcement-card">
                            <div class="announcement-title">
                                <h1 id="t1">{{ $ann->title }} </h1>
                            </div>
                            <hr>
                            <div class="announcement-date">
                                <i class="far fa-calendar-alt"></i> <i>{{ \Carbon\Carbon::parse($ann->published_at)->format('d M Y') }}</i>
                            </div>
                            <div class="announcement-message">
                                {{ $ann->message }}
                            </div>
                        </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('after-styles')
  <style>
    
    .announcement-list {
      max-height: 400px;
      overflow-y: auto;
    }
    .announcement-card {
      margin-bottom: 20px;
      padding: 20px;
      transition: box-shadow 0.3s ease-in-out;
      box-shadow: 0px 0px 15px 0px rgba(0,0,0,0.2);

    }
    
    #t1 {
      font-weight: bold;
      color: #333;
    }
    .announcement-date {
      font-size: 14px;
      color: #777;
      margin-bottom: 10px;
    }
    .announcement-message {
      font-size: 16px;
      color: #555;
    }
    
  </style>
  @endpush