@extends('backend.layouts.app')

@section('title', app_name() . ' | ' . __('strings.backend.dashboard.title'))

@section('content')
<section class="admin-home-page" style="padding-left: 10px;">
  <div class="row">
    <div class="col-lg-12">
      <h3 class="dashboard-main-heading">Welcome back, {{$logged_in_user->first_name}} !</h3>
    </div>
  </div>
  {{-- POC --}}
  @if($agent_details->point_of_contact)
  <div class="row">
    <div class="col-md-12 mt-1">
      <h6>Your Point of Contact</h6>
    </div>   
    <div class="col-md-6 col-12">
      <div class="card"style="cursor:pointer;  height:100px;">
        <div class="card-body" style="padding-top: 10px!important;">
          <div class="stats-heading">
            <span><i class="fa fa-user-tie"></i> &nbsp;{{get_user_full_name_by_id($agent_details->point_of_contact)}}</span>
          </div>
          <div class="">
            <p class="mb-0" style="font-size: 20px !important;"><i class='fas fa-phone-alt text-sub'></i> {{get_user_mobile_by_id($agent_details->point_of_contact)}}</p>
            <p class="mb-0" style="font-size: 20px !important;"><i class='fas fa-envelope text-sub'></i> {{get_user_email_by_id($agent_details->point_of_contact)}}</p>
          </div>
        </div>
      </div>
    </div>
  </div>
  @endif
  @if(config('app.product_code') == 'OVERSEAS' || config('app.product_code') == 'EDUCTRL_CRM')  
  <div class="row">
    <div class="col-md-12 mt-1">
      <h6>STUDY ABROAD</h6>
      <h6>University Applications</h6>
    </div>
    @foreach($allAgentApplicationStatus as $key => $applicationStatus)
      <div class="col-md-3 col-sm-4 col-6">
        {{-- <div class="card text-white" style="cursor:pointer; background-color:<?php echo $allColors[$random]?>" onclick="document.location='{{route('admin.applications').'/?q='.$key}}'"> --}}
        <div class="card text-white" style="cursor:pointer; height:95px; background-color: {{get_application_status_color($key)}}" onclick="document.location='{{route('admin.applications').'/?q='.$key}}'">
          <div class="card-body">
            <div class="stats-heading">
              <span>{{$key}}</span>
              <i class="fas fa-chart-pie float-end"></i>
            </div>
            <div class="stats-count">{{$applicationStatus}}</div>
          </div>
        </div>
      </div>
    @endforeach

    <div class="col-md-3 col-sm-4 col-6">
      <div class="card bg-primary text-white" style=" height:95px; cursor:pointer;" onclick="document.location='{{route('admin.applications')}}'">
        <div class="card-body">
          <div class="stats-heading">
            <span>Total Applications</span>
            <i class="fas fa-chart-pie float-end"></i>
          </div>
          <div class="stats-count">{{$appl_total}}</div>
          
        </div>
      </div>
    </div>

  </div>

  <div class="row">
    <div class="col-md-12 mt-1">
      <h6>Students</h6>
    </div>    
    {{-- <div class="col-md-3 col-sm-4 col-6">
      <div class="card" onclick="document.location='{{route('admin.auth.user.index').'/?q=Pending'}}'" style="cursor:pointer;">
        <div class="card-body">
          <div class="stats-heading">
            <span>Profile Incomplete</span>
            <i class="fas fa-chart-pie float-end"></i>
          </div>
          <div class="stats-count">{{$student_profile_incomplete}}</div>
        </div>
      </div>
    </div>
    <div class="col-md-3 col-sm-4 col-6">
      <div class="card" onclick="document.location='{{route('admin.auth.user.index').'/?q=Profile'}}'" style="cursor:pointer;">
        <div class="card-body">
          <div class="stats-heading">
            <span>Profile Complete</span>
            <i class="fas fa-chart-pie float-end"></i>
          </div>
          <div class="stats-count">{{$student_profile_complete}}</div>

        </div>
      </div>
    </div>
    <div class="col-md-3 col-sm-4 col-6">
      <div class="card" onclick="document.location='{{route('admin.auth.user.index').'/?q=Course Preferences'}}'" style="cursor:pointer;">
        <div class="card-body">
          <div class="stats-heading">
            <span>Course Pref Added</span>
            <i class="fas fa-chart-pie float-end"></i>
          </div>
          <div class="stats-count">{{$student_course_pref}}</div>

        </div>
      </div>
    </div>
    <div class="col-md-3 col-sm-4 col-6">
      <div class="card" onclick="document.location='{{route('admin.auth.user.index').'/?q=Documents'}}'" style="cursor:pointer;">
        <div class="card-body">
          <div class="stats-heading">
            <span>Docs Uploaded</span>
            <i class="fas fa-chart-pie float-end"></i>
          </div>
          <div class="stats-count">{{$student_docs}}</div>

        </div>
      </div>
    </div>
    <div class="col-md-3 col-sm-4 col-6">
      <div class="card" onclick="document.location='{{route('admin.auth.user.index').'/?q=Application Processing'}}'" style="cursor:pointer;">
        <div class="card-body">
          <div class="stats-heading">
            <span>Appl Processing</span>
            <i class="fas fa-chart-pie float-end"></i>
          </div>
          <div class="stats-count">{{$student_appl_processing}}</div>

        </div>
      </div>
    </div>
    <div class="col-md-3 col-sm-4 col-6">
      <div class="card" onclick="document.location='{{route('admin.auth.user.index').'/?q=Admission Complete'}}'" style="cursor:pointer;">
        <div class="card-body">
          <div class="stats-heading">
            <span>Admission Complete</span>
            <i class="fas fa-chart-pie float-end"></i>
          </div>
          <div class="stats-count">{{$student_admission_complete}}</div>

        </div>
      </div>
    </div>
    <div class="col-md-3 col-sm-4 col-6">
      <div class="card" onclick="document.location='{{route('admin.auth.user.index').'/?q=Application Rejected/Cancelled'}}'" style="cursor:pointer;">
        <div class="card-body">
          <div class="stats-heading">
            <span>Appl Reject/Cancel</span>
            <i class="fas fa-chart-pie float-end"></i>
          </div>
          <div class="stats-count">{{$student_reject_cancel}}</div>

        </div>
      </div>
    </div> --}}
    @foreach($allStudentStatus as $stu_key => $studentStatus)
    <div class="col-md-3 col-sm-4 col-6">
      <div class="card text-white" style="cursor:pointer; height:95px; background-color: {{get_overseas_status_color($stu_key)}}" onclick="document.location='{{route('admin.auth.user.index').'/?query='.$stu_key}}'">
        <div class="card-body">
          <div class="stats-heading">
            <span>{{$stu_key}}</span>
            <i class="fas fa-chart-pie float-end"></i>
          </div>
          <div class="stats-count">{{$studentStatus}}</div>
        </div>
      </div>
    </div>
  @endforeach
    <div class="col-md-3 col-sm-4 col-6">
      <div class="card" onclick="document.location='{{route('admin.auth.user.index').'/?q='}}'" style="cursor:pointer;  height:95px;">
        <div class="card-body">
          <div class="stats-heading">
            <span>Total Students</span>
            <i class="fas fa-chart-pie float-end"></i>
          </div>
          <div class="stats-count">{{$student_total}}</div>
        </div>
      </div>
    </div>

  </div>
  @endif

  @if(config('app.product_code') == 'VISA' || env('VISA_ADDON'))
  <div class="row">
    <div class="col-md-12 mt-1">
      <h6>VISA STATS</h6>
    </div>
    @foreach($visa_stats as $title => $detail)
    <div class="col-md-3 col-sm-4 col-6">
      <div class="card bg-primary text-white">
        <div class="card-body">
          <div class="stats-heading">
            <span>{{$title}}</span>
            <i class="far fa-circle"></i>
          </div>
          <div class="stats-count">{{$detail['active']}}</div>
          <div class="stats-progress">Total: {{$detail['total']}}</div>
        </div>
      </div>
    </div>
    @endforeach
  </div>
  @endif

  	<div class="container mt-3">
        <div class="row">
            <div class="col-md-6 mt-1">
                <h4>Announcements</h4>
                <div class="announcement-list border rounded">
					@if(count($announcements) > 0)
						@foreach($announcements as $announcement)
								<div class="announcement-card">
									<div class="announcement-title">
										<a href="{{ route('admin.agent_announcement', ['id' => $announcement->id]) }}"><h3 id="t1">{!!$announcement->title!!} </h3></a>
									</div>
									<div class="announcement-date">
										<i class="far fa-calendar-alt"></i> <i>{{ \Carbon\Carbon::parse($announcement->published_at)->format('d M Y') }}</i>
									</div>
									<div class="announcement-message">
										{{ \Illuminate\Support\Str::limit($announcement->message, 150) }} 
										<a href="{{ route('admin.agent_announcement', ['id' => $announcement->id]) }}">read more</a>
									</div>
								</div>
								<hr>
						@endforeach
						<div class="text-end" style="margin-right:20px"> 
							  <a href="{{ route('admin.announcementslist') }}"><u>View All...</u></a>
						</div>
					@else
						<h5 class="px-2 py-2">No announcements found!</h5>
					@endif
                </div>
            </div>
        </div>
    </div>
  @endsection

  @push('after-styles')
  <style>
    .stat_num {
      text-align: center;
      font-size: 2em;
    }

    .stat_info {
      margin-bottom: 0;
    }
    .announcement-list {
      max-height: 400px;
      overflow-y: auto;
      border: solid 1px rgb(220,220,220) ;
    }

    .announcement-card {
      margin-bottom: 10px;
      border-radius: 10px;
      padding: 18px;
      transition: box-shadow 0.3s ease-in-out;
    }
    
    #t1 {
      font-weight: bold;
      color: #333;
    }
    .announcement-date {
      font-size: 14px;
      color: #777;
      margin-bottom: 10px;
    }
    .announcement-message {
      font-size: 16px;
      color: #555;
      
    }
    
    
  </style>
  @endpush