@extends('backend.layouts.app')

@section('title', "My Invoices")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5 col-5">
                <h4 class="card-title mb-0">
                    My Invoices
                </h4>
            </div>
        </div>
        <!--row-->

        <div class="row mt-4">
            <div class="col">
                <div class="">
                    <div class="table-responsive">
                    <table id="orders-table" class="table display">
                        <thead>
                            <tr>
                                <th>id</th>
                                <th>Date</th>
                                <th>Invoice #</th>
                                <th>Due Amount</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                    </table>
                </div>
                </div>
            </div>
        </div>
        <!--row-->
    </div>
    <!--card-body-->
</div>
<!--card-->
@endsection
@push('after-scripts')

<script type="text/javascript">
    var key = $('#key').val();
    var status = $('#status').val();
    var datatable = $('#orders-table').DataTable({
        processing: true,
        serverSide: true,
        autoWidth: true,
        responsive: true,
        order: [
            [0, "desc"]
        ],
        ajax: {
            url: '{{route('admin.agent-invoice.invoice-list')}}',
            data: function(data) {
                data.key = $('#key').val();
                data.status = $('#status').val();
            }

        },
        columns: [
            {
                data: 'invoice_id',
                name: 'invoice_id'
            },
            {
                data: 'date',
                name: 'date'
            },
            {
                data: 'invoice',
                name: 'invoice'
            },
            {
                data: 'amount',
                name: 'amount'
            },
            {
                data: 'status',
                name: 'status'
            },
            {
                data: 'action',
                name: 'action',
                orderable: false
            }
        ],
        columnDefs: [{
            "targets": 0,
            "visible": false
        }, {
            "targets": 1,
            "className": "text-center",
        }, {
            "targets": 2,
            "className": "text-center",
        }, {
            "targets": 3,
            "className": "text-center",
        }, {
            "targets": 4,
            "className": "text-center",
        },
        {
            "targets": 5,
            "className": "text-center",
        }],
    });
</script>
@endpush
