@extends('backend.layouts.app')
@section('title', "View Invoice")

@section('content')
<div class="card" style="border: none;">
    <div class="card-body printableArea">
       
        <div class="row">
            <div class="col-sm-5 col-10">
                <h4 class="card-title mb-0">
                   Invoice #{{$invoice->invoice_num}}
                </h4>
            </div>
            <!--col-->
            <div class="col-sm-7 col-2 no_print">
                <div class="btn-toolbar float-right" role="toolbar" style="margin-top: 20px;float: right;">
                    <button type="cancel" name="back" class="btn btn-primary btn-sm " value="Back" onclick="document.location ='{{route('admin.agent-invoice')}}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
                </div>
                <!--btn-toolbar-->
            </div>
            <!--col-->
        </div>
        <!--row-->
        <br>
        <div class="row mt-4 no_print" style="float:right;">
            <div class="col-md-12 col-sm-12">
                <div class="text-right">
                    <a class="btn btn-primary" target="_blank" href="{{route('admin.downloads.invoice', $invoice->id)}}">Download </a>
                    <button onclick="printDiv('printme')" class="btn btn-info" type="button">Print</button>
                </div>
            </div>
        </div>
        <br><br><br><br><br>
        <div class="row mt-4" id="printme">
            <h3 class="" id="hidden_div" style="display:none;"><b>Invoice #{{$invoice->invoice_num}}</b></h3>
            <div class="col-md-4">
                <div class="pull-left">
                    <address>
                        <h5><b>Bill To</b></h5>
                        <p class="m-l-5">
                            {{get_user_full_name_by_id($invoice->student_id)}} <br />
                            @if($stuData->address_1)
                            Address: {{ $stuData->address_1 }}<br />{{ $stuData->address_2 }} <br />
                            @else
                            Address: N/A<br />
                            @endif
                            Mob: {{$stuData->mobile}} <br />
                            Email: {{$stuData->email}}
                        </p>
                    </address>
                </div>
            </div>
            <div class="col-md-5">
            </div>
            <div class="col-md-3">
                <div class="pull-right text-left">
                    <address>
                        <h5 class="font-bold">{{get_site_config('invoice_business_name')}}</h5>
                        <p class="m-l-30">
                            Address: {!!get_site_config('invoice_business_address')!!} <br />
                            Ph: {!!get_site_config('invoice_business_phone')!!} <br />
                            Email: {!!get_site_config('invoice_business_email')!!}<br>
                            @lang('labels.general.taxid'): {!!get_site_config('invoice_business_taxid')!!}<br><br />
                            Created: {{date('d/m/Y', strtotime($invoice->created_at))}}<br>
                            Due: {{date('d/m/Y', strtotime($invoice->due_date))}}
                        </p>
                    </address>
                </div>
            </div>
            <div class="col-md-12">
                <div class="table-responsive m-t-40" style="clear: both;">
                    <table class="table table-hover table-bordered">
                        <thead>
                            <tr>
                                <th class="text-center">Sl.No</th>
                                <th>Item & Description</th>
                                <th class="text-right">Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php $i = 1; @endphp
                            @if($invoice->item1)
                            <tr>
                                <td class="text-center">{{$i}}</td>
                                <td>{{$invoice->item1}}</td>
                                <td class="text-right">{{config('app.currency_symbol')}} {{$invoice->item1_amount}}</td>
                                @php $i++; @endphp
                            </tr>
                            @endif
                            @if($invoice->item2)
                            <tr>
                                <td class="text-center">{{$i}}</td>
                                <td>{{$invoice->item2}}</td>
                                <td class="text-right">{{config('app.currency_symbol')}} {{$invoice->item2_amount}}</td>
                                @php $i++; @endphp
                            </tr>
                            @endif
                            @if($invoice->item3)
                            <tr>
                                <td class="text-center">{{$i}}</td>
                                <td>{{$invoice->item3}}</td>
                                <td class="text-right">{{config('app.currency_symbol')}} {{$invoice->item3_amount}}</td>

                            </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="col-md-12">
                <div class="pull-right m-t-30 text-right" style="float:right;">
                    <h6><b>Discount :</b> {{$invoice->discount}}</h6>
                    <h6><b>Total :</b> {{config('app.currency_symbol')}} {{$invoice->grand_total}}</h6>
                    <h6><b>Payment Made :</b> (-) {{config('app.currency_symbol')}} {{($total_payment) ? $total_payment : '0'}}</h6>
                    <h6><b>Balance Due :</b> {{config('app.currency_symbol')}} {{($total_payment) ? $invoice->grand_total - $total_payment : $invoice->grand_total}}</h6>
                </div>
            </div>
            <div class="col-md-12">
               <div class="clearfix"></div>
                <div class="text-left">
                    <p><b>Transactions</b></p>
                    <div class="table-responsive m-t-40" style="clear: both;">
                        <table class="table table-hover table-bordered">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Mode</th>
                                    <th>Transaction ID/ Notes</th>
                                    <th>Staff</th>
                                    <th>Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($payments as $payment)
                                <tr>
                                    <td>{{date('d/m/Y', strtotime($payment->payment_date))}}</td>
                                    <td>{{strtoupper($payment->pay_mode)}}</td>
                                    <td>{{$payment->trans_id}}</td>
                                    <td>{{get_user_full_name_by_id($payment->staff_id)}}</td>
                                    <td>{{config('app.currency_symbol')}} {{$payment->amount}}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
@endsection
@push('after-styles')
<style>
    @media print {
        .col-md-1, .col-md-2, .col-md-3, .col-md-4, .col-md-5, .col-md-6,
      .col-md-7, .col-md-8, .col-md-9, .col-md-10, .col-md-11, .col-md-12 {
           float: left;               
      }

      .col-md-12 {
           width: 100%;
      }

      .col-md-11 {
           width: 91.66666666666666%;
      }

      .col-md-10 {
           width: 83.33333333333334%;
      }

      .col-md-9 {
            width: 75%;
      }

      .col-md-8 {
            width: 66.66666666666666%;
      }

       .col-md-7 {
            width: 58.333333333333336%;
       }

       .col-md-6 {
            width: 50%;
       }

       .col-md-5 {
            flex: 0 0 auto;
            width: 41.66666666666667%;
       }

       .col-md-4 {
            flex: 0 0 auto;
            width: 33.33333333333333%;
       }

       .col-md-3 {
            float: right;
            flex: 0 0 auto;
            width: 25%;
       }

       .col-md-2 {
              width: 16.666666666666664%;
       }

       .col-md-1 {
              width: 8.333333333333332%;
        }           
        .no_print {
            display: none !important;
        }
        #hidden_div { 
            display: block !important;
            margin-bottom: 30px;
        }
    }
</style>
@endpush
@push('after-scripts')
<script>
    function printDiv(divName) {
        var printContents = document.getElementById(divName).innerHTML;
        var originalContents = document.body.innerHTML;
        document.body.innerHTML = printContents;
        window.print();
        document.body.innerHTML = originalContents;
    }
</script>
@endpush