<div class="row">
    <h4 class="card-title mb-0 ms-3">
        Agent Students
        <small class="text-muted"></small>
    </h4>
    <div class="table-responsive">
        <table class="table align-middle">
          <thead>
            <tr>
                <th>Created</th>
                <th>Name</th>
                <th>Email</th>
                <th>Mobile</th>
                <th>Address</th>
                <th>Status</th>
            </tr>
          </thead>
          <tbody>
            @foreach ($agent_students as $agent_student)
                <tr>
                    <td>{{date("d M Y", strtotime($agent_student->created_at))}}</td>
                    <td>
                        <a href="{{route('admin.auth.user.show', $agent_student->id)}}" target="_blank"><b>{{get_user_full_name_by_id($agent_student->id)}}</b></a>
                    </td>
                    <td>{{$agent_student->email}}</td>
                    <td>@if($agent_student->dialcode) +{{ $agent_student->dialcode }}-@endif{{ $agent_student->mobile }}</td>
                    <td>
                        @if($agent_student->user_country || $agent_student->city || $agent_student->state)
                        <i class='fas fa-globe'></i>
                        @if($agent_student->city)
                        {{ strtoupper($agent_student->city) }},&nbsp;
                        @endif
                        @if($agent_student->state)
                        {{ strtoupper(get_state_name($agent_student->state)) }},&nbsp;
                        @endif
                        @if($agent_student->user_country)
                        {{ strtoupper($agent_student->user_country->title_en) }}&nbsp;
                        @endif
                        @endif    
                    </td>
                    <td>
                        <span class="badge" style="background-color: {{get_application_status_color($agent_student->overseas_status)}}">
                            {{$agent_student->overseas_status}}
                        </span>
                    </td>
                </tr>
            @endforeach
          </tbody>
        </table>
    </div>
</div>