<?php
$countries = get_study_countries();
$months = array();
for ($i = 1; $i <= 12; $i++) {
    $months[$i] = date('F', strtotime("2019-" . $i . "-01"));
}
?> 
@extends('backend.layouts.app')
@section('title', "Resources")

@section('content')
<div class="row page-titles">
    <div class="col-md-5 align-self-center">
        <h3 class="text-themecolor mb-3">Resources</h3>
    </div>
</div>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">                
                    @include('includes.partials.messages')
                    <div class="row mt-4">
                        <div class="col">
                            <div class="table-responsive" style="border: 1px solid rgb(244, 240, 240); border-radius: 6px;">
                                <table class="table table-striped bg-none mb-0">
                                    <thead class="tableHeading">
                                        <tr>
                                            <th>Title</th>
                                            <th>Country</th>
                                            <th></th>
                                        </tr> 
                                    </thead>
                                    <tbody>
                                        @if(count($folders))
                                        @foreach($folders as $folder)
                                        <tr>  
                                            <td>{{ $folder['title'] }}</td>
                                            <td>{{ ($folder['country']) ? get_country_name($folder['country']) : "--" }}</td>  
                                            @if($folder['filename'] !='mp4' and $folder['filename'] !='mp3')
                                            <td> 
                                                <a href="{{ url('/storage/'.$folder['file'])}}" target="_blank" title="Download"> 
                                                    <button type="button" class="btn btn-outline-primary btn-rounded"><i class="fa fa-download"></i> Download</button> 
                                                </a>
                                            </td>          
                                            @else
                                            <td>         
                                                <a href="{{route('admin.agent.viewvideo',$folder['id']) }}" title="Download"> 
                                                    <button type="button" class="btn btn-primary"><span class="btn-label"><i class="fa fa-play"></i></span> Play</button> 
                                                </a> 
                                            </td>
                                            @endif    
                                        </tr>
                                        @endforeach 
                                        @else
                                        <tr>
                                            <td colspan="3" class="text-center">No Folder Found</td>
                                        </tr>
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                            <center>
                                <div class="row">
                                    <div class="col p-t-20">  
                                        <a href="{{route('admin.agent.resources') }}" class="my-2 btn btn-rounded btn-secondary"><i class="fa fa-backward"></i> Go Back</a>  
                                    </div>  
                                </div>
                            </center> 
                        </div><!--col-->
                    </div><!--row-->
                </div>
            </div>
        </div>
    </div>
</div>
<!-- ============================================================== -->
<!-- End Container fluid  -->
<!-- ============================================================== -->                    
@endsection