<style>
    .form-control{
        height: 35px !important;
        margin-bottom: 5px !important;
    }
    .form-select{
        height: 35px !important;
        margin-bottom: 5px !important;
    }
</style>
<div class="card bg-white border-0 mb-4">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10">
                <h4 class="card-title mb-0">Sub-agent Agreement</h4><br>
            </div>
            <div class="col-sm-2" style="margin-top:20px;text-align: right;">
                <button type="button" class="btn btn-primary btn-sm" onclick="window.location='{{ route('admin.auth.user.show', $user->id) }}'" title="Back">
                    <i class="fa fa-reply" aria-hidden="true"></i>
                </button>
            </div>
        </div>

        <form method="POST" action="{{ route('admin.esign.send') }}" id="esignForm" style="margin-top: -10px;">
            @csrf
            <h4>Send a agreement document for eSignature</h4>
            <div class="mb-3 col-md-6">
                <input type="hidden" name="user_id" value="{{ $user->id }}">
                <input type="hidden" name="user_name" value="{{ $user->first_name }}">
                <input type="hidden" name="user_email" value="{{ $user->email }}">
                <input type="hidden" name="file_path" id="file_path">
                <input type="hidden" name="title" id="title">
                <label for="template_id" class="form-label">Select Document</label>
                <select name="template_id" id="template_id" class="form-control form-select mb-3">
                        <option value="">-- Select a Document --</option>
                        @foreach($templates as $template)
                            <option value="{{ $template['_id'] }}">{{ $template['title'] }}</option>
                        @endforeach
                </select>
                <button type="submit" class="btn btn-primary">Send for eSignature</button>
            </div>
            
            <p class="text-muted mt-3">
                <strong>Note:</strong> You must first 
                <strong>create the document template</strong> in 
                <strong>DocuEsign</strong> 
                and ensure your API key is configured in Advanced Settings.
            </p>
        </form>

        <hr>
        <h5>Agreement History</h5>
        <div class="default-table-area all-products">
            <div id="" class="mt-4 table-responsive">
            <table class="table eductrl-datatable" id="">
                <thead>
                    <tr>
                        <th>Document</th>
                        <th>Status</th>
                        <th>Signed Date</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                        @foreach($docusignSentDocs as $doc)
                            <tr data-send-id="{{ $doc->send_request_id }}" id="doc-row-{{ $doc->id }}">
                                <td>{{ ucfirst($doc->title) }}</td>
                                
                                <td class="status-cell">
                                    {{ ucfirst($doc->status) }}
                                    @php
                                        $status = trim(strtolower($doc->status ?? ''));
                                        $sentDate = $doc->created_at 
                                            ? \Carbon\Carbon::parse($doc->created_at)->format('j M Y h:i A') 
                                            : null;
                                    @endphp

                                    @if($status === 'pending' && $sentDate)
                                        <br>
                                        <small class="text-muted">Sent on {{ $sentDate }}</small>
                                    @endif

                                </td>
                                
                                <td class="signed-date-cell">
                                    {{ $doc->signed_date ? \Carbon\Carbon::parse($doc->signed_date)->format('d M Y, h:i A') : '-' }}
                                </td>
                                
                             <td class="actions-cell">
                                    @php
                                        $signstatus = trim(strtolower($doc->status ?? ''));
                                    @endphp
                                    @if($signstatus === 'Signed' && !empty($doc->file_path))
                                        <a href="{{ $doc->file_path }}" target="_blank" class="btn btn-sm btn-primary" title="View Signed Document">
                                            
                                            <i class="fas fa-eye"></i>
                                        </a>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

@push('after-scripts')
<script>
document.addEventListener('DOMContentLoaded', function () {
    document.getElementById('esignForm').addEventListener('submit', function() {
    let templateSelect = document.getElementById('template_id');
    let titleInput = document.getElementById('title');
    let selectedText = templateSelect.options[templateSelect.selectedIndex].text;

    titleInput.value = selectedText.trim();
});

    document.querySelectorAll('tr[data-send-id]').forEach(function(row) {
        let sendId = row.getAttribute('data-send-id');

        fetch("{{ url('admin/esign/getStatus') }}/" + sendId, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify({ send_request_id: sendId })
        })
        .then(res => res.json())
        .then(data => {
            console.log('Status API Response:', data);

            // if (data.status) {
            //     row.querySelector('.status-cell').innerHTML = data.status;
            // }

            if (data.signed_date) {
                row.querySelector('.signed-date-cell').innerHTML = formatDate(data.signed_date);
            }

           if (data.status) {
    let statusText = data.status;

    if (statusText.toLowerCase() === 'pending' && data.sent_date_for_pending) {
        statusText += `<br><small class="text-muted">Sent on ${data.sent_date_for_pending}</small>`;
    }

    row.querySelector('.status-cell').innerHTML = statusText;
}


            let actionsCell = row.querySelector('.actions-cell');

        if (data.status && data.signed_doc) {
            let statusLower = data.status.toLowerCase();

            if (statusLower === 'signed') {
                actionsCell.innerHTML = `
    <a href="${data.signed_doc}" target="_blank" class="btn btn-sm btn-primary" title="View Signed Document">
        <i class="fas fa-eye"></i>
    </a>
`;
            } else {
                actionsCell.innerHTML = '-';
            }
        } else {
            actionsCell.innerHTML = '-';
        }

        })
        .catch(err => console.error('Error fetching status:', err));
    });

     function formatDate(datetimeString) {
        const d = new Date(datetimeString);
        return d.toLocaleDateString('en-US', {
            day: '2-digit', month: 'short', year: 'numeric',
            hour: '2-digit', minute: '2-digit', hour12: true
        });
    }

});
</script>
@endpush