<!-- Tab Content -->
<div class="" id="myTabContent">
    <div class="row" id="overview" role="tabpanel" aria-labelledby="overview-tab ">
        <div class="col-xl-9 col-md-8 col-sm-12 row border ms-2 rounded">
            <div class="row mt-3">

                <div class="col-sm-12 col-md-2 mb-3">
                    <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">ID</label>
                    <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">
                        {{($agent_details->agent_id??'') }}
                    </p>
                </div>

                <div class="col-sm-12 col-md-2 mb-3">
                    <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Category</label>
                    <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">
                        {{($agent_details->point_of_contact) ? ucfirst($agent_details->agent_category) : "--" }}
                    </p>
                </div>
    
                <div class="col-sm-12 col-md-4 mb-3">
                    <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Point of contact</label>
                    <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">
                        {{ ($agent_details->point_of_contact) ? get_user_full_name_by_id($agent_details->point_of_contact) : "--"}}
                    </p>
                </div>
    
                <div class="col-sm-12 col-md-4 mb-3">
                    <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Address</label>
                    <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">
                        @if($agent_details->address_1)
                            {{ $agent_details->address_1 }}
                        @else 
                            --
                        @endif
                    </p>
                </div>
    
                <div class="col-sm-12 col-md-4 mb-3">
                    <label class="pb-1" style="color: rgb(107, 107, 107) !important; font-weight: 400;">Logo Status</label>
                    <div class="col-2">
                        @if (!$agent_details->logo_approved)
                        <span class="btn btn-sm btn-danger">Disabled</span>
                        @else
                        <span class="btn btn-sm btn-success">Approved</span>
                        @endif
                    </div>
                </div>
    
                <div class="col-sm-12 col-md-4 mb-3">
                    <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Branch</label>
                    <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">
                        {{ ($agent_details->branch) ? ucfirst($agent_details->branch) : "--" }}
                    </p>
                </div>
    
                <div class="col-sm-12 col-md-4 mb-3">
                    <label style="color: rgb(107, 107, 107) !important; font-weight: 400;">Registered On</label>
                    <p style="color: rgb(23, 23, 23) !important; font-size: 16px !important; font-weight: 600;">
                        {{ ($agent_details->created_at->format('d M Y') )   }}</p>
                </div>
            </div>
        </div>

        <!-- Actions Section -->
        <div class="col-xl-3 col-md-4 col-sm-12 ms-md-1 mt-3 mt-md-0">
            <div class="col-12 container-100 ps-2" >
                <div class="card">
                    <div class="card-header bg-primary text-white"   style="font-size: 16px;">
                        Actions
                    </div>
                    <ul class="list-group list-group-flush">
                        @if(!auth()->user()->isAgent() && !$agent_details->is_lead)
                        <!-- Edit Icon -->
                        <a class="list-group-item list-group-item-action d-flex align-items-center" href="{{ route('admin.agents.edit', $agent_details->agent_id) }}">
                            <i class="ri-edit-2-line text-primary"></i>&nbsp;&nbsp;&nbsp;Edit
                        </a>
                        @endif

                        @if($agent_details->active)
                        <!-- Deactivate Icon -->
                        <a class="list-group-item list-group-item-action d-flex align-items-center " href="{{route('admin.auth.agent.mark', [$agent_details->user_id, 0])}}">
                            <i class="fas fa-eye-slash text-primary"></i>&nbsp;&nbsp;&nbsp;Deactivate
                        </a>
                        @else
                        <!-- Activate Icon -->
                        <a class="list-group-item list-group-item-action d-flex align-items-center" href="{{route('admin.auth.agent.mark', [$agent_details->user_id, 1])}}">
                            <i class="fas fa-eye text-primary"></i>&nbsp;&nbsp;&nbsp;Activate
                        </a>
                        @endif

                        <a class="list-group-item list-group-item-action d-flex align-items-center " id="sub_agent_agreement" href="#" 
                            onclick="addURL('docuesign')" data-bs-toggle="tab" data-bs-target="#docuesign">
                            <i class="fas fa-file-signature text-primary"></i>&nbsp;&nbsp;&nbsp;Sub-agent Agreement
                        </a>

                        @if(!auth()->user()->isAgent() && !$agent_details->is_lead)
                        <!-- Login As Icon -->
                        <a class="list-group-item list-group-item-action d-flex align-items-center" href="{{route('admin.auth.agent.login-as', $agent_details->user_id)}}">
                            <i class="ri-login-box-line text-primary"></i>&nbsp;&nbsp;&nbsp;Login as {{ $agent_details->first_name}}
                        </a>

                        <!-- Change Password Icon -->
                        <a class="list-group-item list-group-item-action d-flex align-items-center" href="{{ route('admin.auth.agent.change-password', $agent_details->user_id) }}">
                            <i class="fas fa-key text-primary"></i>&nbsp;&nbsp;&nbsp;Change Password
                        </a>

                        <!-- Delete Icon -->
                        <a class="list-group-item list-group-item-action d-flex align-items-center text-danger" href="{{ route('admin.auth.agent.destroy', $agent_details->user_id) }}" data-method="delete" data-trans-button-cancel="{{ Lang::get('buttons.general.cancel') }}" data-trans-button-confirm="{{ Lang::get('buttons.general.crud.delete') }}" data-trans-title="{{ Lang::get('strings.backend.general.are_you_sure') }}">
                            <i class="fas fa-trash-alt"></i>&nbsp;&nbsp;&nbsp;Delete
                        </a>

                        @if(!empty($agent_details->agent_id_proof))
                            <a class="list-group-item list-group-item-action d-flex align-items-center text-primary"
                            href="{{ asset('storage/' . $agent_details->agent_id_proof) }}"
                            target="_blank" download>
                                <i class="fas fa-download"></i>&nbsp;&nbsp;&nbsp;Download ID Proof
                            </a>
                        @endif

                        @if(!empty($agent_details->buis_incorpo_certi_proof))
                            <a class="list-group-item list-group-item-action d-flex align-items-center text-primary"
                            href="{{ asset('storage/' . $agent_details->buis_incorpo_certi_proof) }}"
                            target="_blank" download>
                                <i class="fas fa-download"></i>&nbsp;&nbsp;&nbsp;Download Business Proof
                            </a>
                        @endif

                        @endif
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>