@extends('backend.layouts.app')
@section('title', 'Agent Overview')

@section('content')

    <div class="card">
        {{-- <div class="row" @if ($agent_details->is_lead) style="background: #d5bb6c;" @else style="background: #1976d2;border-color: #1976d2;" @endif> --}}
        <div class="row p-3">
            <div class="col-md-1 col-sm-1 col-lg-1 mt-2">
                @if ($agent_details->avatar_location != '')
                    <img width="60px" height="60px" src="{{ asset('storage/' . $agent_details->avatar_location) }}"
                        alt="user" style="border-radius: 50%" />
                @else
                    <img src="{{ asset('assets/images/agent.png') }}" width="60px" height="60px" style="border-radius: 50%"
                        class="border" alt="">
                @endif
            </div>

            <div class="col-md-9 col-sm-8 col-lg-9">
                {{-- <div @if ($agent_details->is_lead) class="card-header text-dark" style="background: #d5bb6c; border-color: #d5bb6c" @else class="card-header text-white"  style="background: #1976d2;border-color: #1976d2;" @endif> --}}
                <h3 class="text-dark" style="font-weight: 600">{{ $agent_details->first_name }}
                    {{ $agent_details->last_name }}</h3>
                <h4 class="text-dark" style="font-weight: 400">{{ $agent_details->business_name }}</h4>

                @if (!$agent_details->active)
                    <span class="badge badge-danger"> Disabled</span> <br>
                @else
                    <span class="badge badge-success"><i class="fas fa-eye"></i> Active</span> <br>
                @endif

                @if ($agent_details->email)
                    <svg style="margin-bottom: 5px !important; color: rgb(52, 52, 52) !important;"
                        xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="currentColor"
                        class="bi bi-envelope sub-text" viewBox="0 0 16 16">
                        <path
                            d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V4Zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1H2Zm13 2.383-4.708 2.825L15 11.105V5.383Zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741ZM1 11.105l4.708-2.897L1 5.383v5.722Z" />
                    </svg>&nbsp;
                    <span class="sub-text" style="color: rgb(52, 52, 52) !important;">{{ $agent_details->email }}
                        @if (!\Auth::user()->isAgent())
                            <a target='_blank' href="{{ route('admin.communicate.mail', $agent_details->agent_id) }}"
                                title="Email" class="text-reset" style="margin-bottom: 0px !important;">
                                {{-- <img src="{{asset('assets/images/icon/mail.png')}}" width="25px" alt=""> --}}
                                <i class="bi bi-envelope btn btn-sm btn-outline-primary border-0"
                                    style="font-size: 20px !important;"></i>
                            </a>
                        @endif
                    </span>
                @endif


                @if ($agent_details->mobile)
                    {{-- <br> --}}&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                    {{-- <div class=" d-inline-block">
                    <div class=" d-inline-block"> --}}
                    <svg style="margin-bottom: 5px !important; color: rgb(52, 52, 52) !important;"
                        xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="currentColor"
                        class="bi bi-telephone sub-text" viewBox="0 0 16 16">
                        <path
                            d="M3.654 1.328a.678.678 0 0 0-1.015-.063L1.605 2.3c-.483.484-.661 1.169-.45 1.77a17.568 17.568 0 0 0 4.168 6.608 17.569 17.569 0 0 0 6.608 4.168c.601.211 1.286.033 1.77-.45l1.034-1.034a.678.678 0 0 0-.063-1.015l-2.307-1.794a.678.678 0 0 0-.58-.122l-2.19.547a1.745 1.745 0 0 1-1.657-.459L5.482 8.062a1.745 1.745 0 0 1-.46-1.657l.548-2.19a.678.678 0 0 0-.122-.58L3.654 1.328zM1.884.511a1.745 1.745 0 0 1 2.612.163L6.29 2.98c.329.423.445.974.315 1.494l-.547 2.19a.678.678 0 0 0 .178.643l2.457 2.457a.678.678 0 0 0 .644.178l2.189-.547a1.745 1.745 0 0 1 1.494.315l2.306 1.794c.829.645.905 1.87.163 2.611l-1.034 1.034c-.74.74-1.846 1.065-2.877.702a18.634 18.634 0 0 1-7.01-4.42 18.634 18.634 0 0 1-4.42-7.009c-.362-1.03-.037-2.137.703-2.877L1.885.511z" />
                    </svg>
                    {{-- </div> --}}
                    &nbsp;
                    <span class="sub-text" style="color: rgb(52, 52, 52) !important;">
                        @if ($agent_details->dialcode)
                            +{{ $agent_details->dialcode }}-
                        @endif{{ $agent_details->mobile }}
                    </span>&nbsp;
                    {{-- </div> --}}
                    @if (get_site_config('outbound_call_enabled'))
                        <button data-num="{{ $agent_details->id }}" class="text-reset call_btn btn" title="Phone"
                            style="margin: 0px !important; padding: 0px !important;">
                            {{-- <i class='fas fa-phone-alt contactIcon'></i> --}}
                            <i class="bi bi-telephone-outbound btn btn-sm btn-outline-info border-0"
                                style="font-size: 20px !important;"></i>
                        </button>
                    @endif
                @endif
                <a target='_blank' href="#" title="Message" class="text-reset" style="margin-bottom: 0px !important">
                    {{-- <i class="bi bi-envelope btn btn-sm btn-outline-primary rounded-circle"></i> --}}
                    <i class="bi bi-chat-dots btn btn-sm btn-outline-info border-0" style="font-size: 20px !important;"></i>
                </a>

                {{-- <a href="tel:+{{$agent_details->dialcode}}{{$agent_details->mobile}}" class="text-reset btn btn-sm" style="margin-bottom: 0px !important">
             <i class='fas fa-phone-alt ' style="color:white"></i>
              </a> --}}


                @if ($agent_details->whatsapp)
                    {{-- <br> --}}&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                    <svg style="margin-bottom: 5px !important; color: rgb(52, 52, 52) !important;"
                        xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="currentColor"
                        class="bi bi-whatsapp sub-text" viewBox="0 0 16 16">
                        <path
                            d="M13.601 2.326A7.854 7.854 0 0 0 7.994 0C3.627 0 .068 3.558.064 7.926c0 1.399.366 2.76 1.057 3.965L0 16l4.204-1.102a7.933 7.933 0 0 0 3.79.965h.004c4.368 0 7.926-3.558 7.93-7.93A7.898 7.898 0 0 0 13.6 2.326zM7.994 14.521a6.573 6.573 0 0 1-3.356-.92l-.24-.144-2.494.654.666-2.433-.156-.251a6.56 6.56 0 0 1-1.007-3.505c0-3.626 2.957-6.584 6.591-6.584a6.56 6.56 0 0 1 4.66 1.931 6.557 6.557 0 0 1 1.928 4.66c-.004 3.639-2.961 6.592-6.592 6.592zm3.615-4.934c-.197-.099-1.17-.578-1.353-.646-.182-.065-.315-.099-.445.099-.133.197-.513.646-.627.775-.114.133-.232.148-.43.05-.197-.1-.836-.308-1.592-.985-.59-.525-.985-1.175-1.103-1.372-.114-.198-.011-.304.088-.403.087-.088.197-.232.296-.346.1-.114.133-.198.198-.33.065-.134.034-.248-.015-.347-.05-.099-.445-1.076-.612-1.47-.16-.389-.323-.335-.445-.34-.114-.007-.247-.007-.38-.007a.729.729 0 0 0-.529.247c-.182.198-.691.677-.691 1.654 0 .977.71 1.916.81 2.049.098.133 1.394 2.132 3.383 2.992.47.205.84.326 1.129.418.475.152.904.129 1.246.08.38-.058 1.171-.48 1.338-.943.164-.464.164-.86.114-.943-.049-.084-.182-.133-.38-.232z" />
                    </svg>&nbsp;
                    <span class="sub-text" style="color: rgb(52, 52, 52) !important;">
                        @if ($agent_details->whatsapp_dialcode)
                            +{{ $agent_details->whatsapp_dialcode }}-
                        @endif{{ $agent_details->whatsapp }}
                    </span>&nbsp;

                    {{-- @if (env('WATI_WHATSAPP_TOKEN')) --}}
                    @if (get_site_config('whatsapp_enabled'))
                        <a &nbsp; target='_blank' href="{{ route('admin.communicate.whatsapp', $agent_details->id) }}"
                            title="Whatsapp" class="text-reset" style="margin-bottom: 0px !important">
                            {{-- <i class='fab fa-whatsapp contactIcon'></i> --}}
                            <i class="bi bi-whatsapp btn btn-sm btn-outline-success border-0"
                                style="font-size: 20px !important;"></i>
                        </a>
                    @else
                        <a &nbsp; target='_blank'
                            href="https://wa.me/+{{ $agent_details->dialcode }}{{ $agent_details->whatsapp }}"
                            title="Whatsapp" class="text-reset" style="margin-bottom: 0px !important">
                            {{-- <i class='fab fa-whatsapp contactIcon'></i> --}}
                            <i class="bi bi-whatsapp btn btn-sm btn-outline-success border-0"
                                style="font-size: 20px !important;"></i>
                        </a>
                    @endif

                @endif
                @if ($agent_details->country || $agent_details->city || $agent_details->state)
                    <br>
                    <svg style="margin-bottom: 5px !important;color: rgb(52, 52, 52) !important;"
                        xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="currentColor"
                        class="bi bi-globe-americas sub-text" viewBox="0 0 16 16">
                        <path
                            d="M8 0a8 8 0 1 0 0 16A8 8 0 0 0 8 0ZM2.04 4.326c.325 1.329 2.532 2.54 3.717 3.19.48.263.793.434.743.484-.08.08-.162.158-.242.234-.416.396-.787.749-.758 1.266.035.634.618.824 1.214 1.017.577.188 1.168.38 1.286.983.082.417-.075.988-.22 1.52-.215.782-.406 1.48.22 1.48 1.5-.5 3.798-3.186 4-5 .138-1.243-2-2-3.5-2.5-.478-.16-.755.081-.99.284-.172.15-.322.279-.51.216-.445-.148-2.5-2-1.5-2.5.78-.39.952-.171 1.227.182.078.099.163.208.273.318.609.304.662-.132.723-.633.039-.322.081-.671.277-.867.434-.434 1.265-.791 2.028-1.12.712-.306 1.365-.587 1.579-.88A7 7 0 1 1 2.04 4.327Z" />
                    </svg>
                    @if ($agent_details->city)
                        <span class="sub-text"
                            style="color: rgb(52, 52, 52) !important;">{{ strtoupper($agent_details->city) }}</span>,&nbsp;
                    @endif
                    @if ($agent_details->state)
                        <span class="sub-text"
                            style="color: rgb(52, 52, 52) !important;">{{ strtoupper(get_state_name($agent_details->state)) }}</span>,&nbsp;
                    @endif
                    @if ($agent_details->country)
                        <span class="sub-text"
                            style="color: rgb(52, 52, 52) !important;">{{ strtoupper(get_country_name($agent_details->country)) }}</span>&nbsp;
                    @endif
                @endif
            </div>
            {{-- <div class="col-md-1"></div> --}}
        </div>
        <ul class="nav nav-pills ms-3 mt-2" id="myTab" role="tablist"
            style="margin-bottom: -12px; border-bottom: none;">
            <li class="nav-item" role="presentation">
                <button onclick="addURL('overview')" style="font-weight:bold;" class="nav-link active" id="overview-tab"
                    data-bs-toggle="tab" data-bs-target="#overview" type="button" role="tab"
                    aria-controls="overview" aria-selected="true"> Overview</button>
            </li>
            <li class="nav-item" role="presentation">
                <button onclick="addURL('docuesign')" style="font-weight:bold;" class="nav-link" id="docuesign-tab"
                    data-bs-toggle="tab" data-bs-target="#docuesign" type="button" role="tab"
                    aria-controls="docuesign" aria-selected="false">Agreement Document</button>
            </li>
            <li class="nav-item" role="presentation">
                <button onclick="addURL('referrals')" style="font-weight:bold;" class="nav-link" id="referrals-tab"
                    data-bs-toggle="tab" data-bs-target="#referrals" type="button" role="tab"
                    aria-controls="referrals" aria-selected="false"> Referrals</button>
            </li>
            <li class="nav-item" role="presentation">
                <button onclick="addURL('commissions')" style="font-weight:bold;" class="nav-link" id="commissions-tab"
                    data-bs-toggle="tab" data-bs-target="#commissions" type="button" role="tab"
                    aria-controls="commissions" aria-selected="false"> Commissions</button>
            </li>
        </ul>

        <div class="tab-content" id="myTabContent">
            <div class="tab-pane fade show active" id="overview" role="tabpanel" aria-labelledby="overview-tab"
                style="border: none !important;">
                @include('backend.agents.agent_overview')
            </div>
            <div class="tab-pane fade" id="referrals" role="tabpanel" aria-labelledby="referrals-tab"
                style="border: none !important;">
                @include('backend.agents.agent_referrals')
            </div>
            <div class="tab-pane fade" id="commissions" role="tabpanel" aria-labelledby="commissions-tab"
                style="border: none !important;">
                @include('backend.agents.agent_commissions')
            </div>
            <div class="tab-pane fade " id="docuesign" role="tabpanel" aria-labelledby="docuesign-tab"
                style="border: none !important;">
                @include('backend.agents.agent_esignature', ['user' => $user, 'docusignSentDocs' => $docusignSentDocs, 'templates' => $templates])
            </div>
        </div>
    </div>
    <script>
        function addURL(type) {
            // var uri = window.location.toString();
            // if (type === 'commissions') {

            //     document.getElementById('commissions').style.display = 'block';
            //     document.getElementById('referrals').style.display = 'none';
            // } else if(type === 'referrals'){
            //     document.getElementById('referrals').style.display = 'block';
            //     document.getElementById('commissions').style.display = 'none';
            // }
        }
    </script>
    <!-- Action Links -->
@endsection


@push('after-styles')
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <style>
        div.dataTables_wrapper div.dataTables_filter input {
            width: 320px !important;
        }

        .edu-tooltip {
            position: relative;
            margin-top: -10px;
            /* margin-bottom: 0px; */
            /* display: inline-block; */
            /* border-bottom: 1px dotted black; */
        }

        .edu-tooltip .edu-tooltiptext {
            visibility: hidden;
            width: 300px;
            background-color: rgb(62, 62, 62);
            color: #fff;
            font-size: 0.9em;
            text-align: center;
            border-radius: 6px;
            padding: 5px 5px;
            position: absolute;
            z-index: 1;
            top: 100%;
            left: 50%;
            margin-left: -60px;
            line-height: 16px;
            font-size: 12px;
            text-wrap: wrap;
            font-style: normal;
        }

        .edu-tooltip .edu-tooltiptext::after {
            content: "";
            position: absolute;
            bottom: 100%;
            left: 20%;
            margin-left: -5px;
            border-width: 5px;
            border-style: solid;
            border-color: transparent transparent rgb(62, 62, 62) transparent;
        }

        .edu-tooltip:hover .edu-tooltiptext {
            visibility: visible;
        }

        .lead-horizontal {
            overflow-x: scroll;
        }

        .select2-search--inline>textarea {
            height: 12px !important;
        }
    </style>
@endpush

@push('after-scripts')
    <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
    <script>
        //Overview tab
        $("#sub_agent_agreement").click(function (e) { 
            e.preventDefault();
            $("#docuesign-tab").trigger("click");
        });
        $("#overview-tab").click(function (e) { 
            e.preventDefault();
            $("#sub_agent_agreement").removeClass('active');
        });

        //Referrals tab
        $('.daterange').daterangepicker({
            autoUpdateInput: false,
        });
        $('.daterange').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY') + ' to ' + picker.endDate.format('DD-MM-YYYY'));
        });
        $('.daterange').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
        });

        var start = moment().subtract(29, 'days');
        var end = moment();
        $('#referral_created_date').daterangepicker({
            "showDropdowns": true,
            "showWeekNumbers": true,
            "showISOWeekNumbers": true,
            autoUpdateInput: false,
            locale: {
                format: 'DD-MM-YYYY',
                "separator": " to ",
            },
            "ranges": {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf(
                    'month')]
            },
            "alwaysShowCalendars": true,
        });

        // Update input field when date is selected
        $('#referral_created_date').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('YYYY-MM-DD') + ' - ' + picker.endDate.format('YYYY-MM-DD'));
        });

        // Clear the input when cancel is pressed
        $('#referral_created_date').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
        });

        $(document).ready(function() {
            // Initialize date range picker
            loadData();
        });

        function loadData(myleads) {
            $('#referral_data_table').DataTable({
                "dom": '<"row px-3"<"col-md-2 text-start"l><"col-md-1"><"col-md-5"f><"col-md-4 text-end"B>>rt<"ps-3"i><"pe-3"p>',
                "processing": true,
                "serverSide": true,
                "language": {
                    searchPlaceholder: "Name, Email, Mobile"
                },
                "lengthMenu": [10, 25, 50, 100],
                "ajax": {
                    "url": "{{ route('admin.agent.my-referral-list') }}",
                    "dataType": "json",
                    "type": "post",
                    data: {
                        '_token': $('meta[name="csrf-token"]').attr('content'),
                        'agent_id': $('#agent_id').val(),
                        'search_value': $('#studentStatus').val(),
                        'created_date': $('#referral_created_date').val(), // Pass date filter
                    },
                },
                "columns": [{
                        "data": "student_name"
                    },
                    {
                        "data": "status"
                    },
                    {
                        "data": "created_at",

                    }
                ],
                'order': [
                    [2, 'desc']
                ],
                "columnDefs": [{
                    "orderable": true,
                    "targets": -1
                }],
                "buttons": [{
                        extend: 'excel',
                        text: '<i class="ri-file-excel-2-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Excel"></i>',
                        className: 'btn btn-outline-secondary exportBtn',
                        footer: false,
                        header: true,
                        exportOptions: {
                            columns: [0, 1, 2]
                        }
                    },
                    {
                        extend: 'pdf',
                        text: '<i class="bi bi-file-earmark-pdf" data-toggle="tooltip" data-placement="top" title="Pdf" ></i>',
                        className: 'btn btn-outline-secondary exportBtn',
                        footer: false,
                        header: true,
                        orientation: 'landscape',
                        exportOptions: {
                            columns: [0, 1, 2]
                        }
                    },
                    {
                        extend: 'print',
                        text: '<i class="bi bi-printer" data-toggle="tooltip" data-placement="top" title="Print"></i>',
                        className: 'btn btn-outline-secondary exportBtn',
                        footer: false,
                        header: true,
                        orientation: 'landscape',
                        exportOptions: {
                            columns: [0, 1, 2]
                        }
                    },
                    {
                        extend: 'copy',
                        text: '<i class="ri-file-copy-2-line export-btn-size"  data-toggle="tooltip" data-placement="top" title="Copy"></i>',
                        className: 'btn btn-outline-secondary exportBtn',
                        footer: false,
                        header: true,
                        exportOptions: {
                            columns: [0, 1, 2]
                        }
                    },
                    {
                        extend: 'csv',
                        text: '<i class="ri-file-excel-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Csv"></i>',
                        className: 'btn btn-outline-secondary exportBtn',
                        footer: false,
                        header: true,
                        exportOptions: {
                            columns: [0, 1, 2]
                        }
                    },
                ]
            });
        }

        function searchTable() {
            $("#referral_data_table").dataTable().fnDestroy();
            loadData();
        }

        function clearTable() {
            $('#referral_created_date').val(''); // Clear date filter
            $('#studentStatus').val(''); // Clear status filter
            $("#referral_data_table").dataTable().fnDestroy();
            loadData();
        }

        //agent commission tab

        $(document).ready(function() {
            loadCommissionData();
        });


        function loadCommissionData() {
            $('#commission_data_table').DataTable({
                "dom": '<"row px-3"<"col-md-2 text-start"l><"col-md-1"><"col-md-5"f><"col-md-4 text-end"B>>rt<"ps-3"i><"pe-3"p>',
                "processing": true,
                "serverSide": true,
                "language": {
                    searchPlaceholder: "Appl ID, Country"
                },
                "lengthMenu": [10, 25, 50, 100],

                "ajax": {
                    "url": "{{ route('admin.agents.myagent_commissiondata') }}",
                    "dataType": "json",
                    "type": "post",
                    data: {
                        '_token': $('meta[name="csrf-token"]').attr('content'),
                        'agent': $('#agent').val(),
                        'agent_id': $('#agent_id').val(),
                        'status': $('#status').val(),
                    },

                },
                "drawCallback": function(settings) {
                    addDeleteForms();
                },
                "columns": [{
                        "data": 'created_at'
                    },

                    {
                        "data": "applId"
                    },
                    {
                        "data": "commission_notes",
                        orderable: false,
                    },
                    {
                        "data": "commission"
                    },
                    {
                        "data": "deduction"
                    },
                    {
                        "data": "net_pay"
                    },
                    {
                        "data": "trans_details"
                    },
                    {
                        "data": "date_paid"
                    }
                ],
                'order': [
                    [0, 'desc']
                ],

                "buttons": [{
                        extend: 'excel',
                        text: '<i class="ri-file-excel-2-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Excel" ></i>',
                        className: 'btn btn-outline-secondary exportBtn',
                        footer: false,
                        header: true,
                        exportOptions: {
                            columns: [0, 1, 2, 3, 4, 5]
                        }
                    },
                    {
                        extend: 'pdf',
                        text: '<i class="bi bi-file-earmark-pdf" data-toggle="tooltip" data-placement="top" title="Pdf"></i>',
                        className: 'btn btn-outline-secondary exportBtn',
                        footer: false,
                        header: true,
                        exportOptions: {
                            columns: [0, 1, 2, 3, 4, 5]
                        }
                    },
                    {
                        extend: 'print',
                        text: '<i class="bi bi-printer" data-toggle="tooltip" data-placement="top" title="Print"></i>',
                        className: 'btn btn-outline-secondary exportBtn',
                        footer: false,
                        header: true,
                        exportOptions: {
                            columns: [0, 1, 2, 3, 4, 5]
                        }
                    },
                    {
                        extend: 'copy',
                        text: '<i class="ri-file-copy-2-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Copy"></i>',
                        className: 'btn btn-outline-secondary exportBtn',
                        footer: false,
                        header: true,
                        exportOptions: {
                            columns: [0, 1, 2, 3, 4, 5]
                        }
                    },
                    {
                        extend: 'csv',
                        text: '<i class="ri-file-excel-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Csv"></i>',
                        className: 'btn btn-outline-secondary exportBtn',
                        footer: false,
                        header: true,
                        exportOptions: {
                            columns: [0, 1, 2, 3, 4, 5]
                        }
                    },
                ]
            });
        }

        function searchCommissionTable() {
            $("#commission_data_table").dataTable().fnDestroy();
            loadCommissionData();
        }

        function clearCommissionTable() {
            $('#agent').val('');
            $('#status').val('');
            $("#commission_data_table").dataTable().fnDestroy();
            loadCommissionData();
        }

        $(document).on('click', '.mark_paid', function(e) {
            e.preventDefault();
            $('#ded').val('');
            $('#net_pay_val').val('');
            $('#net_pay').text("");
            var applid = $(this).data('id');
            var comm = $(this).data('comm');
            var agent = $(this).data('agent');
            $('.agent_name').text(agent);
            $('.appl_id').text(applid);
            $('.appl_id').val(applid);
            $('#amt').val(comm);
            $('#payoutModal').modal('show');

        });

        $(document).on('keyup', '#amt,#ded', function(e) {
            var amt = $('#amt').val();
            var ded = $('#ded').val();
            var netAmt = amt - ded;
            $('#net_pay_val').val(netAmt);
            $('#net_pay').text("{{ config('app.currency_symbol') }}" + netAmt);
        });
    </script>
@endpush
