@extends('backend.layouts.app')
@section('title', "Agents List")

@include('backend.agents.top-links')

@section('content')
<div class="card">
    <div class="card-body" style="padding-left: 0px !important; padding-right: 0px !important;">
        <div class="row" style="padding-left: 20px !important; padding-right: 20px !important;">
            <div class="col-sm-8 col-8">
                <h4 class="card-title mb-0">
                    Agents
                </h4>
            </div>
            <!--col-->
            <div class="col-sm-4 col-4">
                <div class="btn-toolbar float-right" role="toolbar" aria-label="" style="margin-top: 20px;float: right;">
                    <a href="{{ route('admin.agents.create') }}" class="btn btn-primary ml-1 btn-sm" data-toggle="tooltip" title="Add New Agent"><i class="bi bi-plus-circle"></i> Create</a>
                </div>

            </div>
        </div>
        {{-- Filters --}}
        <div class="filterBox" style="">
            <div class="row mt-4">
                <div class="col-sm-12 col-md-3">
                    <select class="form-select" id="branch" name="branch">
                            <option value="all" @if($current_branch == 'all') selected="selected" @endif>All Branch</option>
                            @foreach($branch as $id => $name)
                            <option value="{{ $id }}" @if($current_branch == $id) selected="selected" @endif>{{ $name }}</option>
                            @endforeach
                    </select>
                </div>
                <div class="col-sm-12 col-md-2">
                    <button onclick="javascript:searchTable();" class=" btn btn-primary btn-sm">Filter</button>
                    <button onclick="javascript:clearTable();" class=" btn btn-outline-primary btn-sm">Clear</button>
                </div>
            </div>
            </div>
        {{-- Filters --}}
        <!--row-->
        <div class="row mt-4">
            <div class="col-12">
                <div class="table-responsive">
                    <table class="table" id="agents-table">
                        <thead>
                            <tr>
                                <th style="min-width: 200px !important;">Name</th>
                                <th>Category</th>
                                <th>Email</th>
                                <th>Mobile</th>
                                <th>Status</th>
                                <th style="min-width: 80px !important;">Signed Up</th>
                                <th style="min-width: 115px !important;">Actions</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
            <!--col-->

        </div>
        <!--row-->

    </div>
</div>
@endsection

@push('after-scripts')
<script type="text/javascript">
$(document).ready(function() {
    loadData();
});
    function loadData() {
        $('#agents-table').DataTable({
            "dom": '<"row px-3"<"col-md-3 text-start"l><"col-md-5 text-start"f><"col-md-4 text-end"B>>rt<"ps-3"i><"pe-3"p>',
            processing: true,
            serverSide: true,
            autoWidth: true,
            responsive: true,
            order: [5, "desc"],
            pageLength: 10,
            lengthMenu: [10, 50, 100, 500, 1000],
            ajax: {
                "url": "{{ route("admin.agents.agents-list") }}",
                "dataType": "json",
                "type": "post",
                data: {
                    '_token': $('meta[name="csrf-token"]').attr('content'),
                    'branch': $('#branch').val()
                },
            },
            "drawCallback": function( settings ) {
                addDeleteForms();
            },            
            columns: [{
                    data: 'full_name',
                    name: 'full_name'
                },
                {
                    data: 'agent_cat',
                    name: 'agent_cat',
                    orderable: false,
                },
                {
                    data: 'email',
                    name: 'email'
                },
                {
                    data: 'mobile',
                    name: 'mobile'
                },
                {
                    data: 'status',
                    name: 'status'
                },
                {
                    data: 'signed_up',
                },
                {
                    data: 'options',
                    name: 'options',
                    orderable: false,
                    searchable: false
                },
            ],
            "buttons": [{
                    extend: 'excel',
                    text: '<i class="ri-file-excel-2-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Excel" ></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4]
                    }
                },
                {
                    extend: 'pdf',
                    text: '<i class="bi bi-file-earmark-pdf" data-toggle="tooltip" data-placement="top" title="Pdf"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4]
                    }
                },
                {
                    extend: 'print',
                    text: '<i class="bi bi-printer" data-toggle="tooltip" data-placement="top" title="Print"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4]
                    }
                },
                {
                    extend: 'copy',
                    text: '<i class="ri-file-copy-2-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Copy"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4]
                    }
                },
                {
                    extend: 'csv',
                    text: '<i class="ri-file-excel-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Csv"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4]
                    }
                },
            ]
        });
    }

function searchTable() {
    $("#agents-table").dataTable().fnDestroy();
    loadData();
}

function clearTable() {
    $('#branch').val('all');
    $("#agents-table").dataTable().fnDestroy();
    loadData();
}   
</script>
@endpush