@extends('backend.layouts.app')
@section('title', "Agents Commission")

@section('content')
<div class="card">
    <div class="card-body" style="padding-left: 0px !important; padding-right: 0px !important;">
        <div class="row" style="padding-left: 20px !important; padding-right: 20px !important;">
            <div class="col-sm-8">
                <h4 class="card-title mb-0">
                    Agent Commission
                </h4>
            </div>
            <!--col-->
            <div class="col-sm-4 ">
            </div>
        </div>
        <!--row-->

        {{-- Filters --}}
        <div class="filterBox">
            <div class="row mt-4">
                <div class="col-sm-12 col-md-3">
                    <select class="form-select" name="agent" id="agent">
                        <option value="">Agent</option>
                        @foreach($agents as $agent)
                        <option {{($filters['agent'] == $agent->id)? 'selected' : ''}} value="{{$agent->id}}">{{$agent->first_name.' '.$agent->last_name}}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-sm-12 col-md-3">
                    <select class="form-select" id='status'>
                        <option value=''>Status</option>
                        <option value="pending">Pending</option>
                        <option value="1">Paid</option>
                    </select>
                </div>
                <div class="col-sm-12 col-md-4">
                    <button onclick="javascript:searchTable();" class=" btn btn-primary btn-sm">Filter</button>
                    <button onclick="javascript:clearTable();" class=" btn btn-primary btn-sm">Clear</button>
                </div>
            </div>
        </div>

        <div class="row mt-4">
            <div class="col-12">
                <div class="table-responsive">
            <table id="data_table" class="table table-bordered table-hover">
                        <thead>
                            <tr>
                                <th style="min-width: 100px !important;">Date</th>
                                <th>Agent</th>
                                <th style="min-width: 190px !important;">Application</th>
                                <th style="width: 0px !important; min-width: 120px !important;">Commission Notes</th>
                                <th style="min-width: 90px !important;">Commission</th>
                                <th style="min-width: 90px !important;">Deduction</th>
                                <th style="min-width: 90px !important;">Net Pay</th>
                                <th>Comments</th>
                                <th style="min-width: 90px !important;">Date Paid</th>
                                <th style="min-width: 90px !important;">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</div>
<div class="modal fade" id="editModal" role="dialog">
    <div class="modal-dialog">
      <!-- Modal content-->
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Edit</h4>
          <button type="button" class="close" data-bs-dismiss="modal">&times;</button>
        </div>
        <div class="modal-body">
          <form action="{{route('admin.agents.update.commission')}}" method="POST">
              @csrf
              <input type="hidden" name="net_pay_val" id="net_pay_val" value="">
              <input type="hidden" name="appl_id" class="appl_id" value="">
              <div class="">
                <div class="">
                <h6 class="agent_name"></h6>
                </div>
                <div class="">
                <h6>University Applications ID #<span class="appl_id"></span></h6>
                </div>
                <div class="mt-3">
                <strong class="required-field">Commission (<span class="appl_curr"></span>)</strong>
                    <input type="number" step="0.01" min="0" id="amt" class="form-control" value="" name="amount" required>
                </div>  
                <div class="mt-2">
                <strong class="required-field">Deduction (<span class="appl_curr"></span>)</strong>
                    <input type="number" step="0.01" min="0" id="ded" class="form-control" name="deduction" required>
                </div> 
                <div class="mt-3">
                <strong>Net Pay: </strong>
                    <span class="appl_curr"></span><span id="net_pay"></span>
                </div> 
                <div class="mt-3">
                    <textarea class="form-control" name="notes" rows="3" style="width:100%;" placeholder="Notes*" required></textarea>    
                </div>            
                <div class="mt-1">
                    <button type="submit" class="btn btn-primary">Save</button>
                    <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cancel</button>
                </div>
                </div>
          </form>
        </div>
      </div>
      
    </div>
  </div>

@endsection

@push('after-styles')
<link href="{{ asset('assets/plugins/toast-master/css/jquery.toast.css') }}" rel="stylesheet">
<link href="{{ asset('assets/plugins/sweetalert/sweetalert.css') }}" rel="stylesheet" type="text/css">
@endpush
@push('after-scripts')
<script src="{{ asset('assets/plugins/toast-master/js/jquery.toast.js') }}"></script>
<script src="{{ asset('assets/plugins/sweetalert/sweetalert.min.js') }}"></script>
<script type="text/javascript">
  
    $(document).ready(function() {
        loadData();
    });
  

    function loadData() {
        $('#data_table').DataTable({
            "dom": '<"row px-3"<"col-md-2 text-start"l><"col-md-1"><"col-md-5"f><"col-md-4 text-end"B>>rt<"ps-3"i><"pe-3"p>',
            "processing": true,
            "serverSide": true,
            "language": {
                searchPlaceholder: "Appl ID, Country"
            },
            "lengthMenu": [10, 25, 50, 100],

            "ajax": {
                "url": "{{route('admin.agents.commission-data')}}",
                "dataType": "json",
                "type": "post",
                data: {
                    '_token': $('meta[name="csrf-token"]').attr('content'),
                    'agent': $('#agent').val(),
                    'status': $('#status').val(),
                },

            },
            "drawCallback": function( settings ) {
                addDeleteForms();
            },
            "columns": [
                { "data": 'created_at' },
                {
                    "data": "agent"
                },
                {
                    "data": "applId"
                },
                {
                    "data": "commission_notes",
                    orderable: false,
                },
                {
                    "data": "commission"
                },
                {
                    "data": "deduction"
                },
                {
                    "data": "net_pay"
                },
                {
                    "data": "trans_details"
                },
                {
                    "data": "date_paid"
                },
                {
                    "data": "actions",
                    orderable: false,
                }
            ],
            'order': [
                [0, 'desc']
            ],
           
            "buttons": [{
                    extend: 'excel',
                    text: '<i class="ri-file-excel-2-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Excel" ></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5]
                    }
                },
                {
                    extend: 'pdf',
                    text: '<i class="bi bi-file-earmark-pdf" data-toggle="tooltip" data-placement="top" title="Pdf"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5]
                    }
                },
                {
                    extend: 'print',
                    text: '<i class="bi bi-printer" data-toggle="tooltip" data-placement="top" title="Print"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5]
                    }
                },
                {
                    extend: 'copy',
                    text: '<i class="ri-file-copy-2-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Copy"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5]
                    }
                },
                {
                    extend: 'csv',
                    text: '<i class="ri-file-excel-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Csv"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5]
                    }
                },
            ]
        });
    }

    function searchTable() {
        $("#data_table").dataTable().fnDestroy();
        loadData();
    }

    function clearTable() {
        $('#agent').val('');
        $('#status').val('');
        $("#data_table").dataTable().fnDestroy();
        loadData();
    }

    $(document).on('click', '.edit_commission', function (e) {
         e.preventDefault();
            $('#ded').val('');
            $('#net_pay_val').val('');
            $('#net_pay').text("");
            var applid = $(this).data('id');
            var comm = $(this).data('comm');
            var currency = $(this).data('currency');
            var agent = $(this).data('agent');
            $('.agent_name').text(agent);
            $('.appl_id').text(applid);
            $('.appl_curr').text(currency);
            $('.appl_id').val(applid);
            $('#amt').val(comm);
            $('#editModal').modal('show'); 
          
      });

    $(document).on('keyup', '#amt,#ded', function (e) {
             var amt = $('#amt').val();
             var ded = $('#ded').val();
             var netAmt = amt-ded;
             $('#net_pay_val').val(netAmt);
             $('#net_pay').text(netAmt);
      });

</script>
@endpush