@extends('backend.layouts.app')
@section('title', "Edit Agent")
@section('content')



<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    Edit Agent
                </h4><br>
            </div>
            <!--col-->
            <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
                <button type="cancel" name="back" class="btn btn-primary btn-sm" value="Back" onclick="document.location ='{{ route('admin.agents.index') }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
            </div>

        </div>

        <!--row-->

        {{ html()->form('POST', route('admin.agents.update', $user->id))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
        
            <div class="form-group row">
                <div class="col-sm-12 col-md-4">
                    <label for="business_name" class="col-form-label">Business Name</label>
                    <div class="">
                        <input type="text" id="business_name" class="form-control" name="business_name" placeholder="Business Name" value="{{ $agent_details->business_name }}">
                    </div>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label for="business_cat" class="col-form-label">Category</label>
                    <div class="">
                        <select class="form-select" name="agent_category" style="padding:0.49rem 2rem 0.375rem 0.75rem;">
                            <option value=''>Select</option>
                            <option {{("Big" == $agent_details->agent_category)? 'selected' : ''}} value="Big">Big</option>
                            <option {{("Medium" == $agent_details->agent_category)? 'selected' : ''}} value="Medium">Medium</option>
                            <option {{("Small" == $agent_details->agent_category)? 'selected' : ''}} value="Small">Small</option>
                        </select>
                    </div>
                </div>
            </div>
        
        <div class="form-group row">
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label required-field">First Name</span></label>
                <div class="">
                    <input type="text" class="form-control" name="first_name" value="{{ $user->first_name }}" required>
                </div>
            </div>
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label required-field">Last Name</label>
                <div class="">
                    <input type="text" class="form-control" name="last_name" value="{{ $user->last_name }}" required>
                </div>
            </div>
        </div>

        <div class="form-group row">
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label required-field">Email</label>
                <div class="">
                    <input type="text" class="form-control" name="email" value="{{ $user->email }}" required>
                </div>
            </div>
            {{-- <div class="col-sm-12 col-md-4">
                <label class="col-form-label required-field">Mobile No.</label>
                <div class="">
                    <input type="text" class="form-control" name="mobile" value="{{ $user->mobile }}" minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}" maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}" required>
                </div>
            </div> --}}
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label required-field">Mobile No.</label>
                <div class="input-group">
                    <div class="input-group-prepend" style="width: 50%">
                        <select class="form-select select2" id="dialcode" name="dialcode" style="padding:0.49rem 2rem 0.375rem 0.75rem;">
                            {{-- <option value=''>Dialcode</option> --}}
                            @foreach($dialcodes as $dialcode)
                            <option {{((Request::old('dialcode') == $dialcode->code) || $dialcode->code == $user->dialcode)? 'selected' : ''}} value="{{$dialcode->code}}">{{$dialcode->name}} +{{$dialcode->code}}</option>
                            @endforeach
                        </select>
                    </div>
                    <input type="text" class="form-control" name="mobile" value="{{ $user->mobile }}" minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}" maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}" required>
                </div>
            </div>
        </div>
        <div class="form-group row ">
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label required-field">Country</label>
                <select class="form-select" id="country" name="country" required>
                    @foreach ($country_list as $key => $value)
                    <option value="{{ $key }}" @if(Request::old('country') == $key) selected @elseif ($user->country == $key) selected @endif>{{ $value }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label">State</label>
                <div class="form-group">
                    <select class="form-control form-select" name="state" id="state-dd">
                    </select>
                </div>
            </div>
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label" for="city">City</label>
                <input type="text" placeholder="City" value="@if(Request::old('city')){{ Request::old('city') }}@else{{ $user->city }}@endif" class="form-control" id="city" name="city">
            </div>
        </div>
        <div class="form-group row ">
            <div class="col-sm-12 col-md-8">
                <label for="address" class="col-form-label">Address</label>
                <div class="">
                    <input type="text" id="address" class="form-control" name="address" value="{{ $user->address_1 }}">
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <label class="col-form-label">Commission Percent</label>
                <input type="number" style="width: 31.5% !important;" name="commission_percent" class="form-control" value="{{$agent_details->commission_percent}}">
                <span style="display: block; margin-top: -10px;">
                    Enter the percentage of your commission to share with the sub-agent. For example, if your are giving 30% of your commission, enter 30.
                </span>
            </div>
        </div>
        <div class="row mt-3">
            <div class="col-sm-12 col-md-2">
                <img src="{{ url('storage/'.$agent_details->agent_panel_logo) }}" alt="Current logo" style="height:70px;padding:8px 0px 10px">    
            </div>
            <div class="col-sm-12 col-md-6">
                <label class="col-form-label">Logo for Agent Panel</label>
                <div class="col-sm-12">
                    <input type="file" class="form-control" name="agent_panel_logo" id="agent_panel_logo">
                    <span style="font-size:0.9em;">Allowed file types: png, jpg, gif, svg. File size must not exceed 500KB<br />
                        Image less than 400px width is preferred
                    </span>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label">Agent ID Proof</label>
                <div class="col-sm-12">
                    <input type="file" class="form-control" name="agent_id_proof" id="agent_id_proof">
                </div>
            </div>
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label">Business Incorporation Certificate/Proof</label>
                <div class="col-sm-12">
                    <input type="file" class="form-control" name="buis_incor_certi_proof" id="buis_incor_certi_proof">
                </div>
            </div>
        </div>
        <div class="form-group row">
            {{-- <div class="col-sm-12 col-md-4">
                <label for="address" class="col-form-label">City/Location</label>
                <div class="">
                    <input type="text" id="address" class="form-control" name="address" value="{{ $user->address_1 }}">
</div>
</div> --}}
<div class="col-sm-12 col-md-4">
    <label class="col-form-label required-field">Branch</label>
    <select class="form-select" id="branch" name="branch" required>
        <option value="">Select Branch</option>
        @foreach($branch as $branches)
        <option {{($branches->id == $user->branch)? 'selected' : ''}} value="{{ $branches->id }}">{{ $branches->branch_name }}</option>
        @endforeach
    </select>
</div>
<div class="col-sm-12 col-md-4">
    <label class="col-form-label"><b>Point of Contact</b></label>
    <div class="">
        <select class="form-select" id='point_of_contact' name="point_of_contact">
            <option value=''>Select</option>
            @foreach($staff as $stf)
            <option value="{{$stf->id}}" @if($agent_details->point_of_contact == $stf->id) selected @endif>{{$stf->first_name . ' ' . $stf->last_name}}</option>
            @endforeach
        </select>
    </div>
</div>
</div>

<div class="row" style="margin-top:10px;">
    <div class="col-sm-12 col-md-8 text-center">
        <div class="form-group mb-0 clearfix">
            {{ form_submit("Save") }}
        </div>
    </div>
</div>
</form>

</div>
</div>
@endsection


@push('after-scripts')
<script>
    $('#country').on('change', function() {
        var idCountry = this.value;
        $("#state-dd").html('');
        $.ajax({
            url: "{{url('api/fetch-states')}}",
            type: "POST",
            data: {
                country_id: idCountry,
                _token: '{{csrf_token()}}'
            },
            dataType: 'json',
            success: function(result) {
                $('#state-dd').html('<option value="">Select State</option>');
                $.each(result.states, function(key, value) {
                    if (value.id == "{{$user->state}}") {
                        var selectedState = "selected=\"'selected'\"";
                    } else {
                        var selectedState = "";
                    }
                    $("#state-dd").append('<option ' + selectedState + ' value="' + value.id + '">' + value.name + '</option>');
                });
            }
        });
    });
    $('#country').trigger('change');
</script>
@endpush