@extends('backend.layouts.app')
@section('title', "Agents Payout")
@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-8">
                <h4 class="card-title mb-0">
                    Agent Payout
                </h4>
            </div>
            <!--col-->
            <div class="col-sm-4 ">
            </div>
        </div>

        <div class="row mt-4">
            <div class="col-12">
                <div class="table-responsive">
                    <table id="data_table" class="table w-100">
                        <thead>
                            <tr>
                                <th data-orderable="false">
                                    <div class="form-check form-check-sm form-check-custom form-check-solid">
                                        <input class="form-check-input" type="checkbox" id="check_all" name="check_all"/>
                                    </div>                                                                        
                                </th>
                                <th style="min-width: 100px !important;">Date</th>
                                <th>Agent</th>
                                <th style="min-width: 190px !important;">Application</th>
                                <th style="width: 0px !important; min-width: 120px !important;">Commission Notes</th>
                                <th style="min-width: 90px !important;">Commission</th>
                                <th style="min-width: 90px !important;">Deduction</th>
                                <th style="min-width: 90px !important;">Net Pay</th>
                                <th>Comments</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($payouts as $payout)
                            <?php 
                            $currency = "";
                                // $universityApplication = UniversityApplication::where("id", $page->appl_id)->first();
                                // if ($universityApplication) {
                                //     if ($universityApplication->university) {
                                //         $university_name = $universityApplication->university;
                                //     }
                                //     if ($universityApplication->course) {
                                //         $course_name = $universityApplication->course;
                                // }
                                // }
                                $currency = $payout->currency . " " . get_currency_symbol($payout->currency);
                            ?>
                            <tr>
                                <td>
                                    <div class="form-check form-check-sm form-check-custom form-check-solid">
                                    <input class="form-check-input data-checkboxs" onclick="javascript:checkboxCheckSelected();" name="multiselect" type="checkbox" value="{{$payout->id}}"/>
                                </div>
                                </td>
                                <td>{{date("d M Y", strtotime($payout->created_at))}}</td>
                                <td>
                                    {!!$payout->first_name . " " . $payout->last_name . "<br /><span class='text-smaller text-muted'>" . $payout->email . "</small>"!!}
                                </td>
                                <td>
                                    {!!get_application_id($payout->appl_id)."<br>".$payout->university . '<br>' . $payout->course!!}
                                </td>
                                <td>{{$payout->agent_commission_notes}}</td>
                                <td>{{$currency . " " . $payout->amount}}</td>
                                <td>{{$currency . " " . $payout->deduction}}</td>
                                <td>{{$currency . " " . $payout->net_pay." (".get_currency_by_user_country($payout->agent_id).' '.get_currency_symbol(get_currency_by_user_country($payout->agent_id)).' '.currency_convert($payout->net_pay, $payout->currency, get_currency_by_user_country($payout->agent_id)).")"}}</td>
                                <td>{{$payout->notes}}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <h3>Select the transactions from the above table which you want to process payment</h3>
            </div>
            
            <div class="col-md-12 process-selected" style="display: none;">
                <div class="text-left">
                    <button class="btn btn-primary btn-sm" type="button" onclick="processPayment();" value="create">Process Payment</button>
                </div>
            </div>
        </div>

    </div>
</div>
@endsection
@push('after-styles')
<link href="{{ asset('assets/plugins/toast-master/css/jquery.toast.css') }}" rel="stylesheet">
<link href="{{ asset('assets/plugins/sweetalert/sweetalert.css') }}" rel="stylesheet" type="text/css">
@endpush
@push('after-scripts')
<script src="{{ asset('assets/plugins/toast-master/js/jquery.toast.js') }}"></script>
<script src="{{ asset('assets/plugins/sweetalert/sweetalert.min.js') }}"></script>
<script type="text/javascript">
  
    $(document).ready(function() {
        $("#check_all").on("click", function () {
            if ($("input:checkbox[name='check_all']").prop("checked")) {
                $("input:checkbox[name='multiselect']").prop("checked", true);
            } else {
                $("input:checkbox[name='multiselect']").prop("checked", false);
            }
            checkboxCheckSelected();
        });
    });

 
    function processPayment() {
        var dataArray = new Array();
        $("input:checkbox[name=multiselect]:checked").each(function() {
            dataArray.push($(this).val());
        });
        var sub_options = {
            url: "{{route('admin.agents.process-payment.step-two')}}",
            method: "POST",
            data: {
                'id_arr': dataArray,
                '_token': $('meta[name="csrf-token"]').attr('content')
            }
        };
        manual_form_submit(sub_options);
    }

    function manual_form_submit(options) {
        var $form = $("<form />");
        $form.attr("action", options.url);
        $form.attr("method", options.method);
        for (var data in options.data)
            $form.append('<input type="hidden" name="' + data + '" value="' + options.data[data] + '" />');
        $("body").append($form);
        $form.submit();
    }

    function checkboxCheckSelected(){
        var total_check_boxes = $("input:checkbox[name='multiselect']").length;
        var total_checked_boxes = $("input:checkbox[name='multiselect']:checked").length;
        if (total_check_boxes === total_checked_boxes) {
            $("#check_all").prop("checked", true);
        }
        else {
            $("#check_all").prop("checked", false);
        }
        if(total_checked_boxes > 0){
            $(".process-selected").show();
        }
        else{
            //$("#bulk_pay")[0].selectedIndex = 0;
            $(".process-selected").hide();
        }
    }

    function clearSelectedCheckboxs(){
        $("#check_all").prop("checked", false);
        $(".process-selected").hide();
     }     

        $('#data_table').DataTable({
            "dom": '<"row px-3"<"col-md-3 text-start"l><"col-md-5 text-start"f><"col-md-4 text-end"B>>rt<"ps-3"i><"pe-3"p>',
            "processing": false,
            "serverSide": false,
            "language": {
                searchPlaceholder: "Appl ID, Country"
            },
            "lengthMenu": [50, 100, 200],
            "buttons": [{
                    extend: 'excel',
                    text: '<i class="ri-file-excel-2-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Excel" ></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5]
                    }
                },
                {
                    extend: 'pdf',
                    text: '<i class="bi bi-file-earmark-pdf" data-toggle="tooltip" data-placement="top" title="Pdf"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5]
                    }
                },
                {
                    extend: 'print',
                    text: '<i class="bi bi-printer" data-toggle="tooltip" data-placement="top" title="Print"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5]
                    }
                },
                {
                    extend: 'copy',
                    text: '<i class="ri-file-copy-2-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Copy"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5]
                    }
                },
                {
                    extend: 'csv',
                    text: '<i class="ri-file-excel-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Csv"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5]
                    }
                },
            ]
        });


    // $(document).on('click', '.show_confirm', function (e) {
    //      e.preventDefault();
    //         var id = $(this).data('id');
    //         swal({
    //                 title: "Are you sure?",
    //                 type: "warning",
    //                 confirmButtonClass: "btn-danger",
    //                 confirmButtonText: "Yes!",
    //                 showCancelButton: true,
    //             },
    //             function() {
    //                 window.location.href = "{{url('admin/agents/pay/')}}/"+id;
    //         });
          
    //   });
</script>
@endpush