@extends('backend.layouts.app')
@section('title', "Agents Payout")
@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-8">
                <h4 class="card-title mb-0">
                    Process Agent Payout
                </h4>
            </div>
            <!--col-->
            <div class="col-sm-4 ">
            </div>
        </div>

        <div class="row mt-4">
            <div class="col-12">
                <div class="table-responsive">
                    <table id="data_table" class="table w-100">
                        <thead>
                            <tr>
                                <th>Agent</th>
                                <th style="min-width: 90px !important;">Total Net Pay</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($commdata_arr as $commdata)
                            <?php 
                            $currency = "";
                                $currency = $commdata['currency'] . " " . get_currency_symbol($commdata['currency']);
                            ?>
                            <tr>
                                <td>
                                    {!!$commdata['agent_name']. "<br /><span class='text-smaller text-muted'>" . $commdata['email'] . "</small>"!!}
                                </td>
                                <td>{{$currency . " " . $commdata['total_net_pay']}}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-md-12">
            <div class="text-left">
                <form action="{{route('admin.agents.process-payment.save')}}" method="POST">
                    @csrf
                    <input type="hidden" name="comm_ids" value="{{$comm_ids}}">
                    <button class="btn btn-primary btn-sm" type="submit">Mark Paid</button>
                    <a class="btn btn-danger btn-sm" href="{{ url()->previous() }}">Cancel</a>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@push('after-styles')
<link href="{{ asset('assets/plugins/toast-master/css/jquery.toast.css') }}" rel="stylesheet">
<link href="{{ asset('assets/plugins/sweetalert/sweetalert.css') }}" rel="stylesheet" type="text/css">
@endpush
@push('after-scripts')
<script src="{{ asset('assets/plugins/toast-master/js/jquery.toast.js') }}"></script>
<script src="{{ asset('assets/plugins/sweetalert/sweetalert.min.js') }}"></script>
<script type="text/javascript">
  

 
    function processPayment() {
        var dataArray = new Array();
        $("input:checkbox[name=multiselect]:checked").each(function() {
            dataArray.push($(this).val());
        });
        var sub_options = {
            url: "{{route('admin.agents.process-payment.step-two')}}",
            method: "POST",
            data: {
                'id_arr': dataArray,
                '_token': $('meta[name="csrf-token"]').attr('content')
            }
        };
        manual_form_submit(sub_options);
    }

    function manual_form_submit(options) {
        var $form = $("<form />");
        $form.attr("action", options.url);
        $form.attr("method", options.method);
        for (var data in options.data)
            $form.append('<input type="hidden" name="' + data + '" value="' + options.data[data] + '" />');
        $("body").append($form);
        $form.submit();
    }

        $('#data_table').DataTable({
            "dom": '<"row px-3"<"col-md-3 text-start"l><"col-md-5 text-start"f><"col-md-4 text-end"B>>rt<"ps-3"i><"pe-3"p>',
            "processing": false,
            "serverSide": false,
            "language": {
                searchPlaceholder: "Appl ID, Country"
            },
            "lengthMenu": [100, 200, 400],
            "buttons": [{
                    extend: 'excel',
                    text: '<i class="ri-file-excel-2-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Excel" ></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0,1]
                    }
                },
                {
                    extend: 'pdf',
                    text: '<i class="bi bi-file-earmark-pdf" data-toggle="tooltip" data-placement="top" title="Pdf"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0,1]
                    }
                },
                {
                    extend: 'print',
                    text: '<i class="bi bi-printer" data-toggle="tooltip" data-placement="top" title="Print"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0,1]
                    }
                },
                {
                    extend: 'copy',
                    text: '<i class="ri-file-copy-2-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Copy"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0,1]
                    }
                },
                {
                    extend: 'csv',
                    text: '<i class="ri-file-excel-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Csv"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0,1]
                    }
                },
            ]
        });
</script>
@endpush