@extends('backend.layouts.app')
@section('title', "Agent Profile")
@section('content')


<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    Profile
                </h4><br>
            </div>
            <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
                <button type="cancel" name="back" class="btn btn-primary btn-sm" value="Back" onclick="document.location ='{{ route('admin.agents.index') }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
            </div>
        </div>

        {{ html()->form('POST', route('admin.auth.agents.update.business-logo'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
            <div class="row">
                <input type="hidden" name="agent_id" value="{{$user->id}}">
                @if($agent_details->agent_panel_logo)
                <div class="col-sm-12 col-md-3">
                    <img src="{{ url('storage/'.$agent_details->agent_panel_logo) }}" alt="Portal Logo" style="height:70px;">    
                    @if($agent_details->logo_approved)
						<br><span class="text-success mt-3" title="" ><i class="fa fa-check"></i> Approved</span>
					@else
						<br><span class="text-danger mt-3" title=""><i class="fas fa-times"></i> Pending Approval</span>
					@endif
                </div>
                @endif
                <div class="col-sm-12 col-md-5">
                    <label class="col-form-label required-field">Upload Portal Logo</label>
                    <input type="file" class="form-control" name="agent_panel_logo" id="agent_panel_logo" required>
                    <span style="font-size:0.9em;">Allowed file types: png, jpg, gif, svg. File size must not exceed 500KB<br />
                        Image less than 400px width is preferred
                    </span>
                </div>
                <div class="col-sm-12 col-md-2 my-auto text-center">
                    <div class="form-group mb-0 clearfix">
                        {{ form_submit("Update") }}
                    </div>
                </div>
            </div>
        </form>

        <div class="row">
            <div class="form-group row">
                <div class="col-sm-12 col-md-8">
                    <label for="business_name" class="col-form-label">Business Name</label>
                    <div class="">
                        {{-- <input type="text" id="business_name" value="{{ $agent_details->business_name }}" class="form-control" name="business_name" placeholder="Business Name" value="{{ Request::old('business_name') }}" disabled> --}}
                        <span>{{ $agent_details->business_name }}</span>
                    </div>
                </div>
            </div>
        </div>

        <h5 class="mt-3" style="border-bottom: 1px solid black;">Your Details</h5>
        <div class="form-group row my-3">
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label">First Name</span></label>
                <div class="">
                    {{-- <input type="text" class="form-control" name="first_name" value="{{ $user->first_name }}" required disabled> --}}
                    <span>{{ $user->first_name }}</span>
                </div>
            </div>
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label">Last Name</label>
                <div class="">
                    {{-- <input type="text" class="form-control" name="last_name" value="{{ $user->last_name }}" required disabled> --}}
                    <span>{{ $user->last_name }}</span>
                </div>
            </div>
        </div>

        <div class="form-group row my-3">
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label" for="email">Email</label>
                <div class="">
                    {{-- <input type="text" class="form-control" id="email" name="email" value="{{ $user->email }}" required disabled> --}}
                    @if($user->email)
                    <span>{{ $user->email }}</span>
                    @else
                    <span>--</span>
                    @endif
                </div>
            </div>
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label">Mobile No.</label>
                {{-- <div class="input-group">
                    <div class="input-group-prepend" style="width: 35%"">
                        <select class="form-control" id="dialcode" name="dialcode" style="padding:0.49rem 2rem 0.375rem 0.75rem;" disabled>
                            <option value=''>Dialcode</option>
                            @foreach($dialcodes as $dialcode)
                            <option >{{$user->dialcode}}</option>
                            @endforeach
                        </select>
                    </div>
                    <input type="text" class="form-control" name="mobile" disabled value="{{ $user->mobile }}" minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}" maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}" required>
                </div> --}}
                <div class="">
                    @if($user->dialcode)
                        <span> + {{$user->dialcode}}   {{ $user->mobile }}</span>
                    @else
                        <span>{{ $user->mobile }}</span>
                    @endif
                </div>
            </div>

            <div class="col-sm-12 col-md-4">
                <!-- <label for="whatsapp_number" class="col-form-label">Whatsapp No.</label> -->
                {{-- <div class="input-group">
                    <div class="input-group-prepend" style="width: 35%"">
                        <select class="form-control" id="whatsapp_dialcode" disabled name="whatsapp_dialcode" style="padding:0.49rem 2rem 0.375rem 0.75rem;">
                            <option value=''>Dialcode</option>
                            @foreach($dialcodes as $dialcode)
                            <option >{{$user->whatsapp_dialcode}}</option>
                            @endforeach
                        </select>
                    </div>
                    <input type="text" placeholder="Whatsapp No." disabled id="whatsapp_number" minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}" maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}" class="form-control" name="whatsapp_number" value="@if(Request::old('whatsapp_number')){{ Request::old('whatsapp_number') }}@else{{ $user->whatsapp }}@endif">
                </div> --}}
                {{-- <div class="">
                    @if($user->whatsapp_dialcode && $user->whatsapp)
                        <span>{{$user->whatsapp_dialcode}} + {{ $user->whatsapp }}</span>
                    @elseif($user->whatsapp)
                        <span>{{ $user->whatsapp }}</span>
                    @else
                        <span>--</span>
                    @endif
                </div> --}}
            </div>
        </div>
        <div class="form-group row my-3 ">
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label">Country</label>
                {{-- <select class="form-control" id="country" disabled name="country" required>
                    @foreach ($country_list as $key => $value)
                    <option >{{ get_country_name($user->country)}}</option>
                    @endforeach
                </select> --}}
                <div class="">
                    @if($user->country)
                    <span>{{ get_country_name($user->country)}}</span>
                    @else
                    <span>--</span>
                    @endif
                </div>
            </div>
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label">State</label>
                {{-- <div class="form-group">
                    <select class="form-control " name="state" id="state-dd" disabled>
                        <option >{{ get_state_name($user->state)}}</option>
                    </select>
                </div> --}}
                <div class="">
                    @if($user->state)
                    <span>{{ get_state_name($user->state)}}</span>
                    @else
                    <span>--</span>
                    @endif
                </div>
            </div>
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label" for="city">City</label>
                {{-- <input type="text" placeholder="City" disabled value="@if(Request::old('city')){{ Request::old('city') }}@else{{ $user->city }}@endif" class="form-control" id="city" name="city"> --}}
                <div class="">
                    @if($user->city)
                    <span>{{$user->city}}</span>
                    @else
                    <span>--</span>
                    @endif
                </div>
            </div>
        </div>
        <div class="form-group row my-3 ">
            <div class="col-sm-12 col-md-8">
                <label for="address" class="col-form-label">Address</label>
                <div class="">
                    {{-- <input type="text" id="address" disabled class="form-control" name="address" value="{{ $user->address_1 }}"> --}}
                    @if($user->address_1)
                    <span>{{ $user->address_1 }}</span>
                    @else
                    <span>--</span>
                    @endif
                </div>
            </div>
        </div>
        {{-- <div class="row my-3">
            <div class="col-sm-12 col-md-8">
                <label for="agent_website_url" class="col-form-label">Website URL</label>
                <div class="">
                   
                    @if($agent_details->agent_website_url)
                    <a href="{{$agent_details->agent_website_url}}" class="text-primary" target="_blank">{{$agent_details->agent_website_url}}</a>
                    @else
                    <span>--</span>
                    @endif
                </div>
            </div>
        </div> --}}
        <div class="row my-3">
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label">Agent ID Proof</label>
                <div class="col-sm-12">
                    {{-- <input type="file" disabled class="form-control" name="agent_id_proof" id="agent_id_proof"> --}}
                    @if($agent_details->agent_id_proof)
                    <a class="small text-primary" href="<?php echo url('storage/' . $agent_details->agent_id_proof) ?>" target="_blank">ID Proof</a>
                    @else
                    <span>--</span>
                    @endif
                </div>
            </div>
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label">Business Incorporation Certificate/Proof</label>
                <div class="col-sm-12">
                    {{-- <input type="file" disabled class="form-control" name="buis_incor_certi_proof" id="buis_incor_certi_proof"> --}}
                    @if($agent_details->buis_incorpo_certi_proof)
                    <a class="small text-primary" href="<?php echo url('storage/' . $agent_details->buis_incorpo_certi_proof) ?>" target="_blank">Business Incorporation Certificate/Proof</a>
                    @else
                    <span>--</span>
                    @endif
                </div>
            </div>
        </div>
        <div class="form-group row my-3">
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label">Branch</label>
                {{-- <select class="form-control" id="branch" name="branch" disabled required>
                    @foreach($branch as $branches)
                    <option >{{branch_name($user->branch)}}</option>
                    @endforeach
                </select> --}}
                <div class="col-sm-12">
                    @if($user->branch)
                    <span>{{branch_name($user->branch)}}</span>
                    @else
                    <span>--</span>
                    @endif
                </div>
            </div>
        </div>

        {{-- <div class="form-group row">
            <div class="col-12">
                <div class="row">
                    <div class="col-sm-4">
                        <label class="col-form-label">Facebook (optional)</span></label>
                        <div class="">
                            <input type="text" placeholder="Facebook (optional)" class="form-control" name="facebook" value="{{$agent_details->facebook}}">
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <label class="col-form-label">Instagram (optional)</span></label>
                        <div class="">
                            <input type="text" placeholder="Instagram (optional)" class="form-control" name="instagram" value="{{$agent_details->instagram}}">
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12">
                <div class="row">
                    <div class="col-sm-4">
                        <label class="col-form-label">Twitter (optional)</span></label>
                        <div class="">
                            <input type="text" placeholder="Twitter (optional)" class="form-control" name="twitter" value="{{$agent_details->twitter}}">
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <label class="col-form-label">Others (optional)</span></label>
                        <div class="">
                            <input type="text" placeholder="Others (optional)" class="form-control" name="others" value="{{$agent_details->others}}">
                        </div>
                    </div>
                </div>
            </div>
        </div> --}}
    </div>
</div>
@endsection

@push('after-scripts')
<script>

// $('#country').on('change', function () {
//     var idCountry = this.value;
//     $("#state-dd").html('');
//     $.ajax({
//         url: "{{url('api/fetch-states')}}",
//         type: "POST",
//         data: {
//             country_id: idCountry,
//             _token: '{{csrf_token()}}'
//         },
//         dataType: 'json',
//         success: function (result) {
//             $('#state-dd').html('<option value="">Select State</option>');
//             $.each(result.states, function (key, value) {
//                if(value.id == "{{old('state')}}"){
//                 var selectedState = "selected=\"'selected'\"";
//                }
//                else{
//                 var selectedState = "";
//                }
//                 $("#state-dd").append('<option '+selectedState+' value="'+ value.id + '">' + value.name + '</option>');
//             });
//         }
//     });
// });

$('#country').trigger('change');

</script>
@endpush