@extends('backend.layouts.app')
@section('title', "Agents Referrals")

@section('content')
<div class="card">
    <div class="card-body" style="padding-left: 0px !important; padding-right: 0px !important;">
        <div class="row" style="padding-left: 20px !important; padding-right: 20px !important;">
            <div class="col-sm-8">
                <h4 class="card-title mb-0">
                    Agent Referral Students
                </h4>
            </div>
            <!--col-->
            <div class="col-sm-4 ">
            </div>
        </div>
        <!--row-->

        {{-- Filters --}}
        <div class="filterBox">
            <div class="row mt-4">
                <div class="col-sm-12 col-md-3">
                    <select class="form-select" name="agent" id="agent">
                        <option value="">Select Agent</option>
                        @foreach($agents as $agent)
                        <option {{($filters['agent'] == $agent->id)? 'selected' : ''}} value="{{$agent->id}}">{{$agent->first_name.' '.$agent->last_name}}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-sm-12 col-md-4">
                    <button onclick="javascript:searchTable();" class=" btn btn-primary btn-sm">Filter</button>
                    <button onclick="javascript:clearTable();" class=" btn btn-primary btn-sm">Clear</button>
                </div>
            </div>
        </div>

        <div class="row mt-4">
            <div class="col-12">
                <div class="table-responsive">
                    <table id="data_table" class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Student Name</th>
                                <th>Email</th>
                                <th>Mobile</th>
                                <th>Status</th>
                                <th>Added On</th>
                                <th>Agent</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('after-scripts')

<script>
    $(document).ready(function() {
        loadData();
    });

    function loadData(myleads) {
        $('#data_table').DataTable({
            "dom": '<"row px-3"<"col-md-2 text-start"l><"col-md-1"><"col-md-5"f><"col-md-4 text-end"B>>rt<"ps-3"i><"pe-3"p>',
            "processing": true,
            "serverSide": true,
            "language": {
                searchPlaceholder: "Name, Email, Mobile"
            },
            "lengthMenu": [10, 25, 50, 100],

            "ajax": {
                "url": "{{route('admin.agents.referralsdata')}}",
                "dataType": "json",
                "type": "post",
                data: {
                    '_token': $('meta[name="csrf-token"]').attr('content'),
                    'agent': $('#agent').val(),
                },

            },
            // "drawCallback": function( settings ) {
            //     addDeleteForms();
            // },
            "columns": [{
                    "data": "name"
                },
                {
                    "data": "email"
                },
                {
                    "data": "mobile"
                },
                {
                    "data": "status",
                    "orderable": false
                },                
                {
                    "data": "created_at"
                },
                {
                    "data": "agent"
                }
            ],
            'order': [
                [4, 'desc']
            ],
            "columnDefs": [{
                "orderable": false,
                "targets": -1
            }, ],
            "buttons": [{
                    extend: 'excel',
                    text: '<i class="ri-file-excel-2-line export-btn-size"  data-toggle="tooltip" data-placement="top" title="Excel"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5]
                    }
                },
                {
                    extend: 'pdf',
                    text: '<i class="bi bi-file-earmark-pdf" data-toggle="tooltip" data-placement="top" title="Pdf"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5]
                    }
                },
                {
                    extend: 'print',
                    text: '<i class="bi bi-printer" data-toggle="tooltip" data-placement="top" title="Print"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5]
                    }
                },
                {
                    extend: 'copy',
                    text: '<i class="ri-file-copy-2-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Copy"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5]
                    }
                },
                {
                    extend: 'csv',
                    text: '<i class="ri-file-excel-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Csv"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5]
                    }
                },
            ]
        });
    }

    function searchTable() {
        $("#data_table").dataTable().fnDestroy();
        loadData();
    }

    function clearTable() {
        $('#agent').val('');
        $("#data_table").dataTable().fnDestroy();
        loadData();
    }
</script>
@endpush