@extends('backend.layouts.app')

@section('title', "All Notifications")

@section('content')
        <div class="row">
             <div class="container-fluid">
                <div class="">
                    <!--content-header-->
                    <!-- <div class="content-header">
                        <h2>Notifications</h2>
                    </div> -->
                    <div class="card">

                        <div class="card-body">
                            <div class="col-sm-12 col-12">
                                <h4 class="card-title mb-0">
                                    All Notifications
                                    <button class="btn btn-sm btn-primary" style="float: right!important;" id="mark_all_read">Mark all as read</button>
                                </h4>
                                <hr>
                            </div>

                            <div class="notification-details">
                                <div class="people-list" id="people-list">

                                    <ul class="list">
                                        @if(count($notifications))
                                        @foreach($notifications as $noti)
                                            @if($noti->application_type=="visa")
                                                @php $app_url = 'admin.service-visa.view'; @endphp
                                            @elseif($noti->application_type=="university")
                                                @php $app_url = 'admin.applicationdetail'; @endphp
                                            @elseif($noti->application_type=="lead" || $noti->application_type=="student")
                                                @php $app_url = 'admin.auth.user.show'; @endphp
                                            @elseif($noti->application_type == "ticket")
                                                @php $app_url = 'admin.viewticket'; @endphp
                                            @elseif($noti->application_type == "agent")
                                                @php $app_url = 'admin.agents.agents-list'; @endphp
                                            @elseif($noti->application_type == "webinar")
                                                @php $app_url = 'admin.webinar.view'; @endphp
                                            @elseif($noti->application_type == "invoice")
                                                @php $app_url = 'admin.invoice.view-student-invoice'; @endphp
                                            @elseif($noti->application_type == "staff_leaves")
                                                @php $app_url = 'admin.staff-leaves'; @endphp
                                            @else
                                                @php $app_url = 'admin.dashboard'; @endphp
                                            @endif

                                        <a href="{{route($app_url, [$noti->application_id])}}" class="list-group-i" data-id="{{$noti->id}}" onClick="all_noti_seen($(this))">
                                        <li class="notification-box">
                                            <div class="staus-pic">
                                                @if($noti->application_type=="visa")
                                                <span class="notif-img"><img class="notification-icon" src="{{asset('assets/backend/img/visa.png')}}"></span>
                                                @elseif($noti->application_type=="university")
                                                <span class="notif-img"><img class="notification-icon" src="{{asset('assets/backend/img/mortarboard.png')}}"></span>
                                                @elseif($noti->application_type=="lead" || $noti->application_type=="student")
                                                <span class="notif-img"><img class="notification-icon" src="{{asset('assets/backend/img/userleads.png')}}"></span>
                                                @elseif($noti->application_type == "ticket")
                                                <span class="notif-img"><img class="notification-icon" src="{{asset('assets/backend/img/ticket.png')}}"></span>
                                                @elseif($noti->application_type == "agent")
                                                <span class="notif-img"><img class="notification-icon" src="{{asset('assets/backend/img/customer-service.png')}}"></span>
                                                @elseif($noti->application_type == "webinar")
                                                <span class="notif-img"><img class="notification-icon" src="{{asset('assets/backend/img/webinar.png')}}"></span>
                                                @elseif($noti->application_type == "invoice")
                                                <span class="notif-img"><img class="notification-icon" src="{{asset('assets/backend/img/invoice.png')}}"></span>
                                                @elseif($noti->application_type == "staff_leaves")
                                                <span class="notif-img"><img class="notification-icon" src="{{asset('assets/backend/img/leave.png')}}"></span>
                                                @endif
                                            </div>

                                            <div class="about">
                                                <div class="name {{($noti->read==0)? 'unseen' : ''}}">
                                                   <span class="all-time {{($noti->read==0)? 'unseen' : ''}}" style="float: right;"><i class="bi bi-clock" style="padding: 5px;"></i>{{\Carbon\Carbon::parse($noti->created_at)->diffForHumans()}}
                                                    <span class="dot d-none"></span>
                                                </div>
                                                <div class="subject {{($noti->read==0)? 'unseen' : 'seen'}}">
                                                    <span class="message">{!!$noti->message!!}</span>
                                                    <br />
                                                    </span><strong>{{get_user_full_name_by_id($noti->from_user)}}</strong>
                                                </div>
                                            </div>
                                        </li>
                                        </a>
                                        @endforeach
                                        @else
                                        <li class='text-center'><h6 class='text-center p-4'>No notifications found!</h6></li>
                                        @endif

                                    </ul>
                                    <div class="d-flex justify-content-center">
                                        {!! $notifications->links() !!}
                                    </div>
                                </div>
                            </div>
                            <!--card-->
                        </div>
                        <!--animated-->
                    </div>
                    <!--container-fluid-->
            <!--col-->
        </div>
        <!--row-->
    </div>
</div>
@endsection
@push ('after-scripts')
<script src="{{ asset('assets/plugins/sweetalert/sweetalert.min.js') }}"></script>
<script type="text/javascript">
    $(document).ready(function() {
        $(document).on('click', '#mark_all_read', function (e) {
         e.preventDefault();
            var user_id = "{{\Auth::user()->id}}";
            swal({
                    title: "Mark all as read?",
                    type: "warning",
                    confirmButtonClass: "btn-danger",
                    confirmButtonText: "Yes!",
                    showCancelButton: true,
                },
                function() {
                    window.location.href = "{{url('admin/mark-all-noti-seen/')}}/"+user_id;
            });
          
      });
});
</script>
@endpush
@push ('after-styles')
<link href="{{ asset('assets/plugins/sweetalert/sweetalert.css') }}" rel="stylesheet" type="text/css">
<style>
.about .unseen .dot{
  display: inline-block !important;
  height: 10px;
  width: 10px; 
  background-color: #4E93F4; 
  border-radius: 50%; 
  padding: 3px;
  margin-left: 5px;
}

.about .seen{
    color: #8d8d8d !important
}

</style>
@endpush