@extends('backend.layouts.app')

@section('title', "Analytics")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">

            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    Analytics
                </h4>
            </div>
            <!--col-->

            <div class="col-sm-7">
            </div>
            <!--col-->
        </div>
        <!--row-->
        <form class="" action="{{route('admin.analytics.applicationsreport')}}" method="get">
            @include('backend.analytics.report_filters')
        </form>

        <div class="row mt-4">
            <div class="col-sm-12 col-md-12">
                <div style="padding:50px;">
                    <h4>University Applications Created</h4>
                    <canvas id="applicationsCreatedChart"></canvas>
                    <br />
                    <br />
                    <br />
                    <h4>Admission Completed</h4>
                    <canvas id="applicationsCompletedChart"></canvas>
                    <br />
                    <br />
                    <br />
                </div>
            </div>
        </div>

    </div>
    <!--card-body-->
</div>
<!--card-->
@endsection

@push('after-scripts')
<script>
    const ctx = document.getElementById('applicationsCreatedChart');
    new Chart(ctx, {
        type: 'line',
        data: {
            labels: [{!!implode(",", $appls_created_labels)!!}],
            datasets: [{
                label: '# of applications created',
                data: [{!!implode(",", $appls_created_data)!!}],
                borderWidth: 2
            }]
        },
        options: {
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    const ctx2 = document.getElementById('applicationsCompletedChart');
    new Chart(ctx2, {
        type: 'line',
        data: {
            labels: [{!!implode(",", $appls_completed_labels)!!}],
            datasets: [{
                label: '# of applications completed',
                data: [{!!implode(",", $appls_completed_data)!!}],
                borderWidth: 2
            }]
        },
        options: {
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

</script>
@endpush