@extends('backend.layouts.app')

@section('title', "Analytics")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">

            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    Analytics
                </h4>
            </div>
            <!--col-->

            <div class="col-sm-7">
            </div>
            <!--col-->
        </div>
        <!--row-->
        <form class="" action="{{route('admin.analytics.applicationsreport')}}" method="get">
        @include('backend.analytics.report_filters')
        </form>

        @if($current_branch=="branch-wise")
        <div class="row mt-4">
            <div class="col-sm-12 col-md-6">
                <table class="table">
                    <th>
                        Branch
                    </th>
                    <th>
                        University Applications Created
                    </th>
                    <th>
                        Admission Completed
                    </th>
                    <th>
                        Completion %
                    </th>
                    @if(count($branches))
                    <?php
                    if($daterange!=''){
                        $daterange = $daterange;
                    }
                    else {
                        $daterange='';
                    }
                    ?>
                    @foreach($branches as $branch)
                    <tr>
                        <td><strong>{{$branch->branch_name}}</strong></td>
                        <td style="min-width:80px;">
                            {{get_appls_created($branch->id,$daterange)}}
                        </td>
                        <td style="min-width:80px;">
                            {{get_completed_admissions($branch->id,$daterange)}}
                        </td>
                        <td style="min-width:80px;">
                            {{get_appls_percentage($branch->id,$daterange)}}
                        </td>
                    </tr>
                    @endforeach
                    @else
                    <tr><td colspan="4" style="text-align: center;">No results found.</td></tr>
                    @endif
                </table>
            </div>
        </div>
    @elseif($subtype == "all_apps")
    <div class="row mt-4">
        <div class="col table-responsive">
            <table class="table display nowrap" cellspacing="0" id="eductrl-app-report-datatable" style="width:100%">
                    <thead>
                        <tr>
                        <th>ID</th>
                        <th>Student</th>
                        <th class="select_data">Country</th>
                        <th class="select_data">Status</th>
                        <th class="select_data">University</th>
                        <th class="select_data">Course</th>
                        <th class="select_data">Intake</th>
                        <th>Application Open Date</th>
                        <th>Application Close Date</th>
                        <th>Created</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($applications as $appl)
                        <tr>
                            <td>
                                <a href="{{route('admin.applicationdetail', [$appl->id])}}" title="Details" class="" style="font-size:13px;">{{$appl->appl_id}}</a>
                            </td>
                            <td><a target='_blank' href="{{route('admin.auth.user.show', $appl->userid)}}"><strong><span style='white-space:nowrap;'>{{$appl->first_name . ' ' . $appl->last_name}}</a>
                            </td>
                            <td>{{$appl->country}}</td>
                            <td>{{$appl->status}}</td>
                            <td>
                                {{$appl->university}}
                            </td>
                            <td>
                                {{$appl->course}}
                            </td>
                            <td>
                                {{get_intake_month_name($appl->intake)." ".$appl->year}}
                            </td>
                            <td>
                                {{get_date_formated($appl->application_open_date)}}
                            </td>
                            <td>
                                {{get_date_formated($appl->application_close_date)}}
                            </td>
                            <td>{{get_date_formated($appl->created_at)}}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        @else
        <div class="row mt-4">
            <div class="col-sm-12 col-md-6">
                <table class="table">
                    <tr>
                        <td>Applications Created</td>
                        <td style="min-width:80px;">{{$appls_created}}</td>
                    </tr>
                    <tr>
                        <td>Admission Completed</td>
                        <td>{{$appls_completed}}</td>
                    </tr>
                   <tr>
                        <td>Completion %</td>
                        <td>{{intval($appls_percent[0]->university_application_percent)}}%</td>
                    </tr>
                    

                </table>
            </div>
        </div>
        @endif
    </div>
    <!--card-body-->
</div>
<!--card-->
@endsection
@push('after-scripts')
<script>
    var table = $('#eductrl-app-report-datatable').DataTable({
                "dom": '<"row"<"col-md-3 text-start"l><"col-md-5 text-start"f><"col-md-4 text-end"B>>rtip',                
                "ordering": false,
                "lengthMenu": [100, 200, 500],
                "drawCallback": function( settings ) {
                    addDeleteForms();
                },
                initComplete: function () {
                    this.api().columns('.select_data').every( function () {
                        var column = this;
                        var colTitle = this.header().innerHTML;
                        var select = $('<select class="form-select" style="width:auto;"><option value="" selected>' + colTitle + '</option></select>')
                            .appendTo( $(column.header()).empty() )
                            .on( 'change', function () {
                                var val = $.fn.dataTable.util.escapeRegex(
                                    $(this).val()
                                );

                                column.search( val ? '^'+val+'$' : '', true, false ).draw();
                            } );

                        column.data().unique().sort().each( function ( d, j ) {
                            if(d !=''){
                                select.append( '<option value="'+d+'">'+d+'</option>' )
                            }
                        } );
                    } );
                },
                "buttons": [{
                    extend: 'excel',
                    text: '<i class="ri-file-excel-2-line export-btn-size" ></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: 
                    {
                    stripHtml: true,
                    }
                },
                {
                    extend: 'copy',
                    text: '<i class="ri-file-copy-2-line export-btn-size"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: 
                    {
                    stripHtml: true,
                    }
                },
                {
                    extend: 'csv',
                    text: '<i class="ri-file-excel-line export-btn-size"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: 
                    {
                    stripHtml: true,
                    }
                },
            ]
            });

var el_up = document.getElementById('GFG_UP');
if ($('#eductrl-app-report-datatable').attr("data-datatable-nopaging") == 1) {
    $('#eductrl-app-report-datatable').dataTable({
        "paging": false
    });
}
</script>
@endpush


