@extends('backend.layouts.app')

@section('title', "Analytics")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">

            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    Analytics
                </h4>
            </div>
            <!--col-->

            <div class="col-sm-7">
            </div>
            <!--col-->
        </div>
        <!--row-->
        <form class="" action="{{route('admin.analytics.leadsreport')}}" method="get">
            @include('backend.analytics.report_filters')
        </form>

        <div class="row mt-4">
            <div class="col-sm-12 col-md-12">
                <div style="padding:50px;">
                    <h4>Leads Created</h4>
                    <canvas id="leadsCreatedChart"></canvas>
                    <br />
                    <br />
                    <br />
                    <h4>Lead Follow-ups</h4>
                    <canvas id="leadsFollowupsChart"></canvas>
                    <br />
                    <br />
                    <br />
                    <h4>Lead Counselling</h4>
                    <canvas id="leadsCounsellingChart"></canvas>
                    <br />
                    <br />
                    <br />
                    <h4>Leads Converted</h4>
                    <canvas id="leadsConvertedChart"></canvas>

                </div>
            </div>
        </div>

    </div>
    <!--card-body-->
</div>
<!--card-->
@endsection

@push('after-scripts')
<script>
    const ctx = document.getElementById('leadsCreatedChart');
    new Chart(ctx, {
        type: 'line',
        data: {
            labels: [{!!implode(",", $leads_created_labels)!!}],
            datasets: [{
                label: '# of Leads',
                data: [{!!implode(",", $leads_created_data)!!}],
                borderWidth: 2
            }]
        },
        options: {
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    const ctx2 = document.getElementById('leadsFollowupsChart');
    new Chart(ctx2, {
        type: 'line',
        data: {
            labels: [{!!implode(",", $leads_followups_labels)!!}],
            datasets: [{
                label: '# of Follow-ups done',
                data: [{!!implode(",", $leads_followups_data)!!}],
                borderWidth: 2
            }]
        },
        options: {
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    const ctx3 = document.getElementById('leadsCounsellingChart');
    new Chart(ctx3, {
        type: 'line',
        data: {
            labels: [{!!implode(",", $leads_counselling_labels)!!}],
            datasets: [{
                label: '# of Counselling done',
                data: [{!!implode(",", $leads_counselling_data)!!}],
                borderWidth: 2
            }]
        },
        options: {
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });


    const ctx4 = document.getElementById('leadsConvertedChart');
    new Chart(ctx4, {
        type: 'line',
        data: {
            labels: [{!!implode(",", $leads_converted_labels)!!}],
            datasets: [{
                label: '# of Lead Conversion',
                data: [{!!implode(",", $leads_converted_data)!!}],
                borderWidth: 2
            }]
        },
        options: {
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

</script>
@endpush