@extends('backend.layouts.app')

@section('title', "Analytics")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">

            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    Analytics
                </h4>
            </div>
            <!--col-->

            <div class="col-sm-7">
            </div>
            <!--col-->
        </div>
        <!--row-->

        @include('backend.analytics.report_filters')

        <div class="row mt-4">
            <div class="col">
                <div id="graph_div"></div>
            </div>
        </div>

    </div>
    <!--card-body-->
</div>
<!--card-->
@endsection


@push ('after-scripts')

<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<script type="text/javascript">

    // Load the Visualization API and the corechart package.
    google.charts.load('current', {
        'packages': ['corechart', 'bar']
    });

    // Set a callback to run when the Google Visualization API is loaded.
    google.charts.setOnLoadCallback(drawChart);

    // Callback that creates and populates a data table,
    // instantiates the pie chart, passes in the data and
    // draws it.
    function drawChart() {

        // Create the data table.
        var data = new google.visualization.DataTable();
        data.addColumn('date', 'Date');
        data.addColumn('number', 'Leads');
        data.addRows({!!$data_js!!});

        // Set chart options
        var options = {
            title: 'Leads Received',
            height: 400,
            hAxis: {
                title: 'Date',
                format: 'd/M',
            },
            vAxis: {
                title: 'No. of Leads'
            }
        };

        // Instantiate and draw our chart, passing in some options.
        var chart = new google.visualization.ColumnChart(document.getElementById('graph_div'));
        chart.draw(data, options);
    }


    function showReport() {
        let url = '{{route('admin.analytics.leadsgraph')}}?';

        if($("#date_from").val()) {
            url = url + 'date_from=' + $("#date_from").val();
        }
        if($("#date_to").val()) {
            url = url + '&date_to=' + $("#date_to").val();
        }
        if($("#branch").val()) {
            url = url + '&branch=' + $("#branch").val();
        }
        window.location.replace(url);
    }

</script>
@endpush