@extends('backend.layouts.app')

@section('title', "Analytics")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">

            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    Analytics
                </h4>
            </div>
            <!--col-->

            <div class="col-sm-7">
            </div>
            <!--col-->
        </div>
        <!--row-->
        <form class="" action="{{route('admin.analytics.leadsreport')}}" method="get">
        @include('backend.analytics.report_filters')
        </form>

        @if($current_branch=="branch-wise")
        <div class="row mt-4">
            <div class="col-sm-12 col-md-6">
                <table class="table">
                    <th>
                        Branch
                    </th>
                    <th>
                        Leads Created
                    </th>
                    <th>
                        Leads Converted
                    </th>
                    <th>
                        No. of Follow-ups
                    </th>
                    @if(count($branches))
                    <?php
                    if($daterange!=''){
                        $daterange = $daterange;
                    }
                    else {
                        $daterange='';
                    }
                    ?>
                    @foreach($branches as $branch)
                    <tr>
                        <td><strong>{{$branch->branch_name}}</strong></td>
                        <td style="min-width:80px;">
                            {{get_leads_created($branch->id,$daterange)}}
                        </td>
                        <td style="min-width:80px;">
                            {{get_leads_converted($branch->id,$daterange)}}
                        </td>
                        <td style="min-width:80px;">
                            {{get_leads_followups_count($branch->id,$daterange)}}
                        </td>
                    </tr>
                    @endforeach
                    @else
                    <tr><td colspan="4" style="text-align: center;">No results found.</td></tr>
                    @endif
                </table>
            </div>
        </div>

        @elseif($subtype == "all_leads")

        <div class="row mt-4">
            <div class="col table-responsive">
                <table class="table display nowrap" cellspacing="0" id="eductrl-lead-report-datatable" style="width:100%">
                    <thead>
                        <tr>
                        <th>ID</th>
                        <th>Lead Name</th>
                        <th>Email</th>
                        <th>Mobile</th>
                        <th>Whatsapp</th>
                        <th>Alt. Contact</th>
                        <th class="select_data">Gender</th>
                        <th class="">DOB</th>
                        <th class="select_data">City</th>
                        <th class="select_data">State</th>
                        <th class="select_data">Country</th>
                        <th class="select_data">Study Level</th>
                        <th class="select_data">Country Interested to Study</th>
                        <th class="select_data">Course Interested to Study</th>
                        <th class="select_data">Intake Month</th>
                        <th class="select_data">Intake Year</th>
                        <th class="select_data">Qualification</th>
                        <th class="select_data">Passout Year</th>
                        <th class="select_data">Score/Grade</th>
                        <th class="select_data">Currently Studying Course</th>
                        <th class="select_data">Work Exp.</th>
                        <th class="select_data">IELTS</th>
                        <th class="select_data">TOEFL</th>
                        <th class="select_data">PTE</th>
                        <th class="select_data">GRE</th>
                        <th class="select_data">DUOLINGO</th>
                        <th class="select_data">Accommodation?</th>
                        <th class="select_data">Study Permit?</th>
                        <th class="select_data">Education Loan?</th>
                        <th class="select_data">Lead Source</th>
                        <th class="select_data">Source Details</th>
                        <th class="select_data">Campaign Name</th>
                        <th class="select_data">Lead Ad Name</th>
                        <th class="select_data">Lead Form Name</th>
                        <th class="select_data">Lead Lead ID</th>
                        <th class="">Lead Notes</th>
                        <th class="select_data">Branch</th>
                        <th class="select_data">Status</th>
                        <th class="select_data">Deleted?</th>
                        <th class="select_data">Assigned to</th>
                        <th class="">Next Followup</th>
                        <th class="">Lead Converted</th>
                        <th>Created</th>
                        @for($i=1; $i <= get_max_followups_count(); $i++ )
                            <th class="" style="display: none;">Followup {{$i}} Date</th>
                            <th class="" style="display: none;">Followup {{$i}}</th>
                        @endfor
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($leads as $lead)
                        <tr>
                            <td>{{$lead->id}}
                            </td>
                            <td>
                                <p class="mb-0"><strong><a target="_blank" href="{{route('admin.auth.user.show', $lead->id)}}">{{$lead->first_name . ' ' . $lead->last_name}}</a></strong></p>
                            </td>
                                <td>
                                @if($lead->email)
                                    {{$lead->email}}
                                @endif
                                </td>
                                <td>
                                @if ($lead->mobile)
                                    @if ($lead->dialcode != '')
                                        <?php $mob = '+' . $lead->dialcode . '-' . $lead->mobile;?>
                                    @else
                                        <?php $mob = $lead->mobile;?>
                                    @endif
                                    {{$mob}}
                                @else
                                --
                                @endif
                                </td>
                                <td>
                                @if ($lead->whatsapp) 
                                    @if ($lead->dialcode != '')
                                        <?php $whtsp = '+' . $lead->dialcode . '-' . $lead->whatsapp;?>
                                    @else
                                        <?php $whtsp = $lead->whatsapp;?>
                                    @endif
                                    {{$whtsp}}
                                @else
                                --
                                @endif
                                </td>
                                <td>
                                @if ($lead->alternate_contact) 
                                    <?php $alt_cntct = $lead->alternate_contact;?>
                                    {{$alt_cntct}}
                                @else
                                --
                                @endif
                                </td>
                                <td>{{$lead->gender}}</td>
                                <td>{{($lead->birthday) ? date('d-m-Y', strtotime($lead->birthday)): '--'}}</td>
                                <td>
                                    @if ($lead->city)
                                        {{get_city_name($lead->city)}}
                                    @else
                                    --
                                    @endif
                                </td>
                                <td>
                                    @if ($lead->state)
                                        {{get_state_name($lead->state)}}
                                    @else
                                    --
                                    @endif
                                </td>
                                <td>
                                    @if ($lead->country)
                                        {{get_country_name($lead->country)}}
                                    @else
                                    --
                                    @endif
                                </td>
                               
                                <td>{{($lead->overseas_study_level) ? $lead->overseas_study_level : '--'}}</td>
                                <td>{{($lead->country_interested)? $lead->country_interested : '--'}}</td>
                                <td>{{($lead->overseas_course_intersted) ? $lead->overseas_course_intersted : '--'}}</td>
                                <td>{{($lead->intake_month) ? date("F", mktime(0, 0, 0, $lead->intake_month, 10)) : '--'}}</td>
                                <td>{{($lead->intake_year) ? $lead->intake_year : '--'}}</td>
                                <td>{{($lead->highest_level_education)? $lead->highest_level_education : '--'}}</td>
                                <td>{{($lead->passout_year)? $lead->passout_year : '--'}}</td>
                                <td>{{($lead->qualification_score)? $lead->qualification_score : '--'}}</td>
                                <td>{{($lead->current_course)? $lead->current_course : '--'}}</td>
                                <td>{{($lead->work_experience)? $lead->work_experience : '--'}}</td>
                                <td>{{($lead->ielts)? $lead->ielts : '--'}}</td>
                                <td>{{($lead->toefl)? $lead->toefl : '--'}}</td>
                                <td>{{($lead->pte)? $lead->pte : '--'}}</td>
                                <td>{{($lead->gre)? $lead->gre : '--'}}</td>
                                <td>{{($lead->duolingo)? $lead->duolingo : '--'}}</td>
                                <td>{{($lead->accommodation)? "Yes" : '--'}}</td>
                                <td>{{($lead->study_permit)? "Yes" : '--'}}</td>
                                <td>{{($lead->education_loan)? "Yes" : '--'}}</td>
                                <td>{{($lead->lead_source)? $lead->lead_source : '--'}}</td>
                                <td>{{($lead->lead_source_detail)? $lead->lead_source_detail : '--'}}</td>
                                <td>{{($lead->lead_campaign_name)? $lead->lead_campaign_name : '--'}}</td>
                                <td>{{($lead->lead_ad_name)? $lead->lead_ad_name : '--'}}</td>
                                <td>{{($lead->lead_form_name)? $lead->lead_form_name : '--'}}</td>
                                <td>{{($lead->lead_lead_id)? $lead->lead_lead_id : '--'}}</td>
                                <td>{!!($lead->lead_notes)? $lead->lead_notes : '--'!!}</td>

                                <td>
                                    @if($lead->branch)
                                        {{branch_name($lead->branch)}}
                                    @endif
                                </td>
                            <td>{{$lead->lead_status}}
                                
                            </td>
                            <td>
                                @if($lead->trashed())
                                   Deleted
                                @endif
                            </td>
                            <td>{{$lead->assigned_to ? get_user_full_name_by_id($lead->assigned_to) : "--"}}</td>
                            <td>{{($lead->next_followup) ? date('d M Y, g:ia', strtotime($lead->next_followup)) : '--'}}</td>
                            {{-- <td>{{var_dump($lead->leadfollowups)}}</td> --}}
                            {{-- @foreach($lead->leadfollowups as $followups)
                            <td>{{$followups->created_at}} </td>
                            <td>{{$followups->detail}} </td>
                            @endforeach --}}
                            <td>{{($lead->lead_converted_date) ? date('d M Y, g:ia', strtotime($lead->lead_converted_date)) : '--'}}</td>
                            <td>{{date('d M Y, g:ia', strtotime($lead->created_at))}}</td>
                            {!!$lead->leadfollowups!!}
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        @else
        <div class="row mt-4">
            <div class="col-sm-12 col-md-6">
                <table class="table">
                    <tr>
                        <td>Leads Created</td>
                        <td style="min-width:80px;">{{$leads_created}}</td>
                    </tr>
                    <tr>
                        <td>Leads Converted</td>
                        <td>{{$leads_converted}}</td>
                    </tr>
                    <tr>
                        <td>No. of Follow-ups</td>
                        <td>{{$followups_count}}</td>
                    </tr>
                    <tr>
                        <td>No. of Counselling</td>
                        <td>{{$counselling_count}}</td>
                    </tr>
                    <!-- <tr>
                        <td>Time taken for first followup</td>
                        <td></td>
                    </tr> -->
                    <tr>
                        <td>Follow-ups/Counselling per Lead</td>
                        <td>{{$avg_followups}}</td>
                    </tr>

                    <!-- all time stats only, when no date filter -->
                    <!-- <tr>
                        <td>Conversion Percent</td>
                        <td></td>
                    </tr>                    
                    <tr>
                        <td>Average Time taken for Leads Conversion</td>
                        <td></td>
                    </tr>
                    <tr>
                        <td>New Leads to Counselling Status</td>
                        <td></td>
                    </tr>
                    <tr>
                        <td>Counselling to Converted Status</td>
                        <td></td>
                    </tr> -->
                    <!-- -->

                </table>
            </div>
        </div>
        @endif
    </div>
    <!--card-body-->
</div>
<!--card-->
@endsection
@push('after-scripts')
<script>
    var table = $('#eductrl-lead-report-datatable').DataTable({
                "dom": '<"row"<"col-md-3 text-start"l><"col-md-5 text-start"f><"col-md-4 text-end"B>>rtip',                
                "ordering": false,
                "lengthMenu": [100, 200, 500],
                "drawCallback": function( settings ) {
                    addDeleteForms();
                },
                initComplete: function () {
                    this.api().columns('.select_data').every( function () {
                        var column = this;
                        var colTitle = this.header().innerHTML;
                        var select = $('<select class="form-select" style="width:auto;"><option value="" selected>' + colTitle + '</option></select>')
                            .appendTo( $(column.header()).empty() )
                            .on( 'change', function () {
                                var val = $.fn.dataTable.util.escapeRegex(
                                    $(this).val()
                                );

                                column.search( val ? '^'+val+'$' : '', true, false ).draw();
                            } );

                        column.data().unique().sort().each( function ( d, j ) {
                            if(d !=''){
                                select.append( '<option value="'+d+'">'+d+'</option>' )
                            }
                        } );
                    } );
                },
                "buttons": [{
                    extend: 'excelHtml5',
                    text: '<i class="ri-file-excel-2-line export-btn-size" ></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: 
                    {
                    stripHtml: true,
                    format: {
                        header: function ( data, columnIdx ) {
                                if(columnIdx==6){
                                    return 'Gender';
                                }
                                else if(columnIdx==8){
                                    return 'City';
                                }
                                else if(columnIdx==9){
                                    return 'State';
                                }
                                else if(columnIdx==10){
                                    return 'Country';
                                }
                                else if(columnIdx==11){
                                    return 'Study Level';
                                }
                                else if(columnIdx==12){
                                    return 'Country Interested to Study';
                                }
                                else if(columnIdx==13){
                                    return 'Course Interested to Study';
                                }
                                else if(columnIdx==14){
                                    return 'Intake Month';
                                }
                                else if(columnIdx==15){
                                    return 'Intake Year';
                                }
                                else if(columnIdx==16){
                                    return 'Qualification';
                                }
                                else if(columnIdx==17){
                                    return 'Passout Year';
                                }
                                else if(columnIdx==18){
                                    return 'Score/Grade';
                                }
                                else if(columnIdx==19){
                                    return 'Currently Studying Course';
                                }
                                else if(columnIdx==20){
                                    return 'Work Exp.';
                                }
                                else if(columnIdx==21){
                                    return 'IELTS';
                                }
                                else if(columnIdx==22){
                                    return 'TOEFL';
                                }
                                else if(columnIdx==23){
                                    return 'PTE';
                                }
                                else if(columnIdx==24){
                                    return 'GRE';
                                }
                                else if(columnIdx==25){
                                    return 'DUOLINGO';
                                }
                                else if(columnIdx==26){
                                    return 'Accomodation?';
                                }
                                else if(columnIdx==27){
                                    return 'Study Permit?';
                                }
                                else if(columnIdx==28){
                                    return 'Education Loan?';
                                }
                                else if(columnIdx==29){
                                    return 'Lead Source';
                                }
                                else if(columnIdx==30){
                                    return 'Source Details';
                                }
                                else if(columnIdx==31){
                                    return 'Campaign Name';
                                }
                                else if(columnIdx==32){
                                    return 'Lead Ad Name';
                                }
                                else if(columnIdx==33){
                                    return 'Lead Form Name';
                                }
                                else if(columnIdx==34){
                                    return 'Lead Lead ID';
                                }
                                else if(columnIdx==36){
                                    return 'Branch';
                                }
                                else if(columnIdx==37){
                                    return 'Status';
                                }
                                else if(columnIdx==38){
                                    return 'Deleted?';
                                }
                                else if(columnIdx==39){
                                    return 'Assigned To';
                                }
                                else{
                                return data;
                                }
                            },
                            body: function ( data, column, row ) {
                                return (row > 43 ) ? data.replace( /<br\s*\/?>/ig, String.fromCharCode(10)) : data.replace(/(&nbsp;|<([^>]+)>)/ig, "");
                                return (row > 31 ) ? data.replace( /<br\s*\/?>/ig, String.fromCharCode(10)) : data.replace(/(&nbsp;|<([^>]+)>)/ig, "");
                            }
                        }
                    }
                },
                // {
                //     extend: 'pdf',
                //     text: '<i class="bi bi-file-earmark-pdf"></i>',
                //     className: 'btn btn-outline-secondary exportBtn',
                //     footer: false,
                //     header: true,
                //     exportOptions: 
                //     {
                //     stripHtml: true,
                //     }
                // },
                // {
                //     extend: 'print',
                //     text: '<i class="bi bi-printer"></i>',
                //     className: 'btn btn-outline-secondary exportBtn',
                //     footer: false,
                //     header: true,
                //     exportOptions: 
                //     {
                //     stripHtml: false,
                //     }
                // },
                {
                    extend: 'copy',
                    text: '<i class="ri-file-copy-2-line export-btn-size"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: 
                    {
                    stripHtml: true,
                    }
                },
                {
                    extend: 'csv',
                    text: '<i class="ri-file-excel-line export-btn-size"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: 
                    {
                    stripHtml: true,
                    }
                },
            ]
            });

var el_up = document.getElementById('GFG_UP');
if ($('#eductrl-lead-report-datatable').attr("data-datatable-nopaging") == 1) {
    $('#eductrl-lead-report-datatable').dataTable({
        "paging": false
    });
}
</script>
@endpush

