@extends('backend.layouts.app')

@section('title', "Analytics")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">

            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    Analytics
                </h4>
            </div>
            <!--col-->

            <div class="col-sm-7">
            </div>
            <!--col-->
        </div>
        <!--row-->

        @include('backend.analytics.report_filters')

        <div class="row mt-4">
            <div class="col">
                <div class="" style="height: 500px; overflow-y: scroll;">
                    <table class="table" id="data_table">
                        <thead>
                            <tr>
                                <th>First Name</th>
                                <th>Last Name</th>
                                <th>Email</th>
                                <th>Mobile</th>
                                <th>Alt. Contact</th>
                                <th>Status</th>
                                <th>Counselling Date</th>
                                <th>Gender</th>
                                <th>DOB</th>
                                <th>Location</th>
                                <th>Country of Citizenship</th>
                                <th>Lead Type</th>
                                <th>Current Course</th>
                                <th>Course Interested</th>
                                <!-- <th>Country Interested</th> -->
				<th>Branch</th>
                                <th>Study Level</th>
                                <th>Source</th>
                                <th>Source Details</th>
                                <th>Accommodation</th>
                                <th>Study Permit</th>
                                <th>Notes</th>
                                <th>Assigned To</th>
                                <th>Last Followup</th>
                                <th>Created At</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>

    </div>
    <!--card-body-->
</div>
<!--card-->
@endsection


@push ('after-scripts')

<script type="text/javascript">
    let datatable = '';
    $(document).ready(function() {
        loadData();
    });

    function showReport() {
        datatable.destroy();
        loadData();
    }

    function loadData() {
        datatable = $('#data_table').DataTable({
            "dom": '<"row"<"col-md-3 text-start"l><"col-md-5 text-start"f><"col-md-4 text-end"B>>rtip',
            processing: true,
            serverSide: true,
            "pageLength": 10,
            lengthMenu: [10, 25, 50, 100, 200, 500],
            scrollX: true,
            "searching": false,
            "ajax": {
                "url": "{{route('admin.analytics.leadsreportdata')}}",
                "dataType": "json",
                "type": "post",
                data: {
                    '_token': $('meta[name="csrf-token"]').attr('content'),
                    'report': $('#report').val(),
                    'date_from': $('#date_from').val(),
                    'date_to': $('#date_to').val(),
                },
            },
            order: [
                // [15, 'desc']
                [23, 'desc']
            ],
            columns: [{
                    data: 'first_name', 
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'last_name', 
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'email', 
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'mobile', 
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'alternate_contact', 
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'lead_status', 
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'counselling_date', 
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'gender', 
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'dob', 
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'location', 
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'country_of_citizenship', 
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'student_type', 
                    {{-- data: 'lead_type',  --}}
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'current_course', 
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'course_interested', 
                    orderable: false,
                    searchable: false
                },
                // {
                //     data: 'country_interested',
                //     orderable: false,
                //     searchable: false
                // },
                // Gourav
                {
                    data: 'branch', 
                    orderable: false,
                    searchable: false
                },
                {
                    {{-- data: 'study_level',  --}}
                    data: 'overseas_study_level', 
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'lead_source', 
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'source_details', 
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'accommodation', 
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'study_permit', 
                    orderable: false,
                    searchable: false
                },
                
                {
                    {{-- data: 'notes',  --}}
                    data: 'lead_notes', 
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'assigned_to', 
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'last_followup', 
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'created_at', 
                    orderable: false,
                    searchable: false
                },

            ],
            "buttons": [{
                    extend: 'excel',
                    text: '<i class="ri-file-excel-2-line export-btn-size" ></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                },
                {
                    extend: 'pdf',
                    text: '<i class="bi bi-file-earmark-pdf"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    orientation: 'landscape',
                    pageSize: 'A3',
                },
                {
                    extend: 'print',
                    text: '<i class="bi bi-printer"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                },
                {
                    extend: 'copy',
                    text: '<i class="ri-file-copy-2-line export-btn-size"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                },
                {
                    extend: 'csv',
                    text: '<i class="ri-file-excel-line export-btn-size"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                },
            ]
        });
    }
</script>
@endpush