@extends('backend.layouts.app')

@section('title', "Analytics")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">

            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    Analytics
                </h4>
            </div>
            <!--col-->

            <div class="col-sm-7">
            </div>
            <!--col-->
        </div>
        <!--row-->
        <form class="" action="{{route('admin.analytics.leadsreport')}}" method="get">
        @include('backend.analytics.report_filters')
        </form>

        @if($subtype == "converted_staff_wise")
            <div class="row mt-4">
                <div class="col-sm-12 col-md-6">
                    <table class="table">
                        <th>Staff</th>
                        <th>No. of leads converted</th>
                        @if(count($converted_staff_wise))
                        @foreach($converted_staff_wise as $staff_converted)
                        <tr>
                            <td><strong>{{$staff_converted->first_name}} {{$staff_converted->last_name}}</strong><br />{{$staff_converted->email}}</td>
                            <td style="min-width:80px;">{{$staff_converted->cnt}}</td>
                        </tr>
                        @endforeach
                        @else
                        <tr><td colspan="2">No results found.</td></tr>
                        @endif
                    </table>
                </div>
            </div>
        @else
        <div class="row mt-4">
            <div class="col-sm-12 col-md-6">
                <table class="table">
                    <th>Staff</th>
                    <th>Lead Count</th>
                    @if(count($staff_leads))
                    @foreach($staff_leads as $staff)
                    <tr>
                        <td><strong>{{$staff->first_name}} {{$staff->last_name}}</strong><br />{{$staff->email}}</td>
                        <td style="min-width:80px;">{{$staff->cnt}}</td>
                    </tr>
                    @endforeach
                    @else
                    <tr><td colspan="2">No results found.</td></tr>
                    @endif
                </table>
            </div>
        </div>
        @endif

    </div>
    <!--card-body-->
</div>
<!--card-->
@endsection

