@extends('backend.layouts.app')

@section('title', "Analytics")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">

            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    Analytics
                </h4>
            </div>
            <!--col-->

            <div class="col-sm-7">
            </div>
            <!--col-->
        </div>
        <!--row-->
        <form class="" action="{{route('admin.analytics.leadsreport')}}" method="get">
        @include('backend.analytics.report_filters')
        </form>
        @if($current_branch=="branch-wise")
            <div class="row mt-4">
                <div class="col-sm-12 col-md-6">
                    <table class="table">
                        <th>
                            Branch
                        </th>
                        @foreach($lead_status as $status)
                        <th>
                            {{$status->status}}
                        </th>
                        @endforeach
                        @if(count($branches))
                        <?php
                        if($daterange!=''){
                            $daterange = $daterange;
                        }
                        else {
                            $daterange='';
                        }
                        ?>
                        @foreach($branches as $branch)
                        <tr>
                            <td><strong>{{$branch->branch_name}}</strong></td>
                            @foreach($lead_status as $status)
                            <td>
                                {{get_leads_by_status_count($branch->id,$status->status,$daterange)}}
                            </td>
                        @endforeach
                        </tr>
                        @endforeach
                        @else
                        <tr><td colspan="4" style="text-align: center;">No results found.</td></tr>
                        @endif
                    </table>
                </div>
            </div>
        @else
        <div class="row mt-4">
            <div class="col-sm-12 col-md-6">
                <table class="table">
                    @foreach($lead_status_stats as $status => $count)
                    <tr>
                        <td>{{$status}}</td>
                        <td style="min-width:80px;">{{$count}}</td>
                    </tr>
                    @endforeach
                </table>
            </div>
        </div>
        @endif

    </div>
    <!--card-body-->
</div>
<!--card-->
@endsection

